import type { AlertButton, AlertOptions } from '@ionic/core/components';
import type { HookOverlayOptions } from './HookOverlayOptions';
/**
 * A hook for presenting/dismissing an IonAlert component
 * @returns Returns the present and dismiss methods in an array
 */
export declare function useIonAlert(): UseIonAlertResult;
export type UseIonAlertResult = [
    {
        /**
         * Presents the alert
         * @param message The main message to be displayed in the alert
         * @param buttons Optional - Array of buttons to be added to the alert
         */
        (message: string, buttons?: AlertButton[]): Promise<void>;
        /**
         * Presents the alert
         * @param options The options to pass to the IonAlert
         */
        (options: AlertOptions & HookOverlayOptions): Promise<void>;
    },
    /**
     * Dismisses the alert
     */
    () => Promise<void>
];
