/*
 *     This file is a part of LittleRelay (https://www.github.com/UmerCodez/LittleRelay)
 *     Copyright (C) 2026 Umer Farooq (umerfarooq2383@gmail.com)
 *
 *     LittleRelay is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     LittleRelay is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with LittleRelay. If not, see <https://www.gnu.org/licenses/>.
 *
 */
package app.umerfarooq.littlerelay.ui.screens.deviceservices

import app.umerfarooq.littlerelay.domain.model.BleCharacteristic
import app.umerfarooq.littlerelay.domain.model.BleDevice

data class DeviceServicesScreenState(
    val currentDevice: BleDevice? = null,
    val selectedNotifiableCharacteristics: Set<BleCharacteristic> = emptySet(),
    val selectedWriteableCharacteristics: Set<BleCharacteristic> = emptySet(),
    val isAnyNotifiableCharacteristicSelected: Boolean = false,
    val hasNotifiableCharacteristic: Boolean = false,
    val hasWriteableCharacteristic: Boolean = false,
    val isAnyWriteableCharacteristicSelected: Boolean = false
)