package app.simple.inure.util

import android.Manifest
import android.app.AppOpsManager
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.os.Environment
import android.os.Process
import androidx.core.app.AppOpsManagerCompat
import androidx.core.content.ContextCompat

object PermissionUtils {
    fun Context.areStoragePermissionsGranted(): Boolean {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            Environment.isExternalStorageManager()
        } else {
            (ContextCompat.checkSelfPermission(this, Manifest.permission.READ_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED &&
                    ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED)
        }
    }

    fun Context.checkForUsageAccessPermission(): Boolean {
        val appOps = getSystemService(Context.APP_OPS_SERVICE) as AppOpsManager
        val mode = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            @Suppress("DEPRECATION")
            appOps.unsafeCheckOpNoThrow(AppOpsManager.OPSTR_GET_USAGE_STATS, Process.myUid(), packageName)
        } else {
            appOps.checkOpNoThrow(AppOpsManager.OPSTR_GET_USAGE_STATS, Process.myUid(), packageName)
        }

        return mode == AppOpsManagerCompat.MODE_ALLOWED
    }

    fun Context.checkStoragePermission(): Boolean {
        return areStoragePermissionsGranted()
    }

    fun Context.checkRequiredPermissions(): Boolean {
        return checkForUsageAccessPermission() && checkStoragePermission()
    }

    fun hasPermission(context: Context?, permissionName: String?): Boolean {
        return ContextCompat.checkSelfPermission(context!!, permissionName!!) == PackageManager.PERMISSION_GRANTED
    }
}