## Features of Inure App Manager
List of all the features available in Inure at the moment.

**Note:** I'll try best to list all core features to give a general idea of the capabilities
of the app. This is not a complete features list but rather the core ones, **it's recommended to run the app and explore all the possible options by yourself.**

### Normal Features
These features are available to all users without any extra requirements.

- Ability to view all the apps both system and user.
- View usage stats of apps up to a year and detailed usage stats for up to two weeks.
- Built-in Terminal emulator wih complete customization.
- Analytics graph or all apps.
- Create and manage notes for your apps with a powerful notes editor built-in.
- Assign tags to your apps and organize them in a group.
- Save your terminal commands in the app for one tap execution in Terminal.
- Scan directories for apk files and show them all at one place to easily manage all your apk files.
- Built-in crash report framework.
- Pin your favourite apps in home panel.
- View internal components such as permissions, services, activities etc of all apps.
- Get detailed app information.
- View resources of any app in a properly highlighted code viewer.
- Scan for trackers in any app.
- Decompile dex classes of any at runtime and view their code.
- Launch, send, uninstall, any user app.
- Extract the apk or open them in app stores of your choice.
- Deep search mode to search for internal components in all apps.
- Built-in package installer to install apk and split apk files.
- View information of any app even not installed ones.
- View licenses of FOSS apps and update licenses manually if needed.
- Dedicated indicator for FOSS apps throughout the app.
- Identify Xposed modules in app info and package installer.
- Create and manage Batch profiles for multiple apps.
- Create activity shortcuts of any app.
- Upload and scan apk files to VirusTotal and view the results. (Requires API key and limited to
  Github builds only)

### Root Features
These features require root access to work in the app.

- Uninstall, disable, close any app
- Manage individual components of any app and enable/disable them on the fly.
- Per app battery optimization configuration.
- Component level boot manager to block boot components.
- Force trigger launch for any component.
- Reinstall apps on the go.
- Clear data and cache of any app.
- Block app trackers using IFW method.
- View and modify shared preferences of any app.
- Run installer in root mode to seamlessly install apps.
- Run Terminal in root mode.
- Change **AppOps** permissions of any app.

### Shizuku Features

Features available for Shizuku users.

- Manage battery optimization configuration for various apps.
- Uninstall, disable, close any app.
- Reinstall apps on the go.
- Clear data and cache of any app.
- Run installer in Shizuku mode to seamlessly install apps.
- Run terminal in Shizuku mode.

### Installer Features

Features supported by built-in app installer

- Bypass the low target sdk restrictions for both Android 14 and Android 15.
  - When you see an error like this in the app `INSTALL_FAILED_DEPRECATED_SDK_VERSION: App package must target at least SDK version 24, but found 7`
- All split apk format support.
- Get all information in the Installer at one place, including what has changed in the new apk, trackers and many othe info.
- Signature check before installation to see if signature matches with the exisitng one.
- Block trackers from Installer page
- Separate framework for Root, Shizuku and Session based installer.

### UI Features

UI feature of Inure that makes it stand out.

- Fresh and modern interface design with customizable fluid motion animations.
- Customize app with various font styles and accent colors.
- Various dark and light mode themes.
- Adjust corner radius to remove or add rounded corners to all UI elements in the app.
- Glowing icon effects to give a pleasant look to all the app icons.
- Adjust icon size of all apps in the app.
- Ability to disable animations in the app completely or customize them to your liking.
- Various accessibility feature to add retro touch in the app if you're used to legacy layouts and
  ease of access for various users.
- Dynamic interface to support all screen sizes and aspect ratios.
- Customizable home panel with various options to choose from.
- Supports seamless operations using keyboard and mouse.

### Bonus Features

Features that are added for convenience

- Music library browser to browse all your music files in one place.
- Audio player with streaming support.
- LRC file support for audio player.
- Play video files as audio.
- Image Viewer with SVG and GIF support
- TTF viewer
- Text Viewer and Editor

### How does GitHub builds differ from Play builds?
GitHub builds don't have play policies constraints and therefore allows more room for including features
that are not possible to have in play builds. Here are the list of feature exclusive to GitHub builds only.

- Debloat
- Bloat indicator for bloat apps throughout the app
- Activate using license key without unlocker
- VirusTotal integration
- More store options
