# Contribution Guidelines

Here are some guidelines to help you get started with contributing to Inure.:

## How to Contribute

- Fork the repo and let the initial setup finish.
- Create a new branch for your feature or bug fix.
- Make your changes, ensuring that your code adheres to the project's coding standards (see *
  *Guidelines**).
- Write tests for your changes to ensure they work as expected. If no tests are included, mention
  how the changes can be tested.
- Submit a pull request with a clear description of your changes.
- Engage in the code review process and make any requested changes.
- Wait for your pull request to be reviewed and merged.

## Guidelines

- First and foremost, open an issue to discuss your proposed changes before starting work on them.
- Ensure your code is well-documented and follows the existing style.
- Make sure you understand Inure's architecture and design principles before making significant
  changes.
- Test your changes thoroughly to avoid introducing new bugs.
- Make sure to include all changed files in your pull request.
- Be respectful and considerate in all interactions with the community.
- Do not submit AI generated code. If you use AI tools to assist you, please keep the changes
  minimal and clearly indicate which parts were generated by AI.
- Do not submit plagiarized code. Ensure that all code you contribute is your own or properly
  attributed.

## Reporting Issues

If you encounter any bugs or have feature requests, please go
here: https://github.com/Hamza417/Inure/issues/new/choose

---

Thank you for contributing to Inure!
