import React, { useMemo, useContext, useRef, useState, useCallback, useEffect } from 'react';
import { Animated, PanResponder, View, Easing, FlatList } from 'react-native';

function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}
function _objectWithoutPropertiesLoose(r, e) {
  if (null == r) return {};
  var t = {};
  for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
    if (e.includes(n)) continue;
    t[n] = r[n];
  }
  return t;
}

// A type of promise-like that resolves synchronously and supports only one observer

const _iteratorSymbol = /*#__PURE__*/ typeof Symbol !== "undefined" ? (Symbol.iterator || (Symbol.iterator = Symbol("Symbol.iterator"))) : "@@iterator";

const _asyncIteratorSymbol = /*#__PURE__*/ typeof Symbol !== "undefined" ? (Symbol.asyncIterator || (Symbol.asyncIterator = Symbol("Symbol.asyncIterator"))) : "@@asyncIterator";

// Asynchronously await a promise and pass the result to a finally continuation
function _finallyRethrows(body, finalizer) {
	try {
		var result = body();
	} catch (e) {
		return finalizer(true, e);
	}
	if (result && result.then) {
		return result.then(finalizer.bind(null, false), finalizer.bind(null, true));
	}
	return finalizer(false, result);
}

var DragListContext = React.createContext(undefined);
function DragListProvider(_ref) {
  var activeKey = _ref.activeKey,
    activeIndex = _ref.activeIndex,
    keyExtractor = _ref.keyExtractor,
    pan = _ref.pan,
    panIndex = _ref.panIndex,
    layouts = _ref.layouts,
    horizontal = _ref.horizontal,
    children = _ref.children;
  var value = useMemo(function () {
    return {
      activeKey: activeKey,
      activeIndex: activeIndex,
      keyExtractor: keyExtractor,
      pan: pan,
      panIndex: panIndex,
      layouts: layouts,
      horizontal: horizontal
    };
  }, [activeKey, activeIndex, keyExtractor, pan, panIndex, layouts, horizontal]);
  return React.createElement(DragListContext.Provider, {
    value: value
  }, children);
}
function useDragListContext() {
  var value = useContext(DragListContext);
  if (!value) {
    throw new Error("useDragListContext must be called within DragListProvider");
  }
  return value;
}

var _excluded = ["containerStyle", "data", "keyExtractor", "onDragBegin", "onDragEnd", "onScroll", "onLayout", "renderItem", "CustomFlatList"],
  _excluded2 = ["item", "index", "children", "style", "onLayout"];
function DragListImpl(props, _ref) {
  var containerStyle = props.containerStyle,
    data = props.data,
    keyExtractor = props.keyExtractor,
    onDragBegin = props.onDragBegin,
    onDragEnd = props.onDragEnd,
    onScroll = props.onScroll,
    onLayout = props.onLayout,
    _props$CustomFlatList = props.CustomFlatList,
    CustomFlatList = _props$CustomFlatList === void 0 ? FlatList : _props$CustomFlatList,
    rest = _objectWithoutPropertiesLoose(props, _excluded);
  var activeKey = useRef(null);
  var activeIndex = useRef(-1);
  var reorderingRef = useRef(false);
  var panIndex = useRef(-1);
  var _useState = useState({
      activeKey: activeKey.current,
      panIndex: -1
    }),
    extra = _useState[0],
    setExtra = _useState[1];
  var layouts = useRef({}).current;
  var dataRef = useRef(data);
  var panGrantedRef = useRef(false);
  var grantScrollPosRef = useRef(0);
  var grantActiveCenterOffsetRef = useRef(0);
  var flatWrapRefPosUpdatedRef = useRef(false);
  var autoScrollTimerRef = useRef(null);
  var hoverRef = useRef(props.onHoverChanged);
  var reorderRef = useRef(props.onReordered);
  var flatRef = useRef(null);
  var flatWrapRef = useRef(null);
  var flatWrapLayout = useRef({
    pos: 0,
    extent: 1
  });
  var scrollPos = useRef(0);
  var pan = useRef(new Animated.Value(0)).current;
  var panResponder = useRef(PanResponder.create({
    onStartShouldSetPanResponderCapture: function onStartShouldSetPanResponderCapture() {
      return !!activeKey.current && !reorderingRef.current;
    },
    onStartShouldSetPanResponder: function onStartShouldSetPanResponder() {
      return !!activeKey.current && !reorderingRef.current;
    },
    onMoveShouldSetPanResponder: function onMoveShouldSetPanResponder() {
      return !!activeKey.current && !reorderingRef.current;
    },
    onMoveShouldSetPanResponderCapture: function onMoveShouldSetPanResponderCapture() {
      return !!activeKey.current && !reorderingRef.current;
    },
    onPanResponderGrant: function onPanResponderGrant(_, gestate) {
      var _flatWrapRef$current;
      grantScrollPosRef.current = scrollPos.current;
      pan.setValue(0);
      panGrantedRef.current = true;
      flatWrapRefPosUpdatedRef.current = false;
      (_flatWrapRef$current = flatWrapRef.current) === null || _flatWrapRef$current === void 0 ? void 0 : _flatWrapRef$current.measure(function (_x, _y, _width, _height, pageX, pageY) {
        flatWrapLayout.current = _extends({}, flatWrapLayout.current, {
          pos: props.horizontal ? pageX : pageY
        });
        if (activeKey.current && layouts.hasOwnProperty(activeKey.current)) {
          var itemLayout = layouts[activeKey.current];
          var screenPos = props.horizontal ? gestate.x0 : gestate.y0;
          var clientViewPos = screenPos - flatWrapLayout.current.pos;
          var clientPos = clientViewPos + scrollPos.current;
          var posOnActiveItem = clientPos - itemLayout.pos;
          grantActiveCenterOffsetRef.current = itemLayout.extent / 2 - posOnActiveItem;
        } else {
          grantActiveCenterOffsetRef.current = 0;
        }
        flatWrapRefPosUpdatedRef.current = true;
      });
      onDragBegin === null || onDragBegin === void 0 ? void 0 : onDragBegin();
    },
    onPanResponderMove: function onPanResponderMove(_, gestate) {
      if (autoScrollTimerRef.current) {
        clearInterval(autoScrollTimerRef.current);
        autoScrollTimerRef.current = null;
      }
      if (!flatWrapRefPosUpdatedRef.current || !activeKey.current || !layouts.hasOwnProperty(activeKey.current)) {
        return;
      }
      var posOrigin = props.horizontal ? gestate.x0 : gestate.y0;
      var pos = props.horizontal ? gestate.dx : gestate.dy;
      var wrapPos = posOrigin + pos - flatWrapLayout.current.pos;
      function updateRendering() {
        var movedAmount = props.horizontal ? gestate.dx : gestate.dy;
        var panAmount = scrollPos.current - grantScrollPosRef.current + movedAmount;
        Animated.timing(pan, {
          duration: 0,
          easing: Easing.inOut(Easing.linear),
          toValue: panAmount,
          useNativeDriver: true
        }).start();
        var clientPos = wrapPos + scrollPos.current;
        var curIndex = 0;
        var key;
        while (curIndex < dataRef.current.length && layouts.hasOwnProperty(key = keyExtractor(dataRef.current[curIndex], curIndex)) && layouts[key].pos + layouts[key].extent < clientPos + grantActiveCenterOffsetRef.current) {
          curIndex++;
        }
        if (panIndex.current != curIndex) {
          var _hoverRef$current;
          setExtra(_extends({}, extra, {
            panIndex: curIndex
          }));
          (_hoverRef$current = hoverRef.current) === null || _hoverRef$current === void 0 ? void 0 : _hoverRef$current.call(hoverRef, curIndex);
          panIndex.current = curIndex;
        }
      }
      var dragItemExtent = layouts[activeKey.current].extent;
      var leadingEdge = wrapPos - dragItemExtent / 2;
      var trailingEdge = wrapPos + dragItemExtent / 2;
      var offset = 0;
      if (leadingEdge < 0) {
        offset = -dragItemExtent;
      } else if (trailingEdge > flatWrapLayout.current.extent) {
        offset = dragItemExtent;
      }
      if (offset !== 0) {
        var scrollOnce = function scrollOnce(distance) {
          var _flatRef$current;
          (_flatRef$current = flatRef.current) === null || _flatRef$current === void 0 ? void 0 : _flatRef$current.scrollToOffset({
            animated: true,
            offset: Math.max(0, scrollPos.current + distance)
          });
          updateRendering();
        };
        scrollOnce(offset);
        autoScrollTimerRef.current = setInterval(function () {
          scrollOnce(offset);
        }, AUTO_SCROLL_MILLIS);
      } else {
        updateRendering();
      }
    },
    onPanResponderRelease: function (_, _gestate) {
      try {
        var _temp3 = function _temp3() {
          reset();
        };
        if (autoScrollTimerRef.current) {
          clearInterval(autoScrollTimerRef.current);
          autoScrollTimerRef.current = null;
        }
        onDragEnd === null || onDragEnd === void 0 ? void 0 : onDragEnd();
        var _temp2 = function () {
          if (activeIndex.current !== panIndex.current && !(activeIndex.current === dataRef.current.length - 1 && panIndex.current > activeIndex.current)) {
            var _temp = _finallyRethrows(function () {
              var _reorderRef$current;
              reorderingRef.current = true;
              return Promise.resolve((_reorderRef$current = reorderRef.current) === null || _reorderRef$current === void 0 ? void 0 : _reorderRef$current.call(reorderRef, activeIndex.current, panIndex.current)).then(function () {});
            }, function (_wasThrown, _result) {
              reorderingRef.current = false;
              if (_wasThrown) throw _result;
              return _result;
            });
            if (_temp && _temp.then) return _temp.then(function () {});
          }
        }();
        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(_temp3) : _temp3(_temp2));
      } catch (e) {
        return Promise.reject(e);
      }
    }
  })).current;
  var reset = useCallback(function () {
    activeIndex.current = -1;
    activeKey.current = null;
    panIndex.current = -1;
    setExtra({
      activeKey: null,
      panIndex: -1
    });
    pan.setValue(0);
    panGrantedRef.current = false;
    grantActiveCenterOffsetRef.current = 0;
    if (autoScrollTimerRef.current) {
      clearInterval(autoScrollTimerRef.current);
      autoScrollTimerRef.current = null;
    }
  }, []);
  useEffect(function () {
    dataRef.current = data;
  }, [data]);
  useEffect(function () {
    reorderRef.current = props.onReordered;
  }, [props.onReordered]);
  var renderDragItem = useCallback(function (info) {
    var key = keyExtractor(info.item, info.index);
    var isActive = key === activeKey.current;
    var onDragStart = function onDragStart() {
      if (data.length > 1) {
        activeIndex.current = info.index;
        activeKey.current = key;
        panIndex.current = activeIndex.current;
        setExtra({
          activeKey: key,
          panIndex: info.index
        });
      }
    };
    var onDragEnd = function onDragEnd() {
      if (activeKey.current !== null && !panGrantedRef.current) {
        reset();
      }
    };
    return props.renderItem(_extends({}, info, {
      onDragStart: onDragStart,
      onStartDrag: onDragStart,
      onDragEnd: onDragEnd,
      onEndDrag: onDragEnd,
      isActive: isActive
    }));
  }, [props.renderItem, data.length]);
  var onDragScroll = useCallback(function (event) {
    scrollPos.current = props.horizontal ? event.nativeEvent.contentOffset.x : event.nativeEvent.contentOffset.y;
    if (onScroll) {
      onScroll(event);
    }
  }, [onScroll]);
  var onDragLayout = useCallback(function (evt) {
    var _flatWrapRef$current2;
    (_flatWrapRef$current2 = flatWrapRef.current) === null || _flatWrapRef$current2 === void 0 ? void 0 : _flatWrapRef$current2.measure(function (_x, _y, width, height, pageX, pageY) {
      flatWrapLayout.current = props.horizontal ? {
        pos: pageX,
        extent: width
      } : {
        pos: pageY,
        extent: height
      };
    });
    if (onLayout) {
      onLayout(evt);
    }
  }, [onLayout]);
  return React.createElement(DragListProvider, {
    activeKey: activeKey.current,
    activeIndex: activeIndex.current,
    keyExtractor: keyExtractor,
    pan: pan,
    panIndex: panIndex.current,
    layouts: layouts,
    horizontal: props.horizontal
  }, React.createElement(View, Object.assign({
    ref: flatWrapRef,
    style: containerStyle
  }, panResponder.panHandlers, {
    onLayout: onDragLayout
  }), React.createElement(CustomFlatList, Object.assign({
    ref: function ref(r) {
      flatRef.current = r;
      if (!!_ref) {
        if (typeof _ref === "function") {
          _ref(r);
        } else {
          _ref.current = r;
        }
      }
    },
    keyExtractor: keyExtractor,
    data: data,
    renderItem: renderDragItem,
    CellRendererComponent: CellRendererComponent,
    extraData: extra,
    scrollEnabled: !activeKey.current,
    onScroll: onDragScroll,
    scrollEventThrottle: 16,
    removeClippedSubviews: false
  }, rest))));
}
var SLIDE_MILLIS = 200;
var AUTO_SCROLL_MILLIS = 200;
function CellRendererComponent(props) {
  var item = props.item,
    index = props.index,
    children = props.children,
    style = props.style,
    onLayout = props.onLayout,
    rest = _objectWithoutPropertiesLoose(props, _excluded2);
  var _useDragListContext = useDragListContext(),
    keyExtractor = _useDragListContext.keyExtractor,
    activeKey = _useDragListContext.activeKey,
    activeIndex = _useDragListContext.activeIndex,
    pan = _useDragListContext.pan,
    panIndex = _useDragListContext.panIndex,
    layouts = _useDragListContext.layouts,
    horizontal = _useDragListContext.horizontal;
  var _useState2 = useState(false),
    isOffset = _useState2[0],
    setIsOffset = _useState2[1];
  var key = keyExtractor(item, index);
  var isActive = key === activeKey;
  var ref = useRef(null);
  var anim = useRef(new Animated.Value(0)).current;
  var elevations = useMemo(function () {
    return isActive ? {
      elevation: new Animated.Value(1),
      zIndex: new Animated.Value(999)
    } : {
      elevation: new Animated.Value(0),
      zIndex: new Animated.Value(0)
    };
  }, [isActive]);
  useEffect(function () {
    if (activeKey && !isActive && layouts.hasOwnProperty(activeKey)) {
      if (index >= panIndex && index <= activeIndex) {
        Animated.timing(anim, {
          duration: SLIDE_MILLIS,
          easing: Easing.inOut(Easing.linear),
          toValue: layouts[activeKey].extent,
          useNativeDriver: true
        }).start();
        setIsOffset(true);
        return;
      } else if (index >= activeIndex && index <= panIndex) {
        Animated.timing(anim, {
          duration: SLIDE_MILLIS,
          easing: Easing.inOut(Easing.linear),
          toValue: -layouts[activeKey].extent,
          useNativeDriver: true
        }).start();
        setIsOffset(true);
        return;
      }
    }
    if (!activeKey) {
      anim.setValue(0);
    }
    setIsOffset(false);
  }, [activeKey, index, panIndex, key, activeIndex, horizontal]);
  useEffect(function () {
    if (!isOffset) {
      Animated.timing(anim, {
        duration: SLIDE_MILLIS,
        easing: Easing.inOut(Easing.linear),
        toValue: 0,
        useNativeDriver: true
      }).start();
    }
  }, [isOffset]);
  function onCellLayout(evt) {
    if (onLayout) {
      onLayout(evt);
    }
    var layout = evt.nativeEvent.layout;
    layouts[key] = horizontal ? {
      pos: layout.x,
      extent: layout.width
    } : {
      pos: layout.y,
      extent: layout.height
    };
  }
  return React.createElement(Animated.View, Object.assign({
    ref: ref,
    key: key
  }, rest, {
    style: [style, isActive ? _extends({}, elevations, {
      transform: [horizontal ? {
        translateX: pan
      } : {
        translateY: pan
      }]
    }) : _extends({}, elevations, {
      transform: [horizontal ? {
        translateX: anim
      } : {
        translateY: anim
      }]
    })],
    onLayout: onCellLayout
  }), children);
}
var DragList = React.forwardRef(DragListImpl);

export default DragList;
//# sourceMappingURL=index.modern.js.map
