import React from "react";
import { Animated } from "react-native";
export interface PosExtent {
    pos: number;
    extent: number;
}
export interface LayoutCache {
    [key: string]: PosExtent;
}
declare type ContextProps<T> = {
    activeKey: string | null;
    activeIndex: number;
    keyExtractor: (item: T, index: number) => string;
    pan: Animated.Value;
    panIndex: number;
    layouts: LayoutCache;
    horizontal: boolean | null | undefined;
    children: React.ReactNode;
};
export declare function DragListProvider<T>({ activeKey, activeIndex, keyExtractor, pan, panIndex, layouts, horizontal, children, }: ContextProps<T>): React.JSX.Element;
export declare function useDragListContext<T>(): Pick<ContextProps<T>, "activeKey" | "activeIndex" | "keyExtractor" | "pan" | "panIndex" | "layouts" | "horizontal">;
export {};
