/**
 * Lighthouse v10.2.0-56-gb981a38e7 (Jun 13 2023)
 *
 * Automated auditing, performance metrics, and best practices for the web.
 *
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   The Lighthouse Authors
 * @license  Apache-2.0
 */
!function(){"use strict";var e="undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t=[],n=[],a="undefined"!=typeof Uint8Array?Uint8Array:Array,r=!1;function init$1(){r=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",a=0,o=e.length;a<o;++a)t[a]=e[a],n[e.charCodeAt(a)]=a;n["-".charCodeAt(0)]=62,n["_".charCodeAt(0)]=63}function encodeChunk(e,n,a){for(var r,o,i=[],s=n;s<a;s+=3)r=(e[s]<<16)+(e[s+1]<<8)+e[s+2],i.push(t[(o=r)>>18&63]+t[o>>12&63]+t[o>>6&63]+t[63&o]);return i.join("")}function fromByteArray(e){var n;r||init$1();for(var a=e.length,o=a%3,i="",s=[],c=16383,l=0,u=a-o;l<u;l+=c)s.push(encodeChunk(e,l,l+c>u?u:l+c));return 1===o?(n=e[a-1],i+=t[n>>2],i+=t[n<<4&63],i+="=="):2===o&&(n=(e[a-2]<<8)+e[a-1],i+=t[n>>10],i+=t[n>>4&63],i+=t[n<<2&63],i+="="),s.push(i),s.join("")}function read(e,t,n,a,r){var o,i,s=8*r-a-1,c=(1<<s)-1,l=c>>1,u=-7,d=n?r-1:0,m=n?-1:1,p=e[t+d];for(d+=m,o=p&(1<<-u)-1,p>>=-u,
u+=s;u>0;o=256*o+e[t+d],d+=m,u-=8);for(i=o&(1<<-u)-1,o>>=-u,u+=a;u>0;i=256*i+e[t+d],d+=m,u-=8);if(0===o)o=1-l;else{if(o===c)return i?NaN:1/0*(p?-1:1);i+=Math.pow(2,a),o-=l}return(p?-1:1)*i*Math.pow(2,o-a)}function write(e,t,n,a,r,o){var i,s,c,l=8*o-r-1,u=(1<<l)-1,d=u>>1,m=23===r?Math.pow(2,-24)-Math.pow(2,-77):0,p=a?0:o-1,h=a?1:-1,f=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,i=u):(i=Math.floor(Math.log(t)/Math.LN2),t*(c=Math.pow(2,-i))<1&&(i--,c*=2),(t+=i+d>=1?m/c:m*Math.pow(2,1-d))*c>=2&&(i++,c/=2),i+d>=u?(s=0,i=u):i+d>=1?(s=(t*c-1)*Math.pow(2,r),i+=d):(s=t*Math.pow(2,d-1)*Math.pow(2,r),i=0));r>=8;e[n+p]=255&s,p+=h,s/=256,r-=8);for(i=i<<r|s,l+=r;l>0;e[n+p]=255&i,p+=h,i/=256,l-=8);e[n+p-h]|=128*f}var o={}.toString,i=Array.isArray||function(e){return"[object Array]"==o.call(e)};function kMaxLength(){return Buffer$1.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function createBuffer(e,t){if(kMaxLength()<t)throw new RangeError("Invalid typed array length")
;return Buffer$1.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t)).__proto__=Buffer$1.prototype:(null===e&&(e=new Buffer$1(t)),e.length=t),e}function Buffer$1(e,t,n){if(!(Buffer$1.TYPED_ARRAY_SUPPORT||this instanceof Buffer$1))return new Buffer$1(e,t,n);if("number"==typeof e){if("string"==typeof t)throw new Error("If encoding is specified then the first argument must be a string");return allocUnsafe(this,e)}return from(this,e,t,n)}function from(e,t,n,a){if("number"==typeof t)throw new TypeError('"value" argument must not be a number');return"undefined"!=typeof ArrayBuffer&&t instanceof ArrayBuffer?function fromArrayBuffer(e,t,n,a){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(a||0))throw new RangeError("'length' is out of bounds");t=void 0===n&&void 0===a?new Uint8Array(t):void 0===a?new Uint8Array(t,n):new Uint8Array(t,n,a);Buffer$1.TYPED_ARRAY_SUPPORT?(e=t).__proto__=Buffer$1.prototype:e=fromArrayLike(e,t);return e
}(e,t,n,a):"string"==typeof t?function fromString(e,t,n){"string"==typeof n&&""!==n||(n="utf8");if(!Buffer$1.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var a=0|byteLength(t,n),r=(e=createBuffer(e,a)).write(t,n);r!==a&&(e=e.slice(0,r));return e}(e,t,n):function fromObject(e,t){if(internalIsBuffer(t)){var n=0|checked(t.length);return 0===(e=createBuffer(e,n)).length||t.copy(e,0,0,n),e}if(t){if("undefined"!=typeof ArrayBuffer&&t.buffer instanceof ArrayBuffer||"length"in t)return"number"!=typeof t.length||function isnan(e){return e!=e}(t.length)?createBuffer(e,0):fromArrayLike(e,t);if("Buffer"===t.type&&i(t.data))return fromArrayLike(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}(e,t)}function assertSize(e){if("number"!=typeof e)throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function allocUnsafe(e,t){
if(assertSize(t),e=createBuffer(e,t<0?0:0|checked(t)),!Buffer$1.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function fromArrayLike(e,t){var n=t.length<0?0:0|checked(t.length);e=createBuffer(e,n);for(var a=0;a<n;a+=1)e[a]=255&t[a];return e}function checked(e){if(e>=kMaxLength())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+kMaxLength().toString(16)+" bytes");return 0|e}function internalIsBuffer(e){return!(null==e||!e._isBuffer)}function byteLength(e,t){if(internalIsBuffer(e))return e.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;"string"!=typeof e&&(e=""+e);var n=e.length;if(0===n)return 0;for(var a=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return utf8ToBytes(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":
return base64ToBytes(e).length;default:if(a)return utf8ToBytes(e).length;t=(""+t).toLowerCase(),a=!0}}function slowToString(e,t,n){var a=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),n<=0)return"";if((n>>>=0)<=(t>>>=0))return"";for(e||(e="utf8");;)switch(e){case"hex":return hexSlice(this,t,n);case"utf8":case"utf-8":return utf8Slice(this,t,n);case"ascii":return asciiSlice(this,t,n);case"latin1":case"binary":return latin1Slice(this,t,n);case"base64":return base64Slice(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return utf16leSlice(this,t,n);default:if(a)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),a=!0}}function swap(e,t,n){var a=e[t];e[t]=e[n],e[n]=a}function bidirectionalIndexOf(e,t,n,a,r){if(0===e.length)return-1;if("string"==typeof n?(a=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=r?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(r)return-1
;n=e.length-1}else if(n<0){if(!r)return-1;n=0}if("string"==typeof t&&(t=Buffer$1.from(t,a)),internalIsBuffer(t))return 0===t.length?-1:arrayIndexOf(e,t,n,a,r);if("number"==typeof t)return t&=255,Buffer$1.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?r?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):arrayIndexOf(e,[t],n,a,r);throw new TypeError("val must be string, number or Buffer")}function arrayIndexOf(e,t,n,a,r){var o,i=1,s=e.length,c=t.length;if(void 0!==a&&("ucs2"===(a=String(a).toLowerCase())||"ucs-2"===a||"utf16le"===a||"utf-16le"===a)){if(e.length<2||t.length<2)return-1;i=2,s/=2,c/=2,n/=2}function read(e,t){return 1===i?e[t]:e.readUInt16BE(t*i)}if(r){var l=-1;for(o=n;o<s;o++)if(read(e,o)===read(t,-1===l?0:o-l)){if(-1===l&&(l=o),o-l+1===c)return l*i}else-1!==l&&(o-=o-l),l=-1}else for(n+c>s&&(n=s-c),o=n;o>=0;o--){for(var u=!0,d=0;d<c;d++)if(read(e,o+d)!==read(t,d)){u=!1;break}if(u)return o}return-1}
function hexWrite(e,t,n,a){n=Number(n)||0;var r=e.length-n;a?(a=Number(a))>r&&(a=r):a=r;var o=t.length;if(o%2!=0)throw new TypeError("Invalid hex string");a>o/2&&(a=o/2);for(var i=0;i<a;++i){var s=parseInt(t.substr(2*i,2),16);if(isNaN(s))return i;e[n+i]=s}return i}function utf8Write(e,t,n,a){return blitBuffer(utf8ToBytes(t,e.length-n),e,n,a)}function asciiWrite(e,t,n,a){return blitBuffer(function asciiToBytes(e){for(var t=[],n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}(t),e,n,a)}function latin1Write(e,t,n,a){return asciiWrite(e,t,n,a)}function base64Write(e,t,n,a){return blitBuffer(base64ToBytes(t),e,n,a)}function ucs2Write(e,t,n,a){return blitBuffer(function utf16leToBytes(e,t){for(var n,a,r,o=[],i=0;i<e.length&&!((t-=2)<0);++i)a=(n=e.charCodeAt(i))>>8,r=n%256,o.push(r),o.push(a);return o}(t,e.length-n),e,n,a)}function base64Slice(e,t,n){return 0===t&&n===e.length?fromByteArray(e):fromByteArray(e.slice(t,n))}function utf8Slice(e,t,n){n=Math.min(e.length,n)
;for(var a=[],r=t;r<n;){var o,i,c,l,u=e[r],d=null,m=u>239?4:u>223?3:u>191?2:1;if(r+m<=n)switch(m){case 1:u<128&&(d=u);break;case 2:128==(192&(o=e[r+1]))&&(l=(31&u)<<6|63&o)>127&&(d=l);break;case 3:o=e[r+1],i=e[r+2],128==(192&o)&&128==(192&i)&&(l=(15&u)<<12|(63&o)<<6|63&i)>2047&&(l<55296||l>57343)&&(d=l);break;case 4:o=e[r+1],i=e[r+2],c=e[r+3],128==(192&o)&&128==(192&i)&&128==(192&c)&&(l=(15&u)<<18|(63&o)<<12|(63&i)<<6|63&c)>65535&&l<1114112&&(d=l)}null===d?(d=65533,m=1):d>65535&&(d-=65536,a.push(d>>>10&1023|55296),d=56320|1023&d),a.push(d),r+=m}return function decodeCodePointsArray(e){var t=e.length;if(t<=s)return String.fromCharCode.apply(String,e);var n="",a=0;for(;a<t;)n+=String.fromCharCode.apply(String,e.slice(a,a+=s));return n}(a)}Buffer$1.TYPED_ARRAY_SUPPORT=void 0===e.TYPED_ARRAY_SUPPORT||e.TYPED_ARRAY_SUPPORT,Buffer$1.poolSize=8192,Buffer$1._augment=function(e){return e.__proto__=Buffer$1.prototype,e},Buffer$1.from=function(e,t,n){return from(null,e,t,n)},
Buffer$1.TYPED_ARRAY_SUPPORT&&(Buffer$1.prototype.__proto__=Uint8Array.prototype,Buffer$1.__proto__=Uint8Array),Buffer$1.alloc=function(e,t,n){return function alloc(e,t,n,a){return assertSize(t),t<=0?createBuffer(e,t):void 0!==n?"string"==typeof a?createBuffer(e,t).fill(n,a):createBuffer(e,t).fill(n):createBuffer(e,t)}(null,e,t,n)},Buffer$1.allocUnsafe=function(e){return allocUnsafe(null,e)},Buffer$1.allocUnsafeSlow=function(e){return allocUnsafe(null,e)},Buffer$1.isBuffer=function isBuffer$3(e){return null!=e&&(!!e._isBuffer||isFastBuffer(e)||function isSlowBuffer(e){return"function"==typeof e.readFloatLE&&"function"==typeof e.slice&&isFastBuffer(e.slice(0,0))}(e))},Buffer$1.compare=function compare(e,t){if(!internalIsBuffer(e)||!internalIsBuffer(t))throw new TypeError("Arguments must be Buffers");if(e===t)return 0;for(var n=e.length,a=t.length,r=0,o=Math.min(n,a);r<o;++r)if(e[r]!==t[r]){n=e[r],a=t[r];break}return n<a?-1:a<n?1:0},Buffer$1.isEncoding=function isEncoding(e){
switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},Buffer$1.concat=function concat(e,t){if(!i(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return Buffer$1.alloc(0);var n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;var a=Buffer$1.allocUnsafe(t),r=0;for(n=0;n<e.length;++n){var o=e[n];if(!internalIsBuffer(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(a,r),r+=o.length}return a},Buffer$1.byteLength=byteLength,Buffer$1.prototype._isBuffer=!0,Buffer$1.prototype.swap16=function swap16(){var e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;t<e;t+=2)swap(this,t,t+1);return this},Buffer$1.prototype.swap32=function swap32(){var e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits")
;for(var t=0;t<e;t+=4)swap(this,t,t+3),swap(this,t+1,t+2);return this},Buffer$1.prototype.swap64=function swap64(){var e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;t<e;t+=8)swap(this,t,t+7),swap(this,t+1,t+6),swap(this,t+2,t+5),swap(this,t+3,t+4);return this},Buffer$1.prototype.toString=function toString(){var e=0|this.length;return 0===e?"":0===arguments.length?utf8Slice(this,0,e):slowToString.apply(this,arguments)},Buffer$1.prototype.equals=function equals(e){if(!internalIsBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===Buffer$1.compare(this,e)},Buffer$1.prototype.inspect=function inspect(){var e="";return this.length>0&&(e=this.toString("hex",0,50).match(/.{2}/g).join(" "),this.length>50&&(e+=" ... ")),"<Buffer "+e+">"},Buffer$1.prototype.compare=function compare(e,t,n,a,r){if(!internalIsBuffer(e))throw new TypeError("Argument must be a Buffer");if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),
void 0===a&&(a=0),void 0===r&&(r=this.length),t<0||n>e.length||a<0||r>this.length)throw new RangeError("out of range index");if(a>=r&&t>=n)return 0;if(a>=r)return-1;if(t>=n)return 1;if(this===e)return 0;for(var o=(r>>>=0)-(a>>>=0),i=(n>>>=0)-(t>>>=0),s=Math.min(o,i),c=this.slice(a,r),l=e.slice(t,n),u=0;u<s;++u)if(c[u]!==l[u]){o=c[u],i=l[u];break}return o<i?-1:i<o?1:0},Buffer$1.prototype.includes=function includes(e,t,n){return-1!==this.indexOf(e,t,n)},Buffer$1.prototype.indexOf=function indexOf(e,t,n){return bidirectionalIndexOf(this,e,t,n,!0)},Buffer$1.prototype.lastIndexOf=function lastIndexOf(e,t,n){return bidirectionalIndexOf(this,e,t,n,!1)},Buffer$1.prototype.write=function write(e,t,n,a){if(void 0===t)a="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)a=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t|=0,isFinite(n)?(n|=0,void 0===a&&(a="utf8")):(a=n,n=void 0)}var r=this.length-t
;if((void 0===n||n>r)&&(n=r),e.length>0&&(n<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");a||(a="utf8");for(var o=!1;;)switch(a){case"hex":return hexWrite(this,e,t,n);case"utf8":case"utf-8":return utf8Write(this,e,t,n);case"ascii":return asciiWrite(this,e,t,n);case"latin1":case"binary":return latin1Write(this,e,t,n);case"base64":return base64Write(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return ucs2Write(this,e,t,n);default:if(o)throw new TypeError("Unknown encoding: "+a);a=(""+a).toLowerCase(),o=!0}},Buffer$1.prototype.toJSON=function toJSON(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};var s=4096;function asciiSlice(e,t,n){var a="";n=Math.min(e.length,n);for(var r=t;r<n;++r)a+=String.fromCharCode(127&e[r]);return a}function latin1Slice(e,t,n){var a="";n=Math.min(e.length,n);for(var r=t;r<n;++r)a+=String.fromCharCode(e[r]);return a}function hexSlice(e,t,n){var a=e.length;(!t||t<0)&&(t=0),
(!n||n<0||n>a)&&(n=a);for(var r="",o=t;o<n;++o)r+=toHex(e[o]);return r}function utf16leSlice(e,t,n){for(var a=e.slice(t,n),r="",o=0;o<a.length;o+=2)r+=String.fromCharCode(a[o]+256*a[o+1]);return r}function checkOffset(e,t,n){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function checkInt(e,t,n,a,r,o){if(!internalIsBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>r||t<o)throw new RangeError('"value" argument is out of bounds');if(n+a>e.length)throw new RangeError("Index out of range")}function objectWriteUInt16(e,t,n,a){t<0&&(t=65535+t+1);for(var r=0,o=Math.min(e.length-n,2);r<o;++r)e[n+r]=(t&255<<8*(a?r:1-r))>>>8*(a?r:1-r)}function objectWriteUInt32(e,t,n,a){t<0&&(t=4294967295+t+1);for(var r=0,o=Math.min(e.length-n,4);r<o;++r)e[n+r]=t>>>8*(a?r:3-r)&255}function checkIEEE754(e,t,n,a,r,o){if(n+a>e.length)throw new RangeError("Index out of range")
;if(n<0)throw new RangeError("Index out of range")}function writeFloat(e,t,n,a,r){return r||checkIEEE754(e,0,n,4),write(e,t,n,a,23,4),n+4}function writeDouble(e,t,n,a,r){return r||checkIEEE754(e,0,n,8),write(e,t,n,a,52,8),n+8}Buffer$1.prototype.slice=function slice(e,t){var n,a=this.length;if((e=~~e)<0?(e+=a)<0&&(e=0):e>a&&(e=a),(t=void 0===t?a:~~t)<0?(t+=a)<0&&(t=0):t>a&&(t=a),t<e&&(t=e),Buffer$1.TYPED_ARRAY_SUPPORT)(n=this.subarray(e,t)).__proto__=Buffer$1.prototype;else{var r=t-e;n=new Buffer$1(r,void 0);for(var o=0;o<r;++o)n[o]=this[o+e]}return n},Buffer$1.prototype.readUIntLE=function readUIntLE(e,t,n){e|=0,t|=0,n||checkOffset(e,t,this.length);for(var a=this[e],r=1,o=0;++o<t&&(r*=256);)a+=this[e+o]*r;return a},Buffer$1.prototype.readUIntBE=function readUIntBE(e,t,n){e|=0,t|=0,n||checkOffset(e,t,this.length);for(var a=this[e+--t],r=1;t>0&&(r*=256);)a+=this[e+--t]*r;return a},Buffer$1.prototype.readUInt8=function readUInt8(e,t){return t||checkOffset(e,1,this.length),this[e]},
Buffer$1.prototype.readUInt16LE=function readUInt16LE(e,t){return t||checkOffset(e,2,this.length),this[e]|this[e+1]<<8},Buffer$1.prototype.readUInt16BE=function readUInt16BE(e,t){return t||checkOffset(e,2,this.length),this[e]<<8|this[e+1]},Buffer$1.prototype.readUInt32LE=function readUInt32LE(e,t){return t||checkOffset(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},Buffer$1.prototype.readUInt32BE=function readUInt32BE(e,t){return t||checkOffset(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},Buffer$1.prototype.readIntLE=function readIntLE(e,t,n){e|=0,t|=0,n||checkOffset(e,t,this.length);for(var a=this[e],r=1,o=0;++o<t&&(r*=256);)a+=this[e+o]*r;return a>=(r*=128)&&(a-=Math.pow(2,8*t)),a},Buffer$1.prototype.readIntBE=function readIntBE(e,t,n){e|=0,t|=0,n||checkOffset(e,t,this.length);for(var a=t,r=1,o=this[e+--a];a>0&&(r*=256);)o+=this[e+--a]*r;return o>=(r*=128)&&(o-=Math.pow(2,8*t)),o},
Buffer$1.prototype.readInt8=function readInt8(e,t){return t||checkOffset(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},Buffer$1.prototype.readInt16LE=function readInt16LE(e,t){t||checkOffset(e,2,this.length);var n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},Buffer$1.prototype.readInt16BE=function readInt16BE(e,t){t||checkOffset(e,2,this.length);var n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},Buffer$1.prototype.readInt32LE=function readInt32LE(e,t){return t||checkOffset(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},Buffer$1.prototype.readInt32BE=function readInt32BE(e,t){return t||checkOffset(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},Buffer$1.prototype.readFloatLE=function readFloatLE(e,t){return t||checkOffset(e,4,this.length),read(this,e,!0,23,4)},Buffer$1.prototype.readFloatBE=function readFloatBE(e,t){return t||checkOffset(e,4,this.length),read(this,e,!1,23,4)},
Buffer$1.prototype.readDoubleLE=function readDoubleLE(e,t){return t||checkOffset(e,8,this.length),read(this,e,!0,52,8)},Buffer$1.prototype.readDoubleBE=function readDoubleBE(e,t){return t||checkOffset(e,8,this.length),read(this,e,!1,52,8)},Buffer$1.prototype.writeUIntLE=function writeUIntLE(e,t,n,a){(e=+e,t|=0,n|=0,a)||checkInt(this,e,t,n,Math.pow(2,8*n)-1,0);var r=1,o=0;for(this[t]=255&e;++o<n&&(r*=256);)this[t+o]=e/r&255;return t+n},Buffer$1.prototype.writeUIntBE=function writeUIntBE(e,t,n,a){(e=+e,t|=0,n|=0,a)||checkInt(this,e,t,n,Math.pow(2,8*n)-1,0);var r=n-1,o=1;for(this[t+r]=255&e;--r>=0&&(o*=256);)this[t+r]=e/o&255;return t+n},Buffer$1.prototype.writeUInt8=function writeUInt8(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,1,255,0),Buffer$1.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),this[t]=255&e,t+1},Buffer$1.prototype.writeUInt16LE=function writeUInt16LE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,2,65535,0),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=255&e,
this[t+1]=e>>>8):objectWriteUInt16(this,e,t,!0),t+2},Buffer$1.prototype.writeUInt16BE=function writeUInt16BE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,2,65535,0),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):objectWriteUInt16(this,e,t,!1),t+2},Buffer$1.prototype.writeUInt32LE=function writeUInt32LE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,4,4294967295,0),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e):objectWriteUInt32(this,e,t,!0),t+4},Buffer$1.prototype.writeUInt32BE=function writeUInt32BE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,4,4294967295,0),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):objectWriteUInt32(this,e,t,!1),t+4},Buffer$1.prototype.writeIntLE=function writeIntLE(e,t,n,a){if(e=+e,t|=0,!a){var r=Math.pow(2,8*n-1);checkInt(this,e,t,n,r-1,-r)}var o=0,i=1,s=0;for(this[t]=255&e;++o<n&&(i*=256);)e<0&&0===s&&0!==this[t+o-1]&&(s=1),this[t+o]=(e/i>>0)-s&255
;return t+n},Buffer$1.prototype.writeIntBE=function writeIntBE(e,t,n,a){if(e=+e,t|=0,!a){var r=Math.pow(2,8*n-1);checkInt(this,e,t,n,r-1,-r)}var o=n-1,i=1,s=0;for(this[t+o]=255&e;--o>=0&&(i*=256);)e<0&&0===s&&0!==this[t+o+1]&&(s=1),this[t+o]=(e/i>>0)-s&255;return t+n},Buffer$1.prototype.writeInt8=function writeInt8(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,1,127,-128),Buffer$1.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),e<0&&(e=255+e+1),this[t]=255&e,t+1},Buffer$1.prototype.writeInt16LE=function writeInt16LE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,2,32767,-32768),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):objectWriteUInt16(this,e,t,!0),t+2},Buffer$1.prototype.writeInt16BE=function writeInt16BE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,2,32767,-32768),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):objectWriteUInt16(this,e,t,!1),t+2},Buffer$1.prototype.writeInt32LE=function writeInt32LE(e,t,n){return e=+e,t|=0,
n||checkInt(this,e,t,4,2147483647,-2147483648),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24):objectWriteUInt32(this,e,t,!0),t+4},Buffer$1.prototype.writeInt32BE=function writeInt32BE(e,t,n){return e=+e,t|=0,n||checkInt(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),Buffer$1.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):objectWriteUInt32(this,e,t,!1),t+4},Buffer$1.prototype.writeFloatLE=function writeFloatLE(e,t,n){return writeFloat(this,e,t,!0,n)},Buffer$1.prototype.writeFloatBE=function writeFloatBE(e,t,n){return writeFloat(this,e,t,!1,n)},Buffer$1.prototype.writeDoubleLE=function writeDoubleLE(e,t,n){return writeDouble(this,e,t,!0,n)},Buffer$1.prototype.writeDoubleBE=function writeDoubleBE(e,t,n){return writeDouble(this,e,t,!1,n)},Buffer$1.prototype.copy=function copy(e,t,n,a){if(n||(n=0),a||0===a||(a=this.length),t>=e.length&&(t=e.length),t||(t=0),a>0&&a<n&&(a=n),a===n)return 0
;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("sourceStart out of bounds");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),e.length-t<a-n&&(a=e.length-t+n);var r,o=a-n;if(this===e&&n<t&&t<a)for(r=o-1;r>=0;--r)e[r+t]=this[r+n];else if(o<1e3||!Buffer$1.TYPED_ARRAY_SUPPORT)for(r=0;r<o;++r)e[r+t]=this[r+n];else Uint8Array.prototype.set.call(e,this.subarray(n,n+o),t);return o},Buffer$1.prototype.fill=function fill(e,t,n,a){if("string"==typeof e){if("string"==typeof t?(a=t,t=0,n=this.length):"string"==typeof n&&(a=n,n=this.length),1===e.length){var r=e.charCodeAt(0);r<256&&(e=r)}if(void 0!==a&&"string"!=typeof a)throw new TypeError("encoding must be a string");if("string"==typeof a&&!Buffer$1.isEncoding(a))throw new TypeError("Unknown encoding: "+a)}else"number"==typeof e&&(e&=255)
;if(t<0||this.length<t||this.length<n)throw new RangeError("Out of range index");if(n<=t)return this;var o;if(t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0),"number"==typeof e)for(o=t;o<n;++o)this[o]=e;else{var i=internalIsBuffer(e)?e:utf8ToBytes(new Buffer$1(e,a).toString()),s=i.length;for(o=0;o<n-t;++o)this[o+t]=i[o%s]}return this};var c=/[^+\/0-9A-Za-z-_]/g;function toHex(e){return e<16?"0"+e.toString(16):e.toString(16)}function utf8ToBytes(e,t){var n;t=t||1/0;for(var a=e.length,r=null,o=[],i=0;i<a;++i){if((n=e.charCodeAt(i))>55295&&n<57344){if(!r){if(n>56319){(t-=3)>-1&&o.push(239,191,189);continue}if(i+1===a){(t-=3)>-1&&o.push(239,191,189);continue}r=n;continue}if(n<56320){(t-=3)>-1&&o.push(239,191,189),r=n;continue}n=65536+(r-55296<<10|n-56320)}else r&&(t-=3)>-1&&o.push(239,191,189);if(r=null,n<128){if((t-=1)<0)break;o.push(n)}else if(n<2048){if((t-=2)<0)break;o.push(n>>6|192,63&n|128)}else if(n<65536){if((t-=3)<0)break;o.push(n>>12|224,n>>6&63|128,63&n|128)}else{
if(!(n<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;o.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return o}function base64ToBytes(e){return function toByteArray(e){var t,o,i,s,c,l;r||init$1();var u=e.length;if(u%4>0)throw new Error("Invalid string. Length must be a multiple of 4");c="="===e[u-2]?2:"="===e[u-1]?1:0,l=new a(3*u/4-c),i=c>0?u-4:u;var d=0;for(t=0,o=0;t<i;t+=4,o+=3)s=n[e.charCodeAt(t)]<<18|n[e.charCodeAt(t+1)]<<12|n[e.charCodeAt(t+2)]<<6|n[e.charCodeAt(t+3)],l[d++]=s>>16&255,l[d++]=s>>8&255,l[d++]=255&s;return 2===c?(s=n[e.charCodeAt(t)]<<2|n[e.charCodeAt(t+1)]>>4,l[d++]=255&s):1===c&&(s=n[e.charCodeAt(t)]<<10|n[e.charCodeAt(t+1)]<<4|n[e.charCodeAt(t+2)]>>2,l[d++]=s>>8&255,l[d++]=255&s),l}(function base64clean(e){if((e=function stringtrim(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}(e).replace(c,"")).length<2)return"";for(;e.length%4!=0;)e+="=";return e}(e))}function blitBuffer(e,t,n,a){
for(var r=0;r<a&&!(r+n>=t.length||r>=e.length);++r)t[r+n]=e[r];return r}function isFastBuffer(e){return!!e.constructor&&"function"==typeof e.constructor.isBuffer&&e.constructor.isBuffer(e)}function defaultSetTimout(){throw new Error("setTimeout has not been defined")}function defaultClearTimeout(){throw new Error("clearTimeout has not been defined")}var l=defaultSetTimout,u=defaultClearTimeout;function runTimeout(e){if(l===setTimeout)return setTimeout(e,0);if((l===defaultSetTimout||!l)&&setTimeout)return l=setTimeout,setTimeout(e,0);try{return l(e,0)}catch(t){try{return l.call(null,e,0)}catch(t){return l.call(this,e,0)}}}"function"==typeof e.setTimeout&&(l=setTimeout),"function"==typeof e.clearTimeout&&(u=clearTimeout);var d,m=[],p=!1,h=-1;function cleanUpNextTick(){p&&d&&(p=!1,d.length?m=d.concat(m):h=-1,m.length&&drainQueue())}function drainQueue(){if(!p){var e=runTimeout(cleanUpNextTick);p=!0;for(var t=m.length;t;){for(d=m,m=[];++h<t;)d&&d[h].run();h=-1,t=m.length}d=null,p=!1,
function runClearTimeout(e){if(u===clearTimeout)return clearTimeout(e);if((u===defaultClearTimeout||!u)&&clearTimeout)return u=clearTimeout,clearTimeout(e);try{return u(e)}catch(t){try{return u.call(null,e)}catch(t){return u.call(this,e)}}}(e)}}function nextTick(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];m.push(new Item(e,t)),1!==m.length||p||runTimeout(drainQueue)}function Item(e,t){this.fun=e,this.array=t}Item.prototype.run=function(){this.fun.apply(null,this.array)};function noop$1(){}var f=noop$1,y=noop$1,b=noop$1,v=noop$1,w=noop$1,D=noop$1,E=noop$1;var T=e.performance||{},C=T.now||T.mozNow||T.msNow||T.oNow||T.webkitNow||function(){return(new Date).getTime()};var S=new Date;var _={nextTick,title:"browser",browser:!0,env:{},argv:[],version:"",versions:{},on:f,addListener:y,once:b,off:v,removeListener:w,removeAllListeners:D,emit:E,binding:function binding$1(e){throw new Error("process.binding is not supported")
},cwd:function cwd(){return"/"},chdir:function chdir(e){throw new Error("process.chdir is not supported")},umask:function umask(){return 0},hrtime:function hrtime$1(e){var t=.001*C.call(T),n=Math.floor(t),a=Math.floor(t%1*1e9);return e&&(n-=e[0],(a-=e[1])<0&&(n--,a+=1e9)),[n,a]},platform:"browser",release:{},config:{},uptime:function uptime(){return(new Date-S)/1e3}};function EventHandlers(){}function EventEmitter(){EventEmitter.init.call(this)}function $getMaxListeners(e){return void 0===e._maxListeners?EventEmitter.defaultMaxListeners:e._maxListeners}function emitNone(e,t,n){if(t)e.call(n);else for(var a=e.length,r=arrayClone(e,a),o=0;o<a;++o)r[o].call(n)}function emitOne(e,t,n,a){if(t)e.call(n,a);else for(var r=e.length,o=arrayClone(e,r),i=0;i<r;++i)o[i].call(n,a)}function emitTwo(e,t,n,a,r){if(t)e.call(n,a,r);else for(var o=e.length,i=arrayClone(e,o),s=0;s<o;++s)i[s].call(n,a,r)}function emitThree(e,t,n,a,r,o){
if(t)e.call(n,a,r,o);else for(var i=e.length,s=arrayClone(e,i),c=0;c<i;++c)s[c].call(n,a,r,o)}function emitMany(e,t,n,a){if(t)e.apply(n,a);else for(var r=e.length,o=arrayClone(e,r),i=0;i<r;++i)o[i].apply(n,a)}function _addListener(e,t,n,a){var r,o,i;if("function"!=typeof n)throw new TypeError('"listener" argument must be a function');if((o=e._events)?(o.newListener&&(e.emit("newListener",t,n.listener?n.listener:n),o=e._events),i=o[t]):(o=e._events=new EventHandlers,e._eventsCount=0),i){if("function"==typeof i?i=o[t]=a?[n,i]:[i,n]:a?i.unshift(n):i.push(n),!i.warned&&(r=$getMaxListeners(e))&&r>0&&i.length>r){i.warned=!0;var s=new Error("Possible EventEmitter memory leak detected. "+i.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");s.name="MaxListenersExceededWarning",s.emitter=e,s.type=t,s.count=i.length,function emitWarning(e){"function"==typeof console.warn?console.warn(e):console.log(e)}(s)}}else i=o[t]=n,++e._eventsCount;return e}
function _onceWrap(e,t,n){var a=!1;function g(){e.removeListener(t,g),a||(a=!0,n.apply(e,arguments))}return g.listener=n,g}function listenerCount$1(e){var t=this._events;if(t){var n=t[e];if("function"==typeof n)return 1;if(n)return n.length}return 0}function arrayClone(e,t){for(var n=new Array(t);t--;)n[t]=e[t];return n}function getAugmentedNamespace(e){if(e.__esModule)return e;var t=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(e).forEach((function(n){var a=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,a.get?a:{enumerable:!0,get:function(){return e[n]}})})),t}EventHandlers.prototype=Object.create(null),EventEmitter.EventEmitter=EventEmitter,EventEmitter.usingDomains=!1,EventEmitter.prototype.domain=void 0,EventEmitter.prototype._events=void 0,EventEmitter.prototype._maxListeners=void 0,EventEmitter.defaultMaxListeners=10,EventEmitter.init=function(){this.domain=null,EventEmitter.usingDomains&&undefined.active,
this._events&&this._events!==Object.getPrototypeOf(this)._events||(this._events=new EventHandlers,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0},EventEmitter.prototype.setMaxListeners=function setMaxListeners(e){if("number"!=typeof e||e<0||isNaN(e))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=e,this},EventEmitter.prototype.getMaxListeners=function getMaxListeners(){return $getMaxListeners(this)},EventEmitter.prototype.emit=function emit(e){var t,n,a,r,o,i,s,c="error"===e;if(i=this._events)c=c&&null==i.error;else if(!c)return!1;if(s=this.domain,c){if(t=arguments[1],!s){if(t instanceof Error)throw t;var l=new Error('Uncaught, unspecified "error" event. ('+t+")");throw l.context=t,l}return t||(t=new Error('Uncaught, unspecified "error" event')),t.domainEmitter=this,t.domain=s,t.domainThrown=!1,s.emit("error",t),!1}if(!(n=i[e]))return!1;var u="function"==typeof n;switch(a=arguments.length){case 1:emitNone(n,u,this);break
;case 2:emitOne(n,u,this,arguments[1]);break;case 3:emitTwo(n,u,this,arguments[1],arguments[2]);break;case 4:emitThree(n,u,this,arguments[1],arguments[2],arguments[3]);break;default:for(r=new Array(a-1),o=1;o<a;o++)r[o-1]=arguments[o];emitMany(n,u,this,r)}return!0},EventEmitter.prototype.addListener=function addListener(e,t){return _addListener(this,e,t,!1)},EventEmitter.prototype.on=EventEmitter.prototype.addListener,EventEmitter.prototype.prependListener=function prependListener(e,t){return _addListener(this,e,t,!0)},EventEmitter.prototype.once=function once(e,t){if("function"!=typeof t)throw new TypeError('"listener" argument must be a function');return this.on(e,_onceWrap(this,e,t)),this},EventEmitter.prototype.prependOnceListener=function prependOnceListener(e,t){if("function"!=typeof t)throw new TypeError('"listener" argument must be a function');return this.prependListener(e,_onceWrap(this,e,t)),this},EventEmitter.prototype.removeListener=function removeListener(e,t){
var n,a,r,o,i;if("function"!=typeof t)throw new TypeError('"listener" argument must be a function');if(!(a=this._events))return this;if(!(n=a[e]))return this;if(n===t||n.listener&&n.listener===t)0==--this._eventsCount?this._events=new EventHandlers:(delete a[e],a.removeListener&&this.emit("removeListener",e,n.listener||t));else if("function"!=typeof n){for(r=-1,o=n.length;o-- >0;)if(n[o]===t||n[o].listener&&n[o].listener===t){i=n[o].listener,r=o;break}if(r<0)return this;if(1===n.length){if(n[0]=void 0,0==--this._eventsCount)return this._events=new EventHandlers,this;delete a[e]}else!function spliceOne(e,t){for(var n=t,a=n+1,r=e.length;a<r;n+=1,a+=1)e[n]=e[a];e.pop()}(n,r);a.removeListener&&this.emit("removeListener",e,i||t)}return this},EventEmitter.prototype.off=function(e,t){return this.removeListener(e,t)},EventEmitter.prototype.removeAllListeners=function removeAllListeners(e){var t,n;if(!(n=this._events))return this
;if(!n.removeListener)return 0===arguments.length?(this._events=new EventHandlers,this._eventsCount=0):n[e]&&(0==--this._eventsCount?this._events=new EventHandlers:delete n[e]),this;if(0===arguments.length){for(var a,r=Object.keys(n),o=0;o<r.length;++o)"removeListener"!==(a=r[o])&&this.removeAllListeners(a);return this.removeAllListeners("removeListener"),this._events=new EventHandlers,this._eventsCount=0,this}if("function"==typeof(t=n[e]))this.removeListener(e,t);else if(t)do{this.removeListener(e,t[t.length-1])}while(t[0]);return this},EventEmitter.prototype.listeners=function listeners(e){var t,n=this._events;return n&&(t=n[e])?"function"==typeof t?[t.listener||t]:function unwrapListeners(e){for(var t=new Array(e.length),n=0;n<t.length;++n)t[n]=e[n].listener||e[n];return t}(t):[]},EventEmitter.listenerCount=function(e,t){return"function"==typeof e.listenerCount?e.listenerCount(t):listenerCount$1.call(e,t)},EventEmitter.prototype.listenerCount=listenerCount$1,
EventEmitter.prototype.eventNames=function eventNames(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]};var A={exports:{}},k=1e3,F=60*k,x=60*F,R=24*x,I=7*R,M=365.25*R,ms=function(e,t){t=t||{};var n=typeof e;if("string"===n&&e.length>0)return function parse$1(e){if((e=String(e)).length>100)return;var t=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(!t)return;var n=parseFloat(t[1]);switch((t[2]||"ms").toLowerCase()){case"years":case"year":case"yrs":case"yr":case"y":return n*M;case"weeks":case"week":case"w":return n*I;case"days":case"day":case"d":return n*R;case"hours":case"hour":case"hrs":case"hr":case"h":return n*x;case"minutes":case"minute":case"mins":case"min":case"m":return n*F;case"seconds":case"second":case"secs":case"sec":case"s":return n*k;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return n;default:return}}(e)
;if("number"===n&&isFinite(e))return t.long?function fmtLong(e){var t=Math.abs(e);if(t>=R)return plural(e,t,R,"day");if(t>=x)return plural(e,t,x,"hour");if(t>=F)return plural(e,t,F,"minute");if(t>=k)return plural(e,t,k,"second");return e+" ms"}(e):function fmtShort(e){var t=Math.abs(e);if(t>=R)return Math.round(e/R)+"d";if(t>=x)return Math.round(e/x)+"h";if(t>=F)return Math.round(e/F)+"m";if(t>=k)return Math.round(e/k)+"s";return e+"ms"}(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))};function plural(e,t,n,a){var r=t>=1.5*n;return Math.round(e/n)+" "+a+(r?"s":"")}var N=function setup(e){function createDebug(e){let t,n,a,r=null;function debug(...e){if(!debug.enabled)return;const n=debug,a=Number(new Date),r=a-(t||a);n.diff=r,n.prev=t,n.curr=a,t=a,e[0]=createDebug.coerce(e[0]),"string"!=typeof e[0]&&e.unshift("%O");let o=0;e[0]=e[0].replace(/%([a-zA-Z%])/g,((t,a)=>{if("%%"===t)return"%";o++;const r=createDebug.formatters[a]
;if("function"==typeof r){const a=e[o];t=r.call(n,a),e.splice(o,1),o--}return t})),createDebug.formatArgs.call(n,e);(n.log||createDebug.log).apply(n,e)}return debug.namespace=e,debug.useColors=createDebug.useColors(),debug.color=createDebug.selectColor(e),debug.extend=extend,debug.destroy=createDebug.destroy,Object.defineProperty(debug,"enabled",{enumerable:!0,configurable:!1,get:()=>null!==r?r:(n!==createDebug.namespaces&&(n=createDebug.namespaces,a=createDebug.enabled(e)),a),set:e=>{r=e}}),"function"==typeof createDebug.init&&createDebug.init(debug),debug}function extend(e,t){const n=createDebug(this.namespace+(void 0===t?":":t)+e);return n.log=this.log,n}function toNamespace(e){return e.toString().substring(2,e.toString().length-2).replace(/\.\*\?$/,"*")}return createDebug.debug=createDebug,createDebug.default=createDebug,createDebug.coerce=function coerce(e){if(e instanceof Error)return e.stack||e.message;return e},createDebug.disable=function disable(){
const e=[...createDebug.names.map(toNamespace),...createDebug.skips.map(toNamespace).map((e=>"-"+e))].join(",");return createDebug.enable(""),e},createDebug.enable=function enable(e){let t;createDebug.save(e),createDebug.namespaces=e,createDebug.names=[],createDebug.skips=[];const n=("string"==typeof e?e:"").split(/[\s,]+/),a=n.length;for(t=0;t<a;t++)n[t]&&("-"===(e=n[t].replace(/\*/g,".*?"))[0]?createDebug.skips.push(new RegExp("^"+e.slice(1)+"$")):createDebug.names.push(new RegExp("^"+e+"$")))},createDebug.enabled=function enabled(e){if("*"===e[e.length-1])return!0;let t,n;for(t=0,n=createDebug.skips.length;t<n;t++)if(createDebug.skips[t].test(e))return!1;for(t=0,n=createDebug.names.length;t<n;t++)if(createDebug.names[t].test(e))return!0;return!1},createDebug.humanize=ms,createDebug.destroy=function destroy(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")},
Object.keys(e).forEach((t=>{createDebug[t]=e[t]})),createDebug.names=[],createDebug.skips=[],createDebug.formatters={},createDebug.selectColor=function selectColor(e){let t=0;for(let n=0;n<e.length;n++)t=(t<<5)-t+e.charCodeAt(n),t|=0;return createDebug.colors[Math.abs(t)%createDebug.colors.length]},createDebug.enable(createDebug.load()),createDebug};!function(e,t){t.formatArgs=function formatArgs(t){if(t[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+t[0]+(this.useColors?"%c ":" ")+"+"+e.exports.humanize(this.diff),!this.useColors)return;const n="color: "+this.color;t.splice(1,0,n,"color: inherit");let a=0,r=0;t[0].replace(/%[a-zA-Z%]/g,(e=>{"%%"!==e&&(a++,"%c"===e&&(r=a))})),t.splice(r,0,n)},t.save=function save(e){try{e?t.storage.setItem("debug",e):t.storage.removeItem("debug")}catch(e){}},t.load=function load(){let e;try{e=t.storage.getItem("debug")}catch(e){}!e&&void 0!==_&&"env"in _&&(e=_.env.DEBUG);return e},t.useColors=function useColors(){
if("undefined"!=typeof window&&window.process&&("renderer"===window.process.type||window.process.__nwjs))return!0;if("undefined"!=typeof navigator&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/))return!1;return"undefined"!=typeof document&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||"undefined"!=typeof window&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||"undefined"!=typeof navigator&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||"undefined"!=typeof navigator&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)},t.storage=function localstorage(){try{return localStorage}catch(e){}}(),t.destroy=(()=>{let e=!1;return()=>{e||(e=!0,
console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})(),t.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"],t.log=console.debug||console.log||(()=>{}),e.exports=N(t)
;const{formatters:n}=e.exports;n.j=function(e){try{return JSON.stringify(e)}catch(e){return"[UnexpectedJSONParseError]: "+e.message}}}(A,A.exports);var L,P,O,B,U=A.exports,j="undefined"!=typeof performance&&performance,z=_.hrtime,getNanoSeconds=function(){var e=z();return 1e9*e[0]+e[1]},q=getNanoSeconds(),now=function(){return(getNanoSeconds()-q)/1e6};function throwIfEmpty(e){if(!e)throw new Error("name must be non-empty")}if(j&&j.mark&&j.getEntriesByName&&j.getEntriesByType&&j.clearMeasures)L=function(e){throwIfEmpty(e),j.mark("start "+e)},P=function(e){throwIfEmpty(e),j.mark("end "+e),j.measure(e,"start "+e,"end "+e);var t=j.getEntriesByName(e);return t[t.length-1]},O=function(){return j.getEntriesByType("measure")},B=function(){j.clearMarks(),j.clearMeasures()};else{var W={},$=[];L=function(e){throwIfEmpty(e);var t=now();W["$"+e]=t},P=function(e){throwIfEmpty(e);var t=now(),n=W["$"+e];if(!n)throw new Error("no known mark: "+e);var a={startTime:n,name:e,duration:t-n,
entryType:"measure"};return function insertSorted(e,t){for(var n,a=0,r=e.length;a<r;)e[n=a+r>>>1].startTime<t.startTime?a=n+1:r=n;e.splice(a,0,t)}($,a),a},O=function(){return $},B=function(){W={},$=[]}}const V="win32"===_.platform,H=_.browser,G={red:H?"crimson":1,yellow:H?"gold":3,cyan:H?"darkturquoise":6,green:H?"forestgreen":2,blue:H?"steelblue":4,magenta:H?"palevioletred":5};U.colors=[G.cyan,G.green,G.blue,G.magenta];const Y={};let K;class Log{static _logToStdErr(e,t){Log.loggerfn(e)(...t)}static loggerfn(e){let t=Y[e=`LH:${e}`];return t||(t=U(e),Y[e]=t,e.endsWith("error")?t.color=G.red:e.endsWith("warn")&&(t.color=G.yellow)),t}static setLevel(e){switch(K=e,e){case"silent":U.enable("-LH:*");break;case"verbose":U.enable("LH:*");break;case"warn":U.enable("-LH:*, LH:*:warn, LH:*:error");break;case"error":U.enable("-LH:*, LH:*:error");break;default:U.enable("LH:*, -LH:*:verbose")}}static formatProtocol(e,t,n){
const a=!_||_.browser?1/0:_.stdout.columns,r=t.method||"?????",o=a-r.length-e.length-25,i=t.params&&"IO.read"!==r?JSON.stringify(t.params).substr(0,o):"";Log._logToStdErr(`${e}:${n||""}`,[r,i])}static isVerbose(){return"verbose"===K}static time({msg:e,id:t,args:n=[]},a="log"){L(t),Log[a]("status",e,...n)}static timeEnd({msg:e,id:t,args:n=[]},a="verbose"){Log[a]("statusEnd",e,...n),P(t)}static log(e,...t){return Log.events.issueStatus(e,t),Log._logToStdErr(e,t)}static warn(e,...t){return Log.events.issueWarning(e,t),Log._logToStdErr(`${e}:warn`,t)}static error(e,...t){return Log._logToStdErr(`${e}:error`,t)}static verbose(e,...t){return Log.events.issueStatus(e,t),Log._logToStdErr(`${e}:verbose`,t)}static greenify(e){return`${Log.green}${e}${Log.reset}`}static redify(e){return`${Log.red}${e}${Log.reset}`}static get green(){return"[32m"}static get red(){return"[31m"}static get yellow(){return"[33m"}static get purple(){return"[95m"}static get reset(){return"[0m"}static get bold(){
return"[1m"}static get dim(){return"[2m"}static get tick(){return V?"√":"✓"}static get cross(){return V?"×":"✘"}static get whiteSmallSquare(){return V?"·":"▫"}static get heavyHorizontal(){return V?"─":"━"}static get heavyVertical(){return V?"│ ":"┃ "}static get heavyUpAndRight(){return V?"└":"┗"}static get heavyVerticalAndRight(){return V?"├":"┣"}static get heavyDownAndHorizontal(){return V?"┬":"┳"}static get doubleLightHorizontal(){return"──"}}Log.events=new class Emitter extends EventEmitter{issueStatus(e,t){"status"!==e&&"statusEnd"!==e||this.emit(e,[e,...t])}issueWarning(e,t){this.emit("warning",[e,...t])}},Log.takeTimeEntries=()=>{const e=O();return B(),e},Log.getTimeEntries=()=>O();var J={},X=Object.freeze({__proto__:null,default:J});function normalizeArray(e,t){for(var n=0,a=e.length-1;a>=0;a--){var r=e[a];"."===r?e.splice(a,1):".."===r?(e.splice(a,1),n++):n&&(e.splice(a,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}
var Z=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,splitPath=function(e){return Z.exec(e).slice(1)};function resolve(){for(var e="",t=!1,n=arguments.length-1;n>=-1&&!t;n--){var a=n>=0?arguments[n]:"/";if("string"!=typeof a)throw new TypeError("Arguments to path.resolve must be strings");a&&(e=a+"/"+e,t="/"===a.charAt(0))}return(t?"/":"")+(e=normalizeArray(filter(e.split("/"),(function(e){return!!e})),!t).join("/"))||"."}function normalize(e){var t=isAbsolute(e),n="/"===ee(e,-1);return(e=normalizeArray(filter(e.split("/"),(function(e){return!!e})),!t).join("/"))||t||(e="."),e&&n&&(e+="/"),(t?"/":"")+e}function isAbsolute(e){return"/"===e.charAt(0)}var Q={extname:function extname(e){return splitPath(e)[3]},basename:function basename(e,t){var n=splitPath(e)[2];return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n},dirname:function dirname(e){var t=splitPath(e),n=t[0],a=t[1];return n||a?(a&&(a=a.substr(0,a.length-1)),n+a):"."},sep:"/",delimiter:":",
relative:function relative(e,t){function trim(e){for(var t=0;t<e.length&&""===e[t];t++);for(var n=e.length-1;n>=0&&""===e[n];n--);return t>n?[]:e.slice(t,n-t+1)}e=resolve(e).substr(1),t=resolve(t).substr(1);for(var n=trim(e.split("/")),a=trim(t.split("/")),r=Math.min(n.length,a.length),o=r,i=0;i<r;i++)if(n[i]!==a[i]){o=i;break}var s=[];for(i=o;i<n.length;i++)s.push("..");return(s=s.concat(a.slice(o))).join("/")},join:function join(){var e=Array.prototype.slice.call(arguments,0);return normalize(filter(e,(function(e,t){if("string"!=typeof e)throw new TypeError("Arguments to path.join must be strings");return e})).join("/"))},isAbsolute,normalize,resolve};function filter(e,t){if(e.filter)return e.filter(t);for(var n=[],a=0;a<e.length;a++)t(e[a],a,e)&&n.push(e[a]);return n}var ee="b"==="ab".substr(-1)?function(e,t,n){return e.substr(t,n)}:function(e,t,n){return t<0&&(t=e.length+t),e.substr(t,n)};var te=function listCacheClear$1(){this.__data__=[],this.size=0};var ne=function eq$2(e,t){
return e===t||e!=e&&t!=t},ae=ne;var re=function assocIndexOf$4(e,t){for(var n=e.length;n--;)if(ae(e[n][0],t))return n;return-1},oe=re,ie=Array.prototype.splice;var se=re;var ce=re;var le=re;var ue=te,de=function listCacheDelete$1(e){var t=this.__data__,n=oe(t,e);return!(n<0)&&(n==t.length-1?t.pop():ie.call(t,n,1),--this.size,!0)},me=function listCacheGet$1(e){var t=this.__data__,n=se(t,e);return n<0?void 0:t[n][1]},pe=function listCacheHas$1(e){return ce(this.__data__,e)>-1},ge=function listCacheSet$1(e,t){var n=this.__data__,a=le(n,e);return a<0?(++this.size,n.push([e,t])):n[a][1]=t,this};function ListCache$4(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var a=e[t];this.set(a[0],a[1])}}ListCache$4.prototype.clear=ue,ListCache$4.prototype.delete=de,ListCache$4.prototype.get=me,ListCache$4.prototype.has=pe,ListCache$4.prototype.set=ge;var he=ListCache$4,fe=he;var ye=function stackClear$1(){this.__data__=new fe,this.size=0};var be=function stackDelete$1(e){
var t=this.__data__,n=t.delete(e);return this.size=t.size,n};var ve=function stackGet$1(e){return this.__data__.get(e)};var we=function stackHas$1(e){return this.__data__.has(e)},De="object"==typeof e&&e&&e.Object===Object&&e,Ee=De,Te="object"==typeof self&&self&&self.Object===Object&&self,Ce=Ee||Te||Function("return this")(),Se=Ce.Symbol,_e=Se,Ae=Object.prototype,ke=Ae.hasOwnProperty,Fe=Ae.toString,xe=_e?_e.toStringTag:void 0;var Re=function getRawTag$1(e){var t=ke.call(e,xe),n=e[xe];try{e[xe]=void 0;var a=!0}catch(e){}var r=Fe.call(e);return a&&(t?e[xe]=n:delete e[xe]),r},Ie=Object.prototype.toString;var Me=Re,Ne=function objectToString$2(e){return Ie.call(e)},Le=Se?Se.toStringTag:void 0;var Pe=function baseGetTag$4(e){return null==e?void 0===e?"[object Undefined]":"[object Null]":Le&&Le in Object(e)?Me(e):Ne(e)};var Oe=function isObject$3(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)},Be=Pe,Ue=Oe;var je,ze=function isFunction$3(e){if(!Ue(e))return!1;var t=Be(e)
;return"[object Function]"==t||"[object GeneratorFunction]"==t||"[object AsyncFunction]"==t||"[object Proxy]"==t},qe=Ce["__core-js_shared__"],We=(je=/[^.]+$/.exec(qe&&qe.keys&&qe.keys.IE_PROTO||""))?"Symbol(src)_1."+je:"";var $e=function isMasked$1(e){return!!We&&We in e},Ve=Function.prototype.toString;var He=function toSource$2(e){if(null!=e){try{return Ve.call(e)}catch(e){}try{return e+""}catch(e){}}return""},Ge=ze,Ye=$e,Ke=Oe,Je=He,Xe=/^\[object .+?Constructor\]$/,Ze=Function.prototype,Qe=Object.prototype,et=Ze.toString,tt=Qe.hasOwnProperty,nt=RegExp("^"+et.call(tt).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var at=function baseIsNative$1(e){return!(!Ke(e)||Ye(e))&&(Ge(e)?nt:Xe).test(Je(e))},rt=function getValue$1(e,t){return null==e?void 0:e[t]};var ot=function getNative$6(e,t){var n=rt(e,t);return at(n)?n:void 0},it=ot(Ce,"Map"),st=ot(Object,"create"),ct=st;var lt=function hashClear$1(){
this.__data__=ct?ct(null):{},this.size=0};var ut=function hashDelete$1(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t},dt=st,mt=Object.prototype.hasOwnProperty;var pt=function hashGet$1(e){var t=this.__data__;if(dt){var n=t[e];return"__lodash_hash_undefined__"===n?void 0:n}return mt.call(t,e)?t[e]:void 0},gt=st,ht=Object.prototype.hasOwnProperty;var ft=st;var yt=lt,bt=ut,vt=pt,wt=function hashHas$1(e){var t=this.__data__;return gt?void 0!==t[e]:ht.call(t,e)},Dt=function hashSet$1(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=ft&&void 0===t?"__lodash_hash_undefined__":t,this};function Hash$1(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var a=e[t];this.set(a[0],a[1])}}Hash$1.prototype.clear=yt,Hash$1.prototype.delete=bt,Hash$1.prototype.get=vt,Hash$1.prototype.has=wt,Hash$1.prototype.set=Dt;var Et=Hash$1,Tt=he,Ct=it;var St=function isKeyable$1(e){var t=typeof e
;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==e:null===e};var _t=function getMapData$4(e,t){var n=e.__data__;return St(t)?n["string"==typeof t?"string":"hash"]:n.map},At=_t;var kt=_t;var Ft=_t;var xt=_t;var Rt=function mapCacheClear$1(){this.size=0,this.__data__={hash:new Et,map:new(Ct||Tt),string:new Et}},It=function mapCacheDelete$1(e){var t=At(this,e).delete(e);return this.size-=t?1:0,t},Mt=function mapCacheGet$1(e){return kt(this,e).get(e)},Nt=function mapCacheHas$1(e){return Ft(this,e).has(e)},Lt=function mapCacheSet$1(e,t){var n=xt(this,e),a=n.size;return n.set(e,t),this.size+=n.size==a?0:1,this};function MapCache$2(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var a=e[t];this.set(a[0],a[1])}}MapCache$2.prototype.clear=Rt,MapCache$2.prototype.delete=It,MapCache$2.prototype.get=Mt,MapCache$2.prototype.has=Nt,MapCache$2.prototype.set=Lt;var Pt=MapCache$2,Ot=he,Bt=it,Ut=Pt;var jt=he,zt=ye,Wt=be,$t=ve,Vt=we,Ht=function stackSet$1(e,t){
var n=this.__data__;if(n instanceof Ot){var a=n.__data__;if(!Bt||a.length<199)return a.push([e,t]),this.size=++n.size,this;n=this.__data__=new Ut(a)}return n.set(e,t),this.size=n.size,this};function Stack$1(e){var t=this.__data__=new jt(e);this.size=t.size}Stack$1.prototype.clear=zt,Stack$1.prototype.delete=Wt,Stack$1.prototype.get=$t,Stack$1.prototype.has=Vt,Stack$1.prototype.set=Ht;var Gt=Stack$1;var Yt=Pt,Kt=function setCacheAdd$1(e){return this.__data__.set(e,"__lodash_hash_undefined__"),this},Jt=function setCacheHas$1(e){return this.__data__.has(e)};function SetCache$1(e){var t=-1,n=null==e?0:e.length;for(this.__data__=new Yt;++t<n;)this.add(e[t])}SetCache$1.prototype.add=SetCache$1.prototype.push=Kt,SetCache$1.prototype.has=Jt;var Xt=SetCache$1,Zt=function arraySome$1(e,t){for(var n=-1,a=null==e?0:e.length;++n<a;)if(t(e[n],n,e))return!0;return!1},Qt=function cacheHas$1(e,t){return e.has(t)};var en=function equalArrays$2(e,t,n,a,r,o){var i=1&n,s=e.length,c=t.length
;if(s!=c&&!(i&&c>s))return!1;var l=o.get(e),u=o.get(t);if(l&&u)return l==t&&u==e;var d=-1,m=!0,p=2&n?new Xt:void 0;for(o.set(e,t),o.set(t,e);++d<s;){var h=e[d],f=t[d];if(a)var y=i?a(f,h,d,t,e,o):a(h,f,d,e,t,o);if(void 0!==y){if(y)continue;m=!1;break}if(p){if(!Zt(t,(function(e,t){if(!Qt(p,t)&&(h===e||r(h,e,n,a,o)))return p.push(t)}))){m=!1;break}}else if(h!==f&&!r(h,f,n,a,o)){m=!1;break}}return o.delete(e),o.delete(t),m};var tn=Ce.Uint8Array,nn=ne,an=en,rn=function mapToArray$1(e){var t=-1,n=Array(e.size);return e.forEach((function(e,a){n[++t]=[a,e]})),n},on=function setToArray$1(e){var t=-1,n=Array(e.size);return e.forEach((function(e){n[++t]=e})),n},sn=Se?Se.prototype:void 0,cn=sn?sn.valueOf:void 0;var ln=function equalByTag$1(e,t,n,a,r,o,i){switch(n){case"[object DataView]":if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case"[object ArrayBuffer]":return!(e.byteLength!=t.byteLength||!o(new tn(e),new tn(t)));case"[object Boolean]":
case"[object Date]":case"[object Number]":return nn(+e,+t);case"[object Error]":return e.name==t.name&&e.message==t.message;case"[object RegExp]":case"[object String]":return e==t+"";case"[object Map]":var s=rn;case"[object Set]":var c=1&a;if(s||(s=on),e.size!=t.size&&!c)return!1;var l=i.get(e);if(l)return l==t;a|=2,i.set(e,t);var u=an(s(e),s(t),a,r,o,i);return i.delete(e),u;case"[object Symbol]":if(cn)return cn.call(e)==cn.call(t)}return!1};var un=function arrayPush$1(e,t){for(var n=-1,a=t.length,r=e.length;++n<a;)e[r+n]=t[n];return e},dn=Array.isArray,mn=un,pn=dn;var gn=function baseGetAllKeys$1(e,t,n){var a=t(e);return pn(e)?a:mn(a,n(e))};var hn=function arrayFilter$1(e,t){for(var n=-1,a=null==e?0:e.length,r=0,o=[];++n<a;){var i=e[n];t(i,n,e)&&(o[r++]=i)}return o},fn=function stubArray$1(){return[]},yn=Object.prototype.propertyIsEnumerable,bn=Object.getOwnPropertySymbols,vn=bn?function(e){return null==e?[]:(e=Object(e),hn(bn(e),(function(t){return yn.call(e,t)})))}:fn
;var wn=function baseTimes$1(e,t){for(var n=-1,a=Array(e);++n<e;)a[n]=t(n);return a};var Dn=function isObjectLike$4(e){return null!=e&&"object"==typeof e},En=Pe,Tn=Dn;var Cn=function baseIsArguments$1(e){return Tn(e)&&"[object Arguments]"==En(e)},Sn=Dn,_n=Object.prototype,An=_n.hasOwnProperty,kn=_n.propertyIsEnumerable,Fn=Cn(function(){return arguments}())?Cn:function(e){return Sn(e)&&An.call(e,"callee")&&!kn.call(e,"callee")},xn={exports:{}};var Rn=function stubFalse(){return!1};!function(e,t){var n=Ce,a=Rn,r=t&&!t.nodeType&&t,o=r&&e&&!e.nodeType&&e,i=o&&o.exports===r?n.Buffer:void 0,s=(i?i.isBuffer:void 0)||a;e.exports=s}(xn,xn.exports);var In=/^(?:0|[1-9]\d*)$/;var Mn=function isIndex$1(e,t){var n=typeof e;return!!(t=null==t?9007199254740991:t)&&("number"==n||"symbol"!=n&&In.test(e))&&e>-1&&e%1==0&&e<t};var Nn=function isLength$2(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=9007199254740991},Ln=Pe,Pn=Nn,On=Dn,Bn={}
;Bn["[object Float32Array]"]=Bn["[object Float64Array]"]=Bn["[object Int8Array]"]=Bn["[object Int16Array]"]=Bn["[object Int32Array]"]=Bn["[object Uint8Array]"]=Bn["[object Uint8ClampedArray]"]=Bn["[object Uint16Array]"]=Bn["[object Uint32Array]"]=!0,Bn["[object Arguments]"]=Bn["[object Array]"]=Bn["[object ArrayBuffer]"]=Bn["[object Boolean]"]=Bn["[object DataView]"]=Bn["[object Date]"]=Bn["[object Error]"]=Bn["[object Function]"]=Bn["[object Map]"]=Bn["[object Number]"]=Bn["[object Object]"]=Bn["[object RegExp]"]=Bn["[object Set]"]=Bn["[object String]"]=Bn["[object WeakMap]"]=!1;var Un=function baseIsTypedArray$1(e){return On(e)&&Pn(e.length)&&!!Bn[Ln(e)]};var jn=function baseUnary$1(e){return function(t){return e(t)}},zn={exports:{}};!function(e,t){var n=De,a=t&&!t.nodeType&&t,r=a&&e&&!e.nodeType&&e,o=r&&r.exports===a&&n.process,i=function(){try{var e=r&&r.require&&r.require("util").types;return e||o&&o.binding&&o.binding("util")}catch(e){}}();e.exports=i}(zn,zn.exports)
;var qn=Un,Wn=jn,$n=zn.exports,Vn=$n&&$n.isTypedArray,Hn=Vn?Wn(Vn):qn,Gn=wn,Yn=Fn,Kn=dn,Jn=xn.exports,Xn=Mn,Zn=Hn,Qn=Object.prototype.hasOwnProperty;var ea=function arrayLikeKeys$1(e,t){var n=Kn(e),a=!n&&Yn(e),r=!n&&!a&&Jn(e),o=!n&&!a&&!r&&Zn(e),i=n||a||r||o,s=i?Gn(e.length,String):[],c=s.length;for(var l in e)!t&&!Qn.call(e,l)||i&&("length"==l||r&&("offset"==l||"parent"==l)||o&&("buffer"==l||"byteLength"==l||"byteOffset"==l)||Xn(l,c))||s.push(l);return s},ta=Object.prototype;var na=function isPrototype$1(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||ta)};var aa=function overArg$1(e,t){return function(n){return e(t(n))}}(Object.keys,Object),ra=na,oa=aa,ia=Object.prototype.hasOwnProperty;var sa=ze,ca=Nn;var la=ea,ua=function baseKeys$1(e){if(!ra(e))return oa(e);var t=[];for(var n in Object(e))ia.call(e,n)&&"constructor"!=n&&t.push(n);return t},da=function isArrayLike$1(e){return null!=e&&ca(e.length)&&!sa(e)};var ma=gn,pa=vn,ga=function keys$2(e){
return da(e)?la(e):ua(e)};var ha=function getAllKeys$1(e){return ma(e,ga,pa)},fa=Object.prototype.hasOwnProperty;var ya=function equalObjects$1(e,t,n,a,r,o){var i=1&n,s=ha(e),c=s.length;if(c!=ha(t).length&&!i)return!1;for(var l=c;l--;){var u=s[l];if(!(i?u in t:fa.call(t,u)))return!1}var d=o.get(e),m=o.get(t);if(d&&m)return d==t&&m==e;var p=!0;o.set(e,t),o.set(t,e);for(var h=i;++l<c;){var f=e[u=s[l]],y=t[u];if(a)var b=i?a(y,f,u,t,e,o):a(f,y,u,e,t,o);if(!(void 0===b?f===y||r(f,y,n,a,o):b)){p=!1;break}h||(h="constructor"==u)}if(p&&!h){var v=e.constructor,w=t.constructor;v==w||!("constructor"in e)||!("constructor"in t)||"function"==typeof v&&v instanceof v&&"function"==typeof w&&w instanceof w||(p=!1)}return o.delete(e),o.delete(t),p},ba=ot(Ce,"DataView"),va=it,wa=ot(Ce,"Promise"),Da=ot(Ce,"Set"),Ea=ot(Ce,"WeakMap"),Ta=Pe,Ca=He,Sa="[object Map]",_a="[object Promise]",Aa="[object Set]",ka="[object WeakMap]",Fa="[object DataView]",xa=Ca(ba),Ra=Ca(va),Ia=Ca(wa),Ma=Ca(Da),Na=Ca(Ea),La=Ta
;(ba&&La(new ba(new ArrayBuffer(1)))!=Fa||va&&La(new va)!=Sa||wa&&La(wa.resolve())!=_a||Da&&La(new Da)!=Aa||Ea&&La(new Ea)!=ka)&&(La=function(e){var t=Ta(e),n="[object Object]"==t?e.constructor:void 0,a=n?Ca(n):"";if(a)switch(a){case xa:return Fa;case Ra:return Sa;case Ia:return _a;case Ma:return Aa;case Na:return ka}return t});var Pa=Gt,Oa=en,Ba=ln,Ua=ya,ja=La,za=dn,qa=xn.exports,Wa=Hn,$a="[object Arguments]",Va="[object Array]",Ha="[object Object]",Ga=Object.prototype.hasOwnProperty;var Ya=function baseIsEqualDeep$1(e,t,n,a,r,o){var i=za(e),s=za(t),c=i?Va:ja(e),l=s?Va:ja(t),u=(c=c==$a?Ha:c)==Ha,d=(l=l==$a?Ha:l)==Ha,m=c==l;if(m&&qa(e)){if(!qa(t))return!1;i=!0,u=!1}if(m&&!u)return o||(o=new Pa),i||Wa(e)?Oa(e,t,n,a,r,o):Ba(e,t,c,n,a,r,o);if(!(1&n)){var p=u&&Ga.call(e,"__wrapped__"),h=d&&Ga.call(t,"__wrapped__");if(p||h){var f=p?e.value():e,y=h?t.value():t;return o||(o=new Pa),r(f,y,n,a,o)}}return!!m&&(o||(o=new Pa),Ua(e,t,n,a,r,o))},Ka=Dn;var Ja=function baseIsEqual$1(e,t,n,a,r){
return e===t||(null==e||null==t||!Ka(e)&&!Ka(t)?e!=e&&t!=t:Ya(e,t,n,a,baseIsEqual$1,r))};var Xa=function isEqual(e,t){return Ja(e,t)};
/**
   * @license Copyright 2020 Google Inc. All Rights Reserved.
   * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
   * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
   */class Fetcher{constructor(e){this.session=e}async fetchResource(e,t={timeout:2e3}){return globalThis.isLightrider?this._wrapWithTimeout(this._fetchWithFetchApi(e),t.timeout):this._fetchResourceOverProtocol(e,t)}async _fetchWithFetchApi(e){const t=await fetch(e);let n=null;try{n=await t.text()}catch{}return{content:n,status:t.status}}async _readIOStream(e,t={timeout:2e3}){const n=Date.now();let a,r="";for(;!a||!a.eof;){if(Date.now()-n>t.timeout)throw new Error("Waiting for the end of the IO stream exceeded the allotted time.");a=await this.session.sendCommand("IO.read",{handle:e});const o=a.base64Encoded?Buffer.from(a.data,"base64").toString("utf-8"):a.data;r=r.concat(o)}return r}async _loadNetworkResource(e){const t=await this.session.sendCommand("Page.getFrameTree"),n=await this.session.sendCommand("Network.loadNetworkResource",{frameId:t.frameTree.frame.id,url:e,options:{disableCache:!0,includeCredentials:!0}});return{stream:n.resource.success&&n.resource.stream||null,
status:n.resource.httpStatusCode||null}}async _fetchResourceOverProtocol(e,t){const n=Date.now(),a=await this._wrapWithTimeout(this._loadNetworkResource(e),t.timeout),r=a.status&&a.status>=200&&a.status<=299;if(!a.stream||!r)return{status:a.status,content:null};const o=t.timeout-(Date.now()-n),i=await this._readIOStream(a.stream,{timeout:o});return{status:a.status,content:i}}async _wrapWithTimeout(e,t){let n;const a=new Promise(((e,a)=>{n=setTimeout(a,t,new Error("Timed out fetching resource"))}));return await Promise.race([e,a]).finally((()=>clearTimeout(n)))}}const Za="…",Qa={PASS:{label:"pass",minScore:.9},AVERAGE:{label:"average",minScore:.5},FAIL:{label:"fail"},ERROR:{label:"error"}},er=["com","co","gov","edu","ac","org","go","gob","or","net","in","ne","nic","gouv","web","spb","blog","jus","kiev","mil","wi","qc","ca","bel","on"];class Util{static get RATINGS(){return Qa}static get PASS_THRESHOLD(){return.9}static get MS_DISPLAY_VALUE(){return"%10d ms"}
static getFinalDisplayedUrl(e){if(e.finalDisplayedUrl)return e.finalDisplayedUrl;if(e.finalUrl)return e.finalUrl;throw new Error("Could not determine final displayed URL")}static getMainDocumentUrl(e){return e.mainDocumentUrl||e.finalUrl}static getFullPageScreenshot(e){if(e.fullPageScreenshot)return e.fullPageScreenshot;return e.audits["full-page-screenshot"]?.details}static splitMarkdownCodeSpans(e){const t=[],n=e.split(/`(.*?)`/g);for(let e=0;e<n.length;e++){const a=n[e];if(!a)continue;const r=e%2!=0;t.push({isCode:r,text:a})}return t}static splitMarkdownLink(e){const t=[],n=e.split(/\[([^\]]+?)\]\((https?:\/\/.*?)\)/g);for(;n.length;){const[e,a,r]=n.splice(0,3);e&&t.push({isLink:!1,text:e}),a&&r&&t.push({isLink:!0,text:a,linkHref:r})}return t}static truncate(e,t,n="…"){if(e.length<=t)return e;const a=new Intl.Segmenter(void 0,{granularity:"grapheme"}).segment(e)[Symbol.iterator]();let r=0;for(let o=0;o<=t-n.length;o++){const t=a.next();if(t.done)return e;r=t.value.index}
for(let t=0;t<n.length;t++)if(a.next().done)return e;return e.slice(0,r)+n}static getURLDisplayName(e,t){const n=void 0!==(t=t||{numPathParts:void 0,preserveQuery:void 0,preserveHost:void 0}).numPathParts?t.numPathParts:2,a=void 0===t.preserveQuery||t.preserveQuery,r=t.preserveHost||!1;let o;if("about:"===e.protocol||"data:"===e.protocol)o=e.href;else{o=e.pathname;const t=o.split("/").filter((e=>e.length));n&&t.length>n&&(o=Za+t.slice(-1*n).join("/")),r&&(o=`${e.host}/${o.replace(/^\//,"")}`),a&&(o=`${o}${e.search}`)}if("data:"!==e.protocol&&(o=o.slice(0,200),o=o.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,"$1…"),o=o.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,"$1…"),o=o.replace(/(\d{3})\d{6,}/g,"$1…"),o=o.replace(/\u2026+/g,Za),o.length>64&&o.includes("?")&&(o=o.replace(/\?([^=]*)(=)?.*/,"?$1$2…"),o.length>64&&(o=o.replace(/\?.*/,"?…")))),o.length>64){const e=o.lastIndexOf(".");o=e>=0?o.slice(0,63-(o.length-e))+`…${o.slice(e)}`:o.slice(0,63)+Za}
return o}static getChromeExtensionOrigin(e){const t=new URL(e);return t.protocol+"//"+t.host}static parseURL(e){const t=new URL(e);return{file:Util.getURLDisplayName(t),hostname:t.hostname,origin:"chrome-extension:"===t.protocol?Util.getChromeExtensionOrigin(e):t.origin}}static createOrReturnURL(e){return e instanceof URL?e:new URL(e)}static getTld(e){const t=e.split(".").slice(-2);return er.includes(t[0])?`.${t.join(".")}`:`.${t[t.length-1]}`}static getRootDomain(e){const t=Util.createOrReturnURL(e).hostname,n=Util.getTld(t).split(".");return t.split(".").slice(-n.length).join(".")}static filterRelevantLines(e,t,n){if(0===t.length)return e.slice(0,2*n+1);const a=new Set;return(t=t.sort(((e,t)=>(e.lineNumber||0)-(t.lineNumber||0)))).forEach((({lineNumber:e})=>{let t=e-n,r=e+n;for(;t<1;)t++,r++;a.has(t-3-1)&&(t-=3);for(let e=t;e<=r;e++){const t=e;a.add(t)}})),e.filter((e=>a.has(e.lineNumber)))}}function getElementsInDocument(e){
const t=window.__ElementMatches||window.Element.prototype.matches,n=[],_findAllElements=a=>{for(const r of a){if(!e||t.call(r,e)){const e=r;n.push(e)}r.shadowRoot&&_findAllElements(r.shadowRoot.querySelectorAll("*"))}};return _findAllElements(document.querySelectorAll("*")),n}function getOuterHTMLSnippet(e,t=[],n=500){const a=["autofill-information","autofill-prediction","title"];e instanceof ShadowRoot&&(e=e.host);try{const r=e.cloneNode();e.ownerDocument.createElement("template").content.append(r),t.concat(a).forEach((e=>{r.removeAttribute(e)}));let o=0;for(const t of r.getAttributeNames()){if(o>n){r.removeAttribute(t);continue}let a=r.getAttribute(t);if(null===a)continue;let i=!1;if("src"===t&&"currentSrc"in e){const t=e,n=t.currentSrc,r=t.ownerDocument.location.href;new URL(a,r).toString()!==n&&(a=n,i=!0)}const s=truncate(a,75);if(s!==a&&(i=!0),a=s,i)if("style"===t){r.style.cssText=a}else r.setAttribute(t,a);o+=t.length+a.length}const i=/^[\s\S]*?>/,[s]=r.outerHTML.match(i)||[]
;return s&&o>n?s.slice(0,s.length-1)+" …>":s||""}catch(t){return`<${e.localName}>`}}function getNodePath(e){const isShadowRoot=e=>e.nodeType===Node.DOCUMENT_FRAGMENT_NODE,getNodeParent=e=>isShadowRoot(e)?e.host:e.parentNode;function getNodeIndex(e){if(isShadowRoot(e))return"a";let t,n=0;for(;t=e.previousSibling;)(e=t).nodeType===Node.TEXT_NODE&&0===(e.nodeValue||"").trim().length||n++;return n}let t=e;const n=[];for(;t&&getNodeParent(t);){const e=getNodeIndex(t);n.push([e,t.nodeName]),t=getNodeParent(t)}return n.reverse(),n.join(",")}function getNodeSelector(e){function getSelectorPart(e){let t=e.tagName.toLowerCase();return e.id?t+="#"+e.id:e.classList.length>0&&(t+="."+e.classList[0]),t}const t=[];for(;t.length<4&&(t.unshift(getSelectorPart(e)),e.parentElement)&&"HTML"!==(e=e.parentElement).tagName;);return t.join(" > ")}function isPositionFixed(e){function getStyleAttrValue(e,t){return e.style[t]||window.getComputedStyle(e)[t]}const t=document.querySelector("html")
;if(!t)throw new Error("html element not found in document");if(t.scrollHeight<=t.clientHeight||!["scroll","auto","visible"].includes(getStyleAttrValue(t,"overflowY")))return!1;let n=e;for(;n;){const e=getStyleAttrValue(n,"position");if("fixed"===e||"sticky"===e)return!0;n=n.parentElement}return!1}function getNodeLabel(e){const t=e.tagName.toLowerCase();if("html"!==t&&"body"!==t){const t=e instanceof HTMLElement&&e.innerText||e.getAttribute("alt")||e.getAttribute("aria-label");if(t)return truncate(t,80);{const t=e.querySelector("[alt], [aria-label]");if(t)return getNodeLabel(t)}}return null}function getBoundingClientRect(e){const t=(window.__HTMLElementBoundingClientRect||window.HTMLElement.prototype.getBoundingClientRect).call(e);return{top:Math.round(t.top),bottom:Math.round(t.bottom),left:Math.round(t.left),right:Math.round(t.right),width:Math.round(t.width),height:Math.round(t.height)}}function getNodeDetails(e){
window.__lighthouseNodesDontTouchOrAllVarianceGoesAway||(window.__lighthouseNodesDontTouchOrAllVarianceGoesAway=new Map);const t=getNodeSelector(e=e instanceof ShadowRoot?e.host:e);let n=window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.get(e);n||(n=[void 0===window.__lighthouseExecutionContextUniqueIdentifier?"page":window.__lighthouseExecutionContextUniqueIdentifier,window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.size,e.tagName].join("-"),window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.set(e,n));return{lhId:n,devtoolsNodePath:getNodePath(e),selector:t,boundingRect:getBoundingClientRect(e),snippet:getOuterHTMLSnippet(e),nodeLabel:getNodeLabel(e)||t}}function truncate(e,t){return Util.truncate(e,t)}const tr=truncate.toString();truncate.toString=()=>`function truncate(string, characterLimit) {\n  const Util = { ${Util.truncate} };\n  return (${tr})(string, characterLimit);\n}`;const nr=getNodeLabel.toString()
;getNodeLabel.toString=()=>`function getNodeLabel(element) {\n  ${truncate};\n  return (${nr})(element);\n}`;const ar=getOuterHTMLSnippet.toString();getOuterHTMLSnippet.toString=()=>`function getOuterHTMLSnippet(element, ignoreAttrs = [], snippetCharacterLimit = 500) {\n  ${truncate};\n  return (${ar})(element, ignoreAttrs, snippetCharacterLimit);\n}`;const rr=getNodeDetails.toString();getNodeDetails.toString=()=>`function getNodeDetails(element) {\n  ${truncate};\n  ${getNodePath};\n  ${getNodeSelector};\n  ${getBoundingClientRect};\n  ${ar};\n  ${nr};\n  return (${rr})(element);\n}`;const or={wrapRuntimeEvalErrorInBrowser:function wrapRuntimeEvalErrorInBrowser(e){return e&&"string"!=typeof e||(e=new Error(e)),{__failedInBrowser:!0,name:e.name||"Error",message:e.message||"unknown error",stack:e.stack}},getElementsInDocument,getOuterHTMLSnippet,computeBenchmarkIndex:function computeBenchmarkIndex(){return(function benchmarkIndexGC(){const e=Date.now();let t=0;for(;Date.now()-e<500;){
let e="";for(let t=0;t<1e4;t++)e+="a";if(1===e.length)throw new Error("will never happen, but prevents compiler optimizations");t++}const n=(Date.now()-e)/1e3;return Math.round(t/10/n)}()+function benchmarkIndexNoGC(){const e=[],t=[];for(let n=0;n<1e5;n++)e[n]=t[n]=n;const n=Date.now();let a=0;for(;a%10!=0||Date.now()-n<500;){const n=a%2==0?e:t,r=a%2==0?t:e;for(let e=0;e<n.length;e++)r[e]=n[e];a++}const r=(Date.now()-n)/1e3;return Math.round(a/10/r)}())/2},getNodeDetails,getNodePath,getNodeSelector,getNodeLabel,isPositionFixed,wrapRequestIdleCallback:function wrapRequestIdleCallback(e){const t=Math.floor(40/e),n=window.requestIdleCallback;window.requestIdleCallback=(e,a)=>n((n=>{const a=Date.now();n.__timeRemaining=n.timeRemaining,n.timeRemaining=()=>{const e=n.__timeRemaining();return Math.min(e,Math.max(0,t-(Date.now()-a)))},n.timeRemaining.toString=()=>"function timeRemaining() { [native code] }",e(n)}),a),
window.requestIdleCallback.toString=()=>"function requestIdleCallback() { [native code] }"},getBoundingClientRect,truncate};class ExecutionContext{constructor(e){this._session=e,this._executionContextId=void 0,this._executionContextIdentifiersCreated=0,e.on("Page.frameNavigated",(()=>this.clearContextId())),e.on("Runtime.executionContextDestroyed",(e=>{e.executionContextId===this._executionContextId&&this.clearContextId()}))}getContextId(){return this._executionContextId}clearContextId(){this._executionContextId=void 0}async _getOrCreateIsolatedContextId(){if("number"==typeof this._executionContextId)return this._executionContextId;await this._session.sendCommand("Page.enable"),await this._session.sendCommand("Runtime.enable");const e=(await this._session.sendCommand("Page.getFrameTree")).frameTree.frame.id,t=await this._session.sendCommand("Page.createIsolatedWorld",{frameId:e,worldName:"lighthouse_isolated_context"});return this._executionContextId=t.executionContextId,
this._executionContextIdentifiersCreated++,t.executionContextId}async _evaluateInContext(e,t){const n=this._session.hasNextProtocolTimeout()?this._session.getNextProtocolTimeout():6e4,a=void 0===t?void 0:this._executionContextIdentifiersCreated,r={expression:`(function wrapInNativePromise() {\n        ${ExecutionContext._cachedNativesPreamble};\n        globalThis.__lighthouseExecutionContextUniqueIdentifier =\n          ${a};\n        return new Promise(function (resolve) {\n          return Promise.resolve()\n            .then(_ => ${e})\n            .catch(${or.wrapRuntimeEvalErrorInBrowser})\n            .then(resolve);\n        });\n      }())\n      //# sourceURL=_lighthouse-eval.js`,includeCommandLineAPI:!0,awaitPromise:!0,returnByValue:!0,timeout:n,contextId:t};this._session.setNextProtocolTimeout(n);const o=await this._session.sendCommand("Runtime.evaluate",r),i=o.exceptionDetails;if(i){
const t=["Runtime.evaluate exception",`Expression: ${e.replace(/\s+/g," ").substring(0,100)}\n---- (elided)`,i.stackTrace?null:`Parse error at: ${i.lineNumber+1}:${i.columnNumber+1}`,i.exception?.description||i.text].filter(Boolean),n=new Error(t.join("\n"));return Promise.reject(n)}if(void 0===o.result)return Promise.reject(new Error('Runtime.evaluate response did not contain a "result" object'));const s=o.result.value;return s?.__failedInBrowser?Promise.reject(Object.assign(new Error,s)):s}async evaluateAsync(e,t={}){const n=t.useIsolation?await this._getOrCreateIsolatedContextId():void 0;try{return await this._evaluateInContext(e,n)}catch(t){if(n&&t.message.includes("Cannot find context")){this.clearContextId();const t=await this._getOrCreateIsolatedContextId();return this._evaluateInContext(e,t)}throw t}}evaluate(e,t){const n=ExecutionContext.serializeArguments(t.args),a=`(() => {\n      ${t.deps?t.deps.join("\n"):""}\n      return (${e})(${n});\n    })()`
;return this.evaluateAsync(a,t)}async evaluateOnNewDocument(e,t){const n=ExecutionContext.serializeArguments(t.args),a=t.deps?t.deps.join("\n"):"",r=`(() => {\n      ${ExecutionContext._cachedNativesPreamble};\n      ${a};\n      (${e})(${n});\n    })()\n    //# sourceURL=_lighthouse-eval.js`;await this._session.sendCommand("Page.addScriptToEvaluateOnNewDocument",{source:r})}async cacheNativesOnNewDocument(){await this.evaluateOnNewDocument((()=>{window.__nativePromise=window.Promise,window.__nativeURL=window.URL,window.__nativePerformance=window.performance,window.__nativeFetch=window.fetch,window.__ElementMatches=window.Element.prototype.matches,window.__HTMLElementBoundingClientRect=window.HTMLElement.prototype.getBoundingClientRect}),{args:[]})}
static _cachedNativesPreamble=["const Promise = globalThis.__nativePromise || globalThis.Promise","const URL = globalThis.__nativeURL || globalThis.URL","const performance = globalThis.__nativePerformance || globalThis.performance","const fetch = globalThis.__nativeFetch || globalThis.fetch"].join(";\n");static serializeArguments(e){return e.map((e=>void 0===e?"undefined":JSON.stringify(e))).join(",")}}var ir,sr={URL:globalThis.URL,fileURLToPath:e=>e},cr=function(){function peg$SyntaxError(e,t,n,a){this.message=e,this.expected=t,this.found=n,this.location=a,this.name="SyntaxError","function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,peg$SyntaxError)}return function peg$subclass(e,t){function ctor(){this.constructor=e}ctor.prototype=t.prototype,e.prototype=new ctor}(peg$SyntaxError,Error),peg$SyntaxError.buildMessage=function(e,t){var n={literal:function(e){return'"'+literalEscape(e.text)+'"'},class:function(e){var t,n=""
;for(t=0;t<e.parts.length;t++)n+=e.parts[t]instanceof Array?classEscape(e.parts[t][0])+"-"+classEscape(e.parts[t][1]):classEscape(e.parts[t]);return"["+(e.inverted?"^":"")+n+"]"},any:function(e){return"any character"},end:function(e){return"end of input"},other:function(e){return e.description}};function hex(e){return e.charCodeAt(0).toString(16).toUpperCase()}function literalEscape(e){return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,(function(e){return"\\x0"+hex(e)})).replace(/[\x10-\x1F\x7F-\x9F]/g,(function(e){return"\\x"+hex(e)}))}function classEscape(e){return e.replace(/\\/g,"\\\\").replace(/\]/g,"\\]").replace(/\^/g,"\\^").replace(/-/g,"\\-").replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,(function(e){return"\\x0"+hex(e)})).replace(/[\x10-\x1F\x7F-\x9F]/g,(function(e){return"\\x"+hex(e)}))}
return"Expected "+function describeExpected(e){var t,a,r,o=new Array(e.length);for(t=0;t<e.length;t++)o[t]=(r=e[t],n[r.type](r));if(o.sort(),o.length>0){for(t=1,a=1;t<o.length;t++)o[t-1]!==o[t]&&(o[a]=o[t],a++);o.length=a}switch(o.length){case 1:return o[0];case 2:return o[0]+" or "+o[1];default:return o.slice(0,-1).join(", ")+", or "+o[o.length-1]}}(e)+" but "+function describeFound(e){return e?'"'+literalEscape(e)+'"':"end of input"}(t)+" found."},{SyntaxError:peg$SyntaxError,parse:function peg$parse(e,t){t=void 0!==t?t:{};var n,a={},r={start:peg$parsestart},o=peg$parsestart,peg$c3=function(e){return e.join("")
},i=peg$literalExpectation("{",!1),s=",",c=peg$literalExpectation(",",!1),l=peg$literalExpectation("}",!1),u="number",d=peg$literalExpectation("number",!1),m="date",p=peg$literalExpectation("date",!1),h="time",f=peg$literalExpectation("time",!1),y="plural",b=peg$literalExpectation("plural",!1),v="selectordinal",w=peg$literalExpectation("selectordinal",!1),D="select",E=peg$literalExpectation("select",!1),T=peg$literalExpectation("=",!1),C="offset:",S=peg$literalExpectation("offset:",!1),_=peg$otherExpectation("whitespace"),A=/^[ \t\n\r]/,k=peg$classExpectation([" ","\t","\n","\r"],!1,!1),F=peg$otherExpectation("optionalWhitespace"),x=/^[0-9]/,R=peg$classExpectation([["0","9"]],!1,!1),I=/^[0-9a-f]/i,M=peg$classExpectation([["0","9"],["a","f"]],!1,!0),N=peg$literalExpectation("0",!1),L=/^[1-9]/,P=peg$classExpectation([["1","9"]],!1,!1),O="'",B=peg$literalExpectation("'",!1),U=/^[ \t\n\r,.+={}#]/,j=peg$classExpectation([" ","\t","\n","\r",",",".","+","=","{","}","#"],!1,!1),z={type:"any"
},q=/^[^{}\\\0-\x1F\x7F \t\n\r]/,W=peg$classExpectation(["{","}","\\",["\0",""],""," ","\t","\n","\r"],!0,!1),$=peg$literalExpectation("\\\\",!1),V=peg$literalExpectation("\\#",!1),H=peg$literalExpectation("\\{",!1),G=peg$literalExpectation("\\}",!1),Y=peg$literalExpectation("\\u",!1),K=0,J=0,X=[{line:1,column:1}],Z=0,Q=[],ee=0;if("startRule"in t){if(!(t.startRule in r))throw new Error("Can't start parsing from rule \""+t.startRule+'".');o=r[t.startRule]}function location(){return peg$computeLocation(J,K)}function peg$literalExpectation(e,t){return{type:"literal",text:e,ignoreCase:t}}function peg$classExpectation(e,t,n){return{type:"class",parts:e,inverted:t,ignoreCase:n}}function peg$otherExpectation(e){return{type:"other",description:e}}function peg$computePosDetails(t){var n,a=X[t];if(a)return a;for(n=t-1;!X[n];)n--;for(a={line:(a=X[n]).line,column:a.column};n<t;)10===e.charCodeAt(n)?(a.line++,a.column=1):a.column++,n++;return X[t]=a,a}function peg$computeLocation(e,t){
var n=peg$computePosDetails(e),a=peg$computePosDetails(t);return{start:{offset:e,line:n.line,column:n.column},end:{offset:t,line:a.line,column:a.column}}}function peg$fail(e){K<Z||(K>Z&&(Z=K,Q=[]),Q.push(e))}function peg$parsestart(){return peg$parsemessageFormatPattern()}function peg$parsemessageFormatPattern(){var e,t,n;for(e=K,t=[],n=peg$parsemessageFormatElement();n!==a;)t.push(n),n=peg$parsemessageFormatElement();return t!==a&&(J=e,t={type:"messageFormatPattern",elements:t,location:location()}),e=t}function peg$parsemessageFormatElement(){var t;return(t=function peg$parsemessageTextElement(){var t,n;t=K,(n=function peg$parsemessageText(){var t,n,r,o,i,s;t=K,n=[],r=K,(o=peg$parse_())!==a&&(i=peg$parsechars())!==a&&(s=peg$parse_())!==a?r=o=[o,i,s]:(K=r,r=a);if(r!==a)for(;r!==a;)n.push(r),r=K,(o=peg$parse_())!==a&&(i=peg$parsechars())!==a&&(s=peg$parse_())!==a?r=o=[o,i,s]:(K=r,r=a);else n=a;n!==a&&(J=t,n=n.reduce((function(e,t){return e.concat(t)}),[]).join(""));(t=n)===a&&(t=K,
t=(n=peg$parsews())!==a?e.substring(t,K):n);return t}())!==a&&(J=t,n={type:"messageTextElement",value:n,location:location()});return t=n}())===a&&(t=function peg$parseargumentElement(){var t,n,r,o,T,C,S;t=K,123===e.charCodeAt(K)?(n="{",K++):(n=a,0===ee&&peg$fail(i));n!==a&&peg$parse_()!==a&&(r=function peg$parseargument(){var e,t,n;if((e=peg$parsenumber())===a){for(e=K,t=[],n=peg$parsequoteEscapedChar();n!==a;)t.push(n),n=peg$parsequoteEscapedChar();t!==a&&(J=e,t=peg$c3(t)),e=t}return e}())!==a&&peg$parse_()!==a?(o=K,44===e.charCodeAt(K)?(T=s,K++):(T=a,0===ee&&peg$fail(c)),T!==a&&(C=peg$parse_())!==a&&(S=function peg$parseelementFormat(){var t;(t=function peg$parsesimpleFormat(){var t,n,r,o,i,l;t=K,e.substr(K,6)===u?(n=u,K+=6):(n=a,0===ee&&peg$fail(d));n===a&&(e.substr(K,4)===m?(n=m,K+=4):(n=a,0===ee&&peg$fail(p)),n===a&&(e.substr(K,4)===h?(n=h,K+=4):(n=a,0===ee&&peg$fail(f))));n!==a&&peg$parse_()!==a?(r=K,44===e.charCodeAt(K)?(o=s,K++):(o=a,0===ee&&peg$fail(c)),
o!==a&&(i=peg$parse_())!==a&&(l=peg$parsechars())!==a?r=o=[o,i,l]:(K=r,r=a),r===a&&(r=null),r!==a?(J=t,t=n={type:n+"Format",style:(y=r)&&y[2],location:location()}):(K=t,t=a)):(K=t,t=a);var y;return t}())===a&&(t=function peg$parsepluralFormat(){var t,n,r,o;t=K,e.substr(K,6)===y?(n=y,K+=6):(n=a,0===ee&&peg$fail(b));n!==a&&peg$parse_()!==a?(44===e.charCodeAt(K)?(r=s,K++):(r=a,0===ee&&peg$fail(c)),r!==a&&peg$parse_()!==a&&(o=peg$parsepluralStyle())!==a?(J=t,t=n={type:(i=o).type,ordinal:!1,offset:i.offset||0,options:i.options,location:location()}):(K=t,t=a)):(K=t,t=a);var i;return t}())===a&&(t=function peg$parseselectOrdinalFormat(){var t,n,r,o;t=K,e.substr(K,13)===v?(n=v,K+=13):(n=a,0===ee&&peg$fail(w));n!==a&&peg$parse_()!==a?(44===e.charCodeAt(K)?(r=s,K++):(r=a,0===ee&&peg$fail(c)),r!==a&&peg$parse_()!==a&&(o=peg$parsepluralStyle())!==a?(J=t,t=n={type:(i=o).type,ordinal:!0,offset:i.offset||0,options:i.options,location:location()}):(K=t,t=a)):(K=t,t=a);var i;return t
}())===a&&(t=function peg$parseselectFormat(){var t,n,r,o,i;t=K,e.substr(K,6)===D?(n=D,K+=6):(n=a,0===ee&&peg$fail(E));if(n!==a)if(peg$parse_()!==a)if(44===e.charCodeAt(K)?(r=s,K++):(r=a,0===ee&&peg$fail(c)),r!==a)if(peg$parse_()!==a){if(o=[],(i=peg$parseoptionalFormatPattern())!==a)for(;i!==a;)o.push(i),i=peg$parseoptionalFormatPattern();else o=a;o!==a?(J=t,t=n=function(e){return{type:"selectFormat",options:e,location:location()}}(o)):(K=t,t=a)}else K=t,t=a;else K=t,t=a;else K=t,t=a;else K=t,t=a;return t}());return t}())!==a?o=T=[T,C,S]:(K=o,o=a),o===a&&(o=null),o!==a&&(T=peg$parse_())!==a?(125===e.charCodeAt(K)?(C="}",K++):(C=a,0===ee&&peg$fail(l)),C!==a?(J=t,t=n=function(e,t){return{type:"argumentElement",id:e,format:t&&t[2],location:location()}}(r,o)):(K=t,t=a)):(K=t,t=a)):(K=t,t=a);return t}()),t}function peg$parseoptionalFormatPattern(){var t,n,r,o,s;return t=K,peg$parse_()!==a&&(n=function peg$parseselector(){var t,n,r,o;return t=K,n=K,61===e.charCodeAt(K)?(r="=",K++):(r=a,
0===ee&&peg$fail(T)),r!==a&&(o=peg$parsenumber())!==a?n=r=[r,o]:(K=n,n=a),(t=n!==a?e.substring(t,K):n)===a&&(t=peg$parsechars()),t}())!==a&&peg$parse_()!==a?(123===e.charCodeAt(K)?(r="{",K++):(r=a,0===ee&&peg$fail(i)),r!==a&&(o=peg$parsemessageFormatPattern())!==a?(125===e.charCodeAt(K)?(s="}",K++):(s=a,0===ee&&peg$fail(l)),s!==a?(J=t,t={type:"optionalFormatPattern",selector:n,value:o,location:location()}):(K=t,t=a)):(K=t,t=a)):(K=t,t=a),t}function peg$parsepluralStyle(){var t,n,r,o;if(t=K,(n=function peg$parseoffset(){var t,n,r;return t=K,e.substr(K,7)===C?(n=C,K+=7):(n=a,0===ee&&peg$fail(S)),n!==a&&peg$parse_()!==a&&(r=peg$parsenumber())!==a?(J=t,t=n=r):(K=t,t=a),t}())===a&&(n=null),n!==a)if(peg$parse_()!==a){if(r=[],(o=peg$parseoptionalFormatPattern())!==a)for(;o!==a;)r.push(o),o=peg$parseoptionalFormatPattern();else r=a;r!==a?(J=t,t=n=function(e,t){return{type:"pluralFormat",offset:e,options:t,location:location()}}(n,r)):(K=t,t=a)}else K=t,t=a;else K=t,t=a;return t}
function peg$parsews(){var t,n;if(ee++,t=[],A.test(e.charAt(K))?(n=e.charAt(K),K++):(n=a,0===ee&&peg$fail(k)),n!==a)for(;n!==a;)t.push(n),A.test(e.charAt(K))?(n=e.charAt(K),K++):(n=a,0===ee&&peg$fail(k));else t=a;return ee--,t===a&&(n=a,0===ee&&peg$fail(_)),t}function peg$parse_(){var t,n,r;for(ee++,t=K,n=[],r=peg$parsews();r!==a;)n.push(r),r=peg$parsews();return t=n!==a?e.substring(t,K):n,ee--,t===a&&(n=a,0===ee&&peg$fail(F)),t}function peg$parsedigit(){var t;return x.test(e.charAt(K))?(t=e.charAt(K),K++):(t=a,0===ee&&peg$fail(R)),t}function peg$parsehexDigit(){var t;return I.test(e.charAt(K))?(t=e.charAt(K),K++):(t=a,0===ee&&peg$fail(M)),t}function peg$parsenumber(){var t,n,r,o,i,s;if(t=K,48===e.charCodeAt(K)?(n="0",K++):(n=a,0===ee&&peg$fail(N)),n===a){if(n=K,r=K,L.test(e.charAt(K))?(o=e.charAt(K),K++):(o=a,0===ee&&peg$fail(P)),o!==a){for(i=[],s=peg$parsedigit();s!==a;)i.push(s),s=peg$parsedigit();i!==a?r=o=[o,i]:(K=r,r=a)}else K=r,r=a;n=r!==a?e.substring(n,K):r}return n!==a&&(J=t,
n=parseInt(n,10)),t=n}function peg$parsequoteEscapedChar(){var t,n,r;return t=K,n=K,ee++,39===e.charCodeAt(K)?(r=O,K++):(r=a,0===ee&&peg$fail(B)),r===a&&(U.test(e.charAt(K))?(r=e.charAt(K),K++):(r=a,0===ee&&peg$fail(j))),ee--,r===a?n=void 0:(K=n,n=a),n!==a?(e.length>K?(r=e.charAt(K),K++):(r=a,0===ee&&peg$fail(z)),r!==a?(J=t,t=n=r):(K=t,t=a)):(K=t,t=a),t===a&&(t=K,39===e.charCodeAt(K)?(n=O,K++):(n=a,0===ee&&peg$fail(B)),n!==a&&(r=function peg$parseescape(){var t;U.test(e.charAt(K))?(t=e.charAt(K),K++):(t=a,0===ee&&peg$fail(j));t===a&&(t=peg$parseapostrophe());return t}())!==a?(J=t,t=n=r):(K=t,t=a)),t}function peg$parseapostrophe(){var t;return 39===e.charCodeAt(K)?(t=O,K++):(t=a,0===ee&&peg$fail(B)),t}function peg$parsechar(){var t,n,r,o,i,s,c,l,u;return t=K,39===e.charCodeAt(K)?(n=O,K++):(n=a,0===ee&&peg$fail(B)),n!==a&&(r=peg$parseapostrophe())!==a?(J=t,t=n=r):(K=t,t=a),t===a&&(q.test(e.charAt(K))?(t=e.charAt(K),K++):(t=a,0===ee&&peg$fail(W)),t===a&&(t=K,
"\\\\"===e.substr(K,2)?(n="\\\\",K+=2):(n=a,0===ee&&peg$fail($)),n!==a&&(J=t,n="\\"),(t=n)===a&&(t=K,"\\#"===e.substr(K,2)?(n="\\#",K+=2):(n=a,0===ee&&peg$fail(V)),n!==a&&(J=t,n="\\#"),(t=n)===a&&(t=K,"\\{"===e.substr(K,2)?(n="\\{",K+=2):(n=a,0===ee&&peg$fail(H)),n!==a&&(J=t,n="{"),(t=n)===a&&(t=K,"\\}"===e.substr(K,2)?(n="\\}",K+=2):(n=a,0===ee&&peg$fail(G)),n!==a&&(J=t,n="}"),(t=n)===a&&(t=K,"\\u"===e.substr(K,2)?(n="\\u",K+=2):(n=a,0===ee&&peg$fail(Y)),n!==a?(r=K,o=K,(i=peg$parsehexDigit())!==a&&(s=peg$parsehexDigit())!==a&&(c=peg$parsehexDigit())!==a&&(l=peg$parsehexDigit())!==a?o=i=[i,s,c,l]:(K=o,o=a),(r=o!==a?e.substring(r,K):o)!==a?(J=t,u=r,t=n=String.fromCharCode(parseInt(u,16))):(K=t,t=a)):(K=t,t=a))))))),t}function peg$parsechars(){var e,t,n;if(e=K,t=[],(n=peg$parsechar())!==a)for(;n!==a;)t.push(n),n=peg$parsechar();else t=a;return t!==a&&(J=e,t=peg$c3(t)),e=t}if((n=o())!==a&&K===e.length)return n;throw n!==a&&K<e.length&&peg$fail({type:"end"}),
function peg$buildStructuredError(e,t,n){return new peg$SyntaxError(peg$SyntaxError.buildMessage(e,t),e,t,n)}(Q,Z<e.length?e.charAt(Z):null,Z<e.length?peg$computeLocation(Z,Z+1):peg$computeLocation(Z,Z))}}}(),lr=globalThis&&globalThis.__extends||(ir=function(e,t){return(ir=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function __(){this.constructor=e}ir(e,t),e.prototype=null===t?Object.create(t):(__.prototype=t.prototype,new __)}),ur=function(){function Compiler(e,t,n){this.locales=[],this.formats={number:{},date:{},time:{}},this.pluralNumberFormat=null,this.currentPlural=null,this.pluralStack=[],this.locales=e,this.formats=t,this.formatters=n}return Compiler.prototype.compile=function(e){return this.pluralStack=[],this.currentPlural=null,this.pluralNumberFormat=null,this.compileMessage(e)},Compiler.prototype.compileMessage=function(e){var t=this
;if(!e||"messageFormatPattern"!==e.type)throw new Error('Message AST is not of type: "messageFormatPattern"');var n=e.elements,a=n.filter((function(e){return"messageTextElement"===e.type||"argumentElement"===e.type})).map((function(e){return"messageTextElement"===e.type?t.compileMessageText(e):t.compileArgument(e)}));if(a.length!==n.length)throw new Error("Message element does not have a valid type");return a},Compiler.prototype.compileMessageText=function(e){return this.currentPlural&&/(^|[^\\])#/g.test(e.value)?(this.pluralNumberFormat||(this.pluralNumberFormat=new Intl.NumberFormat(this.locales)),new gr(this.currentPlural.id,this.currentPlural.format.offset,this.pluralNumberFormat,e.value)):e.value.replace(/\\#/g,"#")},Compiler.prototype.compileArgument=function(e){var t=e.format,n=e.id,a=this.formatters;if(!t)return new mr(n);var r=this.formats,o=this.locales;switch(t.type){case"numberFormat":return{id:n,format:a.getNumberFormat(o,r.number[t.style]).format};case"dateFormat":return{
id:n,format:a.getDateTimeFormat(o,r.date[t.style]).format};case"timeFormat":return{id:n,format:a.getDateTimeFormat(o,r.time[t.style]).format};case"pluralFormat":return new pr(n,t.offset,this.compileOptions(e),a.getPluralRules(o,{type:t.ordinal?"ordinal":"cardinal"}));case"selectFormat":return new hr(n,this.compileOptions(e));default:throw new Error("Message element does not have a valid format type")}},Compiler.prototype.compileOptions=function(e){var t=this,n=e.format,a=n.options;this.pluralStack.push(this.currentPlural),this.currentPlural="pluralFormat"===n.type?e:null;var r=a.reduce((function(e,n){return e[n.selector]=t.compileMessage(n.value),e}),{});return this.currentPlural=this.pluralStack.pop(),r},Compiler}(),dr=function dr(e){this.id=e},mr=function(e){function StringFormat(){return null!==e&&e.apply(this,arguments)||this}return lr(StringFormat,e),StringFormat.prototype.format=function(e){return e||"number"==typeof e?"string"==typeof e?e:String(e):""},StringFormat
}(dr),pr=function(){function PluralFormat(e,t,n,a){this.id=e,this.offset=t,this.options=n,this.pluralRules=a}return PluralFormat.prototype.getOption=function(e){var t=this.options;return t["="+e]||t[this.pluralRules.select(e-this.offset)]||t.other},PluralFormat}(),gr=function(e){function PluralOffsetString(t,n,a,r){var o=e.call(this,t)||this;return o.offset=n,o.numberFormat=a,o.string=r,o}return lr(PluralOffsetString,e),PluralOffsetString.prototype.format=function(e){var t=this.numberFormat.format(e-this.offset);return this.string.replace(/(^|[^\\])#/g,"$1"+t).replace(/\\#/g,"#")},PluralOffsetString}(dr),hr=function(){function SelectFormat(e,t){this.id=e,this.options=t}return SelectFormat.prototype.getOption=function(e){var t=this.options;return t[e]||t.other},SelectFormat}();var fr=globalThis&&globalThis.__extends||function(){var extendStatics=function(e,t){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){
for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};return function(e,t){function __(){this.constructor=e}extendStatics(e,t),e.prototype=null===t?Object.create(t):(__.prototype=t.prototype,new __)}}(),yr=globalThis&&globalThis.__assign||function(){return(yr=Object.assign||function(e){for(var t,n=1,a=arguments.length;n<a;n++)for(var r in t=arguments[n])Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e}).apply(this,arguments)};function resolveLocale(e){"string"==typeof e&&(e=[e]);try{return Intl.NumberFormat.supportedLocalesOf(e,{localeMatcher:"best fit"})[0]}catch(e){return vr.defaultLocale}}function formatPatterns(e,t){for(var n="",a=0,r=e;a<r.length;a++){var o=r[a];if("string"!=typeof o){var i=o.id;if(!t||!(i in t))throw new br("A value must be provided for: "+i,i);var s=t[i];o.options?n+=formatPatterns(o.getOption(s),t):n+=o.format(s)}else n+=o}return n}function mergeConfigs(e,t){return t?Object.keys(e).reduce((function(n,a){return n[a]=function mergeConfig(e,t){
return t?yr({},e||{},t||{},Object.keys(e).reduce((function(n,a){return n[a]=yr({},e[a],t[a]||{}),n}),{})):e}(e[a],t[a]),n}),yr({},e)):e}var br=function(e){function FormatError(t,n){var a=e.call(this,t)||this;return a.variableId=n,a}return fr(FormatError,e),FormatError}(Error);var vr=function(){function IntlMessageFormat(e,t,n,a){var r=this;if(void 0===t&&(t=IntlMessageFormat.defaultLocale),this.format=function(e){try{return formatPatterns(r.pattern,e)}catch(e){throw e.variableId?new Error("The intl string context variable '"+e.variableId+"' was not provided to the string '"+r.message+"'"):e}},"string"==typeof e){if(!IntlMessageFormat.__parse)throw new TypeError("IntlMessageFormat.__parse must be set to process `message` of type `string`");this.ast=IntlMessageFormat.__parse(e)}else this.ast=e;if(this.message=e,!this.ast||"messageFormatPattern"!==this.ast.type)throw new TypeError("A message must be provided as a String or AST.");var o=mergeConfigs(IntlMessageFormat.formats,n)
;this.locale=resolveLocale(t||[]);var i=a&&a.formatters||function createDefaultFormatters(){return{getNumberFormat:function(){for(var e,t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return new((e=Intl.NumberFormat).bind.apply(e,[void 0].concat(t)))},getDateTimeFormat:function(){for(var e,t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return new((e=Intl.DateTimeFormat).bind.apply(e,[void 0].concat(t)))},getPluralRules:function(){for(var e,t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return new((e=Intl.PluralRules).bind.apply(e,[void 0].concat(t)))}}}();this.pattern=new ur(t,o,i).compile(this.ast)}return IntlMessageFormat.prototype.resolvedOptions=function(){return{locale:this.locale}},IntlMessageFormat.prototype.getAst=function(){return this.ast},IntlMessageFormat.defaultLocale="en",IntlMessageFormat.__parse=void 0,IntlMessageFormat.formats={number:{currency:{style:"currency"},percent:{style:"percent"}},date:{short:{month:"numeric",day:"numeric",year:"2-digit"},medium:{
month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}},IntlMessageFormat}();vr.__parse=cr.parse;function getModulePath(e){return sr.fileURLToPath(e.url)}function getModuleDirectory(e){return Q.dirname(getModulePath(e))}function isObjectOfUnknownValues(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}getModuleDirectory({url:"shared/localization/format.js"})
;const wr={},Dr="en-US",Er=["ar-XB.json","ar.json","bg.json","ca.json","cs.json","da.json","de.json","el.json","en-GB.json","en-US.ctc.json","en-US.json","en-XA.json","en-XL.ctc.json","en-XL.json","es-419.json","es.json","fi.json","fil.json","fr.json","he.json","hi.json","hr.json","hu.json","id.json","it.json","ja.json","ko.json","lt.json","lv.json","nl.json","no.json","pl.json","pt-PT.json","pt.json","ro.json","ru.json","sk.json","sl.json","sr-Latn.json","sr.json","sv.json","ta.json","te.json","th.json","tr.json","uk.json","vi.json","zh-HK.json","zh-TW.json","zh.json"].filter((e=>e.endsWith(".json")&&!e.endsWith(".ctc.json"))).map((e=>e.replace(".json",""))).sort(),Tr=/ | [^\s]+$/,Cr={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};function collectAllCustomElementsFromICU(e,t=new Map){
for(const n of e)if("argumentElement"===n.type&&(t.set(n.id,n),n.format&&"pluralFormat"===n.format.type))for(const e of n.format.options)collectAllCustomElementsFromICU(e.value.elements,t);return t}function _preformatValues(e,t={},n){const a=[...collectAllCustomElementsFromICU(e.getAst().elements).values()],r={};for(const{id:e,format:o}of a){if(e&&e in t==!1)throw new Error(`ICU Message "${n}" contains a value reference ("${e}") that wasn't provided`);const a=t[e];if(o&&"numberFormat"===o.type){if("number"!=typeof a)throw new Error(`ICU Message "${n}" contains a numeric reference ("${e}") but provided value was not a number`);"milliseconds"===o.style?r[e]=10*Math.round(a/10):"seconds"===o.style&&"timeInMs"===e?r[e]=Math.round(a/100)/10:"bytes"===o.style?r[e]=a/1024:r[e]=a}else r[e]=a}for(const e of Object.keys(t))if(!(e in r)){if("errorCode"!==e)throw new Error(`Provided value "${e}" does not match any placeholder in ICU message "${n}"`);r.errorCode=t.errorCode}return r}
function formatMessage(e,t,n){if(!e.includes("{")&&void 0===t)return e;const a=new vr(e,"en-XA"===n||"en-XL"===n?"de-DE":n,Cr),r=_preformatValues(a,t,e);return a.format(r)}function getRendererFormattedStrings(e){const t=_getLocaleMessages(e),n=Object.keys(t).filter((e=>e.startsWith("report/renderer/report-utils.js"))),a={};for(const e of n){const{filename:n,key:r}=getIcuMessageIdParts(e);if(!n.endsWith("report-utils.js"))throw new Error(`Unexpected message: ${e}`);a[r]=t[e].message}return a}function isIcuMessage(e){if(!isObjectOfUnknownValues(e))return!1;const{i18nId:t,values:n,formattedDefault:a}=e;if("string"!=typeof t)return!1;if("string"!=typeof a)return!1;if(void 0!==n){if(!isObjectOfUnknownValues(n))return!1;for(const e of Object.values(n))if("string"!=typeof e&&"number"!=typeof e)return!1}return Tr.test(t)}function getFormatted(e,t){if(isIcuMessage(e))return function _localizeIcuMessage(e,t){const n=_getLocaleMessages(t)[e.i18nId]
;return n?formatMessage(n.message,e.values,t):e.formattedDefault}(e,t);if("string"==typeof e)return e;throw new Error("Attempted to format invalid icuMessage type")}function _formatPathAsString(e){let t="";for(const n of e)if(/^[a-z]+$/i.test(n))t.length&&(t+="."),t+=n;else{if(/]|"|'|\s/.test(n))throw new Error(`Cannot handle "${n}" in i18n`);t+=`[${n}]`}return t}function replaceIcuMessages(e,t){const n={};return function replaceInObject(e,n,a=[]){if(function isObjectOrArrayOfUnknownValues(e){return"object"==typeof e&&null!==e}(e))for(const[r,o]of Object.entries(e)){const i=a.concat([r]);if(isIcuMessage(o)){const a=getFormatted(o,t),s=n[o.i18nId]||[],c=_formatPathAsString(i);s.push(o.values?{values:o.values,path:c}:c),e[r]=a,n[o.i18nId]=s}else replaceInObject(o,n,i)}}(e,n),n}function _getLocaleMessages(e){const t=wr[e];if(!t){if(e===Dr)return{};throw new Error(`Unsupported locale '${e}'`)}return t}function getIcuMessageIdParts(e){
if(!Tr.test(e))throw Error(`"${e}" does not appear to be a valid ICU message id`);const[t,n]=e.split(" | ");return{filename:t,key:n}}const Sr=getModuleDirectory({url:"root.js"
}),_r=JSON.parse('{\n  "name": "lighthouse",\n  "type": "module",\n  "version": "10.3.0",\n  "description": "Automated auditing, performance metrics, and best practices for the web.",\n  "main": "./core/index.js",\n  "bin": {\n    "lighthouse": "./cli/index.js",\n    "chrome-debug": "./core/scripts/manual-chrome-launcher.js",\n    "smokehouse": "./cli/test/smokehouse/frontends/smokehouse-bin.js"\n  },\n  "engines": {\n    "node": ">=16.16"\n  },\n  "scripts": {\n    "prepack": "yarn build-report --standalone --flow --esm && yarn build-types",\n    "postpack": "yarn clean-types",\n    "build-all": "npm-run-posix-or-windows build-all:task",\n    "build-all:task": "yarn build-report && yarn build-cdt-lib && yarn build-devtools && concurrently \'yarn build-extension\' \'yarn build-lr\' \'yarn build-viewer\' \'yarn build-treemap\' \'yarn build-smokehouse-bundle\' && yarn build-pack",\n    "build-all:task:windows": "yarn build-report && yarn build-cdt-lib && yarn build-extension && yarn build-devtools && yarn build-lr && yarn build-viewer && yarn build-treemap && yarn build-smokehouse-bundle",\n    "build-cdt-lib": "node ./build/build-cdt-lib.js",\n    "build-extension": "yarn build-extension-chrome && yarn build-extension-firefox",\n    "build-extension-chrome": "node ./build/build-extension.js chrome",\n    "build-extension-firefox": "node ./build/build-extension.js firefox",\n    "build-devtools": "yarn reset-link && node ./build/build-bundle.js clients/devtools/devtools-entry.js dist/lighthouse-dt-bundle.js && node ./build/build-dt-report-resources.js",\n    "build-smokehouse-bundle": "node ./build/build-smokehouse-bundle.js",\n    "build-lr": "yarn reset-link && node --max-old-space-size=4096 ./build/build-lightrider-bundles.js",\n    "build-pack": "bash build/build-pack.sh",\n    "build-report": "node build/build-report-components.js && node build/build-report.js",\n    "build-sample-reports": "yarn build-report && node build/build-sample-reports.js",\n    "build-treemap": "node ./build/build-treemap.js",\n    "build-viewer": "node ./build/build-viewer.js",\n    "build-types": "yarn type-check && rsync -a .tmp/tsbuildinfo/ ./ --include=\'*.d.ts\' --include=\'*.d.cts\' --exclude=\'*.map\' --exclude=\'*.tsbuildinfo\'",\n    "reset-link": "(yarn unlink || true) && yarn link && yarn link lighthouse",\n    "c8": "bash core/scripts/c8.sh",\n    "clean": "rm -r dist proto/scripts/*.json proto/scripts/*_pb2.* proto/scripts/*_pb.* proto/scripts/__pycache__ proto/scripts/*.pyc *.report.html *.report.dom.html *.report.json *.devtoolslog.json *.trace.json shared/localization/locales/*.ctc.json || true",\n    "clean-types": "git clean -xfq \'*.d.ts\' \'*.d.cts\' -e \'node_modules/\' -e \'dist/\' -e \'.tmp/\' -e \'**/types/\'",\n    "lint": "[ \\"$CI\\" = true ] && eslint --quiet -f codeframe . || eslint .",\n    "smoke": "node cli/test/smokehouse/frontends/smokehouse-bin.js",\n    "debug": "node --inspect-brk ./cli/index.js",\n    "start": "yarn build-report --standalone && node ./cli/index.js",\n    "mocha": "node --loader=testdouble core/test/scripts/run-mocha-tests.js",\n    "test": "yarn diff:sample-json && yarn lint --quiet && yarn unit && yarn type-check",\n    "test-bundle": "yarn smoke --runner bundle --retries=2",\n    "test-clients": "yarn mocha --testMatch clients/**/*-test.js && yarn mocha --testMatch clients/**/*-test-pptr.js",\n    "test-viewer": "yarn unit-viewer && yarn mocha --testMatch viewer/**/*-test-pptr.js --timeout 35000",\n    "test-treemap": "yarn unit-treemap && yarn mocha --testMatch treemap/**/*-test-pptr.js --timeout 35000",\n    "test-lantern": "bash core/scripts/test-lantern.sh",\n    "test-legacy-javascript": "bash core/scripts/test-legacy-javascript.sh",\n    "test-docs": "yarn --cwd docs/recipes/ test",\n    "test-proto": "yarn compile-proto && yarn build-proto-roundtrip",\n    "unit-core": "yarn mocha core",\n    "unit-cli": "yarn mocha --testMatch cli/**/*-test.js",\n    "unit-report": "yarn mocha --testMatch report/**/*-test.js",\n    "unit-treemap": "yarn mocha --testMatch treemap/**/*-test.js",\n    "unit-viewer": "yarn mocha --testMatch viewer/**/*-test.js",\n    "unit-flow": "bash flow-report/test/run-flow-report-tests.sh",\n    "unit": "yarn unit-flow && yarn mocha",\n    "unit:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit --forbid-only",\n    "core-unit": "yarn unit-core",\n    "cli-unit": "yarn unit-cli",\n    "viewer-unit": "yarn unit-viewer",\n    "watch": "yarn unit-core --watch",\n    "unit:cicoverage": "yarn c8 --all yarn unit:ci",\n    "coverage": "yarn unit:cicoverage && c8 report --reporter html",\n    "coverage:smoke": "yarn c8 yarn smoke -j=1 && c8 report --reporter html",\n    "devtools": "bash core/scripts/roll-to-devtools.sh",\n    "chrome": "node core/scripts/manual-chrome-launcher.js",\n    "fast": "node ./cli/index.js --preset=desktop --throttlingMethod=provided",\n    "deploy-treemap": "yarn build-treemap --deploy",\n    "deploy-viewer": "yarn build-viewer --deploy",\n    "vercel-build": "yarn build-sample-reports && yarn build-viewer && yarn build-treemap",\n    "dogfood-lhci": "./core/scripts/dogfood-lhci.sh",\n    "timing-trace": "node core/scripts/generate-timing-trace.js",\n    "changelog": "conventional-changelog --config ./build/changelog-generator/index.cjs --infile changelog.md --same-file",\n    "type-check": "tsc --build ./tsconfig-all.json",\n    "i18n:checks": "./core/scripts/i18n/assert-strings-collected.sh",\n    "i18n:collect-strings": "node core/scripts/i18n/collect-strings.js",\n    "update:lantern-baseline": "node core/scripts/lantern/update-baseline-lantern-values.js",\n    "update:sample-artifacts": "node core/scripts/update-report-fixtures.js",\n    "update:sample-json": "yarn i18n:collect-strings && node ./cli -A=./core/test/results/artifacts --config-path=./core/test/results/sample-config.js --output=json --output-path=./core/test/results/sample_v2.json && node core/scripts/cleanup-LHR-for-diff.js ./core/test/results/sample_v2.json --only-remove-timing && node ./core/scripts/update-flow-fixtures.js",\n    "update:flow-sample-json": "yarn i18n:collect-strings && node ./core/scripts/update-flow-fixtures.js",\n    "test-devtools": "bash core/test/devtools-tests/test-locally.sh",\n    "open-devtools": "bash core/scripts/open-devtools.sh",\n    "run-devtools": "node core/scripts/pptr-run-devtools.js",\n    "diff:sample-json": "yarn i18n:checks && bash core/scripts/assert-golden-lhr-unchanged.sh",\n    "diff:flow-sample-json": "yarn i18n:collect-strings && bash core/scripts/assert-baseline-flow-result-unchanged.sh",\n    "computeBenchmarkIndex": "./core/scripts/benchmark.js",\n    "save-latest-run": "./core/scripts/save-latest-run.sh",\n    "compile-proto": "protoc --python_out=./ ./proto/lighthouse-result.proto && mv ./proto/*_pb2.py ./proto/scripts || (echo \\"❌ Install protobuf = 3.20.x to compile the proto file.\\" && false)",\n    "build-proto-roundtrip": "mkdir -p .tmp && python3 proto/scripts/json_roundtrip_via_proto.py",\n    "static-server": "node cli/test/fixtures/static-server.js",\n    "serve-dist": "cd dist && python3 -m http.server 7878",\n    "serve-gh-pages": "cd dist/gh-pages && python3 -m http.server 7333",\n    "serve-treemap": "yarn serve-gh-pages",\n    "serve-viewer": "yarn serve-gh-pages",\n    "flow-report": "yarn build-report --flow && node ./core/scripts/build-test-flow-report.js"\n  },\n  "devDependencies": {\n    "@build-tracker/cli": "^1.0.0-beta.15",\n    "@esbuild-kit/esm-loader": "^2.1.1",\n    "@jest/fake-timers": "^28.1.0",\n    "@rollup/plugin-alias": "^3.1.2",\n    "@rollup/plugin-commonjs": "^20.0.0",\n    "@rollup/plugin-dynamic-import-vars": "^1.1.1",\n    "@rollup/plugin-json": "^4.1.0",\n    "@rollup/plugin-node-resolve": "^13.0.4",\n    "@rollup/plugin-typescript": "^8.2.5",\n    "@stadtlandnetz/rollup-plugin-postprocess": "^1.1.0",\n    "@testing-library/preact": "^3.1.1",\n    "@testing-library/preact-hooks": "^1.1.0",\n    "@types/archiver": "^2.1.2",\n    "@types/chrome": "^0.0.154",\n    "@types/configstore": "^4.0.0",\n    "@types/cpy": "^5.1.0",\n    "@types/debug": "^4.1.7",\n    "@types/eslint": "^8.2.1",\n    "@types/estree": "^0.0.50",\n    "@types/gh-pages": "^2.0.0",\n    "@types/google.analytics": "0.0.39",\n    "@types/jpeg-js": "^0.3.7",\n    "@types/jsdom": "^16.2.13",\n    "@types/lodash": "^4.14.178",\n    "@types/mocha": "^9.0.0",\n    "@types/node": "*",\n    "@types/pako": "^1.0.1",\n    "@types/resize-observer-browser": "^0.1.1",\n    "@types/semver": "^5.5.0",\n    "@types/tabulator-tables": "^4.9.1",\n    "@types/ws": "^7.0.0",\n    "@types/yargs": "^17.0.8",\n    "@types/yargs-parser": "^20.2.1",\n    "@typescript-eslint/eslint-plugin": "^5.48.0",\n    "@typescript-eslint/parser": "^5.48.0",\n    "acorn": "^8.5.0",\n    "angular": "^1.7.4",\n    "archiver": "^3.0.0",\n    "c8": "^7.11.3",\n    "chalk": "^2.4.1",\n    "chrome-devtools-frontend": "1.0.1153166",\n    "concurrently": "^6.4.0",\n    "conventional-changelog-cli": "^2.1.1",\n    "cpy": "^8.1.2",\n    "cross-env": "^7.0.2",\n    "csv-validator": "^0.0.3",\n    "es-main": "^1.2.0",\n    "eslint": "^8.4.1",\n    "eslint-config-google": "^0.14.0",\n    "eslint-formatter-codeframe": "^7.32.1",\n    "eslint-plugin-import": "^2.25.3",\n    "eslint-plugin-local-rules": "1.1.0",\n    "event-target-shim": "^6.0.2",\n    "expect": "^28.1.0",\n    "firebase": "^9.0.2",\n    "gh-pages": "^2.0.1",\n    "glob": "^7.1.3",\n    "idb-keyval": "2.2.0",\n    "intl-messageformat-parser": "^1.8.1",\n    "jest-mock": "^27.3.0",\n    "jest-snapshot": "^28.1.0",\n    "jsdom": "^12.2.0",\n    "lighthouse-plugin-publisher-ads": "1.5.7-beta",\n    "lighthouse-plugin-soft-navigation": "^1.0.1",\n    "magic-string": "^0.25.7",\n    "mime-types": "^2.1.30",\n    "mocha": "^10.0.0",\n    "node-fetch": "^2.6.1",\n    "npm-run-posix-or-windows": "^2.0.2",\n    "pako": "^2.0.3",\n    "preact": "^10.7.2",\n    "pretty-json-stringify": "^0.0.2",\n    "puppeteer": "^20.7.1",\n    "resolve": "^1.20.0",\n    "rollup": "^2.52.7",\n    "rollup-plugin-node-resolve": "^5.2.0",\n    "rollup-plugin-polyfill-node": "^0.12.0",\n    "rollup-plugin-replace": "^2.2.0",\n    "rollup-plugin-shim": "^1.0.0",\n    "rollup-plugin-terser": "^7.0.2",\n    "tabulator-tables": "^4.9.3",\n    "terser": "^5.3.8",\n    "testdouble": "^3.17.2",\n    "typed-query-selector": "^2.6.1",\n    "typescript": "^5.0.4",\n    "wait-for-expect": "^3.0.2",\n    "webtreemap-cdt": "^3.2.1"\n  },\n  "dependencies": {\n    "@sentry/node": "^6.17.4",\n    "axe-core": "4.7.2",\n    "chrome-launcher": "^0.15.2",\n    "configstore": "^5.0.1",\n    "csp_evaluator": "1.1.1",\n    "devtools-protocol": "0.0.1155343",\n    "enquirer": "^2.3.6",\n    "http-link-header": "^1.1.1",\n    "intl-messageformat": "^4.4.0",\n    "jpeg-js": "^0.4.4",\n    "js-library-detector": "^6.6.0",\n    "lighthouse-logger": "^1.4.1",\n    "lighthouse-stack-packs": "1.10.0",\n    "lodash": "^4.17.21",\n    "lookup-closest-locale": "6.2.0",\n    "metaviewport-parser": "0.3.0",\n    "open": "^8.4.0",\n    "parse-cache-control": "1.0.1",\n    "ps-list": "^8.0.0",\n    "puppeteer-core": "^20.7.1",\n    "robots-parser": "^3.0.0",\n    "semver": "^5.3.0",\n    "speedline-core": "^1.4.3",\n    "third-party-web": "^0.23.0",\n    "ws": "^7.0.0",\n    "yargs": "^17.3.1",\n    "yargs-parser": "^21.0.0"\n  },\n  "resolutions": {\n    "puppeteer/**/devtools-protocol": "0.0.1155343",\n    "puppeteer-core/**/devtools-protocol": "0.0.1155343"\n  },\n  "repository": "GoogleChrome/lighthouse",\n  "keywords": [\n    "google",\n    "chrome",\n    "devtools"\n  ],\n  "author": "The Lighthouse Authors",\n  "license": "Apache-2.0",\n  "bugs": {\n    "url": "https://github.com/GoogleChrome/lighthouse/issues"\n  },\n  "homepage": "https://github.com/GoogleChrome/lighthouse#readme"\n}\n').version,Ar={
ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Potential savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Potential savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Potential Savings",columnWastedMs:"Potential Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnOverBudget:"Over Budget",columnElement:"Element",columnStartTime:"Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",totalResourceType:"Total",documentResourceType:"Document",
scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift",interactionToNextPaint:"Interaction to Next Paint",itemSeverityLow:"Low",itemSeverityMedium:"Medium",itemSeverityHigh:"High"};function lookupLocale(e,t){if("object"!=typeof Intl)throw new Error("Lighthouse must be run in Node with `Intl` support. See https://nodejs.org/api/intl.html for help")
;const n=Intl.getCanonicalLocales(e),a=Intl.NumberFormat.supportedLocalesOf(n),r=t||function getAvailableLocales(){return[...new Set([...Object.keys(wr),Dr])].sort()}(),o=function lookupClosestLocale(e,t){if("string"==typeof e&&t[e])return e;for(var n=[].concat(e||[]),a=0,r=n.length;a<r;++a)for(var o=n[a].split("-");o.length;){var i=o.join("-");if(t[i])return i;o.pop()}}(a,Object.fromEntries(r.map((e=>[e,{}]))));return o||(0===Intl.NumberFormat.supportedLocalesOf("es").length&&Log.warn("i18n","Requested locale not available in this version of node. The `full-icu` npm module can provide additional locales. For help, see https://github.com/GoogleChrome/lighthouse/blob/main/readme.md#how-do-i-get-localized-lighthouse-results-via-the-cli"),Log.warn("i18n",`locale(s) '${e}' not available. Falling back to default 'en-US'`)),o||Dr}function createIcuMessageFn(e,t){e.startsWith("file://")&&(e=sr.fileURLToPath(e)),Q.isAbsolute(e)&&(e=Q.relative(Sr,e));const n={...Ar,...t};return(a,r)=>{
const o=Object.keys(n).find((e=>n[e]===a));if(!o)throw new Error(`Could not locate: ${a}`);return{i18nId:`${(o in t?e:Q.relative(Sr,getModulePath({url:"core/lib/i18n/i18n.js"}))).replace(/\\/g,"/")} | ${o}`,values:r,formattedDefault:formatMessage(a,r,Dr)}}}function isStringOrIcuMessage(e){return"string"==typeof e||isIcuMessage(e)}const kr={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",noLcp:"The page did not display content that qualifies as a Largest Contentful Paint (LCP). Ensure the page has a valid LCP element and then try again. ({errorCode})",
pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",
pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",
erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results."},Fr=createIcuMessageFn("core/lib/lh-error.js",kr),xr="__LighthouseErrorSentinel",Rr="__ErrorSentinel";class LighthouseError extends Error{constructor(e,t,n){super(e.code,n),this.name="LighthouseError",this.code=e.code,this.friendlyMessage=Fr(e.message,{errorCode:this.code,...t}),this.lhrRuntimeError=!!e.lhrRuntimeError,t&&Object.assign(this,t),Error.captureStackTrace(this,LighthouseError)}static fromProtocolMessage(e,t){const n=Object.values(LighthouseError.errors).filter((e=>e.pattern)).find((e=>e.pattern&&e.pattern.test(t.message)));if(n)return new LighthouseError(n);let a=`(${e}): ${t.message}`;t.data&&(a+=` (${t.data})`);const r=new Error(`Protocol error ${a}`);return Object.assign(r,{protocolMethod:e,protocolError:t.message})}
static stringifyReplacer(e){if(e instanceof LighthouseError){const{name:t,code:n,message:a,friendlyMessage:r,lhrRuntimeError:o,stack:i,cause:s,...c}=e;return{sentinel:xr,code:n,stack:i,cause:s,properties:c}}if(e instanceof Error){const{message:t,stack:n,cause:a}=e,r=e.code;return{sentinel:Rr,message:t,code:r,stack:n,cause:a}}throw new Error("Invalid value for LighthouseError stringification")}static parseReviver(e,t){if("object"==typeof t&&null!==t){if(t.sentinel===xr){const{code:e,stack:n,cause:a,properties:r}=t,o=LighthouseError.errors[e],i=new LighthouseError(o,r,{cause:a});return i.stack=n,i}if(t.sentinel===Rr){const{message:e,code:n,stack:a,cause:r}=t,o=new Error(e,r?{cause:r}:void 0);return Object.assign(o,{code:n,stack:a}),o}}return t}}const Ir={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:kr.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:kr.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{
code:"NO_SCREENSHOTS",message:kr.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:kr.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:kr.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:kr.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:kr.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:kr.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:kr.badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:kr.badTraceRecording},NO_LCP:{code:"NO_LCP",message:kr.noLcp},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:kr.noLcp},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:kr.oldChromeDoesNotSupportFeature},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:kr.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",
message:kr.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:kr.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:kr.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:kr.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:kr.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:kr.pageLoadFailedInterstitial,lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:kr.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:kr.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:kr.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:kr.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{
code:"READ_FAILED",message:kr.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:kr.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:kr.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:kr.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:kr.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:kr.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:kr.erroredRequiredArtifact}};LighthouseError.errors=Ir,LighthouseError.NO_ERROR="NO_ERROR",LighthouseError.UNKNOWN_ERROR="UNKNOWN_ERROR";const Mr=["https:","http:","chrome:","chrome-extension:"],Nr=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],Lr=["localhost","127.0.0.1"],Pr=["blob","data","intent","file","filesystem","chrome-extension"];function rewriteChromeInternalUrl(e){
return e&&e.startsWith("chrome://")?(e.endsWith("/")&&(e=e.replace(/\/$/,"")),e.replace(/^chrome:\/\/chrome\//,"chrome://")):e}class UrlUtils{static isValid(e){try{return new URL(e),!0}catch(e){return!1}}static hostsMatch(e,t){try{return new URL(e).host===new URL(t).host}catch(e){return!1}}static originsMatch(e,t){try{return new URL(e).origin===new URL(t).origin}catch(e){return!1}}static getOrigin(e){try{const t=new URL(e);return"chrome-extension:"===t.protocol?Util.getChromeExtensionOrigin(e):t.host&&t.origin||null}catch(e){return null}}static rootDomainsMatch(e,t){let n,a;try{n=Util.createOrReturnURL(e),a=Util.createOrReturnURL(t)}catch(e){return!1}if(!n.hostname||!a.hostname)return!1;return Util.getRootDomain(n)===Util.getRootDomain(a)}static getURLDisplayName(e,t){return Util.getURLDisplayName(new URL(e),t)}static elideDataURI(e){try{return"data:"===new URL(e).protocol?Util.truncate(e,100):e}catch(t){return e}}static equalWithExcludedFragments(e,t){
[e,t]=[e,t].map(rewriteChromeInternalUrl);try{const n=new URL(e);n.hash="";const a=new URL(t);return a.hash="",n.href===a.href}catch(e){return!1}}static isProtocolAllowed(e){try{const t=new URL(e);return Mr.includes(t.protocol)}catch(e){return!1}}static isLikeLocalhost(e){return Lr.includes(e)||e.endsWith(".localhost")}static isSecureScheme(e){return Nr.includes(e)}static isNonNetworkProtocol(e){const t=e.includes(":")?e.slice(0,e.indexOf(":")):e;return Pr.includes(t)}static guessMimeType(e){let t;try{t=new URL(e)}catch{return}if("data:"===t.protocol){const e=t.pathname.match(/^(image\/(png|jpeg|svg\+xml|webp|gif|avif))[;,]/);if(!e)return;return e[1]}const n=t.pathname.toLowerCase().match(/\.(png|jpeg|jpg|svg|webp|gif|avif)$/);if(!n)return;const a=n[1];return"svg"===a?"image/svg+xml":"jpg"===a?"image/jpeg":`image/${a}`}static normalizeUrl(e){if(e&&this.isValid(e)&&this.isProtocolAllowed(e))return new URL(e).href;throw new LighthouseError(LighthouseError.errors.INVALID_URL)}}
UrlUtils.INVALID_URL_DEBUG_STRING="Lighthouse was unable to determine the URL of some script executions. It's possible a Chrome extension or other eval'd code is the source.";const Or="X-TCPMs",Br="X-SSLMs",Ur="X-RequestMs",jr="X-ResponseMs",zr="X-TotalMs",qr="X-TotalFetchedSize",Wr="X-ProtocolIsH2",$r={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch"};class NetworkRequest{constructor(){this.requestId="",this.connectionId="0",this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.rendererStartTime=-1,this.networkRequestTime=-1,this.responseHeadersEndTime=-1,this.networkEndTime=-1,this.transferSize=0,
this.resourceSize=0,this.fromDiskCache=!1,this.fromMemoryCache=!1,this.fromPrefetchCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.sessionTargetType=void 0,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(e){this.initiatorRequest=e}onRequestWillBeSent(e){let t;this.requestId=e.requestId;try{t=new URL(e.request.url)}catch(e){return}this.url=e.request.url,this.documentURL=e.documentURL,this.parsedURL={scheme:t.protocol.split(":")[0],host:t.hostname,securityOrigin:t.origin},
this.isSecure=UrlUtils.isSecureScheme(this.parsedURL.scheme),this.rendererStartTime=1e3*e.timestamp,this.networkRequestTime=this.rendererStartTime,this.requestMethod=e.request.method,this.initiator=e.initiator,this.resourceType=e.type&&$r[e.type],this.priority=e.request.initialPriority,this.frameId=e.frameId,this.isLinkPreload="preload"===e.initiator.type||!!e.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(e){this._onResponse(e.response,e.timestamp,e.type),this._updateProtocolForLightrider(),this.frameId=e.frameId}onDataReceived(e){this.resourceSize+=e.dataLength,-1!==e.encodedDataLength&&(this.transferSize+=e.encodedDataLength)}onLoadingFinished(e){this.finished||(this.finished=!0,this.networkEndTime=1e3*e.timestamp,e.encodedDataLength>=0&&(this.transferSize=e.encodedDataLength),this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),
this._updateTimingsForLightrider())}onLoadingFailed(e){this.finished||(this.finished=!0,this.networkEndTime=1e3*e.timestamp,this.failed=!0,this.resourceType=e.type&&$r[e.type],this.localizedFailDescription=e.errorText,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(e){this.priority=e.newPriority}onRedirectResponse(e){if(!e.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(e.redirectResponse,e.timestamp,e.type),this.resourceType=void 0,this.finished=!0,this.networkEndTime=1e3*e.timestamp,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming()}setSession(e){this.sessionId=e}get isOutOfProcessIframe(){return"iframe"===this.sessionTargetType}_onResponse(e,t,n){this.url=e.url,this.connectionId=String(e.connectionId),this.connectionReused=e.connectionReused,
e.protocol&&(this.protocol=e.protocol),this.responseHeadersEndTime=1e3*t,this.transferSize=e.encodedDataLength,"boolean"==typeof e.fromDiskCache&&(this.fromDiskCache=e.fromDiskCache),"boolean"==typeof e.fromPrefetchCache&&(this.fromPrefetchCache=e.fromPrefetchCache),this.statusCode=e.status,this.timing=e.timing,n&&(this.resourceType=$r[n]),this.mimeType=e.mimeType,this.responseHeadersText=e.headersText||"",this.responseHeaders=NetworkRequest._headersDictToHeadersArray(e.headers),this.fetchedViaServiceWorker=!!e.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(e){if(0===e.requestTime||-1===e.receiveHeadersEnd)return;this.networkRequestTime=1e3*e.requestTime;const t=this.networkRequestTime+e.receiveHeadersEnd,n=this.responseHeadersEndTime;this.responseHeadersEndTime=t,this.responseHeadersEndTime=Math.min(this.responseHeadersEndTime,n),
this.responseHeadersEndTime=Math.max(this.responseHeadersEndTime,this.networkRequestTime),this.networkEndTime=Math.max(this.networkEndTime,this.responseHeadersEndTime)}_updateResponseHeadersEndTimeIfNecessary(){this.responseHeadersEndTime=Math.min(this.networkEndTime,this.responseHeadersEndTime)}_updateTransferSizeForLightrider(){if(!globalThis.isLightrider)return;const e=this.responseHeaders.find((e=>e.name===qr));if(!e)return;const t=parseFloat(e.value);isNaN(t)||(this.transferSize=t)}_updateProtocolForLightrider(){globalThis.isLightrider&&this.responseHeaders.some((e=>e.name===Wr))&&(this.protocol="h2")}_backfillReceiveHeaderStartTiming(){this.timing&&void 0===this.timing.receiveHeadersStart&&(this.timing.receiveHeadersStart=this.timing.receiveHeadersEnd)}_updateTimingsForLightrider(){if(!globalThis.isLightrider)return;const e=this.responseHeaders.find((e=>e.name===zr));if(!e)return
;const t=parseInt(e.value),n=this.responseHeaders.find((e=>e.name===Or)),a=this.responseHeaders.find((e=>e.name===Br)),r=this.responseHeaders.find((e=>e.name===Ur)),o=this.responseHeaders.find((e=>e.name===jr)),i=n?Math.max(0,parseInt(n.value)):0,s=a?Math.max(0,parseInt(a.value)):0,c=r?Math.max(0,parseInt(r.value)):0,l=o?Math.max(0,parseInt(o.value)):0;i+c+l===t&&(s>i||(this.lrStatistics={endTimeDeltaMs:this.networkEndTime-(this.networkRequestTime+t),TCPMs:i,requestMs:c,responseMs:l}))}static getRequestIdForBackend(e){return e.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(e){const t=[];for(const n of Object.keys(e)){const a=e[n].split("\n");for(let e=0;e<a.length;++e)t.push({name:n,value:a[e]})}return t}static get TYPES(){return $r}static isNonNetworkRequest(e){return UrlUtils.isNonNetworkProtocol(e.protocol)||UrlUtils.isNonNetworkProtocol(e.parsedURL.scheme)}static isSecureRequest(e){
return UrlUtils.isSecureScheme(e.parsedURL.scheme)||UrlUtils.isSecureScheme(e.protocol)||UrlUtils.isLikeLocalhost(e.parsedURL.host)||NetworkRequest.isHstsRequest(e)}static isHstsRequest(e){const t=e.redirectDestination;if(!t)return!1;return"HSTS"===e.responseHeaders.find((e=>"Non-Authoritative-Reason"===e.name))?.value&&NetworkRequest.isSecureRequest(t)}static getResourceSizeOnNetwork(e){return Math.min(e.resourceSize||0,e.transferSize||1/0)}}async function fetchResponseBodyFromCache(e,t,n=1e3){t=NetworkRequest.getRequestIdForBackend(t),e.setNextProtocolTimeout(n);return(await e.sendCommand("Network.getResponseBody",{requestId:t})).body}NetworkRequest.HEADER_TCP=Or,NetworkRequest.HEADER_SSL=Br,NetworkRequest.HEADER_REQ=Ur,NetworkRequest.HEADER_RES=jr,NetworkRequest.HEADER_TOTAL=zr,NetworkRequest.HEADER_FETCHED_SIZE=qr,NetworkRequest.HEADER_PROTOCOL_IS_H2=Wr;class FRGatherer{meta={supportedModes:[]};startInstrumentation(e){}startSensitiveInstrumentation(e){}
stopSensitiveInstrumentation(e){}stopInstrumentation(e){}getArtifact(e){}get name(){let e=this.constructor.name;return e.includes("$")&&(e=e.substr(0,e.indexOf("$"))),e}async beforePass(e){await this.startInstrumentation({...e,dependencies:{}}),await this.startSensitiveInstrumentation({...e,dependencies:{}})}pass(e){}async afterPass(e,t){if("dependencies"in this.meta)throw Error("Gatherer with dependencies should override afterPass");return await this.stopSensitiveInstrumentation({...e,dependencies:{}}),await this.stopInstrumentation({...e,dependencies:{}}),this.getArtifact({...e,dependencies:{}})}}class DevtoolsLog extends FRGatherer{static symbol=Symbol("DevtoolsLog");meta={symbol:DevtoolsLog.symbol,supportedModes:["timespan","navigation"]};constructor(){super(),this._messageLog=new DevtoolsMessageLog(/^(Page|Network|Target|Runtime)\./),this._onProtocolMessage=e=>this._messageLog.record(e)}async startSensitiveInstrumentation({driver:e}){this._messageLog.reset(),
this._messageLog.beginRecording(),e.targetManager.on("protocolevent",this._onProtocolMessage),await e.defaultSession.sendCommand("Page.enable")}async stopSensitiveInstrumentation({driver:e}){this._messageLog.endRecording(),e.targetManager.off("protocolevent",this._onProtocolMessage)}async getArtifact(){return this._messageLog.messages}}class DevtoolsMessageLog{constructor(e){this._filter=e,this._messages=[],this._isRecording=!1}get messages(){return this._messages}reset(){this._messages=[]}beginRecording(){this._isRecording=!0}endRecording(){this._isRecording=!1}record(e){this._isRecording&&"string"==typeof e.method&&(this._filter&&!this._filter.test(e.method)||this._messages.push(e))}}var Vr=Object.freeze({__proto__:null,default:DevtoolsLog,DevtoolsMessageLog});const Hr=/^(chrome|https?):/;class TraceProcessor{static get TIMESPAN_MARKER_ID(){return"__lighthouseTimespanStart__"}static createNoNavstartError(){return new Error("No navigationStart event found")}
static createNoResourceSendRequestError(){return new Error("No ResourceSendRequest event found")}static createNoTracingStartedError(){return new Error("No tracingStartedInBrowser event found")}static createNoFirstContentfulPaintError(){return new Error("No FirstContentfulPaint event found")}static createNoLighthouseMarkerError(){return new Error("No Lighthouse timespan marker event found")}static _isNavigationStartOfInterest(e){return"navigationStart"===e.name&&(void 0===e.args.data?.documentLoaderURL||!!e.args.data?.documentLoaderURL&&Hr.test(e.args.data.documentLoaderURL))}static _sortTimestampEventGroup(e,t,n,a){const lookupArrayIndexByTsIndex=e=>t[e],lookupEventByTsIndex=e=>a[lookupArrayIndexByTsIndex(e)],r=[],o=[],i=[];for(const t of e){const e=lookupArrayIndexByTsIndex(t),n=lookupEventByTsIndex(t);"E"===n.ph?r.push(e):"X"===n.ph||"B"===n.ph?o.push(e):i.push(e)}const s=new Map;for(const r of o){const o=a[r];if("X"===o.ph)s.set(r,o.dur);else{let a=Number.MAX_SAFE_INTEGER,i=0
;for(let r=n+e.length;r<t.length;r++){const e=lookupEventByTsIndex(r);if(e.name===o.name&&e.pid===o.pid&&e.tid===o.tid){if("E"===e.ph&&0===i){a=e.ts-o.ts;break}"E"===e.ph?i--:"B"===e.ph&&i++}}s.set(r,a)}}return o.sort(((e,t)=>(s.get(t)||0)-(s.get(e)||0)||e-t)),i.sort(((e,t)=>e-t)),[...r,...o,...i]}static filteredTraceSort(e,t){const n=[];for(let a=0;a<e.length;a++)t(e[a])&&n.push(a);n.sort(((t,n)=>e[t].ts-e[n].ts));for(let t=0;t<n.length-1;t++){const a=e[n[t]].ts,r=[t];for(let o=t+1;o<n.length&&e[n[o]].ts===a;o++)r.push(o);if(1===r.length)continue;const o=TraceProcessor._sortTimestampEventGroup(r,n,t,e);n.splice(t,o.length,...o),t+=r.length-1}const a=[];for(let t=0;t<n.length;t++)a.push(e[n[t]]);return a}static assertHasToplevelEvents(e){if(!e.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static _riskPercentiles(e,t,n,a=0){let r=0;for(let t=0;t<e.length;t++)r+=e[t];r-=a;let o=t-r,i=0,s=o;const c=[];let l=-1,u=e.length+1;a>0&&u--;for(const r of n){
const n=r*t;for(;s<n&&l<e.length-1;)o+=i,u-=i<0?-1:1,a>0&&a<e[l+1]?(i=-a,a=0):(l++,i=e[l]),s=o+Math.abs(i)*u;c.push({percentile:r,time:Math.max(0,(n-o)/u)+16})}return c}static getRiskToResponsiveness(e,t,n,a=[.5,.75,.9,.99,1]){const r=n-t;a.sort(((e,t)=>e-t));const o=this.getMainThreadTopLevelEventDurations(e,t,n);return this._riskPercentiles(o.durations,r,a,o.clippedLength)}static getMainThreadTopLevelEventDurations(e,t=0,n=1/0){const a=[];let r=0;for(const o of e){if(o.end<t||o.start>n)continue;let e=o.duration,i=o.start;i<t&&(i=t,e=o.end-t),o.end>n&&(r=e-(n-i)),a.push(e)}return a.sort(((e,t)=>e-t)),{durations:a,clippedLength:r}}static getMainThreadTopLevelEvents(e,t=0,n=1/0){const a=[];for(const r of e.mainThreadEvents){if(!this.isScheduleableTask(r)||!r.dur)continue;const o=(r.ts-e.timeOriginEvt.ts)/1e3,i=(r.ts+r.dur-e.timeOriginEvt.ts)/1e3;o>n||i<t||a.push({start:o,end:i,duration:r.dur/1e3})}return a}static findMainFrameIds(e){
const t=e.find((e=>"TracingStartedInBrowser"===e.name));if(t?.args.data?.frames){const e=t.args.data.frames.find((e=>!e.parent)),n=e?.frame,a=e?.processId;if(a&&n)return{startingPid:a,frameId:n}}const n=e.find((e=>"TracingStartedInPage"===e.name));if(n?.args?.data){const e=n.args.data.page;if(e)return{startingPid:n.pid,frameId:e}}const a=e.find((e=>this._isNavigationStartOfInterest(e)&&e.args.data?.isLoadingMainFrame)),r=e.find((e=>"ResourceSendRequest"===e.name));if(a?.args?.data&&r&&r.pid===a.pid&&r.tid===a.tid){const e=a.args.frame;if(e)return{startingPid:a.pid,frameId:e}}throw this.createNoTracingStartedError()}static findMainFramePidTids(e,t){const n=t.filter((t=>("FrameCommittedInBrowser"===t.name||"ProcessReadyInBrowser"===t.name)&&t.args?.data?.frame===e.frameId&&t?.args?.data?.processId)),a=n.length?n.map((e=>e?.args?.data?.processId)):[e.startingPid],r=new Map;for(const e of new Set(a)){const n=t.filter((t=>"__metadata"===t.cat&&t.pid===e&&"M"===t.ph&&"thread_name"===t.name))
;let a=n.find((e=>"CrRendererMain"===e.args.name));a||(a=n.find((e=>"CrBrowserMain"===e.args.name)));const o=a?.tid;if(!o)throw new Error("Unable to determine tid for renderer process");r.set(e,o)}return r}static isScheduleableTask(e){return"RunTask"===e.name||"ThreadControllerImpl::RunTask"===e.name||"ThreadControllerImpl::DoWork"===e.name||"TaskQueueManager::ProcessTaskFromWorkQueue"===e.name}static isLCPEvent(e){return("largestContentfulPaint::Invalidate"===e.name||"largestContentfulPaint::Candidate"===e.name)&&Boolean(e.args?.frame)}static isLCPCandidateEvent(e){return Boolean("largestContentfulPaint::Candidate"===e.name&&e.args?.frame&&e.args.data&&void 0!==e.args.data.size)}static getFrameId(e){return e.args?.data?.frame||e.args.data?.frameID||e.args.frame}static computeValidLCPAllFrames(e,t){const n=e.filter(this.isLCPEvent).reverse(),a=new Map;for(const e of n){if(e.ts<=t.ts)break;const n=e.args.frame;a.has(n)||a.set(n,e)}let r
;for(const e of a.values())this.isLCPCandidateEvent(e)&&(!r||e.args.data.size>r.args.data.size)&&(r=e);return{lcp:r,invalidated:Boolean(!r&&a.size)}}static resolveRootFrames(e){const t=new Map;for(const n of e)n.parent&&t.set(n.id,n.parent);const n=new Map;for(const a of e){let e=a.id;for(;t.has(e);)e=t.get(e);if(void 0===e)throw new Error("Unexpected undefined frameId");n.set(a.id,e)}return n}static processTrace(e,t){const{timeOriginDeterminationMethod:n="auto"}=t||{},a=this.filteredTraceSort(e.traceEvents,(e=>e.cat.includes("blink.user_timing")||e.cat.includes("loading")||e.cat.includes("devtools.timeline")||"__metadata"===e.cat)),r=this.findMainFrameIds(a),o=this.findMainFramePidTids(r,a),i=TraceProcessor.filteredTraceSort(e.traceEvents,(e=>o.has(e.pid))),s=new Map,c=a.find((e=>"TracingStartedInBrowser"===e.name))?.args?.data?.frames;if(c)for(const e of c)s.set(e.frame,{id:e.frame,url:e.url,parent:e.parent})
;a.filter((e=>Boolean("FrameCommittedInBrowser"===e.name&&e.args.data?.frame&&void 0!==e.args.data.url))).forEach((e=>{s.set(e.args.data.frame,{id:e.args.data.frame,url:e.args.data.url,parent:e.args.data.parent})}));const l=[...s.values()],u=this.resolveRootFrames(l),d=[...u.entries()].filter((([,e])=>e===r.frameId)).map((([e])=>e));const m=a.filter((e=>function associatedToMainFrame(e){return TraceProcessor.getFrameId(e)===r.frameId}(e)));let p=[];u.has(r.frameId)?p=a.filter((e=>function associatedToAllFrames(e){const t=TraceProcessor.getFrameId(e);return!!t&&d.includes(t)}(e))):(Log.warn("TraceProcessor","frameTreeEvents may be incomplete, make sure the trace has frame events"),u.set(r.frameId,r.frameId),p=m);const h=this.computeTimeOrigin({keyEvents:a,frameEvents:m,mainFrameInfo:r},n),f=i.filter((e=>e.tid===o.get(e.pid))),y=this.computeTraceEnd(e.traceEvents,h);return{frames:l,mainThreadEvents:f,frameEvents:m,frameTreeEvents:p,processEvents:i,mainFrameInfo:r,timeOriginEvt:h,
timings:{timeOrigin:0,traceEnd:y.timing},timestamps:{timeOrigin:h.ts,traceEnd:y.timestamp},_keyEvents:a,_rendererPidToTid:o}}static processNavigation(e){const{frameEvents:t,frameTreeEvents:n,timeOriginEvt:a,timings:r,timestamps:o}=e,i=this.computeNavigationTimingsForFrame(t,{timeOriginEvt:a}),s=n.find((e=>"firstContentfulPaint"===e.name&&e.ts>a.ts));if(!s)throw this.createNoFirstContentfulPaintError();const c=this.computeValidLCPAllFrames(n,a).lcp,getTiming=e=>(e-a.ts)/1e3;return{timings:{timeOrigin:r.timeOrigin,firstPaint:i.timings.firstPaint,firstContentfulPaint:i.timings.firstContentfulPaint,firstContentfulPaintAllFrames:getTiming(s.ts),firstMeaningfulPaint:i.timings.firstMeaningfulPaint,largestContentfulPaint:i.timings.largestContentfulPaint,largestContentfulPaintAllFrames:(l=c?.ts,void 0===l?void 0:getTiming(l)),load:i.timings.load,domContentLoaded:i.timings.domContentLoaded,traceEnd:r.traceEnd},timestamps:{timeOrigin:o.timeOrigin,firstPaint:i.timestamps.firstPaint,
firstContentfulPaint:i.timestamps.firstContentfulPaint,firstContentfulPaintAllFrames:s.ts,firstMeaningfulPaint:i.timestamps.firstMeaningfulPaint,largestContentfulPaint:i.timestamps.largestContentfulPaint,largestContentfulPaintAllFrames:c?.ts,load:i.timestamps.load,domContentLoaded:i.timestamps.domContentLoaded,traceEnd:o.traceEnd},firstPaintEvt:i.firstPaintEvt,firstContentfulPaintEvt:i.firstContentfulPaintEvt,firstContentfulPaintAllFramesEvt:s,firstMeaningfulPaintEvt:i.firstMeaningfulPaintEvt,largestContentfulPaintEvt:i.largestContentfulPaintEvt,largestContentfulPaintAllFramesEvt:c,loadEvt:i.loadEvt,domContentLoadedEvt:i.domContentLoadedEvt,fmpFellBack:i.fmpFellBack,lcpInvalidated:i.lcpInvalidated};var l}static computeTraceEnd(e,t){let n=-1/0;for(const t of e)n=Math.max(t.ts+(t.dur||0),n);return{timestamp:n,timing:(n-t.ts)/1e3}}static computeTimeOrigin(e,t){
const lastNavigationStart=()=>e.frameEvents.filter(this._isNavigationStartOfInterest).pop(),lighthouseMarker=()=>e.keyEvents.find((e=>"clock_sync"===e.name&&e.args.sync_id===TraceProcessor.TIMESPAN_MARKER_ID));switch(t){case"firstResourceSendRequest":{const t=e.keyEvents.find((t=>{if("ResourceSendRequest"!==t.name)return!1;return(t.args.data||{}).frame===e.mainFrameInfo.frameId}));if(!t)throw this.createNoResourceSendRequestError();return t}case"lastNavigationStart":{const e=lastNavigationStart();if(!e)throw this.createNoNavstartError();return e}case"lighthouseMarker":{const e=lighthouseMarker();if(!e)throw this.createNoLighthouseMarkerError();return e}case"auto":{const e=lighthouseMarker()||lastNavigationStart();if(!e)throw this.createNoNavstartError();return e}}}static computeNavigationTimingsForFrame(e,t){const{timeOriginEvt:n}=t,a=e.find((e=>"firstPaint"===e.name&&e.ts>n.ts)),r=e.find((e=>"firstContentfulPaint"===e.name&&e.ts>n.ts))
;if(!r)throw this.createNoFirstContentfulPaintError();let o=e.find((e=>"firstMeaningfulPaint"===e.name&&e.ts>n.ts)),i=!1;if(!o){const t="firstMeaningfulPaintCandidate";i=!0,Log.verbose("TraceProcessor",`No firstMeaningfulPaint found, falling back to last ${t}`);const n=e.filter((e=>e.name===t)).pop();n||Log.verbose("TraceProcessor","No `firstMeaningfulPaintCandidate` events found in trace"),o=n}const s=this.computeValidLCPAllFrames(e,n),c=e.find((e=>"loadEventEnd"===e.name&&e.ts>n.ts)),l=e.find((e=>"domContentLoadedEventEnd"===e.name&&e.ts>n.ts)),getTimestamp=e=>e?.ts,u={timeOrigin:n.ts,firstPaint:getTimestamp(a),firstContentfulPaint:r.ts,firstMeaningfulPaint:getTimestamp(o),largestContentfulPaint:getTimestamp(s.lcp),load:getTimestamp(c),domContentLoaded:getTimestamp(l)},getTiming=e=>(e-n.ts)/1e3,maybeGetTiming=e=>void 0===e?void 0:getTiming(e);return{timings:{timeOrigin:0,firstPaint:maybeGetTiming(u.firstPaint),firstContentfulPaint:getTiming(u.firstContentfulPaint),
firstMeaningfulPaint:maybeGetTiming(u.firstMeaningfulPaint),largestContentfulPaint:maybeGetTiming(u.largestContentfulPaint),load:maybeGetTiming(u.load),domContentLoaded:maybeGetTiming(u.domContentLoaded)},timestamps:u,timeOriginEvt:n,firstPaintEvt:a,firstContentfulPaintEvt:r,firstMeaningfulPaintEvt:o,largestContentfulPaintEvt:s.lcp,loadEvt:c,domContentLoadedEvt:l,fmpFellBack:i,lcpInvalidated:s.invalidated}}}class Trace extends FRGatherer{_trace={traceEvents:[]};static getDefaultTraceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack","disabled-by-default-devtools.timeline.frame","latencyInfo"]}static async endTraceAndCollectEvents(e){const t=[],dataListener=function(e){t.push(...e.value)};return e.on("Tracing.dataCollected",dataListener),new Promise(((n,a)=>{
e.once("Tracing.tracingComplete",(a=>{e.off("Tracing.dataCollected",dataListener),n({traceEvents:t})})),e.sendCommand("Tracing.end").catch(a)}))}static symbol=Symbol("Trace");meta={symbol:Trace.symbol,supportedModes:["timespan","navigation"]};async startSensitiveInstrumentation({driver:e,gatherMode:t,settings:n}){const a=Trace.getDefaultTraceCategories().concat(n.additionalTraceCategories||[]);await e.defaultSession.sendCommand("Page.enable"),await e.defaultSession.sendCommand("Tracing.start",{categories:a.join(","),options:"sampling-frequency=10000"}),"timespan"===t&&await e.defaultSession.sendCommand("Tracing.recordClockSyncMarker",{syncId:TraceProcessor.TIMESPAN_MARKER_ID})}async stopSensitiveInstrumentation({driver:e}){this._trace=await Trace.endTraceAndCollectEvents(e.defaultSession)}getArtifact(){return this._trace}}var Gr=Object.freeze({__proto__:null,default:Trace});const Yr=3.75,Kr=.9,Jr={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:Yr,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:Kr,mobileSlow4G:{
rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},Xr={mobile:{mobile:!0,width:412,height:823,deviceScaleFactor:1.75,disabled:!1},desktop:{mobile:!1,width:1350,height:940,deviceScaleFactor:1,disabled:!1}},Zr={mobile:"Mozilla/5.0 (Linux; Android 11; moto g power (2022)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36",desktop:"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36"},Qr={output:"json",maxWaitForFcp:3e4,maxWaitForLoad:45e3,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,
cpuQuietThresholdMs:1e3,formFactor:"mobile",throttling:Jr.mobileSlow4G,throttlingMethod:"simulate",screenEmulation:Xr.mobile,emulatedUserAgent:Zr.mobile,auditMode:!1,gatherMode:!1,disableStorageReset:!1,debugNavigation:!1,channel:"node",usePassiveGathering:!1,disableFullPageScreenshot:!1,skipAboutBlank:!1,blankPage:"about:blank",budgets:null,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null},eo={passName:"defaultPass",loadFailureMode:"fatal",recordTrace:!1,useThrottling:!1,pauseAfterFcpMs:0,pauseAfterLoadMs:0,networkQuietThresholdMs:0,cpuQuietThresholdMs:0,blockedUrlPatterns:[],blankPage:"about:blank",gatherers:[]},to={id:"default",loadFailureMode:"fatal",disableThrottling:!1,disableStorageReset:!1,pauseAfterFcpMs:0,pauseAfterLoadMs:0,networkQuietThresholdMs:0,cpuQuietThresholdMs:0,blockedUrlPatterns:[],blankPage:"about:blank",artifacts:[]},no={pauseAfterFcpMs:5250,
pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250};var ao=Object.freeze({__proto__:null,throttling:Jr,screenEmulationMetrics:Xr,userAgents:Zr,defaultSettings:Qr,defaultPassConfig:eo,defaultNavigationConfig:to,nonSimulatedPassConfigOverrides:no});const ro={warningSlowHostCpu:"The tested device appears to have a slower CPU than  Lighthouse expects. This can negatively affect your performance score. Learn more about [calibrating an appropriate CPU slowdown multiplier](https://github.com/GoogleChrome/lighthouse/blob/main/docs/throttling.md#cpu-throttling)."},oo=createIcuMessageFn("core/gather/driver/environment.js",ro);async function getBrowserVersion(e){const t={msg:"Getting browser version",id:"lh:gather:getVersion"};Log.time(t,"verbose");const n=await e.sendCommand("Browser.getVersion"),a=n.product.match(/\/(\d+)/),r=a?parseInt(a[1]):0;return Log.timeEnd(t),Object.assign(n,{milestone:r})}async function getBenchmarkIndex(e){const t={msg:"Benchmarking machine",
id:"lh:gather:getBenchmarkIndex"};Log.time(t);const n=await e.evaluate(or.computeBenchmarkIndex,{args:[]});return Log.timeEnd(t),n}function getSlowHostCpuWarning(e){const{settings:t,baseArtifacts:n}=e,{throttling:a,throttlingMethod:r}=t,o=Qr.throttling;if("cli"!==t.channel)return;const i="simulate"===r||"devtools"===r,s=a.cpuSlowdownMultiplier===o.cpuSlowdownMultiplier;return!i||!s||n.BenchmarkIndex>1e3?void 0:oo(ro.warningSlowHostCpu)}function getEnvironmentWarnings(e){return[getSlowHostCpuWarning(e)].filter((e=>!!e))}const io={warningData:"{locationCount, plural,\n    =1 {There may be stored data affecting loading performance in this location: {locations}. Audit this page in an incognito window to prevent those resources from affecting your scores.}\n    other {There may be stored data affecting loading performance in these locations: {locations}. Audit this page in an incognito window to prevent those resources from affecting your scores.}\n  }",
warningCacheTimeout:"Clearing the browser cache timed out. Try auditing this page again and file a bug if the issue persists.",warningOriginDataTimeout:"Clearing the origin data timed out. Try auditing this page again and file a bug if the issue persists."},so=createIcuMessageFn("core/gather/driver/storage.js",io);async function clearDataForOrigin(e,t){const n={msg:"Cleaning origin data",id:"lh:storage:clearDataForOrigin"};Log.time(n);const a=[],r=new URL(t).origin,o=["file_systems","shader_cache","service_workers","cache_storage"].join(",");e.setNextProtocolTimeout(5e3);try{await e.sendCommand("Storage.clearDataForOrigin",{origin:r,storageTypes:o})}catch(e){if("PROTOCOL_TIMEOUT"!==e.code)throw e;Log.warn("Driver","clearDataForOrigin timed out"),a.push(so(io.warningOriginDataTimeout))}finally{Log.timeEnd(n)}return a}const co={latency:0,downloadThroughput:0,uploadThroughput:0,offline:!1},lo={rate:1};function parseUseragentIntoMetadata(e,t){
const n=e.match(/Chrome\/([\d.]+)/)?.[1]||"99.0.1234.0",[a]=n.split(".",1),r="mobile"===t;return{brands:[{brand:"Chromium",version:a},{brand:"Google Chrome",version:a},{brand:"Lighthouse",version:_r}],fullVersion:n,...r?{platform:"Android",platformVersion:"11.0",architecture:"",model:"moto g power (2022)"}:{platform:"macOS",platformVersion:"10.15.7",architecture:"x86",model:""},mobile:r}}async function emulate(e,t){if(!1!==t.emulatedUserAgent){const n=t.emulatedUserAgent;await e.sendCommand("Network.setUserAgentOverride",{userAgent:n,userAgentMetadata:parseUseragentIntoMetadata(n,t.formFactor)})}if(!0!==t.screenEmulation.disabled){const{width:n,height:a,deviceScaleFactor:r,mobile:o}=t.screenEmulation,i={width:n,height:a,deviceScaleFactor:r,mobile:o};await e.sendCommand("Emulation.setDeviceMetricsOverride",i),await e.sendCommand("Emulation.setTouchEmulationEnabled",{enabled:i.mobile})}}async function clearThrottling(e){await Promise.all([clearNetworkThrottling(e),clearCPUThrottling(e)])
}function enableNetworkThrottling(e,t){const n={offline:!1,latency:t.requestLatencyMs||0,downloadThroughput:t.downloadThroughputKbps||0,uploadThroughput:t.uploadThroughputKbps||0};return n.downloadThroughput=Math.floor(1024*n.downloadThroughput/8),n.uploadThroughput=Math.floor(1024*n.uploadThroughput/8),e.sendCommand("Network.emulateNetworkConditions",n)}function clearNetworkThrottling(e){return e.sendCommand("Network.emulateNetworkConditions",co)}function enableCPUThrottling(e,t){const n=t.cpuSlowdownMultiplier;return e.sendCommand("Emulation.setCPUThrottlingRate",{rate:n})}function clearCPUThrottling(e){return e.sendCommand("Emulation.setCPUThrottlingRate",lo)}async function enableAsyncStacks(e){const enable=async()=>{await e.sendCommand("Debugger.enable"),await e.sendCommand("Debugger.setSkipAllPauses",{skip:!0}),await e.sendCommand("Debugger.setAsyncCallStackDepth",{maxDepth:8})};function onDebuggerPaused(){e.sendCommand("Debugger.resume")}function onFrameNavigated(e){
e.frame.parentId||enable().catch((e=>Log.error("Driver",e)))}return e.on("Debugger.paused",onDebuggerPaused),e.on("Page.frameNavigated",onFrameNavigated),await enable(),async()=>{await e.sendCommand("Debugger.disable"),e.off("Debugger.paused",onDebuggerPaused),e.off("Page.frameNavigated",onFrameNavigated)}}async function resetStorageForUrl(e,t){const n=[],a=await async function getImportantStorageWarning(e,t){const n=await e.sendCommand("Storage.getUsageAndQuota",{origin:t}),a={local_storage:"Local Storage",indexeddb:"IndexedDB",websql:"Web SQL"},r=n.usageBreakdown.filter((e=>e.usage)).map((e=>a[e.storageType]||"")).filter(Boolean);if(r.length)return so(io.warningData,{locations:r.join(", "),locationCount:r.length})}(e,t);a&&n.push(a);const r=await clearDataForOrigin(e,t);n.push(...r);const o=await async function clearBrowserCaches(e){const t={msg:"Cleaning browser cache",id:"lh:storage:clearBrowserCaches"};Log.time(t);const n=[];try{await e.sendCommand("Network.clearBrowserCache"),
await e.sendCommand("Network.setCacheDisabled",{cacheDisabled:!0}),await e.sendCommand("Network.setCacheDisabled",{cacheDisabled:!1})}catch(e){if("PROTOCOL_TIMEOUT"!==e.code)throw e;Log.warn("Driver","clearBrowserCaches timed out"),n.push(so(io.warningCacheTimeout))}finally{Log.timeEnd(t)}return n}(e);return n.push(...o),{warnings:n}}async function prepareThrottlingAndNetwork(e,t,n){const a={msg:"Preparing network conditions",id:"lh:gather:prepareThrottlingAndNetwork"};Log.time(a),n.disableThrottling?await clearThrottling(e):await async function throttle(e,t){if("devtools"!==t.throttlingMethod)return clearNetworkThrottling(e);await Promise.all([enableNetworkThrottling(e,t.throttling),enableCPUThrottling(e,t.throttling)])}(e,t);const r=(n.blockedUrlPatterns||[]).concat(t.blockedUrlPatterns||[]);await e.sendCommand("Network.setBlockedURLs",{urls:r});const o=t.extraHeaders;o&&await e.sendCommand("Network.setExtraHTTPHeaders",{headers:o}),Log.timeEnd(a)}
async function prepareDeviceEmulation(e,t){await e.defaultSession.sendCommand("Network.enable"),await emulate(e.defaultSession,t)}async function warmUpIntlSegmenter(e){await e.executionContext.evaluate(or.truncate,{args:["aaa",2]})}async function prepareTargetForNavigationMode(e,t){const n={msg:"Preparing target for navigation mode",id:"lh:prepare:navigationMode"};Log.time(n),await prepareDeviceEmulation(e,t),await async function dismissJavaScriptDialogs(e){e.on("Page.javascriptDialogOpening",(t=>{Log.warn("Driver",`${t.type} dialog opened by the page automatically suppressed.`),e.sendCommand("Page.handleJavaScriptDialog",{accept:!0,promptText:"Lighthouse prompt response"}).catch((e=>Log.warn("Driver",e)))})),await e.sendCommand("Page.enable")}(e.defaultSession),await e.executionContext.cacheNativesOnNewDocument(),"simulate"===t.throttlingMethod&&await async function shimRequestIdleCallbackOnNewDocument(e,t){await e.executionContext.evaluateOnNewDocument(or.wrapRequestIdleCallback,{
args:[t.throttling.cpuSlowdownMultiplier]})}(e,t),await warmUpIntlSegmenter(e),Log.timeEnd(n)}async function prepareTargetForIndividualNavigation(e,t,n){const a={msg:"Preparing target for navigation",id:"lh:prepare:navigation"};Log.time(a);const r=[],{requestor:o}=n;if(!t.disableStorageReset&&!n.disableStorageReset&&"string"==typeof o){const t=o,{warnings:n}=await resetStorageForUrl(e,t);r.push(...n)}return await prepareThrottlingAndNetwork(e,t,n),Log.timeEnd(a),{warnings:r}}const uo=3e4;class Driver$1{_eventEmitter=new EventEmitter;_devtoolsLog=new DevtoolsMessageLog(/^(Page|Network|Target|Runtime)\./);_domainEnabledCounts=new Map;_nextProtocolTimeout=uo;online=!0;executionContext=new ExecutionContext(this);defaultSession=this;fetcher=new Fetcher(this.defaultSession);constructor(e){this._connection=e,this.on("Target.attachedToTarget",(e=>{this._handleTargetAttached(e).catch(this._handleEventError)})),this.on("Page.frameNavigated",(e=>{
e.frame.parentId||this.sendCommand("Target.setAutoAttach",{flatten:!0,autoAttach:!0,waitForDebuggerOnStart:!0}).catch(this._handleEventError)})),e.on("protocolevent",this._handleProtocolEvent.bind(this)),this.evaluate=this.executionContext.evaluate.bind(this.executionContext),this.evaluateAsync=this.executionContext.evaluateAsync.bind(this.executionContext),this.targetManager={rootSession:()=>this.defaultSession,mainFrameExecutionContexts:()=>[{id:void 0,uniqueId:void 0,origin:"",name:"",auxData:{isDefault:!0,type:"default",frameId:""}}],on:(e,t)=>{this._connection.on("protocolevent",t)},off:(e,t)=>{this._connection.off("protocolevent",t)}}}static get traceCategories(){return Trace.getDefaultTraceCategories()}async getBrowserVersion(){return getBrowserVersion(this)}async connect(){const e={msg:"Connecting to browser",id:"lh:init:connect"};Log.time(e),await this._connection.connect(),Log.timeEnd(e)}disconnect(){return this._connection.disconnect()}dispose(){return this.disconnect()}
wsEndpoint(){return this._connection.wsEndpoint()}on(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to listen to events.");Log.formatProtocol("listen for event =>",{method:e},"verbose"),this._eventEmitter.on(e,t)}once(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to listen to events.");Log.formatProtocol("listen once for event =>",{method:e},"verbose"),this._eventEmitter.once(e,t)}off(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to remove an event listener.");this._eventEmitter.removeListener(e,t)}setTargetInfo(e){}_shouldToggleDomain(e,t,n){const a=e+(t||""),r=(this._domainEnabledCounts.get(a)||0)+(n?1:-1);return this._domainEnabledCounts.set(a,Math.max(0,r)),n&&1===r||!n&&0===r?(Log.verbose("Driver",`${e}.${n?"enable":"disable"}`),!0):(r<0&&Log.error("Driver",`Attempted to disable domain '${e}' when already disabled.`),!1)}
hasNextProtocolTimeout(){return this._nextProtocolTimeout!==uo}getNextProtocolTimeout(){return this._nextProtocolTimeout}setNextProtocolTimeout(e){this._nextProtocolTimeout=e}_handleProtocolEvent(e){this._devtoolsLog.record(e),this._eventEmitter.emit(e.method,e.params)}_handleEventError(e){Log.error("Driver","Unhandled event error",e.message)}async _handleTargetAttached(e){"iframe"===e.targetInfo.type?await Promise.all([this.sendCommandToSession("Network.enable",e.sessionId),this.sendCommandToSession("Target.setAutoAttach",e.sessionId,{autoAttach:!0,flatten:!0,waitForDebuggerOnStart:!0}),this.sendCommandToSession("Runtime.runIfWaitingForDebugger",e.sessionId)]):await this.sendCommandToSession("Runtime.runIfWaitingForDebugger",e.sessionId)}sendCommandToSession(e,t,...n){const a=this._nextProtocolTimeout;let r;this._nextProtocolTimeout=uo;const o=new Promise(((t,n)=>{a!==1/0&&(r=setTimeout(n,a,new LighthouseError(LighthouseError.errors.PROTOCOL_TIMEOUT,{protocolMethod:e})))}))
;return Promise.race([this._innerSendCommand(e,t,...n),o]).finally((()=>{r&&clearTimeout(r)}))}sendCommand(e,...t){return this.sendCommandToSession(e,void 0,...t)}_innerSendCommand(e,t,...n){const a=/^(\w+)\.(enable|disable)$/.exec(e);if(a){const e="enable"===a[2];if(!this._shouldToggleDomain(a[1],t,e))return Promise.resolve()}return this._connection.sendCommand(e,t,...n)}isDomainEnabled(e){return!!this._domainEnabledCounts.get(e)}async getRequestContent(e,t=1e3){return fetchResponseBodyFromCache(this.defaultSession,e,t)}async beginTrace(e){const t=e?.additionalTraceCategories&&e.additionalTraceCategories.split(",")||[],n=Trace.getDefaultTraceCategories().concat(t),a=Array.from(new Set(n));if(this.isDomainEnabled("CSS"))throw new Error("CSS domain enabled when starting trace");if(this.isDomainEnabled("DOM"))throw new Error("DOM domain enabled when starting trace");return this.sendCommand("Page.enable").then((e=>this.sendCommand("Tracing.start",{categories:a.join(","),
options:"sampling-frequency=10000"})))}endTrace(){return Trace.endTraceAndCollectEvents(this.defaultSession)}async beginDevtoolsLog(){this._disableAsyncStacks=await enableAsyncStacks(this),this._devtoolsLog.reset(),this._devtoolsLog.beginRecording()}async endDevtoolsLog(){return this._devtoolsLog.endRecording(),await(this._disableAsyncStacks?.()),this._devtoolsLog.messages}async url(){const{frameTree:e}=await this.sendCommand("Page.getFrameTree");return`${e.frame.url}${e.frame.urlFragment||""}`}}class ArbitraryEqualityMap{constructor(){this._equalsFn=ArbitraryEqualityMap.deepEquals,this._entries=[]}setEqualityFn(e){this._equalsFn=e}has(e){return-1!==this._findIndexOf(e)}get(e){return this._entries[this._findIndexOf(e)]?.value}set(e,t){let n=this._findIndexOf(e);-1===n&&(n=this._entries.length),this._entries[n]={key:e,value:t}}_findIndexOf(e){for(let t=0;t<this._entries.length;t++)if(this._equalsFn(e,this._entries[t].key))return t;return-1}static deepEquals(e,t){return Xa(e,t)}}
function makeComputedArtifact(e,t){return Object.assign(e,{request:(n,a)=>{const r=t?Object.fromEntries(t.map((e=>[e,n[e]]))):n,o=a.computedCache,i=e.name,s=o.get(i)||new ArbitraryEqualityMap;o.set(i,s);const c=s.get(r);if(c)return c;const l={msg:`Computing artifact: ${i}`,id:`lh:computed:${i}`};Log.time(l,"verbose");const u=e.compute_(r,a);return s.set(r,u),u.then((()=>Log.timeEnd(l))).catch((()=>Log.timeEnd(l))),u}})}class BaseNode{constructor(e){this._id=e,this._isMainDocument=!1,this._dependents=[],this._dependencies=[]}get id(){return this._id}get type(){throw new Error("Unimplemented")}get startTime(){throw new Error("Unimplemented")}get endTime(){throw new Error("Unimplemented")}setIsMainDocument(e){this._isMainDocument=e}isMainDocument(){return this._isMainDocument}getDependents(){return this._dependents.slice()}getNumberOfDependents(){return this._dependents.length}getDependencies(){return this._dependencies.slice()}getNumberOfDependencies(){return this._dependencies.length}
getRootNode(){let e=this;for(;e._dependencies.length;)e=e._dependencies[0];return e}addDependent(e){e.addDependency(this)}addDependency(e){if(e===this)throw new Error("Cannot add dependency on itself");this._dependencies.includes(e)||(e._dependents.push(this),this._dependencies.push(e))}removeDependent(e){e.removeDependency(this)}removeDependency(e){if(!this._dependencies.includes(e))return;const t=e._dependents.indexOf(this);e._dependents.splice(t,1),this._dependencies.splice(this._dependencies.indexOf(e),1)}removeAllDependencies(){for(const e of this._dependencies.slice())this.removeDependency(e)}isDependentOn(e){let t=!1;return this.traverse((n=>{t||(t=n===e)}),(e=>t?[]:e.getDependencies())),t}cloneWithoutRelationships(){const e=new BaseNode(this.id);return e.setIsMainDocument(this._isMainDocument),e}cloneWithRelationships(e){const t=this.getRootNode(),n=new Map;t.traverse((t=>{
n.has(t.id)||(void 0!==e?e(t)&&t.traverse((e=>n.set(e.id,e.cloneWithoutRelationships())),(e=>e._dependencies.filter((e=>!n.has(e.id))))):n.set(t.id,t.cloneWithoutRelationships()))})),t.traverse((e=>{const t=n.get(e.id);if(t)for(const a of e._dependencies){const e=n.get(a.id);if(!e)throw new Error("Dependency somehow not cloned");t.addDependency(e)}}));const a=n.get(this.id);if(!a)throw new Error("Cloned graph missing node");return a}traverse(e,t){for(const{node:n,traversalPath:a}of this.traverseGenerator(t))e(n,a)}*traverseGenerator(e){e||(e=e=>e.getDependents());const t=[[this]],n=new Set([this.id]);for(;t.length;){const a=t.shift(),r=a[0];yield{node:r,traversalPath:a};for(const o of e(r))n.has(o.id)||(n.add(o.id),t.push([o,...a]))}}static hasCycle(e,t="both"){if("both"===t)return BaseNode.hasCycle(e,"dependents")||BaseNode.hasCycle(e,"dependencies");const n=new Set,a=[],r=[e],o=new Map([[e,0]]);for(;r.length;){const e=r.pop();if(a.includes(e))return!0;if(n.has(e))continue
;for(;a.length>o.get(e);)a.pop();n.add(e),a.push(e);const i="dependents"===t?e._dependents:e._dependencies;for(const e of i)r.includes(e)||(r.push(e),o.set(e,a.length))}return!1}canDependOn(e){return e.startTime<=this.startTime}}BaseNode.TYPES={NETWORK:"network",CPU:"cpu"};class NetworkNode extends BaseNode{constructor(e){super(e.requestId),this._record=e}get type(){return BaseNode.TYPES.NETWORK}get startTime(){return 1e3*this._record.networkRequestTime}get endTime(){return 1e3*this._record.networkEndTime}get record(){return this._record}get initiatorType(){return this._record.initiator&&this._record.initiator.type}get fromDiskCache(){return!!this._record.fromDiskCache}get isNonNetworkProtocol(){return NetworkRequest.isNonNetworkRequest(this._record)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){
const e=this._record.priority,t=this._record.resourceType===NetworkRequest.TYPES.Script,n=this._record.resourceType===NetworkRequest.TYPES.Document;return"VeryHigh"===e||"High"===e&&t||"High"===e&&n}cloneWithoutRelationships(){const e=new NetworkNode(this._record);return e.setIsMainDocument(this._isMainDocument),e}}class CPUNode extends BaseNode{constructor(e,t=[]){super(`${e.tid}.${e.ts}`),this._event=e,this._childEvents=t}get type(){return BaseNode.TYPES.CPU}get startTime(){return this._event.ts}get endTime(){return this._event.ts+this._event.dur}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some((e=>"Layout"===e.name))}getEvaluateScriptURLs(){const e=new Set;for(const t of this._childEvents)"EvaluateScript"===t.name&&t.args.data&&t.args.data.url&&e.add(t.args.data.url);return e}cloneWithoutRelationships(){return new CPUNode(this._event,this._childEvents)}}class LHTraceProcessor extends TraceProcessor{
static createNoNavstartError(){return new LighthouseError(LighthouseError.errors.NO_NAVSTART)}static createNoResourceSendRequestError(){return new LighthouseError(LighthouseError.errors.NO_RESOURCE_REQUEST)}static createNoTracingStartedError(){return new LighthouseError(LighthouseError.errors.NO_TRACING_STARTED)}static createNoFirstContentfulPaintError(){return new LighthouseError(LighthouseError.errors.NO_FCP)}}const mo=makeComputedArtifact(class ProcessedTrace{static async compute_(e){return LHTraceProcessor.processTrace(e)}},null),po={Document:.9,XHR:.9,Fetch:.9};class NetworkAnalyzer{static get SUMMARY(){return"__SUMMARY__"}static groupByOrigin(e){const t=new Map;return e.forEach((e=>{const n=e.parsedURL.securityOrigin,a=t.get(n)||[];a.push(e),t.set(n,a)})),t}static getSummary(e){let t;if(e.sort(((e,t)=>e-t)),0===e.length)t=e[0];else if(e.length%2==0){t=(e[Math.floor((e.length-1)/2)]+e[Math.floor((e.length-1)/2)+1])/2}else t=e[Math.floor((e.length-1)/2)];return{min:e[0],
max:e[e.length-1],avg:e.reduce(((e,t)=>e+t),0)/e.length,median:t}}static summarize(e){const t=new Map,n=[];for(const[a,r]of e)t.set(a,NetworkAnalyzer.getSummary(r)),n.push(...r);return t.set(NetworkAnalyzer.SUMMARY,NetworkAnalyzer.getSummary(n)),t}static _estimateValueByOrigin(e,t){const n=NetworkAnalyzer.estimateIfConnectionWasReused(e),a=NetworkAnalyzer.groupByOrigin(e),r=new Map;for(const[e,o]of a.entries()){let a=[];for(const e of o){const r=e.timing;if(!r)continue;const o=t({record:e,timing:r,connectionReused:n.get(e.requestId)});void 0!==o&&(a=a.concat(o))}a.length&&r.set(e,a)}return r}static _estimateRTTByOriginViaConnectionTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({timing:e,connectionReused:t,record:n})=>{if(t)return;if(globalThis.isLightrider&&n.lrStatistics)return n.protocol.startsWith("h3")?n.lrStatistics.TCPMs:[n.lrStatistics.TCPMs/2,n.lrStatistics.TCPMs/2];const{connectStart:a,sslStart:r,sslEnd:o,connectEnd:i}=e
;return i>=0&&a>=0&&n.protocol.startsWith("h3")?i-a:r>=0&&o>=0&&r!==a?[i-r,r-a]:a>=0&&i>=0?i-a:void 0}))}static _estimateRTTByOriginViaDownloadTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:t,connectionReused:n})=>{if(n)return;if(e.transferSize<=14336)return;if(!Number.isFinite(t.receiveHeadersEnd)||t.receiveHeadersEnd<0)return;const a=e.networkEndTime-e.networkRequestTime-t.receiveHeadersEnd,r=Math.log2(e.transferSize/14336);return r>5?void 0:a/r}))}static _estimateRTTByOriginViaSendStartTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:t,connectionReused:n})=>{if(n)return;if(!Number.isFinite(t.sendStart)||t.sendStart<0)return;let a=1;return e.protocol.startsWith("h3")||(a+=1),"https"===e.parsedURL.scheme&&(a+=1),t.sendStart/a}))}static _estimateRTTByOriginViaHeadersEndTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:t,connectionReused:n})=>{
if(!Number.isFinite(t.receiveHeadersEnd)||t.receiveHeadersEnd<0)return;if(!e.resourceType)return;const a=po[e.resourceType]||.4,r=t.receiveHeadersEnd*a;let o=1;return n||(o+=1,e.protocol.startsWith("h3")||(o+=1),"https"===e.parsedURL.scheme&&(o+=1)),Math.max((t.receiveHeadersEnd-r)/o,3)}))}static _estimateResponseTimeByOrigin(e,t){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:n})=>{if(globalThis.isLightrider&&e.lrStatistics)return e.lrStatistics.requestMs;if(!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0)return;if(!Number.isFinite(n.sendEnd)||n.sendEnd<0)return;const a=n.receiveHeadersEnd-n.sendEnd,r=e.parsedURL.securityOrigin,o=t.get(r)||t.get(NetworkAnalyzer.SUMMARY)||0;return Math.max(a-o,0)}))}static canTrustConnectionInformation(e){const t=new Map;for(const n of e){const e=t.get(n.connectionId)||!n.connectionReused;t.set(n.connectionId,e)}return!(t.size<=1)&&Array.from(t.values()).every((e=>e))}static estimateIfConnectionWasReused(e,t){
const{forceCoarseEstimates:n=!1}=t||{};if(!n&&NetworkAnalyzer.canTrustConnectionInformation(e))return new Map(e.map((e=>[e.requestId,!!e.connectionReused])));const a=new Map,r=NetworkAnalyzer.groupByOrigin(e);for(const[e,t]of r.entries()){const e=t.map((e=>e.networkEndTime)).reduce(((e,t)=>Math.min(e,t)),1/0);for(const n of t)a.set(n.requestId,n.networkRequestTime>=e||"h2"===n.protocol);const n=t.reduce(((e,t)=>e.networkRequestTime>t.networkRequestTime?t:e));a.set(n.requestId,!1)}return a}static estimateRTTByOrigin(e,t){const{forceCoarseEstimates:n=!1,coarseEstimateMultiplier:a=.3,useDownloadEstimates:r=!0,useSendStartEstimates:o=!0,useHeadersEndEstimates:i=!0}=t||{};let s=NetworkAnalyzer._estimateRTTByOriginViaConnectionTiming(e);if(!s.size||n){s=new Map;const t=NetworkAnalyzer._estimateRTTByOriginViaDownloadTiming(e),n=NetworkAnalyzer._estimateRTTByOriginViaSendStartTiming(e),c=NetworkAnalyzer._estimateRTTByOriginViaHeadersEndTiming(e);for(const[e,n]of t.entries())r&&s.set(e,n)
;for(const[e,t]of n.entries()){if(!o)continue;const n=s.get(e)||[];s.set(e,n.concat(t))}for(const[e,t]of c.entries()){if(!i)continue;const n=s.get(e)||[];s.set(e,n.concat(t))}for(const e of s.values())e.forEach(((t,n)=>e[n]=t*a))}if(!s.size)throw new Error("No timing information available");return NetworkAnalyzer.summarize(s)}static estimateServerResponseTimeByOrigin(e,t){let n=(t||{}).rttByOrigin;if(!n){n=new Map;const a=NetworkAnalyzer.estimateRTTByOrigin(e,t);for(const[e,t]of a.entries())n.set(e,t.min)}const a=NetworkAnalyzer._estimateResponseTimeByOrigin(e,n);return NetworkAnalyzer.summarize(a)}static estimateThroughput(e){let t=0;const n=e.reduce(((e,n)=>("data"===n.parsedURL?.scheme||n.failed||!n.finished||n.statusCode>300||!n.transferSize||(t+=n.transferSize,e.push({time:n.responseHeadersEndTime/1e3,isStart:!0}),e.push({time:n.networkEndTime/1e3,isStart:!1})),e)),[]).sort(((e,t)=>e.time-t.time));if(!n.length)return 1/0;let a=0,r=0,o=0;return n.forEach((e=>{
e.isStart?(0===a&&(r=e.time),a++):(a--,0===a&&(o+=e.time-r))})),8*t/o}static findResourceForUrl(e,t){return e.find((e=>t.startsWith(e.url)&&UrlUtils.equalWithExcludedFragments(e.url,t)))}static resolveRedirects(e){for(;e.redirectDestination;)e=e.redirectDestination;return e}}const go=makeComputedArtifact(class DocumentUrls{static async compute_(e,t){const n=await mo.request(e.trace,t),a=await bo.request(e.devtoolsLog,t),r=n.mainFrameInfo.frameId;let o,i;for(const t of e.devtoolsLog)if("Page.frameNavigated"===t.method&&t.params.frame.id===r){const{url:e}=t.params.frame;o||(o=e),i=e}if(!o||!i)throw new Error("No main frame navigations found");const s=NetworkAnalyzer.findResourceForUrl(a,o);return s?.redirects?.length&&(o=s.redirects[0].url),{requestedUrl:o,mainDocumentUrl:i}}},["devtoolsLog","trace"]),ho=/^video/;class PageDependencyGraph{static getNetworkInitiators(e){if(!e.initiator)return[];if(e.initiator.url)return[e.initiator.url];if("script"===e.initiator.type){const t=new Set
;let n=e.initiator.stack;for(;n;){const e=n.callFrames||[];for(const n of e)n.url&&t.add(n.url);n=n.parent}return Array.from(t)}return[]}static getNetworkNodeOutput(e){const t=[],n=new Map,a=new Map,r=new Map;return e.forEach((e=>{if(ho.test(e.mimeType))return;for(;n.has(e.requestId);)e.requestId+=":duplicate";const o=new NetworkNode(e);t.push(o);const i=a.get(e.url)||[];if(i.push(o),n.set(e.requestId,o),a.set(e.url,i),e.frameId&&e.resourceType===NetworkRequest.TYPES.Document&&e.documentURL===e.url){const t=r.has(e.frameId)?null:o;r.set(e.frameId,t)}})),{nodes:t,idToNodeMap:n,urlToNodeMap:a,frameIdToNodeMap:r}}static getCPUNodes({mainThreadEvents:e}){const t=[];let n=0;for(TraceProcessor.assertHasToplevelEvents(e);n<e.length;){const a=e[n];if(n++,!TraceProcessor.isScheduleableTask(a)||!a.dur)continue;const r=[];for(const t=a.ts+a.dur;n<e.length&&e[n].ts<t;n++)r.push(e[n]);t.push(new CPUNode(a,r))}return t}static linkNetworkNodes(e,t){t.nodes.forEach((n=>{
const a=n.record.initiatorRequest||e.record,r=t.idToNodeMap.get(a.requestId)||e,o=!r.isDependentOn(n)&&n.canDependOn(r),i=PageDependencyGraph.getNetworkInitiators(n.record);if(i.length?i.forEach((e=>{const a=t.urlToNodeMap.get(e)||[];1===a.length&&a[0].startTime<=n.startTime&&!a[0].isDependentOn(n)?n.addDependency(a[0]):o&&r.addDependent(n)})):o&&r.addDependent(n),n!==e&&0===n.getDependencies().length&&n.canDependOn(e)&&n.addDependency(e),!n.record.redirects)return;const s=[...n.record.redirects,n.record];for(let e=1;e<s.length;e++){const n=t.idToNodeMap.get(s[e-1].requestId),a=t.idToNodeMap.get(s[e].requestId);a&&n&&a.addDependency(n)}}))}static linkCPUNodes(e,t,n){const a=new Set([NetworkRequest.TYPES.XHR,NetworkRequest.TYPES.Fetch,NetworkRequest.TYPES.Script]);function addDependentNetworkRequest(e,n){const r=t.idToNodeMap.get(n);if(!r||r.startTime<=e.startTime)return;const{record:o}=r,i=o.resourceType||o.redirectDestination?.resourceType;a.has(i)&&e.addDependent(r)}
function addDependencyOnFrame(e,n){if(!n)return;const a=t.frameIdToNodeMap.get(n);a&&(a.startTime>=e.startTime||e.addDependency(a))}function addDependencyOnUrl(e,n){if(!n)return;const a=t.urlToNodeMap.get(n)||[];let r=null,o=1/0;for(const t of a){if(e.startTime<=t.startTime)return;const n=e.startTime-t.endTime;n>=-1e5&&n<o&&(r=t,o=n)}r&&e.addDependency(r)}const r=new Map;for(const t of n){for(const e of t.childEvents){if(!e.args.data)continue;const n=e.args.data.url,a=(e.args.data.stackTrace||[]).map((e=>e.url)).filter(Boolean);switch(e.name){case"TimerInstall":r.set(e.args.data.timerId,t),a.forEach((e=>addDependencyOnUrl(t,e)));break;case"TimerFire":{const n=r.get(e.args.data.timerId);if(!n||n.endTime>t.startTime)break;n.addDependent(t);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":addDependencyOnFrame(t,e.args.data.frame),a.forEach((e=>addDependencyOnUrl(t,e)));break;case"EvaluateScript":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,n),
a.forEach((e=>addDependencyOnUrl(t,e)));break;case"XHRReadyStateChange":if(4!==e.args.data.readyState)break;addDependencyOnUrl(t,n),a.forEach((e=>addDependencyOnUrl(t,e)));break;case"FunctionCall":case"v8.compile":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,n);break;case"ParseAuthorStyleSheet":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,e.args.data.styleSheetUrl);break;case"ResourceSendRequest":addDependencyOnFrame(t,e.args.data.frame),addDependentNetworkRequest(t,e.args.data.requestId),a.forEach((e=>addDependencyOnUrl(t,e)))}}0===t.getNumberOfDependencies()&&t.canDependOn(e)&&t.addDependency(e)}let o=!1,i=!1,s=!1;for(const e of n){let t=!1;!o&&e.childEvents.some((e=>"Layout"===e.name))&&(t=o=!0),!i&&e.childEvents.some((e=>"Paint"===e.name))&&(t=i=!0),!s&&e.childEvents.some((e=>"ParseHTML"===e.name))&&(t=s=!0),t||e.event.dur>=1e4||(1===e.getNumberOfDependencies()||e.getNumberOfDependents()<=1)&&PageDependencyGraph._pruneNode(e)}}
static _pruneNode(e){const t=e.getDependencies(),n=e.getDependents();for(const a of t){e.removeDependency(a);for(const e of n)a.addDependent(e)}for(const t of n)e.removeDependent(t)}static createGraph(e,t,n){const a=PageDependencyGraph.getNetworkNodeOutput(t),r=PageDependencyGraph.getCPUNodes(e),{requestedUrl:o,mainDocumentUrl:i}=n;if(!o)throw new Error("requestedUrl is required to get the root request");if(!i)throw new Error("mainDocumentUrl is required to get the main resource");const s=NetworkAnalyzer.findResourceForUrl(t,o);if(!s)throw new Error("rootRequest not found");const c=a.idToNodeMap.get(s.requestId);if(!c)throw new Error("rootNode not found");const l=NetworkAnalyzer.findResourceForUrl(t,i);if(!l)throw new Error("mainDocumentRequest not found");const u=a.idToNodeMap.get(l.requestId);if(!u)throw new Error("mainDocumentNode not found");if(PageDependencyGraph.linkNetworkNodes(c,a),PageDependencyGraph.linkCPUNodes(c,a,r),u.setIsMainDocument(!0),
NetworkNode.hasCycle(c))throw new Error("Invalid dependency graph created, cycle detected");return c}static printGraph(e,t=100){function padRight(e,t,n=" "){return e+n.repeat(Math.max(t-e.length,0))}const n=[];e.traverse((e=>n.push(e))),n.sort(((e,t)=>e.startTime-t.startTime));const a=n[0].startTime,r=(n.reduce(((e,t)=>Math.max(e,t.endTime)),0)-a)/t;n.forEach((e=>{const n=Math.round((e.startTime-a)/r),o=Math.ceil((e.endTime-e.startTime)/r),i=padRight("",n)+padRight("",o,"="),s=e.record?e.record.url:e.type;console.log(padRight(i,t),`| ${s.slice(0,30)}`)}))}static async compute_(e,t){const{trace:n,devtoolsLog:a}=e,[r,o]=await Promise.all([mo.request(n,t),bo.request(a,t)]),i=e.URL||await go.request(e,t);return PageDependencyGraph.createGraph(r,o,i)}}const fo=makeComputedArtifact(PageDependencyGraph,["devtoolsLog","trace","URL"]),yo=EventEmitter;class NetworkRecorder extends yo{constructor(){super(),this._records=[],this._recordsById=new Map}getRawRecords(){return Array.from(this._records)
}onRequestStarted(e){this._records.push(e),this._recordsById.set(e.requestId,e),this.emit("requeststarted",e)}onRequestFinished(e){this.emit("requestfinished",e)}onRequestWillBeSent(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);if(!n){const n=new NetworkRequest;return n.onRequestWillBeSent(t),n.sessionId=e.sessionId,this.onRequestStarted(n),void Log.verbose("network",`request will be sent to ${n.url}`)}if(!t.redirectResponse)return;const a={...t,initiator:n.initiator,requestId:`${n.requestId}:redirect`},r=new NetworkRequest;r.onRequestWillBeSent(a),n.onRedirectResponse(t),Log.verbose("network",`${n.url} redirected to ${r.url}`),n.redirectDestination=r,r.redirectSource=n,this.onRequestStarted(r),this.onRequestFinished(n)}onRequestServedFromCache(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);n&&(Log.verbose("network",`${n.url} served from cache`),n.onRequestServedFromCache())}
onResponseReceived(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);n&&(Log.verbose("network",`${n.url} response received`),n.onResponseReceived(t))}onDataReceived(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);n&&(Log.verbose("network",`${n.url} data received`),n.onDataReceived(t))}onLoadingFinished(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);n&&(Log.verbose("network",`${n.url} loading finished`),n.onLoadingFinished(t),this.onRequestFinished(n))}onLoadingFailed(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);n&&(Log.verbose("network",`${n.url} loading failed`),n.onLoadingFailed(t),this.onRequestFinished(n))}onResourceChangedPriority(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.targetType,e.sessionId);n&&n.onResourceChangedPriority(t)}dispatch(e){switch(e.method){
case"Network.requestWillBeSent":return this.onRequestWillBeSent(e);case"Network.requestServedFromCache":return this.onRequestServedFromCache(e);case"Network.responseReceived":return this.onResponseReceived(e);case"Network.dataReceived":return this.onDataReceived(e);case"Network.loadingFinished":return this.onLoadingFinished(e);case"Network.loadingFailed":return this.onLoadingFailed(e);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(e);default:return}}_findRealRequestAndSetSession(e,t,n){let a=this._recordsById.get(e);if(a&&a.isValid){for(;a.redirectDestination;)a=a.redirectDestination;return a.setSession(n),a.sessionTargetType=t,a}}static _chooseInitiatorRequest(e,t){if(e.redirectSource)return e.redirectSource;const n=fo.getNetworkInitiators(e)[0];let a=t.get(n)||[];if(a=a.filter((t=>t.responseHeadersEndTime<=e.networkRequestTime&&t.finished&&!t.failed)),a.length>1){const e=a.filter((e=>e.resourceType!==NetworkRequest.TYPES.Other));e.length&&(a=e)}
if(a.length>1){const t=a.filter((t=>t.frameId===e.frameId));t.length&&(a=t)}if(a.length>1&&"parser"===e.initiator.type){const e=a.filter((e=>e.resourceType===NetworkRequest.TYPES.Document));e.length&&(a=e)}if(a.length>1){const e=a.filter((e=>e.isLinkPreload));if(e.length){const t=a.filter((e=>!e.isLinkPreload)),n=t.every((e=>e.fromDiskCache||e.fromMemoryCache));t.length&&n&&(a=e)}}return 1===a.length?a[0]:null}static recordsFromLogs(e){const t=new NetworkRecorder;e.forEach((e=>t.dispatch(e)));const n=t.getRawRecords().filter((e=>e.isValid)),a=new Map;for(const e of n){const t=a.get(e.url)||[];t.push(e),a.set(e.url,t)}for(const e of n){const t=NetworkRecorder._chooseInitiatorRequest(e,a);t&&e.setInitiatorRequest(t);let n=e;for(;n.redirectDestination;)n=n.redirectDestination;if(n===e||n.redirects)continue;const r=[];for(let e=n.redirectSource;e;e=e.redirectSource)r.unshift(e);n.redirects=r}return n}}const bo=makeComputedArtifact(class NetworkRecords{static async compute_(e){
return NetworkRecorder.recordsFromLogs(e)}},null),vo={warningXhtml:"The page MIME type is XHTML: Lighthouse does not explicitly support this document type"},wo=createIcuMessageFn("core/lib/navigation-error.js",vo),Do="application/xhtml+xml";function getPageLoadError(e,t){const{url:n,loadFailureMode:a,networkRecords:r}=t;let o,i=NetworkAnalyzer.findResourceForUrl(r,n);if(!i){const e=r.filter((e=>e.resourceType===NetworkRequest.TYPES.Document));e.length&&(i=e.reduce(((e,t)=>t.networkRequestTime<e.networkRequestTime?t:e)))}i&&(o=NetworkAnalyzer.resolveRedirects(i)),o?.mimeType===Do&&t.warnings.push(wo(vo.warningXhtml));const s=function getNetworkError(e){if(!e)return new LighthouseError(LighthouseError.errors.NO_DOCUMENT_REQUEST);if(e.failed){const t=e.localizedFailDescription
;return"net::ERR_NAME_NOT_RESOLVED"===t||"net::ERR_NAME_RESOLUTION_FAILED"===t||t.startsWith("net::ERR_DNS_")?new LighthouseError(LighthouseError.errors.DNS_FAILURE):new LighthouseError(LighthouseError.errors.FAILED_DOCUMENT_REQUEST,{errorDetails:t})}return e.hasErrorStatusCode()?new LighthouseError(LighthouseError.errors.ERRORED_DOCUMENT_REQUEST,{statusCode:`${e.statusCode}`}):void 0}(i),c=function getInterstitialError(e,t){if(!e)return;return t.find((e=>e.documentURL.startsWith("chrome-error://")))&&e.failed?e.localizedFailDescription.startsWith("net::ERR_CERT")?new LighthouseError(LighthouseError.errors.INSECURE_DOCUMENT_REQUEST,{securityMessages:e.localizedFailDescription}):new LighthouseError(LighthouseError.errors.CHROME_INTERSTITIAL_ERROR):void 0}(i,r),l=function getNonHtmlError(e){if(e)return"text/html"!==e.mimeType&&e.mimeType!==Do?new LighthouseError(LighthouseError.errors.NOT_HTML,{mimeType:e.mimeType}):void 0}(o);if("ignore"!==a)return c||(s||(l||e))}const Eo=EventEmitter
;class NetworkMonitor extends Eo{_networkRecorder=void 0;_frameNavigations=[];constructor(e){super(),this._targetManager=e,this._session=e.rootSession(),this._onFrameNavigated=e=>this._frameNavigations.push(e.frame),this._onProtocolMessage=e=>{this._networkRecorder&&this._networkRecorder.dispatch(e)}}async enable(){if(this._networkRecorder)return;this._frameNavigations=[],this._networkRecorder=new NetworkRecorder;const reEmit=e=>t=>{this.emit(e,t),this._emitNetworkStatus()};this._networkRecorder.on("requeststarted",reEmit("requeststarted")),this._networkRecorder.on("requestfinished",reEmit("requestfinished")),this._session.on("Page.frameNavigated",this._onFrameNavigated),this._targetManager.on("protocolevent",this._onProtocolMessage)}async disable(){this._networkRecorder&&(this._session.off("Page.frameNavigated",this._onFrameNavigated),this._targetManager.off("protocolevent",this._onProtocolMessage),this._frameNavigations=[],this._networkRecorder=void 0)}async getNavigationUrls(){
const e=this._frameNavigations;if(!e.length)return{};const t=e.filter((e=>!e.parentId));t.length||Log.warn("NetworkMonitor","No detected navigations");let n=t[0]?.url;if(this._networkRecorder){let e=this._networkRecorder.getRawRecords().find((e=>e.url===n));for(;e?.redirectSource;)e=e.redirectSource,n=e.url}return{requestedUrl:n,mainDocumentUrl:t[t.length-1]?.url}}getInflightRequests(){return this._networkRecorder?this._networkRecorder.getRawRecords().filter((e=>!e.finished)):[]}isIdle(){return this._isActiveIdlePeriod(0)}isCriticalIdle(){if(!this._networkRecorder)return!1;const e=this._networkRecorder.getRawRecords().find((e=>"Document"===e.resourceType))?.frameId;return this._isActiveIdlePeriod(0,(t=>t.frameId===e&&("VeryHigh"===t.priority||"High"===t.priority)))}is2Idle(){return this._isActiveIdlePeriod(2)}_isActiveIdlePeriod(e,t){if(!this._networkRecorder)return!1;const n=this._networkRecorder.getRawRecords();let a=0;for(let e=0;e<n.length;e++){const r=n[e]
;r.finished||(t&&!t(r)||NetworkRequest.isNonNetworkRequest(r)||a++)}return a<=e}_emitNetworkStatus(){const e=this.isIdle(),t=this.is2Idle(),n=this.isCriticalIdle();this.emit(e?"networkidle":"networkbusy"),this.emit(t?"network-2-idle":"network-2-busy"),this.emit(n?"network-critical-idle":"network-critical-busy"),t&&e?Log.verbose("NetworkRecorder","network fully-quiet"):t&&!e?Log.verbose("NetworkRecorder","network semi-quiet"):Log.verbose("NetworkRecorder","network busy")}static findNetworkQuietPeriods(e,t,n=1/0){let a=[];e.forEach((e=>{UrlUtils.isNonNetworkProtocol(e.protocol)||"ws"!==e.protocol&&"wss"!==e.protocol&&(a.push({time:1e3*e.networkRequestTime,isStart:!0}),e.finished&&a.push({time:1e3*e.networkEndTime,isStart:!1}))})),a=a.filter((e=>e.time<=n)).sort(((e,t)=>e.time-t.time));let r=0,o=0;const i=[];return a.forEach((e=>{e.isStart?(r===t&&i.push({start:o,end:e.time}),r++):(r--,r===t&&(o=e.time))})),r<=t&&i.push({start:o,end:n}),i.filter((e=>e.start!==e.end))}}
function waitForNothing(){return{promise:Promise.resolve(),cancel(){}}}function waitForFrameNavigated(e){let cancel=()=>{throw new Error("waitForFrameNavigated.cancel() called before it was defined")};return{promise:new Promise(((t,n)=>{e.once("Page.frameNavigated",t),cancel=()=>{e.off("Page.frameNavigated",t),n(new Error("Wait for navigated cancelled"))}})),cancel}}function waitForNetworkIdle(e,t,n){let a,r=!1,cancel=()=>{throw new Error("waitForNetworkIdle.cancel() called before it was defined")};const{networkQuietThresholdMs:o,busyEvent:i,idleEvent:s,isIdle:c}=n;return{promise:new Promise(((l,u)=>{const onIdle=()=>{t.once(i,onBusy),a=setTimeout((()=>{cancel(),l()}),o)},onBusy=()=>{t.once(s,onIdle),a&&clearTimeout(a)},domContentLoadedListener=()=>{r=!0,c(t)?onIdle():onBusy()},logStatus=()=>{if(!r)return void Log.verbose("waitFor","Waiting on DomContentLoaded");const e=t.getInflightRequests();if(Log.isVerbose()&&e.length<20&&e.length>0){
Log.verbose("waitFor",`=== Waiting on ${e.length} requests to finish`);for(const t of e)Log.verbose("waitFor",`Waiting on ${t.url.slice(0,120)} to finish`)}};t.on("requeststarted",logStatus),t.on("requestfinished",logStatus),t.on(i,logStatus),n.pretendDCLAlreadyFired?domContentLoadedListener():e.once("Page.domContentEventFired",domContentLoadedListener);let d=!1;cancel=()=>{d||(d=!0,a&&clearTimeout(a),n.pretendDCLAlreadyFired||e.off("Page.domContentEventFired",domContentLoadedListener),t.removeListener(i,onBusy),t.removeListener(s,onIdle),t.removeListener("requeststarted",logStatus),t.removeListener("requestfinished",logStatus),t.removeListener(i,logStatus))}})),cancel}}function registerPerformanceObserverInPage(){if(void 0!==window.____lastLongTask)return;window.____lastLongTask=performance.now();new window.PerformanceObserver((e=>{const t=e.getEntries();for(const e of t)if("longtask"===e.entryType){const t=e.startTime+e.duration
;window.____lastLongTask=Math.max(window.____lastLongTask||0,t)}})).observe({type:"longtask",buffered:!0})}function checkTimeSinceLastLongTaskInPage(){return new Promise((e=>{const t=performance.now(),n=window.____lastLongTask||0;setTimeout((()=>{const a=window.____lastLongTask||0;e(n===a?t-n:0)}),150)}))}function waitForLoadEvent(e,t){let cancel=()=>{throw new Error("waitForLoadEvent.cancel() called before it was defined")};return{promise:new Promise(((n,a)=>{let r;const loadListener=function(){r=setTimeout(n,t)};e.once("Page.loadEventFired",loadListener);let o=!1;cancel=()=>{o||(o=!0,e.off("Page.loadEventFired",loadListener),r&&clearTimeout(r))}})),cancel}}const To={waitForFcp:function waitForFcp(e,t,n){let cancel=()=>{throw new Error("waitForFcp.cancel() called before it was defined")};return{promise:new Promise(((a,r)=>{const o=setTimeout((()=>{r(new LighthouseError(LighthouseError.errors.NO_FCP))}),n);let i;const lifecycleListener=e=>{
"firstContentfulPaint"===e.name&&(i=setTimeout((()=>{a(),cancel()}),t))};e.on("Page.lifecycleEvent",lifecycleListener);let s=!1;cancel=()=>{s||(s=!0,e.off("Page.lifecycleEvent",lifecycleListener),o&&clearTimeout(o),i&&clearTimeout(i),r(new Error("Wait for FCP canceled")))}})),cancel}},waitForLoadEvent,waitForCPUIdle:function waitForCPUIdle(e,t){if(!t)return{promise:Promise.resolve(),cancel:()=>{}};let n,a=!1;async function checkForQuiet(e,r){if(a)return;const o=await e.evaluate(checkTimeSinceLastLongTaskInPage,{args:[],useIsolation:!0});if(!a&&"number"==typeof o)if(o>=t)Log.verbose("waitFor",`CPU has been idle for ${o} ms`),r();else{Log.verbose("waitFor",`CPU has been idle for ${o} ms`);n=setTimeout((()=>checkForQuiet(e,r)),t-o)}}let cancel=()=>{throw new Error("waitForCPUIdle.cancel() called before it was defined")};const r=new ExecutionContext(e);return{promise:new Promise(((e,t)=>{r.evaluate(registerPerformanceObserverInPage,{args:[],useIsolation:!0
}).then((()=>checkForQuiet(r,e))).catch(t),cancel=()=>{a||(a=!0,n&&clearTimeout(n),t(new Error("Wait for CPU idle canceled")))}})),cancel}},waitForNetworkIdle};const Co={warningRedirected:"The page may not be loading as expected because your test URL ({requested}) was redirected to {final}. Try testing the second URL directly.",warningTimeout:"The page loaded too slowly to finish within the time limit. Results may be incomplete."},So=createIcuMessageFn("core/gather/driver/navigation.js",Co);async function gotoURL(e,t,n){const a="string"==typeof t?{msg:`Navigating to ${t}`,id:"lh:driver:navigate"}:{msg:"Navigating using a user defined function",id:"lh:driver:navigate"};Log.time(a);const r=e.defaultSession,o=new NetworkMonitor(e.targetManager);let i;await o.enable(),await r.sendCommand("Page.enable"),await r.sendCommand("Page.setLifecycleEventsEnabled",{enabled:!0}),"string"==typeof t?(r.setNextProtocolTimeout(1/0),i=r.sendCommand("Page.navigate",{url:t})):i=t()
;const s=n.waitUntil.includes("navigated"),c=n.waitUntil.includes("load"),l=n.waitUntil.includes("fcp"),u=[];if(s){const e=waitForFrameNavigated(r).promise;u.push(e.then((()=>({timedOut:!1}))))}if(c){const e=function resolveWaitForFullyLoadedOptions(e){let{pauseAfterFcpMs:t,pauseAfterLoadMs:n,networkQuietThresholdMs:a,cpuQuietThresholdMs:r}=e,o=e.maxWaitForLoad,i=e.maxWaitForFcp;return"number"!=typeof t&&(t=0),"number"!=typeof n&&(n=0),"number"!=typeof a&&(a=5e3),"number"!=typeof r&&(r=0),"number"!=typeof o&&(o=Qr.maxWaitForLoad),"number"!=typeof i&&(i=Qr.maxWaitForFcp),e.waitUntil.includes("fcp")||(i=void 0),{pauseAfterFcpMs:t,pauseAfterLoadMs:n,networkQuietThresholdMs:a,cpuQuietThresholdMs:r,maxWaitForLoadedMs:o,maxWaitForFcpMs:i}}(n);u.push(async function waitForFullyLoaded(e,t,n){
const{pauseAfterFcpMs:a,pauseAfterLoadMs:r,networkQuietThresholdMs:o,cpuQuietThresholdMs:i,maxWaitForLoadedMs:s,maxWaitForFcpMs:c}=n,{waitForFcp:l,waitForLoadEvent:u,waitForNetworkIdle:d,waitForCPUIdle:m}=n._waitForTestOverrides||To;let p;const h=c?l(e,a,c):waitForNothing(),f=u(e,r),y=d(e,t,{networkQuietThresholdMs:o,busyEvent:"network-2-busy",idleEvent:"network-2-idle",isIdle:e=>e.is2Idle()}),b=d(e,t,{networkQuietThresholdMs:o,busyEvent:"network-critical-busy",idleEvent:"network-critical-idle",isIdle:e=>e.isCriticalIdle()});let v=waitForNothing();const w=Promise.all([h.promise,f.promise,y.promise,b.promise]).then((()=>(v=m(e,i),v.promise))).then((()=>async function(){return Log.verbose("waitFor","loadEventFired and network considered idle"),{timedOut:!1}})).catch((e=>function(){throw e})),D=new Promise(((e,t)=>{p=setTimeout(e,s)})).then((n=>async()=>{if(Log.warn("waitFor","Timed out waiting for page load. Checking if page is hung..."),await async function isPageHung(e){try{
return e.setNextProtocolTimeout(1e3),await e.sendCommand("Runtime.evaluate",{expression:'"ping"',returnByValue:!0,timeout:1e3}),!1}catch(e){return!0}}(e))throw Log.warn("waitFor","Page appears to be hung, killing JavaScript..."),await e.sendCommand("Emulation.setScriptExecutionDisabled",{value:!0}),await e.sendCommand("Runtime.terminateExecution"),new LighthouseError(LighthouseError.errors.PAGE_HUNG);const n=t.getInflightRequests().map((e=>e.url));return n.length>0&&Log.warn("waitFor","Remaining inflight requests URLs",n),{timedOut:!0}})),E=await Promise.race([w,D]);return p&&clearTimeout(p),h.cancel(),f.cancel(),y.cancel(),v.cancel(),E()}(r,o,e))}else if(l)throw new Error("Cannot wait for FCP without waiting for page load");const d=(await Promise.all(u)).some((e=>e.timedOut)),m=await o.getNavigationUrls();let p=m.requestedUrl;if("string"==typeof t&&(p&&!UrlUtils.equalWithExcludedFragments(t,p)&&Log.error("Navigation",`Provided URL (${t}) did not match initial navigation URL (${p})`),
p=t),!p)throw Error("No navigations detected when running user defined requestor.");const h=m.mainDocumentUrl||p;return await i,await o.disable(),n.debugNavigation&&await function waitForUserToContinue(e){return e.defaultSession.setNextProtocolTimeout(2**31-1),e.executionContext.evaluate((function createInPagePromise(){let resolve=()=>{};const e=new Promise((e=>resolve=e));return console.log(["You have enabled Lighthouse navigation debug mode.",'When you have finished inspecting the page, evaluate "continueLighthouseRun()"',"in the console to continue with the Lighthouse run."].join(" ")),window.continueLighthouseRun=resolve,e}),{args:[]})}(e),Log.timeEnd(a),{requestedUrl:p,mainDocumentUrl:h,warnings:getNavigationWarnings({timedOut:d,mainDocumentUrl:h,requestedUrl:p})}}function getNavigationWarnings(e){const{requestedUrl:t,mainDocumentUrl:n}=e,a=[];return e.timedOut&&a.push(So(Co.warningTimeout)),UrlUtils.equalWithExcludedFragments(t,n)||a.push(So(Co.warningRedirected,{requested:t,
final:n})),a}function getServiceWorkerVersions(e){return new Promise(((t,n)=>{const versionUpdatedListener=a=>{const r=a.versions.filter((e=>"redundant"!==e.status)),o=r.find((e=>"activated"===e.status));r.length&&!o||(e.off("ServiceWorker.workerVersionUpdated",versionUpdatedListener),e.sendCommand("ServiceWorker.disable").then((e=>t(a)),n))};e.on("ServiceWorker.workerVersionUpdated",versionUpdatedListener),e.sendCommand("ServiceWorker.enable").catch(n)}))}function getServiceWorkerRegistrations(e){return new Promise(((t,n)=>{e.once("ServiceWorker.workerRegistrationUpdated",(a=>{e.sendCommand("ServiceWorker.disable").then((e=>t(a)),n)})),e.sendCommand("ServiceWorker.enable").catch(n)}))}class NetworkUserAgent extends FRGatherer{meta={supportedModes:["timespan","navigation"],dependencies:{DevtoolsLog:DevtoolsLog.symbol}};static getNetworkUserAgent(e){for(const t of e){if("Network.requestWillBeSent"!==t.method)continue;const e=t.params.request.headers["User-Agent"];if(e)return e}return""}
async getArtifact(e){return NetworkUserAgent.getNetworkUserAgent(e.dependencies.DevtoolsLog)}}var _o=Object.freeze({__proto__:null,default:NetworkUserAgent});async function getBaseArtifacts(e,t,n){const a=await getBenchmarkIndex(t.executionContext),{userAgent:r}=await getBrowserVersion(t.defaultSession);return{fetchTime:(new Date).toJSON(),Timing:[],LighthouseRunWarnings:[],settings:e.settings,BenchmarkIndex:a,HostUserAgent:r,HostFormFactor:r.includes("Android")||r.includes("Mobile")?"mobile":"desktop",URL:{finalDisplayedUrl:""},PageLoadError:null,GatherContext:n,NetworkUserAgent:"",traces:{},devtoolsLogs:{}}}function finalizeArtifacts(e,t){const n=e.LighthouseRunWarnings.concat(t.LighthouseRunWarnings||[]).concat(getEnvironmentWarnings({settings:e.settings,baseArtifacts:e})),a={...e,...t};if(a.Timing=Log.getTimeEntries(),a.LighthouseRunWarnings=function deduplicateWarnings(e){const t=[];for(const n of e)t.some((e=>Xa(n,e)))||t.push(n);return t}(n),
a.PageLoadError&&!a.URL.finalDisplayedUrl&&(a.URL.finalDisplayedUrl=a.URL.requestedUrl||""),!a.URL.finalDisplayedUrl)throw new Error("Runner did not set finalDisplayedUrl");return a}class GatherRunner{static async loadBlank(e,t=eo.blankPage){const n={msg:"Resetting state with about:blank",id:"lh:gather:loadBlank"};Log.time(n),await gotoURL(e,t,{waitUntil:["navigated"]}),Log.timeEnd(n)}static async loadPage(e,t){const n={msg:"Loading page & waiting for onload",id:`lh:gather:loadPage-${t.passConfig.passName}`};Log.time(n);try{const a=t.url,{mainDocumentUrl:r,warnings:o}=await gotoURL(e,a,{waitUntil:t.passConfig.recordTrace?["load","fcp"]:["load"],debugNavigation:t.settings.debugNavigation,maxWaitForFcp:t.settings.maxWaitForFcp,maxWaitForLoad:t.settings.maxWaitForLoad,...t.passConfig});t.url=r;const{URL:i}=t.baseArtifacts;i.finalDisplayedUrl&&i.mainDocumentUrl||(i.mainDocumentUrl=r,i.finalDisplayedUrl=await t.driver.url()),
"fatal"===t.passConfig.loadFailureMode&&t.LighthouseRunWarnings.push(...o)}catch(e){if("NO_FCP"===e.code||"PAGE_HUNG"===e.code)return{navigationError:e};throw e}finally{Log.timeEnd(n)}return{}}static assertNoSameOriginServiceWorkerClients(e,t){let n,a;return getServiceWorkerRegistrations(e).then((e=>{n=e.registrations})).then((t=>getServiceWorkerVersions(e))).then((e=>{a=e.versions})).then((e=>{const r=new URL(t).origin;n.filter((e=>{const t=new URL(e.scopeURL).origin;return r===t})).forEach((e=>{a.forEach((t=>{if(t.registrationId===e.registrationId&&t.controlledClients&&t.controlledClients.length>0)throw new Error("You probably have multiple tabs open to the same origin.")}))}))}))}static async setupDriver(e,t){const n={msg:"Initializing…",id:"lh:gather:setupDriver"};Log.time(n);const a=e.defaultSession;await GatherRunner.assertNoSameOriginServiceWorkerClients(a,t.requestedUrl),await prepareTargetForNavigationMode(e,t.settings),Log.timeEnd(n)}static async disposeDriver(e,t){const n={
msg:"Disconnecting from browser...",id:"lh:gather:disconnect"};Log.time(n);try{const n=e.defaultSession;!t.settings.disableStorageReset&&await clearDataForOrigin(n,t.requestedUrl),await e.disconnect()}catch(e){/close\/.*status: (500|404)$/.test(e.message)||Log.error("GatherRunner disconnect",e.message)}Log.timeEnd(n)}static async beginRecording(e){const t={msg:"Beginning devtoolsLog and trace",id:"lh:gather:beginRecording"};Log.time(t);const{driver:n,passConfig:a,settings:r}=e;await n.beginDevtoolsLog(),a.recordTrace&&await n.beginTrace(r),Log.timeEnd(t)}static async endRecording(e){const{driver:t,passConfig:n}=e;let a;if(n.recordTrace){const e={msg:"Gathering trace",id:"lh:gather:getTrace"};Log.time(e),a=await t.endTrace(),Log.timeEnd(e)}const r={msg:"Gathering devtoolsLog & network records",id:"lh:gather:getDevtoolsLog"};Log.time(r);const o=await t.endDevtoolsLog(),i=await bo.request(o,e);return Log.timeEnd(r),{networkRecords:i,devtoolsLog:o,trace:a}}static async beforePass(e,t){
const n={msg:"Running beforePass methods",id:"lh:gather:beforePass"};Log.time(n,"verbose");for(const n of e.passConfig.gatherers){const a=n.instance,r={msg:`Gathering setup: ${a.name}`,id:`lh:gather:beforePass:${a.name}`};Log.time(r,"verbose");const o=Promise.resolve().then((t=>a.beforePass(e)));t[a.name]=[o],await o.catch((()=>{})),Log.timeEnd(r)}Log.timeEnd(n)}static async pass(e,t){const n=e.passConfig.gatherers,a={msg:"Running pass methods",id:"lh:gather:pass"};Log.time(a,"verbose");for(const a of n){const n=a.instance,r={msg:`Gathering in-page: ${n.name}`,id:`lh:gather:pass:${n.name}`};Log.time(r);const o=Promise.resolve().then((t=>n.pass(e))),i=t[n.name]||[];i.push(o),t[n.name]=i,await o.catch((()=>{}))}Log.timeEnd(a)}static async afterPass(e,t,n){const a=e.passConfig.gatherers,r={msg:"Running afterPass methods",id:"lh:gather:afterPass"};Log.time(r,"verbose");for(const r of a){const a=r.instance,o={msg:`Gathering: ${a.name}`,id:`lh:gather:afterPass:${a.name}`};Log.time(o)
;const i=Promise.resolve().then((n=>a.afterPass(e,t))),s=n[a.name]||[];s.push(i),n[a.name]=s,await i.catch((()=>{})),Log.timeEnd(o)}Log.timeEnd(r)}static async collectArtifacts(e){const t={},n=Object.entries(e);for(const[e,a]of n){try{const n=(await Promise.all(a)).filter((e=>void 0!==e)),r=n[n.length-1];t[e]=r}catch(n){t[e]=n}if(void 0===t[e])throw new Error(`${e} failed to provide an artifact.`)}return{artifacts:t}}static async initializeBaseArtifacts(e){const t=(await e.driver.getBrowserVersion()).userAgent,n=t.includes("Android")||t.includes("Mobile")?"mobile":"desktop";return{fetchTime:(new Date).toJSON(),LighthouseRunWarnings:[],HostFormFactor:n,HostUserAgent:t,NetworkUserAgent:"",BenchmarkIndex:0,traces:{},devtoolsLogs:{},settings:e.settings,GatherContext:{gatherMode:"navigation"},URL:{requestedUrl:e.requestedUrl,mainDocumentUrl:"",finalDisplayedUrl:""},Timing:[],PageLoadError:null}}static async populateBaseArtifacts(e){const t={msg:"Populate base artifacts",
id:"lh:gather:populateBaseArtifacts"};Log.time(t);const n=e.baseArtifacts,a=n.devtoolsLogs[e.passConfig.passName];n.NetworkUserAgent=NetworkUserAgent.getNetworkUserAgent(a);const r=getEnvironmentWarnings(e);n.LighthouseRunWarnings.push(...r),Log.timeEnd(t)}static async run(e,t){const n=t.driver,a={};try{await n.connect(),await GatherRunner.loadBlank(n);const r=await GatherRunner.initializeBaseArtifacts(t);r.BenchmarkIndex=await getBenchmarkIndex(n.executionContext);const o=UrlUtils.isValid(t.requestedUrl)&&new URL(t.requestedUrl);if("lr"===t.settings.channel&&o&&o.searchParams.has("bidx")){const e=Number(o.searchParams.get("bidx"))||0,t=[r.BenchmarkIndex];for(let a=0;a<e;a++){const e=await getBenchmarkIndex(n.executionContext);t.push(e)}r.BenchmarkIndexes=t}await GatherRunner.setupDriver(n,t);let i=!0;for(const o of e){const e={gatherMode:"navigation",driver:n,url:t.requestedUrl,settings:t.settings,passConfig:o,baseArtifacts:r,computedCache:t.computedCache,
LighthouseRunWarnings:r.LighthouseRunWarnings},s=await GatherRunner.runPass(e);if(Object.assign(a,s.artifacts),s.pageLoadError&&"fatal"===o.loadFailureMode){r.PageLoadError=s.pageLoadError;break}i&&(await GatherRunner.populateBaseArtifacts(e),i=!1)}return await GatherRunner.disposeDriver(n,t),finalizeArtifacts(r,a)}catch(e){throw GatherRunner.disposeDriver(n,t),e}}static _addLoadDataToBaseArtifacts(e,t,n){const a=e.baseArtifacts;a.devtoolsLogs[n]=t.devtoolsLog,t.trace&&(a.traces[n]=t.trace)}static async runPass(e){const t={msg:`Running ${e.passConfig.passName} pass`,id:`lh:gather:runPass-${e.passConfig.passName}`,args:[e.passConfig.gatherers.map((e=>e.instance.name)).join(", ")]};Log.time(t);const n={},{driver:a,passConfig:r}=e;await GatherRunner.loadBlank(a,r.blankPage);const{warnings:o}=await prepareTargetForIndividualNavigation(a.defaultSession,e.settings,{requestor:e.url,disableStorageReset:!r.useThrottling,disableThrottling:!r.useThrottling,blockedUrlPatterns:r.blockedUrlPatterns
});e.LighthouseRunWarnings.push(...o),await GatherRunner.beforePass(e,n),await GatherRunner.beginRecording(e);const{navigationError:i}=await GatherRunner.loadPage(a,e);await GatherRunner.pass(e,n);const s=await GatherRunner.endRecording(e);await clearThrottling(a.defaultSession);const c=getPageLoadError(i,{url:e.url,loadFailureMode:r.loadFailureMode,networkRecords:s.networkRecords,warnings:e.LighthouseRunWarnings});if(c){const n=getFormatted(c.friendlyMessage,e.settings.locale);return Log.error("GatherRunner",n,e.url),e.LighthouseRunWarnings.push(c.friendlyMessage),GatherRunner._addLoadDataToBaseArtifacts(e,s,`pageLoadError-${r.passName}`),Log.timeEnd(t),{artifacts:{},pageLoadError:c}}GatherRunner._addLoadDataToBaseArtifacts(e,s,r.passName),await GatherRunner.afterPass(e,s,n);const l=GatherRunner.collectArtifacts(n);return Log.timeEnd(t),l}}const Ao=!!_.env.CI||"test"===_.env.NODE_ENV;function getLogNormalScore({median:e,p10:t},n){
if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;const a=Math.max(Number.MIN_VALUE,n/e),r=Math.log(a),o=Math.max(Number.MIN_VALUE,t/e),i=(1-function erf(e){const t=Math.sign(e),n=1/(1+.3275911*(e=Math.abs(e)));return t*(1-n*(.254829592+n*(n*(1.421413741+n*(1.061405429*n-1.453152027))-.284496736))*Math.exp(-e*e))}(.9061938024368232*r/-Math.log(o)))/2;let s;return s=n<=t?Math.max(.9,Math.min(1,i)):n<=e?Math.max(.5,Math.min(.8999999999999999,i)):Math.max(0,Math.min(.49999999999999994,i)),s}class Audit{static get DEFAULT_PASS(){return"defaultPass"}static get SCORING_MODES(){return{NUMERIC:"numeric",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(e,t){
throw new Error("audit() method must be overridden")}static computeLogNormalScore(e,t){let n=getLogNormalScore(e,t);return n>.9&&(n+=.05*(n-.9)),Math.floor(100*n)/100}static assertHeadingKeysExist(e,t){if(t.length&&Ao)for(const n of e){if(null===n.key)continue;const e=n.key;if(!t.some((t=>e in t)))throw new Error(`"${n.key}" is missing from items`)}}static makeTableDetails(e,t,n={}){const{wastedBytes:a,wastedMs:r,sortedBy:o,skipSumming:i,isEntityGrouped:s}=n,c=a||r?{wastedBytes:a,wastedMs:r}:void 0;return 0===t.length?{type:"table",headings:[],items:[],summary:c}:(Audit.assertHeadingKeysExist(e,t),{type:"table",headings:e,items:t,summary:c,sortedBy:o,skipSumming:i,isEntityGrouped:s})}static makeListDetails(e){return{type:"list",items:e}}static makeSnippetDetails({content:e,title:t,lineMessages:n,generalMessages:a,node:r,maxLineLength:o=200,maxLinesAroundMessage:i=20}){const s=Audit._makeSnippetLinesArray(e,o);return{type:"snippet",lines:Util.filterRelevantLines(s,n,i),title:t,
lineMessages:n,generalMessages:a,lineCount:s.length,node:r}}static _makeSnippetLinesArray(e,t){return e.split("\n").map(((e,n)=>{const a=n+1,r={content:Util.truncate(e,t),lineNumber:a};return e.length>t&&(r.truncated=!0),r}))}static makeOpportunityDetails(e,t,n){Audit.assertHeadingKeysExist(e,t);const{overallSavingsMs:a,overallSavingsBytes:r,sortedBy:o,skipSumming:i,isEntityGrouped:s}=n;return{type:"opportunity",headings:0===t.length?[]:e,items:t,overallSavingsMs:a,overallSavingsBytes:r,sortedBy:o,skipSumming:i,isEntityGrouped:s}}static makeNodeItem(e){return{type:"node",lhId:e.lhId,path:e.devtoolsNodePath,selector:e.selector,boundingRect:e.boundingRect,snippet:e.snippet,nodeLabel:e.nodeLabel}}static _findOriginalLocation(e,t,n){const a=e?.map.findEntry(t,n);if(a)return{file:a.sourceURL||"",line:a.sourceLineNumber||0,column:a.sourceColumnNumber||0}}static makeSourceLocation(e,t,n,a){return{type:"source-location",url:e,urlProvider:"network",line:t,column:n,
original:a&&this._findOriginalLocation(a,t,n)}}static makeSourceLocationFromConsoleMessage(e,t){if(!e.url)return;const n=e.lineNumber||0,a=e.columnNumber||0;return this.makeSourceLocation(e.url,n,a,t)}static _normalizeAuditScore(e,t,n){if(t!==Audit.SCORING_MODES.BINARY&&t!==Audit.SCORING_MODES.NUMERIC)return null;if(null===e||!Number.isFinite(e))throw new Error(`Invalid score for ${n}: ${e}`);if(e>1)throw new Error(`Audit score for ${n} is > 1`);if(e<0)throw new Error(`Audit score for ${n} is < 0`);var a;return a=e,e=Math.round(100*a)/100}static generateErrorAuditResult(e,t,n){return Audit.generateAuditResult(e,{score:null,errorMessage:t,errorStack:n})}static generateAuditResult(e,t){if(void 0===t.score)throw new Error("generateAuditResult requires a score");let n=e.meta.scoreDisplayMode||Audit.SCORING_MODES.BINARY;void 0!==t.errorMessage?n=Audit.SCORING_MODES.ERROR:t.notApplicable&&(n=Audit.SCORING_MODES.NOT_APPLICABLE);const a=Audit._normalizeAuditScore(t.score,n,e.meta.id)
;let r=e.meta.title;e.meta.failureTitle&&null!==a&&a<Util.PASS_THRESHOLD&&(r=e.meta.failureTitle);const o="numericUnit"in t?t:void 0;return{id:e.meta.id,title:r,description:e.meta.description,score:a,scoreDisplayMode:n,numericValue:o?.numericValue,numericUnit:o?.numericUnit,displayValue:t.displayValue,explanation:t.explanation,errorMessage:t.errorMessage,errorStack:t.errorStack,warnings:t.warnings,details:t.details}}}class ReportScoring{static arithmeticMean(e){if((e=e.filter((e=>e.weight>0))).some((e=>null===e.score)))return null;const t=e.reduce(((e,t)=>{const n=t.score,a=t.weight;return{weight:e.weight+a,sum:e.sum+n*a}}),{weight:0,sum:0});return n=t.sum/t.weight||0,Math.round(100*n)/100;var n}static scoreAllCategories(e,t){const n={};for(const[a,r]of Object.entries(e)){const e=r.auditRefs.map((e=>{const n={...e},a=t[n.id]
;return a.scoreDisplayMode!==Audit.SCORING_MODES.NOT_APPLICABLE&&a.scoreDisplayMode!==Audit.SCORING_MODES.INFORMATIVE&&a.scoreDisplayMode!==Audit.SCORING_MODES.MANUAL||(n.weight=0),n})),o=e.map((e=>({score:t[e.id].score,weight:e.weight}))),i=ReportScoring.arithmeticMean(o);n[a]={...r,auditRefs:e,id:a,score:i}}return n}}var ko=[{id:"amp",title:"AMP",icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><path fill="%230379c4" fill-rule="evenodd" d="m171.887 116.28-53.696 89.36h-9.728l9.617-58.227-30.2.047a4.852 4.852 0 0 1-4.855-4.855c0-1.152 1.07-3.102 1.07-3.102l53.52-89.254 9.9.043-9.86 58.317 30.413-.043a4.852 4.852 0 0 1 4.855 4.855c0 1.088-.427 2.044-1.033 2.854l.004.004zM128 0C57.306 0 0 57.3 0 128s57.306 128 128 128 128-57.306 128-128S198.7 0 128 0z"/></svg>',UIStrings:{
"modern-image-formats":"Consider displaying all [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) components in WebP formats while specifying an appropriate fallback for other browsers. [Learn more](https://amp.dev/documentation/components/amp-img/#example:-specifying-a-fallback-image).","offscreen-images":"Ensure that you are using [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) for images to automatically lazy-load. [Learn more](https://amp.dev/documentation/guides-and-tutorials/develop/media_iframes_3p/?format=websites#images).","render-blocking-resources":"Use tools such as [AMP Optimizer](https://github.com/ampproject/amp-toolbox/tree/master/packages/optimizer) to [server-side render AMP layouts](https://amp.dev/documentation/guides-and-tutorials/optimize-and-measure/server-side-rendering/).",
"unminified-css":"Refer to the [AMP documentation](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/style_pages/) to ensure all styles are supported.","efficient-animated-content":"For animated content, use [`amp-anim`](https://amp.dev/documentation/components/amp-anim/) to minimize CPU usage when the content is offscreen.","uses-responsive-images":"The [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) component supports the [`srcset`](https://web.dev/use-srcset-to-automatically-choose-the-right-image/) attribute to specify which image assets to use based on the screen size. [Learn more](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/art_direction/)."}},{id:"angular",title:"Angular",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250"><path fill="%23dd0031" d="M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"/><path fill="%23c3002f" d="M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"/><path fill="%23fff" d="M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z"/></svg>',UIStrings:{"total-byte-weight":"Apply [route-level code splitting](https://web.dev/route-level-code-splitting-in-angular/) to minimize the size of your JavaScript bundles. Also, consider precaching assets with the [Angular service worker](https://web.dev/precaching-with-the-angular-service-worker/).","unminified-warning":"If you are using Angular CLI, ensure that builds are generated in production mode. [Learn more](https://angular.io/guide/deployment#enable-runtime-production-mode).",
"unused-javascript":"If you are using Angular CLI, include source maps in your production build to inspect your bundles. [Learn more](https://angular.io/guide/deployment#inspect-the-bundles).","uses-responsive-images":"Consider using the `BreakpointObserver` utility in the Component Dev Kit (CDK) to manage image breakpoints. [Learn more](https://material.angular.io/cdk/layout/overview).","uses-rel-preload":"Preload routes ahead of time to speed up navigation. [Learn more](https://web.dev/route-preloading-in-angular/).","dom-size":"Consider virtual scrolling with the Component Dev Kit (CDK) if very large lists are being rendered. [Learn more](https://web.dev/virtualize-lists-with-angular-cdk/)."}},{id:"drupal",title:"Drupal",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 186.525 243.713"><path fill="%23009cde" d="M131.64 51.91C114.491 34.769 98.13 18.429 93.26 0c-4.87 18.429-21.234 34.769-38.38 51.91C29.16 77.613 0 106.743 0 150.434a93.263 93.263 0 1 0 186.525 0c0-43.688-29.158-72.821-54.885-98.524m-92 120.256c-5.719-.194-26.824-36.571 12.329-75.303l25.909 28.3a2.215 2.215 0 0 1-.173 3.306c-6.183 6.34-32.534 32.765-35.81 41.902-.675 1.886-1.663 1.815-2.256 1.795m53.624 47.943a32.075 32.075 0 0 1-32.076-32.075 33.423 33.423 0 0 1 7.995-21.187c5.784-7.072 24.077-26.963 24.077-26.963s18.012 20.183 24.033 26.896a31.368 31.368 0 0 1 8.046 21.254 32.076 32.076 0 0 1-32.075 32.075m61.392-52.015c-.691 1.512-2.26 4.036-4.376 4.113-3.773.138-4.176-1.796-6.965-5.923-6.122-9.06-59.551-64.9-69.545-75.699-8.79-9.498-1.238-16.195 2.266-19.704 4.395-4.403 17.224-17.225 17.224-17.225s38.255 36.296 54.19 61.096 10.444 46.26 7.206 53.342"/></svg>',UIStrings:{
"unused-css-rules":"Consider removing unused CSS rules and only attach the needed Drupal libraries to the relevant page or component in a page. See the [Drupal documentation link](https://www.drupal.org/docs/8/creating-custom-modules/adding-stylesheets-css-and-javascript-js-to-a-drupal-8-module#library) for details. To identify attached libraries that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the stylesheet when CSS aggregation is disabled in your Drupal site. Look out for themes/modules that have many stylesheets in the list which have a lot of red in code coverage. A theme/module should only enqueue a stylesheet if it is actually used on the page.",
"unused-javascript":"Consider removing unused JavaScript assets and only attach the needed Drupal libraries to the relevant page or component in a page. See the [Drupal documentation link](https://www.drupal.org/docs/8/creating-custom-modules/adding-stylesheets-css-and-javascript-js-to-a-drupal-8-module#library) for details. To identify attached libraries that are adding extraneous JavaScript, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the script when JavaScript aggregation is disabled in your Drupal site. Look out for themes/modules that have many scripts in the list which have a lot of red in code coverage. A theme/module should only enqueue a script if it is actually used on the page.",
"modern-image-formats":"Consider configuring [WebP image formats with a Convert image style](https://www.drupal.org/docs/core-modules-and-themes/core-modules/image-module/working-with-images#styles) on your site.","offscreen-images":"Install [a Drupal module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A67&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=%22lazy+load%22&solrsort=iss_project_release_usage+desc&op=Search) that can lazy load images. Such modules provide the ability to defer any offscreen images to improve performance.","total-byte-weight":"Consider using [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) to reduce the size of images loaded on your page. If you are using Views to show multiple content items on a page, consider implementing pagination to limit the number of content items shown on a given page.",
"render-blocking-resources":"Consider using a module to inline critical CSS and JavaScript, or potentially load assets asynchronously via JavaScript such as the [Advanced CSS/JS Aggregation](https://www.drupal.org/project/advagg) module. Beware that optimizations provided by this module may break your site, so you will likely need to make code changes.","unminified-css":'Ensure you have enabled "Aggregate CSS files" in the "Administration » Configuration » Development" page. You can also configure more advanced aggregation options through [additional modules](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=css+aggregation&solrsort=iss_project_release_usage+desc&op=Search) to speed up your site by concatenating, minifying, and compressing your CSS styles.',
"unminified-javascript":'Ensure you have enabled "Aggregate JavaScript files" in the "Administration » Configuration » Development" page. You can also configure more advanced aggregation options through [additional modules](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=javascript+aggregation&solrsort=iss_project_release_usage+desc&op=Search) to speed up your site by concatenating, minifying, and compressing your JavaScript assets.',"efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.",
"uses-long-cache-ttl":'Set the "Browser and proxy cache maximum age" in the "Administration » Configuration » Development" page. Read about [Drupal cache and optimizing for performance](https://www.drupal.org/docs/7/managing-site-performance-and-scalability/caching-to-improve-performance/caching-overview#s-drupal-performance-resources).',"uses-optimized-images":"Consider using [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=optimize+images&solrsort=iss_project_release_usage+desc&op=Search) that automatically optimizes and reduces the size of images uploaded through the site while retaining quality. Also, ensure you are using the native [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) provided from Drupal (available in Drupal 8 and above) for all images rendered on the site.",
"uses-responsive-images":"Ensure that you are using the native [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) provided from Drupal (available in Drupal 8 and above). Use the Responsive Image Styles when rendering image fields through view modes, views, or images uploaded through the WYSIWYG editor.","server-response-time":"Themes, modules, and server specifications all contribute to server response time. Consider finding a more optimized theme, carefully selecting an optimization module, and/or upgrading your server. Your hosting servers should make use of PHP opcode caching, memory-caching to reduce database query times such as Redis or Memcached, as well as optimized application logic to prepare pages faster.",
"uses-rel-preconnect":"Preconnect or dns-prefetch resource hints can be added by installing and configuring [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=dns-prefetch&solrsort=iss_project_release_usage+desc&op=Search) that provides facilities for user agent resource hints.","font-display":"Specify `@font-display` when defining custom fonts in your theme."}},{id:"ezoic",title:"Ezoic",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82 82"><path fill="%235FA624" fill-rule="evenodd" d="M81.37 48.117C85.301 25.821 70.413 4.56 48.117.63 25.821-3.3 4.56 11.586.63 33.883-3.3 56.178 11.586 77.44 33.883 81.37 56.18 85.301 77.44 70.412 81.37 48.117Zm-8.935-14.17c2.77 12.357-1.942 25.721-12.96 33.436-14.57 10.203-34.656 6.662-44.859-7.909a32.434 32.434 0 0 1-2.869-4.98l28.7-20.097a6.53 6.53 0 1 0-3.744-5.347L9.564 48.054c-2.768-12.359 1.943-25.724 12.96-33.439 14.572-10.203 34.656-6.662 44.86 7.91a32.349 32.349 0 0 1 2.868 4.98L41.554 47.6a6.53 6.53 0 1 0 3.746 5.35l27.136-19.003Z"/></svg>',UIStrings:{"unused-css-rules":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Remove Unused CSS` to help with this issue. It will identify the CSS classes that are actually used on each page of your site, and remove any others to keep the file size small.",
"modern-image-formats":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Next-Gen Formats` to convert images to WebP.","offscreen-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Lazy Load Images` to defer loading off-screen images until they are needed.","render-blocking-resources":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Critical CSS` and `Script Delay` to defer non-critical JS/CSS.","unminified-css":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify CSS` to automatically minify your CSS to reduce network payload sizes.","unminified-javascript":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify Javascript` to automatically minify your JS to reduce network payload sizes.","uses-long-cache-ttl":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Efficient Static Cache Policy` to set recommended values in the caching header for static assests.",
"uses-optimized-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Next-Gen Formats` to convert images to WebP.","uses-responsive-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Resize Images` to resize images to a device appropriate size, reducing network payload sizes.","server-response-time":"Use [Ezoic Cloud Caching](https://pubdash.ezoic.com/speed/caching) to cache your content across our world wide network, improving time to first byte.","uses-rel-preconnect":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Pre-Connect Origins` to automatically add `preconnect` resource hints to establish early connections to important third-party origins.","uses-rel-preload":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Preload Fonts` and `Preload Background Images` to add `preload` links to prioritize fetching resources that are currently requested later in page load.",
"font-display":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Optimize Fonts` to automatically leverage the `font-display` CSS feature to ensure text is user-visible while webfonts are loading."}},{id:"gatsby",title:"Gatsby",icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="%23639"/><path fill="%23fff" d="M6.2 21.8C4.1 19.7 3 16.9 3 14.2L13.9 25c-2.8-.1-5.6-1.1-7.7-3.2zm10.2 2.9L3.3 11.6C4.4 6.7 8.8 3 14 3c3.7 0 6.9 1.8 8.9 4.5l-1.5 1.3C19.7 6.5 17 5 14 5c-3.9 0-7.2 2.5-8.5 6L17 22.5c2.9-1 5.1-3.5 5.8-6.5H18v-2h7c0 5.2-3.7 9.6-8.6 10.7z"/></svg>',UIStrings:{"unused-css-rules":"Use the `PurgeCSS` `Gatsby` plugin to remove unused rules from stylesheets. [Learn more](https://purgecss.com/plugins/gatsby.html).",
"modern-image-formats":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically optimize image format. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","offscreen-images":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","render-blocking-resources":"Use the `Gatsby Script API` to defer loading of non-critical third-party scripts. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-script/).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://www.gatsbyjs.com/plugins/gatsby-plugin-webpack-bundle-analyser-v2/)","uses-long-cache-ttl":"Configure caching for immutable assets. [Learn more](https://www.gatsbyjs.com/docs/how-to/previews-deploys-hosting/caching/).",
"uses-optimized-images":"Use the `gatsby-plugin-image` component instead of `<img>` to adjust image quality. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","uses-responsive-images":"Use the `gatsby-plugin-image` component to set appropriate `sizes`. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","prioritize-lcp-image":"Use the `gatsby-plugin-image` component and set the `loading` prop to `eager`. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-plugin-image#shared-props)."}},{id:"joomla",title:"Joomla",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 258"><path fill="%23F9AE41" d="M255.7 35.6a33.7 33.7 0 0 0-67-4.8l-.4-.2c-27.6-12.4-50.8 9.6-50.8 9.6l-61.4 61.7 24.3 23.4 49.4-48.6c23-23 35.6-7.4 35.6-7.4 17.4 14.6.6 32 .6 32l24.9 24c20.3-22 21.5-41.1 15.3-56.3a33.7 33.7 0 0 0 29.5-33.4"/><path fill="%23EE4035" d="m226.5 190.5.2-.3c12.4-27.6-9.6-50.8-9.6-50.8L155.4 78l-23.3 24.3 48.5 49.4c23 23 7.5 35.6 7.5 35.6-14.7 17.4-32 .6-32 .6l-24 24.9c21.9 20.3 41 21.5 56.2 15.3a33.7 33.7 0 1 0 38.2-37.6"/><path fill="%234F91CD" d="m156 133-49.5 48.6c-23 23-35.6 7.4-35.6 7.4-17.4-14.6-.6-32-.6-32l-24.9-24c-20.3 22-21.4 41.1-15.3 56.3a33.7 33.7 0 1 0 37.6 38.2l.3.2c27.6 12.4 50.8-9.6 50.8-9.6l61.4-61.7-24.3-23.4"/><path fill="%237AC043" d="M75.7 106.6c-23-23-7.4-35.6-7.4-35.6 14.6-17.4 32-.6 32-.6l24-24.9c-22-20.3-41-21.5-56.3-15.3a33.7 33.7 0 1 0-38.2 37.6l-.2.3C17.2 95.7 39.2 119 39.2 119l61.7 61.4 23.4-24.3-48.6-49.4"/></svg>',
UIStrings:{"unused-css-rules":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused CSS in your page. To identify extensions that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using a [plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=webp) or service that will automatically convert your uploaded images to the optimal formats.",
"offscreen-images":"Install a [lazy-load Joomla plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=lazy%20loading) that provides the ability to defer any offscreen images, or switch to a template that provides that functionality. Starting with Joomla 4.0, all new images will [automatically](https://github.com/joomla/joomla-cms/pull/30748) get the `loading` attribute from the core.","total-byte-weight":"Consider showing excerpts in your article categories (e.g. via the read more link), reducing the number of articles shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.",
"render-blocking-resources":"There are a number of Joomla plugins that can help you [inline critical assets](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) or [defer less important resources](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance). Beware that optimizations provided by these plugins may break features of your templates or plugins, so you will need to test these thoroughly.","unminified-css":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your css styles. There are also templates that provide this functionality.","unminified-javascript":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your scripts. There are also templates that provide this functionality.",
"efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the extension responsible from the URL of the script. Look out for extensions that have many scripts in the list which have a lot of red in code coverage. An extension should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in Joomla](https://docs.joomla.org/Cache).",
"uses-optimized-images":"Consider using an [image optimization plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression by enabling Gzip Page Compression in Joomla (System > Global configuration > Server).","uses-responsive-images":"Consider using a [responsive images plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=responsive%20images) to use responsive images in your content.","server-response-time":"Templates, extensions, and server specifications all contribute to server response time. Consider finding a more optimized template, carefully selecting an optimization extension, and/or upgrading your server."}},{id:"magento",title:"Magento",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="%23f26322" viewBox="0 0 1000 1000"><path d="M916.9 267.4v465.3l-111.3 67.4V331.4l-1.5-.9-303.9-189-304.6 189.2-1.2.8V799L83.1 732.6V267.4l.7-.4L500.3 10l416 257 .6.4zM560.7 468.5v383.3L500.3 890l-61-38.2V306.7l-136 84.3v476.6l197 122.5 196.4-122.5V391l-136-84.3v161.8z"/></svg>',UIStrings:{"modern-image-formats":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=webp) for a variety of third-party extensions to leverage newer image formats.","offscreen-images":"Consider modifying your product and catalog templates to make use of the web platform's [lazy loading](https://web.dev/native-lazy-loading) feature.","disable-bundling":"Disable Magento's built-in [JavaScript bundling and minification](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html), and consider using [baler](https://github.com/magento/baler/) instead.",
"unminified-css":'Enable the "Minify CSS Files" option in your store\'s Developer settings. [Learn more](https://devdocs.magento.com/guides/v2.3/performance-best-practices/configuration.html?itm_source=devdocs&itm_medium=search_page&itm_campaign=federated_search&itm_term=minify%20css%20files).',"unminified-javascript":"Use [Terser](https://www.npmjs.com/package/terser) to minify all JavaScript assets from static content deployment, and disable the built-in minification feature.","unused-javascript":"Disable Magento's built-in [JavaScript bundling](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html).","uses-optimized-images":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=optimize%20image) for a variety of third party extensions to optimize images.","server-response-time":"Use Magento's [Varnish integration](https://devdocs.magento.com/guides/v2.3/config-guide/varnish/config-varnish.html).",
"uses-rel-preconnect":"Preconnect or dns-prefetch resource hints can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","uses-rel-preload":"`<link rel=preload>` tags can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","critical-request-chains":"If you are not bundling your JavaScript assets, consider using [baler](https://github.com/magento/baler).","font-display":"Specify `@font-display` when [defining custom fonts](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/css-topics/using-fonts.html)."}},{id:"next.js",title:"Next.js",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 207 124"><path fill="%23000" d="M48.942 32.632h38.96v3.082h-35.39v23.193H85.79v3.082H52.513v25.464h35.794v3.081H48.942V32.632Zm42.45 0h4.139l18.343 25.464 18.749-25.464L158.124.287l-41.896 60.485 21.59 29.762h-4.302l-19.642-27.086L94.15 90.534h-4.22l21.751-29.762-20.29-28.14Zm47.967 3.082v-3.082h44.397v3.082h-20.453v54.82h-3.571v-54.82h-20.373ZM.203 32.632h4.464l61.557 91.671-25.439-33.769L3.936 37.011l-.162 53.523H.203zm183.194 53.891c.738 0 1.276-.563 1.276-1.29 0-.727-.538-1.29-1.276-1.29-.73 0-1.277.563-1.277 1.29 0 .727.547 1.29 1.277 1.29Zm3.509-3.393c0 2.146 1.555 3.549 3.822 3.549 2.414 0 3.874-1.446 3.874-3.956v-8.837h-1.946v8.828c0 1.394-.704 2.138-1.946 2.138-1.112 0-1.867-.692-1.893-1.722h-1.911Zm10.24-.113c.14 2.233 2.007 3.662 4.787 3.662 2.97 0 4.83-1.498 4.83-3.887 0-1.878-1.06-2.917-3.632-3.514l-1.38-.338c-1.634-.38-2.294-.891-2.294-1.783 0-1.125 1.025-1.86 2.563-1.86 1.459 0 2.466.718 2.649 1.869h1.893c-.113-2.103-1.971-3.583-4.516-3.583-2.737 0-4.56 1.48-4.56 3.704 0 1.835 1.033 2.926 3.3 3.454l1.616.39c1.659.389 2.388.96 2.388 1.912 0 1.108-1.146 1.913-2.71 1.913-1.676 0-2.84-.753-3.005-1.939h-1.928Z"/></svg>',
UIStrings:{"unused-css-rules":"Consider setting up `PurgeCSS` in `Next.js` configuration to remove unused rules from stylesheets. [Learn more](https://purgecss.com/guides/next.html).","modern-image-formats":"Use the `next/image` component instead of `<img>` to automatically optimize image format. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","offscreen-images":"Use the `next/image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","render-blocking-resources":"Use the `next/script` component to defer loading of non-critical third-party scripts. [Learn more](https://nextjs.org/docs/basic-features/script).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://github.com/vercel/next.js/tree/canary/packages/next-bundle-analyzer)",
"uses-long-cache-ttl":"Configure caching for immutable assets and `Server-side Rendered` (SSR) pages. [Learn more](https://nextjs.org/docs/going-to-production#caching).","uses-optimized-images":"Use the `next/image` component instead of `<img>` to adjust image quality. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","uses-text-compression":"Enable compression on your Next.js server. [Learn more](https://nextjs.org/docs/api-reference/next.config.js/compression).","uses-responsive-images":"Use the `next/image` component to set the appropriate `sizes`. [Learn more](https://nextjs.org/docs/api-reference/next/image#sizes).","user-timings":"Consider using `Next.js Analytics` to measure your app's real-world performance. [Learn more](https://nextjs.org/docs/advanced-features/measuring-performance).",
"prioritize-lcp-image":'Use the `next/image` component and set "priority" to true to preload LCP image. [Learn more](https://nextjs.org/docs/api-reference/next/image#priority).',"unsized-images":"Use the `next/image` component to make sure images are always sized appropriately. [Learn more](https://nextjs.org/docs/api-reference/next/image#width)."}},{id:"nuxt",title:"Nuxt",icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 124 124"><path fill="%2380EEC0" fill-rule="evenodd" d="M55.75 27.155c-3.222-5.54-11.278-5.54-14.5 0L6.134 87.535C2.912 93.075 6.94 100 13.384 100h27.413c-2.753-2.407-3.773-6.57-1.69-10.142L65.704 44.27 55.75 27.155Z" clip-rule="evenodd"/><path fill="%2300DC82" d="M78 40.4c2.667-4.533 9.333-4.533 12 0l29.06 49.4c2.667 4.533-.666 10.199-5.999 10.199H54.938c-5.333 0-8.666-5.666-6-10.199L78 40.4Z"/></svg>',UIStrings:{
"modern-image-formats":'Use the `nuxt/image` component and set `format="webp"`. [Learn more](https://image.nuxtjs.org/components/nuxt-img#format).',"offscreen-images":'Use the `nuxt/image` component and set `loading="lazy"` for offscreen images. [Learn more](https://image.nuxtjs.org/components/nuxt-img#loading).',"uses-optimized-images":"Use the `nuxt/image` component and set the appropriate `quality`. [Learn more](https://image.nuxtjs.org/components/nuxt-img#quality).","uses-responsive-images":"Use the `nuxt/image` component and set the appropriate `sizes`. [Learn more](https://image.nuxtjs.org/components/nuxt-img#sizes).","prioritize-lcp-image":"Use the `nuxt/image` component and specify `preload` for LCP image. [Learn more](https://image.nuxtjs.org/components/nuxt-img#preload).","unsized-images":"Use the `nuxt/image` component and specify explicit `width` and `height`. [Learn more](https://image.nuxtjs.org/components/nuxt-img#width--height)."}},{id:"octobercms",title:"October CMS",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 310 310"><path fill="none" d="M-1-1h802v602H-1z"/><path fill="%23de6c26" d="M135 6.9c-14.2 4.4-34.9 21.8-49.9 42C55.8 88.5 39.6 135.8 41.4 177c.8 20.2 4.9 35.5 14.4 54.5 13.6 27.4 40.8 55.1 65.5 66.9 14.1 6.7 13.4 6.9 14.1-2.8.3-4.4 1-32.4 1.6-62.1 2.7-137.3 4.4-176 8.2-191.3.6-2.3 1.4-4.2 1.9-4.2 1.2 0 3.6 9.1 4.9 18.3.5 4.3 1 17.7 1 29.8 0 12 .3 21.9.7 21.9.3 0 5.7-5 11.9-11 6.9-6.8 12-11 13.3-11 1.8 0 1.9.3 1 2.7-1.2 3.1-7.9 13.2-19.1 28.5L153 128l.1 31.2c.1 17.2.4 37.4.8 44.9l.6 13.7 11-12.6c14-16 35.1-37.1 39.5-39.6l3.3-1.9-.6 3.2c-2 9.8-9.5 20.7-37.4 54.3L154 240.8v31.1c0 18.3.4 31.1.9 31.1 2.8 0 19.3-6.4 26.8-10.5 13.8-7.3 23.8-15 38.3-29.5 15.7-15.7 24.4-27.4 33.4-45.2 20.5-40 21-80.3 1.6-119-17.8-35.6-54.6-72.1-87.8-86.9-11.7-5.3-24.6-7.3-32.2-5z"/></svg>',UIStrings:{
"unused-css-rules":"Consider reviewing the [plugins](https://octobercms.com/plugins) loading unused CSS on the website. To identify plugins that add unnecessary CSS, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the stylesheet URL. Look for plugins with many stylesheets with lots of red in code coverage. A plugin should only add a stylesheet if it is actually used on the web page.","modern-image-formats":"Consider using a [plugin](https://octobercms.com/plugins?search=image) or service that will automatically convert the uploaded images to the optimal formats. [WebP lossless images](https://developers.google.com/speed/webp) are 26% smaller in size compared to PNGs and 25-34% smaller than comparable JPEG images at the equivalent SSIM quality index. Another next-gen image format to consider is [AVIF](https://jakearchibald.com/2020/avif-has-landed/).",
"offscreen-images":"Consider installing an [image lazy loading plugin](https://octobercms.com/plugins?search=lazy) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://octobercms.com/plugins?search=Accelerated+Mobile+Pages).","total-byte-weight":"Consider showing excerpts in the post lists (e.g. using a `show more` button), reducing the number of posts shown on a given web page, breaking long posts into multiple web pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are many plugins that help [inline critical assets](https://octobercms.com/plugins?search=css). These plugins may break other plugins, so you should test thoroughly.",
"unminified-css":"There are many [plugins](https://octobercms.com/plugins?search=css) that can speed up a website by concatenating, minifying and compressing the styles. Using a build process to do this minification up-front can speed up development.","unminified-javascript":"There are many [plugins](https://octobercms.com/plugins?search=javascript) that can speed up a website by concatenating, minifying and compressing the scripts. Using a build process to do this minification up-front can speed up development.","efficient-animated-content":"[Replace animated GIFs with video](https://web.dev/replace-gifs-with-videos/) for faster web page loads and consider using modern file formats such as [WebM](https://web.dev/replace-gifs-with-videos/#create-webm-videos) or [AV1](https://developers.google.com/web/updates/2018/09/chrome-70-media-updates#av1-decoder) to improve compression efficiency by greater than 30% over the current state-of-the-art video codec, VP9.",
"unused-javascript":"Consider reviewing the [plugins](https://octobercms.com/plugins?search=javascript) that load unused JavaScript in the web page. To identify plugins that add unnecessary JavaScript, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the URL of the script. Look for plugins with many scripts with lots of red in code coverage. A plugin should only add a script if it is actually used on the web page.","uses-long-cache-ttl":"Read about [preventing unnecessary network requests with the HTTP Cache](https://web.dev/http-cache/#caching-checklist). There are many [plugins](https://octobercms.com/plugins?search=Caching) that can be used to speed up caching.","uses-optimized-images":"Consider using an [image optimization plugin](https://octobercms.com/plugins?search=image) to compresses images while retaining the quality.",
"uses-text-compression":"Enable text compression in the web server configuration.","uses-responsive-images":"Upload images directly in the media manager to ensure the required image sizes are available. Consider using the [resize filter](https://octobercms.com/docs/markup/filter-resize) or an [image resizing plugin](https://octobercms.com/plugins?search=image) to ensure the optimal image sizes are used.","server-response-time":"Themes, plugins and server specifications all contribute to the server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin and/or upgrade the server. October CMS also allows developers to use [`Queues`](https://octobercms.com/docs/services/queues) to defer the processing of a time consuming task, such as sending an e-mail. This drastically speeds up web requests."}},{id:"react",title:"React",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3"><g fill="%2361DAFB"><path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/><circle cx="420.9" cy="296.5" r="45.7"/><path d="M520.5 78.1z"/></g></svg>',
UIStrings:{"unminified-css":"If your build system minifies CSS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unminified-javascript":"If your build system minifies JS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unused-javascript":"If you are not server-side rendering, [split your JavaScript bundles](https://web.dev/code-splitting-suspense/) with `React.lazy()`. Otherwise, code-split using a third-party library such as [loadable-components](https://www.smooth-code.com/open-source/loadable-components/docs/getting-started/).",
"server-response-time":"If you are server-side rendering any React components, consider using `renderToPipeableStream()` or `renderToStaticNodeStream()` to allow the client to receive and hydrate different parts of the markup instead of all at once. [Learn more](https://reactjs.org/docs/react-dom-server.html#renderToPipeableStream).",redirects:"If you are using React Router, minimize usage of the `<Redirect>` component for [route navigations](https://reacttraining.com/react-router/web/api/Redirect).","user-timings":"Use the React DevTools Profiler, which makes use of the Profiler API, to measure the rendering performance of your components. [Learn more.](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)",
"dom-size":'Consider using a "windowing" library like `react-window` to minimize the number of DOM nodes created if you are rendering many repeated elements on the page. [Learn more](https://web.dev/virtualize-long-lists-react-window/). Also, minimize unnecessary re-renders using [`shouldComponentUpdate`](https://reactjs.org/docs/optimizing-performance.html#shouldcomponentupdate-in-action), [`PureComponent`](https://reactjs.org/docs/react-api.html#reactpurecomponent), or [`React.memo`](https://reactjs.org/docs/react-api.html#reactmemo) and [skip effects](https://reactjs.org/docs/hooks-effect.html#tip-optimizing-performance-by-skipping-effects) only until certain dependencies have changed if you are using the `Effect` hook to improve runtime performance.'}},{id:"wordpress",title:"WordPress",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.5 122.5"><g fill="%232f3439"><path d="M8.7 61.3c0 20.8 12.1 38.7 29.6 47.3l-25-68.7c-3 6.5-4.6 13.7-4.6 21.4zm88-2.7c0-6.5-2.3-11-4.3-14.5-2.7-4.3-5.2-8-5.2-12.3 0-4.8 3.7-9.3 8.9-9.3h.7a52.4 52.4 0 0 0-79.4 9.9h3.3c5.5 0 14-.6 14-.6 2.9-.2 3.2 4 .4 4.3 0 0-2.9.4-6 .5l19.1 57L59.7 59l-8.2-22.5c-2.8-.1-5.5-.5-5.5-.5-2.8-.1-2.5-4.5.3-4.3 0 0 8.7.7 13.9.7 5.5 0 14-.7 14-.7 2.8-.2 3.2 4 .3 4.3 0 0-2.8.4-6 .5l19 56.5 5.2-17.5c2.3-7.3 4-12.5 4-17z"/><path d="m62.2 65.9-15.8 45.8a52.6 52.6 0 0 0 32.3-.9l-.4-.7zM107.4 36a49.6 49.6 0 0 1-3.6 24.2l-16.1 46.5A52.5 52.5 0 0 0 107.4 36z"/><path d="M61.3 0a61.3 61.3 0 1 0 .1 122.7A61.3 61.3 0 0 0 61.3 0zm0 119.7a58.5 58.5 0 1 1 .1-117 58.5 58.5 0 0 1-.1 117z"/></g></svg>',UIStrings:{
"unused-css-rules":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused CSS in your page. To identify plugins that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using the [Performance Lab](https://wordpress.org/plugins/performance-lab/) plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.",
"offscreen-images":"Install a [lazy-load WordPress plugin](https://wordpress.org/plugins/search/lazy+load/) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://wordpress.org/plugins/amp/).","total-byte-weight":"Consider showing excerpts in your post lists (e.g. via the more tag), reducing the number of posts shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of WordPress plugins that can help you [inline critical assets](https://wordpress.org/plugins/search/critical+css/) or [defer less important resources](https://wordpress.org/plugins/search/defer+css+javascript/). Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.",
"unminified-css":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+css/) can speed up your site by concatenating, minifying, and compressing your styles. You may also want to use a build process to do this minification up-front if possible.","unminified-javascript":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+javascript/) can speed up your site by concatenating, minifying, and compressing your scripts. You may also want to use a build process to do this minification up front if possible.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.",
"unused-javascript":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the script. Look out for plugins that have many scripts in the list which have a lot of red in code coverage. A plugin should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in WordPress](https://wordpress.org/support/article/optimization/#browser-caching).","uses-optimized-images":"Consider using an [image optimization WordPress plugin](https://wordpress.org/plugins/search/optimize+images/) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression in your web server configuration.",
"uses-responsive-images":"Upload images directly through the [media library](https://wordpress.org/support/article/media-library-screen/) to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using `Full Size` images unless the dimensions are adequate for their usage. [Learn More](https://wordpress.org/support/article/inserting-images-into-posts-and-pages/).","server-response-time":"Themes, plugins, and server specifications all contribute to server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin, and/or upgrading your server."}},{id:"wp-rocket",title:"WP Rocket",
icon:'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294 524"><defs><linearGradient id="a" x1="36.742%" x2="37.116%" y1="100.518%" y2="-.001%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="b" x1="28.046%" x2="28.421%" y1="100.518%" y2="-.003%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="c" x1="38.215%" x2="38.589%" y1="100.518%" y2="0%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><path fill="url(%23a)" d="M218.617 270.615c-9.752 0-18.896-5.689-23.366-14.63l-7.72-17.27h-76.6l-7.722 17.27c-4.47 8.941-13.613 14.63-23.366 14.63H75.78l32.712 249.306c1.625 4.671 4.673 4.671 6.502 0l32.51-79.648 28.242 79.442c1.625 4.676 4.673 4.676 6.501 0L220.04 270.82l-1.423-.204Z" transform="translate(-1.58 -.2)"/><path fill="url(%23b)" d="M184.47 231.784h-70.3l-10.77 24.179c-3.657 7.314-10.768 12.597-18.489 14.02L109.7 423.791c1.625 2.844 4.673 2.844 6.501 0l31.697-48.155 29.055 47.951c1.829 2.845 4.673 2.845 6.502 0l28.039-154.012c-6.908-2.032-13.004-6.908-16.255-13.613l-10.768-24.18Z" transform="translate(-1.58 -.2)"/><path fill="url(%23c)" d="m195.259 255.988-46.123-103.014-45.92 103.014c-1.625 3.048-3.656 5.69-6.095 7.925l19.1 102.2c1.015 1.423 3.657 1.83 5.485 0l25.601-33.931 25.602 33.728c1.625 2.032 4.47 1.626 5.485 0l21.131-103.42c-1.625-2.032-3.047-4.064-4.266-6.502Z" transform="translate(-1.58 -.2)"/><path fill="%23F56F46" d="M.439 12.559c-1.422-4.877 1.422-8.33 6.299-8.33H47.17c2.845 0 5.486 2.437 6.299 4.876l29.665 116.83h1.422l53.437-121.3c1.016-2.032 3.048-3.86 5.892-3.86h6.299c3.047 0 5.08 1.625 5.892 3.86l53.437 121.3h1.423L240.6 9.105c.61-2.439 3.454-4.877 6.299-4.877h40.433c4.877 0 7.518 3.454 6.299 8.33l-65.221 231.63c-.61 2.845-3.454 4.876-6.298 4.876h-5.487c-2.438 0-4.876-1.625-5.892-3.86l-63.19-141.009h-1.015L83.744 245.203c-1.016 2.032-3.454 3.86-5.892 3.86h-5.486c-2.845 0-5.486-2.031-6.299-4.876L.44 12.559Z"/></g></svg>',
UIStrings:{"unused-css-rules":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket' to fix this issue. It reduces page size by removing all CSS and stylesheets that are not used while keeping only the used CSS for each page.","modern-image-formats":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' to convert your images to WebP.","unused-javascript":"Enable [Delay JavaScript execution](https://docs.wp-rocket.me/article/1349-delay-javascript-execution) in 'WP Rocket' to fix this problem. It will improve the loading of your page by delaying the execution of scripts until user interaction. If your site has iframes, you can use WP Rocket's [LazyLoad for iframes and videos](https://docs.wp-rocket.me/article/1674-lazyload-for-iframes-and-videos) and [Replace YouTube iframe with preview image](https://docs.wp-rocket.me/article/1488-replace-youtube-iframe-with-preview-image) as well.",
"render-blocking-resources":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) and [Load JavaScript deferred](https://docs.wp-rocket.me/article/1265-load-javascript-deferred) in 'WP Rocket' to address this recommendation. These features will respectively optimize the CSS and JavaScript files so that they don't block the rendering of your page.","unminified-css":"Enable [Minify CSS files](https://docs.wp-rocket.me/article/1350-css-minify-combine) in 'WP Rocket' to fix this issue. Any spaces and comments in your site's CSS files will be removed to make the file size smaller and faster to download.","unminified-javascript":"Enable [Minify JavaScript files](https://docs.wp-rocket.me/article/1351-javascript-minify-combine) in 'WP Rocket' to fix this issue. Empty spaces and comments will be removed from JavaScript files to make their size smaller and faster to download.",
"uses-optimized-images":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' and run Bulk Optimization to compress your images.","uses-rel-preconnect":"Use [Prefetch DNS Requests](https://docs.wp-rocket.me/article/1302-prefetch-dns-requests) in 'WP Rocket' to add \"dns-prefetch\" and speed up the connection with external domains. Also, 'WP Rocket' automatically adds \"preconnect\" to [Google Fonts domain](https://docs.wp-rocket.me/article/1312-optimize-google-fonts) and any CNAME(S) added via the [Enable CDN](https://docs.wp-rocket.me/article/42-using-wp-rocket-with-a-cdn) feature.","uses-rel-preload":"To fix this issue for fonts, enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket'. Your site's critical fonts will be preloaded with priority.",
"offscreen-images":"Enable [LazyLoad](https://docs.wp-rocket.me/article/1141-lazyload-for-images) in WP Rocket to fix this recommendation. This feature delays the loading of the images until the visitor scrolls down the page and actually needs to see them."}}];const Fo=[{packId:"gatsby",requiredStacks:["js:gatsby"]},{packId:"wordpress",requiredStacks:["js:wordpress"]},{packId:"wp-rocket",requiredStacks:["js:wp-rocket"]},{packId:"ezoic",requiredStacks:["js:ezoic"]},{packId:"drupal",requiredStacks:["js:drupal"]},{packId:"amp",requiredStacks:["js:amp"]},{packId:"magento",requiredStacks:["js:magento"]},{packId:"octobercms",requiredStacks:["js:octobercms"]},{packId:"joomla",requiredStacks:["js:joomla"]},{packId:"next.js",requiredStacks:["js:next"]},{packId:"nuxt",requiredStacks:["js:nuxt"]},{packId:"angular",requiredStacks:["js:@angular/core"]},{packId:"react",requiredStacks:["js:react"]}];function getStackPacks(e){if(!e)return[];const t=[];for(const n of e){
const e=Fo.find((e=>e.requiredStacks.includes(`${n.detector}:${n.id}`)));if(!e)continue;const a=ko.find((t=>t.id===e.packId));if(!a){Log.warn("StackPacks",`'${e.packId}' stack pack was matched but is not found in stack-packs lib`);continue}const r=createIcuMessageFn(`node_modules/lighthouse-stack-packs/packs/${a.id}.js`,a.UIStrings),o={},i=a.UIStrings;for(const e in i)i[e]&&(o[e]=r(i[e]));t.push({id:a.id,title:a.title,iconDataURL:a.icon,descriptions:o})}return t.sort(((e,t)=>Fo.findIndex((t=>t.packId===e.id))-Fo.findIndex((e=>e.packId===t.id))))}var xo="function"==typeof Object.create?function inherits(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})}:function inherits(e,t){e.super_=t;var TempCtor=function(){};TempCtor.prototype=t.prototype,e.prototype=new TempCtor,e.prototype.constructor=e},Ro=/%[sdj%]/g;function format$1(e){if(!isString(e)){for(var t=[],n=0;n<arguments.length;n++)t.push(inspect(arguments[n]))
;return t.join(" ")}n=1;for(var a=arguments,r=a.length,o=String(e).replace(Ro,(function(e){if("%%"===e)return"%";if(n>=r)return e;switch(e){case"%s":return String(a[n++]);case"%d":return Number(a[n++]);case"%j":try{return JSON.stringify(a[n++])}catch(e){return"[Circular]"}default:return e}})),i=a[n];n<r;i=a[++n])isNull(i)||!isObject(i)?o+=" "+i:o+=" "+inspect(i);return o}function deprecate(t,n){if(isUndefined(e.process))return function(){return deprecate(t,n).apply(this,arguments)};var a=!1;return function deprecated(){return a||(console.error(n),a=!0),t.apply(this,arguments)}}var Io,Mo={};function inspect(e,t){var n={seen:[],stylize:stylizeNoColor};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),isBoolean(t)?n.showHidden=t:t&&_extend(n,t),isUndefined(n.showHidden)&&(n.showHidden=!1),isUndefined(n.depth)&&(n.depth=2),isUndefined(n.colors)&&(n.colors=!1),isUndefined(n.customInspect)&&(n.customInspect=!0),
n.colors&&(n.stylize=stylizeWithColor),formatValue(n,e,n.depth)}function stylizeWithColor(e,t){var n=inspect.styles[t];return n?"["+inspect.colors[n][0]+"m"+e+"["+inspect.colors[n][1]+"m":e}function stylizeNoColor(e,t){return e}function formatValue(e,t,n){if(e.customInspect&&t&&isFunction(t.inspect)&&t.inspect!==inspect&&(!t.constructor||t.constructor.prototype!==t)){var a=t.inspect(n,e);return isString(a)||(a=formatValue(e,a,n)),a}var r=function formatPrimitive(e,t){if(isUndefined(t))return e.stylize("undefined","undefined");if(isString(t)){var n="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(n,"string")}if(function isNumber$1(e){return"number"==typeof e}(t))return e.stylize(""+t,"number");if(isBoolean(t))return e.stylize(""+t,"boolean");if(isNull(t))return e.stylize("null","null")}(e,t);if(r)return r;var o=Object.keys(t),i=function arrayToHash(e){var t={};return e.forEach((function(e,n){t[e]=!0})),t}(o)
;if(e.showHidden&&(o=Object.getOwnPropertyNames(t)),isError(t)&&(o.indexOf("message")>=0||o.indexOf("description")>=0))return formatError(t);if(0===o.length){if(isFunction(t)){var s=t.name?": "+t.name:"";return e.stylize("[Function"+s+"]","special")}if(isRegExp(t))return e.stylize(RegExp.prototype.toString.call(t),"regexp");if(isDate(t))return e.stylize(Date.prototype.toString.call(t),"date");if(isError(t))return formatError(t)}var c,l="",u=!1,d=["{","}"];(function isArray(e){return Array.isArray(e)}(t)&&(u=!0,d=["[","]"]),isFunction(t))&&(l=" [Function"+(t.name?": "+t.name:"")+"]");return isRegExp(t)&&(l=" "+RegExp.prototype.toString.call(t)),isDate(t)&&(l=" "+Date.prototype.toUTCString.call(t)),isError(t)&&(l=" "+formatError(t)),0!==o.length||u&&0!=t.length?n<0?isRegExp(t)?e.stylize(RegExp.prototype.toString.call(t),"regexp"):e.stylize("[Object]","special"):(e.seen.push(t),c=u?function formatArray(e,t,n,a,r){
for(var o=[],i=0,s=t.length;i<s;++i)hasOwnProperty(t,String(i))?o.push(formatProperty(e,t,n,a,String(i),!0)):o.push("");return r.forEach((function(r){r.match(/^\d+$/)||o.push(formatProperty(e,t,n,a,r,!0))})),o}(e,t,n,i,o):o.map((function(a){return formatProperty(e,t,n,i,a,u)})),e.seen.pop(),function reduceToSingleString(e,t,n){if(e.reduce((function(e,t){return t.indexOf("\n"),e+t.replace(/\u001b\[\d\d?m/g,"").length+1}),0)>60)return n[0]+(""===t?"":t+"\n ")+" "+e.join(",\n  ")+" "+n[1];return n[0]+t+" "+e.join(", ")+" "+n[1]}(c,l,d)):d[0]+l+d[1]}function formatError(e){return"["+Error.prototype.toString.call(e)+"]"}function formatProperty(e,t,n,a,r,o){var i,s,c;if((c=Object.getOwnPropertyDescriptor(t,r)||{value:t[r]}).get?s=c.set?e.stylize("[Getter/Setter]","special"):e.stylize("[Getter]","special"):c.set&&(s=e.stylize("[Setter]","special")),hasOwnProperty(a,r)||(i="["+r+"]"),
s||(e.seen.indexOf(c.value)<0?(s=isNull(n)?formatValue(e,c.value,null):formatValue(e,c.value,n-1)).indexOf("\n")>-1&&(s=o?s.split("\n").map((function(e){return"  "+e})).join("\n").substr(2):"\n"+s.split("\n").map((function(e){return"   "+e})).join("\n")):s=e.stylize("[Circular]","special")),isUndefined(i)){if(o&&r.match(/^\d+$/))return s;(i=JSON.stringify(""+r)).match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(i=i.substr(1,i.length-2),i=e.stylize(i,"name")):(i=i.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),i=e.stylize(i,"string"))}return i+": "+s}function isBoolean(e){return"boolean"==typeof e}function isNull(e){return null===e}function isString(e){return"string"==typeof e}function isUndefined(e){return void 0===e}function isRegExp(e){return isObject(e)&&"[object RegExp]"===objectToString(e)}function isObject(e){return"object"==typeof e&&null!==e}function isDate(e){return isObject(e)&&"[object Date]"===objectToString(e)}function isError(e){
return isObject(e)&&("[object Error]"===objectToString(e)||e instanceof Error)}function isFunction(e){return"function"==typeof e}function objectToString(e){return Object.prototype.toString.call(e)}function _extend(e,t){if(!t||!isObject(t))return e;for(var n=Object.keys(t),a=n.length;a--;)e[n[a]]=t[n[a]];return e}function hasOwnProperty(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function BufferList(){this.head=null,this.tail=null,this.length=0}inspect.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[33,39]},inspect.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"},BufferList.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length},BufferList.prototype.unshift=function(e){var t={data:e,next:this.head}
;0===this.length&&(this.tail=t),this.head=t,++this.length},BufferList.prototype.shift=function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}},BufferList.prototype.clear=function(){this.head=this.tail=null,this.length=0},BufferList.prototype.join=function(e){if(0===this.length)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n},BufferList.prototype.concat=function(e){if(0===this.length)return Buffer$1.alloc(0);if(1===this.length)return this.head.data;for(var t=Buffer$1.allocUnsafe(e>>>0),n=this.head,a=0;n;)n.data.copy(t,a),a+=n.data.length,n=n.next;return t};var No=Buffer$1.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};function StringDecoder(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),
function assertEncoding(e){if(e&&!No(e))throw new Error("Unknown encoding: "+e)}(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=utf16DetectIncompleteChar;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=base64DetectIncompleteChar;break;default:return void(this.write=passThroughWrite)}this.charBuffer=new Buffer$1(6),this.charReceived=0,this.charLength=0}function passThroughWrite(e){return e.toString(this.encoding)}function utf16DetectIncompleteChar(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function base64DetectIncompleteChar(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}StringDecoder.prototype.write=function(e){for(var t="";this.charLength;){var n=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,n),this.charReceived+=n,
this.charReceived<this.charLength)return"";if(e=e.slice(n,e.length),!((r=(t=this.charBuffer.slice(0,this.charLength).toString(this.encoding)).charCodeAt(t.length-1))>=55296&&r<=56319)){if(this.charReceived=this.charLength=0,0===e.length)return t;break}this.charLength+=this.surrogateSize,t=""}this.detectIncompleteChar(e);var a=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,a),a-=this.charReceived);var r;a=(t+=e.toString(this.encoding,0,a)).length-1;if((r=t.charCodeAt(a))>=55296&&r<=56319){var o=this.surrogateSize;return this.charLength+=o,this.charReceived+=o,this.charBuffer.copy(this.charBuffer,o,0,o),e.copy(this.charBuffer,0,0,o),t.substring(0,a)}return t},StringDecoder.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var n=e[e.length-t];if(1==t&&n>>5==6){this.charLength=2;break}if(t<=2&&n>>4==14){this.charLength=3;break}if(t<=3&&n>>3==30){this.charLength=4;break}}this.charReceived=t},
StringDecoder.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var n=this.charReceived,a=this.charBuffer,r=this.encoding;t+=a.slice(0,n).toString(r)}return t},Readable.ReadableState=ReadableState;var Lo=function debuglog(e){if(isUndefined(Io)&&(Io=""),e=e.toUpperCase(),!Mo[e])if(new RegExp("\\b"+e+"\\b","i").test(Io)){Mo[e]=function(){var t=format$1.apply(null,arguments);console.error("%s %d: %s",e,0,t)}}else Mo[e]=function(){};return Mo[e]}("stream");function ReadableState(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof Duplex&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var n=e.highWaterMark,a=this.objectMode?16:16384;this.highWaterMark=n||0===n?n:a,this.highWaterMark=~~this.highWaterMark,this.buffer=new BufferList,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,
this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new StringDecoder(e.encoding),this.encoding=e.encoding)}function Readable(e){if(!(this instanceof Readable))return new Readable(e);this._readableState=new ReadableState(e,this),this.readable=!0,e&&"function"==typeof e.read&&(this._read=e.read),EventEmitter.call(this)}function readableAddChunk(e,t,n,a,r){var o=function chunkInvalid(e,t){var n=null;Buffer$1.isBuffer(t)||"string"==typeof t||null==t||e.objectMode||(n=new TypeError("Invalid non-string/buffer chunk"));return n}(t,n);if(o)e.emit("error",o);else if(null===n)t.reading=!1,function onEofChunk(e,t){if(t.ended)return;if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,emitReadable(e)}(e,t);else if(t.objectMode||n&&n.length>0)if(t.ended&&!r){var i=new Error("stream.push() after EOF")
;e.emit("error",i)}else if(t.endEmitted&&r){var s=new Error("stream.unshift() after end event");e.emit("error",s)}else{var c;!t.decoder||r||a||(n=t.decoder.write(n),c=!t.objectMode&&0===n.length),r||(t.reading=!1),c||(t.flowing&&0===t.length&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,r?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&emitReadable(e))),function maybeReadMore(e,t){t.readingMore||(t.readingMore=!0,nextTick(maybeReadMore_,e,t))}(e,t)}else r||(t.reading=!1);return function needMoreData(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(t)}xo(Readable,EventEmitter),Readable.prototype.push=function(e,t){var n=this._readableState;return n.objectMode||"string"!=typeof e||(t=t||n.defaultEncoding)!==n.encoding&&(e=Buffer$1.from(e,t),t=""),readableAddChunk(this,n,e,t,!1)},Readable.prototype.unshift=function(e){return readableAddChunk(this,this._readableState,e,"",!0)},Readable.prototype.isPaused=function(){
return!1===this._readableState.flowing},Readable.prototype.setEncoding=function(e){return this._readableState.decoder=new StringDecoder(e),this._readableState.encoding=e,this};var Po=8388608;function howMuchToRead(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function computeNewHighWaterMark(e){return e>=Po?e=Po:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function emitReadable(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(Lo("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?nextTick(emitReadable_,e):emitReadable_(e))}function emitReadable_(e){Lo("emit readable"),e.emit("readable"),flow(e)}function maybeReadMore_(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(Lo("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}
function nReadingNextTick(e){Lo("readable nexttick read 0"),e.read(0)}function resume_(e,t){t.reading||(Lo("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),flow(e),t.flowing&&!t.reading&&e.read(0)}function flow(e){var t=e._readableState;for(Lo("flow",t.flowing);t.flowing&&null!==e.read(););}function fromList(e,t){return 0===t.length?null:(t.objectMode?n=t.buffer.shift():!e||e>=t.length?(n=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.head.data:t.buffer.concat(t.length),t.buffer.clear()):n=function fromListPartial(e,t,n){var a;e<t.head.data.length?(a=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):a=e===t.head.data.length?t.shift():n?function copyFromBufferString(e,t){var n=t.head,a=1,r=n.data;e-=r.length;for(;n=n.next;){var o=n.data,i=e>o.length?o.length:e;if(i===o.length?r+=o:r+=o.slice(0,e),0===(e-=i)){i===o.length?(++a,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=o.slice(i));break}++a}return t.length-=a,r
}(e,t):function copyFromBuffer(e,t){var n=Buffer$1.allocUnsafe(e),a=t.head,r=1;a.data.copy(n),e-=a.data.length;for(;a=a.next;){var o=a.data,i=e>o.length?o.length:e;if(o.copy(n,n.length-e,0,i),0===(e-=i)){i===o.length?(++r,a.next?t.head=a.next:t.head=t.tail=null):(t.head=a,a.data=o.slice(i));break}++r}return t.length-=r,n}(e,t);return a}(e,t.buffer,t.decoder),n);var n}function endReadable(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,nextTick(endReadableNT,t,e))}function endReadableNT(e,t){e.endEmitted||0!==e.length||(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function indexOf(e,t){for(var n=0,a=e.length;n<a;n++)if(e[n]===t)return n;return-1}function nop(){}function WriteReq(e,t,n){this.chunk=e,this.encoding=t,this.callback=n,this.next=null}function WritableState(e,t){Object.defineProperty(this,"buffer",{get:deprecate((function(){return this.getBuffer()
}),"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof Duplex&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var n=e.highWaterMark,a=this.objectMode?16:16384;this.highWaterMark=n||0===n?n:a,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var r=!1===e.decodeStrings;this.decodeStrings=!r,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function onwrite(e,t){var n=e._writableState,a=n.sync,r=n.writecb;if(function onwriteStateUpdate(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(n),t)!function onwriteError(e,t,n,a,r){--t.pendingcb,n?nextTick(r,a):r(a);e._writableState.errorEmitted=!0,e.emit("error",a)}(e,n,a,t,r);else{var o=needFinish(n);o||n.corked||n.bufferProcessing||!n.bufferedRequest||clearBuffer(e,n),
a?nextTick(afterWrite,e,n,o,r):afterWrite(e,n,o,r)}}(t,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new CorkedRequest(this)}function Writable(e){if(!(this instanceof Writable||this instanceof Duplex))return new Writable(e);this._writableState=new WritableState(e,this),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev)),EventEmitter.call(this)}function doWrite(e,t,n,a,r,o,i){t.writelen=a,t.writecb=i,t.writing=!0,t.sync=!0,n?e._writev(r,t.onwrite):e._write(r,o,t.onwrite),t.sync=!1}function afterWrite(e,t,n,a){n||function onwriteDrain(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,a(),finishMaybe(e,t)}function clearBuffer(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){
var a=t.bufferedRequestCount,r=new Array(a),o=t.corkedRequestsFree;o.entry=n;for(var i=0;n;)r[i]=n,n=n.next,i+=1;doWrite(e,t,!0,t.length,r,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=o.next,o.next=null):t.corkedRequestsFree=new CorkedRequest(t)}else{for(;n;){var s=n.chunk,c=n.encoding,l=n.callback;if(doWrite(e,t,!1,t.objectMode?1:s.length,s,c,l),n=n.next,t.writing)break}null===n&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function needFinish(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function prefinish(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function finishMaybe(e,t){var n=needFinish(t);return n&&(0===t.pendingcb?(prefinish(e,t),t.finished=!0,e.emit("finish")):prefinish(e,t)),n}function CorkedRequest(e){var t=this;this.next=null,this.entry=null,this.finish=function(n){var a=t.entry;for(t.entry=null;a;){var r=a.callback;e.pendingcb--,
r(n),a=a.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}Readable.prototype.read=function(e){Lo("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return Lo("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?endReadable(this):emitReadable(this),null;if(0===(e=howMuchToRead(e,t))&&t.ended)return 0===t.length&&endReadable(this),null;var a,r=t.needReadable;return Lo("need readable",r),(0===t.length||t.length-e<t.highWaterMark)&&Lo("length less than watermark",r=!0),t.ended||t.reading?Lo("reading or ended",r=!1):r&&(Lo("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=howMuchToRead(n,t))),null===(a=e>0?fromList(e,t):null)?(t.needReadable=!0,e=0):t.length-=e,0===t.length&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&endReadable(this)),null!==a&&this.emit("data",a),a},
Readable.prototype._read=function(e){this.emit("error",new Error("not implemented"))},Readable.prototype.pipe=function(e,t){var n=this,a=this._readableState;switch(a.pipesCount){case 0:a.pipes=e;break;case 1:a.pipes=[a.pipes,e];break;default:a.pipes.push(e)}a.pipesCount+=1,Lo("pipe count=%d opts=%j",a.pipesCount,t);var r=!t||!1!==t.end?onend:cleanup;function onunpipe(e){Lo("onunpipe"),e===n&&cleanup()}function onend(){Lo("onend"),e.end()}a.endEmitted?nextTick(r):n.once("end",r),e.on("unpipe",onunpipe);var o=function pipeOnDrain(e){return function(){var t=e._readableState;Lo("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&e.listeners("data").length&&(t.flowing=!0,flow(e))}}(n);e.on("drain",o);var i=!1;function cleanup(){Lo("cleanup"),e.removeListener("close",onclose),e.removeListener("finish",onfinish),e.removeListener("drain",o),e.removeListener("error",onerror),e.removeListener("unpipe",onunpipe),n.removeListener("end",onend),n.removeListener("end",cleanup),
n.removeListener("data",ondata),i=!0,!a.awaitDrain||e._writableState&&!e._writableState.needDrain||o()}var s=!1;function ondata(t){Lo("ondata"),s=!1,!1!==e.write(t)||s||((1===a.pipesCount&&a.pipes===e||a.pipesCount>1&&-1!==indexOf(a.pipes,e))&&!i&&(Lo("false write response, pause",n._readableState.awaitDrain),n._readableState.awaitDrain++,s=!0),n.pause())}function onerror(t){Lo("onerror",t),unpipe(),e.removeListener("error",onerror),0===function listenerCount(e,t){return e.listeners(t).length}(e,"error")&&e.emit("error",t)}function onclose(){e.removeListener("finish",onfinish),unpipe()}function onfinish(){Lo("onfinish"),e.removeListener("close",onclose),unpipe()}function unpipe(){Lo("unpipe"),n.unpipe(e)}return n.on("data",ondata),function prependListener(e,t,n){if("function"==typeof e.prependListener)return e.prependListener(t,n);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]:e.on(t,n)}(e,"error",onerror),
e.once("close",onclose),e.once("finish",onfinish),e.emit("pipe",n),a.flowing||(Lo("pipe resume"),n.resume()),e},Readable.prototype.unpipe=function(e){var t=this._readableState;if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this)),this;if(!e){var n=t.pipes,a=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var r=0;r<a;r++)n[r].emit("unpipe",this);return this}var o=indexOf(t.pipes,e);return-1===o||(t.pipes.splice(o,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this)),this},Readable.prototype.on=function(e,t){var n=EventEmitter.prototype.on.call(this,e,t);if("data"===e)!1!==this._readableState.flowing&&this.resume();else if("readable"===e){var a=this._readableState;a.endEmitted||a.readableListening||(a.readableListening=a.needReadable=!0,a.emittedReadable=!1,a.reading?a.length&&emitReadable(this):nextTick(nReadingNextTick,this))}return n},
Readable.prototype.addListener=Readable.prototype.on,Readable.prototype.resume=function(){var e=this._readableState;return e.flowing||(Lo("resume"),e.flowing=!0,function resume(e,t){t.resumeScheduled||(t.resumeScheduled=!0,nextTick(resume_,e,t))}(this,e)),this},Readable.prototype.pause=function(){return Lo("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(Lo("pause"),this._readableState.flowing=!1,this.emit("pause")),this},Readable.prototype.wrap=function(e){var t=this._readableState,n=!1,a=this;for(var r in e.on("end",(function(){if(Lo("wrapped end"),t.decoder&&!t.ended){var e=t.decoder.end();e&&e.length&&a.push(e)}a.push(null)})),e.on("data",(function(r){(Lo("wrapped data"),t.decoder&&(r=t.decoder.write(r)),t.objectMode&&null==r)||(t.objectMode||r&&r.length)&&(a.push(r)||(n=!0,e.pause()))})),e)void 0===this[r]&&"function"==typeof e[r]&&(this[r]=function(t){return function(){return e[t].apply(e,arguments)}}(r));return function forEach(e,t){
for(var n=0,a=e.length;n<a;n++)t(e[n],n)}(["error","close","destroy","pause","resume"],(function(t){e.on(t,a.emit.bind(a,t))})),a._read=function(t){Lo("wrapped _read",t),n&&(n=!1,e.resume())},a},Readable._fromList=fromList,Writable.WritableState=WritableState,xo(Writable,EventEmitter),WritableState.prototype.getBuffer=function writableStateGetBuffer(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},Writable.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))},Writable.prototype.write=function(e,t,n){var a=this._writableState,r=!1;return"function"==typeof t&&(n=t,t=null),Buffer$1.isBuffer(e)?t="buffer":t||(t=a.defaultEncoding),"function"!=typeof n&&(n=nop),a.ended?function writeAfterEnd(e,t){var n=new Error("write after end");e.emit("error",n),nextTick(t,n)}(this,n):function validChunk(e,t,n,a){var r=!0,o=!1
;return null===n?o=new TypeError("May not write null values to stream"):Buffer$1.isBuffer(n)||"string"==typeof n||void 0===n||t.objectMode||(o=new TypeError("Invalid non-string/buffer chunk")),o&&(e.emit("error",o),nextTick(a,o),r=!1),r}(this,a,e,n)&&(a.pendingcb++,r=function writeOrBuffer(e,t,n,a,r){n=function decodeChunk(e,t,n){e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=Buffer$1.from(t,n));return t}(t,n,a),Buffer$1.isBuffer(n)&&(a="buffer");var o=t.objectMode?1:n.length;t.length+=o;var i=t.length<t.highWaterMark;i||(t.needDrain=!0);if(t.writing||t.corked){var s=t.lastBufferedRequest;t.lastBufferedRequest=new WriteReq(n,a,r),s?s.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else doWrite(e,t,!1,o,n,a,r);return i}(this,a,e,t,n)),r},Writable.prototype.cork=function(){this._writableState.corked++},Writable.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,
e.writing||e.corked||e.finished||e.bufferProcessing||!e.bufferedRequest||clearBuffer(this,e))},Writable.prototype.setDefaultEncoding=function setDefaultEncoding(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new TypeError("Unknown encoding: "+e);return this._writableState.defaultEncoding=e,this},Writable.prototype._write=function(e,t,n){n(new Error("not implemented"))},Writable.prototype._writev=null,Writable.prototype.end=function(e,t,n){var a=this._writableState;"function"==typeof e?(n=e,e=null,t=null):"function"==typeof t&&(n=t,t=null),null!=e&&this.write(e,t),a.corked&&(a.corked=1,this.uncork()),a.ending||a.finished||function endWritable(e,t,n){t.ending=!0,finishMaybe(e,t),n&&(t.finished?nextTick(n):e.once("finish",n));t.ended=!0,e.writable=!1}(this,a,n)},xo(Duplex,Readable);for(var Oo=Object.keys(Writable.prototype),Bo=0;Bo<Oo.length;Bo++){
var Uo=Oo[Bo];Duplex.prototype[Uo]||(Duplex.prototype[Uo]=Writable.prototype[Uo])}function Duplex(e){if(!(this instanceof Duplex))return new Duplex(e);Readable.call(this,e),Writable.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",onend)}function onend(){this.allowHalfOpen||this._writableState.ended||nextTick(onEndNT,this)}function onEndNT(e){e.end()}function TransformState(e){this.afterTransform=function(t,n){return function afterTransform(e,t,n){var a=e._transformState;a.transforming=!1;var r=a.writecb;if(!r)return e.emit("error",new Error("no writecb in Transform class"));a.writechunk=null,a.writecb=null,null!=n&&e.push(n);r(t);var o=e._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&e._read(o.highWaterMark)}(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}
function Transform(e){if(!(this instanceof Transform))return new Transform(e);Duplex.call(this,e),this._transformState=new TransformState(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.once("prefinish",(function(){"function"==typeof this._flush?this._flush((function(e){done(t,e)})):done(t)}))}function done(e,t){if(t)return e.emit("error",t);var n=e._writableState,a=e._transformState;if(n.length)throw new Error("Calling transform done when ws.length != 0");if(a.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}function PassThrough(e){if(!(this instanceof PassThrough))return new PassThrough(e);Transform.call(this,e)}function Stream(){EventEmitter.call(this)}xo(Transform,Duplex),Transform.prototype.push=function(e,t){return this._transformState.needTransform=!1,
Duplex.prototype.push.call(this,e,t)},Transform.prototype._transform=function(e,t,n){throw new Error("Not implemented")},Transform.prototype._write=function(e,t,n){var a=this._transformState;if(a.writecb=n,a.writechunk=e,a.writeencoding=t,!a.transforming){var r=this._readableState;(a.needTransform||r.needReadable||r.length<r.highWaterMark)&&this._read(r.highWaterMark)}},Transform.prototype._read=function(e){var t=this._transformState;null!==t.writechunk&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0},xo(PassThrough,Transform),PassThrough.prototype._transform=function(e,t,n){n(null,e)},xo(Stream,EventEmitter),Stream.Readable=Readable,Stream.Writable=Writable,Stream.Duplex=Duplex,Stream.Transform=Transform,Stream.PassThrough=PassThrough,Stream.Stream=Stream,Stream.prototype.pipe=function(e,t){var n=this;function ondata(t){e.writable&&!1===e.write(t)&&n.pause&&n.pause()}function ondrain(){
n.readable&&n.resume&&n.resume()}n.on("data",ondata),e.on("drain",ondrain),e._isStdio||t&&!1===t.end||(n.on("end",onend),n.on("close",onclose));var a=!1;function onend(){a||(a=!0,e.end())}function onclose(){a||(a=!0,"function"==typeof e.destroy&&e.destroy())}function onerror(e){if(cleanup(),0===EventEmitter.listenerCount(this,"error"))throw e}function cleanup(){n.removeListener("data",ondata),e.removeListener("drain",ondrain),n.removeListener("end",onend),n.removeListener("close",onclose),n.removeListener("error",onerror),e.removeListener("error",onerror),n.removeListener("end",cleanup),n.removeListener("close",cleanup),e.removeListener("close",cleanup)}return n.on("error",onerror),e.on("error",onerror),n.on("end",cleanup),n.on("close",cleanup),e.on("close",cleanup),e.emit("pipe",n),e};const jo=1460;class TcpConnection{constructor(e,t,n=0,a=!0,r=!1){this._warmed=!1,this._ssl=a,this._h2=r,this._rtt=e,this._throughput=t,this._serverLatency=n,this._congestionWindow=10,
this._h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(e,t){const n=8*(1460*(1e3/e));return Math.floor(t/n)}_computeMaximumCongestionWindowInSegments(){const e=this._throughput/8*(this._rtt/1e3);return Math.floor(e/jo)}setThroughput(e){this._throughput=e}setCongestionWindow(e){this._congestionWindow=e}setWarmed(e){this._warmed=e}isWarm(){return this._warmed}isH2(){return this._h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(e){this._h2&&(this._h2OverflowBytesDownloaded=e)}clone(){return Object.assign(new TcpConnection(this._rtt,this._throughput),this)}simulateDownloadUntil(e,t){const{timeAlreadyElapsed:n=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:r=0}=t||{};this._warmed&&this._h2&&(e-=this._h2OverflowBytesDownloaded);const o=this._rtt,i=o/2,s=this._computeMaximumCongestionWindowInSegments();let c=i;this._warmed||(c=r+i+i+i+(this._ssl?o:0));let l=Math.ceil(c/o),u=c+this._serverLatency+i;this._warmed&&this._h2&&(u=0)
;const d=Math.max(u-n,0),m=a-d;let p=Math.min(this._congestionWindow,s),h=0;d>0?h=p*jo:l=0;let f=0,y=e-h;for(;y>0&&f<=m;){l++,f+=o,p=Math.max(Math.min(s,2*p),1);const e=p*jo;h+=e,y-=e}const b=d+f,v=this._h2?Math.max(h-e,0):0,w=Math.max(Math.min(h,e),0);let D;return D=this._warmed?this._h2?{timeToFirstByte:u}:{connectionTime:c,timeToFirstByte:u}:{dnsResolutionTime:r,connectionTime:c-r,sslTime:this._ssl?o:void 0,timeToFirstByte:u},{roundTrips:l,timeElapsed:b,bytesDownloaded:w,extraBytesDownloaded:v,congestionWindow:p,connectionTiming:D}}}const zo=["https","wss"];class ConnectionPool{constructor(e,t){this._options=t,this._records=e,this._connectionsByOrigin=new Map,this._connectionsByRecord=new Map,this._connectionsInUse=new Set,this._connectionReusedByRequestId=NetworkAnalyzer.estimateIfConnectionWasReused(e,{forceCoarseEstimates:!0}),this._initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}_initializeConnections(){
const e=this._connectionReusedByRequestId,t=this._options.additionalRttByOrigin,n=this._options.serverResponseTimeByOrigin,a=NetworkAnalyzer.groupByOrigin(this._records);for(const[r,o]of a.entries()){const a=[],i=t.get(r)||0,s=n.get(r)||30;for(const t of o){if(e.get(t.requestId))continue;const n=zo.includes(t.parsedURL.scheme),r="h2"===t.protocol,o=new TcpConnection(this._options.rtt+i,this._options.throughput,s,n,r);a.push(o)}if(!a.length)throw new Error(`Could not find a connection for origin: ${r}`);const c=a[0].isH2()?1:6;for(;a.length<c;)a.push(a[0].clone());this._connectionsByOrigin.set(r,a)}}_findAvailableConnectionWithLargestCongestionWindow(e,t){const{ignoreConnectionReused:n,observedConnectionWasReused:a}=t;let r=null;for(let t=0;t<e.length;t++){const o=e[t];if(!n&&o._warmed!==a)continue;if(this._connectionsInUse.has(o))continue;const i=r?.congestionWindow||-1/0;o.congestionWindow>i&&(r=o)}return r}acquire(e,t={}){
if(this._connectionsByRecord.has(e))throw new Error("Record already has a connection");const n=e.parsedURL.securityOrigin,a=!!this._connectionReusedByRequestId.get(e.requestId),r=this._connectionsByOrigin.get(n)||[],o=this._findAvailableConnectionWithLargestCongestionWindow(r,{ignoreConnectionReused:t.ignoreConnectionReused,observedConnectionWasReused:a});return o?(this._connectionsInUse.add(o),this._connectionsByRecord.set(e,o),o):null}acquireActiveConnectionFromRecord(e){const t=this._connectionsByRecord.get(e);if(!t)throw new Error("Could not find an active connection for record");return t}release(e){const t=this._connectionsByRecord.get(e);this._connectionsByRecord.delete(e),this._connectionsInUse.delete(t)}}class DNSCache{constructor({rtt:e}){this._rtt=e,this._resolvedDomainNames=new Map}getTimeUntilResolution(e,t){const{requestedAt:n=0,shouldUpdateCache:a=!1}=t||{},r=e.parsedURL.host,o=this._resolvedDomainNames.get(r);let i=this._rtt*DNSCache.RTT_MULTIPLIER;if(o){
const e=Math.max(o.resolvedAt-n,0);i=Math.min(e,i)}const s=n+i;return a&&this._updateCacheResolvedAtIfNeeded(e,s),i}_updateCacheResolvedAtIfNeeded(e,t){const n=e.parsedURL.host,a=this._resolvedDomainNames.get(n)||{resolvedAt:t};a.resolvedAt=Math.min(a.resolvedAt,t),this._resolvedDomainNames.set(n,a)}setResolvedAt(e,t){this._resolvedDomainNames.set(e,{resolvedAt:t})}}DNSCache.RTT_MULTIPLIER=2;class SimulatorTimingMap{constructor(){this._nodeTimings=new Map}getNodes(){return Array.from(this._nodeTimings.keys())}setReadyToStart(e,t){this._nodeTimings.set(e,t)}setInProgress(e,t){const n={...this.getQueued(e),startTime:t.startTime,timeElapsed:0};this._nodeTimings.set(e,e.type===BaseNode.TYPES.NETWORK?{...n,timeElapsedOvershoot:0,bytesDownloaded:0}:n)}setCompleted(e,t){const n={...this.getInProgress(e),endTime:t.endTime,connectionTiming:t.connectionTiming};this._nodeTimings.set(e,n)}setCpu(e,t){const n={...this.getCpuStarted(e),timeElapsed:t.timeElapsed};this._nodeTimings.set(e,n)}
setCpuEstimated(e,t){const n={...this.getCpuStarted(e),estimatedTimeElapsed:t.estimatedTimeElapsed};this._nodeTimings.set(e,n)}setNetwork(e,t){const n={...this.getNetworkStarted(e),timeElapsed:t.timeElapsed,timeElapsedOvershoot:t.timeElapsedOvershoot,bytesDownloaded:t.bytesDownloaded};this._nodeTimings.set(e,n)}setNetworkEstimated(e,t){const n={...this.getNetworkStarted(e),estimatedTimeElapsed:t.estimatedTimeElapsed};this._nodeTimings.set(e,n)}getQueued(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);return t}getCpuStarted(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if("bytesDownloaded"in t)throw new Error(`Node ${e.id} timing not valid`);return t}getNetworkStarted(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`)
;if(!("bytesDownloaded"in t))throw new Error(`Node ${e.id} timing not valid`);return t}getInProgress(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if(!("estimatedTimeElapsed"in t))throw new Error(`Node ${e.id} not yet in progress`);return t}getCompleted(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if(!("estimatedTimeElapsed"in t))throw new Error(`Node ${e.id} not yet in progress`);if(!("endTime"in t))throw new Error(`Node ${e.id} not yet completed`);return t}}const qo=Jr.mobileSlow4G,Wo={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},$o={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},Vo=new Map;class Simulator{constructor(e){if(this._options=Object.assign({rtt:qo.rttMs,throughput:1024*qo.throughputKbps,maximumConcurrentRequests:10,
cpuSlowdownMultiplier:qo.cpuSlowdownMultiplier,layoutTaskMultiplier:.5,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},e),this._rtt=this._options.rtt,this._throughput=this._options.throughput,this._maximumConcurrentRequests=Math.max(Math.min(TcpConnection.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1),this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier,this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier,this._cachedNodeListByStartPosition=[],this._flexibleOrdering=!1,this._nodeTimings=new SimulatorTimingMap,this._numberInProgressByType=new Map,this._nodes={},this._dns=new DNSCache({rtt:this._rtt}),this._connectionPool=null,!Number.isFinite(this._rtt))throw new Error(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this._throughput))throw new Error(`Invalid rtt ${this._throughput}`)}get rtt(){return this._rtt}_initializeConnectionPool(e){const t=[]
;e.getRootNode().traverse((e=>{e.type===BaseNode.TYPES.NETWORK&&t.push(e.record)})),this._connectionPool=new ConnectionPool(t,this._options)}_initializeAuxiliaryData(){this._nodeTimings=new SimulatorTimingMap,this._numberInProgressByType=new Map,this._nodes={},this._cachedNodeListByStartPosition=[];for(const e of Object.values(Wo))this._nodes[e]=new Set}_numberInProgress(e){return this._numberInProgressByType.get(e)||0}_markNodeAsReadyToStart(e,t){const n=Simulator._computeNodeStartPosition(e),a=this._cachedNodeListByStartPosition.findIndex((e=>Simulator._computeNodeStartPosition(e)>n)),r=-1===a?this._cachedNodeListByStartPosition.length:a;this._cachedNodeListByStartPosition.splice(r,0,e),this._nodes[Wo.ReadyToStart].add(e),this._nodes[Wo.NotReadyToStart].delete(e),this._nodeTimings.setReadyToStart(e,{queuedTime:t})}_markNodeAsInProgress(e,t){const n=this._cachedNodeListByStartPosition.indexOf(e);this._cachedNodeListByStartPosition.splice(n,1),this._nodes[Wo.InProgress].add(e),
this._nodes[Wo.ReadyToStart].delete(e),this._numberInProgressByType.set(e.type,this._numberInProgress(e.type)+1),this._nodeTimings.setInProgress(e,{startTime:t})}_markNodeAsComplete(e,t,n){this._nodes[Wo.Complete].add(e),this._nodes[Wo.InProgress].delete(e),this._numberInProgressByType.set(e.type,this._numberInProgress(e.type)-1),this._nodeTimings.setCompleted(e,{endTime:t,connectionTiming:n});for(const n of e.getDependents()){n.getDependencies().some((e=>!this._nodes[Wo.Complete].has(e)))||this._markNodeAsReadyToStart(n,t)}}_acquireConnection(e){return this._connectionPool.acquire(e,{ignoreConnectionReused:this._flexibleOrdering})}_getNodesSortedByStartPosition(){return Array.from(this._cachedNodeListByStartPosition)}_startNodeIfPossible(e,t){if(e.type!==BaseNode.TYPES.CPU){if(e.type!==BaseNode.TYPES.NETWORK)throw new Error("Unsupported");if(!e.isConnectionless){if(this._numberInProgress(e.type)>=this._maximumConcurrentRequests)return;if(!this._acquireConnection(e.record))return}
this._markNodeAsInProgress(e,t)}else 0===this._numberInProgress(e.type)&&this._markNodeAsInProgress(e,t)}_updateNetworkCapacity(){const e=this._numberInProgress(BaseNode.TYPES.NETWORK);if(0!==e)for(const t of this._connectionPool.connectionsInUse())t.setThroughput(this._throughput/e)}_estimateTimeRemaining(e){if(e.type===BaseNode.TYPES.CPU)return this._estimateCPUTimeRemaining(e);if(e.type===BaseNode.TYPES.NETWORK)return this._estimateNetworkTimeRemaining(e);throw new Error("Unsupported")}_estimateCPUTimeRemaining(e){const t=this._nodeTimings.getCpuStarted(e),n=e.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier,a=Math.min(Math.round(e.event.dur/1e3*n),1e4)-t.timeElapsed;return this._nodeTimings.setCpuEstimated(e,{estimatedTimeElapsed:a}),a}_estimateNetworkTimeRemaining(e){const t=e.record,n=this._nodeTimings.getNetworkStarted(e);let a=0;if(e.fromDiskCache){a=8+20*((t.resourceSize||0)/1024/1024)-n.timeElapsed}else if(e.isNonNetworkProtocol){
a=2+10*((t.resourceSize||0)/1024/1024)-n.timeElapsed}else{const e=this._connectionPool.acquireActiveConnectionFromRecord(t),r=this._dns.getTimeUntilResolution(t,{requestedAt:n.startTime,shouldUpdateCache:!0}),o=n.timeElapsed;a=e.simulateDownloadUntil(t.transferSize-n.bytesDownloaded,{timeAlreadyElapsed:o,dnsResolutionTime:r,maximumTimeToElapse:1/0}).timeElapsed}const r=a+n.timeElapsedOvershoot;return this._nodeTimings.setNetworkEstimated(e,{estimatedTimeElapsed:r}),r}_findNextNodeCompletionTime(){let e=1/0;for(const t of this._nodes[Wo.InProgress])e=Math.min(e,this._estimateTimeRemaining(t));return e}_updateProgressMadeInTimePeriod(e,t,n){const a=this._nodeTimings.getInProgress(e),r=a.estimatedTimeElapsed===t;if(e.type===BaseNode.TYPES.CPU||e.isConnectionless)return r?this._markNodeAsComplete(e,n):a.timeElapsed+=t;if(e.type!==BaseNode.TYPES.NETWORK)throw new Error("Unsupported");if(!("bytesDownloaded"in a))throw new Error("Invalid timing data")
;const o=e.record,i=this._connectionPool.acquireActiveConnectionFromRecord(o),s=this._dns.getTimeUntilResolution(o,{requestedAt:a.startTime,shouldUpdateCache:!0}),c=i.simulateDownloadUntil(o.transferSize-a.bytesDownloaded,{dnsResolutionTime:s,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:t-a.timeElapsedOvershoot});i.setCongestionWindow(c.congestionWindow),i.setH2OverflowBytesDownloaded(c.extraBytesDownloaded),r?(i.setWarmed(!0),this._connectionPool.release(o),this._markNodeAsComplete(e,n,c.connectionTiming)):(a.timeElapsed+=c.timeElapsed,a.timeElapsedOvershoot+=c.timeElapsed-t,a.bytesDownloaded+=c.bytesDownloaded)}_computeFinalNodeTimings(){const e=this._nodeTimings.getNodes().map((e=>[e,this._nodeTimings.getCompleted(e)]));e.sort(((e,t)=>e[1].startTime-t[1].startTime));const t=e.map((([e,t])=>[e,{startTime:t.startTime,endTime:t.endTime,duration:t.endTime-t.startTime}]));return{nodeTimings:new Map(t),completeNodeTimings:new Map(e)}}getOptions(){return this._options}
simulate(e,t){if(BaseNode.hasCycle(e))throw new Error("Cannot simulate graph with cycle");t=Object.assign({label:void 0,flexibleOrdering:!1},t),this._flexibleOrdering=!!t.flexibleOrdering,this._dns=new DNSCache({rtt:this._rtt}),this._initializeConnectionPool(e),this._initializeAuxiliaryData();const n=this._nodes[Wo.NotReadyToStart],a=this._nodes[Wo.ReadyToStart],r=this._nodes[Wo.InProgress],o=e.getRootNode();o.traverse((e=>n.add(e)));let i=0,s=0;for(this._markNodeAsReadyToStart(o,i);a.size||r.size;){for(const e of this._getNodesSortedByStartPosition())this._startNodeIfPossible(e,i);if(!r.size){if(this._flexibleOrdering)throw new Error("Failed to start a node");this._flexibleOrdering=!0;continue}this._updateNetworkCapacity();const e=this._findNextNodeCompletionTime();if(i+=e,!Number.isFinite(e)||s>1e5)throw new Error("Simulation failed, depth exceeded");s++;for(const t of r)this._updateProgressMadeInTimePeriod(t,e,i)}
const{nodeTimings:c,completeNodeTimings:l}=this._computeFinalNodeTimings();return Vo.set(t.label||"unlabeled",l),{timeInMs:i,nodeTimings:c}}computeWastedMsFromWastedBytes(e){const{throughput:t,observedThroughput:n}=this._options,a=0===t?n:t;if(0===a)return 0;return 8*e/a*1e3}static get ALL_NODE_TIMINGS(){return Vo}static _computeNodeStartPosition(e){return"cpu"===e.type?e.startTime:e.startTime+(1e3*$o[e.record.priority]*1e3||0)}}class NetworkAnalysis{static computeRTTAndServerResponseTime(e){const t=new Map;for(const[n,a]of NetworkAnalyzer.estimateRTTByOrigin(e).entries())t.set(n,a.min);const n=Math.min(...Array.from(t.values())),a=NetworkAnalyzer.estimateServerResponseTimeByOrigin(e,{rttByOrigin:t}),r=new Map,o=new Map;for(const[e,i]of a.entries()){const a=t.get(e)||n;r.set(e,a-n),o.set(e,i.median)}return{rtt:n,additionalRttByOrigin:r,serverResponseTimeByOrigin:o}}static async compute_(e,t){const n=await bo.request(e,t);return{throughput:NetworkAnalyzer.estimateThroughput(n),
...NetworkAnalysis.computeRTTAndServerResponseTime(n)}}}const Ho=makeComputedArtifact(NetworkAnalysis,null);const Go=makeComputedArtifact(class LoadSimulator{static async compute_(e,t){const{throttlingMethod:n,throttling:a,precomputedLanternData:r}=e.settings,o=await Ho.request(e.devtoolsLog,t),i={additionalRttByOrigin:o.additionalRttByOrigin,serverResponseTimeByOrigin:o.serverResponseTimeByOrigin,observedThroughput:o.throughput};switch(r&&(i.additionalRttByOrigin=new Map(Object.entries(r.additionalRttByOrigin)),i.serverResponseTimeByOrigin=new Map(Object.entries(r.serverResponseTimeByOrigin))),n){case"provided":i.rtt=o.rtt,i.throughput=o.throughput,i.cpuSlowdownMultiplier=1,i.layoutTaskMultiplier=1;break;case"devtools":a&&(i.rtt=a.requestLatencyMs/Jr.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,i.throughput=1024*a.downloadThroughputKbps/Jr.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),i.cpuSlowdownMultiplier=1,i.layoutTaskMultiplier=1;break;case"simulate":a&&(i.rtt=a.rttMs,
i.throughput=1024*a.throughputKbps,i.cpuSlowdownMultiplier=a.cpuSlowdownMultiplier)}return new Simulator(i)}static convertAnalysisToSaveableLanternData(e){const t={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(const[n,a]of e.additionalRttByOrigin.entries())n.startsWith("http")&&(t.additionalRttByOrigin[n]=a);for(const[n,a]of e.serverResponseTimeByOrigin.entries())n.startsWith("http")&&(t.serverResponseTimeByOrigin[n]=a);return t}},["devtoolsLog","settings"]),Yo="artifacts.json",Ko=".trace.json",Jo=".devtoolslog.json";function loadArtifacts(e){if(Log.log("Reading artifacts from disk:",e),!J.existsSync(e))throw new Error("No saved artifacts found at "+e);const t=J.readFileSync(Q.join(e,Yo),"utf8"),n=JSON.parse(t,LighthouseError.parseReviver),a=J.readdirSync(e);return n.devtoolsLogs={},a.filter((e=>e.endsWith(Jo))).forEach((t=>{const a=t.replace(Jo,""),r=JSON.parse(J.readFileSync(Q.join(e,t),"utf8"));n.devtoolsLogs[a]=r,"defaultPass"===a&&(n.DevtoolsLog=r)})),n.traces={},
a.filter((e=>e.endsWith(Ko))).forEach((t=>{const a=J.readFileSync(Q.join(e,t),{encoding:"utf-8"}),r=JSON.parse(a),o=t.replace(Ko,"");n.traces[o]=Array.isArray(r)?{traceEvents:r}:r,"defaultPass"===o&&(n.Trace=n.traces[o])})),Array.isArray(n.Timing)&&n.Timing.forEach((e=>e.gather=!0)),n}function stringifyReplacer(e,t){return t instanceof Error?LighthouseError.stringifyReplacer(t):t}function*arrayOfObjectsJsonGenerator(e){if(yield"[\n",e.length>0){const t=e[Symbol.iterator](),n=t.next().value;yield`  ${JSON.stringify(n)}`;let a=500,r="";for(const e of t)r+=`,\n  ${JSON.stringify(e)}`,a--,0===a&&(yield r,a=500,r="");yield r}yield"\n]"}async function saveTrace(e,t){const n=function*traceJsonGenerator(e){const{traceEvents:t,...n}=e;yield"{\n",yield'"traceEvents": ',yield*arrayOfObjectsJsonGenerator(t);for(const[e,t]of Object.entries(n))yield`,\n"${e}": ${JSON.stringify(t,null,2)}`;yield"}\n"}(e),a=J.createWriteStream(t);return Stream.promises.pipeline(n,a)}function saveDevtoolsLog(e,t){
const n=J.createWriteStream(t);return Stream.promises.pipeline((function*(){yield*arrayOfObjectsJsonGenerator(e),yield"\n"}),n)}const Xo=[],noop=()=>{},Zo={init:async function init(e){if(!e.flags.enableErrorReporting)return;if(!Zo._shouldSample())return;try{const t=await Promise.resolve().then((function(){return Pi}));t.init({...e.environmentData,dsn:"https://a6bb0da87ee048cc9ae2a345fc09ab2e:63a7029f46f74265981b7e005e0f69f8@sentry.io/174697"});const n={...e.flags.throttling,channel:e.flags.channel||"cli",url:e.url,formFactor:e.flags.formFactor,throttlingMethod:e.flags.throttlingMethod};t.setExtras(n),Zo.captureMessage=(...e)=>t.captureMessage(...e),Zo.captureBreadcrumb=(...e)=>t.addBreadcrumb(...e),Zo.getContext=()=>n;const a=new Map;Zo.captureException=async(e,n={})=>{if(!e)return;if(e.expected)return;const r=n.tags||{};if(r.audit){const t=`audit-${r.audit}-${e.message}`;if(a.has(t))return;a.set(t,!0)}if(r.gatherer){const t=`gatherer-${r.gatherer}-${e.message}`;if(a.has(t))return
;a.set(t,!0)}const o=Xo.find((t=>t.pattern.test(e.message)));o&&o.rate<=Math.random()||(e.protocolMethod&&(n.fingerprint=["{{ default }}",e.protocolMethod,e.protocolError],n.tags=n.tags||{},n.tags.protocolMethod=e.protocolMethod),t.withScope((a=>{n.level&&a.setLevel(n.level),n.tags&&a.setTags(n.tags),n.extra&&a.setExtras(n.extra),t.captureException(e)})))}}catch(e){Log.warn("sentry","Could not load Sentry, errors will not be reported.")}},captureMessage:noop,captureBreadcrumb:noop,getContext:noop,captureException:async()=>{},_shouldSample:()=>.01>=Math.random()};const Qo=Zo,ei={};class ReportGenerator{static replaceStrings(e,t){if(0===t.length)return e;const n=t[0],a=t.slice(1);return e.split(n.search).map((e=>ReportGenerator.replaceStrings(e,a))).join(n.replacement)}static sanitizeJson(e){return JSON.stringify(e).replace(/</g,"\\u003c").replace(/\u2028/g,"\\u2028").replace(/\u2029/g,"\\u2029")}static generateReportHtml(e){
const t=ReportGenerator.sanitizeJson(e),n=ei.REPORT_JAVASCRIPT.replace(/<\//g,"\\u003c/");return ReportGenerator.replaceStrings(ei.REPORT_TEMPLATE,[{search:"%%LIGHTHOUSE_JSON%%",replacement:t},{search:"%%LIGHTHOUSE_JAVASCRIPT%%",replacement:n}])}static generateFlowReportHtml(e){const t=ReportGenerator.sanitizeJson(e),n=ei.FLOW_REPORT_JAVASCRIPT.replace(/<\//g,"\\u003c/");return ReportGenerator.replaceStrings(ei.FLOW_REPORT_TEMPLATE,[{search:"%%LIGHTHOUSE_FLOW_JSON%%",replacement:t},{search:"%%LIGHTHOUSE_FLOW_JAVASCRIPT%%",replacement:n},{search:"/*%%LIGHTHOUSE_FLOW_CSS%%*/",replacement:ei.FLOW_REPORT_CSS}])}static generateReportCSV(e){const escape=e=>`"${e.replace(/"/g,'""')}"`,rowFormatter=e=>e.map((e=>null===e?"null":e.toString())).map(escape),t=[],n=["requestedUrl","finalDisplayedUrl","fetchTime","gatherMode"];t.push(rowFormatter(n)),t.push(rowFormatter(n.map((t=>e[t]??null)))),t.push([]),t.push(["category","score"])
;for(const n of Object.values(e.categories))t.push(rowFormatter([n.id,n.score]));t.push([]),t.push(["category","audit","score","displayValue","description"]);for(const n of Object.values(e.categories))for(const a of n.auditRefs){const r=e.audits[a.id];r&&t.push(rowFormatter([n.id,a.id,r.score,r.displayValue||"",r.description]))}return t.map((e=>e.join(","))).join("\r\n")}static isFlowResult(e){return"steps"in e}static generateReport(e,t){const n=Array.isArray(t);"string"==typeof t&&(t=[t]);const a=t.map((t=>{if("html"===t)return ReportGenerator.isFlowResult(e)?ReportGenerator.generateFlowReportHtml(e):ReportGenerator.generateReportHtml(e);if("csv"===t){if(ReportGenerator.isFlowResult(e))throw new Error("CSV output is not support for user flows");return ReportGenerator.generateReportCSV(e)}if("json"===t)return JSON.stringify(e,null,2);throw new Error("Invalid output mode: "+t)}));return n?a:a[0]}}
const ti=/:\/\/(\S*?)(:\d+)?(\/|$)/,ni=/([a-z0-9.-]+\.[a-z0-9]+|localhost)/i,ai=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,ri=/[^.]+\.([^.]+|(gov|com|co|ne)\.\w{2})$/i;function getDomainFromOriginOrURL(e){return"string"!=typeof e||e.length>1e4||e.startsWith("data:")?null:ti.test(e)?e.match(ti)[1]:ni.test(e)?e.match(ni)[0]:null}function getRootDomain(e){const t=getDomainFromOriginOrURL(e);if(!t)return null;if(ai.test(t))return t;const n=t.match(ri);return n&&n[0]||t}function sliceSubdomainFromDomain(e,t){return e.length<=t.length?e:e.split(".").slice(1).join(".")}function getEntityInDataset(e,t,n,a){const r=getDomainFromOriginOrURL(a),o=getRootDomain(r);if(r&&o){if(e.has(r))return e.get(r);for(let e=r;e.length>o.length;e=sliceSubdomainFromDomain(e,o))if(t.has(e))return t.get(e);return n.has(o)?n.get(o):void 0}}function getProductInDataset(e,t,n,a){const r=getEntityInDataset(e,t,n,a),o=r&&r.products;if(o&&"string"==typeof a)for(const e of o)for(const t of e.urlPatterns){
if(t instanceof RegExp&&t.test(a))return e;if("string"==typeof t&&a.includes(t))return e}}var oi={createAPIFromDataset:function createAPIFromDataset$1(e){const t=function cloneEntities(e){return e.map((e=>{const t={company:e.name,categories:[e.category],...e},n=(e.products||[]).map((e=>({company:t.company,category:t.category,categories:[t.category],facades:[],...e,urlPatterns:(e.urlPatterns||[]).map((e=>e.startsWith("REGEXP:")?new RegExp(e.slice("REGEXP:".length)):e))})));return t.products=n,t}))}(e),n=new Map,a=new Map,r=new Map;for(const e of t){e.totalExecutionTime=Number(e.totalExecutionTime)||0,e.totalOccurrences=Number(e.totalOccurrences)||0,e.averageExecutionTime=e.totalExecutionTime/e.totalOccurrences;for(const t of e.domains){if(n.has(t)){const a=n.get(t);throw new Error(`Duplicate domain ${t} (${e.name} and ${a.name})`)}n.set(t,e);const o=getRootDomain(t);if(t.startsWith("*.")){const n=t.slice(2);n===o?a.set(o,e):r.set(n,e)}}}for(const[e,t]of a.entries())t||a.delete(e)
;return{getEntity:getEntityInDataset.bind(null,n,r,a),getProduct:getProductInDataset.bind(null,n,r,a),getRootDomain,entities:t}}};const{createAPIFromDataset:ii}=oi;var si=ii([{name:"Google/Doubleclick Ads",company:"Google",homepage:"https://marketingplatform.google.com/about/enterprise/",category:"ad",domains:["adservice.google.com","adservice.google.com.au","adservice.google.com.sg","adservice.google.com.br","adservice.google.com.ua","adservice.google.co.uk","adservice.google.co.jp","adservice.google.co.in","adservice.google.co.kr","adservice.google.co.id","adservice.google.co.nz","adservice.google.ie","adservice.google.se","adservice.google.de","adservice.google.ca","adservice.google.be","adservice.google.es","adservice.google.ch","adservice.google.fr","adservice.google.nl","*.googleadservices.com","*.googlesyndication.com","*.googletagservices.com","*.2mdn.net","*.doubleclick.net"]},{name:"Facebook",homepage:"https://www.facebook.com",category:"social",
domains:["*.facebook.com","*.atlassbx.com","*.fbsbx.com","fbcdn-photos-e-a.akamaihd.net","*.facebook.net","*.fbcdn.net"],products:[{name:"Facebook Messenger Customer Chat",urlPatterns:["REGEXP:connect\\.facebook\\.net\\/.*\\/sdk\\/xfbml\\.customerchat\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}]},{name:"Instagram",homepage:"https://www.instagram.com",category:"social",domains:["*.cdninstagram.com","*.instagram.com"]},{name:"Google CDN",company:"Google",homepage:"https://developers.google.com/speed/libraries/",category:"cdn",domains:["ajax.googleapis.com","commondatastorage.googleapis.com","www.gstatic.com","ssl.gstatic.com"]},{name:"Google Maps",company:"Google",homepage:"https://www.google.com/maps",category:"utility",
domains:["maps.google.com","maps-api-ssl.google.com","maps.googleapis.com","mts.googleapis.com","mt.googleapis.com","mt0.googleapis.com","mt1.googleapis.com","mt2.googleapis.com","mt3.googleapis.com","khm0.googleapis.com","khm1.googleapis.com","khms.googleapis.com","khms1.googleapis.com","khms2.googleapis.com","maps.gstatic.com"]},{name:"Other Google APIs/SDKs",company:"Google",homepage:"https://developers.google.com/apis-explorer/#p/",category:"utility",
domains:["accounts.google.com","apis.google.com","calendar.google.com","clients2.google.com","cse.google.com","news.google.com","pay.google.com","payments.google.com","play.google.com","smartlock.google.com","www.google.com","www.google.de","www.google.co.jp","www.google.com.au","www.google.co.uk","www.google.ie","www.google.com.sg","www.google.co.in","www.google.com.br","www.google.ca","www.google.co.kr","www.google.co.nz","www.google.co.id","www.google.fr","www.google.be","www.google.com.ua","www.google.nl","www.google.ru","www.google.se","www.googleapis.com","imasdk.googleapis.com","storage.googleapis.com","translate.googleapis.com","translate.google.com","translate-pa.googleapis.com","lh3.googleusercontent.com","jnn-pa.googleapis.com","csi.gstatic.com"]},{name:"Firebase",homepage:"https://developers.google.com/apis-explorer/#p/",category:"utility",
domains:["firebasestorage.googleapis.com","firestore.googleapis.com","firebaseinstallations.googleapis.com","firebase.googleapis.com","firebaseremoteconfig.googleapis.com"]},{name:"Google Analytics",company:"Google",homepage:"https://marketingplatform.google.com/about/analytics/",category:"analytics",domains:["*.google-analytics.com","*.urchin.com","analytics.google.com"]},{name:"Google Optimize",company:"Google",homepage:"https://marketingplatform.google.com/about/optimize/",category:"analytics",domains:["www.googleoptimize.com"]},{name:"Google AMP",company:"Google",homepage:"https://github.com/google/amp-client-id-library",category:"analytics",domains:["ampcid.google.com"]},{name:"Google Tag Manager",company:"Google",homepage:"https://marketingplatform.google.com/about/tag-manager/",category:"tag-manager",domains:["*.googletagmanager.com"]},{name:"Google Fonts",company:"Google",homepage:"https://fonts.google.com/",category:"cdn",domains:["fonts.googleapis.com","fonts.gstatic.com"]},{
name:"Adobe TypeKit",company:"Adobe",homepage:"https://fonts.adobe.com/",category:"cdn",domains:["*.typekit.com","*.typekit.net"]},{name:"YouTube",homepage:"https://youtube.com",category:"video",domains:["*.youtube.com","*.ggpht.com","*.youtube-nocookie.com","*.ytimg.com"],products:[{name:"YouTube Embedded Player",urlPatterns:["youtube.com/embed/"],facades:[{name:"Lite YouTube",repo:"https://github.com/paulirish/lite-youtube-embed"}]}]},{name:"Twitter",homepage:"https://twitter.com",category:"social",domains:["*.vine.co","*.twimg.com","*.twitpic.com","platform.twitter.com","syndication.twitter.com"]},{name:"AddThis",homepage:"https://www.addthis.com/",category:"social",domains:["*.addthis.com","*.addthiscdn.com","*.addthisedge.com"]},{name:"AddToAny",homepage:"https://www.addtoany.com/",category:"social",domains:["*.addtoany.com"]},{name:"Akamai",homepage:"https://www.akamai.com/",category:"cdn",
domains:["23.62.3.183","*.akamaitechnologies.com","*.akamaitechnologies.fr","*.akamai.net","*.akamaiedge.net","*.akamaihd.net","*.akamaized.net","*.edgefcs.net","*.edgekey.net","edgesuite.net","*.srip.net"]},{name:"Blogger",homepage:"https://www.blogger.com/",category:"hosting",domains:["*.blogblog.com","*.blogger.com","*.blogspot.com","images-blogger-opensocial.googleusercontent.com"]},{name:"Gravatar",homepage:"https://en.gravatar.com/",category:"social",domains:["*.gravatar.com"]},{name:"Yandex Metrica",company:"Yandex",homepage:"https://metrica.yandex.com/about?",category:"analytics",domains:["mc.yandex.ru","mc.yandex.com","d31j93rd8oukbv.cloudfront.net"]},{name:"Hotjar",homepage:"https://www.hotjar.com/",category:"analytics",domains:["*.hotjar.com","*.hotjar.io"]},{name:"Baidu Analytics",homepage:"https://tongji.baidu.com/web/welcome/login",category:"analytics",domains:["hm.baidu.com","hmcdn.baidu.com"]},{name:"Insider",homepage:"",category:"analytics",domains:["*.useinsider.com"]
},{name:"Adobe Experience Cloud",company:"Adobe",homepage:"",category:"analytics",domains:["*.2o7.net","du8783wkf05yr.cloudfront.net","*.hitbox.com","*.imageg.net","*.nedstat.com","*.omtrdc.net"]},{name:"Adobe Tag Manager",company:"Adobe",homepage:"https://www.adobe.com/experience-platform/",category:"tag-manager",domains:["*.adobedtm.com","*.demdex.net","*.everesttech.net","sstats.adobe.com","hbrt.adobe.com"]},{name:"jQuery CDN",homepage:"https://code.jquery.com/",category:"cdn",domains:["*.jquery.com"]},{name:"Cloudflare CDN",homepage:"https://cdnjs.com/",category:"cdn",domains:["cdnjs.cloudflare.com","amp.cloudflare.com"]},{name:"Cloudflare",homepage:"https://www.cloudflare.com/website-optimization/",category:"utility",domains:["ajax.cloudflare.com","*.nel.cloudflare.com","static.cloudflareinsights.com"]},{name:"WordPress",company:"Automattic",homepage:"https://wp.com/",category:"hosting",
domains:["*.wordpress.com","s0.wp.com","s2.wp.com","*.w.org","c0.wp.com","s1.wp.com","i0.wp.com","i1.wp.com","i2.wp.com","widgets.wp.com"]},{name:"WordPress Site Stats",company:"Automattic",homepage:"https://wp.com/",category:"analytics",domains:["pixel.wp.com","stats.wp.com"]},{name:"Hatena Blog",homepage:"https://hatenablog.com/",category:"hosting",domains:["*.st-hatena.com","*.hatena.ne.jp"]},{name:"Shopify",homepage:"https://www.shopify.com/",category:"hosting",domains:["*.shopify.com","*.shopifyapps.com","*.shopifycdn.com","*.shopifysvc.com"]},{name:"Dealer",homepage:"https://www.dealer.com/",category:"hosting",domains:["*.dealer.com"]},{name:"PIXNET",homepage:"https://www.pixnet.net/",category:"social",domains:["*.pixfs.net","*.pixnet.net"]},{name:"Moat",homepage:"https://moat.com/",category:"ad",domains:["*.moatads.com","*.moatpixel.com"]},{name:"33 Across",homepage:"https://33across.com/",category:"ad",domains:["*.33across.com"]},{name:"OpenX",homepage:"https://www.openx.com/",
category:"ad",domains:["*.deliverimp.com","*.openxadexchange.com","*.servedbyopenx.com","*.jump-time.net","*.openx.net"]},{name:"Amazon Ads",homepage:"https://ad.amazon.com/",category:"ad",domains:["*.amazon-adsystem.com"]},{name:"Rubicon Project",homepage:"https://rubiconproject.com/",category:"ad",domains:["*.rubiconproject.com","*.chango.com","*.fimserve.com"]},{name:"The Trade Desk",homepage:"https://www.thetradedesk.com/",category:"ad",domains:["*.adsrvr.org","d1eoo1tco6rr5e.cloudfront.net"]},{name:"Bidswitch",homepage:"https://www.bidswitch.com/",category:"ad",domains:["*.bidswitch.net"]},{name:"LiveRamp IdentityLink",homepage:"https://liveramp.com/discover-identitylink/",category:"analytics",domains:["*.circulate.com","*.rlcdn.com"]},{name:"Drawbridge",homepage:"https://www.drawbridge.com/",category:"ad",domains:["*.adsymptotic.com"]},{name:"AOL / Oath / Verizon Media",homepage:"https://www.oath.com/",category:"ad",
domains:["*.advertising.com","*.aol.com","*.aolcdn.com","*.blogsmithmedia.com","*.oath.com","*.aol.net","*.tacoda.net","*.aol.co.uk"]},{name:"Xaxis",homepage:"https://www.xaxis.com/",category:"ad",domains:["*.247realmedia.com","*.mookie1.com","*.gmads.net"]},{name:"Freshdesk",company:"Freshworks",homepage:"https://freshdesk.com/",category:"customer-success",domains:["d36mpcpuzc4ztk.cloudfront.net"]},{name:"Help Scout",homepage:"https://www.helpscout.net/",category:"customer-success",domains:["djtflbt20bdde.cloudfront.net","*.helpscout.net"],products:[{name:"Help Scout Beacon",urlPatterns:["beacon-v2.helpscout.net"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}]},{name:"Alexa",homepage:"https://www.alexa.com/",category:"analytics",domains:["*.alexametrics.com","d31qbv1cthcecs.cloudfront.net"]},{name:"OneSignal",homepage:"https://onesignal.com/",category:"utility",domains:["*.onesignal.com"]},{name:"Lucky Orange",
homepage:"https://www.luckyorange.com/",category:"analytics",domains:["*.luckyorange.com","d10lpsik1i8c69.cloudfront.net","*.luckyorange.net"]},{name:"Crazy Egg",homepage:"https://www.crazyegg.com/",category:"analytics",domains:["*.cetrk.com","*.crazyegg.com","*.hellobar.com","dnn506yrbagrg.cloudfront.net"]},{name:"Yandex Ads",company:"Yandex",homepage:"https://yandex.com/adv/",category:"ad",domains:["an.yandex.ru"]},{name:"Salesforce",homepage:"https://www.salesforce.com/products/marketing-cloud/",category:"analytics",domains:["*.krxd.net"]},{name:"Salesforce Commerce Cloud",homepage:"https://www.salesforce.com/products/commerce-cloud/overview/",category:"hosting",domains:["*.cquotient.com","*.demandware.net","demandware.edgesuite.net"]},{name:"Optimizely",homepage:"https://www.optimizely.com/",category:"analytics",domains:["*.optimizely.com"]},{name:"LiveChat",homepage:"https://www.livechat.com/",category:"customer-success",
domains:["*.livechatinc.com","*.livechat.com","*.livechat-static.com"]},{name:"VK",homepage:"https://vk.com/",category:"social",domains:["*.vk.com"]},{name:"Tumblr",homepage:"https://tumblr.com/",category:"social",domains:["*.tumblr.com"]},{name:"Wistia",homepage:"https://wistia.com/",category:"video",domains:["*.wistia.com","embedwistia-a.akamaihd.net","*.wistia.net"]},{name:"Brightcove",homepage:"https://www.brightcove.com/en/",category:"video",domains:["*.brightcove.com","*.brightcove.net","*.zencdn.net"]},{name:"JSDelivr CDN",homepage:"https://www.jsdelivr.com/",category:"cdn",domains:["*.jsdelivr.net"]},{name:"Sumo",homepage:"https://sumo.com/",category:"marketing",domains:["*.sumo.com","*.sumome.com","sumo.b-cdn.net"]},{name:"Vimeo",homepage:"https://vimeo.com/",category:"video",domains:["*.vimeo.com","*.vimeocdn.com"],products:[{name:"Vimeo Embedded Player",urlPatterns:["player.vimeo.com/video/"],facades:[{name:"Lite Vimeo",repo:"https://github.com/slightlyoff/lite-vimeo"},{
name:"Lite Vimeo Embed",repo:"https://github.com/luwes/lite-vimeo-embed"}]}]},{name:"Disqus",homepage:"https://disqus.com/",category:"social",domains:["*.disqus.com","*.disquscdn.com"]},{name:"Yandex APIs",company:"Yandex",homepage:"https://yandex.ru/",category:"utility",domains:["api-maps.yandex.ru","money.yandex.ru"]},{name:"Yandex CDN",company:"Yandex",homepage:"https://yandex.ru/",category:"cdn",domains:["*.yandex.st","*.yastatic.net"]},{name:"Integral Ad Science",homepage:"https://integralads.com/uk/",category:"ad",domains:["*.adsafeprotected.com","*.iasds01.com"]},{name:"Tealium",homepage:"https://tealium.com/",category:"tag-manager",domains:["*.aniview.com","*.delvenetworks.com","*.limelight.com","*.tiqcdn.com","*.llnwd.net","*.tealiumiq.com"]},{name:"Pubmatic",homepage:"https://pubmatic.com/",category:"ad",domains:["*.pubmatic.com"]},{name:"Olark",homepage:"https://www.olark.com/",category:"customer-success",domains:["*.olark.com"]},{name:"Tawk.to",
homepage:"https://www.tawk.to/",category:"customer-success",domains:["*.tawk.to"]},{name:"OptinMonster",homepage:"https://optinmonster.com/",category:"marketing",domains:["*.opmnstr.com","*.optmnstr.com","*.optmstr.com"]},{name:"ZenDesk",homepage:"https://zendesk.com/",category:"customer-success",domains:["*.zdassets.com","*.zendesk.com","*.zopim.com"]},{name:"Pusher",homepage:"https://pusher.com/",category:"utility",domains:["*.pusher.com","*.pusherapp.com"]},{name:"Drift",homepage:"https://www.drift.com/",category:"marketing",domains:["*.drift.com","*.driftt.com"],products:[{name:"Drift Live Chat",urlPatterns:["REGEXP:js\\.driftt\\.com\\/include\\/.*\\/.*\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}]},{name:"Sentry",homepage:"https://sentry.io/",category:"utility",domains:["*.getsentry.com","*.ravenjs.com","*.sentry-cdn.com","*.sentry.io"]},{name:"Amazon Web Services",homepage:"https://aws.amazon.com/s3/",
category:"other",domains:["*.amazon.com","*.amazonaws.com","*.amazonwebapps.com","*.amazonwebservices.com","*.elasticbeanstalk.com","*.images-amazon.com","*.amazon.co.uk"]},{name:"Amazon Pay",homepage:"https://pay.amazon.com",category:"utility",domains:["payments.amazon.com","*.payments-amazon.com"]},{name:"Media.net",homepage:"https://www.media.net/",category:"ad",domains:["*.media.net","*.mnet-ad.net"]},{name:"Yahoo!",homepage:"https://www.yahoo.com/",category:"ad",domains:["*.bluelithium.com","*.hostingprod.com","*.lexity.com","*.yahoo.com","*.yahooapis.com","*.yimg.com","*.zenfs.com","*.yahoo.net"]},{name:"Adroll",homepage:"https://www.adroll.com/",category:"ad",domains:["*.adroll.com"]},{name:"Twitch",homepage:"https://twitch.tv/",category:"video",domains:["*.twitch.tv"]},{name:"Taboola",homepage:"https://www.taboola.com/",category:"ad",domains:["*.taboola.com","*.taboolasyndication.com"]},{name:"Sizmek",homepage:"https://www.sizmek.com/",category:"ad",
domains:["*.serving-sys.com","*.peer39.net"]},{name:"Scorecard Research",homepage:"https://www.scorecardresearch.com/",category:"ad",domains:["*.scorecardresearch.com"]},{name:"Criteo",homepage:"https://www.criteo.com/",category:"ad",domains:["*.criteo.com","*.emailretargeting.com","*.criteo.net"]},{name:"Segment",homepage:"https://segment.com/",category:"analytics",domains:["*.segment.com","*.segment.io"]},{name:"ShareThis",homepage:"https://www.sharethis.com/",category:"social",domains:["*.sharethis.com"]},{name:"Distil Networks",homepage:"https://www.distilnetworks.com/",category:"utility",domains:["*.areyouahuman.com"]},{name:"Connexity",homepage:"https://connexity.com/",category:"analytics",domains:["*.connexity.net"]},{name:"Popads",homepage:"https://www.popads.net/",category:"ad",domains:["*.popads.net"]},{name:"CreateJS CDN",homepage:"https://code.createjs.com/",category:"cdn",domains:["*.createjs.com"]},{name:"Squarespace",homepage:"https://www.squarespace.com/",
category:"hosting",domains:["*.squarespace.com"]},{name:"Media Math",homepage:"https://www.mediamath.com/",category:"ad",domains:["*.mathads.com","*.mathtag.com"]},{name:"Mixpanel",homepage:"https://mixpanel.com/",category:"analytics",domains:["*.mixpanel.com","*.mxpnl.com"]},{name:"FontAwesome CDN",homepage:"https://fontawesome.com/",category:"cdn",domains:["*.fontawesome.com"]},{name:"Hubspot",homepage:"https://hubspot.com/",category:"marketing",domains:["*.hs-scripts.com","*.hubspot.com","*.leadin.com","*.hs-analytics.net","*.hscollectedforms.net","*.hscta.net","*.hsforms.net","*.hsleadflows.net","*.hsstatic.net","*.hubspot.net","*.hsforms.com","*.hs-banner.com","*.hs-embed-reporting.com","*.hs-growth-metrics.com","*.hs-data.com","*.hsadspixel.net"]},{name:"Mailchimp",homepage:"https://mailchimp.com/",category:"marketing",domains:["*.chimpstatic.com","*.list-manage.com","*.mailchimp.com"]},{name:"MGID",homepage:"https://www.mgid.com/",category:"ad",
domains:["*.mgid.com","*.dt07.net"]},{name:"Stripe",homepage:"https://stripe.com",category:"utility",domains:["*.stripe.com","*.stripecdn.com","*.stripe.network"]},{name:"PayPal",homepage:"https://paypal.com",category:"utility",domains:["*.paypal.com","*.paypalobjects.com"]},{name:"Market GID",homepage:"https://www.marketgid.com/",category:"ad",domains:["*.marketgid.com"]},{name:"Pinterest",homepage:"https://pinterest.com/",category:"social",domains:["*.pinimg.com","*.pinterest.com"]},{name:"New Relic",homepage:"https://newrelic.com/",category:"utility",domains:["*.newrelic.com","*.nr-data.net"]},{name:"AppDynamics",homepage:"https://www.appdynamics.com/",category:"utility",domains:["*.appdynamics.com","*.eum-appdynamics.com","d3tjaysgumg9lf.cloudfront.net"]},{name:"Parking Crew",homepage:"https://parkingcrew.net/",category:"other",domains:["d1lxhc4jvstzrp.cloudfront.net","*.parkingcrew.net"]},{name:"WordAds",company:"Automattic",homepage:"https://wordads.co/",category:"ad",
domains:["*.pubmine.com"]},{name:"AppNexus",homepage:"https://www.appnexus.com/",category:"ad",domains:["*.adnxs.com","*.ctasnet.com","*.adrdgt.com"]},{name:"Histats",homepage:"https://www.histats.com/",category:"analytics",domains:["*.histats.com"]},{name:"DoubleVerify",homepage:"https://www.doubleverify.com/",category:"ad",domains:["*.doubleverify.com","*.dvtps.com","*.iqfp1.com"]},{name:"Mediavine",homepage:"https://www.mediavine.com/",category:"ad",domains:["*.mediavine.com"]},{name:"Wix",homepage:"https://www.wix.com/",category:"hosting",domains:["*.parastorage.com","*.wix.com","*.wixstatic.com","*.wixapps.net"]},{name:"Webflow",homepage:"https://webflow.com/",category:"hosting",domains:["*.uploads-ssl.webflow.com","*.assets-global.website-files.com","*.assets.website-files.com"]},{name:"Weebly",homepage:"https://www.weebly.com/",category:"hosting",domains:["*.editmysite.com"]},{name:"LinkedIn",homepage:"https://www.linkedin.com/",category:"social",
domains:["*.bizographics.com","platform.linkedin.com","*.slideshare.com","*.slidesharecdn.com"]},{name:"LinkedIn Ads",category:"ad",domains:["*.licdn.com","*.ads.linkedin.com","ads.linkedin.com","www.linkedin.com"]},{name:"Vox Media",homepage:"https://www.voxmedia.com/",category:"content",domains:["*.vox-cdn.com","*.voxmedia.com"]},{name:"Hotmart",homepage:"https://www.hotmart.com/",category:"content",domains:["*.hotmart.com"]},{name:"SoundCloud",homepage:"https://www.soundcloud.com/",category:"content",domains:["*.sndcdn.com","*.soundcloud.com","*.stratus.sc"]},{name:"Spotify",homepage:"https://www.spotify.com/",category:"content",domains:["*.scdn.co","*.spotify.com"]},{name:"AMP",homepage:"https://amp.dev/",category:"content",domains:["*.ampproject.org"]},{name:"Beeketing",homepage:"https://beeketing.com/",category:"marketing",domains:["*.beeketing.com"]},{name:"Albacross",homepage:"https://albacross.com/",category:"marketing",domains:["*.albacross.com"]},{name:"TrafficJunky",
homepage:"https://www.trafficjunky.com/",category:"ad",domains:["*.contentabc.com","*.trafficjunky.net"]},{name:"Bootstrap CDN",homepage:"https://www.bootstrapcdn.com/",category:"cdn",domains:["*.bootstrapcdn.com"]},{name:"Shareaholic",homepage:"https://www.shareaholic.com/",category:"social",domains:["*.shareaholic.com","dsms0mj1bbhn4.cloudfront.net"]},{name:"Snowplow",homepage:"https://snowplowanalytics.com/",category:"analytics",domains:["d32hwlnfiv2gyn.cloudfront.net"]},{name:"RD Station",homepage:"https://www.rdstation.com/en/",category:"marketing",domains:["d335luupugsy2.cloudfront.net"]},{name:"Jivochat",homepage:"https://www.jivochat.com/",category:"customer-success",domains:["*.jivosite.com"]},{name:"Listrak",homepage:"https://www.listrak.com/",category:"marketing",domains:["*.listrak.com","*.listrakbi.com"]},{name:"Ontame",homepage:"https://www.ontame.io",category:"analytics",domains:["*.ontame.io"]},{name:"Ipify",homepage:"https://www.ipify.org",category:"utility",
domains:["*.ipify.org"]},{name:"Ensighten",homepage:"https://www.ensighten.com/",category:"tag-manager",domains:["*.ensighten.com"]},{name:"EpiServer",homepage:"https://www.episerver.com",category:"content",domains:["*.episerver.net"]},{name:"mPulse",homepage:"https://developer.akamai.com/akamai-mpulse",category:"analytics",domains:["*.akstat.io","*.go-mpulse.net","*.mpulse.net","*.mpstat.us"]},{name:"Pingdom RUM",homepage:"https://www.pingdom.com/product/performance-monitoring/",category:"analytics",domains:["*.pingdom.net"]},{name:"SpeedCurve LUX",company:"SpeedCurve",homepage:"https://speedcurve.com/features/lux/",category:"analytics",domains:["*.speedcurve.com"]},{name:"Radar",company:"Cedexis",homepage:"https://www.cedexis.com/radar/",category:"analytics",
domains:["*.cedexis-test.com","*.cedexis.com","*.cmdolb.com","cedexis.leasewebcdn.com","*.cedexis-radar.net","*.cedexis.net","cedexis-test01.insnw.net","cedexisakamaitest.azureedge.net","cedexispub.cdnetworks.net","cs600.wac.alphacdn.net","cs600.wpc.edgecastdns.net","global2.cmdolb.com","img-cedexis.mncdn.com","a-cedexis.msedge.net","zn3vgszfh.fastestcdn.net"]},{name:"Byside",homepage:"https://byside.com",category:"analytics",domains:["*.byside.com"]},{name:"VWO",homepage:"https://vwo.com",category:"analytics",domains:["*.vwo.com","*.visualwebsiteoptimizer.com","d5phz18u4wuww.cloudfront.net","*.wingify.com"]},{name:"Bing Ads",homepage:"https://bingads.microsoft.com",category:"ad",domains:["*.bing.com","*.microsoft.com","*.msn.com","*.s-msft.com","*.s-msn.com","*.msads.net","*.msecnd.net"]},{name:"GoSquared",homepage:"https://www.gosquared.com",category:"analytics",domains:["*.gosquared.com","d1l6p2sc9645hc.cloudfront.net"]},{name:"Usabilla",homepage:"https://usabilla.com",
category:"analytics",domains:["*.usabilla.com","d6tizftlrpuof.cloudfront.net"]},{name:"Fastly Insights",homepage:"https://insights.fastlylabs.com",category:"analytics",domains:["*.fastly-insights.com"]},{name:"Visual IQ",homepage:"https://www.visualiq.com",category:"analytics",domains:["*.myvisualiq.net"]},{name:"Snapchat",homepage:"https://www.snapchat.com",category:"analytics",domains:["*.snapchat.com","*.sc-static.net"]},{name:"Atlas Solutions",homepage:"https://atlassolutions.com",category:"analytics",domains:["*.atdmt.com"]},{name:"Quantcast",homepage:"https://www.quantcast.com",category:"analytics",domains:["*.brtstats.com","*.quantcount.com","*.quantserve.com","*.semantictec.com","*.ntv.io"]},{name:"Spiceworks",homepage:"https://www.spiceworks.com",category:"analytics",domains:["*.spiceworks.com"]},{name:"Marketo",homepage:"https://www.marketo.com",category:"analytics",domains:["*.marketo.com","*.mktoresp.com","*.marketo.net"]},{name:"Intercom",
homepage:"https://www.intercom.com",category:"customer-success",domains:["*.intercomcdn.com","*.intercom.io"],products:[{name:"Intercom Widget",urlPatterns:["widget.intercom.io","js.intercomcdn.com/shim.latest.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"},{name:"Intercom Facade",repo:"https://github.com/danielbachhuber/intercom-facade/"}]}]},{name:"Unpkg",homepage:"https://unpkg.com",category:"cdn",domains:["*.unpkg.com","*.npmcdn.com"]},{name:"ReadSpeaker",homepage:"https://www.readspeaker.com",category:"other",domains:["*.readspeaker.com"]},{name:"Browsealoud",homepage:"https://www.texthelp.com/en-gb/products/browsealoud/",category:"other",domains:["*.browsealoud.com","*.texthelp.com"]},{name:"15gifts",category:"customer-success",domains:["*.15gifts.com","*.primefuse.com"]},{name:"1xRUN",category:"utility",domains:["*.1xrun.com"]},{name:"2AdPro Media Solutions",category:"ad",domains:["*.2adpro.com"]},{
name:"301 Digital Media",category:"content",domains:["*.301ads.com","*.301network.com"]},{name:"360 picnic platform",company:"MediaV",category:"ad",domains:["*.mediav.com"]},{name:"365 Media Group",category:"content",domains:["*.365dm.com"]},{name:"365 Tech Services",category:"hosting",domains:["*.365webservices.co.uk"]},{name:"3D Issue",category:"utility",domains:["*.3dissue.com","*.pressjack.com"]},{name:"47Line Technologies",category:"other",domains:["*.pejs.net"]},{name:"4finance",category:"utility",domains:["*.4finance.com"]},{name:"5miles",category:"content",domains:["*.5milesapp.com"]},{name:"77Tool",company:"77Agency",category:"analytics",domains:["*.77tracking.com"]},{name:"9xb",category:"ad",domains:["*.9xb.com"]},{name:"@UK",category:"hosting",domains:["*.uk-plc.net"]},{name:"A Perfect Pocket",category:"hosting",domains:["*.aperfectpocketdata.com"]},{name:"A-FIS PTE",category:"analytics",domains:["*.websta.me"]},{name:"AB Tasty",category:"analytics",
domains:["*.abtasty.com","d1447tq2m68ekg.cloudfront.net"]},{name:"ABA RESEARCH",category:"analytics",domains:["*.abaresearch.uk","qmodal.azurewebsites.net"]},{name:"ADMIZED",category:"ad",domains:["*.admized.com"]},{name:"ADNOLOGIES",category:"ad",domains:["*.heias.com"]},{name:"ADventori",category:"ad",domains:["*.adventori.com"]},{name:"AI Media Group",category:"ad",domains:["*.aimediagroup.com"]},{name:"AIR.TV",category:"ad",domains:["*.air.tv"]},{name:"AKQA",category:"ad",domains:["*.srtk.net"]},{name:"AOL ad",company:"AOL",category:"ad",domains:["*.atwola.com"]},{name:"AOL On",company:"AOL",category:"content",domains:["*.5min.com"]},{name:"AOL Sponsored Listiings",company:"AOL",category:"ad",domains:["*.adsonar.com"]},{name:"APSIS Lead",company:"APSIS International AB",category:"ad",domains:["*.prospecteye.com"]},{name:"APSIS Profile Cloud",company:"APSIS",category:"analytics",domains:["*.innomdc.com"]},{name:"APSIS Forms",company:"APSIS",category:"other",
domains:["*.apsisforms.com"]},{name:"ARENA",company:"Altitude",category:"ad",domains:["*.altitude-arena.com"]},{name:"ARM",category:"analytics",domains:["*.tag4arm.com"]},{name:"ASAPP",category:"other",domains:["*.asapp.com"]},{name:"ASP",category:"hosting",domains:["*.goshowoff.com"]},{name:"AT Internet",category:"analytics",domains:["*.ati-host.net"]},{name:"ATTRAQT",category:"utility",domains:["*.attraqt.com","*.locayta.com"]},{name:"AVANSER",category:"analytics",domains:["*.avanser.com.au"]},{name:"AVG",company:"AVG Technologies",category:"utility",domains:["*.avg.com"]},{name:"AWeber",category:"ad",domains:["*.aweber.com"]},{name:"AXS",category:"content",domains:["*.axs.com"]},{name:"Accentuate",company:"Accentuate Digital",category:"utlity",homepage:"https://www.accentuate.io/",domains:["*.accentuate.io"]},{name:"Accenture",category:"analytics",domains:["*.tmvtp.com"]},{name:"Accord Holdings",category:"ad",domains:["*.agcdn.com"]},{name:"Accordant Media",category:"ad",
domains:["*.a3cloud.net"]},{name:"Account Kit",category:"other",domains:["*.accountkit.com"]},{name:"Accuen Media (Omnicom Media Group)",category:"content",domains:["*.p-td.com"]},{name:"Accuweather",category:"content",domains:["*.accuweather.com"]},{name:"Acquisio",category:"ad",domains:["*.acq.io"]},{name:"Act-On Software",category:"marketing",domains:["*.actonsoftware.com"]},{name:"ActBlue",category:"other",domains:["*.actblue.com"]},{name:"Active Agent",category:"ad",domains:["*.active-agent.com"]},{name:"ActiveCampaign",category:"ad",domains:["*.trackcmp.net","app-us1.com","*.app-us1.com"]},{name:"AcuityAds",category:"ad",domains:["*.acuityplatform.com"]},{name:"Acxiom",category:"ad",domains:["*.acxiom-online.com","*.acxiomapac.com","*.delivery.net"]},{name:"Ad4Screen",category:"ad",domains:["*.a4.tl"]},{name:"Ad6Media",category:"ad",domains:["*.ad6media.fr"]},{name:"AdCurve",category:"ad",domains:["*.shop2market.com"]},{name:"AdEasy",category:"ad",domains:["*.adeasy.ru"]},{
name:"AdExtent",category:"ad",domains:["*.adextent.com"]},{name:"AdForge Edge",company:"AdForge",category:"ad",domains:["*.adforgeinc.com"]},{name:"AdGear",company:"Samsung Electronics",category:"ad",domains:["*.adgear.com","*.adgrx.com"]},{name:"AdInMedia",category:"ad",domains:["*.fastapi.net"]},{name:"AdJug",category:"ad",domains:["*.adjug.com"]},{name:"AdMatic",category:"ad",domains:["*.admatic.com.tr"]},{name:"AdMedia",category:"ad",domains:["*.admedia.com"]},{name:"AdRecover",category:"ad",domains:["*.adrecover.com"]},{name:"AdRiver",category:"ad",domains:["*.adriver.ru"]},{name:"AdSniper",category:"ad",domains:["*.adsniper.ru","*.sniperlog.ru"]},{name:"AdSpeed",category:"ad",domains:["*.adspeed.net"]},{name:"AdSpruce",category:"ad",domains:["*.adspruce.com"]},{name:"AdSupply",category:"ad",domains:["*.doublepimp.com"]},{name:"AdTheorent",category:"ad",domains:["*.adentifi.com"]},{name:"AdThink AudienceInsights",company:"AdThink Media",category:"analytics",
domains:["*.audienceinsights.net"]},{name:"AdTrue",company:"FPT AdTrue",category:"ad",domains:["*.adtrue.com"]},{name:"AdYapper",category:"ad",domains:["*.adyapper.com"]},{name:"Adacado",category:"ad",domains:["*.adacado.com"]},{name:"Adap.tv",category:"ad",domains:["*.adap.tv"]},{name:"Adapt Services",category:"hosting",domains:["*.adcmps.com"]},{name:"Adaptive Web",category:"hosting",domains:["*.adaptive.co.uk"]},{name:"Adara Media",category:"ad",domains:["*.yieldoptimizer.com"]},{name:"Adblade",category:"ad",domains:["*.adblade.com"]},{name:"Adbrain",category:"ad",domains:["*.adbrn.com"]},{name:"AddEvent",category:"utility",domains:["*.addevent.com"]},{name:"AddShoppers",category:"social",domains:["*.addshoppers.com","d3rr3d0n31t48m.cloudfront.net","*.shop.pe"]},{name:"AddThisEvent",category:"hosting",domains:["*.addthisevent.com"]},{name:"Addoox MetaNetwork",company:"Addoox",category:"ad",domains:["*.metanetwork.net"]},{name:"Addvantage Media",category:"ad",
domains:["*.addvantagemedia.com","*.simplytechnology.net"]},{name:"AD EBis",category:"analytics",homepage:"https://www.ebis.ne.jp/",domains:["*.ebis.ne.jp"]},{name:"Adecs",category:"customer-success",domains:["*.adecs.co.uk"]},{name:"Adelphic",category:"ad",domains:["*.ipredictive.com"]},{name:"Adestra",category:"ad",domains:["*.adestra.com","*.msgfocus.com"]},{name:"Adform",category:"ad",domains:["*.adform.net","*.adformdsp.net"]},{name:"Adkontekst",category:"ad",domains:["*.adkontekst.pl"]},{name:"Adlead",category:"ad",domains:["*.webelapp.com"]},{name:"Adledge",category:"utility",domains:["*.adledge.com"]},{name:"Adloox",category:"ad",domains:["*.adlooxtracking.com"]},{name:"Adlux",category:"ad",domains:["*.adlux.com"]},{name:"Admedo",category:"ad",domains:["*.a8723.com","*.adizio.com","*.admedo.com"]},{name:"Admeta",company:"Wideorbit",category:"ad",domains:["*.atemda.com"]},{name:"Admetrics",company:"Next Tuesday",category:"analytics",domains:["*.nt.vc"]},{name:"Admiral",
category:"ad",domains:["*.unknowntray.com"]},{name:"Admitad",category:"ad",domains:["*.lenmit.com"]},{name:"Admixer for Publishers",company:"Admixer",category:"ad",domains:["*.admixer.net"]},{name:"Adnium",category:"ad",domains:["*.adnium.com"]},{name:"Adnostic",company:"Dennis Publishing",category:"ad",domains:["*.adnostic.co.uk"]},{name:"Adobe Marketing Cloud",company:"Adobe Systems",category:"ad",domains:["*.adobetag.com"]},{name:"Adobe Scene7",company:"Adobe Systems",category:"content",domains:["wwwimages.adobe.com","*.scene7.com","*.everestads.net","*.everestjs.net"]},{name:"Adobe Systems",category:"content",domains:["adobe.com","www.adobe.com"]},{name:"Adobe Business Catalyst",homepage:"https://www.businesscatalyst.com/",category:"hosting",domains:["*.businesscatalyst.com"]},{name:"Adocean",company:"Gemius",category:"ad",domains:["*.adocean.pl"]},{name:"Adometry",company:"Google",category:"ad",domains:["*.dmtry.com"]},{name:"Adomik",category:"analytics",domains:["*.adomik.com"]
},{name:"Adotmob",category:"ad",domains:["*.adotmob.com"]},{name:"Adrian Quevedo",category:"hosting",domains:["*.adrianquevedo.com"]},{name:"Adroit Digital Solutions",category:"ad",domains:["*.imiclk.com","*.abmr.net"]},{name:"AdsNative",category:"ad",domains:["*.adsnative.com"]},{name:"AdsWizz",category:"ad",domains:["*.adswizz.com"]},{name:"Adscale",category:"ad",domains:["*.adscale.de"]},{name:"Adschoom",company:"JSWeb Production",category:"ad",domains:["*.adschoom.com"]},{name:"Adscience",category:"ad",domains:["*.adscience.nl"]},{name:"Adsiduous",category:"ad",domains:["*.adsiduous.com"]},{name:"Adsty",category:"ad",domains:["*.adx1.com"]},{name:"Adtech (AOL)",category:"ad",domains:["*.adtechus.com"]},{name:"Adtegrity",category:"ad",domains:["*.adtpix.com"]},{name:"Adthink",company:"Adthink Media",category:"ad",domains:["*.adxcore.com","*.dcoengine.com"]},{name:"AdultWebmasterEmpire.Com",category:"ad",domains:["*.awempire.com"]},{name:"Adunity",category:"ad",
domains:["*.adunity.com"]},{name:"Advance Magazine Group",category:"content",domains:["*.condenastdigital.com","*.condenet.com","*.condenast.co.uk"]},{name:"Adverline Board",company:"Adverline",category:"ad",domains:["*.adverline.com","*.adnext.fr"]},{name:"AdvertServe",category:"ad",domains:["*.advertserve.com"]},{name:"Advolution",category:"utility",domains:["*.advolution.de"]},{name:"Adwise",category:"ad",domains:["*.adwise.bg"]},{name:"Adyen",category:"utility",domains:["*.adyen.com"]},{name:"Adyoulike",category:"ad",domains:["*.adyoulike.com","*.omnitagjs.com","*.adyoulike.net"]},{name:"Adzerk",category:"ad",domains:["*.adzerk.net"]},{name:"Adzip",company:"Adbox Digital",category:"ad",domains:["*.adzip.co"]},{name:"AerServ",category:"ad",domains:["*.aerserv.com"]},{name:"Affectv",category:"ad",domains:["*.affectv.com","*.affec.tv"]},{name:"Affiliate Window",company:"Digital Window",category:"ad",domains:["*.dwin1.com"]},{name:"Affiliatly",category:"ad",domains:["*.affiliatly.com"]
},{name:"Affino",category:"ad",domains:["affino.com"]},{name:"Affirm",category:"utility",domains:["*.affirm.com"]},{name:"Afterpay",company:"Block",category:"utlity",homepage:"https://www.afterpay.com/",domains:["*.afterpay.com"]},{name:"Agenda Media",category:"ad",domains:["*.agendamedia.co.uk"]},{name:"Aggregate Knowledge",company:"Neustar",category:"ad",domains:["*.agkn.com"]},{name:"AgilOne",category:"marketing",domains:["*.agilone.com"]},{name:"Agility",category:"hosting",domains:["*.agilitycms.com"]},{name:"Ahalogy",category:"social",domains:["*.ahalogy.com"]},{name:"Aheadworks",category:"utility",domains:["*.aheadworks.com"]},{name:"AirPR",category:"analytics",domains:["*.airpr.com"]},{name:"Aira",category:"ad",domains:["*.aira.net"]},{name:"Airport Parking and Hotels",category:"content",domains:["*.aph.com"]},{name:"Akanoo",category:"analytics",domains:["*.akanoo.com"]},{name:"Alchemy",company:"AndBeyond.Media",category:"ad",domains:["*.andbeyond.media"]},{name:"AlephD",
company:"AOL",category:"ad",domains:["*.alephd.com"]},{name:"AliveChat",company:"AYU Technology Solutions",category:"customer-success",domains:["*.websitealive.com","*.websitealive7.com"]},{name:"All Access",category:"other",domains:["*.allaccess.com.ph"]},{name:"Alliance for Audited Media",category:"ad",domains:["*.aamsitecertifier.com"]},{name:"Allyde",category:"marketing",domains:["*.mautic.com"]},{name:"AlphaSSL",category:"utility",domains:["*.alphassl.com"]},{name:"Altitude",category:"ad",domains:["*.altitudeplatform.com"]},{name:"Altocloud",category:"analytics",domains:["*.altocloud.com"]},{name:"Amadeus",category:"content",domains:["*.e-travel.com"]},{name:"Amazon CloudFront",company:"Amazon",category:"utility",domains:["cloudfront.net"]},{name:"Ambassador",category:"ad",domains:["*.getambassador.com"]},{name:"Ambient",company:"Ericcson",category:"other",domains:["*.adnetwork.vn","*.ambientplatform.vn"]},{name:"Amelia Communication",category:"hosting",domains:["*.sara.media"]},{
name:"Amobee",category:"marketing",domains:["*.amgdgt.com","*.kontera.com"]},{name:"Amplience",category:"marketing",domains:["*.10cms.com","*.amplience.com","*.amplience.net","*.bigcontent.io","*.adis.ws"]},{name:"Amplitude Mobile Analytics",company:"Amplitude",category:"analytics",domains:["*.amplitude.com","d24n15hnbwhuhn.cloudfront.net"]},{name:"Anametrix",company:"Ensighten",category:"analytics",domains:["*.anametrix.com"]},{name:"Ancora Platform",company:"Ancora Media Solutions",category:"ad",domains:["*.ancoraplatform.com"]},{name:"Anedot",category:"other",domains:["*.anedot.com"]},{name:"AnimateJS",category:"utility",domains:["*.animatedjs.com"]},{name:"AnswerDash",category:"customer-success",domains:["*.answerdash.com"]},{name:"Answers",category:"analytics",domains:["*.answcdn.com","*.answers.com","*.dsply.com"]},{name:"Apester",category:"analytics",domains:["*.apester.com","*.qmerce.com"]},{name:"Apligraf SmartWeb",company:"Apligraf",category:"utility",
domains:["*.apligraf.com.br"]},{name:"Appier",category:"ad",domains:["*.appier.net"]},{name:"Appsolute",category:"utility",homepage:"https://appsolute.us/",domains:["dropahint.love"]},{name:"Apptus eSales",company:"Apptus",category:"analytics",domains:["*.apptus.com"]},{name:"Arbor",company:"LiveRamp",category:"other",domains:["*.pippio.com"]},{name:"Ardent Creative",category:"hosting",domains:["*.ardentcreative.co.uk"]},{name:"Arnold Clark Automobiles",category:"content",domains:["*.arnoldclark.com"]},{name:"Atom Content Marketing",category:"content",domains:["*.atomvault.net"]},{name:"Atom Data",category:"other",domains:["*.atomdata.io"]},{name:"Attribution",category:"ad",domains:["*.attributionapp.com"]},{name:"Audience 360",company:"Datapoint Media",category:"ad",domains:["*.dpmsrv.com"]},{name:"Audience Science",category:"ad",domains:["*.revsci.net"]},{name:"AudienceSearch",company:"Intimate Merger",category:"ad",domains:["*.im-apps.net"]},{name:"Auditorius",category:"ad",
domains:["*.audtd.com"]},{name:"Augur",category:"analytics",domains:["*.augur.io"]},{name:"Auto Link Maker",company:"Apple",category:"ad",domains:["*.apple.com"]},{name:"Autopilot",category:"ad",domains:["*.autopilothq.com"]},{name:"Avail",company:"RichRelevance",category:"ad",domains:["*.avail.net"]},{name:"AvantLink",category:"ad",domains:["*.avmws.com"]},{name:"Avco Systems",category:"utility",domains:["*.avcosystems.com"]},{name:"Avid Media",category:"customer-success",domains:["*.adspdbl.com","*.metadsp.co.uk"]},{name:"Avocet Systems",category:"ad",domains:["*.avocet.io","ads.avct.cloud"]},{name:"Avora",category:"analytics",domains:["*.truedash.com"]},{name:"Azure Traffic Manager",company:"Microsoft",category:"other",domains:["*.gateway.net","*.trafficmanager.net"]},{name:"Azure Web Services",company:"Microsoft",category:"cdn",domains:["*.azurewebsites.net","*.azureedge.net","*.msedge.net","*.windows.net"]},{name:"BAM",category:"analytics",domains:["*.bam-x.com"]},{
name:"Baifendian Technology",category:"marketing",domains:["*.baifendian.com"]},{name:"Bankrate",category:"utility",domains:["*.bankrate.com"]},{name:"BannerFlow",company:"Nordic Factory Solutions",category:"ad",domains:["*.bannerflow.com"]},{name:"Barclaycard SmartPay",company:"Barclaycard",category:"utility",domains:["*.barclaycardsmartpay.com"]},{name:"Barilliance",category:"analytics",domains:["*.barilliance.net","dn3y71tq7jf07.cloudfront.net"]},{name:"Barnebys",category:"other",domains:["*.barnebys.com"]},{name:"Basis",company:"Basis Technologies",category:"ad",homepage:"https://basis.net/",domains:["*.basis.net"]},{name:"Batch Media",category:"ad",domains:["*.t4ft.de"]},{name:"Bauer Consumer Media",category:"content",domains:["*.bauercdn.com","*.greatmagazines.co.uk"]},{name:"Baynote",category:"analytics",domains:["*.baynote.net"]},{name:"Bazaarvoice",category:"analytics",domains:["*.bazaarvoice.com","*.feedmagnet.com"]},{name:"Beachfront Media",category:"ad",
domains:["*.bfmio.com"]},{name:"BeamPulse",category:"analytics",domains:["*.beampulse.com"]},{name:"Beeswax",category:"ad",domains:["*.bidr.io"]},{name:"Beetailer",category:"social",domains:["*.beetailer.com"]},{name:"Best Of Media S.A.",category:"content",domains:["*.servebom.com"]},{name:"Bet365",category:"ad",domains:["*.bet365affiliates.com"]},{name:"Betfair",category:"other",domains:["*.cdnbf.net"]},{name:"Betgenius",company:"Genius Sports",category:"content",domains:["*.connextra.com"]},{name:"Better Banners",category:"ad",domains:["*.betterbannerscloud.com"]},{name:"Better Business Bureau",category:"analytics",domains:["*.bbb.org"]},{name:"Between Digital",category:"ad",domains:["*.betweendigital.com"]},{name:"BidTheatre",category:"ad",domains:["*.bidtheatre.com"]},{name:"Bidtellect",category:"ad",domains:["*.bttrack.com"]},{name:"Bigcommerce",category:"marketing",domains:["*.bigcommerce.com"]},{name:"BitGravity",company:"Tata Communications",category:"content",
domains:["*.bitgravity.com"]},{name:"Bitly",category:"utility",domains:["*.bitly.com","*.lemde.fr","*.bit.ly"]},{name:"Bizible",category:"ad",domains:["*.bizible.com","*.bizibly.com"]},{name:"Bizrate",category:"analytics",domains:["*.bizrate.com"]},{name:"BlastCasta",category:"social",domains:["*.poweringnews.com"]},{name:"Blindado",category:"utility",domains:["*.siteblindado.com"]},{name:"Blis",category:"ad",domains:["*.blismedia.com"]},{name:"Blogg.se",category:"hosting",domains:["*.cdnme.se","*.publishme.se"]},{name:"BloomReach",category:"ad",domains:["*.brcdn.com","*.brsrvr.com","*.brsvr.com"]},{name:"Bloomberg",category:"content",domains:["*.gotraffic.net"]},{name:"Shop Logic",company:"BloomReach",category:"marketing",domains:["*.goshoplogic.com"]},{name:"Blue State Digital",category:"ad",domains:["*.bsd.net"]},{name:"Blue Triangle Technologies",category:"analytics",domains:["*.btttag.com"]},{name:"BlueCava",category:"ad",domains:["*.bluecava.com"]},{name:"BlueKai",
company:"Oracle",category:"ad",domains:["*.bkrtx.com","*.bluekai.com"]},{name:"Bluecore",category:"analytics",domains:["*.bluecore.com"]},{name:"Bluegg",category:"hosting",domains:["d1va5oqn59yrvt.cloudfront.net"]},{name:"Bold Commerce",category:"utility",domains:["*.shappify-cdn.com","*.shappify.com","*.boldapps.net"]},{name:"BoldChat",company:"LogMeIn",category:"customer-success",domains:["*.boldchat.com"]},{name:"Bombora",category:"ad",domains:["*.mlno6.com"]},{name:"Bonnier",category:"content",domains:["*.bonniercorp.com"]},{name:"Bookatable",category:"content",domains:["*.bookatable.com","*.livebookings.com"]},{name:"Booking.com",category:"content",domains:["*.bstatic.com"]},{name:"Boomtrain",category:"ad",domains:["*.boomtrain.com","*.boomtrain.net"]},{name:"BoostSuite",category:"ad",domains:["*.poweredbyeden.com"]},{name:"Boostable",category:"ad",domains:["*.boostable.com"]},{name:"Bootstrap Chinese network",category:"cdn",domains:["*.bootcss.com"]},{name:"Booxscale",
category:"ad",domains:["*.booxscale.com"]},{name:"Borderfree",company:"pitney bowes",category:"utility",domains:["*.borderfree.com","*.fiftyone.com"]},{name:"BowNow",category:"analytics",homepage:"https://bow-now.jp/",domains:["*.bownow.jp"]},{name:"Box",category:"hosting",domains:["*.box.com"]},{name:"Boxever",category:"analytics",domains:["*.boxever.com"]},{name:"Braintree Payments",company:"Paypal",category:"utility",domains:["*.braintreegateway.com"]},{name:"Branch Metrics",category:"ad",domains:["*.branch.io","*.app.link"]},{name:"Brand Finance",category:"other",domains:["*.brandirectory.com"]},{name:"Brand View",category:"analytics",domains:["*.brandview.com"]},{name:"Brandscreen",category:"ad",domains:["*.rtbidder.net"]},{name:"BridgeTrack",company:"Sapient",category:"ad",domains:["*.bridgetrack.com"]},{name:"BrightRoll",company:"Yahoo!",category:"ad",domains:["*.btrll.com"]},{name:"BrightTag / Signal",company:"Signal",homepage:"https://www.signal.co",category:"tag-manager",
domains:["*.btstatic.com","*.thebrighttag.com"]},{name:"Brightcove ZenCoder",company:"Brightcove",category:"other",domains:["*.zencoder.net"]},{name:"Bronto Software",category:"marketing",domains:["*.bm23.com","*.bronto.com","*.brontops.com"]},{name:"Browser-Update.org",category:"other",domains:["*.browser-update.org"]},{name:"Buffer",category:"social",domains:["*.bufferapp.com"]},{name:"Bugsnag",category:"utility",domains:["*.bugsnag.com","d2wy8f7a9ursnm.cloudfront.net"]},{name:"Burst Media",category:"ad",domains:["*.burstnet.com","*.1rx.io"]},{name:"Burt",category:"analytics",domains:["*.richmetrics.com","*.burt.io"]},{name:"Business Message",category:"ad",domains:["*.message-business.com"]},{name:"Business Week",company:"Bloomberg",category:"social",domains:["*.bwbx.io"]},{name:"Buto",company:"Big Button",category:"ad",domains:["*.buto.tv"]},{name:"Button",category:"ad",domains:["*.btncdn.com"]},{name:"BuySellAds",category:"ad",domains:["*.buysellads.com","*.buysellads.net"]},{
name:"BuySight (AOL)",category:"ad",domains:["*.pulsemgr.com"]},{name:"Buyapowa",category:"ad",domains:["*.co-buying.com"]},{name:"BuzzFeed",category:"social",domains:["*.buzzfed.com"]},{name:"C1X",category:"ad",domains:["*.c1exchange.com"]},{name:"C3 Metrics",category:"analytics",domains:["*.c3tag.com"]},{name:"CANDDi",company:"Campaign and Digital Intelligence",category:"ad",domains:["*.canddi.com"]},{name:"CCM benchmark Group",category:"social",domains:["*.ccm2.net"]},{name:"CD Networks",category:"utility",domains:["*.gccdn.net"]},{name:"CDN Planet",category:"analytics",domains:["*.cdnplanet.com"]},{name:"InAuth",category:"utility",homepage:"https://www.inauth.com/",domains:["*.cdn-net.com"]},{name:"CJ Affiliate",company:"Conversant",category:"ad",domains:["*.cj.com","*.dpbolvw.net"]},{name:"CJ Affiliate by Conversant",company:"Conversant",category:"ad",domains:["*.ftjcfx.com"]},{name:"CNBC",category:"content",domains:["*.cnbc.com"]},{name:"CNET Content Solutions",
company:"CBS Interactive",category:"content",domains:["*.cnetcontent.com"]},{name:"CPEx",category:"content",domains:["*.cpex.cz"]},{name:"CPXi",category:"ad",domains:["*.cpxinteractive.com"]},{name:"CUBED Attribution",company:"CUBED",category:"ad",domains:["*.withcubed.com"]},{name:"Cachefly",category:"utility",domains:["*.cachefly.net"]},{name:"Calendly",category:"other",domains:["*.calendly.com"]},{name:"CallRail",category:"analytics",domains:["*.callrail.com"]},{name:"CallTrackingMetrics",category:"analytics",domains:["*.tctm.co"]},{name:"Canned Banners",category:"ad",domains:["*.cannedbanners.com"]},{name:"Canopy Labs",category:"analytics",domains:["*.canopylabs.com"]},{name:"Capita",category:"utility",domains:["*.crcom.co.uk"]},{name:"Captify Media",category:"ad",domains:["*.cpx.to"]},{name:"Captiify",category:"ad",domains:["*.captifymedia.com"]},{name:"Captivate Ai",category:"ad",domains:["*.captivate.ai"]},{name:"Captora",category:"marketing",domains:["*.captora.com"]},{
name:"Carcloud",category:"other",domains:["*.carcloud.co.uk"]},{name:"Cardlytics",category:"ad",domains:["*.cardlytics.com"]},{name:"Cardosa Enterprises",category:"analytics",domains:["*.y-track.com"]},{name:"Caspian Media",category:"ad",domains:["*.caspianmedia.com"]},{name:"Cast",category:"utility",domains:["*.cast.rocks"]},{name:"Catch",category:"other",domains:["*.getcatch.com"]},{name:"Cavisson",category:"analytics",domains:["*.cavisson.com"]},{name:"Cedato",category:"ad",domains:["*.algovid.com","*.vdoserv.com"]},{name:"Celebrus Technologies",category:"analytics",domains:["*.celebrus.com"]},{name:"Celtra",category:"ad",domains:["*.celtra.com"]},{name:"Centro",category:"ad",domains:["*.brand-server.com"]},{name:"Ceros",category:"other",domains:["ceros.com","view.ceros.com"]},{name:"Ceros Analytics",company:"Ceros",category:"analytics",domains:["api.ceros.com"]},{name:"Certona",category:"analytics",domains:["*.certona.net"]},{name:"Certum",category:"utility",
domains:["*.ocsp-certum.com","*.certum.pl"]},{name:"Cgrdirect",category:"other",domains:["*.cgrdirect.co.uk"]},{name:"Channel 5 Media",category:"ad",domains:["*.five.tv"]},{name:"Channel.me",category:"customer-success",domains:["*.channel.me"]},{name:"ChannelAdvisor",category:"ad",domains:["*.channeladvisor.com","*.searchmarketing.com"]},{name:"ChannelApe",company:"ChannelApe",category:"other",homepage:"https://www.channelape.com/",domains:["*.channelape.com"]},{name:"Chargeads Oscar",company:"Chargeads",category:"ad",domains:["*.chargeads.com"]},{name:"Charities Aid Foundation",category:"utility",domains:["*.cafonline.org"]},{name:"Chartbeat",category:"analytics",domains:["*.chartbeat.com","*.chartbeat.net"]},{name:"Cheapflights Media",company:"Momondo",category:"content",domains:["*.momondo.net"]},{name:"CheckM8",category:"ad",domains:["*.checkm8.com"]},{name:"CheckRate",company:"FreeStart",category:"utility",domains:["*.checkrate.co.uk"]},{name:"Checkfront",category:"other",
domains:["*.checkfront.com","dcg3jth5savst.cloudfront.net"]},{name:"CheetahMail",company:"Experian",category:"ad",domains:["*.chtah.com"]},{name:"Chitika",category:"ad",domains:["*.chitika.net"]},{name:"ChoiceStream",category:"ad",domains:["*.choicestream.com"]},{name:"Cint",category:"social",domains:["*.cint.com"]},{name:"Civic",category:"hosting",domains:["*.civiccomputing.com"]},{name:"ClearRise",category:"customer-success",domains:["*.clearrise.com"]},{name:"Clearstream",category:"ad",domains:["*.clrstm.com"]},{name:"Clerk.io ApS",category:"analytics",domains:["*.clerk.io"]},{name:"CleverDATA",category:"ad",domains:["*.1dmp.io"]},{name:"CleverTap",category:"analytics",domains:["d2r1yp2w7bby2u.cloudfront.net"]},{name:"Click Density",category:"analytics",domains:["*.clickdensity.com"]},{name:"Click4Assistance",category:"customer-success",domains:["*.click4assistance.co.uk"]},{name:"ClickDesk",category:"customer-success",domains:["*.clickdesk.com","d1gwclp1pmzk26.cloudfront.net"]},{
name:"ClickDimensions",category:"ad",domains:["*.clickdimensions.com"]},{name:"Clickadu (Winner Solutions)",category:"ad",domains:["*.clickadu.com"]},{name:"Clickagy Audience Lab",company:"Clickagy",category:"ad",domains:["*.clickagy.com"]},{name:"Clickio",category:"ad",domains:[]},{name:"Clicktale",category:"analytics",domains:["*.cdngc.net","*.clicktale.net"]},{name:"Clicktripz",category:"content",domains:["*.clicktripz.com"]},{name:"Clik.com Websites",category:"content",domains:["*.clikpic.com"]},{name:"Cloud Technologies",category:"ad",domains:["*.behavioralengine.com","*.behavioralmailing.com"]},{name:"Cloud-A",category:"other",domains:["*.bulkstorage.ca"]},{name:"Cloud.typography",company:"Hoefler &amp; Co",category:"cdn",domains:["*.typography.com"]},{name:"CloudSponge",category:"ad",domains:["*.cloudsponge.com"]},{name:"CloudVPS",category:"other",domains:["*.adoftheyear.com","*.objectstore.eu"]},{name:"Cloudinary",category:"content",domains:["*.cloudinary.com"]},{
name:"Cloudqp",company:"Cloudwp",category:"other",domains:["*.cloudwp.io"]},{name:"Cludo",category:"utility",domains:["*.cludo.com"]},{name:"Cognesia",category:"marketing",domains:["*.intelli-direct.com"]},{name:"CogoCast",company:"Cogo Labs",category:"ad",domains:["*.cogocast.net"]},{name:"Colbenson",category:"utility",domains:["*.colbenson.com"]},{name:"Collective",category:"ad",domains:["*.collective-media.net"]},{name:"Com Laude",category:"other",domains:["*.gdimg.net"]},{name:"Comm100",category:"customer-success",domains:["*.comm100.com"]},{name:"CommerceHub",category:"marketing",domains:["*.mercent.com"]},{name:"Commission Factory",category:"ad",domains:["*.cfjump.com"]},{name:"Communicator",category:"ad",domains:["*.communicatorcorp.com","*.communicatoremail.com"]},{name:"Comodo",category:"utility",domains:["*.comodo.com","*.trust-provider.com","*.trustlogo.com","*.usertrust.com","*.comodo.net"]},{name:"Comodo Certificate Authority",company:"Comodo",category:"utility",
domains:["crt.comodoca.com","*.comodoca4.com","ocsp.comodoca.com","ocsp.usertrust.com","crt.usertrust.com"]},{name:"Compete",company:"Millwood Brown Digital",category:"analytics",domains:["*.c-col.com","*.compete.com"]},{name:"Compuware",category:"analytics",domains:["*.axf8.net"]},{name:"Conductrics",category:"analytics",domains:["*.conductrics.com"]},{name:"Confirmit",category:"analytics",domains:["*.confirmit.com"]},{name:"Connatix",category:"ad",domains:["*.connatix.com"]},{name:"Connect Events",category:"hosting",domains:["*.connectevents.com.au"]},{name:"Constant Contact",category:"ad",domains:["*.ctctcdn.com"]},{name:"Constructor.io",category:"utility",domains:["*.cnstrc.com"]},{name:"Contabo",category:"hosting",domains:["185.2.100.179"]},{name:"Content Media Corporation",category:"content",domains:["*.contentmedia.eu"]},{name:"ContentSquare",category:"analytics",domains:["d1m6l9dfulcyw7.cloudfront.net","*.content-square.net","*.contentsquare.net"]},{name:"ContextWeb",
category:"ad",domains:["*.contextweb.com"]},{name:"Continental Exchange Solutions",category:"utility",domains:["*.hifx.com"]},{name:"Converge-Digital",category:"ad",domains:["*.converge-digital.com"]},{name:"Conversant",category:"analytics",domains:["*.dotomi.com","*.dtmpub.com","*.emjcd.com","mediaplex.com","*.tqlkg.com","*.fastclick.net"]},{name:"Conversant Ad Server",company:"Conversant",category:"ad",domains:["adfarm.mediaplex.com","*.mediaplex.com"]},{name:"Conversant Tag Manager",company:"Conversant",category:"tag-manager",domains:["*.mplxtms.com"]},{name:"Conversio",category:"ad",domains:["*.conversio.com"]},{name:"Conversion Labs",category:"ad",domains:["*.net.pl"]},{name:"Conversion Logic",category:"ad",domains:["*.conversionlogic.net"]},{name:"Convert Insights",category:"analytics",domains:["*.convertexperiments.com"]},{name:"ConvertMedia",category:"ad",domains:["*.admailtiser.com","*.basebanner.com","*.cmbestsrv.com","*.vidfuture.com","*.zorosrv.com"]},{name:"Convertro",
category:"ad",domains:["*.convertro.com"]},{name:"Conviva",category:"content",domains:["*.conviva.com"]},{name:"Cookie Reports",category:"utility",domains:["*.cookiereports.com"]},{name:"Cookie-Script.com",category:"utility",domains:["*.cookie-script.com"]},{name:"CookieQ",company:"Baycloud Systems",category:"utility",domains:["*.cookieq.com"]},{name:"CoolaData",category:"analytics",domains:["*.cooladata.com"]},{name:"CopperEgg",category:"analytics",domains:["*.copperegg.com","d2vig74li2resi.cloudfront.net"]},{name:"Council ad Network",category:"ad",domains:["*.counciladvertising.net"]},{name:"Covert Pics",category:"content",domains:["*.covet.pics"]},{name:"Cox Digital Solutions",category:"ad",domains:["*.afy11.net"]},{name:"Creafi Online Media",category:"ad",domains:["*.creafi-online-media.com"]},{name:"Creators",category:"content",domains:["*.creators.co"]},{name:"Crimson Hexagon Analytics",company:"Crimson Hexagon",category:"analytics",domains:["*.hexagon-analytics.com"]},{
name:"Crimtan",category:"ad",domains:["*.ctnsnet.com"]},{name:"Cross Pixel Media",category:"ad",domains:["*.crsspxl.com"]},{name:"Crosswise",category:"ad",domains:["*.univide.com"]},{name:"Crowd Control",company:"Lotame",category:"ad",domains:["*.crwdcntrl.net"]},{name:"Crowd Ignite",category:"ad",domains:["*.crowdignite.com"]},{name:"CrowdTwist",category:"ad",domains:["*.crowdtwist.com"]},{name:"Crowdskout",category:"ad",domains:["*.crowdskout.com"]},{name:"Crowdynews",category:"social",domains:["*.breakingburner.com"]},{name:"Curalate",category:"marketing",domains:["*.curalate.com","d116tqlcqfmz3v.cloudfront.net"]},{name:"Customer Acquisition Cloud",company:"[24]7",category:"ad",domains:["*.campanja.com"]},{name:"Customer.io",category:"ad",domains:["*.customer.io"]},{name:"Custora",category:"analytics",domains:["*.custora.com"]},{name:"Cxense",category:"ad",domains:["*.cxense.com","*.cxpublic.com","*.emediate.dk","*.emediate.eu"]},{name:"CyberKnight",company:"Namogoo",
category:"utility",domains:["*.namogoo.com"]},{name:"CyberSource (Visa)",category:"utility",domains:["*.authorize.net"]},{name:"Cybernet Quest",category:"analytics",domains:["*.cqcounter.com"]},{name:"D.A. Consortium",category:"ad",domains:["*.eff1.net"]},{name:"D4t4 Solutions",category:"analytics",domains:["*.u5e.com"]},{name:"DCSL Software",category:"hosting",domains:["*.dcslsoftware.com"]},{name:"DMG Media",category:"content",domains:["*.mol.im","*.and.co.uk","*.anm.co.uk","*.dailymail.co.uk"]},{name:"DTSCOUT",category:"ad",domains:["*.dtscout.com"]},{name:"Dailykarma",category:"utility",homepage:"https://www.dailykarma.com/",domains:["*.dailykarma.io"]},{name:"Dailymotion",category:"content",domains:["*.dailymotion.com","*.dmxleo.com","*.dm.gg","*.pxlad.io","*.dmcdn.net","*.sublimevideo.net"]},{name:"Dash Hudson",company:"Dash Hudson",category:"content",domains:["*.dashhudson.com"]},{name:"Datacamp",category:"utility",domains:["*.cdn77.org"]},{name:"Datalicious",
category:"tag-manager",domains:["*.supert.ag","*.optimahub.com"]},{name:"Datalogix",category:"ad",domains:["*.nexac.com"]},{name:"Datawrapper",category:"utility",domains:["*.datawrapper.de","*.dwcdn.net"]},{name:"Dataxu",category:"marketing",domains:["*.w55c.net"]},{name:"DatoCMS",homepage:"https://www.datocms.com/",category:"content",domains:["*.datocms-assets.com"]},{name:"Datonics",category:"ad",domains:["*.pro-market.net"]},{name:"Dealtime",category:"content",domains:["*.dealtime.com"]},{name:"Debenhams Geo Location",company:"Debenhams",category:"utility",domains:["176.74.183.134"]},{name:"Decibel Insight",category:"analytics",domains:["*.decibelinsight.net"]},{name:"Deep Forest Media",company:"Rakuten",category:"ad",domains:["*.dpclk.com"]},{name:"DeepIntent",category:"ad",domains:["*.deepintent.com"]},{name:"Delicious Media",category:"social",domains:["*.delicious.com"]},{name:"Delineo",category:"ad",domains:["*.delineo.com"]},{name:"Delta Projects AB",category:"ad",
domains:["*.de17a.com"]},{name:"Demand Media",category:"content",domains:["*.dmtracker.com"]},{name:"DemandBase",category:"marketing",domains:["*.demandbase.com"]},{name:"DemandJump",category:"analytics",domains:["*.demandjump.com"]},{name:"Dennis Publishing",category:"content",domains:["*.alphr.com"]},{name:"Devatics",category:"analytics",domains:["*.devatics.com","*.devatics.io"]},{name:"Developer Media",category:"ad",domains:["*.developermedia.com"]},{name:"DialogTech",category:"ad",domains:["*.dialogtech.com"]},{name:"DialogTech SourceTrak",company:"DialogTech",category:"ad",domains:["d31y97ze264gaa.cloudfront.net"]},{name:"DigiCert",category:"utility",domains:["*.digicert.com"]},{name:"Digioh",category:"ad",domains:["*.lightboxcdn.com"]},{name:"Digital Look",category:"content",domains:["*.digitallook.com"]},{name:"Digital Media Exchange",company:"NDN",category:"content",domains:["*.newsinc.com"]},{name:"Digital Millennium Copyright Act Services",category:"utility",
domains:["*.dmca.com"]},{name:"Digital Ocean",category:"other",domains:["95.85.62.56"]},{name:"Digital Remedy",category:"ad",domains:["*.consumedmedia.com"]},{name:"Digital Window",category:"ad",domains:["*.awin1.com","*.zenaps.com"]},{name:"DigitalScirocco",category:"analytics",domains:["*.digitalscirocco.net"]},{name:"Digitial Point",category:"utility",domains:["*.dpstatic.com"]},{name:"Diligent (Adnetik)",category:"ad",domains:["*.wtp101.com"]},{name:"Directed Edge",category:"social",domains:["*.directededge.com"]},{name:"Distribute Travel",category:"ad",domains:["*.dtrck.net"]},{name:"District M",category:"ad",domains:["*.districtm.io"]},{name:"DistroScale",category:"ad",domains:["*.jsrdn.com"]},{name:"Divido",category:"utility",domains:["*.divido.com"]},{name:"Dow Jones",category:"content",domains:["*.dowjones.com","*.dowjoneson.com"]},{name:"Drifty Co",category:"utility",domains:["*.onicframework.com"]},{name:"Drip",company:"The Numa Group",category:"ad",domains:["*.getdrip.com"]
},{name:"Dropbox",category:"utility",domains:["*.dropboxusercontent.com"]},{name:"Dyn Real User Monitoring",company:"Dyn",category:"analytics",domains:["*.jisusaiche.biz","*.dynapis.com","*.jisusaiche.com","*.dynapis.info"]},{name:"DynAdmic",category:"ad",domains:["*.dyntrk.com"]},{name:"Dynamic Converter",category:"utility",domains:["*.dynamicconverter.com"]},{name:"Dynamic Dummy Image Generator",company:"Open Source",category:"utility",domains:["*.dummyimage.com"]},{name:"Dynamic Logic",category:"ad",domains:["*.dl-rms.com","*.questionmarket.com"]},{name:"Dynamic Yield",category:"customer-success",domains:["*.dynamicyield.com"]},{name:"Dynatrace",category:"analytics",domains:["*.ruxit.com","js-cdn.dynatrace.com"]},{name:"ec-concier",homepage:"https://ec-concier.com/",category:"marketing",domains:["*.ec-concier.com"]},{name:"ECT News Network",category:"content",domains:["*.ectnews.com"]},{name:"ELITechGroup",category:"analytics",domains:["*.elitechnology.com"]},{name:"EMAP",
category:"content",domains:["*.emap.com"]},{name:"EMedia Solutions",category:"ad",domains:["*.e-shots.eu"]},{name:"EQ works",category:"ad",domains:["*.eqads.com"]},{name:"ESV Digital",category:"analytics",domains:["*.esearchvision.com"]},{name:"Ebiquity",category:"analytics",domains:["*.ebiquitymedia.com"]},{name:"Eco Rebates",category:"ad",domains:["*.ecorebates.com"]},{name:"Ecwid",category:"hosting",domains:["*.ecwid.com","*.shopsettings.com","d3fi9i0jj23cau.cloudfront.net","d3j0zfs7paavns.cloudfront.net"]},{name:"Edge Web Fonts",company:"Adobe Systems",category:"cdn",domains:["*.edgefonts.net"]},{name:"Edition Digital",category:"ad",domains:["*.editiondigital.com"]},{name:"Edot Web Technologies",category:"hosting",domains:["*.edot.co.za"]},{name:"Effective Measure",category:"ad",domains:["*.effectivemeasure.net"]},{name:"Effiliation sa",category:"ad",domains:["*.effiliation.com"]},{name:"Ekm Systems",category:"analytics",domains:["*.ekmsecure.com","*.ekmpinpoint.co.uk"]},{
name:"Elastera",category:"hosting",domains:["*.elastera.net"]},{name:"Elastic Ad",category:"ad",domains:["*.elasticad.net"]},{name:"Elastic Load Balancing",company:"Amazon Web Services",category:"hosting",domains:["*.105app.com"]},{name:"Elecard StreamEye",company:"Elecard",category:"other",domains:["*.streameye.net"]},{name:"Elevate",company:"Elevate Technology Solutions",category:"utility",domains:["*.elevaate.technology"]},{name:"Elicit",category:"utility",domains:["*.elicitapp.com"]},{name:"Elogia",category:"ad",domains:["*.elogia.net"]},{name:"Email Attitude",company:"1000mercis",category:"ad",domains:["*.email-attitude.com"]},{name:"EmailCenter",category:"ad",domains:["*.emailcenteruk.com"]},{name:"Embedly",category:"content",domains:["*.embedly.com","*.embed.ly"]},{name:"EmpathyBroker Site Search",company:"EmpathyBroker",category:"utility",domains:["*.empathybroker.com"]},{name:"Enfusen",category:"analytics",domains:["*.enfusen.com"]},{name:"Engadget",company:"Engadget (AOL)",
category:"content",domains:["*.gdgt.com"]},{name:"Engagio",category:"marketing",domains:["*.engagio.com"]},{name:"Ensighten Manage",company:"Ensighten",category:"tag-manager",domains:["*.levexis.com"]},{name:"EntityLink",category:"other",domains:["*.entitytag.co.uk"]},{name:"Entrust Datacard",category:"utility",domains:["*.entrust.com","*.entrust.net"]},{name:"Equiniti",category:"utility",domains:["*.equiniti.com"]},{name:"Errorception",category:"utility",domains:["*.errorception.com"]},{name:"Esri ArcGIS",company:"Esri",category:"utility",domains:["*.arcgis.com","*.arcgisonline.com"]},{name:"Ethnio",category:"analytics",domains:["*.ethn.io"]},{name:"Eulerian Technologies",category:"ad",domains:["*.eolcdn.com"]},{name:"Euroland",category:"utility",domains:["*.euroland.com"]},{name:"European Interactive Digital ad Alli",category:"utility",domains:["*.edaa.eu"]},{name:"Eventbrite",category:"hosting",domains:["*.evbuc.com","*.eventbrite.co.uk"]},{name:"Everflow",category:"analytics",
domains:["*.tp88trk.com"]},{name:"Evergage",category:"analytics",domains:["*.evergage.com","*.evgnet.com"]},{name:"Everquote",category:"content",domains:["*.evq1.com"]},{name:"Everyday Health",category:"ad",domains:["*.agoramedia.com"]},{name:"Evidon",category:"analytics",domains:["*.evidon.com"]},{name:"Evolve Media",category:"content",domains:["*.evolvemediallc.com"]},{name:"Exactag",category:"ad",domains:["*.exactag.com"]},{name:"ExoClick",category:"ad",domains:["*.exoclick.com"]},{name:"Expedia",category:"content",domains:["*.travel-assets.com","*.trvl-media.com","*.trvl-px.com","*.uciservice.com"]},{name:"Expedia Australia",company:"Expedia",category:"content",domains:["*.expedia.com.au"]},{name:"Expedia Canada",company:"Expedia",category:"content",domains:["*.expedia.ca"]},{name:"Expedia France",company:"Expedia",category:"content",domains:["*.expedia.fr"]},{name:"Expedia Germany",company:"Expedia",category:"content",domains:["*.expedia.de"]},{name:"Expedia Italy",
company:"Expedia",category:"content",domains:["*.expedia.it"]},{name:"Expedia Japan",company:"Expedia",category:"content",domains:["*.expedia.co.jp"]},{name:"Expedia USA",company:"Expedia",category:"content",domains:["*.expedia.com"]},{name:"Expedia United Kingdom",company:"Expedia",category:"content",domains:["*.expedia.co.uk"]},{name:"Experian",category:"utility",domains:["*.audienceiq.com","*.experian.com","*.experianmarketingservices.digital"]},{name:"Experian Cross-Channel Marketing Platform",company:"Experian",category:"marketing",domains:["*.eccmp.com","*.ccmp.eu"]},{name:"Exponea",category:"analytics",domains:["*.exponea.com"]},{name:"Exponential Interactive",category:"ad",domains:["*.exponential.com"]},{name:"Extensis WebInk",category:"cdn",domains:["*.webink.com"]},{name:"Extole",category:"ad",domains:["*.extole.com","*.extole.io"]},{name:"Ey-Seren",category:"analytics",domains:["*.webabacus.com"]},{name:"EyeView",category:"ad",domains:["*.eyeviewads.com"]},{name:"Eyeota",
category:"ad",domains:["*.eyeota.net"]},{name:"Ezakus Pretargeting",company:"Ezakus",category:"ad",domains:["*.ezakus.net"]},{name:"Ezoic",category:"analytics",domains:["*.ezoic.net"]},{name:"FLXone",company:"Teradata",category:"ad",domains:["*.pangolin.blue","*.flx1.com","d2hlpp31teaww3.cloudfront.net","*.flxpxl.com"]},{name:"Fairfax Media",category:"content",domains:["ads.fairfax.com.au","resources.fairfax.com.au"]},{name:"Fairfax Media Analtics",company:"Fairfax Media",category:"analytics",domains:["analytics.fairfax.com.au"]},{name:"Falk Technologies",category:"ad",domains:["*.angsrvr.com"]},{name:"Fanplayr",category:"analytics",domains:["*.fanplayr.com","d38nbbai6u794i.cloudfront.net"]},{name:"Fast Thinking",company:"NE Marketing",category:"marketing",domains:["*.fast-thinking.co.uk"]},{name:"Fastest Forward",category:"analytics",domains:["*.gaug.es"]},{name:"Fastly",category:"utility",domains:["*.fastly.net"]},{name:"Feedbackify",company:"InsideMetrics",category:"analytics",
domains:["*.feedbackify.com"]},{name:"Feefo.com",company:"Feefo",category:"analytics",domains:["*.feefo.com"]},{name:"Fidelity Media",category:"ad",domains:["*.fidelity-media.com"]},{name:"Filestack",category:"content",domains:["*.filepicker.io"]},{name:"Finsbury Media",category:"ad",domains:["*.finsburymedia.com"]},{name:"Firepush",category:"utility",domains:["*.firepush.io"]},{name:"FirstImpression",category:"ad",domains:["*.firstimpression.io"]},{name:"Fit Analytics",category:"other",domains:["*.fitanalytics.com"]},{name:"Fits Me",category:"analytics",domains:["*.fits.me"]},{name:"Fivetran",category:"analytics",domains:["*.fivetran.com"]},{name:"FlexShopper",category:"utility",domains:["*.flexshopper.com"]},{name:"Flickr",category:"content",domains:["*.flickr.com","*.staticflickr.com"]},{name:"Flipboard",category:"social",domains:["*.flipboard.com"]},{name:"Flipdesk",category:"customer-success",homepage:"https://flipdesk.jp/",domains:["*.flipdesk.jp"]},{name:"Flipp",
category:"analytics",domains:["*.wishabi.com","d2e0sxz09bo7k2.cloudfront.net","*.wishabi.net"]},{name:"Flite",category:"ad",domains:["*.flite.com"]},{name:"Flixmedia",category:"analytics",domains:["*.flix360.com","*.flixcar.com","*.flixfacts.com","*.flixsyndication.net","*.flixfacts.co.uk"]},{name:"Flockler",category:"ad",domains:["*.flockler.com"]},{name:"Flowplayer",category:"content",domains:["*.flowplayer.org"]},{name:"Flowzymes Ky",category:"cdn",domains:["*.jquerytools.org"]},{name:"Fomo",category:"ad",domains:["*.notifyapp.io"]},{name:"Fonecall",category:"analytics",domains:["*.web-call-analytics.com"]},{name:"Fontdeck",category:"cdn",domains:["*.fontdeck.com"]},{name:"Foodity Technologies",category:"ad",domains:["*.foodity.com"]},{name:"Force24",category:"ad",domains:["*.force24.co.uk"]},{name:"ForeSee",company:"Answers",category:"analytics",domains:["*.4seeresults.com","*.answerscloud.com","*.foresee.com","*.foreseeresults.com"]},{name:"Forensiq",category:"utility",
domains:["*.fqtag.com"]},{name:"Fort Awesome",category:"cdn",domains:["*.fortawesome.com"]},{name:"Forter",category:"utility",domains:["*.forter.com"]},{name:"Forward Internet Group",category:"hosting",domains:["*.f3d.io"]},{name:"Forward3D",category:"ad",domains:["*.forward3d.com"]},{name:"Fospha",category:"analytics",domains:["*.fospha.com"]},{name:"Foursixty",category:"customer-success",domains:["*.foursixty.com"]},{name:"FoxyCart",category:"utility",domains:["*.foxycart.com"]},{name:"Fraudlogix",category:"utility",domains:["*.yabidos.com"]},{name:"FreakOut",category:"ad",domains:["*.fout.jp"]},{name:"Freespee",category:"customer-success",domains:["*.freespee.com"]},{name:"Freetobook",category:"content",domains:["*.freetobook.com"]},{name:"Fresh 8 Gaming",category:"ad",domains:["*.fresh8.co"]},{name:"Fresh Relevance",category:"analytics",domains:["*.freshrelevance.com","*.cloudfront.ne","d1y9qtn9cuc3xw.cloudfront.net","d81mfvml8p5ml.cloudfront.net","dkpklk99llpj0.cloudfront.net"]},{
name:"Friendbuy",category:"ad",domains:["*.friendbuy.com","djnf6e5yyirys.cloudfront.net"]},{name:"Frienefit",category:"ad",domains:["*.frienefit.com"]},{name:"FuelX",category:"ad",domains:["*.fuelx.com"]},{name:"Full Circle Studies",category:"analytics",domains:["*.securestudies.com"]},{name:"FullStory",category:"analytics",domains:["*.fullstory.com"]},{name:"Fyber",category:"ad",domains:["*.fyber.com"]},{name:"G-Forces Web Management",category:"hosting",domains:["*.gforcesinternal.co.uk"]},{name:"G4 Native",company:"Gravity4",category:"ad",domains:["*.triggit.com"]},{name:"GET ME IN!  (TicketMaster)",category:"content",domains:["*.getmein.com"]},{name:"GIPHY",category:"content",domains:["*.giphy.com"]},{name:"GainCloud",company:"GainCloud Systems",category:"other",domains:["*.egaincloud.net"]},{name:"Gath Adams",category:"content",domains:["*.iwantthatflight.com.au"]},{name:"Gecko Tribe",category:"social",domains:["*.geckotribe.com"]},{name:"Gemius",category:"ad",
domains:["*.gemius.pl"]},{name:"Genesis Media",category:"ad",domains:["*.bzgint.com","*.genesismedia.com","*.genesismediaus.com"]},{name:"Genie Ventures",category:"ad",domains:["*.genieventures.co.uk"]},{name:"Geniee",category:"ad",domains:["*.href.asia","*.genieessp.jp","*.genieesspv.jp","*.gssprt.jp"]},{name:"Geniuslink",category:"analytics",domains:["*.geni.us"]},{name:"GeoRiot",category:"other",domains:["*.georiot.com"]},{name:"GeoTrust",category:"utility",domains:["*.geotrust.com"]},{name:"Geoplugin",category:"utility",domains:["*.geoplugin.com","*.geoplugin.net"]},{name:"Georeferencer",company:"Klokan Technologies",category:"utility",domains:["*.georeferencer.com"]},{name:"GetIntent RTBSuite",company:"GetIntent",category:"ad",domains:["*.adhigh.net"]},{name:"GetResponse",category:"ad",domains:["*.getresponse.com"]},{name:"GetSiteControl",company:"GetWebCraft",category:"utility",domains:["*.getsitecontrol.com"]},{name:"GetSocial",category:"social",domains:["*.getsocial.io"]},{
name:"Getty Images",category:"content",domains:["*.gettyimages.com","*.gettyimages.co.uk"]},{name:"Gfycat",company:"Gycat",category:"utility",domains:["*.gfycat.com"]},{name:"Ghostery Enterprise",company:"Ghostery",category:"marketing",domains:["*.betrad.com"]},{name:"Giant Media",category:"ad",domains:["*.videostat.com"]},{name:"Gigya",category:"analytics",domains:["*.gigya.com"]},{name:"GitHub",category:"utility",domains:["*.github.com","*.githubusercontent.com","*.github.io","*.rawgit.com"]},{name:"Gladly",company:"Gladly",homepage:"https://www.gladly.com/",category:"customer-success",domains:["*.gladly.com"]},{name:"Glassdoor",category:"content",domains:["*.glassdoor.com"]},{name:"Gleam",category:"marketing",domains:["*.gleam.io"]},{name:"Global Digital Markets",category:"ad",domains:["*.gdmdigital.com"]},{name:"Global-e",category:"hosting",domains:["*.global-e.com"]},{name:"GlobalSign",category:"utility",domains:["*.globalsign.com","*.globalsign.net"]},{name:"GlobalWebIndex",
category:"analytics",domains:["*.globalwebindex.net"]},{name:"Globase International",category:"ad",domains:["*.globase.com"]},{name:"GoDataFeed",category:"other",domains:["*.godatafeed.com"]},{name:"Google APIs",company:"Google",category:"utility",domains:["googleapis.com"]},{name:"Google Ad Block Detection",company:"Google",category:"ad",domains:["*.0emn.com","*.0fmm.com"]},{name:"Google Analytics Experiments",company:"Google",category:"analytics",domains:["*.gexperiments1.com"]},{name:"Google DoubleClick Ad Exchange",company:"Google",category:"ad",domains:["*.admeld.com"]},{name:"Google IPV6 Metrics",company:"Google",category:"analytics",domains:["*.ipv6test.net"]},{name:"Google Plus",company:"Google",category:"social",domains:["plus.google.com"]},{name:"Google Trusted Stores",company:"Google",category:"utility",domains:["*.googlecommerce.com"]},{name:"Google Video",company:"Google",category:"content",domains:["*.googlevideo.com"]},{name:"Google reCAPTCHA",company:"Google",
category:"utility",domains:["*.recaptcha.net"]},{name:"GovMetric",company:"ROL Solutions",category:"analytics",domains:["*.govmetric.com"]},{name:"Granify",category:"analytics",domains:["*.granify.com"]},{name:"Grapeshot",category:"ad",domains:["*.gscontxt.net","*.grapeshot.co.uk"]},{name:"Gravity (AOL)",category:"analytics",domains:["*.grvcdn.com"]},{name:"Groovy Gecko",category:"content",domains:["*.ggwebcast.com","*.groovygecko.net"]},{name:"GroupM",category:"ad",domains:["*.qservz.com"]},{name:"Guardian Media",category:"ad",domains:["*.theguardian.com","*.guardian.co.uk"]},{name:"GumGum",category:"ad",domains:["*.gumgum.com"]},{name:"Gumtree",category:"content",domains:["*.gumtree.com"]},{name:"H264 Codec",company:"Cisco",category:"other",domains:["*.openh264.org"]},{name:"HERE",category:"analytics",domains:["*.medio.com"]},{name:"HP Optimost",company:"Hewlett-Packard Development Company",category:"marketing",domains:["*.hp.com","d2uncb19xzxhzx.cloudfront.net"]},{name:"Has Offers",
company:"TUNE",category:"ad",domains:["*.go2cloud.org"]},{name:"Hawk Search",category:"utility",domains:["*.hawksearch.com"]},{name:"Haymarket Media Group",category:"content",domains:["*.brandrepublic.com","*.hbpl.co.uk"]},{name:"Heap",category:"analytics",domains:["*.heapanalytics.com"]},{name:"Hearst Communications",category:"content",domains:["*.h-cdn.co","*.hearstdigital.com","*.hearstlabs.com","*.hearst.io","*.cdnds.net"]},{name:"Heatmap",category:"analytics",domains:["*.heatmap.it"]},{name:"Heroku",category:"other",domains:["*.herokuapp.com"]},{name:"Hexton",category:"utility",domains:["*.hextom.com"]},{name:"Hibernia Networks",category:"utility",domains:["*.hiberniacdn.com"]},{name:"High Impact Media",category:"ad",domains:["*.reactx.com"]},{name:"Highcharts",category:"utility",domains:["*.highcharts.com"]},{name:"Highwinds",category:"utility",domains:["*.hwcdn.net"]},{name:"HitsLink",category:"analytics",domains:["*.hitslink.com"]},{name:"Hola Networks",category:"other",
domains:["*.h-cdn.com"]},{name:"Hootsuite",category:"analytics",domains:["*.hootsuite.com"]},{name:"HotUKDeals",category:"analytics",domains:["*.hotukdeals.com"]},{name:"HotWords",company:"Media Response Group",category:"ad",domains:["*.hotwords.com.br"]},{name:"HotelsCombined",category:"content",domains:["*.datahc.com"]},{name:"Hoverr",category:"ad",domains:["*.hoverr.media"]},{name:"Hull.js",category:"utility",domains:["*.hull.io","*.hullapp.io"]},{name:"Hupso Website Analyzer",company:"Hupso",category:"analytics",domains:["*.hupso.com"]},{name:"I-Behavior",company:"WPP",category:"ad",domains:["*.ib-ibi.com"]},{name:"i-mobile",company:"i-mobile",category:"ad",domains:["*.i-mobile.co.jp"]},{name:"IBM Digital Analytics",company:"IBM",category:"analytics",
domains:["*.cmcore.com","coremetrics.com","data.coremetrics.com","data.de.coremetrics.com","libs.de.coremetrics.com","tmscdn.de.coremetrics.com","iocdn.coremetrics.com","libs.coremetrics.com","tmscdn.coremetrics.com","*.s81c.com","*.unica.com","*.coremetrics.eu"]},{name:"IBM Digital Data Exchange",company:"IBM",category:"tag-manager",domains:["tagmanager.coremetrics.com"]},{name:"IBM Tealeaf",company:"IBM",category:"analytics",domains:["*.ibmcloud.com"]},{name:"IBM Acoustic Campaign",company:"IBM",category:"analytics",domains:["www.sc.pages01.net","www.sc.pages02.net","www.sc.pages03.net","www.sc.pages04.net","www.sc.pages05.net","www.sc.pages06.net","www.sc.pages07.net","www.sc.pages08.net","www.sc.pages09.net","www.sc.pagesA.net"]},{name:"ICF Technology",category:"content",domains:["*.camads.net"]},{name:"IFDNRG",category:"hosting",domains:["*.ifdnrg.com"]},{name:"IMRG",category:"analytics",domains:["*.peermap.com","*.imrg.org"]},{name:"IPONWEB",category:"ad",
domains:["*.company-target.com","*.liadm.com","*.iponweb.net","*.p161.net"]},{name:"IQ Mobile",category:"utility",domains:["*.iqm.cc"]},{name:"IS Group",category:"hosting",domains:["*.creative-serving.com"]},{name:"IT Dienstleistungen Tim Prinzkosky",category:"utility",domains:["*.flaticons.net"]},{name:"IXI Digital",company:"Equifax",category:"ad",domains:["*.ixiaa.com"]},{name:"IcoMoon",category:"cdn",domains:["d19ayerf5ehaab.cloudfront.net","d1azc1qln24ryf.cloudfront.net"]},{name:"IdenTrust",category:"utility",domains:["*.identrust.com"]},{name:"Ido",category:"customer-success",domains:["*.idio.co"]},{name:"Ignition One",category:"marketing",domains:["*.searchignite.com"]},{name:"ImageShack",category:"content",domains:["*.yfrog.com"]},{name:"Imagen Studio",category:"utility",domains:["*.telephonesky.com"]},{name:"Imagini Holdings",category:"ad",domains:["*.vdna-assets.com"]},{name:"Img Safe",category:"content",domains:["*.imgsafe.org"]},{name:"Imgur",category:"utility",
domains:["*.imgur.com"]},{name:"Impact Radius",category:"ad",domains:["*.impactradius-event.com","*.impactradius-go.com","*.7eer.net","d3cxv97fi8q177.cloudfront.net","*.evyy.net","*.ojrq.net","utt.impactcdn.com","*.sjv.io"]},{name:"Improve Digital",category:"ad",domains:["*.360yield.com"]},{name:"Improvely",category:"analytics",domains:["*.iljmp.com"]},{name:"InMobi",category:"ad",domains:["*.inmobi.com"]},{name:"InSkin Media",category:"ad",domains:["*.inskinad.com","*.inskinmedia.com"]},{name:"Inbenta",category:"customer-success",domains:["*.inbenta.com"]},{name:"Incisive Media",category:"content",domains:["*.incisivemedia.com"]},{name:"Indeed",category:"content",domains:["*.indeed.com"]},{name:"Index Exchange",company:"WPP",category:"ad",domains:["*.casalemedia.com","*.indexww.com"]},{name:"Indoona",category:"other",domains:["*.indoona.com"]},{name:"Infectious Media",category:"ad",domains:["*.impdesk.com","*.impressiondesk.com","*.inmz.net"]},{name:"Inference Mobile",category:"ad",
domains:["*.inferencemobile.com"]},{name:"Infinity Tracking",category:"analytics",domains:["*.infinity-tracking.net"]},{name:"Infoline",category:"analytics",domains:["*.ioam.de"]},{name:"Infolinks",category:"ad",domains:["*.infolinks.com"]},{name:"Infopark",category:"hosting",domains:["*.scrvt.com"]},{name:"Infusionsoft",category:"ad",domains:["*.infusionsoft.com"]},{name:"Ink",category:"ad",domains:["*.inktad.com"]},{name:"Inktel Contact Center Solutions",company:"Inktel",category:"customer-success",domains:["*.inktel.com"]},{name:"Inneractive",category:"ad",domains:["*.inner-active.mobi"]},{name:"Innovid",category:"ad",homepage:"https://www.innovid.com/",domains:["*.innovid.com"]},{name:"Insight Express",category:"analytics",domains:["*.insightexpressai.com"]},{name:"Insipio",category:"other",domains:["*.insipio.com"]},{name:"Inspectlet",category:"analytics",domains:["*.inspectlet.com"]},{name:"Instansive",category:"utility",domains:["*.instansive.com"]},{name:"Instart",
homepage:"https://www.instart.com/",category:"utility",domains:["*.insnw.net"]},{name:"Instembedder",category:"content",domains:["*.instaembedder.com"]},{name:"Instinctive",category:"ad",domains:["*.instinctiveads.com"]},{name:"Intelligent Reach",category:"ad",domains:["*.ist-track.com"]},{name:"Intent HQ",category:"analytics",domains:["*.intenthq.com"]},{name:"Intent IQ",category:"ad",domains:["*.intentiq.com"]},{name:"Intercept Interactive",category:"ad",domains:["*.undertone.com"]},{name:"Interest Graph",company:"AOL",category:"ad",domains:["*.gravity.com"]},{name:"Internet Brands",category:"content",domains:["*.ibpxl.com"]},{name:"Interpublic Group",category:"ad",domains:["*.mbww.com"]},{name:"Interstate",category:"analytics",domains:["*.interstateanalytics.com"]},{name:"Interview",category:"analytics",domains:["*.efm.me"]},{name:"Intilery",category:"customer-success",domains:["*.intilery-analytics.com"]},{name:"Investis",category:"utility",domains:["*.investis.com"]},{
name:"Investis Flife",category:"hosting",domains:["*.quartalflife.com"]},{name:"Invodo",category:"ad",domains:["*.invodo.com"]},{name:"iSite",category:"analytics",domains:["*.isitetv.com"]},{name:"Issue",category:"content",domains:["*.issue.by"]},{name:"J.D. Williams & Co",category:"content",domains:["*.drct2u.com"]},{name:"Janrain",category:"analytics",domains:["*.janrain.com","*.janrainbackplane.com","*.rpxnow.com","d3hmp0045zy3cs.cloudfront.net"]},{name:"Jellyfish",category:"ad",domains:["*.jellyfish.net"]},{name:"JetStream",category:"content",domains:["*.xlcdn.com"]},{name:"JingDong",category:"content",domains:["*.3.com","*.jd.com"]},{name:"Jivox",category:"ad",domains:["*.jivox.com"]},{name:"Jobvite",category:"content",domains:["*.jobvite.com"]},{name:"Johnston Press",category:"content",domains:["*.johnstonpress.co.uk","*.jpress.co.uk"]},{name:"Join the Dots (Research)",category:"social",domains:["*.jtdiscuss.com"]},{name:"JotForm",category:"utility",domains:["*.jotformpro.com"]
},{name:"JuicyAds",category:"ad",domains:["*.juicyads.com"]},{name:"JustPremium",category:"ad",domains:["*.net.net"]},{name:"JustPremium Ads",company:"JustPremium",category:"ad",domains:["*.justpremium.com"]},{name:"JustUno",category:"ad",domains:["*.justuno.com","d2j3qa5nc37287.cloudfront.net"]},{name:"KINX (Korea Internet Neutral eXchange)",category:"other",domains:["*.kinxcdn.com"]},{name:"KISSmetrics",category:"analytics",domains:["*.kissmetrics.com","doug1izaerwt3.cloudfront.net","dsyszv14g9ymi.cloudfront.net"]},{name:"Kaizen Platform",category:"analytics",domains:["*.kaizenplatform.net"]},{name:"Kakao",category:"social",domains:["*.daum.net","*.daumcdn.net"]},{name:"Kaltura Video Platform",company:"Kaltura",category:"content",domains:["*.kaltura.com"]},{name:"Kameleoon",category:"analytics",domains:["*.kameleoon.com","*.kameleoon.eu"]},{name:"Kampyle",category:"analytics",domains:["*.kampyle.com"]},{name:"Kantar",category:"analytics",domains:["*.sesamestats.com"]},{name:"Kargo",
category:"marketing",domains:["*.kargo.com"]},{name:"KARTE",company:"Plaid",homepage:"https://karte.io/",category:"marketing",domains:["*.karte.io"]},{name:"Kauli",category:"ad",domains:["*.kau.li"]},{name:"Keen",company:"Keen",homepage:"https://keen.io/",category:"analytics",domains:["*.keen.io","d26b395fwzu5fz.cloudfront.net"]},{name:"Kelkoo",category:"hosting",domains:["*.kelkoo.com"]},{name:"Kenshoo",category:"marketing",domains:["*.xg4ken.com"]},{name:"Key CDN",category:"utility",domains:["*.kxcdn.com"]},{name:"Keynote",company:"Dynatrace",category:"analytics",domains:["*.keynote.com"]},{name:"Keywee",category:"ad",domains:["*.keywee.co"]},{name:"Kiosked",category:"ad",domains:["*.kiosked.com"]},{name:"Klarna",category:"utility",domains:["*.klarna.com"]},{name:"Klaviyo",category:"ad",domains:["*.klaviyo.com"]},{name:"Klevu Search",company:"Klevu",category:"utility",domains:["*.klevu.com"]},{name:"Klick2Contact",category:"customer-success",domains:["*.klick2contact.com"]},{
name:"Knight Lab",company:"Northwestern University",category:"utility",domains:["*.knightlab.com"]},{name:"Kodajo",category:"other",domains:["*.kodajo.com"]},{name:"Komoona",category:"ad",domains:["*.komoona.com"]},{name:"Korrelate",company:"JD Power",category:"analytics",domains:["*.korrelate.net"]},{name:"LKQD",category:"ad",domains:["*.lkqd.net"]},{name:"Layer0",category:"cdn",domains:["*.layer0.co"]},{name:"Layershift",category:"hosting",domains:["109.109.138.174"]},{name:"Lead Forensics",category:"ad",domains:["*.200summit.com","*.baw5tracker.com","*.business-path-55.com","*.bux1le001.com","*.central-core-7.com","*.direct-azr-78.com","*.explore-123.com","*.forensics1000.com","*.gldsta-02-or.com","*.green-bloc9.com","*.lansrv040.com","*.lead-123.com","*.leadforensics.com","*.mavic852.com","*.mon-com-net.com","*.peak-ip-54.com","*.snta0034.com","*.svr-prc-01.com","*.syntace-094.com","*.tghbn12.com","*.trail-web.com","*.web-01-gbl.com","*.web-cntr-07.com","*.trackdiscovery.net"]},{
name:"Lead Intelligence",company:"Magnetise Solutions",category:"ad",domains:["*.leadintelligence.co.uk"]},{name:"LeadLander",category:"analytics",domains:["*.formalyzer.com","*.trackalyzer.com"]},{name:"Leaflet",category:"utility",domains:["*.leafletjs.com"]},{name:"LeasdBoxer",company:"LeadBoxer",category:"ad",domains:["*.leadboxer.com"]},{name:"LeaseWeb",homepage:"https://www.leaseweb.com/",category:"cdn",domains:["*.lswcdn.net","*.leasewebcdn.com"]},{name:"Leboncoin",category:"content",domains:["*.leboncoin.fr"]},{name:"Lengow",category:"hosting",domains:["*.lengow.com"]},{name:"Lessbuttons",category:"social",domains:["*.lessbuttons.com"]},{name:"Letter Press",category:"ad",domains:["*.getletterpress.com"]},{name:"Level 3 Communications",category:"utility",domains:["footprint.net"]},{name:"Level3",category:"other",domains:["secure.footprint.net"]},{name:"Lifestreet Media",category:"social",domains:["*.lfstmedia.com"]},{name:"LiftSuggest",category:"analytics",
domains:["d2blwevgjs7yom.cloudfront.net"]},{name:"Ligatus",category:"ad",domains:["*.ligadx.com"]},{name:"LightStep",category:"analytics",domains:["*.lightstep.com"]},{name:"LightWidget",category:"utility",domains:["*.lightwidget.com"]},{name:"Likelihood",company:"LIkeihood",category:"hosting",domains:["*.likelihood.com"]},{name:"LikeShop",company:"Dash Hudson",category:"content",domains:["likeshop.me"]},{name:"LINE Corporation",category:"ad",domains:["*.line-scdn.net","*.line.me"]},{name:"Linkcious",category:"analytics",domains:["*.linkcious.com"]},{name:"Linking Mobile",category:"ad",domains:["*.linkingmobile.com"]},{name:"LittleData",category:"analytics",homepage:"https://www.littledata.io/",domains:["*.littledata.io"]},{name:"LiveBurst",category:"ad",domains:["*.liveburst.com"]},{name:"LiveClicker",category:"ad",domains:["*.liveclicker.net"]},{name:"LiveHelpNow",category:"customer-success",domains:["*.livehelpnow.net"]},{name:"LiveInternet",category:"analytics",
domains:["*.yadro.ru"]},{name:"LiveJournal",category:"social",domains:["*.livejournal.com","*.livejournal.net"]},{name:"LivePerson",category:"customer-success",homepage:"https://www.liveperson.com/",domains:["*.liveperson.com","*.look.io","*.liveperson.net","*.lpsnmedia.net"]},{name:"LiveRail",company:"Facebook",category:"ad",domains:["*.liverail.com","*.lrcdn.net"]},{name:"LiveTex",category:"customer-success",domains:["*.livetex.ru"]},{name:"Livefyre",category:"content",domains:["*.fyre.co","*.livefyre.com"]},{name:"Living Map Company",category:"utility",domains:["*.livingmap.com"]},{name:"Local World",category:"content",domains:["*.thelocalpeople.co.uk"]},{name:"LockerDome",category:"analytics",domains:["*.lockerdome.com"]},{name:"Logentries",company:"Rapid",category:"utility",domains:["*.logentries.com"]},{name:"Logicalis",category:"analytics",domains:["*.trovus.co.uk"]},{name:"LoginRadius",company:"LoginRadius",homepage:"https://www.loginradius.com/",category:"ad",
domains:["*.loginradius.com","*.lrcontent.com"]},{name:"LongTail Ad Solutions",category:"ad",domains:["*.jwpcdn.com","*.jwplatform.com","*.jwplayer.com","*.jwpltx.com","*.jwpsrv.com","*.longtailvideo.com"]},{name:"Loop Commerce",category:"other",domains:["*.loopassets.net"]},{name:"Loop11",category:"analytics",domains:["*.loop11.com"]},{name:"LoopMe",category:"ad",domains:["*.loopme.biz","*.loopme.com","*.vntsm.com","*.loopme.me"]},{name:"Looper",category:"content",domains:["*.looper.com"]},{name:"Loyalty Point",category:"ad",domains:["*.loyaltypoint.pl"]},{name:"LoyaltyLion",category:"ad",domains:["*.loyaltylion.com","*.loyaltylion.net","dg1f2pfrgjxdq.cloudfront.net"]},{name:"Luma Tag",category:"analytics",domains:["*.lumatag.co.uk"]},{name:"Lumesse",category:"content",domains:["*.recruitmentplatform.com"]},{name:"Luminate",category:"ad",domains:["*.luminate.com"]},{name:"Lynchpin Analytics",category:"analytics",domains:["*.lypn.net"]},{name:"Lyris",category:"ad",
domains:["*.clicktracks.com"]},{name:"Lytics",category:"ad",domains:["*.lytics.io"]},{name:"MEC WebTrack",company:"MEC",category:"ad",domains:["*.e-webtrack.net"]},{name:"MECLABS Institute",category:"analytics",domains:["*.meclabs.com","*.meclabsdata.com"]},{name:"MLveda",category:"utility",domains:["*.mlveda.com"]},{name:"Macromill",company:"Macromill",category:"analytics",homepage:"https://group.macromill.com/",domains:["*.macromill.com"]},{name:"Macropod BugHerd",company:"Macropod",category:"utility",domains:["*.bugherd.com"]},{name:"Madison Logic",category:"marketing",domains:["*.ml314.com"]},{name:"Madmetrics",company:"Keyade",category:"analytics",domains:["*.keyade.com"]},{name:"Magnetic",category:"ad",domains:["*.domdex.com","d3ezl4ajpp2zy8.cloudfront.net"]},{name:"Magnetic Platform",company:"Magnetic",category:"ad",domains:["*.magnetic.is"]},{name:"MailMunch",category:"ad",domains:["*.mailmunch.co"]},{name:"MailPlus",category:"ad",domains:["*.mailplus.nl"]},{name:"Mapbox",
category:"utility",domains:["*.mapbox.com"]},{name:"Maptive",category:"utility",domains:["*.maptive.com"]},{name:"Marcaria.com",category:"other",domains:["*.gooo.al"]},{name:"Marchex",category:"analytics",domains:["*.voicestar.com","*.marchex.io"]},{name:"Mark and Mini",category:"ad",domains:["*.markandmini.com"]},{name:"Marker",category:"utility",domains:["*.marker.io"]},{name:"Marketing Dashboards",company:"GroupM",category:"analytics",domains:["*.m-decision.com"]},{name:"Marketizator",category:"analytics",domains:["*.marketizator.com"]},{name:"Marketplace Web Service",company:"Amazon",category:"other",domains:["*.ssl-images-amazon.com"]},{name:"Mashable",category:"social",domains:["*.mshcdn.com"]},{name:"MatchWork",category:"utility",domains:["*.matchwork.com"]},{name:"MathJax",category:"utility",domains:["*.mathjax.org"]},{name:"Mather Economics",category:"analytics",domains:["*.matheranalytics.com"]},{name:"MaxCDN Enterprise",company:"MaxCDN",category:"utility",
domains:["*.netdna-cdn.com","*.netdna-ssl.com"]},{name:"MaxMind",category:"utility",domains:["*.maxmind.com"]},{name:"MaxPoint Interactive",category:"ad",domains:["*.mxptint.net"]},{name:"Maxsi",category:"analytics",domains:["*.evisitanalyst.com"]},{name:"Maxymiser",category:"analytics",domains:["*.maxymiser.net, maxymiser.hs.llnwd.net"]},{name:"McAffee",category:"utility",domains:["*.mcafeesecure.com","*.scanalert.com"]},{name:"Measured",category:"analytics",domains:["*.measured.com"],homepage:"https://www.measured.com/"},{name:"Media IQ",category:"analytics",domains:["*.mediaiqdigital.com"]},{name:"Media Management Technologies",category:"ad",domains:["*.speedshiftmedia.com"]},{name:"Media Temple",category:"hosting",domains:["*.goodlayers2.com"]},{name:"Mediabong",category:"ad",domains:["*.mediabong.net"]},{name:"Mediahawk",category:"analytics",domains:["*.mediahawk.co.uk"]},{name:"Mediahub",category:"ad",domains:["*.hubverifyandoptimize.com","*.projectwatchtower.com"]},{
name:"Mediasyndicator",category:"ad",domains:["*.creativesyndicator.com"]},{name:"Medium",category:"content",domains:["*.medium.com"]},{name:"Meetrics",category:"ad",domains:["*.de.com","*.meetrics.net","*.mxcdn.net"]},{name:"Mega",company:"Mega Information Technology",category:"other",domains:["*.mgcdn.com"]},{name:"Melt",category:"ad",domains:["*.meltdsp.com","*.mesp.com"]},{name:"Meltwater Group",category:"customer-success",domains:["*.meltwaternews.com"]},{name:"Meme",category:"ad",domains:["*.viewwonder.com"]},{name:"MentAd",category:"ad",domains:["*.mentad.com"]},{name:"Mention Me",category:"ad",domains:["*.mention-me.com"]},{name:"Merchant Equipment Store",category:"utility",domains:["*.merchantequip.com"]},{name:"Merchenta",category:"customer-success",domains:["*.merchenta.com"]},{name:"Merkle Digital Data Exchange",company:"Merkle",category:"ad",domains:["*.brilig.com"]},{name:"Merkle Paid Search",company:"Merkle",category:"ad",domains:["*.rkdms.com"]},{name:"Met Office",
category:"content",domains:["*.metoffice.gov.uk"]},{name:"Meta Broadcast",category:"social",domains:["*.metabroadcast.com"]},{name:"Michael Associates",category:"ad",domains:["*.checktestsite.com"]},{name:"Michelin",category:"content",domains:["*.viamichelin.com"]},{name:"Microad",category:"ad",domains:["*.microad.jp"]},{name:"Microsoft Certificate Services",company:"Microsoft",category:"utility",domains:["*.msocsp.com"]},{name:"Microsoft Hosted Libs",company:"Microsoft",category:"cdn",domains:["*.aspnetcdn.com"]},{name:"Microsoft XBox Live",company:"Microsoft",category:"marketing",domains:["*.xboxlive.com"]},{name:"Mightypop",category:"ad",domains:["*.mightypop.ca"]},{name:"Mika Tuupola",category:"utility",domains:["*.appelsiini.net"]},{name:"Millennial Media",category:"ad",domains:["*.jumptap.com"]},{name:"Mirror Image Internet",category:"utility",domains:["*.miisolutions.net"]},{name:"Mobify",category:"utility",domains:["*.mobify.com","*.mobify.net"]},{name:"Mobile Nations",
category:"social",domains:["*.mobilenations.com"]},{name:"Mobivate",category:"ad",domains:["*.mobivatebulksms.com"]},{name:"Momondo",category:"content",domains:["*.momondo.dk"]},{name:"Momondo Group",category:"content",domains:["*.momondogrouo.com","*.momondogroup.com"]},{name:"Monarch Ads",category:"ad",domains:["*.monarchads.com"]},{name:"Monetate",category:"analytics",domains:["*.monetate.net"]},{name:"MonetizeMore",category:"ad",domains:["*.m2.ai"]},{name:"Monitor",company:"Econda",category:"analytics",domains:["*.econda-monitor.de"]},{name:"Monkey Frog Media",category:"content",domains:["*.monkeyfrogmedia.com"]},{name:"Monotype",category:"cdn",domains:["*.fonts.com","*.fonts.net"]},{name:"Moore-Wilson",category:"ad",domains:["*.mwdev.co.uk"]},{name:"Moovweb",category:"utility",domains:["*.moovweb.net"]},{name:"Mopinion",category:"analytics",domains:["*.mopinion.com"]},{name:"MotionPoint",category:"other",domains:["*.convertlanguage.com"]},{name:"Mouse3K",category:"analytics",
domains:["*.mouse3k.com"]},{name:"MouseStats",category:"analytics",domains:["*.mousestats.com"]},{name:"Mouseflow",category:"analytics",domains:["*.mouseflow.com"]},{name:"Movable Ink",category:"analytics",domains:["*.micpn.com"]},{name:"MovingIMAGE24",category:"content",domains:["*.edge-cdn.net"]},{name:"Moxielinks",category:"ad",domains:["*.moxielinks.com"]},{name:"Moz Recommended Companies",company:"Moz",category:"analytics",domains:["d2eeipcrcdle6.cloudfront.net"]},{name:"Mozilla",category:"utility",domains:["*.mozilla.org"]},{name:"Multiview",category:"content",domains:["*.multiview.com","*.track-mv.com"]},{name:"Mux",category:"analytics",domains:["*.litix.io"]},{name:"MyAds",company:"MyBuys",category:"analytics",domains:["*.veruta.com"]},{name:"MyBuys",category:"analytics",domains:["*.mybuys.com"]},{name:"MyFonts",category:"cdn",domains:["*.myfonts.net"]},{name:"MyRegistry",category:"other",domains:["*.myregistry.com"]},{name:"MySpace",company:"Specific Media",category:"social",
domains:["*.myspace.com"]},{name:"Mynewsdesk",category:"utility",domains:["*.mynewsdesk.com"]},{name:"NAVIS",category:"content",domains:["*.navistechnologies.info"]},{name:"NCC Group Real User Monitoring",company:"NCC Group",category:"analytics",domains:["*.nccgroup-webperf.com"]},{name:"NEORY Marketing Cloud",company:"NEORY",category:"marketing",domains:["*.ad-srv.net"]},{name:"Nanigans",category:"ad",domains:["*.nanigans.com"]},{name:"Nano Interactive",category:"ad",domains:["*.audiencemanager.de"]},{name:"Nanorep",company:"Nanorep Technologies",category:"customer-success",domains:["*.nanorep.com"]},{name:"Narrative",category:"ad",domains:["*.narrative.io"]},{name:"Native Ads",category:"ad",domains:["*.nativeads.com"]},{name:"Nativo",category:"ad",domains:["*.postrelease.com"]},{name:"Navegg",category:"ad",domains:["*.navdmp.com"]},{name:"NaviStone",category:"ad",domains:["*.murdoog.com"]},{name:"Naytev",category:"analytics",domains:["*.naytev.com"]},{name:"Needle",
category:"analytics",domains:["*.needle.com"]},{name:"Neiman Marcus",category:"content",domains:["*.ctscdn.com"]},{name:"Nend",category:"ad",domains:["*.nend.net"]},{name:"Neodata",category:"ad",domains:["*.neodatagroup.com"]},{name:"Net Applications",category:"analytics",domains:["*.hitsprocessor.com"]},{name:"Net Reviews",category:"analytics",domains:["*.avis-verifies.com"]},{name:"NetAffiliation",company:"Kwanco",category:"ad",domains:["*.metaffiliation.com"]},{name:"NetDirector",company:"G-Forces Web Management",category:"other",domains:["*.netdirector.co.uk"]},{name:"NetFlix",category:"content",domains:["*.nflxext.com","*.nflximg.net"]},{name:"Nielsen NetRatings SiteCensus",company:"The Nielsen Company",homepage:"http://www.nielsen-online.com/intlpage.html",category:"analytics",domains:["*.imrworldwide.com"]},{name:"NetSeer",category:"ad",domains:["*.netseer.com","*.ns-cdn.com"]},{name:"NetShelter",company:"Ziff Davis Tech",category:"ad",domains:["*.netshelter.net"]},{
name:"Netmining",company:"Ignition One",category:"ad",domains:["*.netmng.com"]},{name:"Netop",category:"customer-success",domains:["*.netop.com"]},{name:"Network Solutions",category:"utility",domains:["*.netsolssl.com","*.networksolutions.com"]},{name:"Neustar AdAdvisor",company:"Neustar",category:"ad",domains:["*.adadvisor.net"]},{name:"New Approach Media",category:"ad",domains:["*.newapproachmedia.co.uk"]},{name:"NewShareCounts",category:"social",domains:["*.newsharecounts.com"]},{name:"News",category:"social",domains:["*.news.com.au","*.newsanalytics.com.au","*.newsapi.com.au","*.newscdn.com.au","*.newsdata.com.au","*.newsdiscover.com.au","*.news-static.com"]},{name:"Newsquest",category:"content",domains:["*.newsquestdigital.co.uk"]},{name:"Newzulu",category:"content",domains:["*.filemobile.com","*.projects.fm"]},{name:"Nexcess.Net",category:"hosting",domains:["*.nexcesscdn.net"]},{name:"Nexstar Media Group",category:"ad",domains:["*.yashi.com"]},{name:"NextPerf",
company:"Rakuten Marketing",category:"ad",domains:["*.nxtck.com"]},{name:"Nine.com.au",company:"Nine Digital",category:"content",domains:["*.9msn.com.au"]},{name:"NitroSell",category:"hosting",domains:["*.nitrosell.com"]},{name:"Nochex",category:"utility",domains:["*.nochex.com"]},{name:"Northern &amp; Shell Media Group",category:"content",domains:["*.northernandshell.co.uk"]},{name:"Nosto",category:"analytics",domains:["*.nosto.com"]},{name:"Now Interact",category:"analytics",domains:["*.nowinteract.com"]},{name:"Numberly",company:"1000mercis",category:"ad",domains:["*.mmtro.com","*.nzaza.com"]},{name:"NyaConcepts",category:"analytics",domains:["*.xclusive.ly"]},{name:"O2",category:"other",domains:["*.o2.co.uk"]},{name:"GoDaddy",homepage:"https://www.godaddy.com/",category:"utility",domains:["*.godaddy.com","*.wsimg.com"]},{name:"ObjectPlanet",category:"analytics",domains:["*.easypolls.net"]},{name:"OhMyAd",category:"ad",domains:["*.ohmyad.co"]},{name:"Okas Concepts",
category:"utility",domains:["*.okasconcepts.com"]},{name:"Okta",category:"analytics",domains:["*.okta.com"]},{name:"Olapic",category:"content",domains:["*.photorank.me"]},{name:"Ometria",category:"analytics",domains:["*.ometria.com"]},{name:"Omniconvert",category:"analytics",domains:["*.omniconvert.com","d2tgfbvjf3q6hn.cloudfront.net","d3vbj265bmdenw.cloudfront.net"]},{name:"Omniroot",company:"Verizon",category:"utility",domains:["*.omniroot.com"]},{name:"OnAudience",company:"Cloud Technologies",category:"ad",domains:["*.onaudience.com"]},{name:"OnScroll",category:"ad",domains:["*.onscroll.com"]},{name:"OnState",category:"ad",domains:["*.onstate.co.uk"]},{name:"OnYourMap",category:"utility",domains:["*.onyourmap.com"]},{name:"One by AOL",company:"AOL",category:"ad",domains:["*.adtechjp.com","*.adtech.de"]},{name:"One by AOL:Mobile",company:"AOL",category:"ad",domains:["*.nexage.com"]},{name:"OneAll",category:"analytics",domains:["*.oneall.com"]},{name:"OneSoon",category:"analytics",
domains:["*.adalyser.com"]},{name:"OneTag",category:"ad",domains:["*.onetag-sys.com"]},{name:"Onet",category:"ad",domains:["*.onet.pl"]},{name:"Online Rewards",company:"Mastercard",category:"ad",domains:["*.loyaltygateway.com"]},{name:"Online republic",category:"content",domains:["*.imallcdn.net"]},{name:"Ooyala",category:"ad",domains:["*.ooyala.com"]},{name:"OpenTable",company:"Priceline Group",category:"content",domains:["*.opentable.com","*.opentable.co.uk","*.toptable.co.uk"]},{name:"OpenX Ad Exchange",company:"OpenX Technologies",category:"ad",domains:["*.liftdna.com"]},{name:"Opinion Stage",category:"analytics",domains:["*.opinionstage.com"]},{name:"OpinionBar",category:"analytics",domains:["*.opinionbar.com"]},{name:"Opta",company:"Perform Group",category:"content",domains:["*.opta.net"]},{name:"OptiMonk",category:"ad",domains:["*.optimonk.com"]},{name:"Optilead",category:"analytics",domains:["*.dyn-img.com","*.leadcall.co.uk","*.optilead.co.uk"]},{name:"Optimatic",
category:"ad",domains:["*.optimatic.com"]},{name:"Optimise Media Group",category:"utility",domains:["*.omguk.com"]},{name:"Optimost",company:"OpenText",category:"ad",domains:["*.optimost.com"]},{name:"Optimove",company:"Mobius Solutions",category:"analytics",domains:["*.optimove.net"]},{name:"Optorb",category:"ad",domains:["*.optorb.com"]},{name:"Oracle",category:"marketing",domains:["*.custhelp.com","*.eloqua.com","*.en25.com","*.estara.com","*.instantservice.com"]},{name:"Oracle Recommendations On Demand",company:"Oracle",category:"analytics",domains:["*.atgsvcs.com"]},{name:"Oracle Responsys",company:"Oracle",category:"marketing",domains:["*.adrsp.net","*.responsys.net"]},{name:"Order Security-VOID",company:"Order Security",category:"analytics",domains:["*.order-security.com"]},{name:"Oriel",category:"ad",domains:["*.oriel.io"]},{name:"Outbrain",homepage:"https://www.outbrain.com/",category:"ad",domains:["*.outbrain.com","*.outbrainimg.com","*.visualrevenue.com"]},{
name:"OverStream",company:"Coull",category:"ad",domains:["*.coull.com"]},{name:"Overdrive",category:"content",domains:["*.contentreserve.com"]},{name:"Overstock",category:"utility",domains:["*.ostkcdn.com"]},{name:"OwnerIQ",category:"ad",domains:["*.owneriq.net"]},{name:"OzCart",category:"utility",domains:["*.ozcart.com.au"]},{name:"Ozone Media",category:"ad",domains:["*.adadyn.com"]},{name:"Loqate",company:"Loqate",category:"other",domains:["*.pcapredict.com","*.postcodeanywhere.co.uk"]},{name:"PEER 1 Hosting",category:"hosting",domains:["*.peer1.com"]},{name:"PERFORM",category:"content",domains:["*.performgroup.com"]},{name:"PICnet",category:"hosting",domains:["*.nonprofitsoapbox.com"]},{name:"Pacnet",company:"Telstra",category:"other",domains:["*.cdndelivery.net"]},{name:"Pagefair",category:"ad",domains:["*.pagefair.com","*.pagefair.net"]},{name:"Pagely",category:"other",domains:["*.optnmstr.com"]},{name:"Pagesuite",category:"ad",domains:["*.pagesuite-professional.co.uk"]},{
name:"Pardot",category:"marketing",domains:["*.pardot.com"]},{name:"Parse.ly",category:"analytics",domains:["*.parsely.com","d1z2jf7jlzjs58.cloudfront.net"]},{name:"Pay per Click",company:"Eysys",category:"ad",domains:["*.eysys.com"]},{name:"PayPal Ads",category:"ad",domains:["*.where.com"]},{name:"Peaks & Pies",category:"analytics",domains:["*.bunchbox.co"]},{name:"PebblePost",category:"ad",domains:["*.pbbl.co"]},{name:"Peerius",category:"analytics",domains:["*.peerius.com"]},{name:"Peermap",company:"IMRG",category:"analytics",domains:["peermapcontent.affino.com"]},{name:"Penske Media",category:"content",domains:["*.pmc.com"]},{name:"Penton",category:"utility",domains:["*.pisces-penton.com"]},{name:"Pepper",category:"ad",domains:["*.peppercorp.com"]},{name:"Perfect Audience",company:"Marin Software",category:"ad",domains:["*.prfct.co","*.marinsm.com","*.perfectaudience.com"]},{name:"Perfect Market",category:"ad",domains:["*.perfectmarket.com"]},{name:"Perfect Privacy",
category:"other",domains:["*.suitesmart.com"]},{name:"Perform Group",category:"content",domains:["*.performfeeds.com","*.premiumtv.co.uk"]},{name:"Performio",category:"ad",domains:["*.performax.cz"]},{name:"PerimeterX Bot Defender",company:"PerimeterX",category:"utility",domains:["*.perimeterx.net","*.pxi.pub"]},{name:"Periscope",category:"content",domains:["*.periscope.tv"]},{name:"Permutive",category:"ad",domains:["*.permutive.com","d3alqb8vzo7fun.cloudfront.net"]},{name:"Petametrics",category:"analytics",domains:["*.petametrics.com"]},{name:"PhotoBucket",category:"content",domains:["*.photobucket.com"]},{name:"Picreel",category:"analytics",domains:["*.pcrl.co","*.picreel.com"]},{name:"Pictela (AOL)",category:"analytics",domains:["*.pictela.net"]},{name:"PistonHeads",category:"social",domains:["*.pistonheads.com"]},{name:"Piwik",category:"analytics",domains:["*.drtvtracker.com","*.piwikpro.com","*.raac33.net"]},{name:"Pixalate",category:"utility",domains:["*.adrta.com"]},{
name:"Pixlee",category:"social",domains:["*.pixlee.com"]},{name:"Placed",category:"analytics",domains:["*.placed.com"]},{name:"Planning-inc",category:"analytics",domains:["*.planning-inc.co.uk"]},{name:"PlayAd Media Group",category:"ad",domains:["*.youplay.se"]},{name:"Playbuzz",category:"hosting",domains:["*.playbuzz.com"]},{name:"Pleenq",category:"ad",domains:["*.pleenq.com"]},{name:"Plentific",category:"content",domains:["*.plentific.com"]},{name:"PluginDetect",category:"other",domains:["dtlilztwypawv.cloudfront.net"]},{name:"Po.st",company:"RadiumOne",category:"utility",domains:["*.po.st"]},{name:"Pointpin",category:"utility",domains:["*.pointp.in"]},{name:"Pointroll (Garnett)",category:"ad",domains:["*.pointroll.com"]},{name:"Polar",homepage:"https://polar.me/",category:"ad",
domains:["*.polarmobile.ca","*.mediaeverywhere.com","*.mediavoice.com","*.plrsrvcs.com","*.polarcdn-engine.com","*.polarcdn-meraxes.com","*.polarcdn-pentos.com","*.polarcdn-static.com","*.polarcdn-terrax.com","*.polarcdn.com","*.polarmobile.com","*.poweredbypolar.com","*.mediaconductor.me","*.polaracademy.me"]},{name:"PollDaddy (Automattic)",category:"ad",domains:["static.polldaddy.com","*.poll.fm"]},{name:"Polldaddy",company:"Automattic",category:"analytics",domains:["polldaddy.com","*.polldaddy.com"]},{name:"Polyfill service",company:"Polyfill.io",category:"other",domains:["*.polyfill.io"]},{name:"MegaPopAds",category:"ad",domains:["*.megapopads.com"]},{name:"Populis",category:"ad",domains:["*.populisengage.com"]},{name:"Postimage.org",category:"content",domains:["*.postimg.org"]},{name:"PowerFront",category:"hosting",domains:["*.inside-graph.com"]},{name:"PowerReviews",category:"analytics",domains:["*.powerreviews.com"]},{name:"Powerlinks.com",category:"ad",
domains:["*.powerlinks.com"]},{name:"Press+",category:"ad",domains:["*.pipol.com","*.ppjol.com","*.ppjol.net"]},{name:"PressArea",category:"utility",domains:["*.pressarea.com"]},{name:"Pretio Interactive",category:"ad",domains:["*.pretio.in"]},{name:"Prezi",category:"utility",domains:["*.prezi.com"]},{name:"PriceGrabber",category:"content",domains:["*.pgcdn.com","*.pricegrabber.com"]},{name:"PriceRunner",category:"content",domains:["*.pricerunner.com"]},{name:"PrintFriendly",category:"utility",domains:["*.printfriendly.com"]},{name:"Privy",category:"ad",domains:["*.privy.com","*.privymktg.com"]},{name:"Proclivity Media",category:"analytics",domains:["*.pswec.com"]},{name:"Profitshare",category:"ad",domains:["*.profitshare.ro"]},{name:"Programattik",category:"ad",domains:["*.programattik.com"]},{name:"Proper Media",category:"content",domains:["*.proper.io"]},{name:"Property Week",category:"content",domains:["*.propertyweek.com"]},{name:"Provide Support",category:"customer-success",
domains:["*.providesupport.com"]},{name:"Proweb Uk",category:"hosting",domains:["*.proweb.net"]},{name:"Proximic (ComScore)",category:"ad",domains:["*.proximic.com"]},{name:"Psyma",category:"ad",domains:["*.psyma.com"]},{name:"PubFactory",company:"Safari Books Online",category:"content",domains:["*.pubfactory.com"]},{name:"PubNation",category:"ad",domains:["*.pubnation.com"]},{name:"Publicidad.net",category:"ad",domains:["*.publicidad.tv"]},{name:"PublishThis",company:"Ultra Unlimited",category:"ad",domains:["*.publishthis.com"]},{name:"Pulse Insights",category:"analytics",domains:["*.pulseinsights.com"]},{name:"Pulsepoint",category:"marketing",domains:["*.displaymarketplace.com"]},{name:"Purch",category:"ad",domains:["*.bestofmedia.com","*.purch.com"]},{name:"Pure Chat",category:"customer-success",domains:["*.purechat.com"]},{name:"PushCrew",category:"ad",domains:["*.pushcrew.com"]},{name:"Q1Media",category:"ad",domains:["*.q1media.com","*.q1mediahydraplatform.com"]},{
name:"Qbase Software Development",category:"hosting",domains:["*.smartwebportal.co.uk"]},{name:"Qeryz",category:"analytics",domains:["*.qeryz.com"]},{name:"Qode Interactive",category:"hosting",domains:["*.qodeinteractive.com"]},{name:"Qrius",category:"social",domains:["*.qrius.me"]},{name:"Qualaroo",category:"analytics",domains:["*.qualaroo.com"]},{name:"Qualtrics",category:"analytics",domains:["*.qualtrics.com"]},{name:"Qubit",company:"Qubit",category:"analytics",domains:["*.qubit.com","*.qutics.com","d3c3cq33003psk.cloudfront.net","*.goqubit.com","*.qubitproducts.com"]},{name:"Qubit Deliver",company:"Qubit",category:"analytics",domains:["d1m54pdnjzjnhe.cloudfront.net","d22rutvoghj3db.cloudfront.net","dd6zx4ibq538k.cloudfront.net"]},{name:"QuestionPro",category:"analytics",domains:["*.questionpro.com"]},{name:"Queue-it",category:"other",domains:["*.queue-it.net"]},{name:"QuinStreet",category:"ad",domains:["*.Quinstreet.com","*.b2btechleadform.com","*.qnsr.com","*.qsstats.com"]},{
name:"QuoVadis",category:"utility",domains:["*.quovadisglobal.com"]},{name:"Qzzr",category:"analytics",domains:["*.movementventures.com","*.qzzr.com"]},{name:"RapidAPI",category:"utility",domains:["*.rapidapi.com"]},{name:"RCS Media Group",category:"ad",domains:["*.rcsadv.it"]},{name:"REVIVVE",category:"ad",domains:["*.revivve.com"]},{name:"RSSinclude",category:"social",domains:["*.rssinclude.com"]},{name:"RTB House AdPilot",company:"RTB House",category:"ad",domains:["*.erne.co","*.creativecdn.com"]},{name:"RTB Media",category:"ad",domains:["*.rtb-media.me"]},{name:"RUN",category:"ad",domains:["*.runadtag.com","*.rundsp.com"]},{name:"Rackspace",category:"hosting",domains:["*.rackcdn.com","*.rackspacecloud.com","*.raxcdn.com","*.websitetestlink.com"]},{name:"RadiumOne",category:"ad",domains:["*.gwallet.com","*.r1-cdn.net"]},{name:"Rakuten DC Storm",company:"Rakuten",category:"analytics",domains:["*.dc-storm.com","*.h4k5.com","*.stormiq.com"]},{name:"Rakuten LinkShare",company:"Rakuten",
category:"ad",domains:["*.linksynergy.com"]},{name:"Rakuten Marketing",company:"Rakuten",category:"ad",domains:["*.rakuten-static.com","*.rmtag.com","tag.rmp.rakuten.com"]},{name:"Rakuten MediaForge",company:"Rakuten",category:"ad",domains:["*.mediaforge.com"]},{name:"Rambler",company:"Rambler & Co",category:"utility",domains:["*.rambler.ru"]},{name:"Ranker",category:"content",domains:["*.ranker.com","*.rnkr-static.com"]},{name:"Ravelin",category:"utility",domains:["*.ravelin.com"]},{name:"Raygun",category:"utility",domains:["*.raygun.io"]},{name:"ReCollect",category:"utility",domains:["*.recollect.net"]},{name:"ReSRC",category:"utility",domains:["*.resrc.it"]},{name:"ReTargeter",category:"ad",domains:["*.retargeter.com"]},{name:"Reach Group",category:"ad",domains:["*.redintelligence.net"]},{name:"ReachDynamics",category:"ad",domains:["*.rdcdn.com"]},{name:"ReachForce",category:"ad",domains:["*.reachforce.com"]},{name:"ReachLocal",category:"ad",domains:["*.rtrk.co.nz"]},{
name:"ReachMee",category:"content",domains:["*.reachmee.com"]},{name:"Reactful",category:"analytics",domains:["*.reactful.com"]},{name:"Realtime",company:"internet business technologies",category:"utility",domains:["*.realtime.co"]},{name:"Realtime Media (Brian Communications)",category:"ad",domains:["*.rtm.com"]},{name:"Realtime Targeting",category:"ad",domains:["*.idtargeting.com"]},{name:"Realytics",category:"analytics",domains:["dcniko1cv0rz.cloudfront.net","*.realytics.net"]},{name:"RebelMouse",category:"ad",domains:["*.rebelmouse.com","*.rbl.ms"]},{name:"Receiptful",category:"utility",domains:["*.receiptful.com"]},{name:"Recite Me",category:"other",domains:["*.reciteme.com"]},{name:"RecoBell",category:"analytics",domains:["*.recobell.io"]},{name:"Recommend",category:"analytics",domains:["*.recommend.pro"]},{name:"Red Eye International",category:"ad",domains:["*.pajmc.com"]},{name:"Redfish Group",category:"ad",domains:["*.wmps.com"]},{name:"Reevoo",category:"analytics",
domains:["*.reevoo.com"]},{name:"Refersion",category:"ad",domains:["*.refersion.com"]},{name:"Refined Ads",category:"ad",domains:["*.refinedads.com"]},{name:"Reflektion",category:"analytics",domains:["*.reflektion.com","d26opx5dl8t69i.cloudfront.net"]},{name:"Reflow",company:"Scenestealer",category:"ad",domains:["*.reflow.tv"]},{name:"Reklama",category:"ad",domains:["*.o2.pl","*.wp.pl"]},{name:"Relevad ReleStar",company:"Relevad",category:"ad",domains:["*.relestar.com"]},{name:"Remarketing Pixel",company:"Adsterra Network",category:"ad",domains:["*.datadbs.com","*.remarketingpixel.com"]},{name:"Remintrex",company:"SmartUp Venture",category:"ad",domains:["*.remintrex.com"]},{name:"Republer",category:"ad",domains:["*.republer.com"]},{name:"Research Now",category:"analytics",domains:["*.researchgnow.com","*.researchnow.com"]},{name:"Research Online",company:"Skills Development Scotland",category:"content",domains:["*.researchonline.org.uk"]},{name:"Resonance Insights",
category:"analytics",domains:["*.res-x.com"]},{name:"Resonate Networks",category:"analytics",domains:["*.reson8.com"]},{name:"Response Team",category:"ad",domains:["*.i-transactads.com"]},{name:"ResponseTap",category:"analytics",domains:["*.adinsight.com","*.responsetap.com"]},{name:"ResponsiveVoice",category:"other",domains:["*.responsivevoice.org"]},{name:"Retention Science",category:"ad",domains:["*.retentionscience.com","d1stxfv94hrhia.cloudfront.net"]},{name:"Revcontent",category:"content",domains:["*.revcontent.com"]},{name:"Revee",category:"ad",domains:["*.revee.com"]},{name:"Revenue Conduit",category:"utility",domains:["*.revenueconduit.com"]},{name:"RevenueMantra",category:"ad",domains:["*.revenuemantra.com"]},{name:"Reviews.co.uk",category:"analytics",domains:["*.reviews.co.uk"]},{name:"Reviews.io",category:"analytics",domains:["*.reviews.io"]},{name:"Revolver Maps",category:"analytics",domains:["*.revolvermaps.com"]},{name:"Revv",category:"utility",domains:["*.revv.co"]},{
name:"RichRelevance",category:"analytics",domains:["*.richrelevance.com"]},{name:"RightNow Service Cloud",company:"Oracle",category:"customer-success",domains:["*.rightnowtech.com","*.rnengage.com"]},{name:"Rightster",category:"ad",domains:["*.ads-creativesyndicator.com"]},{name:"Riskified",category:"utility",domains:["*.riskified.com"]},{name:"Rockerbox",category:"analytics",homepage:"https://www.rockerbox.com/",domains:["getrockerbox.com"]},{name:"Rocket Fuel",category:"ad",domains:["*.rfihub.com","*.ru4.com","*.rfihub.net","*.ad1x.com"]},{name:"Rollbar",category:"utility",domains:["*.rollbar.com","d37gvrvc0wt4s1.cloudfront.net"]},{name:"RomanCart",category:"utility",domains:["*.romancart.com"]},{name:"Rondavu",category:"ad",domains:["*.rondavu.com"]},{name:"Roomkey",category:"content",domains:["*.roomkey.com"]},{name:"Roost",category:"utility",domains:["*.goroost.com"]},{name:"Roxot",category:"ad",domains:["*.rxthdr.com"]},{name:"Roxr Software",category:"analytics",
domains:["*.getclicky.com"]},{name:"Rtoaster",company:"Brainpad",homepage:"https://www.brainpad.co.jp/rtoaster/",category:"marketing",domains:["*.rtoaster.jp"]},{name:"Rubikloud.com",category:"analytics",domains:["*.rubikloud.com"]},{name:"Ruler Analytics",company:"Ruler",category:"analytics",domains:["*.nyltx.com","*.ruleranalytics.com"]},{name:"Runner",company:"Rambler & Co",category:"content",domains:["*.begun.ru"]},{name:"S4M",category:"ad",domains:["*.sam4m.com"]},{name:"SAP Hybris Marketing Convert",company:"SAP",category:"ad",domains:["*.seewhy.com"]},{name:"SAS Institute",category:"ad",domains:["*.aimatch.com","*.sas.com"]},{name:"SATORI",homepage:"https://satori.marketing/",category:"marketing",domains:["satori.segs.jp"]},{name:"SC ShopMania Net SRL",category:"content",domains:["*.shopmania.com"]},{name:"SDL Media Manager",company:"SDL",category:"other",domains:["*.sdlmedia.com"]},{name:"SFR",category:"other",domains:["*.sfr.fr"]},{name:"SLI Systems",category:"utility",
domains:["*.resultslist.com","*.resultspage.com","*.sli-spark.com"]},{name:"SMARTASSISTANT",company:"Smart Information Systems",category:"customer-success",domains:["*.smartassistant.com"]},{name:"SMARTSTREAM.TV",category:"ad",domains:["*.smartstream.tv"]},{name:"SPX",company:"Smaato",category:"ad",domains:["*.smaato.net"]},{name:"Sabio",category:"customer-success",domains:["*.sabio.co.uk"]},{name:"Sailthru",category:"analytics",domains:["*.sail-horizon.com","*.sail-personalize.com","*.sail-track.com"]},{name:"Sailthru Sightlines",company:"Sailthru",category:"marketing",domains:["*.sailthru.com"]},{name:"Sajari Pty",category:"utility",domains:["*.sajari.com"]},{name:"SaleCycle",category:"ad",domains:["*.salecycle.com","d16fk4ms6rqz1v.cloudfront.net","d22j4fzzszoii2.cloudfront.net","d30ke5tqu2tkyx.cloudfront.net","dn1i8v75r669j.cloudfront.net"]},{name:"Salesforce Live Agent",company:"Salesforce.com",category:"customer-success",domains:["*.salesforceliveagent.com"]},{
name:"Salesforce.com",category:"ad",domains:["*.force.com","*.salesforce.com"]},{name:"Samba TV",company:"Samba",category:"content",domains:["*.samba.tv"]},{name:"Samplicio.us",category:"analytics",domains:["*.samplicio.us"]},{name:"Say Media",category:"ad",domains:["*.saymedia.com"]},{name:"Scenario",category:"analytics",domains:["*.getscenario.com"]},{name:"Schuh (image shard)",company:"Schuh",category:"other",domains:["d2ob0iztsaxy5v.cloudfront.net"]},{name:"Science Rockstars",category:"analytics",domains:["*.persuasionapi.com"]},{name:"ScientiaMobile",category:"analytics",domains:["*.wurflcloud.com","*.wurfl.io"]},{name:"Scoota",category:"ad",domains:["*.rockabox.co","*.scoota.co","d31i2625d5nv27.cloudfront.net","dyjnzf8evxrp2.cloudfront.net"]},{name:"ScribbleLive",category:"ad",domains:["*.scribblelive.com"]},{name:"SearchForce",category:"ad",domains:["*.searchforce.net"]},{name:"SearchSpring",category:"utility",domains:["*.searchspring.net"]},{name:"Searchanise",
category:"analytics",domains:["*.searchanise.com"]},{name:"Sears Holdings",category:"content",domains:["*.shld.net"]},{name:"Secomapp",category:"utility",domains:["*.secomapp.com"]},{name:"SecuredVisit",company:"4Cite Marketing",category:"ad",domains:["*.securedvisit.com"]},{name:"SecurityMetrics",category:"utility",domains:["*.securitymetrics.com"]},{name:"Segmento",category:"ad",domains:["*.rutarget.ru"]},{name:"Segmint",category:"analytics",domains:["*.segmint.net"]},{name:"Sekindo",category:"content",domains:["*.sekindo.com"]},{name:"Seldon",category:"analytics",domains:["*.rummblelabs.com"]},{name:"SelectMedia International",category:"content",domains:["*.selectmedia.asia"]},{name:"Selligent",category:"ad",domains:["*.emsecure.net","*.slgnt.eu","targetemsecure.blob.core.windows.net"]},{name:"Sellpoints",category:"analytics",domains:["*.sellpoints.com"]},{name:"Semantics3",category:"analytics",domains:["*.hits.io"]},{name:"Semasio",category:"analytics",domains:["*.semasio.net"]},{
name:"Semcasting Site Visitor Attribution",company:"Semcasting",category:"ad",domains:["*.smartzonessva.com"]},{name:"Sentifi",category:"social",domains:["*.sentifi.com"]},{name:"ServMetric",category:"analytics",domains:["*.servmetric.com"]},{name:"ServiceSource International",category:"marketing",domains:["*.scoutanalytics.net"]},{name:"ServiceTick",category:"analytics",domains:["*.servicetick.com"]},{name:"Servo",company:"Xervo",category:"hosting",domains:["*.onmodulus.net"]},{name:"SessionCam",company:"ServiceTick",category:"analytics",domains:["*.sessioncam.com","d2oh4tlt9mrke9.cloudfront.net"]},{name:"Seznam",category:"utility",domains:["*.imedia.cz"]},{name:"Sharethrough",category:"ad",domains:["*.sharethrough.com"]},{name:"SharpSpring",category:"marketing",domains:["*.sharpspring.com","*.marketingautomation.services"]},{name:"ShopRunner",category:"content",domains:["*.shoprunner.com","*.s-9.us"]},{name:"ShopStorm",category:"utility",domains:["*.shopstorm.com"]},{
name:"Shopatron",category:"hosting",domains:["*.shopatron.com"]},{name:"Shopgate",category:"utility",domains:["*.shopgate.com"]},{name:"ShopiMind",company:"ShopIMind",category:"ad",domains:["*.shopimind.com"]},{name:"Shopkeeper Tools",category:"utility",domains:["*.shopkeepertools.com"]},{name:"Sidecar",category:"other",domains:["*.getsidecar.com","d3v27wwd40f0xu.cloudfront.net"]},{name:"Sidereel",category:"analytics",domains:["*.sidereel.com"]},{name:"Sift Science",category:"utility",domains:["*.siftscience.com"]},{name:"Signal",category:"tag-manager",domains:["*.sitetagger.co.uk"]},{name:"Signyfyd",category:"utility",domains:["*.signifyd.com"]},{name:"Silktide",category:"hosting",domains:["*.silktide.com"]},{name:"Silverpop",company:"IBM",category:"ad",domains:["*.mkt912.com","*.mkt922.com","*.mkt932.com","*.mkt941.com","*.mkt51.net","*.mkt61.net","*.pages01.net","*.pages02.net","*.pages03.net","*.pages04.net","*.pages05.net"]},{name:"Simplaex",category:"marketing",
domains:["*.simplaex.net"]},{name:"SimpleReach",category:"analytics",domains:["*.simplereach.com","d8rk54i4mohrb.cloudfront.net"]},{name:"Simplestream",category:"content",domains:["*.simplestream.com"]},{name:"Simpli.fi",category:"ad",domains:["*.simpli.fi"]},{name:"Simplicity Marketing",category:"ad",domains:["*.flashtalking.com"]},{name:"SinnerSchrader Deutschland",category:"ad",domains:["*.s2Betrieb.de"]},{name:"Sirv",category:"other",domains:["*.sirv.com"]},{name:"Site Meter",category:"analytics",domains:["*.sitemeter.com"]},{name:"Site24x7 Real User Monitoring",company:"Site24x7",category:"analytics",domains:["*.site24x7rum.com"]},{name:"SiteGainer",category:"analytics",domains:["*.sitegainer.com","d191y0yd6d0jy4.cloudfront.net"]},{name:"SiteScout",company:"Centro",category:"ad",domains:["*.pixel.ad","*.sitescout.com"]},{name:"Siteimprove",category:"utility",domains:["*.siteimprove.com","*.siteimproveanalytics.com"]},{name:"Six Degrees Group",category:"hosting",
domains:["*.fstech.co.uk"]},{name:"Skimbit",category:"ad",domains:["*.redirectingat.com","*.skimresources.com","*.skimresources.net"]},{name:"Skimlinks",category:"ad",domains:["*.skimlinks.com"]},{name:"SkyGlue Technology",category:"analytics",domains:["*.skyglue.com"]},{name:"SkyScanner",category:"content",domains:["*.skyscanner.net"]},{name:"Skybet",company:"Bonne Terre t/a Sky Vegas (Sky)",category:"other",domains:["*.skybet.com"]},{name:"Skype",category:"other",domains:["*.skype.com"]},{name:"Slate Group",category:"content",domains:["*.cdnslate.com"]},{name:"SlimCut Media Outstream",company:"SlimCut Media",category:"ad",domains:["*.freeskreen.com"]},{name:"Smart Insight Tracking",company:"Emarsys",category:"analytics",domains:["*.scarabresearch.com"]},{name:"Smart AdServer",category:"ad",domains:["*.01net.com","*.sascdn.com","*.sasqos.com","*.smartadserver.com"]},{name:"SmartFocus",category:"analytics",
domains:["*.emv2.com","*.emv3.com","*.predictiveintent.com","*.smartfocus.com","*.themessagecloud.com"]},{name:"Smarter Click",category:"ad",domains:["*.smct.co","*.smarterclick.co.uk"]},{name:"SmarterHQ",category:"analytics",domains:["*.smarterhq.io","d1n00d49gkbray.cloudfront.net","*.smarterremarketer.net"]},{name:"Smarttools",category:"customer-success",domains:["*.smartertrack.com"]},{name:"Smartzer",category:"ad",domains:["*.smartzer.com"]},{name:"Snack Media",category:"content",domains:["*.snack-media.com"]},{name:"Snacktools",category:"ad",domains:["*.bannersnack.com"]},{name:"SnapEngage",category:"customer-success",domains:["*.snapengage.com"]},{name:"SnapWidget",category:"content",domains:["*.snapwidget.com"]},{name:"Soasta",category:"analytics",domains:["*.lognormal.net"]},{name:"SociableLabs",category:"ad",domains:["*.sociablelabs.net","*.sociablelabs.com"]},{name:"Social Annex",category:"customer-success",domains:["*.socialannex.com"]},{name:"SocialShopWave",
category:"social",domains:["*.socialshopwave.com"]},{name:"Socialphotos",category:"social",domains:["*.slpht.com"]},{name:"Sociomantic Labs",company:"DunnHumby",category:"ad",domains:["*.sociomantic.com"]},{name:"SodaHead",category:"analytics",domains:["*.sodahead.com"]},{name:"Softwebzone",category:"hosting",domains:["*.softwebzone.com"]},{name:"Sojern",category:"marketing",domains:["*.sojern.com"]},{name:"Sokrati",category:"marketing",domains:["*.sokrati.com"]},{name:"Sonobi",category:"ad",domains:["*.sonobi.com"]},{name:"Sooqr Search",company:"Sooqr",category:"utility",domains:["*.sooqr.com"]},{name:"Sophus3",category:"analytics",domains:["*.s3ae.com","*.sophus3.com"]},{name:"Sorenson Media",category:"content",domains:["*.sorensonmedia.com"]},{name:"Sortable",category:"ad",domains:["*.deployads.com"]},{name:"Sotic",category:"hosting",domains:["*.sotic.net","*.soticservers.net"]},{name:"Soundest",category:"ad",domains:["*.soundestlink.com","*.soundest.net"]},{name:"Sourcepoint",
category:"ad",domains:["*.decenthat.com","*.fallingfalcon.com","*.summerhamster.com","d2lv4zbk7v5f93.cloudfront.net","d3qxwzhswv93jk.cloudfront.net"]},{name:"SourceKnowledge",homepage:"https://www.sourceknowledge.com",category:"ad",domains:["*.provenpixel.com"]},{name:"SpaceNet",category:"hosting",domains:["*.nmm.de"]},{name:"Sparkflow",company:"Intercept Interactive",category:"ad",domains:["*.sparkflow.net"]},{name:"Specific Media",category:"ad",domains:["*.specificmedia.com","*.adviva.net","*.specificclick.net"]},{name:"Spicy",company:"Data-Centric Alliance",category:"ad",domains:["*.sspicy.ru"]},{name:"Spoke",category:"customer-success",domains:["*.121d8.com"]},{name:"Spongecell",category:"ad",domains:["*.spongecell.com"]},{name:"Spot.IM",category:"social",domains:["*.spot.im","*.spotim.market"]},{name:"SpotXchange",category:"ad",domains:["*.spotxcdn.com","*.spotxchange.com","*.spotx.tv"]},{name:"SpringServer",category:"ad",domains:["*.springserve.com"]},{name:"Spylight",
category:"other",domains:["*.spylight.com"]},{name:"SreamAMG",company:"StreamAMG",category:"other",domains:["*.streamamg.com"]},{name:"StackAdapt",category:"ad",domains:["*.stackadapt.com"]},{name:"StackExchange",category:"social",domains:["*.sstatic.net"]},{name:"Stackla PTY",category:"social",domains:["*.stackla.com"]},{name:"Stailamedia",category:"ad",domains:["*.stailamedia.com"]},{name:"Stamped.io",category:"analytics",domains:["*.stamped.io"]},{name:"Starfield Services Root Certificate Authority",company:"Starfield Technologies",category:"utility",domains:["*.starfieldtech.com","ss2.us","*.ss2.us"]},{name:"Starfield Technologies",category:"utility",domains:["*.websiteprotection.com"]},{name:"StatCounter",category:"analytics",domains:["*.statcounter.com"]},{name:"Statful",category:"analytics",domains:["*.statful.com"]},{name:"Steelhouse",category:"ad",domains:["*.steelhousemedia.com"]},{name:"Steepto",category:"ad",domains:["*.steepto.com"]},{name:"StellaService",
category:"analytics",domains:["*.stellaservice.com"]},{name:"StickyADS.tv",category:"ad",domains:["*.stickyadstv.com"]},{name:"STINGRAY",company:"FlexOne",category:"ad",domains:["*.impact-ad.jp"]},{name:"Storify",company:"Adobe Systems",category:"social",domains:["*.storify.com"]},{name:"Storm Tag Manager",company:"Rakuten",category:"tag-manager",domains:["*.stormcontainertag.com"]},{name:"Storygize",category:"ad",domains:["*.storygize.net"]},{name:"Strands",category:"utility",domains:["*.strands.com"]},{name:"StreamRail",category:"ad",domains:["*.streamrail.com","*.streamrail.net"]},{name:"StrikeAd",category:"ad",domains:["*.strikead.com"]},{name:"Struq",company:"Quantcast",category:"ad",domains:["*.struq.com"]},{name:"StrÃ¶er Digital Media",category:"ad",domains:["*.stroeerdigitalmedia.de"]},{name:"StumbleUpon",category:"content",domains:["*.stumble-upon.com","*.stumbleupon.com"]},{name:"Sub2 Technologies",category:"analytics",domains:["*.sub2tech.com"]},{name:"SublimeSkinz",
category:"ad",domains:["*.ayads.co"]},{name:"Sumo Logic",category:"utility",domains:["*.sumologic.com"]},{name:"Sunday Times Driving",category:"content",domains:["*.driving.co.uk"]},{name:"SundaySky",category:"ad",domains:["*.sundaysky.com","dds6m601du5ji.cloudfront.net"]},{name:"Sunrise Integration",category:"utility",domains:["*.sunriseintegration.com"]},{name:"Supertool Network Technology",category:"analytics",domains:["*.miaozhen.com"]},{name:"Survata",category:"analytics",domains:["*.survata.com"]},{name:"SurveyGizmo",category:"analytics",domains:["*.surveygizmo.eu"]},{name:"SurveyMonkey",category:"analytics",domains:["*.surveymonkey.com"]},{name:"Survicate",category:"analytics",domains:["*.survicate.com"]},{name:"Sweet Tooth",category:"ad",domains:["*.sweettooth.io"]},{name:"Swiftype",category:"utility",domains:["*.swiftype.com","*.swiftypecdn.com"]},{name:"Switch Concepts",category:"ad",domains:["*.switchadhub.com"]},{name:"SwitchAds",company:"Switch Concepts",category:"ad",
domains:["*.switchads.com"]},{name:"Swogo",category:"analytics",domains:["*.xsellapp.com"]},{name:"Swoop",category:"ad",domains:["*.swoop.com"]},{name:"Symantec",category:"utility",domains:["*.norton.com","*.symantec.com","*.symcb.com","*.symcd.com"]},{name:"Syncapse",category:"social",domains:["*.clickable.net"]},{name:"Synergetic",category:"ad",domains:["*.synergetic.ag"]},{name:"Synthetix",category:"customer-success",domains:["*.syn-finity.com","*.synthetix-ec1.com","*.synthetix.com"]},{name:"Syte",category:"other",domains:["*.syteapi.com"]},{name:"TINT",category:"content",domains:["*.71n7.com","d33w9bm0n1egwm.cloudfront.net","d36hc0p18k1aoc.cloudfront.net","d3l7tj34e9fc43.cloudfront.net"]},{name:"TNS (Kantar Group)",category:"analytics",domains:["*.tns-counter.ru"]},{name:"TRUSTe",category:"utility",domains:["*.truste.com"]},{name:"TV Genius",company:"Ericcson Media Services",category:"content",domains:["*.tvgenius.net"]},{name:"TVSquared",category:"ad",domains:["*.tvsquared.com"]
},{name:"TVTY",category:"ad",domains:["*.distribeo.com","*.ogigl.com"]},{name:"Tactics bvba",category:"hosting",domains:["*.influid.co"]},{name:"Tag Inspector",company:"InfoTrust",category:"analytics",domains:["d22xmn10vbouk4.cloudfront.net"]},{name:"TagCommander",category:"tag-manager",domains:["*.commander1.com","*.tagcommander.com"]},{name:"Tagboard",category:"social",domains:["*.tagboard.com"]},{name:"Taggstar",company:"Taggstar UK",category:"ad",domains:["*.taggstar.com"]},{name:"Tail Target",company:"Tail",category:"ad",domains:["*.tailtarget.com"]},{name:"Tailored",category:"other",domains:["d24qm7bu56swjs.cloudfront.net","dw3vahmen1rfy.cloudfront.net","*.tailored.to"]},{name:"Taleo Enterprise Cloud Service",company:"Oracle",category:"content",domains:["*.taleo.net"]},{name:"Talkable",category:"ad",domains:["*.talkable.com","d2jjzw81hqbuqv.cloudfront.net"]},{name:"TapSense",category:"ad",domains:["*.tapsense.com"]},{name:"Tapad",category:"ad",domains:["*.tapad.com"]},{
name:"Teads",category:"ad",domains:["*.teads.tv"]},{name:"Team Internet Tonic",company:"Team Internet",category:"ad",domains:["*.dntrax.com"]},{name:"TechTarget",category:"content",domains:["*.techtarget.com","*.ttgtmedia.com"]},{name:"Technorati",company:"Synacor",category:"ad",domains:["*.technoratimedia.com"]},{name:"Teedhaze",category:"content",domains:["*.fuel451.com"]},{name:"Tell Apart",category:"analytics",domains:["*.tellapart.com","*.tellaparts.com"]},{name:"Tencent",category:"content",domains:["*.qq.com","*.ywxi.net"]},{name:"Thanx Media",category:"utility",domains:["*.hawksearch.info"]},{name:"Thawte",category:"utility",domains:["*.thawte.com"]},{name:"Thesis",category:"analytics",homepage:"https://www.thesistesting.com/",domains:["*.ttsep.com"]},{name:"The AA",category:"ad",domains:["*.adstheaa.com"]},{name:"The ADEX",category:"ad",domains:["*.theadex.com"]},{name:"The Best Day",category:"social",domains:["*.thebestday.com"]},{name:"The Filter",company:"Exabre",
category:"analytics",domains:["*.thefilter.com"]},{name:"The Guardian",category:"analytics",domains:["*.ophan.co.uk"]},{name:"The Hut Group",category:"content",domains:["*.thcdn.com"]},{name:"The Numa Group",category:"other",domains:["*.hittail.com"]},{name:"The Publisher Desk",category:"ad",domains:["*.206ads.com","*.publisherdesk.com"]},{name:"The Sydney Morning Herald",company:"Fairfax Media",category:"content",domains:["*.smh.com.au"]},{name:"The Wall Street Jounal",category:"content",domains:["*.wsj.net"]},{name:"The Wall Street Journal",category:"content",domains:["*.marketwatch.com"]},{name:"TheFind",category:"content",domains:["*.thefind.com"]},{name:"Thinglink",category:"utility",domains:["*.thinglink.com"]},{name:"Thirdpresence",category:"ad",domains:["*.thirdpresence.com"]},{name:"ThreatMetrix",category:"utility",domains:["*.online-metrix.net"]},{name:"Throtle",homepage:"https://throtle.io/",category:"analytics",domains:["*.thrtle.com","*.v12group.com"]},{
name:"TicketMaster",category:"content",domains:["*.t-x.io","*.tmcs.net"]},{name:"TikTok",company:"ByteDance Ltd",homepage:"https://www.tiktok.com/en/",category:"social",domains:["*.tiktok.com","*.ipstatp.com"]},{name:"Tidio Live Chat",company:"Tidio",homepage:"https://www.tidiochat.com/en/",category:"customer-success",domains:["*.tidiochat.com"]},{name:"Tiledesk Live Chat",company:"Tiledesk SRL",homepage:"https://www.tiledesk.com/",category:"customer-success",domains:["*.tiledesk.com"]},{name:"Time",category:"content",domains:["*.timeinc.net"]},{name:"Time2Perf",category:"ad",domains:["*.time2perf.com"]},{name:"TinyURL",category:"utility",domains:["*.tinyurl.com"]},{name:"Tivo",category:"analytics",domains:["*.rovicorp.com"]},{name:"Tom&Co",category:"hosting",domains:["*.tomandco.uk"]},{name:"Toms Native Ads",company:"Purch",category:"ad",domains:["*.natoms.com"]},{name:"ToneMedia",category:"ad",domains:["*.clickfuse.com"]},{name:"Tonic",company:"Team Internet",category:"ad",
domains:["*.dntx.com"]},{name:"Touch Commerce",category:"customer-success",domains:["*.inq.com","*.touchcommerce.com"]},{name:"ToutApp",category:"ad",domains:["*.toutapp.com"]},{name:"TraceView",company:"Solarwinds",category:"analytics",domains:["*.tracelytics.com","d2gfdmu30u15x7.cloudfront.net"]},{name:"TrackJS",category:"analytics",domains:["*.trackjs.com","d2zah9y47r7bi2.cloudfront.net"]},{name:"Tradedoubler",category:"ad",domains:["*.pvnsolutions.com","*.tradedoubler.com"]},{name:"Tradelab",category:"ad",domains:["*.tradelab.fr"]},{name:"TrafficFactory",category:"ad",domains:["*.trafficfactory.biz"]},{name:"TrafficHunt",category:"ad",domains:["*.traffichunt.com"]},{name:"TrafficStars",category:"ad",domains:["*.trafficstars.com","*.tsyndicate.com"]},{name:"Transifex",category:"utility",domains:["*.transifex.com"]},{name:"Travelex",category:"utility",domains:["*.travelex.net","*.travelex.co.uk"]},{name:"Travelocity Canada",company:"Travelocity",category:"content",
domains:["*.travelocity.ca"]},{name:"Travelocity USA",company:"Travelocity",category:"content",domains:["*.travelocity.com"]},{name:"Travelzoo",category:"content",domains:["*.travelzoo.com"]},{name:"Treasure Data",category:"analytics",domains:["*.treasuredata.com"]},{name:"Tremor Video",category:"ad",domains:["*.tremorhub.com","*.videohub.tv"]},{name:"Trialfire",category:"analytics",domains:["*.trialfire.com"]},{name:"Tribal Fusion",company:"Exponential Interactive",category:"ad",domains:["*.tribalfusion.com"]},{name:"Triblio",category:"marketing",domains:["*.tribl.io"]},{name:"Triggered Messaging",company:"Fresh Relevance",category:"ad",domains:["*.triggeredmessaging.com"]},{name:"Trinity Mirror",category:"content",domains:["*.mirror.co.uk"]},{name:"Trinity Mirror Digital Media",category:"social",domains:["*.tm-aws.com","*.icnetwork.co.uk"]},{name:"TripAdvisor",category:"content",
domains:["*.jscache.com","*.tacdn.com","*.tamgrt.com","*.tripadvisor.com","*.viator.com","*.tripadvisor.co.uk"]},{name:"TripleLift",category:"ad",domains:["*.3lift.com"]},{name:"Tru Optik",category:"ad",domains:["*.truoptik.com"]},{name:"TruConversion",category:"analytics",domains:["*.truconversion.com"]},{name:"Trueffect",category:"marketing",domains:["*.adlegend.com"]},{name:"Truefit",category:"analytics",domains:["*.truefitcorp.com"]},{name:"Trust Guard",category:"utility",domains:["*.trust-guard.com"]},{name:"Trust Pilot",category:"analytics",domains:["*.trustpilot.com"]},{name:"Amazon Trust Services",company:"Amazon",category:"utility",domains:["*.amazontrust.com","o.ss2.us"]},{name:"Google Trust Services",company:"Google",category:"utility",domains:["*.pki.goog"]},{name:"Let's Encrypt",homepage:"https://letsencrypt.org/",category:"utility",domains:["*.letsencrypt.org"]},{name:"TrustX",category:"ad",domains:["*.trustx.org"]},{name:"Trusted Shops",category:"utility",
domains:["*.trustedshops.com"]},{name:"Trustev",company:"TransUnion",category:"utility",domains:["*.trustev.com"]},{name:"Trustwave",category:"utility",domains:["*.trustwave.com"]},{name:"Tryzens TradeState",company:"Tryzens",category:"analytics",domains:["*.tryzens-analytics.com"]},{name:"TubeMogul",category:"ad",domains:["*.tubemogul.com"]},{name:"Turn",category:"ad",domains:["*.turn.com"]},{name:"Tutorialize",category:"customer-success",domains:["*.tutorialize.me"]},{name:"Twenga",category:"content",domains:["*.twenga.fr","*.c4tw.net","*.twenga.co.uk"]},{name:"Twitframe",company:"Superblock",category:"utility",domains:["*.twitframe.com"]},{name:"Twitter Online Conversion Tracking",company:"Twitter",category:"ad",domains:["*.ads-twitter.com","analytics.twitter.com"]},{name:"Twitter Short URL",company:"Twitter",category:"social",domains:["*.t.co"]},{name:"Twyn Group",category:"ad",domains:["*.twyn.com"]},{name:"Tynt",company:"33 Across",category:"ad",domains:["*.tynt.com"]},{
name:"Typepad",category:"hosting",domains:["*.typepad.com"]},{name:"TyrbooBytes",category:"utility",domains:["*.turbobytes.net"]},{name:"UPS i-parcel",company:"UPS",category:"other",domains:["*.i-parcel.com"]},{name:"US Media Consulting",category:"ad",domains:["*.mediade.sk"]},{name:"Ubertags",category:"tag-manager",domains:["*.ubertags.com"]},{name:"Umbel",category:"analytics",domains:["*.umbel.com"]},{name:"Unanimis",company:"Switch",category:"ad",domains:["*.unanimis.co.uk"]},{name:"Unbounce",category:"ad",domains:["*.ubembed.com","*.unbounce.com","d2xxq4ijfwetlm.cloudfront.net","d9hhrg4mnvzow.cloudfront.net"]},{name:"Underdog Media",category:"ad",domains:["*.underdog.media","*.udmserve.net"]},{name:"Understand Digital",category:"ad",domains:["*.redirecting2.net"]},{name:"Undertone",company:"Perion",category:"ad",domains:["*.legolas-media.com"]},{name:"Unidays",category:"ad",domains:["*.myunidays.com","*.unidays.world"]},{name:"Uniqodo",category:"ad",domains:["*.uniqodo.com"]},{
name:"Unite",category:"ad",domains:["*.uadx.com"]},{name:"United Card Services",category:"utility",domains:["*.ucs.su"]},{name:"United Internet",category:"hosting",domains:["*.uicdn.com"]},{name:"United Internet Media",category:"ad",domains:["*.ui-portal.de"]},{name:"United Internet Media AG",category:"hosting",domains:["*.tifbs.net","*.uicdn.net","*.uimserv.net"]},{name:"Unknown",category:"other",domains:[]},{name:"Unruly Media",category:"ad",domains:["*.unrulymedia.com"]},{name:"UpBuild",category:"ad",domains:["*.upbuild.io"]},{name:"UpSellit",category:"analytics",domains:["*.upsellit.com"]},{name:"Upland Software",category:"hosting",domains:["*.clickability.com"]},{name:"Airship",category:"marketing",domains:["*.urbanairship.com","*.aswpsdkus.com"]},{name:"UsabilityTools",category:"analytics",domains:["*.usabilitytools.com"]},{name:"Usablenet.net",category:"utility",domains:["*.usablenet.net"]},{name:"Use It Better",category:"analytics",domains:["*.useitbetter.com"]},{
name:"User Replay",category:"analytics",domains:["*.userreplay.net"]},{name:"UserReport",category:"analytics",domains:["*.userreport.com"]},{name:"Userneeds",category:"analytics",domains:["*.userneeds.dk"]},{name:"Userzoom",category:"analytics",domains:["*.userzoom.com"]},{name:"V12 Retail Finance",category:"utility",domains:["*.v12finance.com"]},{name:"Vacaciones eDreams",category:"content",domains:["*.odistatic.net"]},{name:"Varick Media Management",category:"ad",domains:["*.vmmpxl.com"]},{name:"Vdopia Chocolate",company:"Vdopia",category:"ad",domains:["*.vdopia.com"]},{name:"Ve",company:"Ve",homepage:"https://www.ve.com/",category:"marketing",domains:["*.veinteractive.com","*.ve.com"]},{name:"Ve Interactive",company:"Ve",category:"ad",domains:["*.vepxl1.net","*.adgenie.co.uk"]},{name:"Vee24",category:"customer-success",domains:["*.vee24.com"]},{name:"Veeseo",category:"content",domains:["*.veeseo.com"]},{name:"Venatus Media",category:"marketing",
domains:["*.alcvid.com","*.venatusmedia.com"]},{name:"Veoxa",category:"ad",domains:["*.veoxa.com"]},{name:"Vergic AB",category:"customer-success",domains:["*.psplugin.com"]},{name:"Vergic Engage Platform",company:"Vergic",category:"customer-success",domains:["*.vergic.com"]},{name:"Verisign (Symantec)",category:"utility",domains:["*.verisign.com"]},{name:"Verizon",category:"utility",domains:["*.public-trust.com"]},{name:"Verizon Digital Media CDN",homepage:"https://www.verizondigitalmedia.com/",category:"cdn",domains:["*.edgecastcdn.net","*.edgecastdns.net"]},{name:"Verizon Uplynk",company:"Verizon",category:"content",domains:["*.uplynk.com"]},{name:"Vero",company:"Semblance",category:"ad",domains:["*.getvero.com","d3qxef4rp70elm.cloudfront.net"]},{name:"VertaMedia",category:"ad",domains:["*.vertamedia.com"]},{name:"Vertical Mass",category:"ad",domains:["*.vmweb.net"]},{name:"Vestorly",category:"ad",domains:["*.oodalab.com"]},{name:"Vextras",category:"other",domains:["*.vextras.com"]
},{name:"Viacom",category:"content",domains:["*.mtvnservices.com"]},{name:"Vibrant Media",category:"ad",domains:["*.intellitxt.com","*.picadmedia.com"]},{name:"VidPulse",category:"analytics",domains:["*.vidpulse.com"]},{name:"Video Media Groep",category:"ad",domains:["*.vmg.host","*.inpagevideo.nl"]},{name:"VideoHub",company:"Tremor Video",category:"ad",domains:["*.scanscout.com"]},{name:"Videology",category:"ad",domains:["*.tidaltv.com"]},{name:"Vidible",category:"ad",domains:["*.vidible.tv"]},{name:"VigLink",category:"ad",domains:["*.viglink.com"]},{name:"Vindico",company:"Viant",category:"ad",domains:["*.vindicosuite.com"]},{name:"Viocorp International",category:"content",domains:["*.vioapi.com"]},{name:"ViralNinjas",category:"ad",domains:["*.viralninjas.com"]},{name:"Virool",category:"ad",domains:["*.virool.com"]},{name:"Virtual Earth",company:"Microsoft",category:"utility",domains:["*.virtualearth.net"]},{name:"Visely",company:"Visely",category:"other",
homepage:"https://visely.io/",domains:["*.visely.io"]},{name:"VisScore",category:"analytics",domains:["*.visscore.com","d2hkbi3gan6yg6.cloudfront.net"]},{name:"Visible Measures",category:"ad",domains:["*.visiblemeasures.com"]},{name:"Visual Studio",company:"Microsoft",category:"utility",domains:["*.visualstudio.com"]},{name:"VisualDNA",category:"ad",domains:["*.visualdna.com"]},{name:"VisualVisitor",category:"ad",domains:["*.id-visitors.com"]},{name:"Vivocha S.p.A",category:"customer-success",domains:["*.vivocha.com"]},{name:"Vizu (Nielsen)",category:"analytics",domains:["*.vizu.com"]},{name:"Vizury",category:"ad",domains:["*.vizury.com"]},{name:"VoiceFive",category:"analytics",domains:["*.voicefive.com"]},{name:"Volvelle",company:"Optomaton",category:"ad",domains:["*.volvelle.tech"]},{name:"VouchedFor",category:"analytics",domains:["*.vouchedfor.co.uk"]},{name:"WARPCACHE",category:"utility",domains:["*.warpcache.net"]},{name:"WISHLIST",company:"Shopapps",category:"social",
domains:["*.shopapps.in"]},{name:"WP Engine",category:"hosting",domains:["*.wpengine.com"]},{name:"WalkMe",category:"customer-success",domains:["*.walkme.com"]},{name:"Watching That",category:"other",domains:["*.watchingthat.com"]},{name:"Wayfair",category:"analytics",domains:["*.wayfair.com"]},{name:"Web CEO",category:"other",domains:["*.websiteceo.com"]},{name:"Web Dissector",company:"Beijing Gridsum Technologies",category:"analytics",domains:["*.gridsumdissector.com","*.webdissector.com"]},{name:"Web Forensics",category:"analytics",domains:["*.webforensics.co.uk"]},{name:"Web Security and Performance",company:"NCC Group",category:"utility",domains:["*.nccgroup.trust"]},{name:"WebEngage",category:"customer-success",domains:["*.webengage.co","*.webengage.com","d23nd6ymopvz52.cloudfront.net","d3701cc9l7v9a6.cloudfront.net"]},{name:"WebInsight",company:"dotMailer",category:"analytics",domains:["*.trackedlink.net","*.trackedweb.net"]},{name:"WebPageOne Solutions",category:"other",
domains:["*.webpageone.com"]},{name:"WebSpectator",category:"ad",domains:["*.webspectator.com"]},{name:"WebTuna",company:"Application Performance",category:"analytics",domains:["*.webtuna.com"]},{name:"WebVideoCore",company:"StreamingVideoProvider",category:"content",domains:["*.webvideocore.net"]},{name:"WebWombat",category:"utility",domains:["*.ic.com.au"]},{name:"Webcollage",category:"customer-success",domains:["*.webcollage.net"]},{name:"Webcore",category:"ad",domains:["*.onefeed.co.uk"]},{name:"Webkul",company:"Webkul Software",category:"utility",domains:["*.webkul.com"]},{name:"Webmarked",category:"utility",domains:["*.webmarked.net"]},{name:"Weborama",category:"ad",domains:["*.weborama.com","*.weborama.fr"]},{name:"WebpageFX",category:"ad",domains:["*.leadmanagerfx.com"]},{name:"Webphone",company:"IP WEB SERVICES",category:"customer-success",domains:["*.webphone.net"]},{name:"Webselect selectcommerce",company:"Webselect Internet",category:"hosting",domains:["*.webselect.net"]},{
name:"Webthinking",category:"hosting",domains:["*.webthinking.co.uk"]},{name:"Webtrekk",category:"analytics",domains:["*.wbtrk.net","*.webtrekk-asia.net","*.webtrekk.net","*.wt-eu02.net","*.wt-safetag.com"]},{name:"Webtrends",category:"analytics",domains:["*.webtrends.com","*.webtrendslive.com","d1q62gfb8siqnm.cloudfront.net"]},{name:"Webtype",category:"cdn",domains:["*.webtype.com"]},{name:"White Ops",category:"utility",domains:["*.acexedge.com","*.tagsrvcs.com"]},{name:"Whitespace",category:"ad",domains:["*.whitespacers.com"]},{name:"WhosOn Live Chat Software",category:"customer-success",domains:["*.whoson.com"]},{name:"Wibbitz",category:"other",domains:["*.wibbitz.com"]},{name:"Wide Area Communications",category:"hosting",domains:["*.widearea.co.uk"]},{name:"WideOrbit",category:"marketing",domains:["*.admaym.com"]},{name:"William Reed",category:"content",domains:["*.wrbm.com"]},{name:"WillyFogg.com",category:"content",domains:["*.willyfogg.com"]},{name:"Windows",company:"Microsoft",
category:"utility",domains:["*.windowsupdate.com"]},{name:"WisePops",category:"utility",domains:["*.wisepops.com"]},{name:"Wishlist King",company:"Appmate",category:"other",homepage:"https://appmate.io/",domains:["*.appmate.io"]},{name:"Wishpond Technologies",category:"marketing",domains:["*.wishpond.com","*.wishpond.net"]},{name:"WizRocket Technologies",category:"analytics",domains:["*.wzrkt.com"]},{name:"Woopra",category:"analytics",domains:["*.woopra.com"]},{name:"Woosmap",category:"utility",domains:["*.woosmap.com"]},{name:"WorkCast",category:"hosting",domains:["*.workcast.net"]},{name:"World News Media",category:"content",domains:["*.wnmedia.co.uk"]},{name:"Worldpay",category:"utility",domains:["*.worldpay.com"]},{name:"Wow Analytics",category:"analytics",domains:["*.wowanalytics.co.uk"]},{name:"Wowcher",category:"ad",domains:["*.wowcher.co.uk"]},{name:"Wufoo",category:"utility",domains:["*.wufoo.com"]},{name:"Wunderkind",category:"marketing",homepage:"https://www.wunderkind.co/",
domains:["*.bounceexchange.com","*.bouncex.net","*.wknd.ai","*.cdnbasket.net","*.cdnwidget.com"]},{name:"Wyng",category:"ad",domains:["*.offerpop.com"]},{name:"XMLSHOP",category:"hosting",domains:["*.xmlshop.biz"]},{name:"XiTi",company:"AT Internet",category:"analytics",domains:["*.xiti.com","*.aticdn.net"],homepage:"https://www.atinternet.com/en/"},{name:"YUDU",category:"content",domains:["*.yudu.com"]},{name:"Yahoo! Ad Exchange",company:"Yahoo!",category:"ad",domains:["*.yieldmanager.com","*.browsiprod.com"]},{name:"Yahoo! JAPAN Ads",company:"Yahoo! JAPAN",category:"ad",homepage:"https://marketing.yahoo.co.jp/service/yahooads/",domains:["yads.c.yimg.jp","s.yimg.jp","b92.yahoo.co.jp"]},{name:"Yahoo! Tag Manager",company:"Yahoo! JAPAN",category:"tag-manager",homepage:"https://marketing.yahoo.co.jp/service/tagmanager/",domains:["*.yjtag.jp"]},{name:"Yahoo! Small Business",company:"Yahoo!",category:"hosting",domains:["*.aabacosmallbusiness.com"]},{name:"Yellow Robot",category:"ad",
domains:["*.backinstock.org"]},{name:"YieldPartners",category:"ad",domains:["*.yieldpartners.com"]},{name:"Yieldbot",category:"ad",domains:["*.yldbt.com"]},{name:"Yieldify",category:"ad",domains:["*.yieldify.com","*.yieldifylabs.com","d33wq5gej88ld6.cloudfront.net","dwmvwp56lzq5t.cloudfront.net"]},{name:"Yieldlab",category:"ad",domains:["*.yieldlab.net"]},{name:"Yieldmo",category:"ad",domains:["*.yieldmo.com"]},{name:"Yieldr",category:"ad",domains:["*.254a.com"]},{name:"Yo",category:"utility",domains:["*.yopify.com"]},{name:"YoYo",category:"utility",domains:["*.goadservices.com"]},{name:"Yotpo",homepage:"https://www.yotpo.com/",category:"marketing",domains:["*.yotpo.com","*.swellrewards.com"]},{name:"Yottaa",category:"hosting",domains:["*.yottaa.com","*.yottaa.net"]},{name:"YourAmigo",category:"utility",domains:["*.youramigo.com"]},{name:"YuMe",category:"ad",domains:["*.yume.com","*.yumenetworks.com"]},{name:"Yummley",category:"other",domains:["*.yummly.com"]},{name:"ZEDO",
category:"ad",domains:["*.zedo.com"]},{name:"Zafu",category:"analytics",domains:["*.zafu.com"]},{name:"Zaius",category:"ad",domains:["*.zaius.com"]},{name:"Zamplus ad",category:"ad",domains:["*.zampda.net"]},{name:"Zanox",category:"ad",domains:["*.zanox.com","*.zanox.ws"]},{name:"Zapper",category:"utility",domains:["*.zapper.com"]},{name:"Zarget",category:"analytics",domains:["*.zarget.com"]},{name:"Zemanta",category:"ad",domains:["*.zemanta.com"]},{name:"Zen Internet",category:"other",domains:["*.zyen.com"]},{name:"Zenovia Digital Exchange",category:"ad",domains:["*.rhythmxchange.com","*.zenoviaexchange.com"]},{name:"ZergNet",category:"content",domains:["*.zergnet.com"]},{name:"Zerogrey",category:"hosting",domains:["*.zerogrey.com"]},{name:"Ziff Davis Tech",category:"ad",domains:["*.adziff.com","*.zdbb.net"]},{name:"Zmags",category:"marketing",domains:["*.zmags.com"]},{name:"Zolando",category:"content",domains:["*.ztat.net"]},{name:"Zoover",category:"analytics",
domains:["*.zoover.nl","*.zoover.co.uk"]},{name:"Zopim",category:"customer-success",domains:["*.zopim.io"]},{name:"[24]7",category:"customer-success",domains:["*.247-inc.net","*.247inc.net","d1af033869koo7.cloudfront.net"]},{name:"adKernel",category:"ad",domains:["*.adkernel.com"]},{name:"adMarketplace",company:"AMPexchange",category:"ad",domains:["*.ampxchange.com","*.admarketplace.net"]},{name:"addtocalendar",category:"utility",domains:["*.addtocalendar.com"]},{name:"adnanny",category:"ad",domains:["*.adserver01.de"]},{name:"affilinet",category:"ad",domains:["*.reussissonsensemble.fr","*.successfultogether.co.uk"]},{name:"audioBoom",category:"social",domains:["*.audioboom.com","*.audioboo.fm"]},{name:"bPay by Barclaycard",company:"Barclays Bank",category:"utility",domains:["*.bpay.co.uk"]},{name:"bRealTime",category:"ad",domains:["*.brealtime.com"]},{name:"bd4travel",category:"analytics",domains:["*.bd4travel.com"]},{name:"bizinformation-VOID",company:"bizinformation",
category:"analytics",domains:["*.bizinformation.org"]},{name:"carrot",category:"social",domains:["*.sharebutton.co"]},{name:"cloudIQ",category:"analytics",domains:["*.cloud-iq.com"]},{name:"comScore",category:"analytics",domains:["*.adxpose.com","*.comscore.com","*.sitestat.com","*.zqtk.net"]},{name:"content.ad",category:"ad",domains:["*.content.ad"]},{name:"d3 Media",company:"d3 Technologies",category:"other",domains:["*.d3sv.net"]},{name:"dexiMEDIA",category:"ad",domains:["*.deximedia.com"]},{name:"dianomi",category:"ad",domains:["*.dianomi.com","*.dianomioffers.co.uk"]},{name:"donReach",category:"social",domains:["*.donreach.com"]},{name:"dotMailer",category:"ad",domains:["*.dmtrk.com","*.dotmailer.com","*.emlfiles.com"]},{name:"dotMailer Surveys",company:"dotMailer",category:"analytics",domains:["*.dotmailer-surveys.com"]},{name:"dstillery",category:"ad",domains:["*.dstillery.com","*.media6degrees.com"]},{name:"eBay",category:"ad",
domains:["*.ebay.com","*.ebayimg.com","*.fetchback.com"]},{name:"eBay Enterprise",category:"hosting",domains:["*.csdata1.com","*.gsipartners.com"]},{name:"eBuzzing",company:"Teads Managed Services",category:"ad",domains:["*.ebz.io"]},{name:"eDigital Research",category:"customer-success",domains:["*.edigitalresearch.com","*.edigitalsurvey.com","*.edrcdn.com","*.ecustomeropinions.com"]},{name:"eGain",category:"analytics",domains:["*.analytics-egain.com","*.egain.com"]},{name:"eHost",category:"hosting",domains:["*.ehosts.net"]},{name:"eKomi",category:"analytics",domains:["*.ekomi.com","*.ekomi.de"]},{name:"eWAY",company:"Web Active Pty",category:"utility",domains:["*.eway.com.au"]},{name:"eXTReMe digital",category:"analytics",domains:["*.extreme-dm.com"]},{name:"eXelate",category:"ad",domains:["*.exelator.com"]},{name:"ecommercefeed.net",category:"marketing",domains:["*.ecommercefeed.net"]},{name:"engage:BDR",category:"ad",domains:["*.bnmla.com","*.ebdr3.com"]},{name:"epago",
category:"ad",domains:["*.adaos-ads.net"]},{name:"epoq internet services",category:"analytics",domains:["*.epoq.de"]},{name:"etouches",category:"hosting",domains:["*.etouches.com"]},{name:"etracker",category:"analytics",domains:["*.etracker.com","*.etracker.de"]},{name:"everestads.com",category:"content",domains:["*.verestads.net"]},{name:"exebid.DCA",company:"Data-Centric Alliance",category:"ad",domains:["*.exe.bid"]},{name:"eyeReturn Marketing",category:"marketing",domains:["*.eyereturn.com"]},{name:"feedoptimise",category:"hosting",domains:["*.feedoptimise.com","d1w78njrm56n7g.cloudfront.net"]},{name:"fifty-five",category:"ad",domains:["*.55labs.com"]},{name:"fluct",category:"ad",domains:["*.adingo.jp"]},{name:"freegeoip.net",company:"(community-funded)",category:"utility",domains:["*.freegeoip.net"]},{name:"freewheel.tv",category:"content",domains:["*.fwmrm.net"]},{name:"gnatta",category:"customer-success",domains:["*.gnatta.com"]},{name:"home.pl",category:"hosting",
domains:["*.nscontext.eu"]},{name:"hyfn",category:"ad",domains:["*.hyfn.com"]},{name:"iAdvize SAS",category:"customer-success",domains:["*.iadvize.com"]},{name:"iBillboard",category:"ad",domains:["*.ibillboard.com"]},{name:"iCrossing",category:"ad",domains:["*.ic-live.com"]},{name:"iFactory",company:"RDW Group",category:"hosting",domains:["*.ifactory.com"]},{name:"iGoDigital",category:"analytics",domains:["*.igodigital.com"]},{name:"iJento",company:"Fopsha",category:"ad",domains:["*.ijento.com"]},{name:"iPage",category:"hosting",domains:["*.ipage.com"]},{name:"iPerceptions",category:"customer-success",domains:["*.iperceptions.com"]},{name:"iTunes",company:"Apple",category:"content",domains:["*.mzstatic.com"]},{name:"imgix",company:"Zebrafish Labs",category:"utility",domains:["*.imgix.net"]},{name:"infogr.am",category:"utility",domains:["*.infogr.am","*.jifo.co"]},{name:"iotec",category:"analytics",domains:["*.dsp.io"]},{name:"iovation",category:"utility",domains:["*.iesnare.com"]},{
name:"ipinfo.io",category:"utility",domains:["*.ipinfo.io"]},{name:"issuu",category:"content",domains:["*.issuu.com","*.isu.pub"]},{name:"iubenda",category:"utility",domains:["*.iubenda.com"]},{name:"j2 Cloud Services",category:"ad",domains:["*.campaigner.com"]},{name:"jsonip.com",category:"analytics",domains:["*.jsonip.com"]},{name:"linkpulse",category:"analytics",domains:["*.lp4.io"]},{name:"loGo_net",category:"analytics",domains:["*.logo-net.co.uk"]},{name:"mainADV",category:"ad",domains:["*.httptrack.com","*.solocpm.com"]},{name:"mbr targeting",category:"ad",domains:["*.m6r.eu"]},{name:"media.ventive",category:"ad",domains:["*.contentspread.net"]},{name:"metrigo",category:"ad",domains:["*.metrigo.com"]},{name:"minicabit.com",category:"content",domains:["*.minicabit.com"]},{name:"mobiManage",category:"hosting",domains:["*.mobimanage.com"]},{name:"moving-pictures",category:"other",domains:["*.moving-pictures.biz","*.v6-moving-pictures.com","*.vtstat.com","*.moving-pictures.de"]},{
name:"my6sense",category:"ad",domains:["*.mynativeplatform.com"]},{name:"myThings",category:"ad",domains:["*.mythings.com","*.mythingsmedia.net"]},{name:"mymovies",category:"content",domains:["*.mymovies.net"]},{name:"nRelate-VOID",company:"nRelate",category:"content",domains:["*.nrelate.com"]},{name:"nToklo",category:"analytics",domains:["*.ntoklo.com"]},{name:"neXeps",category:"ad",domains:["*.nexeps.com"]},{name:"ninemsn Pty.",category:"utility",domains:["*.ninemsn.com.au"]},{name:"nugg.ad",category:"ad",domains:["*.nuggad.net"]},{name:"numero interactive",company:"numero",category:"ad",domains:["*.numerointeractive.com"]},{name:"optMD",company:"Optimax Media Delivery",category:"ad",domains:["*.optmd.com"]},{name:"otracking.com",category:"analytics",domains:["*.otracking.com"]},{name:"paysafecard",company:"Paysafe Group",category:"utility",domains:["*.paysafecard.com"]},{name:"piano",category:"ad",domains:["*.npttech.com","*.tinypass.com"]},{name:"piclike",category:"ad",
domains:["*.piclike.us"]},{name:"placehold.it",category:"utility",domains:["*.placehold.it"]},{name:"plista",category:"ad",domains:["*.plista.com"]},{name:"prebid.org",category:"utility",domains:["*.prebid.org"]},{name:"reEmbed",category:"other",domains:["*.reembed.com"]},{name:"reddit",category:"social",domains:["*.reddit.com","*.redditstatic.com"]},{name:"rewardStyle.com",category:"ad",domains:["*.rewardstyle.com"]},{name:"rss2json",category:"utility",domains:["*.rss2json.com"]},{name:"sage Pay",company:"Sage Pay Europe",category:"utility",domains:["*.sagepay.com"]},{name:"section.io",category:"utility",domains:["*.squixa.net"]},{name:"smartclip",category:"ad",domains:["*.smartclip.net"]},{name:"sovrn",category:"ad",domains:["*.lijit.com"]},{name:"stackpile.io",company:"StackPile",category:"tag-manager",domains:["*.stackpile.io"]},{name:"template-help.com",category:"hosting",domains:["*.template-help.com"]},{name:"test",company:"test only",category:"other",
domains:["*.testtesttest.com"]},{name:"trueAnthem",category:"social",domains:["*.tru.am"]},{name:"tweetmeme-VOID",company:"tweetmeme",category:"analytics",domains:["*.tweetmeme.com"]},{name:"uLogin",category:"other",domains:["*.ulogin.ru"]},{name:"uLogix",category:"ad",domains:["*.ulogix.ru"]},{name:"ucfunnel ucX",company:"ucfunnel",category:"ad",domains:["*.aralego.com"]},{name:"up-value",category:"ad",domains:["*.up-value.de"]},{name:"wywy",category:"ad",domains:["*.wywy.com","*.wywyuserservice.com"]},{name:"CDK Dealer Management",company:"CDK Global",homepage:"https://www.cdkglobal.com/us",category:"hosting",domains:["*.assets-cdk.com"]},{name:"fam",company:"Fing Co Ltd.",homepage:"http://admin.fam-ad.com/report/",category:"ad",domains:["*.fam-ad.com"]},{name:"zypmedia",category:"ad",domains:["*.extend.tv"]},{name:"codigo",homepage:"https://www.codigo.se",category:"analytics",domains:["*.codigo.se"]},{name:"Playground",homepage:"https://playground.xyz",category:"ad",
domains:["*.playground.xyz"]},{name:"RAM",homepage:"https://www2.rampanel.com/",category:"analytics",domains:["*.rampanel.com"]},{name:"Adition",homepage:"https://www.adition.com",category:"ad",domains:["*.adition.com"]},{name:"Widespace",homepage:"https://www.widespace.com",category:"ad",domains:["*.widespace.com"]},{name:"Colpirio",homepage:"https://www.widespace.com",category:"analytics",domains:["*.colpirio.com"]},{name:"Brandmetrics",homepage:"https://www.brandmetrics.com",category:"analytics",domains:["*.brandmetrics.com"]},{name:"EasyAd",homepage:"https://web.easy-ads.com/",category:"ad",domains:["*.easy-ads.com"]},{name:"Glimr",homepage:"https://glimr.io/",category:"analytics",domains:["*.glimr.io"]},{name:"Webtreck",homepage:"https://www.webtrekk.com/en/home/",category:"analytics",domains:["*.wcfbc.net"]},{name:"DigiTrust",homepage:"http://www.digitru.st/",category:"analytics",domains:["*.digitru.st"]},{name:"Kantar Sifo",homepage:"https://www.kantarsifo.se",
category:"analytics",domains:["*.research-int.se"]},{name:"Concert",homepage:"https://concert.io/",category:"ad",domains:["*.concert.io"]},{name:"Emerse",homepage:"https://www.emerse.com/",category:"ad",domains:["*.emerse.com"]},{name:"Iterate",homepage:"https://iteratehq.com/",category:"analytics",domains:["*.iteratehq.com"]},{name:"Cookiebot",homepage:"https://www.cookiebot.com/",category:"utility",domains:["*.cookiebot.com"]},{name:"Netlify",homepage:"https://www.netlify.com/",category:"utility",domains:["*.netlify.com","*.netlifyusercontent.com"]},{name:"Scroll",homepage:"https://scroll.com/",category:"utility",domains:["*.scroll.com"]},{name:"Consumable",homepage:"https://consumable.com/",category:"ad",domains:["*.serverbid.com"]},{name:"DMD Marketing",homepage:"https://www.dmdconnects.com/",category:"ad",domains:["*.medtargetsystem.com"]},{name:"Catchpoint",homepage:"https://www.catchpoint.com/",category:"analytics",domains:["*.3gl.net"]},{name:"Terminus",
homepage:"https://terminus.com/",category:"ad",domains:["*.terminus.services"]},{name:"Acceptable Ads",homepage:"https://acceptableads.com/",category:"ad",domains:["*.aaxads.com","*.aaxdetect.com"]},{name:"ClearBrain",homepage:"https://www.clearbrain.com/",category:"analytics",domains:["*.clearbrain.com"]},{name:"Optanon",homepage:"https://www.cookielaw.org/",category:"consent-provider",domains:["*.onetrust.com","*.cookielaw.org"]},{name:"TrustArc",homepage:"https://www.trustarc.com/",category:"utility",domains:["*.trustarc.com"]},{name:"iSpot.tv",homepage:"https://www.ispot.tv/",category:"ad",domains:["*.ispot.tv"]},{name:"RevJet",homepage:"https://www.revjet.com/",category:"ad",domains:["*.revjet.com"]},{name:"atlasRTX",homepage:"https://www.atlasrtx.com/",category:"customer-success",domains:["*.atlasrtx.com"]},{name:"ContactAtOnce",homepage:"https://www.contactatonce.com/",category:"customer-success",domains:["*.contactatonce.com"]},{name:"Algolia",
homepage:"https://www.algolia.com/",category:"utility",domains:["*.algolianet.com","*.algolia.net","*.algolia.io"]},{name:"EMX Digital",homepage:"https://emxdigital.com",category:"ad",domains:["*.emxdgt.com"]},{name:"Moxie",homepage:"https://www.gomoxie.com/",category:"utility",domains:["*.gomoxie.solutions"]},{name:"Scripps Network Digital",homepage:"https://www.scrippsnetworksdigital.com/",category:"ad",domains:["*.snidigital.com"]},{name:"TurnTo",homepage:"https://www.turntonetworks.com/",category:"utility",domains:["*.turnto.com"]},{name:"Quantum Metric",homepage:"https://www.quantummetric.com/",category:"analytics",domains:["*.quantummetric.com"]},{name:"Carbon Ads",homepage:"https://www.carbonads.net/",category:"ad",domains:["*.carbonads.net","*.carbonads.com"]},{name:"Ably",homepage:"https://www.ably.io/",category:"utility",domains:["*.ably.io"]},{name:"Sectigo",homepage:"https://sectigo.com/",category:"utility",domains:["*.sectigo.com"]},{name:"Specless",
homepage:"https://gospecless.com/",category:"ad",domains:["*.specless.tech"]},{name:"Loggly",homepage:"https://www.loggly.com/",category:"analytics",domains:["*.loggly.com","d9jmv9u00p0mv.cloudfront.net"]},{name:"Intent Media",homepage:"https://intent.com/",category:"ad",domains:["*.intentmedia.net"]},{name:"Supership",homepage:"https://supership.jp/",category:"ad",domains:["*.socdm.com"]},{name:"F@N Communications",homepage:"https://www.fancs.com/",category:"ad",domains:["*.ladsp.com"]},{name:"Vidyard",homepage:"https://www.vidyard.com/",category:"utility",domains:["*.vidyard.com"]},{name:"RapidSSL",homepage:"https://www.rapidssl.com/",category:"utility",domains:["*.rapidssl.com"]},{name:"Coherent Path",homepage:"https://coherentpath.com/",category:"utility",domains:["*.coherentpath.com"]},{name:"Attentive",homepage:"https://attentivemobile.com/",category:"ad",domains:["*.attn.tv","*.attentivemobile.com"]},{name:"emetriq",homepage:"https://www.emetriq.com/",category:"ad",
domains:["*.emetriq.de","*.xplosion.de"]},{name:"Bonzai",homepage:"https://www.bonzai.co/",category:"ad",domains:["*.bonzai.co"]},{name:"Freshchat",homepage:"https://www.freshworks.com/live-chat-software/",category:"customer-success",domains:["*.freshchat.com","*.freshworksapi.com"],products:[{name:"Freshdesk Messaging",urlPatterns:["wchat.freshchat.com"],facades:[{name:"Freshdesk Messaging (formerly Freshchat) Facade",repo:"https://github.com/coliff/freshdesk-messaging-facade/"}]}]},{name:"Contentful",homepage:"https://www.contentful.com/",category:"utility",domains:["*.contentful.com"]},{name:"PureCars",homepage:"https://www.purecars.com/",category:"marketing",domains:["*.purecars.com"]},{name:"Tray Commerce",homepage:"https://www.tray.com.br/",category:"marketing",domains:["*.tcdn.com.br"]},{name:"AdScore",homepage:"https://www.adscore.com/",category:"ad",domains:["*.adsco.re"]},{name:"WebsiteBuilder.com",homepage:"https://www.websitebuilder.com",category:"hosting",
domains:["*.mywebsitebuilder.com"]},{name:"mParticle",homepage:"https://www.mparticle.com/",category:"utility",domains:["*.mparticle.com"]},{name:"Ada",homepage:"https://www.ada.support/",category:"customer-success",domains:["*.ada.support"]},{name:"Quora Ads",homepage:"https://www.quora.com/business/",category:"ad",domains:["*.quora.com"]},{name:"Auth0",homepage:"https://auth0.com/",category:"utility",domains:["*.auth0.com"]},{name:"Bridgewell DSP",homepage:"https://www.bridgewell.com/",category:"ad",domains:["*.scupio.com"]},{name:"Wicked Reports",homepage:"https://www.wickedreports.com/",category:"marketing",domains:["*.wickedreports.com"]},{name:"Jaywing",homepage:"https://jaywing.com/",category:"marketing",domains:["*.jaywing.com"]},{name:"Holimetrix",homepage:"https://u360.d-bi.fr/",category:"marketing",domains:["*.d-bi.fr"]},{name:"iZooto",homepage:"https://www.izooto.com",category:"marketing",domains:["*.izooto.com"]},{name:"Ordergroove",homepage:"https://www.ordergroove.com/",
category:"marketing",domains:["*.ordergroove.com"]},{name:"PageSense",homepage:"https://www.zoho.com/pagesense/",category:"analytics",domains:["*.pagesense.io"]},{name:"Vizzit",homepage:"https://www.vizzit.se",category:"analytics",domains:["*.vizzit.se"]},{name:"Click Guardian",homepage:"https://www.clickguardian.co.uk/",category:"ad",domains:["*.clickguardian.app","*.clickguardian.co.uk"]},{name:"Smartsupp",company:"Smartsupp.com",homepage:"https://www.smartsupp.com",category:"customer-success",domains:["*.smartsuppchat.com","*.smartsupp.com","smartsupp-widget-161959.c.cdn77.org","*.smartsuppcdn.com"]},{name:"Smartlook",company:"Smartsupp.com",homepage:"https://www.smartlook.com/",category:"analytics",domains:["*.smartlook.com"]},{name:"Luigis Box",company:"Luigis Box",homepage:"https://www.luigisbox.com/",category:"utility",domains:["*.luigisbox.com"]},{name:"Targito",company:"VIVmail.cz",homepage:"https://www.targito.com",category:"marketing",domains:["*.targito.com"]},{
name:"Foxentry",company:"AVANTRO",homepage:"https://foxentry.cz/",category:"utility",domains:["*.foxentry.cz"]},{name:"Pendo",homepage:"https://www.pendo.io",category:"analytics",domains:["*.pendo.io"]},{name:"Braze",homepage:"https://www.braze.com",category:"analytics",domains:["*.appboycdn.com"]},{name:"Usersnap",homepage:"https://usersnap.com",category:"customer-success",domains:["*.usersnap.com"]},{name:"Rewardful",homepage:"https://www.getrewardful.com",category:"analytics",domains:["*.wdfl.co"]},{name:"Launch Darkly",homepage:"https://launchdarkly.com",category:"utility",domains:["*.launchdarkly.com"]},{name:"Statuspage",company:"Atlassian",homepage:"https://www.statuspage.io",category:"utility",domains:["*.statuspage.io"]},{name:"HyperInzerce",homepage:"https://hyperinzerce.cz",category:"ad",domains:["*.hyperinzerce.cz"]},{name:"POWr",homepage:"https://www.powr.io",category:"utility",domains:["*.powr.io"]},{name:"Coral",company:"Coral",homepage:"https://coralproject.net",
category:"content",domains:["*.coral.coralproject.net"]},{name:"Bolt",homepage:"https://www.bolt.com/",category:"utility",domains:["*.bolt.com"]},{name:"Judge.me",homepage:"https://judge.me/",category:"marketing",domains:["*.judge.me"]},{name:"Tilda",homepage:"https://tilda.cc/",category:"hosting",domains:["*.tildacdn.com"]},{name:"SalesLoft",homepage:"https://salesloft.com/",category:"marketing",domains:["*.salesloft.com"]},{name:"Accessibe Accessibility Overlay",company:"Accessibe",homepage:"https://accessibe.com/",category:"utility",domains:["*.accessibe.com","*.acsbapp.com","*.acsbap.com"]},{name:"Builder",homepage:"https://www.builder.io/",category:"hosting",domains:["*.builder.io"]},{name:"Pepperjam",homepage:"https://www.pepperjam.com/",category:"marketing",domains:["*.pepperjam.com","*.affiliatetechnology.com"]},{name:"Reach",homepage:"https://withreach.com/",category:"utility",domains:["*.gointerpay.net"]},{name:"Chameleon",homepage:"https://www.trychameleon.com/",
category:"marketing",domains:["*.trychameleon.com"]},{name:"Matomo",company:"InnoCraft",homepage:"https://matomo.org/",category:"analytics",domains:["*.matomo.cloud"]},{name:"Segmanta",homepage:"https://segmanta.com/",category:"marketing",domains:["*.segmanta.com"]},{name:"Podsights",homepage:"https://podsights.com/",category:"marketing",domains:["*.pdst.fm","us-central1-adaptive-growth.cloudfunctions.net"]},{name:"Chatwoot",homepage:"https://www.chatwoot.com/",category:"customer-success",domains:["*.chatwoot.com"]},{name:"Crisp",homepage:"https://crisp.chat/",category:"customer-success",domains:["*.crisp.chat"]},{name:"Admiral CMP",homepage:"https://www.getadmiral.com",category:"consent-provider",domains:["admiral.mgr.consensu.org","*.admiral.mgr.consensu.org"]},{name:"Adnuntius CMP",homepage:"https://adnuntius.com",category:"consent-provider",domains:["adnuntiusconsent.mgr.consensu.org","*.adnuntiusconsent.mgr.consensu.org"]},{name:"Clickio CMP",homepage:"https://clickio.com",
category:"consent-provider",domains:["clickio.mgr.consensu.org","*.clickio.mgr.consensu.org"]},{name:"AppConsent CMP",homepage:"https://appconsent.io/en",category:"consent-provider",domains:["appconsent.mgr.consensu.org","*.appconsent.mgr.consensu.org"]},{name:"DMG Media CMP",homepage:"https://www.dmgmedia.co.uk",category:"consent-provider",domains:["dmgmedia.mgr.consensu.org","*.dmgmedia.mgr.consensu.org"]},{name:"Axel Springer CMP",homepage:"https://www.axelspringer.com",category:"consent-provider",domains:["axelspringer.mgr.consensu.org","*.axelspringer.mgr.consensu.org"]},{name:"Bedrock CMP",homepage:"https://www.bedrockstreaming.com",category:"consent-provider",domains:["bedrock.mgr.consensu.org","*.bedrock.mgr.consensu.org"]},{name:"BMIND CMP",homepage:"https://www.bmind.es",category:"consent-provider",domains:["bmind.mgr.consensu.org","*.bmind.mgr.consensu.org"]},{name:"Borlabs CMP",homepage:"https://borlabs.io",category:"consent-provider",
domains:["borlabs.mgr.consensu.org","*.borlabs.mgr.consensu.org"]},{name:"Civic CMP",homepage:"https://www.civicuk.com",category:"consent-provider",domains:["cookiecontrol.mgr.consensu.org","*.cookiecontrol.mgr.consensu.org"]},{name:"Commanders Act CMP",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["commandersact.mgr.consensu.org","*.commandersact.mgr.consensu.org"]},{name:"Complianz CMP",homepage:"https://complianz.io/",category:"consent-provider",domains:["complianz.mgr.consensu.org","*.complianz.mgr.consensu.org"]},{name:"Consent Desk CMP",homepage:"https://www.consentdesk.com/",category:"consent-provider",domains:["consentdesk.mgr.consensu.org","*.consentdesk.mgr.consensu.org"]},{name:"Consent Manager CMP",homepage:"https://consentmanager.net",category:"consent-provider",domains:["consentmanager.mgr.consensu.org","*.consentmanager.mgr.consensu.org"]},{name:"Conversant CMP",homepage:"https://www.conversantmedia.eu/",category:"consent-provider",
domains:["conversant.mgr.consensu.org","*.conversant.mgr.consensu.org"]},{name:"Cookie Information CMP",homepage:"https://www.cookieinformation.com/",category:"consent-provider",domains:["cookieinformation.mgr.consensu.org","*.cookieinformation.mgr.consensu.org"]},{name:"Cookiebot CMP",homepage:"https://www.cookiebot.com",category:"consent-provider",domains:["cookiebot.mgr.consensu.org","*.cookiebot.mgr.consensu.org"]},{name:"Truendo CMP",homepage:"https://truendo.com/",category:"consent-provider",domains:["truendo.mgr.consensu.org","*.truendo.mgr.consensu.org"]},{name:"Dentsu CMP",homepage:"https://www.dentsuaegisnetwork.de/",category:"consent-provider",domains:["dan.mgr.consensu.org","*.dan.mgr.consensu.org"]},{name:"Didomi CMP",homepage:"https://www.didomi.io/en/",category:"consent-provider",domains:["didomi.mgr.consensu.org","*.didomi.mgr.consensu.org"]},{name:"Ensighten CMP",homepage:"https://www.ensighten.com/",category:"consent-provider",
domains:["ensighten.mgr.consensu.org","*.ensighten.mgr.consensu.org"]},{name:"Evidon CMP",homepage:"https://evidon.com",category:"consent-provider",domains:["evidon.mgr.consensu.org","*.evidon.mgr.consensu.org"]},{name:"Ezoic CMP",homepage:"https://www.ezoic.com/",category:"consent-provider",domains:["ezoic.mgr.consensu.org","*.ezoic.mgr.consensu.org"]},{name:"Gemius CMP",homepage:"https://www.gemius.com",category:"consent-provider",domains:["gemius.mgr.consensu.org","*.gemius.mgr.consensu.org"]},{name:"NitroPay CMP",homepage:"https://nitropay.com/",category:"consent-provider",domains:["nitropay.mgr.consensu.org","*.nitropay.mgr.consensu.org"]},{name:"Google FundingChoices",homepage:"https://fundingchoices.google.com/start/",category:"consent-provider",domains:["fundingchoices.mgr.consensu.org","*.fundingchoices.mgr.consensu.org"]},{name:"Gravito CMP",homepage:"https://www.gravito.net/",category:"consent-provider",domains:["gravito.mgr.consensu.org","*.gravito.mgr.consensu.org"]},{
name:"ID Ward CMP",homepage:"https://id-ward.com/enterprise",category:"consent-provider",domains:["idward.mgr.consensu.org","*.idward.mgr.consensu.org"]},{name:"iubenda CMP",homepage:"https://www.iubenda.com",category:"consent-provider",domains:["iubenda.mgr.consensu.org","*.iubenda.mgr.consensu.org"]},{name:"Jump CMP",homepage:"https://jumpgroup.it/",category:"consent-provider",domains:["avacy.mgr.consensu.org","*.avacy.mgr.consensu.org"]},{name:"LiveRamp CMP",homepage:"https://liveramp.com/",category:"consent-provider",domains:["faktor.mgr.consensu.org","*.faktor.mgr.consensu.org"]},{name:"Madvertise CMP",homepage:"https://madvertise.com/en/",category:"consent-provider",domains:["madvertise.mgr.consensu.org","*.madvertise.mgr.consensu.org"]},{name:"Mairdumont Netletic CMP",homepage:"https://www.mairdumont-netletix.com/",category:"consent-provider",domains:["mdnxmp.mgr.consensu.org","*.mdnxmp.mgr.consensu.org"]},{name:"Marfeel CMP",homepage:"https://www.marfeel.com/",
category:"consent-provider",domains:["marfeel.mgr.consensu.org","*.marfeel.mgr.consensu.org"]},{name:"Mediavine CMP",homepage:"https://www.mediavine.com/",category:"consent-provider",domains:["mediavine.mgr.consensu.org","*.mediavine.mgr.consensu.org"]},{name:"ConsentServe CMP",homepage:"https://www.consentserve.com/",category:"consent-provider",domains:["consentserve.mgr.consensu.org","*.consentserve.mgr.consensu.org"]},{name:"Next14 CMP",homepage:"https://www.next14.com/",category:"consent-provider",domains:["next14.mgr.consensu.org","*.next14.mgr.consensu.org"]},{name:"AdRoll CMP",homepage:"https://www.adroll.com/",category:"consent-provider",domains:["adroll.mgr.consensu.org","*.adroll.mgr.consensu.org"]},{name:"Ogury CMP",homepage:"https://www.ogury.com/",category:"consent-provider",domains:["ogury.mgr.consensu.org","*.ogury.mgr.consensu.org"]},{name:"OneTag CMP",homepage:"https://onetag.net",category:"consent-provider",
domains:["onetag.mgr.consensu.org","*.onetag.mgr.consensu.org"]},{name:"OneTrust CMP",homepage:"https://onetrust.com",category:"consent-provider",domains:["onetrust.mgr.consensu.org","*.onetrust.mgr.consensu.org"]},{name:"optAd360 CMP",homepage:"https://www.optad360.com/",category:"consent-provider",domains:["optad360.mgr.consensu.org","*.optad360.mgr.consensu.org"]},{name:"Osano CMP",homepage:"https://www.osano.com",category:"consent-provider",domains:["osano.mgr.consensu.org","*.osano.mgr.consensu.org"]},{name:"Playwire CMP",homepage:"https://www.playwire.com",category:"consent-provider",domains:["playwire.mgr.consensu.org","*.playwire.mgr.consensu.org"]},{name:"Pulselive CMP",homepage:"https://www.pulselive.com",category:"consent-provider",domains:["pulselive.mgr.consensu.org","*.pulselive.mgr.consensu.org"]},{name:"Quantcast Choice",homepage:"https://quantcast.com",category:"consent-provider",domains:["quantcast.mgr.consensu.org","*.quantcast.mgr.consensu.org"]},{
name:"RCS Pubblicita CMP",homepage:"http://www.rcspubblicita.it/site/home.html",category:"consent-provider",domains:["rcsmediagroup.mgr.consensu.org","*.rcsmediagroup.mgr.consensu.org"]},{name:"Rich Audience CMP",homepage:"https://richaudience.com",category:"consent-provider",domains:["richaudience.mgr.consensu.org","*.richaudience.mgr.consensu.org"]},{name:"Ringier Axel Springer CMP",homepage:"https://www.ringieraxelspringer.pl/en/home/",category:"consent-provider",domains:["rasp.mgr.consensu.org","*.rasp.mgr.consensu.org"]},{name:"Secure Privacy CMP",homepage:"https://secureprivacy.ai/",category:"consent-provider",domains:["secureprivacy.mgr.consensu.org","*.secureprivacy.mgr.consensu.org"]},{name:"Securiti CMP",homepage:"https://securiti.ai/",category:"consent-provider",domains:["securiti.mgr.consensu.org","*.securiti.mgr.consensu.org"]},{name:"Seznam.cz CMP",homepage:"https://www.seznam.cz/",category:"consent-provider",domains:["seznam.mgr.consensu.org","*.seznam.mgr.consensu.org"]
},{name:"ShareThis CMP",homepage:"https://sharethis.com",category:"consent-provider",domains:["sharethis.mgr.consensu.org","*.sharethis.mgr.consensu.org"]},{name:"ShinyStat CMP",homepage:"https://www.shinystat.com",category:"consent-provider",domains:["shinystat.mgr.consensu.org","*.shinystat.mgr.consensu.org"]},{name:"Sibbo CMP",homepage:"https://sibboventures.com/en/",category:"consent-provider",domains:["sibboventures.mgr.consensu.org","*.sibboventures.mgr.consensu.org"]},{name:"Singlespot CMP",homepage:"https://www.singlespot.com/en",category:"consent-provider",domains:["singlespot.mgr.consensu.org","*.singlespot.mgr.consensu.org"]},{name:"Sirdata CMP",homepage:"https://www.sirdata.com",category:"consent-provider",domains:["sddan.mgr.consensu.org","*.sddan.mgr.consensu.org"]},{name:"Snigel CMP",homepage:"https://snigel.com",category:"consent-provider",domains:["snigelweb.mgr.consensu.org","*.snigelweb.mgr.consensu.org"]},{name:"Sourcepoint CMP",homepage:"https://sourcepoint.com",
category:"consent-provider",domains:["sourcepoint.mgr.consensu.org","*.sourcepoint.mgr.consensu.org"]},{name:"Pubtech CMP",homepage:"https://www.pubtech.ai/",category:"consent-provider",domains:["pubtech.mgr.consensu.org","*.pubtech.mgr.consensu.org"]},{name:"AdMetrics Pro CMP",homepage:"https://admetricspro.com",category:"consent-provider",domains:["cmp.mgr.consensu.org","*.cmp.mgr.consensu.org"]},{name:"Traffective CMP",homepage:"https://traffective.com",category:"consent-provider",domains:["traffective.mgr.consensu.org","*.traffective.mgr.consensu.org"]},{name:"UniConsent CMP",homepage:"https://uniconsent.com",category:"consent-provider",domains:["uniconsent.mgr.consensu.org","*.uniconsent.mgr.consensu.org"]},{name:"TrustArc CMP",homepage:"https://trustarc.com/",category:"consent-provider",domains:["trustarc.mgr.consensu.org","*.trustarc.mgr.consensu.org"]},{name:"Usercentrics CMP",homepage:"https://usercentrics.com",category:"consent-provider",
domains:["usercentrics.mgr.consensu.org","*.usercentrics.mgr.consensu.org","*.usercentrics.eu","*.services.usercentrics.eu"]},{name:"WebAds CMP",homepage:"https://www.webads.nl/",category:"consent-provider",domains:["webads.mgr.consensu.org","*.webads.mgr.consensu.org"]},{name:"Trustcommander",company:"Commandersact",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["*.trustcommander.net"]},{name:"Hubvisor",homepage:"https://www.hubvisor.io",category:"ad",domains:["*.hubvisor.io"]},{name:"Castle",homepage:"https://castle.io",category:"utility",domains:["*.castle.io","d2t77mnxyo7adj.cloudfront.net"]},{name:"Wigzo",homepage:"https://www.wigzo.com/",category:"marketing",domains:["*.wigzo.com","*.wigzopush.com"]},{name:"Convertful",homepage:"https://convertful.com/",category:"marketing",domains:["*.convertful.com"]},{name:"OpenLink",company:"MediaWallah",homepage:"https://www.mediawallah.com/",category:"ad",domains:["*.mediawallahscript.com"]},{name:"TPMN",
company:"TPMN",homepage:"http://tpmn.io/",category:"ad",domains:["*.tpmn.co.kr"]},{name:"HERO",company:"Klarna",homepage:"https://www.usehero.com/",category:"customer-success",domains:["*.usehero.com"]},{name:"Zync",company:"Zeta Global",homepage:"https://zetaglobal.com/",category:"marketing",domains:["*.rezync.com"]},{name:"AdFuel Video",company:"AdFuel",homepage:"https://goadfuel.com/",category:"ad",domains:["*.videoplayerhub.com"]},{name:"Prefix Box AI Search",company:"Prefix Box",homepage:"https://www.prefixbox.com/",category:"utility",domains:["*.prefixbox.com"]},{name:"SpeedSize Service Worker",company:"SpeedSize",homepage:"https://speedsize.com/",category:"utility",domains:["di6367dava8ow.cloudfront.net","d2d22nphq0yz8t.cloudfront.net"]},{name:"Vonage Video API",company:"Vonage",homepage:"https://www.vonage.com/communications-apis/video/",category:"video",domains:["*.opentok.com"]},{name:"Checkout.com",company:"Checkout.com",homepage:"https://www.checkout.com",
category:"utility",domains:["*.checkout.com"]},{name:"Noibu",company:"Noibu",homepage:"https://www.noibu.com",category:"utility",domains:["*.noibu.com"]},{name:"Clarity",company:"Microsoft",homepage:"https://clarity.microsoft.com/",category:"utility",domains:["*.clarity.ms"]},{name:"goinstore",company:"Emplifi",homepage:"https://goinstore.com/",category:"customer-success",domains:["*.goinstore.com"]},{name:"SegmentStream",company:"SegmentStream",homepage:"https://segmentstream.com/",category:"marketing",domains:["*.segmentstream.com"]},{name:"Amazon Associates",company:"Amazon",homepage:"https://affiliate-program.amazon.co.uk/",category:"marketing",domains:["*.associates-amazon.com"]},{name:"DotMetrics",company:"Ipsos",homepage:"https://www.dotmetrics.net/",category:"analytics",domains:["*.dotmetrics.net"]},{name:"Truffle Bid",company:"Truffle",homepage:"https://truffle.bid/",category:"ad",domains:["*.truffle.bid"]},{name:"Hybrid",company:"Hybrid",homepage:"https://hybrid.ai/",
category:"ad",domains:["*.hybrid.ai"]},{name:"AdMan Media",company:"AdMan",homepage:"https://admanmedia.com/",category:"video",domains:["*.admanmedia.com"]},{name:"ID5 Identity Cloud",company:"ID5",homepage:"https://id5.io/",category:"ad",domains:["id5-sync.com","*.id5-sync.com"]},{name:"Audience Rate",company:"Audience Rate Limited",homepage:"https://www.audiencerate.com/",category:"ad",domains:["*.audrte.com"]},{name:"Seedtag",company:"Seedtag Advertising",homepage:"https://www.seedtag.com/",category:"ad",domains:["*.seedtag.com"]},{name:"IVI",company:"IVI Technologies",homepage:"http://ivitechnologies.com/",category:"ad",domains:["*.ivitrack.com"]},{name:"Sportradar",company:"Sportradar",homepage:"https://www.sportradar.com/",category:"ad",domains:["*.sportradarserving.com"]},{name:"ZEOTAP",company:"ZEOTAP",homepage:"https://zeotap.com/",category:"ad",domains:["*.zeotap.com"]},{name:"Web Content Assessor",company:"TMT Digital",homepage:"https://mediatrust.com/",category:"ad",
domains:["*.webcontentassessor.com"]},{name:"Genie",company:"Media Force",homepage:"https://hellogenie.com/",category:"ad",domains:["*.mfadsrvr.com"]},{name:"mediarithmics",company:"mediarithmics",homepage:"https://www.mediarithmics.com/",category:"ad",domains:["*.mediarithmics.com"]},{name:"Ozone Project",company:"The Ozone Project",homepage:"https://www.ozoneproject.com/",category:"ad",domains:["*.the-ozone-project.com"]},{name:"FiftyAurora",company:"Fifty",homepage:"https://fifty.io/",category:"ad",domains:["*.fiftyt.com"]},{name:"smadex",company:"entravision",homepage:"https://smadex.com/",category:"ad",domains:["*.smadex.com"]},{name:"AWX",company:"Trinity Mirror",category:"ad",domains:["*.tm-awx.com"]},{name:"XPO",company:"Knorex",category:"ad",homepage:"https://www.knorex.com/",domains:["*.brand-display.com"]},{name:"Viafoura",company:"Viafoura",category:"ad",homepage:"https://viafoura.com/",domains:["*.viafoura.co","*.viafoura.net"]},{name:"Adnami",company:"Adnami",
category:"ad",homepage:"https://www.adnami.io/",domains:["*.adnami.io"]},{name:"LiveRamp Privacy Manager",company:"LiveRamp",category:"ad",homepage:"https://liveramp.com/privacy-legal-compliance/",domains:["*.privacymanager.io"]},{name:"Onfocus",company:"Onfocus SAS",category:"ad",domains:["*.4dex.io"]},{name:"viewTag",company:"Advanced Store",category:"ad",domains:["*.ad4m.at"]},{name:"MRP Prelytics",company:"Market Resource Partners",category:"ad",homepage:"https://www.mrpfd.com/",domains:["*.mrpdata.net"]},{name:"iPROM",company:"iPROM",category:"ad",homepage:"https://iprom.eu/",domains:["*.iprom.net"]},{name:"Plausible",company:"Plausible",homepage:"https://plausible.io/",category:"analytics",domains:["*.plausible.io"]},{name:"Micro Analytics",company:"Micro Analytics",homepage:"https://microanalytics.io/",category:"analytics",domains:["padmin.microanalytics.io","www.microanalytics.io","dev.microanalytics.io","status.microanalytics.io"]},{name:"Scale8",company:"Scale8",
homepage:"https://scale8.com/",category:"analytics",domains:["www.scale8.com","api-dev.scale8.com","cdn.scale8.com","ui.scale8.com"]},{name:"Cabin",company:"Cabin",homepage:"https://withcabin.com/",category:"analytics",domains:["*.withcabin.com"]},{name:"Appcues",company:"Appcues",homepage:"https://www.appcues.com/",category:"analytics",domains:["*.appcues.com"]}]);function getEntity(e){return si.getEntity(e)}function isThirdParty(e,t){const n=getEntity(e);return!!n&&n!==t}var ci={getEntity,getProduct:function getProduct(e){return si.getProduct(e)},isThirdParty,isFirstParty:function isFirstParty(e,t){return!isThirdParty(e,t)}};class EntityClassification{static makeupChromeExtensionEntity_(e,t,n){const a=Util.getChromeExtensionOrigin(t),r=new URL(a).host,o=n||r,i=e.get(a);if(i)return i;const s={name:o,company:o,category:"Chrome Extension",homepage:"https://chromewebstore.google.com/detail/"+r,categories:[],domains:[],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0}
;return e.set(a,s),s}static _makeUpAnEntity(e,t){if(!UrlUtils.isValid(t))return;const n=Util.createOrReturnURL(t);if("chrome-extension:"===n.protocol)return EntityClassification.makeupChromeExtensionEntity_(e,t);if(!n.protocol.startsWith("http"))return;const a=Util.getRootDomain(t);if(!a)return;if(e.has(a))return e.get(a);const r={name:a,company:a,category:"",categories:[],domains:[a],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0,isUnrecognized:!0};return e.set(a,r),r}static _preloadChromeExtensionsToCache(e,t){for(const n of t.values()){if("Runtime.executionContextCreated"!==n.method)continue;const t=n.params.context.origin;t.startsWith("chrome-extension:")&&(e.has(t)||EntityClassification.makeupChromeExtensionEntity_(e,t,n.params.context.name))}}static async compute_(e,t){const n=await bo.request(e.devtoolsLog,t),a=new Map,r=new Map,o=new Map;EntityClassification._preloadChromeExtensionsToCache(a,e.devtoolsLog);for(const e of n){const{url:t}=e;if(r.has(t))continue
;const n=ci.getEntity(t)||EntityClassification._makeUpAnEntity(a,t);if(!n)continue;const i=o.get(n)||new Set;i.add(t),o.set(n,i),r.set(t,n)}const i=e.URL.mainDocumentUrl||e.URL.finalDisplayedUrl,s=ci.getEntity(i)||EntityClassification._makeUpAnEntity(a,i);return{entityByUrl:r,urlsByEntity:o,firstParty:s,isFirstParty:function isFirstParty(e){return r.get(e)===s}}}}const li=makeComputedArtifact(EntityClassification,["URL","devtoolsLog"]);getModuleDirectory({url:"core/runner.js"});class Runner{static async audit(e,t){const{resolvedConfig:n,computedCache:a}=t,r=n.settings;try{const t={msg:"Audit phase",id:"lh:runner:audit"};Log.time(t,"verbose");const o=[];if(r.gatherMode&&!r.auditMode)return;if(!n.audits)throw new Error("No audits to evaluate.");const i=await Runner._runAudits(r,n.audits,e,o,a),s={msg:"Generating results...",id:"lh:runner:generate"};Log.time(s),e.LighthouseRunWarnings&&o.push(...e.LighthouseRunWarnings);const c={"axe-core":e.Accessibility?.version};let l={}
;n.categories&&(l=ReportScoring.scoreAllCategories(n.categories,i)),Log.timeEnd(s),Log.timeEnd(t);let u=e.FullPageScreenshot;(n.settings.disableFullPageScreenshot||u instanceof Error)&&(u=void 0);const d={lighthouseVersion:_r,requestedUrl:e.URL.requestedUrl,mainDocumentUrl:e.URL.mainDocumentUrl,finalDisplayedUrl:e.URL.finalDisplayedUrl,finalUrl:e.URL.mainDocumentUrl,fetchTime:e.fetchTime,gatherMode:e.GatherContext.gatherMode,runtimeError:Runner.getArtifactRuntimeError(e),runWarnings:o,userAgent:e.HostUserAgent,environment:{networkUserAgent:e.NetworkUserAgent,hostUserAgent:e.HostUserAgent,benchmarkIndex:e.BenchmarkIndex,benchmarkIndexes:e.BenchmarkIndexes,credits:c},audits:i,configSettings:r,categories:l,categoryGroups:n.groups||void 0,stackPacks:getStackPacks(e.Stacks),entities:await Runner.getEntityClassification(e,{computedCache:a}),fullPageScreenshot:u,timing:this._getTiming(e),i18n:{rendererFormattedStrings:getRendererFormattedStrings(r.locale),icuMessagePaths:{}}}
;d.i18n.icuMessagePaths=replaceIcuMessages(d,r.locale);const m=d;if(r.auditMode){!function saveLhr(e,t){J.writeFileSync(`${t}/lhr.report.json`,JSON.stringify(e,null,2))}(m,Runner._getDataSavePath(r))}return{lhr:m,artifacts:e,report:ReportGenerator.generateReport(m,r.output)}}catch(e){throw Runner.createRunnerError(e,r)}}static async getEntityClassification(e,t){const n=e.devtoolsLogs[Audit.DEFAULT_PASS];if(!n)return;const a=await li.request({URL:e.URL,devtoolsLog:n},t),r=[];for(const[e,t]of a.urlsByEntity){const n=new Set;for(const e of t){const t=UrlUtils.getOrigin(e);t&&n.add(t)}const o={name:e.name,homepage:e.homepage,origins:[...n]};e===a.firstParty&&(o.isFirstParty=!0),e.isUnrecognized&&(o.isUnrecognized=!0),e.category&&(o.category=e.category),r.push(o)}return r}static async gather(e,t){const n=t.resolvedConfig.settings;try{const a=Qo.getContext();let r;if(Qo.captureBreadcrumb({message:"Run started",category:"lifecycle",data:a}),n.auditMode&&!n.gatherMode){
r=loadArtifacts(this._getDataSavePath(n))}else{const a={msg:"Gather phase",id:"lh:runner:gather"};if(Log.time(a,"verbose"),r=await e({resolvedConfig:t.resolvedConfig,driverMock:t.driverMock}),Log.timeEnd(a),r.Timing=Log.takeTimeEntries(),n.gatherMode){const e=this._getDataSavePath(n);await async function saveArtifacts(e,t){const n={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};Log.time(n),J.mkdirSync(t,{recursive:!0});const a=J.readdirSync(t);for(const e of a)(e.endsWith(Ko)||e.endsWith(Jo)||e===Yo)&&J.unlinkSync(`${t}/${e}`);const{traces:r,devtoolsLogs:o,DevtoolsLog:i,Trace:s,...c}=e;for(const[e,n]of Object.entries(r))await saveTrace(n,`${t}/${e}.trace.json`);for(const[e,n]of Object.entries(o))await saveDevtoolsLog(n,`${t}/${e}.devtoolslog.json`);const l=JSON.stringify(c,stringifyReplacer,2)+"\n";J.writeFileSync(`${t}/artifacts.json`,l,"utf8"),Log.log("Artifacts saved to disk in folder:",t),Log.timeEnd(n)}(r,e)}}return r}catch(e){throw Runner.createRunnerError(e,n)}}
static createRunnerError(e,t){return e.friendlyMessage&&(e.friendlyMessage=getFormatted(e.friendlyMessage,t.locale)),Qo.captureException(e,{level:"fatal"}),e}static _getTiming(e){const t=[...e.Timing||[],...Log.takeTimeEntries()].map((e=>[`${e.startTime}-${e.name}-${e.duration}`,e])),n=Array.from(new Map(t).values()).map((e=>({startTime:parseFloat(e.startTime.toFixed(2)),name:e.name,duration:parseFloat(e.duration.toFixed(2)),entryType:e.entryType}))).sort(((e,t)=>e.startTime-t.startTime)),a=n.find((e=>"lh:runner:gather"===e.name)),r=n.find((e=>"lh:runner:audit"===e.name));return{entries:n,total:(a?.duration||0)+(r?.duration||0)}}static async _gatherArtifactsFromBrowser(e,t,n){if(!t.resolvedConfig.passes)throw new Error("No browser artifacts are either provided or requested.");const a={driver:t.driverMock||new Driver$1(n),requestedUrl:e,settings:t.resolvedConfig.settings,computedCache:t.computedCache};return await GatherRunner.run(t.resolvedConfig.passes,a)}
static async _runAudits(e,t,n,a,r){const o={msg:"Analyzing and running audits...",id:"lh:runner:auditing"};if(Log.time(o),n.settings){const t={locale:void 0,gatherMode:void 0,auditMode:void 0,output:void 0,channel:void 0,budgets:void 0},a=Object.assign({},n.settings,t),r=Object.assign({},e,t),o=new Set([...Object.keys(a),...Object.keys(r)]);for(const e of o)if(!Xa(a[e],r[e]))throw new Error(`Cannot change settings between gathering and auditing. Difference found at: ${e}`);if(!Xa(a,r))throw new Error("Cannot change settings between gathering and auditing")}const i={settings:e,computedCache:r},s={};for(const e of t){const t=e.implementation.meta.id,r=await Runner._runAudit(e,n,i,a);s[t]=r}return Log.timeEnd(o),s}static async _runAudit(e,t,n,a){const r=e.implementation,o={msg:`Auditing: ${getFormatted(r.meta.title,"en-US")}`,id:`lh:audit:${r.meta.id}`};let i;Log.time(o);try{for(const e of r.meta.requiredArtifacts){
const n=void 0===t[e],a="traces"===e&&!t.traces[Audit.DEFAULT_PASS],o="devtoolsLogs"===e&&!t.devtoolsLogs[Audit.DEFAULT_PASS];if(n||a||o)throw Log.warn("Runner",`${e} gatherer, required by audit ${r.meta.id}, did not run.`),new LighthouseError(LighthouseError.errors.MISSING_REQUIRED_ARTIFACT,{artifactName:e});if(t[e]instanceof Error){const n=t[e];Qo.captureException(n,{tags:{gatherer:e},level:"error"}),Log.warn("Runner",`${e} gatherer, required by audit ${r.meta.id}, encountered an error: ${n.message}`);const a=new LighthouseError(LighthouseError.errors.ERRORED_REQUIRED_ARTIFACT,{artifactName:e,errorMessage:n.message},{cause:n});throw a.expected=!0,a}}const o={options:Object.assign({},r.defaultOptions,e.options),...n},s=r.meta.requiredArtifacts.concat(r.meta.__internalOptionalArtifacts||[]).reduce(((e,n)=>{const a=t[n];return e[n]=a,e}),{}),c=await r.audit(s,o);a.push(...c.runWarnings||[]),i=Audit.generateAuditResult(r,c)}catch(e){
"MISSING_REQUIRED_ARTIFACT"!==e.code&&"ERRORED_REQUIRED_ARTIFACT"!==e.code&&Log.warn(r.meta.id,`Caught exception: ${e.message}`),Qo.captureException(e,{tags:{audit:r.meta.id},level:"error"});const t=e.friendlyMessage?e.friendlyMessage:e.message,n=e.cause?.stack??e.stack;i=Audit.generateErrorAuditResult(r,t,n)}return Log.timeEnd(o),i}static getArtifactRuntimeError(e){const t=[e.PageLoadError,...Object.values(e)];for(const e of t){if(e instanceof LighthouseError&&e.lhrRuntimeError){const t=e.friendlyMessage||e.message;return{code:e.code,message:t}}}}static getAuditList(){const e=["audit.js","violation-audit.js","accessibility/axe-audit.js","multi-check-audit.js","byte-efficiency/byte-efficiency-audit.js","manual/manual-audit.js"]
;return["accessibility","audit.js","autocomplete.js","bf-cache.js","bootup-time.js","byte-efficiency","content-width.js","critical-request-chains.js","csp-xss.js","deprecations.js","diagnostics.js","dobetterweb","errors-in-console.js","final-screenshot.js","font-display.js","image-aspect-ratio.js","image-size-responsive.js","installable-manifest.js","is-on-https.js","largest-contentful-paint-element.js","layout-shift-elements.js","lcp-lazy-loaded.js","long-tasks.js","main-thread-tasks.js","mainthread-work-breakdown.js","manual","maskable-icon.js","metrics","metrics.js","multi-check-audit.js","network-requests.js","network-rtt.js","network-server-latency.js","no-unload-listeners.js","non-composited-animations.js","oopif-iframe-test-audit.js","performance-budget.js","predictive-perf.js","preload-fonts.js","prioritize-lcp-image.js","redirects.js","resource-summary.js","screenshot-thumbnails.js","script-elements-test-audit.js","script-treemap-data.js","seo","server-response-time.js","service-worker.js","splash-screen.js","themed-omnibox.js","third-party-facades.js","third-party-summary.js","timing-budget.js","unsized-images.js","user-timings.js","uses-rel-preconnect.js","uses-rel-preload.js","valid-source-maps.js","viewport.js","violation-audit.js","work-during-interaction.js",...["charset.js","doctype.js","dom-size.js","geolocation-on-start.js","inspector-issues.js","js-libraries.js","no-document-write.js","notification-on-start.js","paste-preventing-inputs.js","uses-http2.js","uses-passive-event-listeners.js"].map((e=>`dobetterweb/${e}`)),...["cumulative-layout-shift.js","experimental-interaction-to-next-paint.js","first-contentful-paint-3g.js","first-contentful-paint.js","first-meaningful-paint.js","interactive.js","largest-contentful-paint.js","max-potential-fid.js","speed-index.js","total-blocking-time.js"].map((e=>`metrics/${e}`)),...["canonical.js","crawlable-anchors.js","font-size.js","hreflang.js","http-status-code.js","is-crawlable.js","link-text.js","manual","meta-description.js","plugins.js","robots-txt.js","tap-targets.js"].map((e=>`seo/${e}`)),...["structured-data.js"].map((e=>`seo/manual/${e}`)),...["accesskeys.js","aria-allowed-attr.js","aria-command-name.js","aria-hidden-body.js","aria-hidden-focus.js","aria-input-field-name.js","aria-meter-name.js","aria-progressbar-name.js","aria-required-attr.js","aria-required-children.js","aria-required-parent.js","aria-roles.js","aria-toggle-field-name.js","aria-tooltip-name.js","aria-treeitem-name.js","aria-valid-attr-value.js","aria-valid-attr.js","axe-audit.js","button-name.js","bypass.js","color-contrast.js","definition-list.js","dlitem.js","document-title.js","duplicate-id-active.js","duplicate-id-aria.js","form-field-multiple-labels.js","frame-title.js","heading-order.js","html-has-lang.js","html-lang-valid.js","html-xml-lang-mismatch.js","image-alt.js","input-button-name.js","input-image-alt.js","label.js","link-name.js","list.js","listitem.js","manual","meta-refresh.js","meta-viewport.js","object-alt.js","tabindex.js","table-fake-caption.js","td-has-header.js","td-headers-attr.js","th-has-data-cells.js","valid-lang.js","video-caption.js"].map((e=>`accessibility/${e}`)),...["custom-controls-labels.js","custom-controls-roles.js","focus-traps.js","focusable-controls.js","interactive-element-affordance.js","logical-tab-order.js","managed-focus.js","offscreen-content-hidden.js","use-landmarks.js","visual-order-follows-dom.js"].map((e=>`accessibility/manual/${e}`)),...["byte-efficiency-audit.js","duplicated-javascript.js","efficient-animated-content.js","legacy-javascript.js","modern-image-formats.js","offscreen-images.js","polyfill-graph-data.json","render-blocking-resources.js","total-byte-weight.js","unminified-css.js","unminified-javascript.js","unused-css-rules.js","unused-javascript.js","uses-long-cache-ttl.js","uses-optimized-images.js","uses-responsive-images-snapshot.js","uses-responsive-images.js","uses-text-compression.js"].map((e=>`byte-efficiency/${e}`)),...["manual-audit.js","pwa-cross-browser.js","pwa-each-page-has-url.js","pwa-page-transitions.js"].map((e=>`manual/${e}`))].filter((t=>/\.js$/.test(t)&&!e.includes(t))).sort()
}static getGathererList(){return["accessibility.js","anchor-elements.js","bf-cache-failures.js","cache-contents.js","console-messages.js","css-usage.js","devtools-log-compat.js","devtools-log.js","dobetterweb","full-page-screenshot.js","gatherer.js","global-listeners.js","iframe-elements.js","image-elements.js","inputs.js","inspector-issues.js","installability-errors.js","js-usage.js","link-elements.js","main-document-content.js","meta-elements.js","network-user-agent.js","script-elements.js","scripts.js","seo","service-worker.js","source-maps.js","stacks.js","trace-compat.js","trace-elements.js","trace.js","viewport-dimensions.js","web-app-manifest.js",...["embedded-content.js","font-size.js","robots-txt.js","tap-targets.js"].map((e=>`seo/${e}`)),...["doctype.js","domstats.js","optimized-images.js","response-compression.js","tags-blocking-first-paint.js"].map((e=>`dobetterweb/${e}`))].filter((e=>/\.js$/.test(e)&&"gatherer.js"!==e)).sort()}static _getDataSavePath(e){
const{auditMode:t,gatherMode:n}=e;return"string"==typeof t?Q.resolve(process.cwd(),t):"string"==typeof n?Q.resolve(process.cwd(),n):Q.join(process.cwd(),"latest-run")}}const ui={},di=["server-response-time","render-blocking-resources","redirects","critical-request-chains","uses-text-compression","uses-rel-preconnect","uses-rel-preload","font-display","unminified-javascript","unminified-css","unused-css-rules"],mi={fcpRelevantAudits:di,lcpRelevantAudits:[...di,"largest-contentful-paint-element","prioritize-lcp-image","unused-javascript","efficient-animated-content","total-byte-weight","lcp-lazy-loaded"],tbtRelevantAudits:["long-tasks","third-party-summary","third-party-facades","bootup-time","mainthread-work-breakdown","dom-size","duplicated-javascript","legacy-javascript","viewport"],clsRelevantAudits:["layout-shift-elements","non-composited-animations","unsized-images"],inpRelevantAudits:["work-during-interaction"]},pi={performanceCategoryTitle:"Performance",
budgetsGroupTitle:"Budgets",budgetsGroupDescription:"Performance budgets set standards for the performance of your site.",metricGroupTitle:"Metrics",loadOpportunitiesGroupTitle:"Opportunities",loadOpportunitiesGroupDescription:"These suggestions can help your page load faster. They don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",diagnosticsGroupTitle:"Diagnostics",
diagnosticsGroupDescription:"More information about the performance of your application. These numbers don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",a11yCategoryDescription:"These checks highlight opportunities to [improve the accessibility of your web app](https://developer.chrome.com/docs/lighthouse/accessibility/). Only a subset of accessibility issues can be automatically detected so manual testing is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://web.dev/how-to-review/).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility best practices.",a11yColorContrastGroupTitle:"Contrast",
a11yColorContrastGroupDescription:"These are opportunities to improve the legibility of your content.",a11yNamesLabelsGroupTitle:"Names and labels",a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio and video",
a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improve the experience for users with hearing or vision impairments.",a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or list data using assistive technology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is following basic search engine optimization advice. There are many additional factors Lighthouse does not score here that may affect your search ranking, including performance on [Core Web Vitals](https://web.dev/learn-core-web-vitals/). [Learn more about Google Search Essentials](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",
seoMobileGroupDescription:"Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn how to make pages mobile-friendly](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better understand your app’s content.",seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",pwaCategoryTitle:"PWA",pwaCategoryDescription:"These checks validate the aspects of a Progressive Web App. [Learn what makes a good Progressive Web App](https://web.dev/pwa-checklist/).",pwaCategoryManualDescription:"These checks are required by the baseline [PWA Checklist](https://web.dev/pwa-checklist/) but are not automatically checked by Lighthouse. They do not affect your score but it's important that you verify them manually.",
bestPracticesCategoryTitle:"Best Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General",pwaInstallableGroupTitle:"Installable",pwaOptimizedGroupTitle:"PWA Optimized"},gi=createIcuMessageFn("core/config/default-config.js",pi),hi={settings:Qr,artifacts:[{id:"DevtoolsLog",gatherer:"devtools-log"},{id:"Trace",gatherer:"trace"},{id:"Accessibility",gatherer:"accessibility"},{id:"AnchorElements",gatherer:"anchor-elements"},{id:"CacheContents",gatherer:"cache-contents"},{id:"ConsoleMessages",gatherer:"console-messages"},{id:"CSSUsage",gatherer:"css-usage"},{id:"Doctype",gatherer:"dobetterweb/doctype"},{id:"DOMStats",gatherer:"dobetterweb/domstats"},{id:"EmbeddedContent",gatherer:"seo/embedded-content"},{id:"FontSize",gatherer:"seo/font-size"},{id:"Inputs",gatherer:"inputs"},{id:"GlobalListeners",gatherer:"global-listeners"},{
id:"IFrameElements",gatherer:"iframe-elements"},{id:"ImageElements",gatherer:"image-elements"},{id:"InstallabilityErrors",gatherer:"installability-errors"},{id:"InspectorIssues",gatherer:"inspector-issues"},{id:"JsUsage",gatherer:"js-usage"},{id:"LinkElements",gatherer:"link-elements"},{id:"MainDocumentContent",gatherer:"main-document-content"},{id:"MetaElements",gatherer:"meta-elements"},{id:"NetworkUserAgent",gatherer:"network-user-agent"},{id:"OptimizedImages",gatherer:"dobetterweb/optimized-images"},{id:"ResponseCompression",gatherer:"dobetterweb/response-compression"},{id:"RobotsTxt",gatherer:"seo/robots-txt"},{id:"ServiceWorker",gatherer:"service-worker"},{id:"ScriptElements",gatherer:"script-elements"},{id:"Scripts",gatherer:"scripts"},{id:"SourceMaps",gatherer:"source-maps"},{id:"Stacks",gatherer:"stacks"},{id:"TagsBlockingFirstPaint",gatherer:"dobetterweb/tags-blocking-first-paint"},{id:"TapTargets",gatherer:"seo/tap-targets"},{id:"TraceElements",gatherer:"trace-elements"},{
id:"ViewportDimensions",gatherer:"viewport-dimensions"},{id:"WebAppManifest",gatherer:"web-app-manifest"},{id:"devtoolsLogs",gatherer:"devtools-log-compat"},{id:"traces",gatherer:"trace-compat"},{id:"FullPageScreenshot",gatherer:"full-page-screenshot"},{id:"BFCacheFailures",gatherer:"bf-cache-failures"}],
audits:["is-on-https","service-worker","viewport","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/first-meaningful-paint","metrics/speed-index","screenshot-thumbnails","final-screenshot","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","metrics/experimental-interaction-to-next-paint","errors-in-console","server-response-time","metrics/interactive","user-timings","critical-request-chains","redirects","installable-manifest","splash-screen","themed-omnibox","maskable-icon","content-width","image-aspect-ratio","image-size-responsive","preload-fonts","deprecations","mainthread-work-breakdown","bootup-time","uses-rel-preload","uses-rel-preconnect","font-display","diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","performance-budget","timing-budget","resource-summary","third-party-summary","third-party-facades","largest-contentful-paint-element","lcp-lazy-loaded","layout-shift-elements","long-tasks","no-unload-listeners","non-composited-animations","unsized-images","valid-source-maps","prioritize-lcp-image","csp-xss","script-treemap-data","manual/pwa-cross-browser","manual/pwa-page-transitions","manual/pwa-each-page-has-url","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-command-name","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-input-field-name","accessibility/aria-meter-name","accessibility/aria-progressbar-name","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-toggle-field-name","accessibility/aria-tooltip-name","accessibility/aria-treeitem-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id-active","accessibility/duplicate-id-aria","accessibility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/html-xml-lang-mismatch","accessibility/image-alt","accessibility/input-button-name","accessibility/input-image-alt","accessibility/label","accessibility/link-name","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/tabindex","accessibility/table-fake-caption","accessibility/td-has-header","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessibility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","accessibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/uses-long-cache-ttl","byte-efficiency/total-byte-weight","byte-efficiency/offscreen-images","byte-efficiency/render-blocking-resources","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","byte-efficiency/modern-image-formats","byte-efficiency/uses-optimized-images","byte-efficiency/uses-text-compression","byte-efficiency/uses-responsive-images","byte-efficiency/efficient-animated-content","byte-efficiency/duplicated-javascript","byte-efficiency/legacy-javascript","byte-efficiency/uses-responsive-images-snapshot","dobetterweb/doctype","dobetterweb/charset","dobetterweb/dom-size","dobetterweb/geolocation-on-start","dobetterweb/inspector-issues","dobetterweb/no-document-write","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/paste-preventing-inputs","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners","seo/meta-description","seo/http-status-code","seo/font-size","seo/link-text","seo/crawlable-anchors","seo/is-crawlable","seo/robots-txt","seo/tap-targets","seo/hreflang","seo/plugins","seo/canonical","seo/manual/structured-data","work-during-interaction","bf-cache"],
groups:{metrics:{title:gi(pi.metricGroupTitle)},"load-opportunities":{title:gi(pi.loadOpportunitiesGroupTitle),description:gi(pi.loadOpportunitiesGroupDescription)},budgets:{title:gi(pi.budgetsGroupTitle),description:gi(pi.budgetsGroupDescription)},diagnostics:{title:gi(pi.diagnosticsGroupTitle),description:gi(pi.diagnosticsGroupDescription)},"pwa-installable":{title:gi(pi.pwaInstallableGroupTitle)},"pwa-optimized":{title:gi(pi.pwaOptimizedGroupTitle)},"a11y-best-practices":{title:gi(pi.a11yBestPracticesGroupTitle),description:gi(pi.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:gi(pi.a11yColorContrastGroupTitle),description:gi(pi.a11yColorContrastGroupDescription)},"a11y-names-labels":{title:gi(pi.a11yNamesLabelsGroupTitle),description:gi(pi.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:gi(pi.a11yNavigationGroupTitle),description:gi(pi.a11yNavigationGroupDescription)},"a11y-aria":{title:gi(pi.a11yAriaGroupTitle),
description:gi(pi.a11yAriaGroupDescription)},"a11y-language":{title:gi(pi.a11yLanguageGroupTitle),description:gi(pi.a11yLanguageGroupDescription)},"a11y-audio-video":{title:gi(pi.a11yAudioVideoGroupTitle),description:gi(pi.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:gi(pi.a11yTablesListsVideoGroupTitle),description:gi(pi.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:gi(pi.seoMobileGroupTitle),description:gi(pi.seoMobileGroupDescription)},"seo-content":{title:gi(pi.seoContentGroupTitle),description:gi(pi.seoContentGroupDescription)},"seo-crawl":{title:gi(pi.seoCrawlingGroupTitle),description:gi(pi.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:gi(pi.bestPracticesTrustSafetyGroupTitle)},"best-practices-ux":{title:gi(pi.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:gi(pi.bestPracticesBrowserCompatGroupTitle)},"best-practices-general":{title:gi(pi.bestPracticesGeneralGroupTitle)},hidden:{title:""}},categories:{
performance:{title:gi(pi.performanceCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"first-contentful-paint",weight:10,group:"metrics",acronym:"FCP",relevantAudits:mi.fcpRelevantAudits},{id:"largest-contentful-paint",weight:25,group:"metrics",acronym:"LCP",relevantAudits:mi.lcpRelevantAudits},{id:"total-blocking-time",weight:30,group:"metrics",acronym:"TBT",relevantAudits:mi.tbtRelevantAudits},{id:"cumulative-layout-shift",weight:25,group:"metrics",acronym:"CLS",relevantAudits:mi.clsRelevantAudits},{id:"speed-index",weight:10,group:"metrics",acronym:"SI"},{id:"experimental-interaction-to-next-paint",weight:0,group:"metrics",acronym:"INP",relevantAudits:mi.inpRelevantAudits},{id:"interactive",weight:0,group:"hidden",acronym:"TTI"},{id:"max-potential-fid",weight:0,group:"hidden"},{id:"first-meaningful-paint",weight:0,acronym:"FMP",group:"hidden"},{id:"render-blocking-resources",weight:0},{id:"uses-responsive-images",weight:0},{id:"offscreen-images",
weight:0},{id:"unminified-css",weight:0},{id:"unminified-javascript",weight:0},{id:"unused-css-rules",weight:0},{id:"unused-javascript",weight:0},{id:"uses-optimized-images",weight:0},{id:"modern-image-formats",weight:0},{id:"uses-text-compression",weight:0},{id:"uses-rel-preconnect",weight:0},{id:"server-response-time",weight:0},{id:"redirects",weight:0},{id:"uses-rel-preload",weight:0},{id:"uses-http2",weight:0},{id:"efficient-animated-content",weight:0},{id:"duplicated-javascript",weight:0},{id:"legacy-javascript",weight:0},{id:"prioritize-lcp-image",weight:0},{id:"total-byte-weight",weight:0},{id:"uses-long-cache-ttl",weight:0},{id:"dom-size",weight:0},{id:"critical-request-chains",weight:0},{id:"user-timings",weight:0},{id:"bootup-time",weight:0},{id:"mainthread-work-breakdown",weight:0},{id:"font-display",weight:0},{id:"resource-summary",weight:0},{id:"third-party-summary",weight:0},{id:"third-party-facades",weight:0},{id:"largest-contentful-paint-element",weight:0},{
id:"lcp-lazy-loaded",weight:0},{id:"layout-shift-elements",weight:0},{id:"uses-passive-event-listeners",weight:0},{id:"no-document-write",weight:0},{id:"long-tasks",weight:0},{id:"non-composited-animations",weight:0},{id:"unsized-images",weight:0},{id:"viewport",weight:0},{id:"uses-responsive-images-snapshot",weight:0},{id:"work-during-interaction",weight:0},{id:"bf-cache",weight:0},{id:"performance-budget",weight:0,group:"budgets"},{id:"timing-budget",weight:0,group:"budgets"},{id:"network-requests",weight:0,group:"hidden"},{id:"network-rtt",weight:0,group:"hidden"},{id:"network-server-latency",weight:0,group:"hidden"},{id:"main-thread-tasks",weight:0,group:"hidden"},{id:"diagnostics",weight:0,group:"hidden"},{id:"metrics",weight:0,group:"hidden"},{id:"screenshot-thumbnails",weight:0,group:"hidden"},{id:"final-screenshot",weight:0,group:"hidden"},{id:"script-treemap-data",weight:0,group:"hidden"}]},accessibility:{title:gi(pi.a11yCategoryTitle),
description:gi(pi.a11yCategoryDescription),manualDescription:gi(pi.a11yCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"accesskeys",weight:3,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-command-name",weight:3,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:3,group:"a11y-aria"},{id:"aria-input-field-name",weight:3,group:"a11y-aria"},{id:"aria-meter-name",weight:3,group:"a11y-aria"},{id:"aria-progressbar-name",weight:3,group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:10,group:"a11y-aria"},{id:"aria-toggle-field-name",weight:3,group:"a11y-aria"},{id:"aria-tooltip-name",weight:3,group:"a11y-aria"},{id:"aria-treeitem-name",weight:3,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,
group:"a11y-aria"},{id:"aria-valid-attr",weight:10,group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:3,group:"a11y-navigation"},{id:"color-contrast",weight:3,group:"a11y-color-contrast"},{id:"definition-list",weight:3,group:"a11y-tables-lists"},{id:"dlitem",weight:3,group:"a11y-tables-lists"},{id:"document-title",weight:3,group:"a11y-names-labels"},{id:"duplicate-id-active",weight:3,group:"a11y-navigation"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:2,group:"a11y-names-labels"},{id:"frame-title",weight:3,group:"a11y-names-labels"},{id:"heading-order",weight:2,group:"a11y-navigation"},{id:"html-has-lang",weight:3,group:"a11y-language"},{id:"html-lang-valid",weight:3,group:"a11y-language"},{id:"html-xml-lang-mismatch",weight:2,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"input-button-name",weight:10,group:"a11y-names-labels"},{id:"input-image-alt",weight:10,
group:"a11y-names-labels"},{id:"label",weight:10,group:"a11y-names-labels"},{id:"link-name",weight:3,group:"a11y-names-labels"},{id:"list",weight:3,group:"a11y-tables-lists"},{id:"listitem",weight:3,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:3,group:"a11y-navigation"},{id:"table-fake-caption",weight:3,group:"a11y-tables-lists"},{id:"td-has-header",weight:10,group:"a11y-tables-lists"},{id:"td-headers-attr",weight:3,group:"a11y-tables-lists"},{id:"th-has-data-cells",weight:3,group:"a11y-tables-lists"},{id:"valid-lang",weight:3,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"logical-tab-order",weight:0},{id:"focusable-controls",weight:0},{id:"interactive-element-affordance",weight:0},{id:"managed-focus",weight:0},{id:"focus-traps",weight:0},{id:"custom-controls-labels",weight:0},{
id:"custom-controls-roles",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"use-landmarks",weight:0}]},"best-practices":{title:gi(pi.bestPracticesCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"is-on-https",weight:1,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,group:"best-practices-trust-safety"},{id:"csp-xss",weight:0,group:"best-practices-trust-safety"},{id:"paste-preventing-inputs",weight:1,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"preload-fonts",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"no-unload-listeners",weight:1,group:"best-practices-general"},{id:"js-libraries",
weight:0,group:"best-practices-general"},{id:"deprecations",weight:1,group:"best-practices-general"},{id:"errors-in-console",weight:1,group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-practices-general"},{id:"inspector-issues",weight:1,group:"best-practices-general"}]},seo:{title:gi(pi.seoCategoryTitle),description:gi(pi.seoCategoryDescription),manualDescription:gi(pi.seoCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"viewport",weight:1,group:"seo-mobile"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-content"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"is-crawlable",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,
group:"seo-content"},{id:"font-size",weight:1,group:"seo-mobile"},{id:"plugins",weight:1,group:"seo-content"},{id:"tap-targets",weight:1,group:"seo-mobile"},{id:"structured-data",weight:0}]},pwa:{title:gi(pi.pwaCategoryTitle),description:gi(pi.pwaCategoryDescription),manualDescription:gi(pi.pwaCategoryManualDescription),supportedModes:["navigation"],auditRefs:[{id:"installable-manifest",weight:2,group:"pwa-installable"},{id:"service-worker",weight:1,group:"pwa-optimized"},{id:"splash-screen",weight:1,group:"pwa-optimized"},{id:"themed-omnibox",weight:1,group:"pwa-optimized"},{id:"content-width",weight:1,group:"pwa-optimized"},{id:"viewport",weight:2,group:"pwa-optimized"},{id:"maskable-icon",weight:1,group:"pwa-optimized"},{id:"pwa-cross-browser",weight:0},{id:"pwa-page-transitions",weight:0},{id:"pwa-each-page-has-url",weight:0}]}}};Object.defineProperty(hi,"UIStrings",{enumerable:!1,get:()=>pi});const fi=JSON.parse(JSON.stringify(hi))
;if(!fi.categories)throw new Error("Default config should always have categories");delete fi.artifacts;const yi=["experimental-interaction-to-next-paint","uses-responsive-images-snapshot","work-during-interaction"];function assertValidPluginName(e,t){if(!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories?.[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}function assertValidFRGatherer(e){const t=e.instance,n=t.name;if("object"!=typeof t.meta)throw new Error(`${n} gatherer did not provide a meta object.`);if(0===t.meta.supportedModes.length)throw new Error(`${n} gatherer did not support any gather modes.`);if("function"!=typeof t.getArtifact||t.getArtifact===FRGatherer.prototype.getArtifact)throw new Error(`${n} gatherer did not define a "getArtifact" method.`)}function assertValidAudit(e){
const{implementation:t,path:n}=e,a=n||t?.meta?.id||"Unknown audit";if("function"!=typeof t.audit||t.audit===Audit.audit)throw new Error(`${a} has no audit() method.`);if("string"!=typeof t.meta.id)throw new Error(`${a} has no meta.id property, or the property is not a string.`);if(!isStringOrIcuMessage(t.meta.title))throw new Error(`${a} has no meta.title property, or the property is not a string.`);const r=t.meta.scoreDisplayMode||Audit.SCORING_MODES.BINARY;if(!isStringOrIcuMessage(t.meta.failureTitle)&&r===Audit.SCORING_MODES.BINARY)throw new Error(`${a} has no meta.failureTitle and should.`);if(!isStringOrIcuMessage(t.meta.description))throw new Error(`${a} has no meta.description property, or the property is not a string.`);if(""===t.meta.description)throw new Error(`${a} has an empty meta.description string. Please add a description for the UI.`)
;if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(`${a} has no meta.requiredArtifacts property, or the property is not an array.`)}function assertValidCategories(e,t,n){if(!e)return;const a=new Map((t||[]).map((e=>[e.implementation.meta.id,e])));Object.keys(e).forEach((t=>{e[t].auditRefs.forEach(((e,r)=>{if(!e.id)throw new Error(`missing an audit id at ${t}[${r}]`);const o=a.get(e.id);if(!o)throw new Error(`could not find ${e.id} audit for category ${t}`);const i="manual"===o.implementation.meta.scoreDisplayMode;if("accessibility"===t&&!e.group&&!i)throw new Error(`${e.id} accessibility audit does not have a group`);if(e.weight>0&&i)throw new Error(`${e.id} is manual but has a positive weight`);if(e.group&&(!n||!n[e.group]))throw new Error(`${e.id} references unknown group ${e.group}`)}))}))}function assertValidSettings(e){
if(!e.formFactor)throw new Error("`settings.formFactor` must be defined as 'mobile' or 'desktop'. See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md");if(!e.screenEmulation.disabled&&e.screenEmulation.mobile!==("mobile"===e.formFactor))throw new Error(`Screen emulation mobile setting (${e.screenEmulation.mobile}) does not match formFactor setting (${e.formFactor}). See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md`)}function assertValidConfig(e){const{warnings:t}=function assertValidFRNavigations(e){if(!e||!e.length)return{warnings:[]};const t=[],n=e[0];if("fatal"!==n.loadFailureMode){const e=n.loadFailureMode,a=[`"${n.id}" is the first navigation but had a failure mode of ${e}.`,"The first navigation will always be treated as loadFailureMode=fatal."].join(" ");t.push(a),n.loadFailureMode="fatal"}const a=e.map((e=>e.id)),r=a.find(((e,t)=>a.slice(t+1).some((t=>e===t))))
;if(r)throw new Error(`Navigation must have unique identifiers, but "${r}" was repeated.`);return{warnings:t}}(e.navigations);for(const t of e.artifacts||[])assertValidFRGatherer(t.gatherer);for(const t of e.audits||[])assertValidAudit(t);return assertValidCategories(e.categories,e.audits,e.groups),assertValidSettings(e.settings),{warnings:t}}function throwInvalidDependencyOrder(e,t){throw new Error([`Failed to find dependency "${t}" for "${e}" artifact`,"Check that...",`  1. A gatherer exposes a matching Symbol that satisfies "${t}".`,`  2. "${t}" is configured to run before "${e}"`].join("\n"))}function isArrayOfUnknownObjects$1(e){return Array.isArray(e)&&e.every(isObjectOfUnknownProperties$1)}function isObjectOfUnknownProperties$1(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function isNumber(e){return"number"==typeof e&&!isNaN(e)}fi.audits=fi.audits?.filter((e=>!yi.find((t=>e.toString().endsWith(t))))),
fi.categories.performance.auditRefs=fi.categories.performance.auditRefs.filter((e=>!yi.includes(e.id))),fi.passes=[{passName:"defaultPass",recordTrace:!0,useThrottling:!0,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,gatherers:["css-usage","js-usage","viewport-dimensions","console-messages","anchor-elements","image-elements","link-elements","meta-elements","script-elements","scripts","iframe-elements","inputs","main-document-content","global-listeners","dobetterweb/doctype","dobetterweb/domstats","dobetterweb/optimized-images","dobetterweb/response-compression","dobetterweb/tags-blocking-first-paint","seo/font-size","seo/embedded-content","seo/robots-txt","seo/tap-targets","accessibility","trace-elements","inspector-issues","source-maps","web-app-manifest","installability-errors","stacks","full-page-screenshot","bf-cache-failures"]},{passName:"offlinePass",loadFailureMode:"ignore",gatherers:["service-worker"]}];class Budget{
static assertNoExcessProperties(e,t){const n=Object.keys(e);if(n.length>0){const e=n.join(", ");throw new Error(`${t} has unrecognized properties: [${e}]`)}}static assertNoDuplicateStrings(e,t){const n=new Set;for(const a of e){if(n.has(a))throw new Error(`${t} has duplicate entry of type '${a}'`);n.add(a)}}static validateResourceBudget(e){const{resourceType:t,budget:n,...a}=e;Budget.assertNoExcessProperties(a,"Resource Budget");const r=["total","document","script","stylesheet","image","media","font","other","third-party"];if(!r.includes(t))throw new Error(`Invalid resource type: ${t}. \nValid resource types are: ${r.join(", ")}`);if(!isNumber(n))throw new Error(`Invalid budget: ${n}`);return{resourceType:t,budget:n}}static throwInvalidPathError(e,t){
throw new Error(`Invalid path ${e}. ${t}\n'Path' should be specified using the 'robots.txt' format.\nLearn more about the 'robots.txt' format here:\nhttps://developers.google.com/search/reference/robots_txt#url-matching-based-on-path-values`)}static validatePath(e){if(void 0!==e){if("string"==typeof e)return e.startsWith("/")?(e.match(/\*/g)||[]).length>1?this.throwInvalidPathError(e,"Path should only contain one '*'."):(e.match(/\$/g)||[]).length>1?this.throwInvalidPathError(e,"Path should only contain one '$' character."):e.includes("$")&&!e.endsWith("$")&&this.throwInvalidPathError(e,"'$' character should only occur at end of path."):this.throwInvalidPathError(e,"Path should start with '/'."),e;this.throwInvalidPathError(e,"Path should be a string.")}}static getMatchingBudget(e,t){if(null!==e&&void 0!==t)for(let n=e.length-1;n>=0;n--){const a=e[n];if(this.urlMatchesPattern(t,a.path))return a}}static urlMatchesPattern(e,t="/"){
const n=new URL(e),a=n.pathname+n.search,r=t.includes("*"),o=t.includes("$");if(!r&&!o)return a.startsWith(t);if(!r&&o)return a===t.slice(0,-1);if(r&&!o){const[e,n]=t.split("*"),r=a.slice(e.length);return a.startsWith(e)&&r.includes(n)}if(r&&o){const[e,n]=t.split("*"),r=a.slice(e.length);return a.startsWith(e)&&r.endsWith(n.slice(0,-1))}return!1}static validateTimingBudget(e){const{metric:t,budget:n,...a}=e;Budget.assertNoExcessProperties(a,"Timing Budget");const r=["first-contentful-paint","interactive","first-meaningful-paint","max-potential-fid","total-blocking-time","speed-index","largest-contentful-paint","cumulative-layout-shift"];if(!r.includes(t))throw new Error(`Invalid timing metric: ${t}. \nValid timing metrics are: ${r.join(", ")}`);if(!isNumber(n))throw new Error(`Invalid budget: ${n}`);return{metric:t,budget:n}}static validateHostname(e){const t=`${e} is not a valid hostname.`;if(0===e.length)throw new Error(t);if(e.includes("/"))throw new Error(t)
;if(e.includes(":"))throw new Error(t);if(e.includes("*")&&(!e.startsWith("*.")||e.lastIndexOf("*")>0))throw new Error(t);return e}static validateHostnames(e){if(Array.isArray(e)&&e.every((e=>"string"==typeof e)))return e.map(Budget.validateHostname);if(void 0!==e)throw new Error("firstPartyHostnames should be defined as an array of strings.")}static initializeBudget(e){if(!isArrayOfUnknownObjects$1(e=JSON.parse(JSON.stringify(e))))throw new Error("Budget file is not defined as an array of budgets.");return e.map(((e,t)=>{const n={},{path:a,options:r,resourceSizes:o,resourceCounts:i,timings:s,...c}=e;if(Budget.assertNoExcessProperties(c,"Budget"),n.path=Budget.validatePath(a),isObjectOfUnknownProperties$1(r)){const{firstPartyHostnames:e,...t}=r;Budget.assertNoExcessProperties(t,"Options property"),n.options={},n.options.firstPartyHostnames=Budget.validateHostnames(e)}else if(void 0!==r)throw new Error(`Invalid options property in budget at index ${t}`)
;if(isArrayOfUnknownObjects$1(o))n.resourceSizes=o.map(Budget.validateResourceBudget),Budget.assertNoDuplicateStrings(n.resourceSizes.map((e=>e.resourceType)),`budgets[${t}].resourceSizes`);else if(void 0!==o)throw new Error(`Invalid resourceSizes entry in budget at index ${t}`);if(isArrayOfUnknownObjects$1(i))n.resourceCounts=i.map(Budget.validateResourceBudget),Budget.assertNoDuplicateStrings(n.resourceCounts.map((e=>e.resourceType)),`budgets[${t}].resourceCounts`);else if(void 0!==i)throw new Error(`Invalid resourceCounts entry in budget at index ${t}`);if(isArrayOfUnknownObjects$1(s))n.timings=s.map(Budget.validateTimingBudget),Budget.assertNoDuplicateStrings(n.timings.map((e=>e.metric)),`budgets[${t}].timings`);else if(void 0!==s)throw new Error(`Invalid timings entry in budget at index ${t}`);return n}))}}function isArrayOfUnknownObjects(e){return Array.isArray(e)&&e.every(isObjectOfUnknownProperties)}function isObjectOfUnknownProperties(e){
return"object"==typeof e&&null!==e&&!Array.isArray(e)}function objectIsGatherMode(e){return"string"==typeof e&&("navigation"===e||"timespan"===e||"snapshot"===e)}function assertNoExcessProperties(e,t,n=""){n&&(n+=" ");const a=Object.keys(e);if(a.length>0){const e=a.join(", ");throw new Error(`${t} has unrecognized ${n}properties: [${e}]`)}}class ConfigPlugin{static _parseAuditsList(e,t){if(void 0!==e){if(!isArrayOfUnknownObjects(e))throw new Error(`${t} has an invalid audits array.`);return e.map((e=>{const{path:n,...a}=e;if(assertNoExcessProperties(a,t,"audit"),"string"!=typeof n)throw new Error(`${t} has a missing audit path.`);return{path:n}}))}}static _parseAuditRefsList(e,t){if(!isArrayOfUnknownObjects(e))throw new Error(`${t} has no valid auditsRefs.`);return e.map((e=>{const{id:n,weight:a,group:r,...o}=e;if(assertNoExcessProperties(o,t,"auditRef"),"string"!=typeof n)throw new Error(`${t} has an invalid auditRef id.`)
;if("number"!=typeof a)throw new Error(`${t} has an invalid auditRef weight.`);if("string"!=typeof r&&void 0!==r)throw new Error(`${t} has an invalid auditRef group.`);return{id:n,weight:a,group:r?`${t}-${r}`:r}}))}static _parseCategory(e,t){if(!isObjectOfUnknownProperties(e))throw new Error(`${t} has no valid category.`);const{title:n,description:a,manualDescription:r,auditRefs:o,supportedModes:i,...s}=e;if(assertNoExcessProperties(s,t,"category"),!isStringOrIcuMessage(n))throw new Error(`${t} has an invalid category tile.`);if(!isStringOrIcuMessage(a)&&void 0!==a)throw new Error(`${t} has an invalid category description.`);if(!isStringOrIcuMessage(r)&&void 0!==r)throw new Error(`${t} has an invalid category manualDescription.`);if(!function isArrayOfGatherModes(e){return!!Array.isArray(e)&&e.every(objectIsGatherMode)}(i)&&void 0!==i)throw new Error(`${t} supportedModes must be an array, valid array values are "navigation", "timespan", and "snapshot".`);return{title:n,
auditRefs:ConfigPlugin._parseAuditRefsList(o,t),description:a,manualDescription:r,supportedModes:i}}static _parseGroups(e,t){if(void 0===e)return;if(!isObjectOfUnknownProperties(e))throw new Error(`${t} groups json is not defined as an object.`);const n=Object.entries(e),a={};return n.forEach((([e,n])=>{if(!isObjectOfUnknownProperties(n))throw new Error(`${t} has a group not defined as an object.`);const{title:r,description:o,...i}=n;if(assertNoExcessProperties(i,t,"group"),!isStringOrIcuMessage(r))throw new Error(`${t} has an invalid group title.`);if(!isStringOrIcuMessage(o)&&void 0!==o)throw new Error(`${t} has an invalid group description.`);a[`${t}-${e}`]={title:r,description:o}})),a}static parsePlugin(e,t){if(!isObjectOfUnknownProperties(e=JSON.parse(JSON.stringify(e))))throw new Error(`${t} is not defined as an object.`);const{audits:n,category:a,groups:r,...o}=e;return assertNoExcessProperties(o,t),{audits:ConfigPlugin._parseAuditsList(n,t),categories:{
[t]:ConfigPlugin._parseCategory(a,t)},groups:ConfigPlugin._parseGroups(r,t)}}}const bi={resolve(){throw new Error("createRequire.resolve is not supported in bundled Lighthouse")}};function isBundledEnvironment(){if(globalThis.isDevtools||globalThis.isLightrider)return!0;try{return bi.resolve("lighthouse-logger"),!1}catch(e){return!0}}const vi=function _mergeConfigFragment(e,t,n=!1){if(null==e)return t;if(void 0===t)return e;if(Array.isArray(t)){if(n)return t;if(!Array.isArray(e))throw new TypeError("Expected array but got "+typeof e);const a=e.slice();return t.forEach((e=>{a.some((t=>Xa(t,e)))||a.push(e)})),a}if("object"==typeof t){if("object"!=typeof e)throw new TypeError("Expected object but got "+typeof e);if(Array.isArray(e))throw new TypeError("Expected object but got Array");return Object.keys(t).forEach((a=>{const r=n||"settings"===a&&"object"==typeof e[a];e[a]=_mergeConfigFragment(e[a],t[a],r)})),e}return t}
;const wi=new Map([["../gather/gatherers/accessibility",Promise.resolve().then((function(){return Oi}))],["../gather/gatherers/anchor-elements",Promise.resolve().then((function(){return Bi}))],["../gather/gatherers/bf-cache-failures",Promise.resolve().then((function(){return Ui}))],["../gather/gatherers/cache-contents",Promise.resolve().then((function(){return ji}))],["../gather/gatherers/console-messages",Promise.resolve().then((function(){return zi}))],["../gather/gatherers/css-usage",Promise.resolve().then((function(){return qi}))],["../gather/gatherers/devtools-log-compat",Promise.resolve().then((function(){return Wi}))],["../gather/gatherers/devtools-log",Promise.resolve().then((function(){return Vr}))],["../gather/gatherers/dobetterweb/doctype",Promise.resolve().then((function(){return $i}))],["../gather/gatherers/dobetterweb/domstats",Promise.resolve().then((function(){return Vi}))],["../gather/gatherers/dobetterweb/optimized-images",Promise.resolve().then((function(){return Gi
}))],["../gather/gatherers/dobetterweb/response-compression",Promise.resolve().then((function(){return $s}))],["../gather/gatherers/dobetterweb/tags-blocking-first-paint",Promise.resolve().then((function(){return Vs}))],["../gather/gatherers/full-page-screenshot",Promise.resolve().then((function(){return Hs}))],["../gather/gatherers/global-listeners",Promise.resolve().then((function(){return Gs}))],["../gather/gatherers/iframe-elements",Promise.resolve().then((function(){return Ys}))],["../gather/gatherers/image-elements",Promise.resolve().then((function(){return Js}))],["../gather/gatherers/inputs",Promise.resolve().then((function(){return Xs}))],["../gather/gatherers/inspector-issues",Promise.resolve().then((function(){return Zs}))],["../gather/gatherers/installability-errors",Promise.resolve().then((function(){return Qs}))],["../gather/gatherers/js-usage",Promise.resolve().then((function(){return ec}))],["../gather/gatherers/link-elements",Promise.resolve().then((function(){
return hc}))],["../gather/gatherers/main-document-content",Promise.resolve().then((function(){return fc}))],["../gather/gatherers/meta-elements",Promise.resolve().then((function(){return yc}))],["../gather/gatherers/network-user-agent",Promise.resolve().then((function(){return _o}))],["../gather/gatherers/script-elements",Promise.resolve().then((function(){return bc}))],["../gather/gatherers/scripts",Promise.resolve().then((function(){return vc}))],["../gather/gatherers/seo/embedded-content",Promise.resolve().then((function(){return wc}))],["../gather/gatherers/seo/font-size",Promise.resolve().then((function(){return Ks}))],["../gather/gatherers/seo/robots-txt",Promise.resolve().then((function(){return Dc}))],["../gather/gatherers/seo/tap-targets",Promise.resolve().then((function(){return Tc}))],["../gather/gatherers/service-worker",Promise.resolve().then((function(){return Cc}))],["../gather/gatherers/source-maps",Promise.resolve().then((function(){return Sc
}))],["../gather/gatherers/stacks",Promise.resolve().then((function(){return _c}))],["../gather/gatherers/trace-compat",Promise.resolve().then((function(){return Ac}))],["../gather/gatherers/trace-elements",Promise.resolve().then((function(){return Nc}))],["../gather/gatherers/trace",Promise.resolve().then((function(){return Gr}))],["../gather/gatherers/viewport-dimensions",Promise.resolve().then((function(){return Lc}))],["../gather/gatherers/web-app-manifest",Promise.resolve().then((function(){return Uc}))],["../audits/accessibility/accesskeys",Promise.resolve().then((function(){return $c}))],["../audits/accessibility/aria-allowed-attr",Promise.resolve().then((function(){return Gc}))],["../audits/accessibility/aria-command-name",Promise.resolve().then((function(){return Jc}))],["../audits/accessibility/aria-hidden-body",Promise.resolve().then((function(){return Qc}))],["../audits/accessibility/aria-hidden-focus",Promise.resolve().then((function(){return nl
}))],["../audits/accessibility/aria-input-field-name",Promise.resolve().then((function(){return ol}))],["../audits/accessibility/aria-meter-name",Promise.resolve().then((function(){return cl}))],["../audits/accessibility/aria-progressbar-name",Promise.resolve().then((function(){return dl}))],["../audits/accessibility/aria-required-attr",Promise.resolve().then((function(){return gl}))],["../audits/accessibility/aria-required-children",Promise.resolve().then((function(){return yl}))],["../audits/accessibility/aria-required-parent",Promise.resolve().then((function(){return wl}))],["../audits/accessibility/aria-roles",Promise.resolve().then((function(){return Tl}))],["../audits/accessibility/aria-toggle-field-name",Promise.resolve().then((function(){return _l}))],["../audits/accessibility/aria-tooltip-name",Promise.resolve().then((function(){return Fl}))],["../audits/accessibility/aria-treeitem-name",Promise.resolve().then((function(){return Il
}))],["../audits/accessibility/aria-valid-attr-value",Promise.resolve().then((function(){return Ll}))],["../audits/accessibility/aria-valid-attr",Promise.resolve().then((function(){return Bl}))],["../audits/accessibility/button-name",Promise.resolve().then((function(){return zl}))],["../audits/accessibility/bypass",Promise.resolve().then((function(){return $l}))],["../audits/accessibility/color-contrast",Promise.resolve().then((function(){return Gl}))],["../audits/accessibility/definition-list",Promise.resolve().then((function(){return Jl}))],["../audits/accessibility/dlitem",Promise.resolve().then((function(){return Ql}))],["../audits/accessibility/document-title",Promise.resolve().then((function(){return nu}))],["../audits/accessibility/duplicate-id-active",Promise.resolve().then((function(){return ou}))],["../audits/accessibility/duplicate-id-aria",Promise.resolve().then((function(){return cu
}))],["../audits/accessibility/form-field-multiple-labels",Promise.resolve().then((function(){return du}))],["../audits/accessibility/frame-title",Promise.resolve().then((function(){return gu}))],["../audits/accessibility/heading-order",Promise.resolve().then((function(){return yu}))],["../audits/accessibility/html-has-lang",Promise.resolve().then((function(){return wu}))],["../audits/accessibility/html-lang-valid",Promise.resolve().then((function(){return Tu}))],["../audits/accessibility/html-xml-lang-mismatch",Promise.resolve().then((function(){return _u}))],["../audits/accessibility/image-alt",Promise.resolve().then((function(){return Fu}))],["../audits/accessibility/input-button-name",Promise.resolve().then((function(){return Iu}))],["../audits/accessibility/input-image-alt",Promise.resolve().then((function(){return Lu}))],["../audits/accessibility/label",Promise.resolve().then((function(){return Bu}))],["../audits/accessibility/link-name",Promise.resolve().then((function(){
return zu}))],["../audits/accessibility/list",Promise.resolve().then((function(){return $u}))],["../audits/accessibility/listitem",Promise.resolve().then((function(){return Gu}))],["../audits/accessibility/manual/custom-controls-labels",Promise.resolve().then((function(){return Yu}))],["../audits/accessibility/manual/custom-controls-roles",Promise.resolve().then((function(){return Ku}))],["../audits/accessibility/manual/focus-traps",Promise.resolve().then((function(){return Ju}))],["../audits/accessibility/manual/focusable-controls",Promise.resolve().then((function(){return Xu}))],["../audits/accessibility/manual/interactive-element-affordance",Promise.resolve().then((function(){return Zu}))],["../audits/accessibility/manual/logical-tab-order",Promise.resolve().then((function(){return Qu}))],["../audits/accessibility/manual/managed-focus",Promise.resolve().then((function(){return ed}))],["../audits/accessibility/manual/offscreen-content-hidden",Promise.resolve().then((function(){
return td}))],["../audits/accessibility/manual/use-landmarks",Promise.resolve().then((function(){return nd}))],["../audits/accessibility/manual/visual-order-follows-dom",Promise.resolve().then((function(){return ad}))],["../audits/accessibility/meta-refresh",Promise.resolve().then((function(){return id}))],["../audits/accessibility/meta-viewport",Promise.resolve().then((function(){return ld}))],["../audits/accessibility/object-alt",Promise.resolve().then((function(){return md}))],["../audits/accessibility/tabindex",Promise.resolve().then((function(){return hd}))],["../audits/accessibility/table-fake-caption",Promise.resolve().then((function(){return bd}))],["../audits/accessibility/td-has-header",Promise.resolve().then((function(){return Dd}))],["../audits/accessibility/td-headers-attr",Promise.resolve().then((function(){return Cd}))],["../audits/accessibility/th-has-data-cells",Promise.resolve().then((function(){return Ad
}))],["../audits/accessibility/valid-lang",Promise.resolve().then((function(){return xd}))],["../audits/accessibility/video-caption",Promise.resolve().then((function(){return Md}))],["../audits/autocomplete",Promise.resolve().then((function(){return Ud}))],["../audits/bf-cache",Promise.resolve().then((function(){return Gd}))],["../audits/bootup-time",Promise.resolve().then((function(){return tm}))],["../audits/byte-efficiency/duplicated-javascript",Promise.resolve().then((function(){return fm}))],["../audits/byte-efficiency/efficient-animated-content",Promise.resolve().then((function(){return vm}))],["../audits/byte-efficiency/legacy-javascript",Promise.resolve().then((function(){return Tm}))],["../audits/byte-efficiency/modern-image-formats",Promise.resolve().then((function(){return _m}))],["../audits/byte-efficiency/offscreen-images",Promise.resolve().then((function(){return Rm}))],["../audits/byte-efficiency/render-blocking-resources",Promise.resolve().then((function(){return Om
}))],["../audits/byte-efficiency/total-byte-weight",Promise.resolve().then((function(){return jm}))],["../audits/byte-efficiency/unminified-css",Promise.resolve().then((function(){return Vm}))],["../audits/byte-efficiency/unminified-javascript",Promise.resolve().then((function(){return Ym}))],["../audits/byte-efficiency/unused-css-rules",Promise.resolve().then((function(){return Xm}))],["../audits/byte-efficiency/unused-javascript",Promise.resolve().then((function(){return ap}))],["../audits/byte-efficiency/uses-long-cache-ttl",Promise.resolve().then((function(){return sp}))],["../audits/byte-efficiency/uses-optimized-images",Promise.resolve().then((function(){return up}))],["../audits/byte-efficiency/uses-responsive-images-snapshot",Promise.resolve().then((function(){return yp}))],["../audits/byte-efficiency/uses-responsive-images",Promise.resolve().then((function(){return gp}))],["../audits/byte-efficiency/uses-text-compression",Promise.resolve().then((function(){return wp
}))],["../audits/content-width",Promise.resolve().then((function(){return Tp}))],["../audits/critical-request-chains",Promise.resolve().then((function(){return Ap}))],["../audits/csp-xss",Promise.resolve().then((function(){return gg}))],["../audits/deprecations",Promise.resolve().then((function(){return Eg}))],["../audits/diagnostics",Promise.resolve().then((function(){return Tg}))],["../audits/dobetterweb/charset",Promise.resolve().then((function(){return Fg}))],["../audits/dobetterweb/doctype",Promise.resolve().then((function(){return Ig}))],["../audits/dobetterweb/dom-size",Promise.resolve().then((function(){return Lg}))],["../audits/dobetterweb/geolocation-on-start",Promise.resolve().then((function(){return Ug}))],["../audits/dobetterweb/inspector-issues",Promise.resolve().then((function(){return qg}))],["../audits/dobetterweb/js-libraries",Promise.resolve().then((function(){return Vg}))],["../audits/dobetterweb/no-document-write",Promise.resolve().then((function(){return Yg
}))],["../audits/dobetterweb/notification-on-start",Promise.resolve().then((function(){return Xg}))],["../audits/dobetterweb/paste-preventing-inputs",Promise.resolve().then((function(){return eh}))],["../audits/dobetterweb/uses-http2",Promise.resolve().then((function(){return rh}))],["../audits/dobetterweb/uses-passive-event-listeners",Promise.resolve().then((function(){return sh}))],["../audits/errors-in-console",Promise.resolve().then((function(){return uh}))],["../audits/final-screenshot",Promise.resolve().then((function(){return mh}))],["../audits/font-display",Promise.resolve().then((function(){return bh}))],["../audits/image-aspect-ratio",Promise.resolve().then((function(){return Dh}))],["../audits/image-size-responsive",Promise.resolve().then((function(){return Ch}))],["../audits/installable-manifest",Promise.resolve().then((function(){return Fh}))],["../audits/is-on-https",Promise.resolve().then((function(){return Mh
}))],["../audits/largest-contentful-paint-element",Promise.resolve().then((function(){return zh}))],["../audits/layout-shift-elements",Promise.resolve().then((function(){return $h}))],["../audits/lcp-lazy-loaded",Promise.resolve().then((function(){return Gh}))],["../audits/long-tasks",Promise.resolve().then((function(){return Xh}))],["../audits/main-thread-tasks",Promise.resolve().then((function(){return Zh}))],["../audits/mainthread-work-breakdown",Promise.resolve().then((function(){return tf}))],["../audits/manual/pwa-cross-browser",Promise.resolve().then((function(){return rf}))],["../audits/manual/pwa-each-page-has-url",Promise.resolve().then((function(){return cf}))],["../audits/manual/pwa-page-transitions",Promise.resolve().then((function(){return df}))],["../audits/maskable-icon",Promise.resolve().then((function(){return gf}))],["../audits/metrics",Promise.resolve().then((function(){return Wf}))],["../audits/metrics/cumulative-layout-shift",Promise.resolve().then((function(){
return Hf}))],["../audits/metrics/experimental-interaction-to-next-paint",Promise.resolve().then((function(){return Kf}))],["../audits/metrics/first-contentful-paint-3g",Promise.resolve().then((function(){return Xf}))],["../audits/metrics/first-contentful-paint",Promise.resolve().then((function(){return ey}))],["../audits/metrics/first-meaningful-paint",Promise.resolve().then((function(){return ay}))],["../audits/metrics/interactive",Promise.resolve().then((function(){return iy}))],["../audits/metrics/largest-contentful-paint",Promise.resolve().then((function(){return ly}))],["../audits/metrics/max-potential-fid",Promise.resolve().then((function(){return my}))],["../audits/metrics/speed-index",Promise.resolve().then((function(){return hy}))],["../audits/metrics/total-blocking-time",Promise.resolve().then((function(){return by}))],["../audits/network-requests",Promise.resolve().then((function(){return vy}))],["../audits/network-rtt",Promise.resolve().then((function(){return Ey
}))],["../audits/network-server-latency",Promise.resolve().then((function(){return Sy}))],["../audits/no-unload-listeners",Promise.resolve().then((function(){return ky}))],["../audits/non-composited-animations",Promise.resolve().then((function(){return Iy}))],["../audits/oopif-iframe-test-audit",Promise.resolve().then((function(){return My}))],["../audits/performance-budget",Promise.resolve().then((function(){return Oy}))],["../audits/predictive-perf",Promise.resolve().then((function(){return Uy}))],["../audits/preload-fonts",Promise.resolve().then((function(){return Wy}))],["../audits/prioritize-lcp-image",Promise.resolve().then((function(){return Hy}))],["../audits/redirects",Promise.resolve().then((function(){return Ky}))],["../audits/resource-summary",Promise.resolve().then((function(){return Zy}))],["../audits/screenshot-thumbnails",Promise.resolve().then((function(){return Qy}))],["../audits/script-elements-test-audit",Promise.resolve().then((function(){return eb
}))],["../audits/script-treemap-data",Promise.resolve().then((function(){return tb}))],["../audits/seo/canonical",Promise.resolve().then((function(){return rb}))],["../audits/seo/crawlable-anchors",Promise.resolve().then((function(){return sb}))],["../audits/seo/font-size",Promise.resolve().then((function(){return mb}))],["../audits/seo/hreflang",Promise.resolve().then((function(){return fb}))],["../audits/seo/http-status-code",Promise.resolve().then((function(){return vb}))],["../audits/seo/is-crawlable",Promise.resolve().then((function(){return _b}))],["../audits/seo/link-text",Promise.resolve().then((function(){return xb}))],["../audits/seo/manual/structured-data",Promise.resolve().then((function(){return Mb}))],["../audits/seo/meta-description",Promise.resolve().then((function(){return Pb}))],["../audits/seo/plugins",Promise.resolve().then((function(){return $b}))],["../audits/seo/robots-txt",Promise.resolve().then((function(){return ev
}))],["../audits/seo/tap-targets",Promise.resolve().then((function(){return av}))],["../audits/server-response-time",Promise.resolve().then((function(){return iv}))],["../audits/service-worker",Promise.resolve().then((function(){return lv}))],["../audits/splash-screen",Promise.resolve().then((function(){return mv}))],["../audits/themed-omnibox",Promise.resolve().then((function(){return hv}))],["../audits/third-party-facades",Promise.resolve().then((function(){return Ev}))],["../audits/third-party-summary",Promise.resolve().then((function(){return bv}))],["../audits/timing-budget",Promise.resolve().then((function(){return Sv}))],["../audits/unsized-images",Promise.resolve().then((function(){return kv}))],["../audits/user-timings",Promise.resolve().then((function(){return Iv}))],["../audits/uses-rel-preconnect",Promise.resolve().then((function(){return Lv}))],["../audits/uses-rel-preload",Promise.resolve().then((function(){return Bv
}))],["../audits/valid-source-maps",Promise.resolve().then((function(){return zv}))],["../audits/viewport",Promise.resolve().then((function(){return $v}))],["../audits/work-during-interaction",Promise.resolve().then((function(){return Gv}))],["lighthouse-plugin-publisher-ads",Promise.resolve().then((function(){return rw}))],["lighthouse-plugin-publisher-ads/audits/ad-blocking-tasks",Promise.resolve().then((function(){return _w}))],["lighthouse-plugin-publisher-ads/audits/ad-render-blocking-resources",Promise.resolve().then((function(){return xw}))],["lighthouse-plugin-publisher-ads/audits/ad-request-critical-path",Promise.resolve().then((function(){return Nw}))],["lighthouse-plugin-publisher-ads/audits/bid-request-from-page-start",Promise.resolve().then((function(){return Bw}))],["lighthouse-plugin-publisher-ads/audits/ad-request-from-page-start",Promise.resolve().then((function(){return zw
}))],["lighthouse-plugin-publisher-ads/audits/ad-top-of-viewport",Promise.resolve().then((function(){return Vw}))],["lighthouse-plugin-publisher-ads/audits/ads-in-viewport",Promise.resolve().then((function(){return Kw}))],["lighthouse-plugin-publisher-ads/audits/async-ad-tags",Promise.resolve().then((function(){return Zw}))],["lighthouse-plugin-publisher-ads/audits/blocking-load-events",Promise.resolve().then((function(){return nD}))],["lighthouse-plugin-publisher-ads/audits/bottleneck-requests",Promise.resolve().then((function(){return iD}))],["lighthouse-plugin-publisher-ads/audits/duplicate-tags",Promise.resolve().then((function(){return dD}))],["lighthouse-plugin-publisher-ads/audits/first-ad-render",Promise.resolve().then((function(){return hD}))],["lighthouse-plugin-publisher-ads/audits/full-width-slots",Promise.resolve().then((function(){return bD}))],["lighthouse-plugin-publisher-ads/audits/gpt-bids-parallel",Promise.resolve().then((function(){return DD
}))],["lighthouse-plugin-publisher-ads/audits/loads-gpt-from-official-source",Promise.resolve().then((function(){return CD}))],["lighthouse-plugin-publisher-ads/audits/loads-ad-tag-over-https",Promise.resolve().then((function(){return AD}))],["lighthouse-plugin-publisher-ads/audits/script-injected-tags",Promise.resolve().then((function(){return ID}))],["lighthouse-plugin-publisher-ads/audits/serial-header-bidding",Promise.resolve().then((function(){return UD}))],["lighthouse-plugin-publisher-ads/audits/tag-load-time",Promise.resolve().then((function(){return WD}))],["lighthouse-plugin-publisher-ads/audits/viewport-ad-density",Promise.resolve().then((function(){return HD}))],["lighthouse-plugin-publisher-ads/audits/cumulative-ad-shift",Promise.resolve().then((function(){return KD}))],["lighthouse-plugin-publisher-ads/audits/deprecated-api-usage",Promise.resolve().then((function(){return ZD
}))],["lighthouse-plugin-publisher-ads/audits/gpt-errors-overall",Promise.resolve().then((function(){return tE}))],["lighthouse-plugin-publisher-ads/audits/total-ad-blocking-time",Promise.resolve().then((function(){return oE}))],["lighthouse-plugin-soft-navigation",Promise.resolve().then((function(){return iE}))],["lighthouse-plugin-soft-navigation/audits/soft-nav-fcp",Promise.resolve().then((function(){return sE}))],["lighthouse-plugin-soft-navigation/audits/soft-nav-lcp",Promise.resolve().then((function(){return cE}))]]);async function requireWrapper(e){let t;if(Q.isAbsolute(e)&&(e=sr.pathToFileURL(e).href),wi.has(e)?t=await wi.get(e):(e.match(/\.(js|mjs|cjs)$/)||(e+=".js"),t=await import(e)),t.default)return t.default;const n=new Set(["meta"]),a=Object.keys(t).filter((e=>!!(t[e]&&t[e]instanceof Object)&&Object.getOwnPropertyNames(t[e]).some((e=>n.has(e)))));if(1===a.length)return a[0];if(a.length>1)throw new Error(`module '${e}' has too many possible exports`)
;throw new Error(`module '${e}' missing default export`)}function cleanFlagsForSettings(e={}){const t={};for(const n of Object.keys(e))n in Qr&&(t[n]=e[n]);return t}function resolveSettings(e={},t){const n=lookupLocale(t?.locale||e.locale),{defaultSettings:a}=ao,r=vi(deepClone(a),e,!0),o=vi(r,cleanFlagsForSettings(t),!0);return o.budgets&&(o.budgets=Budget.initializeBudget(o.budgets)),o.locale=n,!0===o.emulatedUserAgent&&(o.emulatedUserAgent=Zr[o.formFactor]),assertValidSettings(o),o}async function mergePlugins(e,t,n){const a=e.plugins||[],r=new Set([...a,...n?.plugins||[]]);for(const n of r){assertValidPluginName(e,n);const a=isBundledEnvironment()?n:resolveModulePath(n,t,"plugin"),r=await requireWrapper(a),o=ConfigPlugin.parsePlugin(r,n);e=vi(e,o)}return e}async function resolveGathererToDefn(e,t,n){const a=function expandGathererShorthand(e){if("string"==typeof e)return{path:e};if("implementation"in e||"instance"in e)return e;if("path"in e){
if("string"!=typeof e.path)throw new Error("Invalid Gatherer type "+JSON.stringify(e));return e}if("function"==typeof e)return{implementation:e};if(e&&"function"==typeof e.beforePass)return{instance:e};throw new Error("Invalid Gatherer type "+JSON.stringify(e))}(e);if(a.instance)return{instance:a.instance,implementation:a.implementation,path:a.path};if(a.implementation){return{instance:new(0,a.implementation),implementation:a.implementation,path:a.path}}if(a.path){return async function requireGatherer(e,t,n){const a=t.find((t=>t===`${e}.js`));let r=`../gather/gatherers/${e}`;a||(r=resolveModulePath(e,n,"gatherer"));const o=await requireWrapper(r);return{instance:new o,implementation:o,path:e}}(a.path,t,n)}throw new Error("Invalid expanded Gatherer: "+JSON.stringify(a))}async function resolveAuditsToDefns(e,t){if(!e)return null;const n=Runner.getAuditList(),a=e.map((async e=>{const a=function expandAuditShorthand(e){if("string"==typeof e)return{path:e,options:{}}
;if("implementation"in e&&"function"==typeof e.implementation.audit)return e;if("path"in e&&"string"==typeof e.path)return e;if("audit"in e&&"function"==typeof e.audit)return{implementation:e,options:{}};throw new Error("Invalid Audit type "+JSON.stringify(e))}(e);let r;return r="implementation"in a?a.implementation:await function requireAudit(e,t,n){const a=`${e}.js`;let r=`../audits/${e}`;if(!t.find((e=>e===a)))if(isBundledEnvironment())r=e;else{const t=resolveModulePath(e,n,"audit");r=isBundledEnvironment()?Q.relative(getModuleDirectory({url:"core/config/config-helpers.js"}),t):t}return requireWrapper(r)}(a.path,n,t),{implementation:r,path:a.path,options:a.options||{}}})),r=function(e){const t=[];for(const n of e){const e=n.path&&t.find((e=>e.path===n.path));e?e.options=Object.assign({},e.options,n.options):t.push(n)}return t}(await Promise.all(a));return r.forEach((e=>assertValidAudit(e))),r}function resolveModulePath(e,t,n){try{return bi.resolve(e)}catch(e){}try{
return bi.resolve(e,{paths:[process.cwd()]})}catch(e){}const a=Q.resolve(process.cwd(),e);try{return bi.resolve(a)}catch(e){}const r="Unable to locate "+(n?`${n}: `:"")+`\`${e}\`.\n     Tried to resolve the module from these locations:\n       ${getModuleDirectory({url:"core/config/config-helpers.js"})}\n       ${a}`;if(!t)throw new Error(r);const o=Q.resolve(t,e);try{return bi.resolve(o)}catch(e){}try{return bi.resolve(e,{paths:[t]})}catch(e){}throw new Error(r+`\n       ${o}`)}function shallowClone(e){return"object"==typeof e?Object.assign(Object.create(Object.getPrototypeOf(e)),e):e}function deepClone(e){return JSON.parse(JSON.stringify(e))}function deepCloneConfigJson(e){const t=deepClone(e);if(Array.isArray(t.passes)&&Array.isArray(e.passes))for(let n=0;n<t.passes.length;n++){t.passes[n].gatherers=(e.passes[n].gatherers||[]).map((e=>shallowClone(e)))}return Array.isArray(e.audits)&&(t.audits=e.audits.map((e=>shallowClone(e)))),
Array.isArray(e.artifacts)&&(t.artifacts=e.artifacts.map((e=>({...e,gatherer:shallowClone(e.gatherer)})))),t}const Di=Object.keys({fetchTime:"",LighthouseRunWarnings:"",HostFormFactor:"",HostUserAgent:"",NetworkUserAgent:"",BenchmarkIndex:"",BenchmarkIndexes:"",GatherContext:"",traces:"",devtoolsLogs:"",settings:"",URL:"",Timing:"",PageLoadError:""}),Ei=["WebAppManifest","InstallabilityErrors","Stacks","FullPageScreenshot"],Ti={FullPageScreenshot:1,BFCacheFailures:1};class LegacyResolvedConfig{static async fromJson(e,t){const n={msg:"Create config",id:"lh:init:config"};Log.time(n,"verbose");let a=t?.configPath;if(e||(e=fi,a=Q.resolve(getModuleDirectory({url:"core/legacy/config/config.js"}),"./legacy-default-config.js")),a&&!Q.isAbsolute(a))throw new Error("configPath must be an absolute path.");if((e=deepCloneConfigJson(e)).extends){if("lighthouse:default"!==e.extends)throw new Error("`lighthouse:default` is the only valid extension method.")
;e=LegacyResolvedConfig.extendConfigJSON(deepCloneConfigJson(fi),e)}const r=a?Q.dirname(a):void 0,o=resolveSettings((e=await mergePlugins(e,r,t)).settings||{},t),i=LegacyResolvedConfig.augmentPassesWithDefaults(e.passes);LegacyResolvedConfig.adjustDefaultPassForThrottling(o,i);const s=await LegacyResolvedConfig.requireGatherers(i,r),c=await LegacyResolvedConfig.requireAudits(e.audits,r),l=new LegacyResolvedConfig(e,{settings:o,passes:s,audits:c});return Log.timeEnd(n),l}constructor(e,t){this.settings=t.settings,this.passes=t.passes,this.audits=t.audits,this.categories=e.categories||null,this.groups=e.groups||null,LegacyResolvedConfig.filterConfigIfNeeded(this),function assertValidPasses(e,t){if(!Array.isArray(e))return;const n=LegacyResolvedConfig.getGatherersRequestedByAudits(t),a=new Set(Di);e.forEach(((e,t)=>{0===t&&"fatal"!==e.loadFailureMode&&(Log.warn(`"${e.passName}" is the first pass but was marked as non-fatal. The first pass will always be treated as loadFailureMode=fatal.`),
e.loadFailureMode="fatal"),e.gatherers.forEach((e=>{const t=e.instance;a.add(t.name);const r=n.has(t.name),o=Ei.includes(t.name);if(!r&&!o){const e=`${t.name} gatherer requested, however no audit requires it.`;Log.warn("config",e)}}))}));for(const e of t||[]){const t=e.implementation.meta;for(const e of t.requiredArtifacts)if(!a.has(e))throw new Error(`${e} gatherer, required by audit ${t.id}, was not found in config.`)}const r=new Set;e.forEach((e=>{const t=e.passName;if(r.has(t))throw new Error(`Passes must have unique names (repeated passName: ${t}.`);r.add(t)}))}(this.passes,this.audits),assertValidCategories(this.categories,this.audits,this.groups)}getPrintString(){const e=deepClone(this);if(e.passes)for(const t of e.passes)for(const e of t.gatherers)e.implementation=void 0,e.instance=void 0;if(e.audits)for(const t of e.audits)t.implementation=void 0,0===Object.keys(t.options).length&&(t.options=void 0);return replaceIcuMessages(e,e.settings.locale),JSON.stringify(e,null,2)}
static extendConfigJSON(e,t){if(t.passes&&e.passes){for(const n of t.passes){const t=n.passName||eo.passName,a=e.passes.find((e=>e.passName===t));a?vi(a,n):e.passes.push(n)}delete t.passes}return vi(e,t)}static augmentPassesWithDefaults(e){if(!e)return null;const{defaultPassConfig:t}=ao;return e.map((e=>vi(deepClone(t),e)))}static adjustDefaultPassForThrottling(e,t){if(!t||"devtools"!==e.throttlingMethod&&"provided"!==e.throttlingMethod)return;const n=t.find((e=>"defaultPass"===e.passName));if(!n)return;const a=no;n.pauseAfterFcpMs=Math.max(a.pauseAfterFcpMs,n.pauseAfterFcpMs),n.pauseAfterLoadMs=Math.max(a.pauseAfterLoadMs,n.pauseAfterLoadMs),n.cpuQuietThresholdMs=Math.max(a.cpuQuietThresholdMs,n.cpuQuietThresholdMs),n.networkQuietThresholdMs=Math.max(a.networkQuietThresholdMs,n.networkQuietThresholdMs)}static filterConfigIfNeeded(e){const t=e.settings;if(!(t.onlyCategories||t.onlyAudits||t.skipAudits||t.disableFullPageScreenshot))return
;const{categories:n,requestedAuditNames:a}=LegacyResolvedConfig.filterCategoriesAndAudits(e.categories,t),r=e.audits&&e.audits.filter((e=>a.has(e.implementation.meta.id))),o=LegacyResolvedConfig.getGatherersRequestedByAudits(r);for(const e of Ei)o.add(e);t.disableFullPageScreenshot&&o.delete("FullPageScreenshot");const i=LegacyResolvedConfig.generatePassesNeededByGatherers(e.passes,o);e.categories=n,e.audits=r,e.passes=i}static filterCategoriesAndAudits(e,t){if(!e)return{categories:null,requestedAuditNames:new Set};if(t.onlyAudits&&t.skipAudits)throw new Error("Cannot set both skipAudits and onlyAudits");const n={},a=!!t.onlyCategories,r=!!t.onlyAudits,o=t.onlyCategories||[],i=t.onlyAudits||[],s=t.skipAudits||[];o.forEach((t=>{e[t]||Log.warn("config",`unrecognized category in 'onlyCategories': ${t}`)}));const c=new Set(i.concat(s));for(const t of c){const n=Object.keys(e).find((n=>!!e[n].auditRefs.find((e=>e.id===t))))
;if(n)i.includes(t)&&o.includes(n)&&Log.warn("config",`${t} in 'onlyAudits' is already included by ${n} in 'onlyCategories'`);else{const e=s.includes(t)?"skipAudits":"onlyAudits";Log.warn("config",`unrecognized audit in '${e}': ${t}`)}}const l=new Set(i);return s.forEach((e=>l.delete(e))),Object.keys(e).forEach((t=>{const c=deepClone(e[t]);if(a&&r)o.includes(t)||(c.auditRefs=c.auditRefs.filter((e=>i.includes(e.id))));else if(a){if(!o.includes(t))return}else r&&(c.auditRefs=c.auditRefs.filter((e=>i.includes(e.id))));c.auditRefs=c.auditRefs.filter((e=>!s.includes(e.id))),c.auditRefs.length&&(n[t]=c,c.auditRefs.forEach((e=>l.add(e.id))))})),{categories:n,requestedAuditNames:l}}static getGatherersRequestedByAudits(e){if(!e)return new Set;const t=new Set;for(const n of e){const{requiredArtifacts:e,__internalOptionalArtifacts:a}=n.implementation.meta;e.forEach((e=>t.add(e))),a&&a.forEach((e=>t.add(e)))}return t}static generatePassesNeededByGatherers(e,t){if(!e)return null
;const n=t.has("traces");return e.map((e=>{if(e.gatherers=e.gatherers.filter((e=>{const n=e.instance;return t.has(n.name)})),e.recordTrace&&!n){const t=e.passName||"unknown pass";Log.warn("config",`Trace not requested by an audit, dropping trace in ${t}`),e.recordTrace=!1}return e})).filter((e=>!!e.recordTrace||("defaultPass"===e.passName||e.gatherers.length>0)))}static async requireAudits(e,t){const n={msg:"Requiring audits",id:"lh:config:requireAudits"};Log.time(n,"verbose");const a=await resolveAuditsToDefns(e,t);return Log.timeEnd(n),a}static async requireGatherers(e,t){if(!e)return null;const n={msg:"Requiring gatherers",id:"lh:config:requireGatherers"};Log.time(n,"verbose");const a=Runner.getGathererList(),r=e.map((async e=>{const n=await Promise.all(e.gatherers.map((e=>resolveGathererToDefn(e,a,t)))),r=Array.from(new Map(n.map((e=>[e.instance.name,e]))).values());return r.forEach((e=>function assertValidGatherer(e,t){if(t=t||e.name||"gatherer",
"function"!=typeof e.beforePass)throw new Error(`${t} has no beforePass() method.`);if("function"!=typeof e.pass)throw new Error(`${t} has no pass() method.`);if("function"!=typeof e.afterPass)throw new Error(`${t} has no afterPass() method.`)}(e.instance,e.path))),r.sort(((e,t)=>(Ti[e.instance.name]||0)-(Ti[t.instance.name]||0))),Object.assign(e,{gatherers:r})})),o=await Promise.all(r);return Log.timeEnd(n),o}}const Ci=EventEmitter;class ProtocolSession extends Ci{constructor(e){super(),this._cdpSession=e,this._targetInfo=void 0,this._nextProtocolTimeout=void 0,this._handleProtocolEvent=this._handleProtocolEvent.bind(this),this._cdpSession.on("*",this._handleProtocolEvent)}id(){return this._cdpSession.id()}_handleProtocolEvent(e,...t){this.emit(e,...t)}setTargetInfo(e){this._targetInfo=e}hasNextProtocolTimeout(){return void 0!==this._nextProtocolTimeout}getNextProtocolTimeout(){return this._nextProtocolTimeout||3e4}setNextProtocolTimeout(e){this._nextProtocolTimeout=e}
sendCommand(e,...t){const n=this.getNextProtocolTimeout();let a;this._nextProtocolTimeout=void 0;const r=new Promise(((t,r)=>{n!==1/0&&(a=setTimeout(r,n,new LighthouseError(LighthouseError.errors.PROTOCOL_TIMEOUT,{protocolMethod:e})))})),o=this._cdpSession.send(e,...t);return Promise.race([o,r]).finally((()=>{a&&clearTimeout(a)}))}async dispose(){this._cdpSession.off("*",this._handleProtocolEvent),await this._cdpSession.detach()}}const Si=EventEmitter;class TargetManager extends Si{constructor(e){super(),this._enabled=!1,this._rootCdpSession=e,this._mainFrameId="",this._targetIdToTargets=new Map,this._executionContextIdToDescriptions=new Map,this._onSessionAttached=this._onSessionAttached.bind(this),this._onFrameNavigated=this._onFrameNavigated.bind(this),this._onExecutionContextCreated=this._onExecutionContextCreated.bind(this),this._onExecutionContextDestroyed=this._onExecutionContextDestroyed.bind(this),this._onExecutionContextsCleared=this._onExecutionContextsCleared.bind(this)}
async _onFrameNavigated(e){if(!e.frame.parentId&&this._enabled)try{await this._rootCdpSession.send("Target.setAutoAttach",{autoAttach:!0,flatten:!0,waitForDebuggerOnStart:!0})}catch(e){if(this._enabled)throw e}}_findSession(e){for(const{session:t,cdpSession:n}of this._targetIdToTargets.values())if(n.id()===e)return t;throw new Error(`session ${e} not found`)}rootSession(){const e=this._rootCdpSession.id();return this._findSession(e)}mainFrameExecutionContexts(){return[...this._executionContextIdToDescriptions.values()].filter((e=>e.auxData.frameId===this._mainFrameId))}async _onSessionAttached(e){const t=new ProtocolSession(e);try{const n=await t.sendCommand("Target.getTargetInfo").catch((()=>null)),a=n?.targetInfo?.type,r="page"===a||"iframe"===a;if(!n||!r)return;const o=n.targetInfo.targetId;if(this._targetIdToTargets.has(o))return;t.setTargetInfo(n.targetInfo);const i=n.targetInfo.url||n.targetInfo.targetId;Log.verbose("target-manager",`target ${i} attached`)
;const s=this._getProtocolEventListener(a,t.id());e.on("*",s),e.on("sessionattached",this._onSessionAttached);const c={target:n.targetInfo,cdpSession:e,session:t,protocolListener:s};this._targetIdToTargets.set(o,c),await t.sendCommand("Network.enable"),await t.sendCommand("Target.setAutoAttach",{autoAttach:!0,flatten:!0,waitForDebuggerOnStart:!0})}catch(e){if(/Target closed/.test(e.message))return;throw e}finally{await t.sendCommand("Runtime.runIfWaitingForDebugger").catch((()=>{}))}}_onExecutionContextCreated(e){"__puppeteer_utility_world__"!==e.context.name&&"lighthouse_isolated_context"!==e.context.name&&this._executionContextIdToDescriptions.set(e.context.uniqueId,e.context)}_onExecutionContextDestroyed(e){this._executionContextIdToDescriptions.delete(e.executionContextUniqueId)}_onExecutionContextsCleared(){this._executionContextIdToDescriptions.clear()}_getProtocolEventListener(e,t){return(n,a)=>{const r={method:n,params:a,targetType:e,sessionId:t};this.emit("protocolevent",r)}}
async enable(){this._enabled||(this._enabled=!0,this._targetIdToTargets=new Map,this._executionContextIdToDescriptions=new Map,this._rootCdpSession.on("Page.frameNavigated",this._onFrameNavigated),this._rootCdpSession.on("Runtime.executionContextCreated",this._onExecutionContextCreated),this._rootCdpSession.on("Runtime.executionContextDestroyed",this._onExecutionContextDestroyed),this._rootCdpSession.on("Runtime.executionContextsCleared",this._onExecutionContextsCleared),await this._rootCdpSession.send("Page.enable"),await this._rootCdpSession.send("Runtime.enable"),this._mainFrameId=(await this._rootCdpSession.send("Page.getFrameTree")).frameTree.frame.id,await this._onSessionAttached(this._rootCdpSession))}async disable(){this._rootCdpSession.off("Page.frameNavigated",this._onFrameNavigated),this._rootCdpSession.off("Runtime.executionContextCreated",this._onExecutionContextCreated),this._rootCdpSession.off("Runtime.executionContextDestroyed",this._onExecutionContextDestroyed),
this._rootCdpSession.off("Runtime.executionContextsCleared",this._onExecutionContextsCleared);for(const{cdpSession:e,protocolListener:t}of this._targetIdToTargets.values())e.off("*",t),e.off("sessionattached",this._onSessionAttached);await this._rootCdpSession.send("Page.disable"),await this._rootCdpSession.send("Runtime.disable"),this._enabled=!1,this._targetIdToTargets=new Map,this._executionContextIdToDescriptions=new Map,this._mainFrameId=""}}const throwNotConnectedFn=()=>{throw new Error("Session not connected")},_i={setTargetInfo:throwNotConnectedFn,hasNextProtocolTimeout:throwNotConnectedFn,getNextProtocolTimeout:throwNotConnectedFn,setNextProtocolTimeout:throwNotConnectedFn,on:throwNotConnectedFn,once:throwNotConnectedFn,off:throwNotConnectedFn,sendCommand:throwNotConnectedFn,dispose:throwNotConnectedFn};class Driver{constructor(e){this._page=e,this._targetManager=void 0,this._executionContext=void 0,this._fetcher=void 0,this.defaultSession=_i}get executionContext(){
return this._executionContext?this._executionContext:throwNotConnectedFn()}get fetcher(){return this._fetcher?this._fetcher:throwNotConnectedFn()}get targetManager(){return this._targetManager?this._targetManager:throwNotConnectedFn()}async url(){return this._page.url()}async connect(){if(this.defaultSession!==_i)return;const e={msg:"Connecting to browser",id:"lh:driver:connect"};Log.time(e);const t=await this._page.target().createCDPSession();this._targetManager=new TargetManager(t),await this._targetManager.enable(),this.defaultSession=this._targetManager.rootSession(),this._executionContext=new ExecutionContext(this.defaultSession),this._fetcher=new Fetcher(this.defaultSession),Log.timeEnd(e)}async disconnect(){this.defaultSession!==_i&&(await(this._targetManager?.disable()),await this.defaultSession.dispose())}}function createDependencyError(e,t){return new Error(`Dependency "${e.id}" failed with exception: ${t.message}`)}const Ai={startInstrumentation:void 0,
startSensitiveInstrumentation:"startInstrumentation",stopSensitiveInstrumentation:"startSensitiveInstrumentation",stopInstrumentation:"stopSensitiveInstrumentation",getArtifact:"stopInstrumentation"};async function collectPhaseArtifacts(e){const{driver:t,page:n,artifactDefinitions:a,artifactState:r,baseArtifacts:o,phase:i,gatherMode:s,computedCache:c,settings:l}=e,u=Ai[i],d=u&&r[u]||{},m="getArtifact"===i;for(const e of a){Log.verbose(`artifacts:${i}`,e.id);const a=e.gatherer.instance,u=(d[e.id]||Promise.resolve()).then((async()=>{const u=m?await collectArtifactDependencies(e,r.getArtifact):{},d={msg:`Getting artifact: ${e.id}`,id:`lh:gather:getArtifact:${e.id}`};m&&Log.time(d);const p=await a[i]({gatherMode:s,driver:t,page:n,baseArtifacts:o,dependencies:u,computedCache:c,settings:l});return m&&Log.timeEnd(d),p}));await u.catch((()=>{})),r[i][e.id]=u}}async function collectArtifactDependencies(e,t){if(!e.dependencies)return{};const n=Object.entries(e.dependencies).map((async([e,n])=>{
const a=t[n.id];if(void 0===a)throw new Error(`"${n.id}" did not run`);if(a instanceof Error)throw createDependencyError(n,a);const r=Promise.resolve().then((()=>a)).catch((e=>Promise.reject(createDependencyError(n,e))));return[e,await r]}));return Object.fromEntries(await Promise.all(n))}async function awaitArtifacts(e){const t={};for(const[n,a]of Object.entries(e.getArtifact)){const e=await a.catch((e=>e));void 0!==e&&(t[n]=e)}return t}const ki=Object.keys({fetchTime:"",LighthouseRunWarnings:"",BenchmarkIndex:"",BenchmarkIndexes:"",settings:"",Timing:"",URL:"",PageLoadError:"",HostFormFactor:"",HostUserAgent:"",GatherContext:""}),Fi=[],xi=["Stacks","NetworkUserAgent","FullPageScreenshot"];function getAuditIdsInCategories(e,t){if(!e)return new Set;const n=(t=t||Object.keys(e)).map((t=>e[t])).flatMap((e=>e?.auditRefs||[]));return new Set(n.map((e=>e.id)))}function filterCategoriesByAvailableAudits(e,t){if(!e)return e
;const n=new Map(t.map((e=>[e.implementation.meta.id,e.implementation.meta]))),a=Object.entries(e).map((([e,t])=>{const a={...t,auditRefs:t.auditRefs.filter((e=>n.has(e.id)))},r=a.auditRefs.length<t.auditRefs.length,o=a.auditRefs.every((e=>{const t=n.get(e.id);return!!t&&t.scoreDisplayMode===Audit.SCORING_MODES.MANUAL}));return r&&o&&(a.auditRefs=[]),[e,a]})).filter((e=>"object"==typeof e[1]&&e[1].auditRefs.length));return Object.fromEntries(a)}function filterConfigByGatherMode(e,t){const n=function filterArtifactsByGatherMode(e,t){return e?e.filter((e=>e.gatherer.instance.meta.supportedModes.includes(t))):null}(e.artifacts,t),a=function filterAuditsByAvailableArtifacts(e,t){if(!e)return null;const n=new Set(t.map((e=>e.id)).concat(ki));return e.filter((e=>e.implementation.meta.requiredArtifacts.every((e=>n.has(e)))))}(function filterAuditsByGatherMode(e,t){return e?e.filter((e=>{const n=e.implementation.meta;return!n.supportedModes||n.supportedModes.includes(t)})):null
}(e.audits,t),n||[]),r=filterCategoriesByAvailableAudits(function filterCategoriesByGatherMode(e,t){if(!e)return null;const n=Object.entries(e).filter((([e,n])=>!n.supportedModes||n.supportedModes.includes(t)));return Object.fromEntries(n)}(e.categories,t),a||[]);return{...e,artifacts:n,audits:a,categories:r}}function filterConfigByExplicitFilters(e,t){const{onlyAudits:n,onlyCategories:a,skipAudits:r}=t;!function warnOnUnknownOnlyCategories(e,t){if(t)for(const n of t)e?.[n]||Log.warn("config",`unrecognized category in 'onlyCategories': ${n}`)}(e.categories,a);let o=getAuditIdsInCategories(e.categories,void 0);a?o=getAuditIdsInCategories(e.categories,a):n?o=new Set:e.categories&&Object.keys(e.categories).length||(o=new Set(e.audits?.map((e=>e.implementation.meta.id))));const i=new Set([...o,...n||[],...Fi].filter((e=>!r||!r.includes(e)))),s=i.size&&e.audits?e.audits.filter((e=>i.has(e.implementation.meta.id))):e.audits,c=function filterCategoriesByExplicitFilters(e,t){if(!e||!t)return e
;const n=Object.entries(e).filter((([e])=>t.includes(e)));return Object.fromEntries(n)}(filterCategoriesByAvailableAudits(e.categories,s||[]),a);let l=function filterArtifactsByAvailableAudits(e,t){if(!e)return null;if(!t)return e;const n=new Map(e.map((e=>[e.id,e]))),a=new Set([...xi,...t.flatMap((e=>e.implementation.meta.requiredArtifacts))]);let r=0;for(;r!==a.size;){r=a.size;for(const e of a){const t=n.get(e);if(t&&t.dependencies)for(const e of Object.values(t.dependencies))a.add(e.id)}}return e.filter((e=>a.has(e.id)))}(e.artifacts,s);l&&e.settings.disableFullPageScreenshot&&(l=l.filter((({id:e})=>"FullPageScreenshot"!==e)));const u=function filterNavigationsByAvailableArtifacts(e,t){if(!e)return e;const n=new Set(t.map((e=>e.id)).concat(ki));return e.map((e=>({...e,artifacts:e.artifacts.filter((e=>n.has(e.id)))}))).filter((e=>e.artifacts.length))}(e.navigations,l||[]);return{...e,artifacts:l,navigations:u,audits:s,categories:c}}const Ri=Q.join(getModuleDirectory({
url:"core/config/config.js"}),"../../config/default-config.js"),Ii={FullPageScreenshot:1,BFCacheFailures:1};function resolveExtensions(e){if(!e.extends)return e;if("lighthouse:default"!==e.extends)throw new Error("`lighthouse:default` is the only valid extension method.");const{artifacts:t,...n}=e,a=deepCloneConfigJson(hi),r=vi(a,n);return r.artifacts=function mergeConfigFragmentArrayByKey(e,t,n){const a=new Map,r=e||[];for(let e=0;e<r.length;e++){const t=r[e];a.set(n(t),{index:e,item:t})}for(const e of t||[]){const t=a.get(n(e));if(t){const n=t.item,a="object"==typeof e&&"object"==typeof n?vi(n,e,!0):e;r[t.index]=a}else r.push(e)}return r}(a.artifacts,t,(e=>e.id)),r}function resolveArtifactDependencies(e,t,n){if(!("dependencies"in t.instance.meta))return;const a=Object.entries(t.instance.meta.dependencies).map((([a,r])=>{const o=n.get(r);o||throwInvalidDependencyOrder(e.id,a);return function isValidArtifactDependency(e,t){const n={timespan:0,snapshot:1,navigation:2
},a=Math.min(...e.instance.meta.supportedModes.map((e=>n[e]))),r=Math.min(...t.instance.meta.supportedModes.map((e=>n[e])));return a===n.timespan?r===n.timespan:a!==n.snapshot||r===n.snapshot}(t,o.gatherer)||function throwInvalidArtifactDependency(e,t){throw new Error([`Dependency "${t}" for "${e}" artifact is invalid.`,"The dependency must be collected before the dependent."].join("\n"))}(e.id,a),[a,{id:o.id}]}));return Object.fromEntries(a)}function resolveFakeNavigations(e,t){if(!e)return null;const n={msg:"Resolve navigation definitions",id:"lh:config:resolveNavigationsToDefns"};Log.time(n,"verbose");const a={...to,artifacts:e,pauseAfterFcpMs:t.pauseAfterFcpMs,pauseAfterLoadMs:t.pauseAfterLoadMs,networkQuietThresholdMs:t.networkQuietThresholdMs,cpuQuietThresholdMs:t.cpuQuietThresholdMs,blankPage:t.blankPage};!function overrideNavigationThrottlingWindows(e,t){
e.disableThrottling||"simulate"!==t.throttlingMethod&&(e.cpuQuietThresholdMs=Math.max(e.cpuQuietThresholdMs||0,no.cpuQuietThresholdMs),e.networkQuietThresholdMs=Math.max(e.networkQuietThresholdMs||0,no.networkQuietThresholdMs),e.pauseAfterFcpMs=Math.max(e.pauseAfterFcpMs||0,no.pauseAfterFcpMs),e.pauseAfterLoadMs=Math.max(e.pauseAfterLoadMs||0,no.pauseAfterLoadMs))}(a,t);const r=[a];return function assertArtifactTopologicalOrder(e){const t=new Set;for(const n of e)for(const e of n.artifacts)if(t.add(e.id),e.dependencies)for(const[n,{id:a}]of Object.entries(e.dependencies))t.has(a)||throwInvalidDependencyOrder(e.id,n)}(r),Log.timeEnd(n),r}async function initializeConfig(e,t,n={}){const a={msg:"Initialize config",id:"lh:config"};Log.time(a,"verbose");let{configWorkingCopy:r,configDir:o}=function resolveWorkingCopy(e,t){let{configPath:n}=t;if(n&&!Q.isAbsolute(n))throw new Error("configPath must be an absolute path");e||(e=hi,n=Ri);const a=n?Q.dirname(n):void 0;return{
configWorkingCopy:deepCloneConfigJson(e),configPath:n,configDir:a}}(t,n);r=resolveExtensions(r),r=await mergePlugins(r,o,n);const i=resolveSettings(r.settings||{},n);!function overrideSettingsForGatherMode(e,t){"timespan"===t&&"simulate"===e.throttlingMethod&&(e.throttlingMethod="devtools")}(i,e);const s=await async function resolveArtifactsToDefns(e,t){if(!e)return null;const n={msg:"Resolve artifact definitions",id:"lh:config:resolveArtifactsToDefns"};Log.time(n,"verbose");const a=[...e];a.sort(((e,t)=>(Ii[e.id]||0)-(Ii[t.id]||0)));const r=new Map,o=Runner.getGathererList(),i=[];for(const e of a){const n=e.gatherer,a=await resolveGathererToDefn(n,o,t);if(!("meta"in a.instance))throw new Error(`${a.instance.name} gatherer does not have a Fraggle Rock meta obj`);const s={id:e.id,gatherer:a,dependencies:resolveArtifactDependencies(e,a,r)},c=s.gatherer.instance.meta.symbol;c&&r.set(c,s),i.push(s)}return Log.timeEnd(n),i}(r.artifacts,o);let c={artifacts:s,
navigations:resolveFakeNavigations(s,i),audits:await resolveAuditsToDefns(r.audits,o),categories:r.categories||null,groups:r.groups||null,settings:i};const{warnings:l}=assertValidConfig(c);return c=filterConfigByGatherMode(c,e),c=filterConfigByExplicitFilters(c,i),Log.timeEnd(a),{resolvedConfig:c,warnings:l}}async function startTimespanGather(e,t={}){const{flags:n={},config:a}=t;Log.setLevel(n.logLevel||"error");const{resolvedConfig:r}=await initializeConfig("timespan",a,n),o=new Driver(e);await o.connect();const i=new Map,s=r.artifacts||[],c=await getBaseArtifacts(r,o,{gatherMode:"timespan"}),l={startInstrumentation:{},startSensitiveInstrumentation:{},stopSensitiveInstrumentation:{},stopInstrumentation:{},getArtifact:{}},u={driver:o,page:e,artifactDefinitions:s,artifactState:l,baseArtifacts:c,computedCache:i,gatherMode:"timespan",settings:r.settings};await async function prepareTargetForTimespanMode(e,t){const n={msg:"Preparing target for timespan mode",id:"lh:prepare:timespanMode"}
;Log.time(n),await prepareDeviceEmulation(e,t),await prepareThrottlingAndNetwork(e.defaultSession,t,{disableThrottling:!1,blockedUrlPatterns:void 0}),await warmUpIntlSegmenter(e),Log.timeEnd(n)}(o,r.settings);const d=await enableAsyncStacks(o.defaultSession);return await collectPhaseArtifacts({phase:"startInstrumentation",...u}),await collectPhaseArtifacts({phase:"startSensitiveInstrumentation",...u}),{async endTimespanGather(){const e=await o.url(),t={resolvedConfig:r,computedCache:i};return{artifacts:await Runner.gather((async()=>{c.URL={finalDisplayedUrl:e},await collectPhaseArtifacts({phase:"stopSensitiveInstrumentation",...u}),await collectPhaseArtifacts({phase:"stopInstrumentation",...u}),await d(),await collectPhaseArtifacts({phase:"getArtifact",...u}),await o.disconnect();const t=await awaitArtifacts(l);return finalizeArtifacts(c,t)}),t),runnerOptions:t}}}}var Mi={};const Ni="127.0.0.1",Li=9222;async function _computeNavigationResult(e,t,n,a){
const{navigationError:r,mainDocumentUrl:o}=a,i=[...n.warnings,...a.warnings],s=await async function _collectDebugData(e,t){const n=t.artifactDefinitions.find((e=>e.gatherer.instance.meta.symbol===DevtoolsLog.symbol)),a=t.artifactDefinitions.find((e=>e.gatherer.instance.meta.symbol===Trace.symbol)),r=[n,a].filter((e=>Boolean(e)));if(!r.length)return{};await collectPhaseArtifacts({...t,phase:"getArtifact",artifactDefinitions:r});const o=t.artifactState.getArtifact,i=n?.id,s=i&&await o[i],c=s&&await bo.request(s,e),l=a?.id;return{devtoolsLog:s,records:c,trace:l&&await o[l]}}(e,t),c=s.records?getPageLoadError(r,{url:o,loadFailureMode:e.navigation.loadFailureMode,networkRecords:s.records,warnings:i}):r;if(c){const t=e.resolvedConfig.settings.locale,n=getFormatted(c.friendlyMessage,t);Log.error("NavigationRunner",n,a.requestedUrl);const r={},o=`pageLoadError-${e.navigation.id}`;return s.devtoolsLog&&(r.devtoolsLogs={[o]:s.devtoolsLog}),s.trace&&(r.traces={[o]:s.trace}),{pageLoadError:c,
artifacts:r,warnings:[...i,c.friendlyMessage]}}await collectPhaseArtifacts({phase:"getArtifact",...t});return{artifacts:await awaitArtifacts(t.artifactState),warnings:i,pageLoadError:void 0}}async function _navigation(e){const t={startInstrumentation:{},startSensitiveInstrumentation:{},stopSensitiveInstrumentation:{},stopInstrumentation:{},getArtifact:{}},n={url:await e.driver.url(),gatherMode:"navigation",driver:e.driver,page:e.page,computedCache:e.computedCache,artifactDefinitions:e.navigation.artifacts,artifactState:t,baseArtifacts:e.baseArtifacts,settings:e.resolvedConfig.settings},a=await async function _setupNavigation({requestor:e,driver:t,navigation:n,resolvedConfig:a}){"string"!=typeof e||a.settings.skipAboutBlank||await gotoURL(t,n.blankPage,{...n,waitUntil:["navigated"]});const{warnings:r}=await prepareTargetForIndividualNavigation(t.defaultSession,a.settings,{...n,requestor:e});return{warnings:r}}(e),r=await enableAsyncStacks(e.driver.defaultSession)
;await collectPhaseArtifacts({phase:"startInstrumentation",...n}),await collectPhaseArtifacts({phase:"startSensitiveInstrumentation",...n});const o=await async function _navigate(e){const{driver:t,resolvedConfig:n,requestor:a}=e;try{const{requestedUrl:r,mainDocumentUrl:o,warnings:i}=await gotoURL(t,a,{...e.navigation,debugNavigation:n.settings.debugNavigation,maxWaitForFcp:n.settings.maxWaitForFcp,maxWaitForLoad:n.settings.maxWaitForLoad,waitUntil:e.navigation.pauseAfterFcpMs?["fcp","load"]:["load"]});return{requestedUrl:r,mainDocumentUrl:o,navigationError:void 0,warnings:i}}catch(e){if(!(e instanceof LighthouseError))throw e;if("NO_FCP"!==e.code&&"PAGE_HUNG"!==e.code)throw e;if("string"!=typeof a)throw e;return{requestedUrl:a,mainDocumentUrl:a,navigationError:e,warnings:[]}}}(e);return Object.values(n.baseArtifacts).every(Boolean)||(n.baseArtifacts.URL={requestedUrl:o.requestedUrl,mainDocumentUrl:o.mainDocumentUrl,finalDisplayedUrl:await e.driver.url()}),n.url=o.mainDocumentUrl,
await collectPhaseArtifacts({phase:"stopSensitiveInstrumentation",...n}),await collectPhaseArtifacts({phase:"stopInstrumentation",...n}),await r(),await async function _cleanupNavigation({driver:e}){await clearThrottling(e.defaultSession)}(e),_computeNavigationResult(e,n,a,o)}async function navigationGather(e,t,n={}){const{flags:a={},config:r}=n;Log.setLevel(a.logLevel||"error");const{resolvedConfig:o}=await initializeConfig("navigation",r,a),i=new Map,s="function"==typeof t,c={resolvedConfig:o,computedCache:i};return{artifacts:await Runner.gather((async()=>{const n=s?t:UrlUtils.normalizeUrl(t);let r,c;if(!e){const{hostname:t=Ni,port:n=Li}=a;r=await Mi.connect({browserURL:`http://${t}:${n}`,defaultViewport:null}),c=await r.newPage(),e=c}const l={driver:new Driver(e),lhBrowser:r,lhPage:c,resolvedConfig:o,requestor:n},{baseArtifacts:u}=await async function _setup({driver:e,resolvedConfig:t,requestor:n}){await e.connect(),
"string"!=typeof n||t.settings.skipAboutBlank||await gotoURL(e,to.blankPage,{waitUntil:["navigated"]});const a=await getBaseArtifacts(t,e,{gatherMode:"navigation"});return await prepareTargetForNavigationMode(e,t.settings),{baseArtifacts:a}}(l),{artifacts:d}=await async function _navigations(e){const{driver:t,page:n,resolvedConfig:a,requestor:r,baseArtifacts:o,computedCache:i}=e;if(!a.artifacts||!a.navigations)throw new Error("No artifacts were defined on the config");const s={},c=[];for(const e of a.navigations){const l={driver:t,page:n,navigation:e,requestor:r,resolvedConfig:a,baseArtifacts:o,computedCache:i};let u=!1;const d=await _navigation(l);if("fatal"===e.loadFailureMode&&d.pageLoadError&&(s.PageLoadError=d.pageLoadError,u=!0),c.push(...d.warnings),Object.assign(s,d.artifacts),u)break}return{artifacts:{...s,LighthouseRunWarnings:c}}}({...l,page:e,baseArtifacts:u,computedCache:i})
;return await async function _cleanup({requestedUrl:e,driver:t,resolvedConfig:n,lhBrowser:a,lhPage:r}){!n.settings.disableStorageReset&&e&&await clearDataForOrigin(t.defaultSession,e),await t.disconnect(),await(r?.close()),await(a?.disconnect())}(l),finalizeArtifacts(u,d)}),c),runnerOptions:c}}async function legacyNavigation(e,t={},n,a){t.logLevel=t.logLevel||"error",Log.setLevel(t.logLevel);const r={resolvedConfig:await LegacyResolvedConfig.fromJson(n,t),computedCache:new Map},o=a||new ui(t.port,t.hostname),i=await Runner.gather((()=>{const t=UrlUtils.normalizeUrl(e);return Runner._gatherArtifactsFromBrowser(t,r,o)}),r);return Runner.audit(i,r)}async function navigation(e,t,n){const a=await navigationGather(e,t,n);return Runner.audit(a.artifacts,a.runnerOptions)}async function snapshot(e,t){const n=await async function snapshotGather(e,t={}){const{flags:n={},config:a}=t;Log.setLevel(n.logLevel||"error");const{resolvedConfig:r}=await initializeConfig("snapshot",a,n),o=new Driver(e)
;await o.connect();const i=new Map,s=await o.url(),c={resolvedConfig:r,computedCache:i};return{artifacts:await Runner.gather((async()=>{const t=await getBaseArtifacts(r,o,{gatherMode:"snapshot"});t.URL={finalDisplayedUrl:s};const n=r.artifacts||[],a={startInstrumentation:{},startSensitiveInstrumentation:{},stopSensitiveInstrumentation:{},stopInstrumentation:{},getArtifact:{}};return await collectPhaseArtifacts({phase:"getArtifact",gatherMode:"snapshot",driver:o,page:e,baseArtifacts:t,artifactDefinitions:n,artifactState:a,computedCache:i,settings:r.settings}),await o.disconnect(),finalizeArtifacts(t,await awaitArtifacts(a))}),c),runnerOptions:c}}(e,t);return Runner.audit(n.artifacts,n.runnerOptions)}async function startTimespan(e,t){const{endTimespanGather:n}=await startTimespanGather(e,t);return{endTimespan:async()=>{const e=await n();return Runner.audit(e.artifacts,e.runnerOptions)}}}createIcuMessageFn("core/user-flow.js",{defaultFlowName:"User flow ({url})",
defaultNavigationName:"Navigation report ({url})",defaultTimespanName:"Timespan report ({url})",defaultSnapshotName:"Snapshot report ({url})"});class RawConnection extends class Connection{constructor(){this._lastCommandId=0,this._callbacks=new Map,this._sessionIdToTargetType=new Map,this._eventEmitter=new EventEmitter}connect(){return Promise.reject(new Error("Not implemented"))}disconnect(){return Promise.reject(new Error("Not implemented"))}wsEndpoint(){return Promise.reject(new Error("Not implemented"))}sendCommand(e,t,...n){const a=n.length?n[0]:void 0;Log.formatProtocol("method => browser",{method:e,params:a},"verbose");const r=++this._lastCommandId,o=JSON.stringify({id:r,sessionId:t,method:e,params:a});return this.sendRawMessage(o),new Promise((t=>{this._callbacks.set(r,{method:e,resolve:t})}))}on(e,t){if("protocolevent"!==e)throw new Error('Only supports "protocolevent" events');if(!this._eventEmitter)throw new Error("Attempted to add event listener after connection disposed.")
;this._eventEmitter.on(e,t)}off(e,t){if("protocolevent"!==e)throw new Error('Only supports "protocolevent" events');if(!this._eventEmitter)throw new Error("Attempted to remove event listener after connection disposed.");this._eventEmitter.removeListener(e,t)}sendRawMessage(e){throw new Error("Not implemented")}handleRawMessage(e){const t=JSON.parse(e);if(!("id"in t)){if(Log.formatProtocol("<= event",{method:t.method,params:t.params},"verbose"),"Target.attachedToTarget"===t.method){const e=t.params.targetInfo.type;"page"!==e&&"iframe"!==e||this._sessionIdToTargetType.set(t.params.sessionId,e)}if(t.sessionId){const e=this._sessionIdToTargetType.get(t.sessionId);e&&(t.targetType=e)}return void this.emitProtocolEvent(t)}const n=this._callbacks.get(t.id);if(n)this._callbacks.delete(t.id),n.resolve(Promise.resolve().then((e=>{if(t.error)throw Log.formatProtocol("method <= browser ERR",{method:n.method},"error"),LighthouseError.fromProtocolMessage(n.method,t.error)
;return Log.formatProtocol("method <= browser OK",{method:n.method,params:t.result},"verbose"),t.result})));else{const e=t.error?.message;Log.formatProtocol("disowned method <= browser "+(e?"ERR":"OK"),{method:"UNKNOWN",params:e||t.result},"verbose")}}emitProtocolEvent(e){if(!this._eventEmitter)throw new Error("Attempted to emit event after connection disposed.");this._eventEmitter.emit("protocolevent",e)}dispose(){this._eventEmitter&&(this._eventEmitter.removeAllListeners(),this._eventEmitter=null),this._sessionIdToTargetType.clear()}}{constructor(e){super(),this._port=e,this._port.on("message",this.handleRawMessage.bind(this)),this._port.on("close",this.dispose.bind(this))}connect(){return Promise.resolve()}disconnect(){return this._port.close(),Promise.resolve()}sendRawMessage(e){this._port.send(e)}}globalThis.Buffer=Buffer$1,"undefined"!=typeof self?(globalThis.isDevtools=!0,self.setUpWorkerConnection=function setUpWorkerConnection(e){return new RawConnection(e)},
self.runLighthouse=legacyNavigation,self.runLighthouseNavigation=function runLighthouseNavigation(e,{page:t,...n}){return navigation(t,e,n)},self.navigation=navigation,self.startLighthouseTimespan=function startLighthouseTimespan({page:e,...t}){return startTimespan(e,t)},self.startTimespan=startTimespan,self.runLighthouseSnapshot=function runLighthouseSnapshot({page:e,...t}){return snapshot(e,t)},self.snapshot=snapshot,self.createConfig=function createConfig(e,t){const n={onlyCategories:e,screenEmulation:{disabled:!0}};return"desktop"===t&&(n.throttling=Jr.desktopDense4G,n.emulatedUserAgent=Zr.desktop,n.formFactor="desktop"),{extends:"lighthouse:default",plugins:["lighthouse-plugin-publisher-ads"],settings:n}},self.listenForStatus=function listenForStatus(e){Log.events.addListener("status",e),Log.events.addListener("warning",e)},self.registerLocaleData=function registerLocaleData(e,t){wr[e]=t},self.lookupLocale=function lookupCanonicalLocale(e){
return lookupLocale(e,function getCanonicalLocales(){return Er}())}):(global.runBundledLighthouse=async function lighthouse(e,t={},n,a){return navigation(a,e,{config:n,flags:t})},global.runBundledLighthouseLegacyNavigation=legacyNavigation);var Pi=Object.freeze({__proto__:null,default:{}});async function runA11yChecks(){const e=window.axe,t=`lighthouse-${Math.random()}`;e.configure({branding:{application:t},noHtml:!0});const n=await e.run(document,{elementRef:!0,runOnly:{type:"tag",values:["wcag2a","wcag2aa"]},resultTypes:["violations","inapplicable"],rules:{accesskeys:{enabled:!0},"area-alt":{enabled:!1},"aria-roledescription":{enabled:!1},"aria-treeitem-name":{enabled:!0},"audio-caption":{enabled:!1},blink:{enabled:!1},"duplicate-id":{enabled:!1},"frame-focusable-content":{enabled:!1},"frame-title-unique":{enabled:!1},"heading-order":{enabled:!0},"html-xml-lang-mismatch":{enabled:!0},"identical-links-same-purpose":{enabled:!1},"input-button-name":{enabled:!0},"link-in-text-block":{
enabled:!1},marquee:{enabled:!1},"meta-viewport":{enabled:!0},"nested-interactive":{enabled:!1},"no-autoplay-audio":{enabled:!1},"role-img-alt":{enabled:!1},"scrollable-region-focusable":{enabled:!1},"select-name":{enabled:!1},"server-side-image-map":{enabled:!1},"svg-img-alt":{enabled:!1},tabindex:{enabled:!0},"table-fake-caption":{enabled:!0},"td-has-header":{enabled:!0}}});return document.documentElement.scrollTop=0,{violations:n.violations.map(createAxeRuleResultArtifact),incomplete:n.incomplete.map(createAxeRuleResultArtifact),notApplicable:n.inapplicable.map((e=>({id:e.id}))),passes:n.passes.map((e=>({id:e.id}))),version:n.testEngine.version}}async function runA11yChecksAndResetScroll(){const e={x:window.scrollX,y:window.scrollY};try{return await runA11yChecks()}finally{window.scrollTo(e.x,e.y)}}function createAxeRuleResultArtifact(e){const t=e.nodes.map((e=>{
const{target:t,failureSummary:n,element:a}=e,r=getNodeDetails(a),o=new Set,impactToNumber=e=>[null,"minor","moderate","serious","critical"].indexOf(e),i=[...e.any,...e.all,...e.none].sort(((e,t)=>impactToNumber(t.impact)-impactToNumber(e.impact)));for(const e of i)for(const t of e.relatedNodes||[]){const e=t.element;if(o.size>=3)break;e&&(a!==e&&o.add(e))}return{target:t,failureSummary:n,node:r,relatedNodes:[...o].map(getNodeDetails)}})),n=e.error;let a;return n instanceof Error&&(a={name:n.name,message:n.message}),{id:e.id,impact:e.impact||void 0,tags:e.tags,nodes:t,error:a}}var Oi=Object.freeze({__proto__:null,default:class Accessibility extends FRGatherer{meta={supportedModes:["snapshot","navigation"]};static pageFns={runA11yChecks,createAxeRuleResultArtifact};getArtifact(e){return e.driver.executionContext.evaluate(runA11yChecksAndResetScroll,{args:[],useIsolation:!0,
deps:['/*! axe v4.7.2\n * Copyright (c) 2023 Deque Systems, Inc.\n *\n * Your use of this Source Code Form is subject to the terms of the Mozilla Public\n * License, v. 2.0. If a copy of the MPL was not distributed with this\n * file, You can obtain one at http://mozilla.org/MPL/2.0/.\n *\n * This entire copyright notice must appear in every copy of this file you\n * distribute or in any file that contains substantial portions of this source\n * code.\n */\n!function e(t){var n=t,a=t.document;function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=o||{};function u(e){this.name="SupportError",this.cause=e.cause,this.message="`".concat(e.cause,"` - feature unsupported in your environment."),e.ruleId&&(this.ruleId=e.ruleId,this.message+=" Skipping ".concat(this.ruleId," rule.")),this.stack=(new Error).stack}o.version="4.7.2","function"==typeof define&&define.amd&&define("axe-core",[],(function(){return o})),"object"===("undefined"==typeof module?"undefined":r(module))&&module.exports&&"function"==typeof e.toString&&(o.source="("+e.toString()+\')(typeof window === "object" ? window : this);\',module.exports=o),"function"==typeof t.getComputedStyle&&(t.axe=o),(u.prototype=Object.create(Error.prototype)).constructor=u;var i=["node"],l=["variant"],s=["matches"],c=["chromium"],d=["noImplicit"],p=["noPresentational"],f=["precision","format","inGamut"],D=["space"],m=["algorithm"],h=["method"],g=["maxDeltaE","deltaEMethod","steps","maxSteps"],b=["node"],v=["nodes"],y=["node"],F=["relatedNodes"],w=["environmentData"],E=["environmentData"],C=["node"],x=["environmentData"],A=["environmentData"],k=["environmentData"];function B(e){return K(e)||U(e)||te(e)||Y()}function T(e,t,n){return(T=S()?Reflect.construct.bind():function(e,t,n){var a=[null];return a.push.apply(a,t),t=new(Function.bind.apply(e,a)),n&&R(t,n.prototype),t}).apply(null,arguments)}function N(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&R(e,t)}function R(e,t){return(R=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}function _(e){var t=S();return function(){var n,a=M(e);n=t?(n=M(this).constructor,Reflect.construct(a,arguments,n)):a.apply(this,arguments),a=this;if(n&&("object"===r(n)||"function"==typeof n))return n;if(void 0!==n)throw new TypeError("Derived constructors may only return object or undefined");return O(a)}}function O(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}function S(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function M(e){return(M=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function P(e,t,n){j(e,t),t.set(e,n)}function I(e,t){j(e,t),t.add(e)}function j(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function L(e,t){return(t=V(e,t,"get")).get?t.get.call(e):t.value}function q(e,t,n){if(t.has(e))return n;throw new TypeError("attempted to get private field on non-instance")}function z(e,t,n){if((t=V(e,t,"set")).set)t.set.call(e,n);else{if(!t.writable)throw new TypeError("attempted to set read only private field");t.value=n}}function V(e,t,n){if(t.has(e))return t.get(e);throw new TypeError("attempted to "+n+" private field on non-instance")}function $(e,t){if(null==e)return{};var n,a=function(e,t){if(null==e)return{};var n,a,r={},o=Object.keys(e);for(a=0;a<o.length;a++)n=o[a],0<=t.indexOf(n)||(r[n]=e[n]);return r}(e,t);if(Object.getOwnPropertySymbols)for(var r=Object.getOwnPropertySymbols(e),o=0;o<r.length;o++)n=r[o],0<=t.indexOf(n)||Object.prototype.propertyIsEnumerable.call(e,n)&&(a[n]=e[n]);return a}function H(e){return function(e){if(Array.isArray(e))return ne(e)}(e)||U(e)||te(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function U(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function G(){return(G=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n,a=arguments[t];for(n in a)Object.prototype.hasOwnProperty.call(a,n)&&(e[n]=a[n])}return e}).apply(this,arguments)}function W(e,t){return K(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var a,r,o,u,i=[],l=!0,s=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(a=o.call(n)).done)&&(i.push(a.value),i.length!==t);l=!0);}catch(e){s=!0,r=e}finally{try{if(!l&&null!=n.return&&(u=n.return(),Object(u)!==u))return}finally{if(s)throw r}}return i}}(e,t)||te(e,t)||Y()}function Y(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function K(e){if(Array.isArray(e))return e}function X(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function Z(e,t){for(var n=0;n<t.length;n++){var a=t[n];a.enumerable=a.enumerable||!1,a.configurable=!0,"value"in a&&(a.writable=!0),Object.defineProperty(e,Q(a.key),a)}}function J(e,t,n){return t&&Z(e.prototype,t),n&&Z(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function Q(e){return e=function(e,t){if("object"!==r(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return String(e);if(n=n.call(e,t),"object"===r(n))throw new TypeError("@@toPrimitive must return a primitive value.");return n}(e,"string"),"symbol"===r(e)?e:String(e)}function ee(e,t){var n,a,r,o,u="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(u)return a=!(n=!0),{s:function(){u=u.call(e)},n:function(){var e=u.next();return n=e.done,e},e:function(e){a=!0,r=e},f:function(){try{n||null==u.return||u.return()}finally{if(a)throw r}}};if(Array.isArray(e)||(u=te(e))||t&&e&&"number"==typeof e.length)return u&&(e=u),o=0,{s:t=function(){},n:function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function te(e,t){var n;if(e)return"string"==typeof e?ne(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?ne(e,t):void 0}function ne(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,a=new Array(t);n<t;n++)a[n]=e[n];return a}function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function ae(e,t){return function(){return t||e((t={exports:{}}).exports,t),t.exports}}function re(e,t){for(var n in t)pe(e,n,{get:t[n],enumerable:!0})}function oe(e){return function(e,t,n){if(t&&"object"===r(t)||"function"==typeof t){var a,o=ee(me(t));try{for(o.s();!(a=o.n()).done;)!function(){var r=a.value;De.call(e,r)||"default"===r||pe(e,r,{get:function(){return t[r]},enumerable:!(n=he(t,r))||n.enumerable})}()}catch(e){o.e(e)}finally{o.f()}}return e}((t=pe(null!=e?de(fe(e)):{},"default",e&&e.__esModule&&"default"in e?{get:function(){return e.default},enumerable:!0}:{value:e,enumerable:!0}),pe(t,"__esModule",{value:!0})),e);var t}function ue(e,t,n){e=e,n=n,(t="symbol"!==r(t)?t+"":t)in e?pe(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n}var ie,le,se,ce,de=Object.create,pe=Object.defineProperty,fe=Object.getPrototypeOf,De=Object.prototype.hasOwnProperty,me=Object.getOwnPropertyNames,he=Object.getOwnPropertyDescriptor,ge=ae((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.isIdentStart=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"-"===e||"_"===e},e.isIdent=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"0"<=e&&e<="9"||"-"===e||"_"===e},e.isHex=function(e){return"a"<=e&&e<="f"||"A"<=e&&e<="F"||"0"<=e&&e<="9"},e.escapeIdentifier=function(t){for(var n=t.length,a="",r=0;r<n;){var o=t.charAt(r);if(e.identSpecialChars[o])a+="\\\\"+o;else if("_"===o||"-"===o||"A"<=o&&o<="Z"||"a"<=o&&o<="z"||0!==r&&"0"<=o&&o<="9")a+=o;else{if(55296==(63488&(o=o.charCodeAt(0)))){var u=t.charCodeAt(r++);if(55296!=(64512&o)||56320!=(64512&u))throw Error("UCS-2(decode): illegal sequence");o=((1023&o)<<10)+(1023&u)+65536}a+="\\\\"+o.toString(16)+" "}r++}return a},e.escapeStr=function(t){for(var n,a=t.length,r="",o=0;o<a;){var u=t.charAt(o);\'"\'===u?u=\'\\\\"\':"\\\\"===u?u="\\\\\\\\":void 0!==(n=e.strReplacementsRev[u])&&(u=n),r+=u,o++}return\'"\'+r+\'"\'},e.identSpecialChars={"!":!0,\'"\':!0,"#":!0,$:!0,"%":!0,"&":!0,"\'":!0,"(":!0,")":!0,"*":!0,"+":!0,",":!0,".":!0,"/":!0,";":!0,"<":!0,"=":!0,">":!0,"?":!0,"@":!0,"[":!0,"\\\\":!0,"]":!0,"^":!0,"`":!0,"{":!0,"|":!0,"}":!0,"~":!0},e.strReplacementsRev={"\\n":"\\\\n","\\r":"\\\\r","\\t":"\\\\t","\\f":"\\\\f","\\v":"\\\\v"},e.singleQuoteEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\","\'":"\'"},e.doubleQuotesEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\",\'"\':\'"\'}})),be=ae((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=ge();e.parseCssSelector=function(e,n,a,r,o,u){var i=e.length,l="";function s(a,r){var o="";for(n++,l=e.charAt(n);n<i;){if(l===a)return n++,o;var u;if("\\\\"===l)if(n++,(l=e.charAt(n))===a)o+=a;else if(void 0!==(u=r[l]))o+=u;else{if(t.isHex(l)){var s=l;for(n++,l=e.charAt(n);t.isHex(l);)s+=l,n++,l=e.charAt(n);" "===l&&(n++,l=e.charAt(n)),o+=String.fromCharCode(parseInt(s,16));continue}o+=l}else o+=l;n++,l=e.charAt(n)}return o}function c(){var a="";for(l=e.charAt(n);n<i;){if(!t.isIdent(l)){if("\\\\"!==l)return a;if(i<=++n)throw Error("Expected symbol but end of file reached.");if(l=e.charAt(n),!t.identSpecialChars[l]&&t.isHex(l)){var r=l;for(n++,l=e.charAt(n);t.isHex(l);)r+=l,n++,l=e.charAt(n);" "===l&&(n++,l=e.charAt(n)),a+=String.fromCharCode(parseInt(r,16));continue}}a+=l,n++,l=e.charAt(n)}return a}function d(){for(l=e.charAt(n);" "===l||"\\t"===l||"\\n"===l||"\\r"===l||"\\f"===l;)n++,l=e.charAt(n)}function p(){var t=f();if(!t)return null;var a=t;for(l=e.charAt(n);","===l;){if(n++,d(),"selectors"!==a.type&&(a={type:"selectors",selectors:[t]}),!(t=f()))throw Error(\'Rule expected after ",".\');a.selectors.push(t)}return a}function f(){d();var t={type:"ruleSet"},a=D();if(!a)return null;for(var r=t;a&&(a.type="rule",r.rule=a,r=a,d(),l=e.charAt(n),!(i<=n||","===l||")"===l));)if(o[l]){var u=l;if(n++,d(),!(a=D()))throw Error(\'Rule expected after "\'+u+\'".\');a.nestingOperator=u}else(a=D())&&(a.nestingOperator=null);return t}function D(){for(var o=null;n<i;)if("*"===(l=e.charAt(n)))n++,(o=o||{}).tagName="*";else if(t.isIdentStart(l)||"\\\\"===l)(o=o||{}).tagName=c();else if("."===l)n++,((o=o||{}).classNames=o.classNames||[]).push(c());else if("#"===l)n++,(o=o||{}).id=c();else if("["===l){n++,d();var f={name:c()};if(d(),"]"===l)n++;else{var D="";if(r[l]&&(D=l,n++,l=e.charAt(n)),i<=n)throw Error(\'Expected "=" but end of file reached.\');if("="!==l)throw Error(\'Expected "=" but "\'+l+\'" found.\');f.operator=D+"=",n++,d();var m="";if(f.valueType="string",\'"\'===l)m=s(\'"\',t.doubleQuotesEscapeChars);else if("\'"===l)m=s("\'",t.singleQuoteEscapeChars);else if(u&&"$"===l)n++,m=c(),f.valueType="substitute";else{for(;n<i&&"]"!==l;)m+=l,n++,l=e.charAt(n);m=m.trim()}if(d(),i<=n)throw Error(\'Expected "]" but end of file reached.\');if("]"!==l)throw Error(\'Expected "]" but "\'+l+\'" found.\');n++,f.value=m}((o=o||{}).attrs=o.attrs||[]).push(f)}else{if(":"!==l)break;if(n++,f={name:D=c()},"("===l){n++;var h="";if(d(),"selector"===a[D])f.valueType="selector",h=p();else{if(f.valueType=a[D]||"string",\'"\'===l)h=s(\'"\',t.doubleQuotesEscapeChars);else if("\'"===l)h=s("\'",t.singleQuoteEscapeChars);else if(u&&"$"===l)n++,h=c(),f.valueType="substitute";else{for(;n<i&&")"!==l;)h+=l,n++,l=e.charAt(n);h=h.trim()}d()}if(i<=n)throw Error(\'Expected ")" but end of file reached.\');if(")"!==l)throw Error(\'Expected ")" but "\'+l+\'" found.\');n++,f.value=h}((o=o||{}).pseudos=o.pseudos||[]).push(f)}return o}var m=p();if(n<i)throw Error(\'Rule expected but "\'+e.charAt(n)+\'" found.\');return m}})),ve=ae((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=ge();e.renderEntity=function e(n){var a="";switch(n.type){case"ruleSet":for(var r=n.rule,o=[];r;)r.nestingOperator&&o.push(r.nestingOperator),o.push(e(r)),r=r.rule;a=o.join(" ");break;case"selectors":a=n.selectors.map(e).join(", ");break;case"rule":n.tagName&&(a="*"===n.tagName?"*":t.escapeIdentifier(n.tagName)),n.id&&(a+="#"+t.escapeIdentifier(n.id)),n.classNames&&(a+=n.classNames.map((function(e){return"."+t.escapeIdentifier(e)})).join("")),n.attrs&&(a+=n.attrs.map((function(e){return"operator"in e?"substitute"===e.valueType?"["+t.escapeIdentifier(e.name)+e.operator+"$"+e.value+"]":"["+t.escapeIdentifier(e.name)+e.operator+t.escapeStr(e.value)+"]":"["+t.escapeIdentifier(e.name)+"]"})).join("")),n.pseudos&&(a+=n.pseudos.map((function(n){return n.valueType?"selector"===n.valueType?":"+t.escapeIdentifier(n.name)+"("+e(n.value)+")":"substitute"===n.valueType?":"+t.escapeIdentifier(n.name)+"($"+n.value+")":"numeric"===n.valueType?":"+t.escapeIdentifier(n.name)+"("+n.value+")":":"+t.escapeIdentifier(n.name)+"("+t.escapeIdentifier(n.value)+")":":"+t.escapeIdentifier(n.name)})).join(""));break;default:throw Error(\'Unknown entity type: "\'+n.type+\'".\')}return a}})),ye=ae((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=be(),n=ve();function a(){this.pseudos={},this.attrEqualityMods={},this.ruleNestingOperators={},this.substitutesEnabled=!1}a.prototype.registerSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)this.pseudos[a[n]]="selector";return this},a.prototype.unregisterSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)delete this.pseudos[a[n]];return this},a.prototype.registerNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)this.pseudos[a[n]]="numeric";return this},a.prototype.unregisterNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)delete this.pseudos[a[n]];return this},a.prototype.registerNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)this.ruleNestingOperators[a[n]]=!0;return this},a.prototype.unregisterNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)delete this.ruleNestingOperators[a[n]];return this},a.prototype.registerAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)this.attrEqualityMods[a[n]]=!0;return this},a.prototype.unregisterAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,a=e;n<a.length;n++)delete this.attrEqualityMods[a[n]];return this},a.prototype.enableSubstitutes=function(){return this.substitutesEnabled=!0,this},a.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this},a.prototype.parse=function(e){return t.parseCssSelector(e,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled)},a.prototype.render=function(e){return n.renderEntity(e).trim()},e.CssSelectorParser=a})),Fe=ae((function(e,t){"use strict";t.exports=function(){}})),we=ae((function(e,t){"use strict";var n=Fe()();t.exports=function(e){return e!==n&&null!==e}})),Ee=ae((function(e,t){"use strict";var n=we(),a=Array.prototype.forEach,r=Object.create;t.exports=function(e){var t=r(null);return a.call(arguments,(function(e){if(n(e)){var a,r=Object(e),o=t;for(a in r)o[a]=r[a]}})),t}})),Ce=ae((function(e,t){"use strict";t.exports=function(){var e=Math.sign;return"function"==typeof e&&1===e(10)&&-1===e(-20)}})),xe=ae((function(e,t){"use strict";t.exports=function(e){return e=Number(e),isNaN(e)||0===e?e:0<e?1:-1}})),Ae=ae((function(e,t){"use strict";t.exports=Ce()()?Math.sign:xe()})),ke=ae((function(e,t){"use strict";var n=Ae(),a=Math.abs,r=Math.floor;t.exports=function(e){return isNaN(e)?0:0!==(e=Number(e))&&isFinite(e)?n(e)*r(a(e)):e}})),Be=ae((function(e,t){"use strict";var n=ke(),a=Math.max;t.exports=function(e){return a(0,n(e))}})),Te=ae((function(e,t){"use strict";var n=Be();t.exports=function(e,t,a){return isNaN(e)?0<=t?a&&t?t-1:t:1:!1!==e&&n(e)}})),Ne=ae((function(e,t){"use strict";t.exports=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}})),Re=ae((function(e,t){"use strict";var n=we();t.exports=function(e){if(n(e))return e;throw new TypeError("Cannot use null or undefined")}})),_e=ae((function(e,t){"use strict";var n=Ne(),a=Re(),r=Function.prototype.bind,o=Function.prototype.call,u=Object.keys,i=Object.prototype.propertyIsEnumerable;t.exports=function(e,t){return function(l,s){var c,d=arguments[2],p=arguments[3];return l=Object(a(l)),n(s),c=u(l),p&&c.sort("function"==typeof p?r.call(p,l):void 0),"function"!=typeof e&&(e=c[e]),o.call(e,c,(function(e,n){return i.call(l,e)?o.call(s,d,l[e],e,l,n):t}))}}})),Oe=ae((function(e,t){"use strict";t.exports=_e()("forEach")})),Se=ae((function(){})),Me=ae((function(e,t){"use strict";t.exports=function(){var e=Object.assign;return"function"==typeof e&&(e(e={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="razdwatrzy")}})),Pe=ae((function(e,t){"use strict";t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}})),Ie=ae((function(e,t){"use strict";var n=we(),a=Object.keys;t.exports=function(e){return a(n(e)?Object(e):e)}})),je=ae((function(e,t){"use strict";t.exports=Pe()()?Object.keys:Ie()})),Le=ae((function(e,t){"use strict";var n=je(),a=Re(),r=Math.max;t.exports=function(e,t){var o,u,i,l=r(arguments.length,2);for(e=Object(a(e)),i=function(n){try{e[n]=t[n]}catch(n){o=o||n}},u=1;u<l;++u)n(t=arguments[u]).forEach(i);if(void 0!==o)throw o;return e}})),qe=ae((function(e,t){"use strict";t.exports=Me()()?Object.assign:Le()})),ze=ae((function(e,t){"use strict";var n=we(),a={function:!0,object:!0};t.exports=function(e){return n(e)&&a[r(e)]||!1}})),Ve=ae((function(e,t){"use strict";var n=qe(),a=ze(),r=we(),o=Error.captureStackTrace;t.exports=function(e){e=new Error(e);var u=arguments[1],i=arguments[2];return r(i)||a(u)&&(i=u,u=null),r(i)&&n(e,i),r(u)&&(e.code=u),o&&o(e,t.exports),e}})),$e=ae((function(e,t){"use strict";var n=Re(),a=Object.defineProperty,r=Object.getOwnPropertyDescriptor,o=Object.getOwnPropertyNames,u=Object.getOwnPropertySymbols;t.exports=function(e,t){var i,l=Object(n(t));if(e=Object(n(e)),o(l).forEach((function(n){try{a(e,n,r(t,n))}catch(n){i=n}})),"function"==typeof u&&u(l).forEach((function(n){try{a(e,n,r(t,n))}catch(n){i=n}})),void 0!==i)throw i;return e}})),He=ae((function(e,t){"use strict";function n(e,t){return t}var a,r,o,u,i,l=Be();try{Object.defineProperty(n,"length",{configurable:!0,writable:!1,enumerable:!1,value:1})}catch(e){}1===n.length?(a={configurable:!0,writable:!1,enumerable:!1},r=Object.defineProperty,t.exports=function(e,t){return t=l(t),e.length===t?e:(a.value=t,r(e,"length",a))}):(u=$e(),i=[],o=function(e){var t,n=0;if(i[e])return i[e];for(t=[];e--;)t.push("a"+(++n).toString(36));return new Function("fn","return function ("+t.join(", ")+") { return fn.apply(this, arguments); };")},t.exports=function(e,t){if(t=l(t),e.length===t)return e;t=o(t)(e);try{u(t,e)}catch(e){}return t})})),Ue=ae((function(e,t){"use strict";t.exports=function(e){return null!=e}})),Ge=ae((function(e,t){"use strict";var n=Ue(),a={object:!0,function:!0,undefined:!0};t.exports=function(e){return!!n(e)&&hasOwnProperty.call(a,r(e))}})),We=ae((function(e,t){"use strict";var n=Ge();t.exports=function(e){if(!n(e))return!1;try{return!!e.constructor&&e.constructor.prototype===e}catch(e){return!1}}})),Ye=ae((function(e,t){"use strict";var n=We();t.exports=function(e){if("function"!=typeof e)return!1;if(!hasOwnProperty.call(e,"length"))return!1;try{if("number"!=typeof e.length)return!1;if("function"!=typeof e.call)return!1;if("function"!=typeof e.apply)return!1}catch(e){return!1}return!n(e)}})),Ke=ae((function(e,t){"use strict";var n=Ye(),a=/^\\s*class[\\s{/}]/,r=Function.prototype.toString;t.exports=function(e){return!!n(e)&&!a.test(r.call(e))}})),Xe=ae((function(e,t){"use strict";var n="razdwatrzy";t.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}})),Ze=ae((function(e,t){"use strict";var n=String.prototype.indexOf;t.exports=function(e){return-1<n.call(this,e,arguments[1])}})),Je=ae((function(e,t){"use strict";t.exports=Xe()()?String.prototype.contains:Ze()})),Qe=ae((function(e,t){"use strict";var n=Ue(),a=Ke(),r=qe(),o=Ee(),u=Je();(t.exports=function(e,t){var a,i,l,s;return arguments.length<2||"string"!=typeof e?(s=t,t=e,e=null):s=arguments[2],n(e)?(a=u.call(e,"c"),i=u.call(e,"e"),l=u.call(e,"w")):i=!(a=l=!0),e={value:t,configurable:a,enumerable:i,writable:l},s?r(o(s),e):e}).gs=function(e,t,i){var l,s;return"string"!=typeof e?(s=i,i=t,t=e,e=null):s=arguments[3],n(t)?a(t)?n(i)?a(i)||(s=i,i=void 0):i=void 0:(s=t,t=i=void 0):t=void 0,e=n(e)?(l=u.call(e,"c"),u.call(e,"e")):!(l=!0),t={get:t,set:i,configurable:l,enumerable:e},s?r(o(s),t):t}})),et=ae((function(e,t){"use strict";var n=Qe(),a=Ne(),o=Function.prototype.apply,u=Function.prototype.call,i=Object.create,l=Object.defineProperty,s=Object.defineProperties,c=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0},p=function(e,t){var n;return a(t),c.call(this,"__ee__")?n=this.__ee__:(n=d.value=i(null),l(this,"__ee__",d),d.value=null),n[e]?"object"===r(n[e])?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},f=function(e,t){var n,r;return a(t),r=this,p.call(this,e,n=function(){D.call(r,e,n),o.call(t,this,arguments)}),n.__eeOnceListener__=t,this},D=function(e,t){var n,o,u,i;if(a(t),c.call(this,"__ee__")&&(n=this.__ee__)[e])if(o=n[e],"object"===r(o))for(i=0;u=o[i];++i)u!==t&&u.__eeOnceListener__!==t||(2===o.length?n[e]=o[i?0:1]:o.splice(i,1));else o!==t&&o.__eeOnceListener__!==t||delete n[e];return this},m=function(e){var t,n,a,i,l;if(c.call(this,"__ee__")&&(i=this.__ee__[e]))if("object"===r(i)){for(n=arguments.length,l=new Array(n-1),t=1;t<n;++t)l[t-1]=arguments[t];for(i=i.slice(),t=0;a=i[t];++t)o.call(a,this,l)}else switch(arguments.length){case 1:u.call(i,this);break;case 2:u.call(i,this,arguments[1]);break;case 3:u.call(i,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,l=new Array(n-1),t=1;t<n;++t)l[t-1]=arguments[t];o.call(i,this,l)}},h={on:p,once:f,off:D,emit:m},g={on:n(p),once:n(f),off:n(D),emit:n(m)},b=s({},g);t.exports=e=function(e){return null==e?i(b):s(Object(e),g)},e.methods=h})),tt=ae((function(e,t){"use strict";t.exports=function(){var e,t=Array.from;return"function"==typeof t&&(e=t(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}})),nt=ae((function(e,t){"use strict";t.exports=function(){return"object"===("undefined"==typeof globalThis?"undefined":r(globalThis))&&!!globalThis&&globalThis.Array===Array}})),at=ae((function(e,n){function a(){if("object"===("undefined"==typeof self?"undefined":r(self))&&self)return self;if("object"===(void 0===t?"undefined":r(t))&&t)return t;throw new Error("Unable to resolve global `this`")}n.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(e){return a()}try{return __global__||a()}finally{delete Object.prototype.__global__}}()})),rt=ae((function(e,t){"use strict";t.exports=nt()()?globalThis:at()})),ot=ae((function(e,t){"use strict";var n=rt(),a={object:!0,symbol:!0};t.exports=function(){var e,t=n.Symbol;if("function"!=typeof t)return!1;e=t("test symbol");try{String(e)}catch(e){return!1}return!!a[r(t.iterator)]&&!!a[r(t.toPrimitive)]&&!!a[r(t.toStringTag)]}})),ut=ae((function(e,t){"use strict";t.exports=function(e){return!!e&&("symbol"===r(e)||!!e.constructor&&"Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag])}})),it=ae((function(e,t){"use strict";var n=ut();t.exports=function(e){if(n(e))return e;throw new TypeError(e+" is not a symbol")}})),lt=ae((function(e,t){"use strict";var n=Qe(),a=Object.create,r=Object.defineProperty,o=Object.prototype,u=a(null);t.exports=function(e){for(var t,a,i=0;u[e+(i||"")];)++i;return u[e+=i||""]=!0,r(o,t="@@"+e,n.gs(null,(function(e){a||(a=!0,r(this,t,n(e)),a=!1)}))),t}})),st=ae((function(e,t){"use strict";var n=Qe(),a=rt().Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:n("",a&&a.hasInstance||e("hasInstance")),isConcatSpreadable:n("",a&&a.isConcatSpreadable||e("isConcatSpreadable")),iterator:n("",a&&a.iterator||e("iterator")),match:n("",a&&a.match||e("match")),replace:n("",a&&a.replace||e("replace")),search:n("",a&&a.search||e("search")),species:n("",a&&a.species||e("species")),split:n("",a&&a.split||e("split")),toPrimitive:n("",a&&a.toPrimitive||e("toPrimitive")),toStringTag:n("",a&&a.toStringTag||e("toStringTag")),unscopables:n("",a&&a.unscopables||e("unscopables"))})}})),ct=ae((function(e,t){"use strict";var n=Qe(),a=it(),r=Object.create(null);t.exports=function(e){return Object.defineProperties(e,{for:n((function(t){return r[t]||(r[t]=e(String(t)))})),keyFor:n((function(e){for(var t in a(e),r)if(r[t]===e)return t}))})}})),dt=ae((function(e,t){"use strict";var n,a,o,u=Qe(),i=it(),l=rt().Symbol,s=lt(),c=st(),d=ct(),p=Object.create,f=Object.defineProperties,D=Object.defineProperty;if("function"==typeof l)try{String(l()),o=!0}catch(e){}else l=null;a=function(e){if(this instanceof a)throw new TypeError("Symbol is not a constructor");return n(e)},t.exports=n=function e(t){var n;if(this instanceof e)throw new TypeError("Symbol is not a constructor");return o?l(t):(n=p(a.prototype),t=void 0===t?"":String(t),f(n,{__description__:u("",t),__name__:u("",s(t))}))},c(n),d(n),f(a.prototype,{constructor:u(n),toString:u("",(function(){return this.__name__}))}),f(n.prototype,{toString:u((function(){return"Symbol ("+i(this).__description__+")"})),valueOf:u((function(){return i(this)}))}),D(n.prototype,n.toPrimitive,u("",(function(){var e=i(this);return"symbol"===r(e)?e:e.toString()}))),D(n.prototype,n.toStringTag,u("c","Symbol")),D(a.prototype,n.toStringTag,u("c",n.prototype[n.toStringTag])),D(a.prototype,n.toPrimitive,u("c",n.prototype[n.toPrimitive]))})),pt=ae((function(e,t){"use strict";t.exports=ot()()?rt().Symbol:dt()})),ft=ae((function(e,t){"use strict";var n=Object.prototype.toString,a=n.call(function(){return arguments}());t.exports=function(e){return n.call(e)===a}})),Dt=ae((function(e,t){"use strict";var n=Object.prototype.toString,a=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);t.exports=function(e){return"function"==typeof e&&a(n.call(e))}})),mt=ae((function(e,t){"use strict";var n=Object.prototype.toString,a=n.call("");t.exports=function(e){return"string"==typeof e||e&&"object"===r(e)&&(e instanceof String||n.call(e)===a)||!1}})),ht=ae((function(e,t){"use strict";var n=pt().iterator,a=ft(),r=Dt(),o=Be(),u=Ne(),i=Re(),l=we(),s=mt(),c=Array.isArray,d=Function.prototype.call,p={configurable:!0,enumerable:!0,writable:!0,value:null},f=Object.defineProperty;t.exports=function(e){var t,D,m,h,g,b,v,y,F,w,E=arguments[1],C=arguments[2];if(e=Object(i(e)),l(E)&&u(E),this&&this!==Array&&r(this))t=this;else{if(!E){if(a(e))return 1!==(g=e.length)?Array.apply(null,e):((h=new Array(1))[0]=e[0],h);if(c(e)){for(h=new Array(g=e.length),D=0;D<g;++D)h[D]=e[D];return h}}h=[]}if(!c(e))if(void 0!==(F=e[n])){for(v=u(F).call(e),t&&(h=new t),y=v.next(),D=0;!y.done;)w=E?d.call(E,C,y.value,D):y.value,t?(p.value=w,f(h,D,p)):h[D]=w,y=v.next(),++D;g=D}else if(s(e)){for(g=e.length,t&&(h=new t),m=D=0;D<g;++D)w=e[D],D+1<g&&55296<=(b=w.charCodeAt(0))&&b<=56319&&(w+=e[++D]),w=E?d.call(E,C,w,m):w,t?(p.value=w,f(h,m,p)):h[m]=w,++m;g=m}if(void 0===g)for(g=o(e.length),t&&(h=new t(g)),D=0;D<g;++D)w=E?d.call(E,C,e[D],D):e[D],t?(p.value=w,f(h,D,p)):h[D]=w;return t&&(p.value=null,h.length=g),h}})),gt=ae((function(e,t){"use strict";t.exports=tt()()?Array.from:ht()})),bt=ae((function(e,t){"use strict";var n=gt(),a=Array.isArray;t.exports=function(e){return a(e)?e:n(e)}})),vt=ae((function(e,t){"use strict";var n=bt(),a=we(),r=Ne(),o=Array.prototype.slice,u=function(e){return this.map((function(t,n){return t?t(e[n]):e[n]})).concat(o.call(e,this.length))};t.exports=function(e){return(e=n(e)).forEach((function(e){a(e)&&r(e)})),u.bind(e)}})),yt=ae((function(e,t){"use strict";var n=Ne();t.exports=function(e){var t;return"function"==typeof e?{set:e,get:e}:(t={get:n(e.get)},void 0!==e.set?(t.set=n(e.set),e.delete&&(t.delete=n(e.delete)),e.clear&&(t.clear=n(e.clear))):t.set=t.get,t)}})),Ft=ae((function(e,t){"use strict";var n=Ve(),a=He(),r=Qe(),o=et().methods,u=vt(),i=yt(),l=Function.prototype.apply,s=Function.prototype.call,c=Object.create,d=Object.defineProperties,p=o.on,f=o.emit;t.exports=function(e,t,o){var D,m,h,g,b,v,y,F,w,E,C,x=c(null),A=!1!==t?t:isNaN(e.length)?1:e.length;return o.normalizer&&(E=i(o.normalizer),m=E.get,h=E.set,g=E.delete,b=E.clear),null!=o.resolvers&&(C=u(o.resolvers)),E=m?a((function(t){var a,r,o=arguments;if(C&&(o=C(o)),null!==(a=m(o))&&hasOwnProperty.call(x,a))return y&&D.emit("get",a,o,this),x[a];if(r=1===o.length?s.call(e,this,o[0]):l.call(e,this,o),null===a){if(null!==(a=m(o)))throw n("Circular invocation","CIRCULAR_INVOCATION");a=h(o)}else if(hasOwnProperty.call(x,a))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[a]=r,F&&D.emit("set",a,null,r),r}),A):0===t?function(){var t;if(hasOwnProperty.call(x,"data"))return y&&D.emit("get","data",arguments,this),x.data;if(t=arguments.length?l.call(e,this,arguments):s.call(e,this),hasOwnProperty.call(x,"data"))throw n("Circular invocation","CIRCULAR_INVOCATION");return x.data=t,F&&D.emit("set","data",null,t),t}:function(t){var a,r=arguments;if(C&&(r=C(arguments)),a=String(r[0]),hasOwnProperty.call(x,a))return y&&D.emit("get",a,r,this),x[a];if(r=1===r.length?s.call(e,this,r[0]):l.call(e,this,r),hasOwnProperty.call(x,a))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[a]=r,F&&D.emit("set",a,null,r),r},D={original:e,memoized:E,profileName:o.profileName,get:function(e){return C&&(e=C(e)),m?m(e):String(e[0])},has:function(e){return hasOwnProperty.call(x,e)},delete:function(e){var t;hasOwnProperty.call(x,e)&&(g&&g(e),t=x[e],delete x[e],w)&&D.emit("delete",e,t)},clear:function(){var e=x;b&&b(),x=c(null),D.emit("clear",e)},on:function(e,t){return"get"===e?y=!0:"set"===e?F=!0:"delete"===e&&(w=!0),p.call(this,e,t)},emit:f,updateEnv:function(){e=D.original}},o=m?a((function(e){var t=arguments;C&&(t=C(t)),null!==(t=m(t))&&D.delete(t)}),A):0===t?function(){return D.delete("data")}:function(e){return C&&(e=C(arguments)[0]),D.delete(e)},A=a((function(){var e=arguments;return 0===t?x.data:(C&&(e=C(e)),e=m?m(e):String(e[0]),x[e])})),v=a((function(){var e=arguments;return 0===t?D.has("data"):(C&&(e=C(e)),null!==(e=m?m(e):String(e[0]))&&D.has(e))})),d(E,{__memoized__:r(!0),delete:r(o),clear:r(D.clear),_get:r(A),_has:r(v)}),D}})),wt=ae((function(e,t){"use strict";var n=Ne(),a=Oe(),r=Se(),o=Ft(),u=Te();t.exports=function e(t){var i,l,s;if(n(t),(i=Object(arguments[1])).async&&i.promise)throw new Error("Options \'async\' and \'promise\' cannot be used together");return hasOwnProperty.call(t,"__memoized__")&&!i.force?t:(l=u(i.length,t.length,i.async&&r.async),s=o(t,l,i),a(r,(function(e,t){i[t]&&e(i[t],s,i)})),e.__profiler__&&e.__profiler__(s),s.updateEnv(),s.memoized)}})),Et=ae((function(e,t){"use strict";t.exports=function(e){var t,n,a=e.length;if(!a)return"";for(t=String(e[n=0]);--a;)t+=""+e[++n];return t}})),Ct=ae((function(e,t){"use strict";t.exports=function(e){return e?function(t){for(var n=String(t[0]),a=0,r=e;--r;)n+=""+t[++a];return n}:function(){return""}}})),xt=ae((function(e,t){"use strict";t.exports=function(){var e=Number.isNaN;return"function"==typeof e&&!e({})&&e(NaN)&&!e(34)}})),At=ae((function(e,t){"use strict";t.exports=function(e){return e!=e}})),kt=ae((function(e,t){"use strict";t.exports=xt()()?Number.isNaN:At()})),Bt=ae((function(e,t){"use strict";var n=kt(),a=Be(),r=Re(),o=Array.prototype.indexOf,u=Object.prototype.hasOwnProperty,i=Math.abs,l=Math.floor;t.exports=function(e){var t,s,c;if(!n(e))return o.apply(this,arguments);for(s=a(r(this).length),e=arguments[1],t=e=isNaN(e)?0:0<=e?l(e):a(this.length)-l(i(e));t<s;++t)if(u.call(this,t)&&(c=this[t],n(c)))return t;return-1}})),Tt=ae((function(e,t){"use strict";var n=Bt(),a=Object.create;t.exports=function(){var e=0,t=[],r=a(null);return{get:function(e){var a,r=0,o=t,u=e.length;if(0===u)return o[u]||null;if(o=o[u]){for(;r<u-1;){if(-1===(a=n.call(o[0],e[r])))return null;o=o[1][a],++r}return-1===(a=n.call(o[0],e[r]))?null:o[1][a]||null}return null},set:function(a){var o,u=0,i=t,l=a.length;if(0===l)i[l]=++e;else{for(i[l]||(i[l]=[[],[]]),i=i[l];u<l-1;)-1===(o=n.call(i[0],a[u]))&&(o=i[0].push(a[u])-1,i[1].push([[],[]])),i=i[1][o],++u;-1===(o=n.call(i[0],a[u]))&&(o=i[0].push(a[u])-1),i[1][o]=++e}return r[e]=a,e},delete:function(e){var a,o=0,u=t,i=r[e],l=i.length,s=[];if(0===l)delete u[l];else if(u=u[l]){for(;o<l-1;){if(-1===(a=n.call(u[0],i[o])))return;s.push(u,a),u=u[1][a],++o}if(-1===(a=n.call(u[0],i[o])))return;for(e=u[1][a],u[0].splice(a,1),u[1].splice(a,1);!u[0].length&&s.length;)a=s.pop(),(u=s.pop())[0].splice(a,1),u[1].splice(a,1)}delete r[e]},clear:function(){t=[],r=a(null)}}}})),Nt=ae((function(e,t){"use strict";var n=Bt();t.exports=function(){var e=0,t=[],a=[];return{get:function(e){return-1===(e=n.call(t,e[0]))?null:a[e]},set:function(n){return t.push(n[0]),a.push(++e),e},delete:function(e){-1!==(e=n.call(a,e))&&(t.splice(e,1),a.splice(e,1))},clear:function(){t=[],a=[]}}}})),Rt=ae((function(e,t){"use strict";var n=Bt(),a=Object.create;t.exports=function(e){var t=0,r=[[],[]],o=a(null);return{get:function(t){for(var a,o=0,u=r;o<e-1;){if(-1===(a=n.call(u[0],t[o])))return null;u=u[1][a],++o}return-1!==(a=n.call(u[0],t[o]))&&u[1][a]||null},set:function(a){for(var u,i=0,l=r;i<e-1;)-1===(u=n.call(l[0],a[i]))&&(u=l[0].push(a[i])-1,l[1].push([[],[]])),l=l[1][u],++i;return-1===(u=n.call(l[0],a[i]))&&(u=l[0].push(a[i])-1),l[1][u]=++t,o[t]=a,t},delete:function(t){for(var a,u=0,i=r,l=[],s=o[t];u<e-1;){if(-1===(a=n.call(i[0],s[u])))return;l.push(i,a),i=i[1][a],++u}if(-1!==(a=n.call(i[0],s[u]))){for(t=i[1][a],i[0].splice(a,1),i[1].splice(a,1);!i[0].length&&l.length;)a=l.pop(),(i=l.pop())[0].splice(a,1),i[1].splice(a,1);delete o[t]}},clear:function(){r=[[],[]],o=a(null)}}}})),_t=ae((function(e,t){"use strict";var n=Ne(),a=Oe(),r=Function.prototype.call;t.exports=function(e,t){var o={},u=arguments[2];return n(t),a(e,(function(e,n,a,i){o[n]=r.call(t,u,e,n,a,i)})),o}})),Ot=ae((function(e,t){"use strict";function n(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}function o(e){var t,r,o=a.createTextNode(""),u=0;return new e((function(){var e;if(t)r&&(t=r.concat(t));else{if(!r)return;t=r}if(r=t,t=null,"function"==typeof r)e=r,r=null,e();else for(o.data=u=++u%2;r;)e=r.shift(),r.length||(r=null),e()})).observe(o,{characterData:!0}),function(e){n(e),t?"function"==typeof t?t=[t,e]:t.push(e):(t=e,o.data=u=++u%2)}}t.exports=function(){if("object"===("undefined"==typeof process?"undefined":r(process))&&process&&"function"==typeof process.nextTick)return process.nextTick;if("function"==typeof queueMicrotask)return function(e){queueMicrotask(n(e))};if("object"===(void 0===a?"undefined":r(a))&&a){if("function"==typeof MutationObserver)return o(MutationObserver);if("function"==typeof WebKitMutationObserver)return o(WebKitMutationObserver)}return"function"==typeof setImmediate?function(e){setImmediate(n(e))}:"function"==typeof setTimeout||"object"===("undefined"==typeof setTimeout?"undefined":r(setTimeout))?function(e){setTimeout(n(e),0)}:null}()})),St=ae((function(){"use strict";var e=gt(),t=_t(),n=$e(),a=He(),r=Ot(),o=Array.prototype.slice,u=Function.prototype.apply,i=Object.create;Se().async=function(l,s){var c,d,p,f=i(null),D=i(null),m=s.memoized,h=s.original;s.memoized=a((function(e){var t=arguments,n=t[t.length-1];return"function"==typeof n&&(c=n,t=o.call(t,0,-1)),m.apply(d=this,p=t)}),m);try{n(s.memoized,m)}catch(l){}s.on("get",(function(e){var t,n,a;c&&(f[e]?("function"==typeof f[e]?f[e]=[f[e],c]:f[e].push(c),c=null):(t=c,n=d,a=p,c=d=p=null,r((function(){var r;hasOwnProperty.call(D,e)?(r=D[e],s.emit("getasync",e,a,n),u.call(t,r.context,r.args)):(c=t,d=n,p=a,m.apply(n,a))}))))})),s.original=function(){var t,n,a,o;return c?(t=e(arguments),a=c,c=d=p=null,t.push(n=function t(n){var a,i,l=t.id;if(null==l)r(u.bind(t,this,arguments));else if(delete t.id,a=f[l],delete f[l],a)return i=e(arguments),s.has(l)&&(n?s.delete(l):(D[l]={context:this,args:i},s.emit("setasync",l,"function"==typeof a?1:a.length))),"function"==typeof a?o=u.call(a,this,i):a.forEach((function(e){o=u.call(e,this,i)}),this),o}),o=u.call(h,this,t),n.cb=a,c=n,o):u.call(h,this,arguments)},s.on("set",(function(e){c?(f[e]?"function"==typeof f[e]?f[e]=[f[e],c.cb]:f[e].push(c.cb):f[e]=c.cb,delete c.cb,c.id=e,c=null):s.delete(e)})),s.on("delete",(function(e){var t;hasOwnProperty.call(f,e)||D[e]&&(t=D[e],delete D[e],s.emit("deleteasync",e,o.call(t.args,1)))})),s.on("clear",(function(){var e=D;D=i(null),s.emit("clearasync",t(e,(function(e){return o.call(e.args,1)})))}))}})),Mt=ae((function(e,t){"use strict";var n=Array.prototype.forEach,a=Object.create;t.exports=function(e){var t=a(null);return n.call(arguments,(function(e){t[e]=!0})),t}})),Pt=ae((function(e,t){"use strict";t.exports=function(e){return"function"==typeof e}})),It=ae((function(e,t){"use strict";var n=Pt();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){throw new TypeError("Passed argument cannot be stringifed")}}})),jt=ae((function(e,t){"use strict";var n=Re(),a=It();t.exports=function(e){return a(n(e))}})),Lt=ae((function(e,t){"use strict";var n=Pt();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){return"<Non-coercible to string value>"}}})),qt=ae((function(e,t){"use strict";var n=Lt(),a=/[\\n\\r\\u2028\\u2029]/g;t.exports=function(e){return(e=100<(e=n(e)).length?e.slice(0,99)+"…":e).replace(a,(function(e){return JSON.stringify(e).slice(1,-1)}))}})),zt=ae((function(e,t){function n(e){return!!e&&("object"===r(e)||"function"==typeof e)&&"function"==typeof e.then}t.exports=n,t.exports.default=n})),Vt=ae((function(){"use strict";var e=_t(),t=Mt(),n=jt(),a=qt(),r=zt(),o=Ot(),u=Object.create,i=t("then","then:finally","done","done:finally");Se().promise=function(t,l){var s=u(null),c=u(null),d=u(null);if(!0===t)t=null;else if(t=n(t),!i[t])throw new TypeError("\'"+a(t)+"\' is not valid promise mode");l.on("set",(function(e,n,a){var u=!1;if(r(a)){s[e]=1,d[e]=a;var i=function(t){var n=s[e];if(u)throw new Error("Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in \'done:finally\' mode)\\nConsider to rely on \'then\' or \'done\' mode instead.");n&&(delete s[e],c[e]=t,l.emit("setasync",e,n))},p=function(){u=!0,s[e]&&(delete s[e],delete d[e],l.delete(e))},f=t;if("then"===(f=f||"then")){var D=function(){o(p)};"function"==typeof(a=a.then((function(e){o(i.bind(this,e))}),D)).finally&&a.finally(D)}else if("done"===f){if("function"!=typeof a.done)throw new Error("Memoizee error: Retrieved promise does not implement \'done\' in \'done\' mode");a.done(i,p)}else if("done:finally"===f){if("function"!=typeof a.done)throw new Error("Memoizee error: Retrieved promise does not implement \'done\' in \'done:finally\' mode");if("function"!=typeof a.finally)throw new Error("Memoizee error: Retrieved promise does not implement \'finally\' in \'done:finally\' mode");a.done(i),a.finally(p)}}else c[e]=a,l.emit("setasync",e,1)})),l.on("get",(function(e,t,n){var a,u;s[e]?++s[e]:(a=d[e],u=function(){l.emit("getasync",e,t,n)},r(a)?"function"==typeof a.done?a.done(u):a.then((function(){o(u)})):u())})),l.on("delete",(function(e){var t;delete d[e],s[e]?delete s[e]:hasOwnProperty.call(c,e)&&(t=c[e],delete c[e],l.emit("deleteasync",e,[t]))})),l.on("clear",(function(){var t=c;c=u(null),s=u(null),d=u(null),l.emit("clearasync",e(t,(function(e){return[e]})))}))}})),$t=ae((function(){"use strict";var e=Ne(),t=Oe(),n=Se(),a=Function.prototype.apply;n.dispose=function(r,o,u){var i;e(r),u.async&&n.async||u.promise&&n.promise?(o.on("deleteasync",i=function(e,t){a.call(r,null,t)}),o.on("clearasync",(function(e){t(e,(function(e,t){i(t,e)}))}))):(o.on("delete",i=function(e,t){r(t)}),o.on("clear",(function(e){t(e,(function(e,t){i(t,e)}))})))}})),Ht=ae((function(e,t){"use strict";t.exports=2147483647})),Ut=ae((function(e,t){"use strict";var n=Be(),a=Ht();t.exports=function(e){if(e=n(e),a<e)throw new TypeError(e+" exceeds maximum possible timeout");return e}})),Gt=ae((function(){"use strict";var e=gt(),t=Oe(),n=Ot(),a=zt(),r=Ut(),o=Se(),u=Function.prototype,i=Math.max,l=Math.min,s=Object.create;o.maxAge=function(c,d,p){var f,D,m,h;(c=r(c))&&(f=s(null),D=p.async&&o.async||p.promise&&o.promise?"async":"",d.on("set"+D,(function(e){f[e]=setTimeout((function(){d.delete(e)}),c),"function"==typeof f[e].unref&&f[e].unref(),h&&(h[e]&&"nextTick"!==h[e]&&clearTimeout(h[e]),h[e]=setTimeout((function(){delete h[e]}),m),"function"==typeof h[e].unref)&&h[e].unref()})),d.on("delete"+D,(function(e){clearTimeout(f[e]),delete f[e],h&&("nextTick"!==h[e]&&clearTimeout(h[e]),delete h[e])})),p.preFetch&&(m=!0===p.preFetch||isNaN(p.preFetch)?.333:i(l(Number(p.preFetch),1),0))&&(h={},m=(1-m)*c,d.on("get"+D,(function(t,r,o){h[t]||(h[t]="nextTick",n((function(){var n;"nextTick"===h[t]&&(delete h[t],d.delete(t),p.async&&(r=e(r)).push(u),n=d.memoized.apply(o,r),p.promise)&&a(n)&&("function"==typeof n.done?n.done(u,u):n.then(u,u))})))}))),d.on("clear"+D,(function(){t(f,(function(e){clearTimeout(e)})),f={},h&&(t(h,(function(e){"nextTick"!==e&&clearTimeout(e)})),h={})})))}})),Wt=ae((function(e,t){"use strict";var n=Be(),a=Object.create,r=Object.prototype.hasOwnProperty;t.exports=function(e){var t,o=0,u=1,i=a(null),l=a(null),s=0;return e=n(e),{hit:function(n){var a=l[n],c=++s;if(i[c]=n,l[n]=c,!a)return++o<=e?void 0:(n=i[u],t(n),n);if(delete i[a],u===a)for(;!r.call(i,++u););},delete:t=function(e){var t=l[e];if(t&&(delete i[t],delete l[e],--o,u===t))if(o)for(;!r.call(i,++u););else s=0,u=1},clear:function(){o=0,u=1,i=a(null),l=a(null),s=0}}}})),Yt=ae((function(){"use strict";var e=Be(),t=Wt(),n=Se();n.max=function(a,r,o){var u;(a=e(a))&&(u=t(a),a=o.async&&n.async||o.promise&&n.promise?"async":"",r.on("set"+a,o=function(e){void 0!==(e=u.hit(e))&&r.delete(e)}),r.on("get"+a,o),r.on("delete"+a,u.delete),r.on("clear"+a,u.clear))}})),Kt=ae((function(){"use strict";var e=Qe(),t=Se(),n=Object.create,a=Object.defineProperties;t.refCounter=function(r,o,u){var i=n(null);u=u.async&&t.async||u.promise&&t.promise?"async":"";o.on("set"+u,(function(e,t){i[e]=t||1})),o.on("get"+u,(function(e){++i[e]})),o.on("delete"+u,(function(e){delete i[e]})),o.on("clear"+u,(function(){i={}})),a(o.memoized,{deleteRef:e((function(){var e=o.get(arguments);return null!==e&&i[e]?!--i[e]&&(o.delete(e),!0):null})),getRefCount:e((function(){var e=o.get(arguments);return null!==e&&i[e]||0}))})}})),Xt=ae((function(e,t){"use strict";var n=Ee(),a=Te(),r=wt();t.exports=function(e){var t,o=n(arguments[1]);return o.normalizer||0!==(t=o.length=a(o.length,e.length,o.async))&&(o.primitive?!1===t?o.normalizer=Et():1<t&&(o.normalizer=Ct()(t)):o.normalizer=!1===t?Tt()():1===t?Nt()():Rt()(t)),o.async&&St(),o.promise&&Vt(),o.dispose&&$t(),o.maxAge&&Gt(),o.max&&Yt(),o.refCounter&&Kt(),r(e,o)}})),Zt=ae((function(e,a){!function(){"use strict";var e={name:"doT",version:"1.1.1",templateSettings:{evaluate:/\\{\\{([\\s\\S]+?(\\}?)+)\\}\\}/g,interpolate:/\\{\\{=([\\s\\S]+?)\\}\\}/g,encode:/\\{\\{!([\\s\\S]+?)\\}\\}/g,use:/\\{\\{#([\\s\\S]+?)\\}\\}/g,useParams:/(^|[^\\w$])def(?:\\.|\\[[\\\'\\"])([\\w$\\.]+)(?:[\\\'\\"]\\])?\\s*\\:\\s*([\\w$\\.]+|\\"[^\\"]+\\"|\\\'[^\\\']+\\\'|\\{[^\\}]+\\})/g,define:/\\{\\{##\\s*([\\w\\.$]+)\\s*(\\:|=)([\\s\\S]+?)#\\}\\}/g,defineParams:/^\\s*([\\w$]+):([\\s\\S]+)/,conditional:/\\{\\{\\?(\\?)?\\s*([\\s\\S]*?)\\s*\\}\\}/g,iterate:/\\{\\{~\\s*(?:\\}\\}|([\\s\\S]+?)\\s*\\:\\s*([\\w$]+)\\s*(?:\\:\\s*([\\w$]+))?\\s*\\}\\})/g,varname:"it",strip:!0,append:!0,selfcontained:!1,doNotSkipEncoded:!1},template:void 0,compile:void 0,log:!0};if("object"!==("undefined"==typeof globalThis?"undefined":r(globalThis)))try{Object.defineProperty(Object.prototype,"__magic__",{get:function(){return this},configurable:!0}),__magic__.globalThis=__magic__,delete Object.prototype.__magic__}catch(e){t.globalThis=function(){if("undefined"!=typeof self)return self;if(void 0!==t)return t;if(void 0!==n)return n;if(void 0!==this)return this;throw new Error("Unable to locate global `this`")}()}e.encodeHTMLSource=function(e){var t={"&":"&#38;","<":"&#60;",">":"&#62;",\'"\':"&#34;","\'":"&#39;","/":"&#47;"},n=e?/[&<>"\'\\/]/g:/&(?!#?\\w+;)|<|>|"|\'|\\//g;return function(e){return e?e.toString().replace(n,(function(e){return t[e]||e})):""}},void 0!==a&&a.exports?a.exports=e:"function"==typeof define&&define.amd?define((function(){return e})):globalThis.doT=e;var o={append:{start:"\'+(",end:")+\'",startencode:"\'+encodeHTML("},split:{start:"\';out+=(",end:");out+=\'",startencode:"\';out+=encodeHTML("}},u=/$^/;function i(e){return e.replace(/\\\\(\'|\\\\)/g,"$1").replace(/[\\r\\t\\n]/g," ")}e.template=function(t,n,a){var r,l,s=(n=n||e.templateSettings).append?o.append:o.split,c=0;a=n.use||n.define?function e(t,n,a){return("string"==typeof n?n:n.toString()).replace(t.define||u,(function(e,n,r,o){return(n=0===n.indexOf("def.")?n.substring(4):n)in a||(":"===r?(t.defineParams&&o.replace(t.defineParams,(function(e,t,r){a[n]={arg:t,text:r}})),n in a||(a[n]=o)):new Function("def","def[\'"+n+"\']="+o)(a)),""})).replace(t.use||u,(function(n,r){return t.useParams&&(r=r.replace(t.useParams,(function(e,t,n,r){var o;if(a[n]&&a[n].arg&&r)return o=(n+":"+r).replace(/\'|\\\\/g,"_"),a.__exp=a.__exp||{},a.__exp[o]=a[n].text.replace(new RegExp("(^|[^\\\\w$])"+a[n].arg+"([^\\\\w$])","g"),"$1"+r+"$2"),t+"def.__exp[\'"+o+"\']"}))),(r=new Function("def","return "+r)(a))&&e(t,r,a)}))}(n,t,a||{}):t,a=("var out=\'"+(n.strip?a.replace(/(^|\\r|\\n)\\t* +| +\\t*(\\r|\\n|$)/g," ").replace(/\\r|\\n|\\t|\\/\\*[\\s\\S]*?\\*\\//g,""):a).replace(/\'|\\\\/g,"\\\\$&").replace(n.interpolate||u,(function(e,t){return s.start+i(t)+s.end})).replace(n.encode||u,(function(e,t){return r=!0,s.startencode+i(t)+s.end})).replace(n.conditional||u,(function(e,t,n){return t?n?"\';}else if("+i(n)+"){out+=\'":"\';}else{out+=\'":n?"\';if("+i(n)+"){out+=\'":"\';}out+=\'"})).replace(n.iterate||u,(function(e,t,n,a){return t?(c+=1,l=a||"i"+c,t=i(t),"\';var arr"+c+"="+t+";if(arr"+c+"){var "+n+","+l+"=-1,l"+c+"=arr"+c+".length-1;while("+l+"<l"+c+"){"+n+"=arr"+c+"["+l+"+=1];out+=\'"):"\';} } out+=\'"})).replace(n.evaluate||u,(function(e,t){return"\';"+i(t)+"out+=\'"}))+"\';return out;").replace(/\\n/g,"\\\\n").replace(/\\t/g,"\\\\t").replace(/\\r/g,"\\\\r").replace(/(\\s|;|\\}|^|\\{)out\\+=\'\';/g,"$1").replace(/\\+\'\'/g,"");r&&(n.selfcontained||!globalThis||globalThis._encodeHTML||(globalThis._encodeHTML=e.encodeHTMLSource(n.doNotSkipEncoded)),a="var encodeHTML = typeof _encodeHTML !== \'undefined\' ? _encodeHTML : ("+e.encodeHTMLSource.toString()+"("+(n.doNotSkipEncoded||"")+"));"+a);try{return new Function(n.varname,a)}catch(t){throw"undefined"!=typeof console&&console.log("Could not create a template function: "+a),t}},e.compile=function(t,n){return e.template(t,null,n)}}()})),Jt=ae((function(e,o){var u;u=function(){"use strict";function e(e){return"function"==typeof e}var o=Array.isArray||function(e){return"[object Array]"===Object.prototype.toString.call(e)},u=0,i=void 0,l=void 0,s=function(e,t){m[u]=e,m[u+1]=t,2===(u+=2)&&(l?l(h):y())},c=void 0!==t?t:void 0,d=(d=c||{}).MutationObserver||d.WebKitMutationObserver,p="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),f="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function D(){var e=setTimeout;return function(){return e(h,1)}}var m=new Array(1e3);function h(){for(var e=0;e<u;e+=2)(0,m[e])(m[e+1]),m[e]=void 0,m[e+1]=void 0;u=0}var g,b,v,y=void 0;function F(e,t){var n,a=this,r=new this.constructor(C),o=(void 0===r[E]&&M(r),a._state);return o?(n=arguments[o-1],s((function(){return O(o,r,n,a._result)}))):R(a,r,e,t),r}function w(e){var t;return e&&"object"===r(e)&&e.constructor===this?e:(k(t=new this(C),e),t)}y=p?function(){return process.nextTick(h)}:d?(b=0,p=new d(h),v=a.createTextNode(""),p.observe(v,{characterData:!0}),function(){v.data=b=++b%2}):f?((g=new MessageChannel).port1.onmessage=h,function(){return g.port2.postMessage(0)}):(void 0===c?function(){try{var e=Function("return this")().require("vertx");return void 0!==(i=e.runOnLoop||e.runOnContext)?function(){i(h)}:D()}catch(e){return D()}}:D)();var E=Math.random().toString(36).substring(2);function C(){}var x=void 0;function A(t,n,a){var r,o;n.constructor===t.constructor&&a===F&&n.constructor.resolve===w?(r=t,1===(o=n)._state?T(r,o._result):2===o._state?N(r,o._result):R(o,void 0,(function(e){return k(r,e)}),(function(e){return N(r,e)}))):void 0!==a&&e(a)?function(e,t,n){s((function(e){var a=!1,r=function(e,t,n,a){try{e.call(t,n,a)}catch(e){return e}}(n,t,(function(n){a||(a=!0,(t!==n?k:T)(e,n))}),(function(t){a||(a=!0,N(e,t))}),e._label);!a&&r&&(a=!0,N(e,r))}),e)}(t,n,a):T(t,n)}function k(e,t){if(e===t)N(e,new TypeError("You cannot resolve a promise with itself"));else if(a=r(n=t),null===n||"object"!==a&&"function"!==a)T(e,t);else{n=void 0;try{n=t.then}catch(t){return void N(e,t)}A(e,t,n)}var n,a}function B(e){e._onerror&&e._onerror(e._result),_(e)}function T(e,t){e._state===x&&(e._result=t,e._state=1,0!==e._subscribers.length)&&s(_,e)}function N(e,t){e._state===x&&(e._state=2,e._result=t,s(B,e))}function R(e,t,n,a){var r=e._subscribers,o=r.length;e._onerror=null,r[o]=t,r[o+1]=n,r[o+2]=a,0===o&&e._state&&s(_,e)}function _(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var a,r=void 0,o=e._result,u=0;u<t.length;u+=3)a=t[u],r=t[u+n],a?O(n,a,r,o):r(o);e._subscribers.length=0}}function O(t,n,a,r){var o=e(a),u=void 0,i=void 0,l=!0;if(o){try{u=a(r)}catch(t){l=!1,i=t}if(n===u)return void N(n,new TypeError("A promises callback cannot return that same promise."))}else u=r;n._state===x&&(o&&l?k(n,u):!1===l?N(n,i):1===t?T(n,u):2===t&&N(n,u))}var S=0;function M(e){e[E]=S++,e._state=void 0,e._result=void 0,e._subscribers=[]}I.prototype._enumerate=function(e){for(var t=0;this._state===x&&t<e.length;t++)this._eachEntry(e[t],t)},I.prototype._eachEntry=function(e,t){var n=this._instanceConstructor,a=n.resolve;if(a===w){var r,o=void 0,u=void 0,i=!1;try{o=e.then}catch(t){i=!0,u=t}o===F&&e._state!==x?this._settledAt(e._state,t,e._result):"function"!=typeof o?(this._remaining--,this._result[t]=e):n===j?(r=new n(C),i?N(r,u):A(r,e,o),this._willSettleAt(r,t)):this._willSettleAt(new n((function(t){return t(e)})),t)}else this._willSettleAt(a(e),t)},I.prototype._settledAt=function(e,t,n){var a=this.promise;a._state===x&&(this._remaining--,2===e?N(a,n):this._result[t]=n),0===this._remaining&&T(a,this._result)},I.prototype._willSettleAt=function(e,t){var n=this;R(e,void 0,(function(e){return n._settledAt(1,t,e)}),(function(e){return n._settledAt(2,t,e)}))};var P=I;function I(e,t){this._instanceConstructor=e,this.promise=new e(C),this.promise[E]||M(this.promise),o(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0!==this.length&&(this.length=this.length||0,this._enumerate(t),0!==this._remaining)||T(this.promise,this._result)):N(this.promise,new Error("Array Methods must be provided an Array"))}L.prototype.catch=function(e){return this.then(null,e)},L.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then((function(e){return n.resolve(t()).then((function(){return e}))}),(function(e){return n.resolve(t()).then((function(){throw e}))})):this.then(t,t)};var j=L;function L(e){if(this[E]=S++,this._result=this._state=void 0,this._subscribers=[],C!==e){if("function"!=typeof e)throw new TypeError("You must pass a resolver function as the first argument to the promise constructor");if(!(this instanceof L))throw new TypeError("Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.");var t=this;try{e((function(e){k(t,e)}),(function(e){N(t,e)}))}catch(e){N(t,e)}}}return j.prototype.then=F,j.all=function(e){return new P(this,e).promise},j.race=function(e){var t=this;return o(e)?new t((function(n,a){for(var r=e.length,o=0;o<r;o++)t.resolve(e[o]).then(n,a)})):new t((function(e,t){return t(new TypeError("You must pass an array to race."))}))},j.resolve=w,j.reject=function(e){var t=new this(C);return N(t,e),t},j._setScheduler=function(e){l=e},j._setAsap=function(e){s=e},j._asap=s,j.polyfill=function(){var e=void 0;if(void 0!==n)e=n;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var a=null;try{a=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===a&&!t.cast)return}e.Promise=j},j.Promise=j},"object"===r(e=e)&&void 0!==o?o.exports=u():"function"==typeof define&&define.amd?define(u):e.ES6Promise=u()})),Qt=ae((function(e){var t,n,a=(t=Object.prototype.toString,n=Object.prototype.hasOwnProperty,{Class:function(e){return t.call(e).replace(/^\\[object *|\\]$/g,"")},HasProperty:function(e,t){return t in e},HasOwnProperty:function(e,t){return n.call(e,t)},IsCallable:function(e){return"function"==typeof e},ToInt32:function(e){return e>>0},ToUint32:function(e){return e>>>0}}),o=Math.LN2,u=Math.abs,i=Math.floor,l=Math.log,s=Math.min,c=Math.pow,d=Math.round;function p(e,t,n){return e<t?t:n<e?n:e}var f,D,m,h,g,b,v,y,F,w,E,C=Object.getOwnPropertyNames||function(e){if(e!==Object(e))throw new TypeError("Object.getOwnPropertyNames called on non-object");var t,n=[];for(t in e)a.HasOwnProperty(e,t)&&n.push(t);return n};function x(e){if(C&&f)for(var t=C(e),n=0;n<t.length;n+=1)f(e,t[n],{value:e[t[n]],writable:!1,enumerable:!1,configurable:!1})}function A(e){if(f){if(e.length>1e5)throw new RangeError("Array too large for polyfill");for(var t=0;t<e.length;t+=1)!function(t){f(e,t,{get:function(){return e._getter(t)},set:function(n){e._setter(t,n)},enumerable:!0,configurable:!1})}(t)}}function k(e,t){return e<<(t=32-t)>>t}function B(e,t){return e<<(t=32-t)>>>t}function T(e){return B(e[0],8)}function N(e,t,n){var a,r,d,p,f,D,m,h=(1<<t-1)-1;function g(e){var t=i(e);return(e=e-t)<.5||!(.5<e||t%2)?t:t+1}for(e!=e?(r=(1<<t)-1,d=c(2,n-1),a=0):e===1/0||e===-1/0?(r=(1<<t)-1,a=e<(d=0)?1:0):0===e?a=1/e==-1/(d=r=0)?1:0:(a=e<0,(e=u(e))>=c(2,1-h)?(r=s(i(l(e)/o),1023),2<=(d=g(e/c(2,r)*c(2,n)))/c(2,n)&&(r+=1,d=1),h<r?(r=(1<<t)-1,d=0):(r+=h,d-=c(2,n))):(r=0,d=g(e/c(2,1-h-n)))),f=[],p=n;p;--p)f.push(d%2?1:0),d=i(d/2);for(p=t;p;--p)f.push(r%2?1:0),r=i(r/2);for(f.push(a?1:0),f.reverse(),D=f.join(""),m=[];D.length;)m.push(parseInt(D.substring(0,8),2)),D=D.substring(8);return m}function R(e,t,n){for(var a,r,o,u,i,l,s=[],d=e.length;d;--d)for(r=e[d-1],a=8;a;--a)s.push(r%2?1:0),r>>=1;return s.reverse(),l=s.join(""),o=(1<<t-1)-1,u=parseInt(l.substring(0,1),2)?-1:1,i=parseInt(l.substring(1,1+t),2),l=parseInt(l.substring(1+t),2),i===(1<<t)-1?0===l?1/0*u:NaN:0<i?u*c(2,i-o)*(1+l/c(2,n)):0!==l?u*c(2,-(o-1))*(l/c(2,n)):u<0?-0:0}function _(e){if((e=a.ToInt32(e))<0)throw new RangeError("ArrayBuffer size is not a small enough positive integer");var t;for(this.byteLength=e,this._bytes=[],this._bytes.length=e,t=0;t<this.byteLength;t+=1)this._bytes[t]=0;x(this)}function O(){}function S(e,t,n){var o=function(e,t,n){var u,i,l,s;if(arguments.length&&"number"!=typeof e)if("object"===r(e)&&e.constructor===o)for(this.length=(u=e).length,this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new _(this.byteLength),l=this.byteOffset=0;l<this.length;l+=1)this._setter(l,u._getter(l));else if("object"!==r(e)||e instanceof _||"ArrayBuffer"===a.Class(e)){if("object"!==r(e)||!(e instanceof _||"ArrayBuffer"===a.Class(e)))throw new TypeError("Unexpected argument type(s)");if(this.buffer=e,this.byteOffset=a.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteOffset%this.BYTES_PER_ELEMENT)throw new RangeError("ArrayBuffer length minus the byteOffset is not a multiple of the element size.");if(arguments.length<3){if(this.byteLength=this.buffer.byteLength-this.byteOffset,this.byteLength%this.BYTES_PER_ELEMENT)throw new RangeError("length of buffer minus byteOffset not a multiple of the element size");this.length=this.byteLength/this.BYTES_PER_ELEMENT}else this.length=a.ToUint32(n),this.byteLength=this.length*this.BYTES_PER_ELEMENT;if(this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer")}else for(this.length=a.ToUint32((i=e).length),this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new _(this.byteLength),l=this.byteOffset=0;l<this.length;l+=1)s=i[l],this._setter(l,Number(s));else{if(this.length=a.ToInt32(e),n<0)throw new RangeError("ArrayBufferView size is not a small enough positive integer");this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new _(this.byteLength),this.byteOffset=0}this.constructor=o,x(this),A(this)};return(o.prototype=new O).BYTES_PER_ELEMENT=e,o.prototype._pack=t,o.prototype._unpack=n,o.BYTES_PER_ELEMENT=e,o.prototype.get=o.prototype._getter=function(e){if(arguments.length<1)throw new SyntaxError("Not enough arguments");if(!((e=a.ToUint32(e))>=this.length)){for(var t=[],n=0,r=this.byteOffset+e*this.BYTES_PER_ELEMENT;n<this.BYTES_PER_ELEMENT;n+=1,r+=1)t.push(this.buffer._bytes[r]);return this._unpack(t)}},o.prototype._setter=function(e,t){if(arguments.length<2)throw new SyntaxError("Not enough arguments");if((e=a.ToUint32(e))<this.length)for(var n=this._pack(t),r=0,o=this.byteOffset+e*this.BYTES_PER_ELEMENT;r<this.BYTES_PER_ELEMENT;r+=1,o+=1)this.buffer._bytes[o]=n[r]},o.prototype.set=function(e,t){if(arguments.length<1)throw new SyntaxError("Not enough arguments");var n,o,u,i,l,s,c,d,p,f;if("object"===r(e)&&e.constructor===this.constructor){if(n=e,(u=a.ToUint32(t))+n.length>this.length)throw new RangeError("Offset plus length of array is out of range");if(d=this.byteOffset+u*this.BYTES_PER_ELEMENT,p=n.length*this.BYTES_PER_ELEMENT,n.buffer===this.buffer){for(f=[],l=0,s=n.byteOffset;l<p;l+=1,s+=1)f[l]=n.buffer._bytes[s];for(l=0,c=d;l<p;l+=1,c+=1)this.buffer._bytes[c]=f[l]}else for(l=0,s=n.byteOffset,c=d;l<p;l+=1,s+=1,c+=1)this.buffer._bytes[c]=n.buffer._bytes[s]}else{if("object"!==r(e)||void 0===e.length)throw new TypeError("Unexpected argument type(s)");if(i=a.ToUint32((o=e).length),(u=a.ToUint32(t))+i>this.length)throw new RangeError("Offset plus length of array is out of range");for(l=0;l<i;l+=1)s=o[l],this._setter(u+l,Number(s))}},o.prototype.subarray=function(e,t){e=a.ToInt32(e),t=a.ToInt32(t),arguments.length<1&&(e=0),arguments.length<2&&(t=this.length),e<0&&(e=this.length+e),t<0&&(t=this.length+t),e=p(e,0,this.length);var n=(t=p(t,0,this.length))-e;return new this.constructor(this.buffer,this.byteOffset+e*this.BYTES_PER_ELEMENT,n=n<0?0:n)},o}function M(e,t){return a.IsCallable(e.get)?e.get(t):e[t]}function P(t,n,r){if(0===arguments.length)t=new e.ArrayBuffer(0);else if(!(t instanceof e.ArrayBuffer||"ArrayBuffer"===a.Class(t)))throw new TypeError("TypeError");if(this.buffer=t||new e.ArrayBuffer(0),this.byteOffset=a.ToUint32(n),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteLength=arguments.length<3?this.buffer.byteLength-this.byteOffset:a.ToUint32(r),this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer");x(this)}function I(t){return function(n,r){if((n=a.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");n+=this.byteOffset;for(var o=new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT),u=[],i=0;i<t.BYTES_PER_ELEMENT;i+=1)u.push(M(o,i));return Boolean(r)===Boolean(E)&&u.reverse(),M(new t(new e.Uint8Array(u).buffer),0)}}function j(t){return function(n,r,o){if((n=a.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");r=new t([r]);for(var u=new e.Uint8Array(r.buffer),i=[],l=0;l<t.BYTES_PER_ELEMENT;l+=1)i.push(M(u,l));Boolean(o)===Boolean(E)&&i.reverse(),new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT).set(i)}}f=Object.defineProperty&&function(){try{return Object.defineProperty({},"x",{}),1}catch(e){}}()?Object.defineProperty:function(e,t,n){if(!e===Object(e))throw new TypeError("Object.defineProperty called on non-object");return a.HasProperty(n,"get")&&Object.prototype.__defineGetter__&&Object.prototype.__defineGetter__.call(e,t,n.get),a.HasProperty(n,"set")&&Object.prototype.__defineSetter__&&Object.prototype.__defineSetter__.call(e,t,n.set),a.HasProperty(n,"value")&&(e[t]=n.value),e},e.ArrayBuffer=e.ArrayBuffer||_,w=S(1,(function(e){return[255&e]}),(function(e){return k(e[0],8)})),D=S(1,(function(e){return[255&e]}),T),m=S(1,(function(e){return[(e=d(Number(e)))<0?0:255<e?255:255&e]}),T),h=S(2,(function(e){return[e>>8&255,255&e]}),(function(e){return k(e[0]<<8|e[1],16)})),g=S(2,(function(e){return[e>>8&255,255&e]}),(function(e){return B(e[0]<<8|e[1],16)})),b=S(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return k(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),v=S(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return B(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),y=S(4,(function(e){return N(e,8,23)}),(function(e){return R(e,8,23)})),F=S(8,(function(e){return N(e,11,52)}),(function(e){return R(e,11,52)})),e.Int8Array=e.Int8Array||w,e.Uint8Array=e.Uint8Array||D,e.Uint8ClampedArray=e.Uint8ClampedArray||m,e.Int16Array=e.Int16Array||h,e.Uint16Array=e.Uint16Array||g,e.Int32Array=e.Int32Array||b,e.Uint32Array=e.Uint32Array||v,e.Float32Array=e.Float32Array||y,e.Float64Array=e.Float64Array||F,w=new e.Uint16Array([4660]),E=18===M(new e.Uint8Array(w.buffer),0),P.prototype.getUint8=I(e.Uint8Array),P.prototype.getInt8=I(e.Int8Array),P.prototype.getUint16=I(e.Uint16Array),P.prototype.getInt16=I(e.Int16Array),P.prototype.getUint32=I(e.Uint32Array),P.prototype.getInt32=I(e.Int32Array),P.prototype.getFloat32=I(e.Float32Array),P.prototype.getFloat64=I(e.Float64Array),P.prototype.setUint8=j(e.Uint8Array),P.prototype.setInt8=j(e.Int8Array),P.prototype.setUint16=j(e.Uint16Array),P.prototype.setInt16=j(e.Int16Array),P.prototype.setUint32=j(e.Uint32Array),P.prototype.setInt32=j(e.Int32Array),P.prototype.setFloat32=j(e.Float32Array),P.prototype.setFloat64=j(e.Float64Array),e.DataView=e.DataView||P})),en=ae((function(e){!function(e){"use strict";var t,n,a;function o(){if(void 0===this)throw new TypeError("Constructor WeakMap requires \'new\'");if(a(this,"_id","_WeakMap_"+i()+"."+i()),0<arguments.length)throw new TypeError("WeakMap iterable is not supported")}function u(e,n){if(!l(e)||!t.call(e,"_id"))throw new TypeError(n+" method called on incompatible receiver "+r(e))}function i(){return Math.random().toString().substring(2)}function l(e){return Object(e)===e}e.WeakMap||(t=Object.prototype.hasOwnProperty,n=Object.defineProperty&&function(){try{return 1===Object.defineProperty({},"x",{value:1}).x}catch(e){}}(),e.WeakMap=((a=function(e,t,a){n?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:a}):e[t]=a})(o.prototype,"delete",(function(e){var t;return u(this,"delete"),!!l(e)&&!(!(t=e[this._id])||t[0]!==e||(delete e[this._id],0))})),a(o.prototype,"get",(function(e){var t;return u(this,"get"),l(e)&&(t=e[this._id])&&t[0]===e?t[1]:void 0})),a(o.prototype,"has",(function(e){var t;return u(this,"has"),!!l(e)&&!(!(t=e[this._id])||t[0]!==e)})),a(o.prototype,"set",(function(e,t){var n;if(u(this,"set"),l(e))return(n=e[this._id])&&n[0]===e?n[1]=t:a(e,this._id,[e,t]),this;throw new TypeError("Invalid value used as weak map key")})),a(o,"_polyfill",!0),o))}("undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:void 0!==t?t:void 0!==n?n:e)})),tn={helpUrlBase:"https://dequeuniversity.com/rules/",gridSize:200,results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze(["minor","moderate","serious","critical"]),preload:Object.freeze({assets:["cssom","media"],timeout:1e4}),allOrigins:"<unsafe_all_origins>",sameOrigin:"<same_origin>"},nn=([{name:"NA",value:"inapplicable",priority:0,group:"inapplicable"},{name:"PASS",value:"passed",priority:1,group:"passes"},{name:"CANTTELL",value:"cantTell",priority:2,group:"incomplete"},{name:"FAIL",value:"failed",priority:3,group:"violations"}].forEach((function(e){var t=e.name,n=e.value,a=e.priority;e=e.group;tn[t]=n,tn[t+"_PRIO"]=a,tn[t+"_GROUP"]=e,tn.results[a]=n,tn.resultGroups[a]=e,tn.resultGroupMap[n]=e})),Object.freeze(tn.results),Object.freeze(tn.resultGroups),Object.freeze(tn.resultGroupMap),Object.freeze(tn),tn),an=function(){"object"===("undefined"==typeof console?"undefined":r(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},rn=/[\\t\\r\\n\\f]/g;function on(){X(this,on),this.parent=void 0}J(on,[{key:"props",get:function(){throw new Error(\'VirtualNode class must have a "props" object consisting of "nodeType" and "nodeName" properties\')}},{key:"attrNames",get:function(){throw new Error(\'VirtualNode class must have an "attrNames" property\')}},{key:"attr",value:function(){throw new Error(\'VirtualNode class must have an "attr" function\')}},{key:"hasAttr",value:function(){throw new Error(\'VirtualNode class must have a "hasAttr" function\')}},{key:"hasClass",value:function(e){var t=this.attr("class");return!!t&&(e=" "+e+" ",0<=(" "+t+" ").replace(rn," ").indexOf(e))}}]);var un=on,ln={},sn=(re(ln,{DqElement:function(){return Jn},aggregate:function(){return sn},aggregateChecks:function(){return mn},aggregateNodeResults:function(){return gn},aggregateResult:function(){return vn},areStylesSet:function(){return yn},assert:function(){return Fn},checkHelper:function(){return Qn},clone:function(){return ea},closest:function(){return ca},collectResultsFromFrames:function(){return tr},contains:function(){return nr},convertSelector:function(){return ia},cssParser:function(){return ta},deepMerge:function(){return ar},escapeSelector:function(){return En},extendMetaData:function(){return rr},filterHtmlAttrs:function(){return fp},finalizeRuleResult:function(){return hn},findBy:function(){return Ja},getAllChecks:function(){return Za},getAncestry:function(){return Gn},getBaseLang:function(){return td},getCheckMessage:function(){return sd},getCheckOption:function(){return cd},getEnvironmentData:function(){return dd},getFlattenedTree:function(){return ed},getFrameContexts:function(){return Ed},getFriendlyUriEnd:function(){return Bn},getNodeAttributes:function(){return Tn},getNodeFromTree:function(){return Xn},getPreloadConfig:function(){return up},getRootNode:function(){return lr},getRule:function(){return Cd},getScroll:function(){return xd},getScrollState:function(){return kd},getSelector:function(){return Hn},getSelectorData:function(){return qn},getShadowSelector:function(){return _n},getStandards:function(){return Bd},getStyleSheetFactory:function(){return Nd},getXpath:function(){return Wn},injectStyle:function(){return Rd},isHidden:function(){return _d},isHtmlElement:function(){return Od},isNodeInContext:function(){return Sd},isShadowRoot:function(){return ur},isValidLang:function(){return Ep},isXHTML:function(){return Rn},matchAncestry:function(){return Pd},matches:function(){return sa},matchesExpression:function(){return la},matchesSelector:function(){return Nn},memoize:function(){return Dr},mergeResults:function(){return er},nodeLookup:function(){return jd},nodeSorter:function(){return Id},parseCrossOriginStylesheet:function(){return $d},parseSameOriginStylesheet:function(){return zd},parseStylesheet:function(){return Vd},performanceTimer:function(){return Wd},pollyfillElementsFromPoint:function(){return Yd},preload:function(){return ip},preloadCssom:function(){return tp},preloadMedia:function(){return rp},processMessage:function(){return ld},publishMetaData:function(){return sp},querySelectorAll:function(){return cp},querySelectorAllFilter:function(){return ep},queue:function(){return ha},respondable:function(){return Ga},ruleShouldRun:function(){return pp},select:function(){return mp},sendCommandToFrame:function(){return Ya},setScrollState:function(){return hp},shadowSelect:function(){return gp},shadowSelectAll:function(){return bp},shouldPreload:function(){return op},toArray:function(){return wn},tokenList:function(){return Uc},uniqueArray:function(){return Zd},uuid:function(){return Ta},validInputTypes:function(){return vp},validLangs:function(){return Fp}}),function(e,t,n){return t=t.slice(),n&&t.push(n),n=t.map((function(t){return e.indexOf(t)})).sort(),e[n.pop()]}),cn=nn.CANTTELL_PRIO,dn=nn.FAIL_PRIO,pn=[],fn=(pn[nn.PASS_PRIO]=!0,pn[nn.CANTTELL_PRIO]=null,pn[nn.FAIL_PRIO]=!1,["any","all","none"]);function Dn(e,t){fn.reduce((function(n,a){return n[a]=(e[a]||[]).map((function(e){return t(e,a)})),n}),{})}var mn=function(e){var t=Object.assign({},e),n=(Dn(t,(function(e,t){var n=void 0===e.result?-1:pn.indexOf(e.result);e.priority=-1!==n?n:nn.CANTTELL_PRIO,"none"===t&&(e.priority===nn.PASS_PRIO?e.priority=nn.FAIL_PRIO:e.priority===nn.FAIL_PRIO&&(e.priority=nn.PASS_PRIO))})),{all:t.all.reduce((function(e,t){return Math.max(e,t.priority)}),0),none:t.none.reduce((function(e,t){return Math.max(e,t.priority)}),0),any:t.any.reduce((function(e,t){return Math.min(e,t.priority)}),4)%4}),a=(t.priority=Math.max(n.all,n.none,n.any),[]);return fn.forEach((function(e){t[e]=t[e].filter((function(a){return a.priority===t.priority&&a.priority===n[e]})),t[e].forEach((function(e){return a.push(e.impact)}))})),[cn,dn].includes(t.priority)?t.impact=sn(nn.impact,a):t.impact=null,Dn(t,(function(e){delete e.result,delete e.priority})),t.result=nn.results[t.priority],delete t.priority,t},hn=function(e){var t=o._audit.rules.find((function(t){return t.id===e.id}));return t&&t.impact&&e.nodes.forEach((function(e){["any","all","none"].forEach((function(n){(e[n]||[]).forEach((function(e){e.impact=t.impact}))}))})),Object.assign(e,gn(e.nodes)),delete e.nodes,e},gn=function(e){var t={},n=((e=e.map((function(e){if(e.any&&e.all&&e.none)return mn(e);if(Array.isArray(e.node))return hn(e);throw new TypeError("Invalid Result type")})))&&e.length?(n=e.map((function(e){return e.result})),t.result=sn(nn.results,n,t.result)):t.result="inapplicable",nn.resultGroups.forEach((function(e){return t[e]=[]})),e.forEach((function(e){var n=nn.resultGroupMap[e.result];t[n].push(e)})),nn.FAIL_GROUP);return 0===t[n].length&&(n=nn.CANTTELL_GROUP),0<t[n].length?(e=t[n].map((function(e){return e.impact})),t.impact=sn(nn.impact,e)||null):t.impact=null,t};function bn(e,t,n){var a=Object.assign({},t);a.nodes=(a[n]||[]).concat(),nn.resultGroups.forEach((function(e){delete a[e]})),e[n].push(a)}var vn=function(e){var t={};return nn.resultGroups.forEach((function(e){return t[e]=[]})),e.forEach((function(e){e.error?bn(t,e,nn.CANTTELL_GROUP):e.result===nn.NA?bn(t,e,nn.NA_GROUP):nn.resultGroups.forEach((function(n){Array.isArray(e[n])&&0<e[n].length&&bn(t,e,n)}))})),t},yn=function e(n,a,r){var o=t.getComputedStyle(n,null);if(!o)return!1;for(var u=0;u<a.length;++u){var i=a[u];if(o.getPropertyValue(i.property)===i.value)return!0}return!(!n.parentNode||n.nodeName.toUpperCase()===r.toUpperCase())&&e(n.parentNode,a,r)},Fn=function(e,t){if(!e)throw new Error(t)},wn=function(e){return Array.prototype.slice.call(e)},En=function(e){for(var t,n=String(e),a=n.length,r=-1,o="",u=n.charCodeAt(0);++r<a;)0==(t=n.charCodeAt(r))?o+="�":o+=1<=t&&t<=31||127==t||0==r&&48<=t&&t<=57||1==r&&48<=t&&t<=57&&45==u?"\\\\"+t.toString(16)+" ":0==r&&1==a&&45==t||!(128<=t||45==t||95==t||48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122)?"\\\\"+n.charAt(r):n.charAt(r);return o};function Cn(e,t){return[e.substring(0,t),e.substring(t)]}function xn(e){return e.replace(/\\s+$/,"")}var An,kn,Bn=function(){var e,t,n,a,r,o,u,i,l=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"",s=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!(l.length<=1||"data:"===l.substr(0,5)||"javascript:"===l.substr(0,11)||l.includes("?")))return e=s.currentDomain,s=void 0===(s=s.maxLength)?25:s,u=o=i=r=a="",(n=l=l).includes("#")&&(l=(t=W(Cn(l,l.indexOf("#")),2))[0],u=t[1]),l.includes("?")&&(l=(t=W(Cn(l,l.indexOf("?")),2))[0],o=t[1]),l.includes("://")?(a=(t=W(l.split("://"),2))[0],r=(t=W(Cn(l=t[1],l.indexOf("/")),2))[0],l=t[1]):"//"===l.substr(0,2)&&(r=(t=W(Cn(l=l.substr(2),l.indexOf("/")),2))[0],l=t[1]),(r="www."===r.substr(0,4)?r.substr(4):r)&&r.includes(":")&&(r=(t=W(Cn(r,r.indexOf(":")),2))[0],i=t[1]),n=(t={original:n,protocol:a,domain:r,port:i,path:l,query:o,hash:u}).domain,a=t.hash,i=(r=t.path).substr(r.substr(0,r.length-2).lastIndexOf("/")+1),a?i&&(i+a).length<=s?xn(i+a):i.length<2&&2<a.length&&a.length<=s?xn(a):void 0:n&&n.length<s&&r.length<=1||r==="/"+i&&n&&e&&n!==e&&(n+r).length<=s?xn(n+r):(-1===(l=i.lastIndexOf("."))||1<l)&&(-1!==l||2<i.length)&&i.length<=s&&!i.match(/index(\\.[a-zA-Z]{2-4})?/)&&!function(e){var t=0<arguments.length&&void 0!==e?e:"";return 0!==t.length&&(t.match(/[0-9]/g)||"").length>=t.length/2}(i)?xn(i):void 0},Tn=function(e){return(e.attributes instanceof t.NamedNodeMap?e:e.cloneNode(!1)).attributes},Nn=function(e,t){return!!e[An=An&&e[An]?An:function(e){for(var t,n=["matches","matchesSelector","mozMatchesSelector","webkitMatchesSelector","msMatchesSelector"],a=n.length,r=0;r<a;r++)if(e[t=n[r]])return t}(e)]&&e[An](t)},Rn=function(e){return!!e.createElement&&"A"===e.createElement("A").localName},_n=function(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};if(!t)return"";var r=t.getRootNode&&t.getRootNode()||a;if(11!==r.nodeType)return e(t,n,r);for(var o=[];11===r.nodeType;){if(!r.host)return"";o.unshift({elm:t,doc:r}),r=(t=r.host).getRootNode()}return o.unshift({elm:t,doc:r}),o.map((function(t){var a=t.elm;t=t.doc;return e(a,n,t)}))},On=["class","style","id","selected","checked","disabled","tabindex","aria-checked","aria-selected","aria-invalid","aria-activedescendant","aria-busy","aria-disabled","aria-expanded","aria-grabbed","aria-pressed","aria-valuenow"],Sn=/([\\\\"])/g,Mn=/(\\r\\n|\\r|\\n)/g;function Pn(e){return e.replace(Sn,"\\\\$1").replace(Mn,"\\\\a ")}function In(e,t){var n,a=t.name;return-1!==a.indexOf("href")||-1!==a.indexOf("src")?(n=Bn(e.getAttribute(a)))?En(t.name)+\'$="\'+Pn(n)+\'"\':En(t.name)+\'="\'+Pn(e.getAttribute(a))+\'"\':En(a)+\'="\'+Pn(t.value)+\'"\'}function jn(e,t){return e.count<t.count?-1:e.count===t.count?0:1}function Ln(e){return!On.includes(e.name)&&-1===e.name.indexOf(":")&&(!e.value||e.value.length<31)}function qn(e){for(var t={classes:{},tags:{},attributes:{}},n=(e=Array.isArray(e)?e:[e]).slice(),a=[];n.length;)!function(){var e,r=n.pop(),o=r.actualNode;for(o.querySelectorAll&&(e=o.nodeName,t.tags[e]?t.tags[e]++:t.tags[e]=1,o.classList&&Array.from(o.classList).forEach((function(e){e=En(e),t.classes[e]?t.classes[e]++:t.classes[e]=1})),o.hasAttributes())&&Array.from(Tn(o)).filter(Ln).forEach((function(e){(e=In(o,e))&&(t.attributes[e]?t.attributes[e]++:t.attributes[e]=1)})),r.children.length&&(a.push(n),n=r.children.slice());!n.length&&a.length;)n=a.pop()}();return t}function zn(e){return void 0===kn&&(kn=Rn(a)),En(kn?e.localName:e.nodeName.toLowerCase())}function Vn(e,t){var n,a,r,o,u,i,l,s,c,d="",p=(a=e,r=[],o=t.classes,u=t.tags,a.classList&&Array.from(a.classList).forEach((function(e){e=En(e),o[e]<u[a.nodeName]&&r.push({name:e,count:o[e],species:"class"})})),r.sort(jn));i=e,l=[],s=t.attributes,c=t.tags,i.hasAttributes()&&Array.from(Tn(i)).filter(Ln).forEach((function(e){(e=In(i,e))&&s[e]<c[i.nodeName]&&l.push({name:e,count:s[e],species:"attribute"})})),t=l.sort(jn);return p.length&&1===p[0].count?n=[p[0]]:t.length&&1===t[0].count?(n=[t[0]],d=zn(e)):((n=p.concat(t)).sort(jn),(n=n.slice(0,3)).some((function(e){return"class"===e.species}))?n.sort((function(e,t){return e.species!==t.species&&"class"===e.species?-1:e.species===t.species?0:1})):d=zn(e)),d+n.reduce((function(e,t){switch(t.species){case"class":return e+"."+t.name;case"attribute":return e+"["+t.name+"]"}return e}),"")}function $n(e,t,n){if(!o._selectorData)throw new Error("Expect axe._selectorData to be set up");var r,u,i=void 0!==(t=t.toRoot)&&t;do{var l=function(e){var t;if(e.getAttribute("id"))return t=e.getRootNode&&e.getRootNode()||a,(e="#"+En(e.getAttribute("id")||"")).match(/player_uid_/)||1!==t.querySelectorAll(e).length?void 0:e}(e);l||(l=Vn(e,o._selectorData),l+=function(e,t){var n=e.parentNode&&Array.from(e.parentNode.children||"")||[];return n.find((function(n){return n!==e&&Nn(n,t)}))?":nth-child("+(1+n.indexOf(e))+")":""}(e,l)),r=r?l+" > "+r:l,u=u?u.filter((function(e){return Nn(e,r)})):Array.from(n.querySelectorAll(r)),e=e.parentElement}while((1<u.length||i)&&e&&11!==e.nodeType);return 1===u.length?r:-1!==r.indexOf(" > ")?":root"+r.substring(r.indexOf(" > ")):":root"}function Hn(e,t){return _n($n,e,t)}function Un(e){var t,n=e.nodeName.toLowerCase(),a=e.parentElement;return a?(t="","head"!==n&&"body"!==n&&1<a.children.length&&(e=Array.prototype.indexOf.call(a.children,e)+1,t=":nth-child(".concat(e,")")),Un(a)+" > "+n+t):n}function Gn(e,t){return _n(Un,e,t)}var Wn=function(e){return function e(t,n){var a,r,o,u;if(!t)return[];if(!n&&9===t.nodeType)return[{str:"html"}];if(n=n||[],t.parentNode&&t.parentNode!==t&&(n=e(t.parentNode,n)),t.previousSibling){for(r=1,a=t.previousSibling;1===a.nodeType&&a.nodeName===t.nodeName&&r++,a=a.previousSibling;);1===r&&(r=null)}else if(t.nextSibling)for(a=t.nextSibling;a=1===a.nodeType&&a.nodeName===t.nodeName?(r=1,null):(r=null,a.previousSibling););return 1===t.nodeType&&((o={}).str=t.nodeName.toLowerCase(),(u=t.getAttribute&&En(t.getAttribute("id")))&&1===t.ownerDocument.querySelectorAll("#"+u).length&&(o.id=t.getAttribute("id")),1<r&&(o.count=r),n.push(o)),n}(e).reduce((function(e,t){return t.id?"/".concat(t.str,"[@id=\'").concat(t.id,"\']"):e+"/".concat(t.str)+(0<t.count?"[".concat(t.count,"]"):"")}),"")},Yn={},Kn={set:function(e,t){var n;Fn("string"==typeof(n=e),"key must be a string, "+r(n)+" given"),Fn(""!==n,"key must not be empty"),Yn[e]=t},get:function(e,t){var n;return Fn("function"==typeof(n=t)||void 0===n,"creator must be a function or undefined, "+r(n)+" given"),e in Yn?Yn[e]:"function"==typeof t?(n=t(),Fn(void 0!==n,"Cache creator function should not return undefined"),this.set(e,n),Yn[e]):void 0},clear:function(){Yn={}}},Xn=function(e,t){return t=t||e,Kn.get("nodeMap")?Kn.get("nodeMap").get(t):null};function Zn(e){var n,a,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};this.spec=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},e instanceof un?(this._virtualNode=e,this._element=e.actualNode):(this._element=e,this._virtualNode=Xn(e)),this.fromFrame=1<(null==(n=this.spec.selector)?void 0:n.length),r.absolutePaths&&(this._options={toRoot:!0}),this.nodeIndexes=[],Array.isArray(this.spec.nodeIndexes)?this.nodeIndexes=this.spec.nodeIndexes:"number"==typeof(null==(n=this._virtualNode)?void 0:n.nodeIndex)&&(this.nodeIndexes=[this._virtualNode.nodeIndex]),this.source=null,o._audit.noHtml||(this.source=null!=(r=this.spec.source)?r:null!=(n=this._element)&&n.outerHTML?((r=n.outerHTML)||"function"!=typeof t.XMLSerializer||(r=(new t.XMLSerializer).serializeToString(n)),(n=r||"").length>(a=a||300)&&(a=n.indexOf(">"),n=n.substring(0,a+1)),n):"")}Zn.prototype={get selector(){return this.spec.selector||[Hn(this.element,this._options)]},get ancestry(){return this.spec.ancestry||[Gn(this.element)]},get xpath(){return this.spec.xpath||[Wn(this.element)]},get element(){return this._element},toJSON:function(){return{selector:this.selector,source:this.source,xpath:this.xpath,ancestry:this.ancestry,nodeIndexes:this.nodeIndexes}}},Zn.fromFrame=function(e,t,n){return e=Zn.mergeSpecs(e,n),new Zn(n.element,t,e)},Zn.mergeSpecs=function(e,t){return G({},e,{selector:[].concat(H(t.selector),H(e.selector)),ancestry:[].concat(H(t.ancestry),H(e.ancestry)),xpath:[].concat(H(t.xpath),H(e.xpath)),nodeIndexes:[].concat(H(t.nodeIndexes),H(e.nodeIndexes))})};var Jn=Zn,Qn=function(e,n,a,r){return{isAsync:!1,async:function(){return this.isAsync=!0,function(t){t instanceof Error==0?(e.result=t,a(e)):r(t)}},data:function(t){e.data=t},relatedNodes:function(a){t.Node&&(a=a instanceof t.Node||a instanceof un?[a]:wn(a),e.relatedNodes=[],a.forEach((function(a){(a=a instanceof un?a.actualNode:a)instanceof t.Node&&(a=new Jn(a,n),e.relatedNodes.push(a))})))}}},ea=function e(n){var a,o,u,i=n;if(null!=(a=t)&&a.Node&&n instanceof t.Node||null!=(a=t)&&a.HTMLCollection&&n instanceof t.HTMLCollection)return n;if(null!==n&&"object"===r(n))if(Array.isArray(n))for(i=[],o=0,u=n.length;o<u;o++)i[o]=e(n[o]);else for(o in i={},n)i[o]=e(n[o]);return i},ta=((Mo=new(oe(ye()).CssSelectorParser)).registerSelectorPseudos("not"),Mo.registerSelectorPseudos("is"),Mo.registerNestingOperators(">"),Mo.registerAttrEqualityMods("^","$","*","~"),Mo);function na(e,t){return u=t,1===(o=e).props.nodeType&&("*"===u.tag||o.props.nodeName===u.tag)&&(r=e,!(o=t).classes||o.classes.every((function(e){return r.hasClass(e.value)})))&&(a=e,!(u=t).attributes||u.attributes.every((function(e){var t=a.attr(e.key);return null!==t&&e.test(t)})))&&(o=e,!(u=t).id||o.props.id===u.id)&&(n=e,!((o=t).pseudos&&!o.pseudos.every((function(e){if("not"===e.name)return!e.expressions.some((function(e){return la(n,e)}));if("is"===e.name)return e.expressions.some((function(e){return la(n,e)}));throw new Error("the pseudo selector "+e.name+" has not yet been implemented")}))));var n,a,r,o,u}aa=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g;var aa,ra=function(e){return e.replace(aa,"\\\\")},oa=/\\\\/g;function ua(e){return e.map((function(e){for(var t=[],n=e.rule;n;)t.push({tag:n.tagName?n.tagName.toLowerCase():"*",combinator:n.nestingOperator||" ",id:n.id,attributes:function(e){if(e)return e.map((function(e){var t,n,a=e.name.replace(oa,""),r=(e.value||"").replace(oa,"");switch(e.operator){case"^=":n=new RegExp("^"+ra(r));break;case"$=":n=new RegExp(ra(r)+"$");break;case"~=":n=new RegExp("(^|\\\\s)"+ra(r)+"(\\\\s|$)");break;case"|=":n=new RegExp("^"+ra(r)+"(-|$)");break;case"=":t=function(e){return r===e};break;case"*=":t=function(e){return e&&e.includes(r)};break;case"!=":t=function(e){return r!==e};break;default:t=function(e){return null!==e}}return""===r&&/^[*$^]=$/.test(e.operator)&&(t=function(){return!1}),{key:a,value:r,type:void 0===e.value?"attrExist":"attrValue",test:t=t||function(e){return e&&n.test(e)}}}))}(n.attrs),classes:function(e){if(e)return e.map((function(e){return{value:e=e.replace(oa,""),regexp:new RegExp("(^|\\\\s)"+ra(e)+"(\\\\s|$)")}}))}(n.classNames),pseudos:function(e){if(e)return e.map((function(e){var t;return["is","not"].includes(e.name)&&(t=ua(t=(t=e.value).selectors||[t])),{name:e.name,expressions:t,value:e.value}}))}(n.pseudos)}),n=n.rule;return t}))}function ia(e){return ua((e=ta.parse(e)).selectors||[e])}function la(e,t,n){return function e(t,n,a,r){if(!t)return!1;for(var o=Array.isArray(n)?n[a]:n,u=na(t,o);!u&&r&&t.parent;)u=na(t=t.parent,o);if(0<a){if(!1===[" ",">"].includes(o.combinator))throw new Error("axe.utils.matchesExpression does not support the combinator: "+o.combinator);u=u&&e(t.parent,n,a-1," "===o.combinator)}return u}(e,t,t.length-1,n)}var sa=function(e,t){return ia(t).some((function(t){return la(e,t)}))},ca=function(e,t){for(;e;){if(sa(e,t))return e;if(void 0===e.parent)throw new TypeError("Cannot resolve parent for non-DOM nodes");e=e.parent}return null};function da(){}function pa(e){if("function"!=typeof e)throw new TypeError("Queue methods require functions as arguments")}for(var fa,Da,ma,ha=function(){function e(e){t=e,setTimeout((function(){null!=t&&an("Uncaught error (of queue)",t)}),1)}var t,n=[],a=0,o=0,u=da,i=!1,l=e;function s(e){return u=da,l(e),n}function c(){for(var e=n.length;a<e;a++){var t=n[a];try{t.call(null,function(e){return function(t){n[e]=t,--o||u===da||(i=!0,u(n))}}(a),s)}catch(e){s(e)}}}var d={defer:function(e){var a;if("object"===r(e)&&e.then&&e.catch&&(a=e,e=function(e,t){a.then(e).catch(t)}),pa(e),void 0===t){if(i)throw new Error("Queue already completed");return n.push(e),++o,c(),d}},then:function(e){if(pa(e),u!==da)throw new Error("queue `then` already set");return t||(u=e,o)||(i=!0,u(n)),d},catch:function(n){if(pa(n),l!==e)throw new Error("queue `catch` already set");return t?(n(t),t=null):l=n,d},abort:s};return d},ga=t.crypto||t.msCrypto,ba=(!fa&&ga&&ga.getRandomValues&&(Da=new Uint8Array(16),fa=function(){return ga.getRandomValues(Da),Da}),fa||(ma=new Array(16),fa=function(){for(var e,t=0;t<16;t++)0==(3&t)&&(e=4294967296*Math.random()),ma[t]=e>>>((3&t)<<3)&255;return ma}),"function"==typeof t.Buffer?t.Buffer:Array),va=[],ya={},Fa=0;Fa<256;Fa++)va[Fa]=(Fa+256).toString(16).substr(1),ya[va[Fa]]=Fa;function wa(e,t){return t=t||0,va[e[t++]]+va[e[t++]]+va[e[t++]]+va[e[t++]]+"-"+va[e[t++]]+va[e[t++]]+"-"+va[e[t++]]+va[e[t++]]+"-"+va[e[t++]]+va[e[t++]]+"-"+va[e[t++]]+va[e[t++]]+va[e[t++]]+va[e[t++]]+va[e[t++]]+va[e[+t]]}var Ea=[1|(Mo=fa())[0],Mo[1],Mo[2],Mo[3],Mo[4],Mo[5]],Ca=16383&(Mo[6]<<8|Mo[7]),xa=0,Aa=0;function ka(e,t,n){var a=t&&n||0,r=t||[],o=(n=null!=(e=e||{}).clockseq?e.clockseq:Ca,null!=e.msecs?e.msecs:(new Date).getTime()),u=null!=e.nsecs?e.nsecs:Aa+1;if((i=o-xa+(u-Aa)/1e4)<0&&null==e.clockseq&&(n=n+1&16383),1e4<=(u=(i<0||xa<o)&&null==e.nsecs?0:u))throw new Error("uuid.v1(): Can\'t create more than 10M uuids/sec");xa=o,Ca=n;for(var i=(1e4*(268435455&(o+=122192928e5))+(Aa=u))%4294967296,l=(u=(r[a++]=i>>>24&255,r[a++]=i>>>16&255,r[a++]=i>>>8&255,r[a++]=255&i,o/4294967296*1e4&268435455),r[a++]=u>>>8&255,r[a++]=255&u,r[a++]=u>>>24&15|16,r[a++]=u>>>16&255,r[a++]=n>>>8|128,r[a++]=255&n,e.node||Ea),s=0;s<6;s++)r[a+s]=l[s];return t||wa(r)}function Ba(e,t,n){var a=t&&n||0,r=("string"==typeof e&&(t="binary"==e?new ba(16):null,e=null),(e=e||{}).random||(e.rng||fa)());if(r[6]=15&r[6]|64,r[8]=63&r[8]|128,t)for(var o=0;o<16;o++)t[a+o]=r[o];return t||wa(r)}(Mo=Ba).v1=ka,Mo.v4=Ba,Mo.parse=function(e,t,n){var a=t&&n||0,r=0;for(t=t||[],e.toLowerCase().replace(/[0-9a-f]{2}/g,(function(e){r<16&&(t[a+r++]=ya[e])}));r<16;)t[a+r++]=0;return t},Mo.unparse=wa,Mo.BufferClass=ba,o._uuid=ka();var Ta=Ba,Na=Object.freeze(["EvalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError"]);function Ra(){var e="axeAPI",t="";return(e=void 0!==o&&o._audit&&o._audit.application?o._audit.application:e)+"."+(void 0!==o?o.version:t)}function _a(e){Sa(e),Fn(t.parent===e,"Source of the response must be the parent window.")}function Oa(e){Sa(e),Fn(e.parent===t,"Respondable target must be a frame in the current window")}function Sa(e){Fn(t!==e,"Messages can not be sent to the same window.")}var Ma={},Pa=[];function Ia(){var e="".concat(Ba(),":").concat(Ba());return Pa.includes(e)?Ia():(Pa.push(e),e)}function ja(e,t,n,a){var r,u;return"function"==typeof a&&function(e,t,n){var a=!(2<arguments.length&&void 0!==n)||n;Fn(!Ma[e],"A replyHandler already exists for this message channel."),Ma[e]={replyHandler:t,sendToParent:a}}(t.channelId,a,n),(n?_a:Oa)(e),t.message instanceof Error&&!n?(o.log(t.message),!1):(n=(a=G({messageId:Ia()},t)).topic,t=a.channelId,u=a.message,t={channelId:t,topic:n,messageId:a.messageId,keepalive:!!a.keepalive,source:Ra()},u instanceof Error?t.error={name:u.name,message:u.message,stack:u.stack}:t.payload=u,r=JSON.stringify(t),!(!(n=o._audit.allowedOrigins)||!n.length||(n.forEach((function(t){try{e.postMessage(r,t)}catch(n){if(n instanceof e.DOMException)throw new Error(\'allowedOrigins value "\'.concat(t,\'" is not a valid origin\'));throw n}})),0)))}function La(e,t,n){var a=!(2<arguments.length&&void 0!==n)||n;return function(n,r,o){ja(e,{channelId:t,message:n,keepalive:r},a,o)}}function qa(e,n){var a,u,i,l=e.origin,s=e.data;e=e.source;try{var c=function(e){var n,a,o,u;try{n=JSON.parse(e)}catch(e){return}if(null!==(e=n)&&"object"===r(e)&&"string"==typeof e.channelId&&e.source===Ra())return a=(e=n).topic,o=e.channelId,u=e.messageId,e=e.keepalive,{topic:a,message:"object"===r(n.error)?function(e){var n=e.message||"Unknown error occurred",a=Na.includes(e.name)?e.name:"Error";return a=t[a]||Error,e.stack&&(n+="\\n"+e.stack.replace(e.message,"")),new a(n)}(n.error):n.payload,messageId:u,channelId:o,keepalive:!!e}}(s)||{},d=c.channelId,p=c.message,f=c.messageId;if(u=l,((i=o._audit.allowedOrigins)&&i.includes("*")||i.includes(u))&&(a=f,!Pa.includes(a))&&(Pa.push(a),1))if(p instanceof Error&&e.parent!==t)o.log(p);else try{if(c.topic){var D=La(e,d);_a(e),n(c,D)}else{var m=e,h=(b=c).channelId,g=b.message,b=b.keepalive,v=(y=function(e){return Ma[e]}(h)||{}).replyHandler,y=y.sendToParent;if(v){(y?_a:Oa)(m),m=La(m,h,y),!b&&h&&function(e){delete Ma[e]}(h);try{v(g,b,m)}catch(n){o.log(n),m(n,b)}}}}catch(n){var F=e,w=n,E=d;if(!F.parent!==t)o.log(w);else try{ja(F,{topic:null,channelId:E,message:w,messageId:Ia(),keepalive:!0},!0)}catch(n){return void o.log(n)}}}catch(n){o.log(n)}}var za,Va,$a={open:function(e){var n;if("function"==typeof t.addEventListener)return t.addEventListener("message",n=function(t){qa(t,e)},!1),function(){t.removeEventListener("message",n,!1)}},post:function(e,n,a){return"function"==typeof t.addEventListener&&ja(e,n,!1,a)}};function Ha(e){e.updateMessenger($a)}var Ua={};function Ga(e,t,n,a,r){return t={topic:t,message:n,channelId:"".concat(Ba(),":").concat(Ba()),keepalive:a},Va(e,t,r)}function Wa(e,t){var n=e.topic,a=e.message;e=e.keepalive;if(n=Ua[n])try{n(a,e,t)}catch(n){o.log(n),t(n,e)}}function Ya(e,t,n,a){var r,o=e.contentWindow,u=null!=(u=null==(u=t.options)?void 0:u.pingWaitTime)?u:500;o?0===u?Ka(e,t,n,a):(r=setTimeout((function(){r=setTimeout((function(){t.debug?a(Xa("No response from frame",e)):n(null)}),0)}),u),Ga(o,"axe.ping",null,void 0,(function(){clearTimeout(r),Ka(e,t,n,a)}))):(an("Frame does not have a content window",e),n(null))}function Ka(e,t,n,a){var r=null!=(r=null==(r=t.options)?void 0:r.frameWaitTime)?r:6e4,o=e.contentWindow,u=setTimeout((function(){a(Xa("Axe in frame timed out",e))}),r);Ga(o,"axe.start",t,void 0,(function(e){clearTimeout(u),(e instanceof Error==0?n:a)(e)}))}function Xa(e,t){var n;return o._tree&&(n=Hn(t)),new Error(e+": "+(n||t))}Ga.updateMessenger=function(e){var t=e.open;e=e.post,Fn("function"==typeof t,"open callback must be a function"),Fn("function"==typeof e,"post callback must be a function"),za&&za(),t=t(Wa);za=t?(Fn("function"==typeof t,"open callback must return a cleanup function"),t):null,Va=e},Ga.subscribe=function(e,t){Fn("function"==typeof t,"Subscriber callback must be a function"),Fn(!Ua[e],"Topic ".concat(e," is already registered to.")),Ua[e]=t},Ga.isInFrame=function(){return!!(0<arguments.length&&void 0!==arguments[0]?arguments[0]:t).frameElement},Ha(Ga);var Za=function(e){return[].concat(e.any||[]).concat(e.all||[]).concat(e.none||[])},Ja=function(e,t,n){if(Array.isArray(e))return e.find((function(e){return"object"===r(e)&&e[t]===n}))};function Qa(e,t){for(var n=0<arguments.length&&void 0!==e?e:[],a=1<arguments.length&&void 0!==t?t:[],r=Math.max(null==n?void 0:n.length,null==a?void 0:a.length),o=0;o<r;o++){var u=null==n?void 0:n[o],i=null==a?void 0:a[o];if("number"!=typeof u||isNaN(u))return 0===o?1:-1;if("number"!=typeof i||isNaN(i))return 0===o?-1:1;if(u!==i)return u-i}return 0}var er=function(e,t){var n=[];return e.forEach((function(e){var a,r=(r=e)&&r.results?Array.isArray(r.results)?r.results.length?r.results:null:[r.results]:null;r&&r.length&&(a=function(e,t){return e.frameElement?new Jn(e.frameElement,t):e.frameSpec?e.frameSpec:null}(e,t),r.forEach((function(e){e.nodes&&a&&(u=e.nodes,r=t,o=a,u.forEach((function(e){e.node=Jn.fromFrame(e.node,r,o),Za(e).forEach((function(e){e.relatedNodes=e.relatedNodes.map((function(e){return Jn.fromFrame(e,r,o)}))}))})));var r,o,u=Ja(n,"id",e.id);if(u){if(e.nodes.length){for(var i=u.nodes,l=e.nodes,s=l[0].node,c=0;c<i.length;c++){var d=i[c].node,p=Qa(d.nodeIndexes,s.nodeIndexes);if(0<p||0===p&&s.selector.length<d.selector.length)return void i.splice.apply(i,[c,0].concat(H(l)))}i.push.apply(i,H(l))}}else n.push(e)})))})),n.forEach((function(e){e.nodes&&e.nodes.sort((function(e,t){return Qa(e.node.nodeIndexes,t.node.nodeIndexes)}))})),n};function tr(e,t,n,a,r,o){var u=ha();e.frames.forEach((function(e){var r=e.node,o=$(e,i);u.defer((function(e,u){Ya(r,{options:t,command:n,parameter:a,context:o},(function(t){return e(t?{results:t,frameElement:r}:null)}),u)}))})),u.then((function(e){r(er(e,t))})).catch(o)}function nr(e,t){if(!e.shadowId&&!t.shadowId&&e.actualNode&&"function"==typeof e.actualNode.contains)return e.actualNode.contains(t.actualNode);do{if(e===t)return!0;if(t.nodeIndex<e.nodeIndex)return!1}while(t=t.parent);return!1}var ar=function e(){for(var t={},n=arguments.length,a=new Array(n),o=0;o<n;o++)a[o]=arguments[o];return a.forEach((function(n){if(n&&"object"===r(n)&&!Array.isArray(n))for(var a=0,o=Object.keys(n);a<o.length;a++){var u=o[a];!t.hasOwnProperty(u)||"object"!==r(n[u])||Array.isArray(t[u])?t[u]=n[u]:t[u]=e(t[u],n[u])}})),t},rr=function(e,t){Object.assign(e,t),Object.keys(t).filter((function(e){return"function"==typeof t[e]})).forEach((function(n){e[n]=null;try{e[n]=t[n](e)}catch(n){}}))},or=["article","aside","blockquote","body","div","footer","h1","h2","h3","h4","h5","h6","header","main","nav","p","section","span"],ur=function(e){return!!(e.shadowRoot&&(e=e.nodeName.toLowerCase(),or.includes(e)||/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(e)))},ir={},lr=(re(ir,{createGrid:function(){return Kr},findElmsInContext:function(){return cr},findNearbyElms:function(){return no},findUp:function(){return pr},findUpVirtual:function(){return dr},focusDisabled:function(){return co},getComposedParent:function(){return Mr},getElementByReference:function(){return mo},getElementCoordinates:function(){return Ir},getElementStack:function(){return Ao},getModalDialog:function(){return oo},getOverflowHiddenAncestors:function(){return gr},getRootNode:function(){return sr},getScrollOffset:function(){return Pr},getTabbableElements:function(){return ko},getTextElementStack:function(){return fi},getViewportSize:function(){return jr},getVisibleChildTextRects:function(){return pi},hasContent:function(){return vi},hasContentVirtual:function(){return bi},hasLangText:function(){return yi},idrefs:function(){return To},insertedIntoFocusOrder:function(){return Fi},isCurrentPageLink:function(){return Do},isFocusable:function(){return Jo},isHTML5:function(){return xi},isHiddenForEveryone:function(){return _r},isHiddenWithCSS:function(){return Ci},isInTabOrder:function(){return Ai},isInTextBlock:function(){return Ni},isInert:function(){return uo},isModalOpen:function(){return Ri},isMultiline:function(){return _i},isNativelyFocusable:function(){return Zo},isNode:function(){return Oi},isOffscreen:function(){return Lr},isOpaque:function(){return kc},isSkipLink:function(){return Bc},isVisible:function(){return _c},isVisibleOnScreen:function(){return zr},isVisibleToScreenReaders:function(){return Mu},isVisualContent:function(){return mi},reduceToElementsBelowFloating:function(){return Oc},shadowElementsFromPoint:function(){return jc},urlPropsFromAttribute:function(){return Lc},visuallyContains:function(){return Sc},visuallyOverlaps:function(){return qc},visuallySort:function(){return ho}}),function(e){var t=e.getRootNode&&e.getRootNode()||a;return t===e?a:t}),sr=lr,cr=function(e){var t=e.context,n=e.value,a=e.attr;e=void 0===(e=e.elm)?"":e,n=En(n),t=9===t.nodeType||11===t.nodeType?t:sr(t);return Array.from(t.querySelectorAll(e+"["+a+"="+n+"]"))},dr=function(e,t){var n=e.actualNode;if(!e.shadowId&&"function"==typeof e.actualNode.closest)return e.actualNode.closest(t)||null;for(;(n=(n=n.assignedSlot||n.parentNode)&&11===n.nodeType?n.host:n)&&!Nn(n,t)&&n!==a.documentElement;);return n&&Nn(n,t)?n:null},pr=function(e,t){return dr(Xn(e),t)},fr=oe(Xt()),Dr=(o._memoizedFns=[],function(e){return e=(0,fr.default)(e),o._memoizedFns.push(e),e});function mr(e,t){return(0|e.left)<(0|t.right)&&(0|e.right)>(0|t.left)&&(0|e.top)<(0|t.bottom)&&(0|e.bottom)>(0|t.top)}var hr=Dr((function(e){var t=[];return e?("hidden"===e.getComputedStylePropertyValue("overflow")&&t.push(e),t.concat(hr(e.parent))):t})),gr=hr,br=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,vr=/(\\w+)\\((\\d+)/;function yr(e){return["style","script","noscript","template"].includes(e.props.nodeName)}function Fr(e){return"area"!==e.props.nodeName&&"none"===e.getComputedStylePropertyValue("display")}function wr(e){return!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&["hidden","collapse"].includes(e.getComputedStylePropertyValue("visibility"))}function Er(e){return!!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&"hidden"===e.getComputedStylePropertyValue("content-visibility")}function Cr(e){return"true"===e.attr("aria-hidden")}function xr(e){return"0"===e.getComputedStylePropertyValue("opacity")}function Ar(e){var t=xd(e.actualNode),n=parseInt(e.getComputedStylePropertyValue("height"));e=parseInt(e.getComputedStylePropertyValue("width"));return!!t&&(0===n||0===e)}function kr(e){var t,n;return!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&(t=e.boundingClientRect,!!(n=gr(e)).length)&&n.some((function(e){return(e=e.boundingClientRect).width<2||e.height<2||!mr(t,e)}))}function Br(e){var t=e.getComputedStylePropertyValue("clip").match(br),n=e.getComputedStylePropertyValue("clip-path").match(vr);if(t&&5===t.length&&(e=e.getComputedStylePropertyValue("position"),["fixed","absolute"].includes(e)))return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(n){e=n[1];var a=parseInt(n[2],10);switch(e){case"inset":return 50<=a;case"circle":return 0===a}}return!1}function Tr(e,t){var n,a=ca(e,"map");return!a||!((a=a.attr("name"))&&(e=lr(e.actualNode))&&9===e.nodeType&&(n=cp(o._tree,\'img[usemap="#\'.concat(En(a),\'"]\')))&&n.length)||n.some((function(e){return!t(e)}))}function Nr(e){var t;return"details"===(null==(t=e.parent)?void 0:t.props.nodeName)&&(("summary"!==e.props.nodeName||e.parent.children.find((function(e){return"summary"===e.props.nodeName}))!==e)&&!e.parent.hasAttr("open"))}var Rr=[Fr,wr,Er,Nr];function _r(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).skipAncestors,n=void 0!==(n=n.isAncestor)&&n;return e=jd(e).vNode,(t?Or:Sr)(e,n)}var Or=Dr((function(e,t){return!!yr(e)||!(!e.actualNode||!Rr.some((function(n){return n(e,{isAncestor:t})}))&&e.actualNode.isConnected)})),Sr=Dr((function(e,t){return!!Or(e,t)||!!e.parent&&Sr(e.parent,!0)})),Mr=function e(t){if(t.assignedSlot)return e(t.assignedSlot);if(t.parentNode){if(1===(t=t.parentNode).nodeType)return t;if(t.host)return t.host}return null},Pr=function(e){var t,n;return 9===(e=!e.nodeType&&e.document?e.document:e).nodeType?(t=e.documentElement,n=e.body,{left:t&&t.scrollLeft||n&&n.scrollLeft||0,top:t&&t.scrollTop||n&&n.scrollTop||0}):{left:e.scrollLeft,top:e.scrollTop}},Ir=function(e){var t=(n=Pr(a)).left,n=n.top;return{top:(e=e.getBoundingClientRect()).top+n,right:e.right+t,bottom:e.bottom+n,left:e.left+t,width:e.right-e.left,height:e.bottom-e.top}},jr=function(e){var t=e.document,n=t.documentElement;return e.innerWidth?{width:e.innerWidth,height:e.innerHeight}:n?{width:n.clientWidth,height:n.clientHeight}:{width:(e=t.body).clientWidth,height:e.clientHeight}},Lr=function(e){if((1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor)return!1;var n=jd(e).domNode;if(n){var r=a.documentElement,o=t.getComputedStyle(n),u=t.getComputedStyle(a.body||r).getPropertyValue("direction"),i=Ir(n);if(i.bottom<0&&(function(e,t){for(e=Mr(e);e&&"html"!==e.nodeName.toLowerCase();){if(e.scrollTop&&0<=(t+=e.scrollTop))return;e=Mr(e)}return 1}(n,i.bottom)||"absolute"===o.position))return!0;if(0!==i.left||0!==i.right)if("ltr"===u){if(i.right<=0)return!0}else if(n=Math.max(r.scrollWidth,jr(t).width),i.left>=n)return!0;return!1}},qr=[xr,Ar,kr,Br,Lr];function zr(e){return e=jd(e).vNode,Vr(e)}var Vr=Dr((function(e,t){return e.actualNode&&"area"===e.props.nodeName?!Tr(e,Vr):!(_r(e,{skipAncestors:!0,isAncestor:t})||e.actualNode&&qr.some((function(n){return n(e,{isAncestor:t})})))&&(!e.parent||Vr(e.parent,!0))}));function $r(e,n){var a=Math.min(e.top,n.top),r=Math.max(e.right,n.right),o=Math.max(e.bottom,n.bottom);e=Math.min(e.left,n.left);return new t.DOMRect(e,a,r-e,o-a)}function Hr(e,t){var n=e.x,a=(e=e.y,t.top),r=t.right,o=t.bottom;t=t.left;return a<=e&&n<=r&&e<=o&&t<=n}var Ur=0,Gr=.2,Wr=.3,Yr=0;function Kr(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:a.body,n=1<arguments.length?arguments[1]:void 0,r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!Kn.get("gridCreated")||r){Kn.set("gridCreated",!0),r||(i=(i=Xn(a.documentElement))||new Hc(a.documentElement),Yr=0,i._stackingOrder=[Zr(Ur,null)],Jr(n=null!=n?n:new Qr,i),xd(i.actualNode)&&(u=new Qr(i),i._subGrid=u));for(var u,i,l=a.createTreeWalker(e,t.NodeFilter.SHOW_ELEMENT,null,!1),s=r?l.nextNode():l.currentNode;s;){var c=Xn(s),d=(d=(c&&c.parent?r=c.parent:s.assignedSlot?r=Xn(s.assignedSlot):s.parentElement?r=Xn(s.parentElement):s.parentNode&&Xn(s.parentNode)&&(r=Xn(s.parentNode)),(c=c||new o.VirtualNode(s,r))._stackingOrder=function(e,t,n){var a=t._stackingOrder.slice();if(function(e,t){var n=e.getComputedStylePropertyValue("position"),a=e.getComputedStylePropertyValue("z-index");return"fixed"===n||"sticky"===n||"auto"!==a&&"static"!==n||"1"!==e.getComputedStylePropertyValue("opacity")||"none"!==(e.getComputedStylePropertyValue("-webkit-transform")||e.getComputedStylePropertyValue("-ms-transform")||e.getComputedStylePropertyValue("transform")||"none")||(n=e.getComputedStylePropertyValue("mix-blend-mode"))&&"normal"!==n||(n=e.getComputedStylePropertyValue("filter"))&&"none"!==n||(n=e.getComputedStylePropertyValue("perspective"))&&"none"!==n||(n=e.getComputedStylePropertyValue("clip-path"))&&"none"!==n||"none"!==(e.getComputedStylePropertyValue("-webkit-mask")||e.getComputedStylePropertyValue("mask")||"none")||"none"!==(e.getComputedStylePropertyValue("-webkit-mask-image")||e.getComputedStylePropertyValue("mask-image")||"none")||"none"!==(e.getComputedStylePropertyValue("-webkit-mask-border")||e.getComputedStylePropertyValue("mask-border")||"none")||"isolate"===e.getComputedStylePropertyValue("isolation")||"transform"===(n=e.getComputedStylePropertyValue("will-change"))||"opacity"===n||"touch"===e.getComputedStylePropertyValue("-webkit-overflow-scrolling")?1:(n=e.getComputedStylePropertyValue("contain"),["layout","paint","strict","content"].includes(n)||"auto"!==a&&Xr(t)?1:void 0)}(e,t)){var r=(-1!==(r=a.findIndex((function(e){return e=e.value,[Ur,Gr,Wr].includes(e)})))&&a.splice(r,a.length-r),function(e,t){return"static"!==e.getComputedStylePropertyValue("position")||Xr(t)?e.getComputedStylePropertyValue("z-index"):"auto"}(e,t));if(["auto","0"].includes(r)){for(var o=n.toString();o.length<10;)o="0"+o;a.push(Zr(parseFloat("".concat(.1).concat(o)),e))}else a.push(Zr(parseInt(r),e))}else"static"!==e.getComputedStylePropertyValue("position")?a.push(Zr(Wr,e)):"none"!==e.getComputedStylePropertyValue("float")&&a.push(Zr(Gr,e));return a}(c,r,Yr++),function(e,t){for(var n=null,a=[e];t;){if(xd(t.actualNode)){n=t;break}if(t._scrollRegionParent){n=t._scrollRegionParent;break}a.push(t),t=Xn(t.actualNode.parentElement||t.actualNode.parentNode)}return a.forEach((function(e){return e._scrollRegionParent=n})),n}(c,r)))?d._subGrid:n,p=(xd(c.actualNode)&&(p=new Qr(c),c._subGrid=p),c.boundingClientRect);0!==p.width&&0!==p.height&&zr(s)&&Jr(d,c),ur(s)&&Kr(s.shadowRoot,d,c),s=l.nextNode()}}return nn.gridSize}function Xr(e){if(e)return e=e.getComputedStylePropertyValue("display"),["flex","inline-flex","grid","inline-grid"].includes(e)}function Zr(e,t){return{value:e,vNode:t}}function Jr(e,t){t.clientRects.forEach((function(n){null==t._grid&&(t._grid=e),n=e.getGridPositionOfRect(n),e.loopGridPosition(n,(function(e){e.includes(t)||e.push(t)}))}))}J(eo,[{key:"toGridIndex",value:function(e){return Math.floor(e/nn.gridSize)}},{key:"getCellFromPoint",value:function(e){var t=e.x;e=e.y,Fn(this.boundaries,"Grid does not have cells added"),e=this.toGridIndex(e),t=this.toGridIndex(t);return null!=(t=(e=(Fn(Hr({y:e,x:t},this.boundaries),"Element midpoint exceeds the grid bounds"),null!=(e=this.cells[e-this.cells._negativeIndex])?e:[]))[t-e._negativeIndex])?t:[]}},{key:"loopGridPosition",value:function(e,t){var n=(o=e).left,a=o.right,r=o.top,o=o.bottom;this.boundaries&&(e=$r(this.boundaries,e)),this.boundaries=e,to(this.cells,r,o,(function(e,r){to(e,n,a,(function(e,n){t(e,{row:r,col:n})}))}))}},{key:"getGridPositionOfRect",value:function(e){var n=e.top,a=e.right,r=e.bottom,o=e.left,u=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;n=this.toGridIndex(n-u),a=this.toGridIndex(a+u-1),r=this.toGridIndex(r+u-1),o=this.toGridIndex(o-u);return new t.DOMRect(o,n,a-o,r-n)}}]);var Qr=eo;function eo(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;X(this,eo),this.container=e,this.cells=[]}function to(e,t,n,a){if(null!=e._negativeIndex||(e._negativeIndex=0),t<e._negativeIndex){for(var r=0;r<e._negativeIndex-t;r++)e.splice(0,0,[]);e._negativeIndex=t}for(var o,u=t-e._negativeIndex,i=n-e._negativeIndex,l=u;l<=i;l++)null==e[o=l]&&(e[o]=[]),a(e[l],l+e._negativeIndex)}function no(e){var t,n,a,r,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;return Kr(),null!=(a=e._grid)&&null!=(a=a.cells)&&a.length?(a=e.boundingClientRect,t=e._grid,n=ao(e),a=t.getGridPositionOfRect(a,o),r=[],t.loopGridPosition(a,(function(t){var a,o=ee(t);try{for(o.s();!(a=o.n()).done;){var u=a.value;u&&u!==e&&!r.includes(u)&&n===ao(u)&&r.push(u)}}catch(t){o.e(t)}finally{o.f()}})),r):[]}var ao=Dr((function(e){return!!e&&("fixed"===e.getComputedStylePropertyValue("position")||ao(e.parent))}));function ro(e,n){var a=Math.max(e.left,n.left),r=Math.min(e.right,n.right),o=Math.max(e.top,n.top);e=Math.min(e.bottom,n.bottom);return r<=a||e<=o?null:new t.DOMRect(a,o,r-a,e-o)}var oo=Dr((function(){var e;return o._tree&&(e=ep(o._tree[0],"dialog[open]",(function(e){var t=e.boundingClientRect;return a.elementsFromPoint(t.left+1,t.top+1).includes(e.actualNode)&&zr(e)}))).length?e.find((function(e){var t=e.boundingClientRect;return a.elementsFromPoint(t.left-10,t.top-10).includes(e.actualNode)}))||(null!=(e=e.find((function(e){var n=(e=null!=(e=function(e){Kr();var n=o._tree[0]._grid,a=new t.DOMRect(0,0,t.innerWidth,t.innerHeight);if(n)for(var r=0;r<n.cells.length;r++){var u=n.cells[r];if(u)for(var i=0;i<u.length;i++){var l=u[i];if(l)for(var s=0;s<l.length;s++){var c=l[s],d=ro(c.boundingClientRect,a);if("html"!==c.props.nodeName&&c!==e&&"none"!==c.getComputedStylePropertyValue("pointer-events")&&d)return{vNode:c,rect:d}}}}}(e))?e:{}).vNode;e=e.rect;return!!n&&!a.elementsFromPoint(e.left+1,e.top+1).includes(n.actualNode)})))?e:null):null}));function uo(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).skipAncestors,n=n.isAncestor;return(t?io:lo)(e,n)}var io=Dr((function(e,t){return!!e.hasAttr("inert")||!(t||!e.actualNode||!(t=oo())||nr(t,e))})),lo=Dr((function(e,t){return!!io(e,t)||!!e.parent&&lo(e.parent,!0)})),so=["button","command","fieldset","keygen","optgroup","option","select","textarea","input"],co=function(e){var t=jd(e).vNode;if(e=t.props.nodeName,so.includes(e)&&t.hasAttr("disabled")||uo(t))return!0;for(var n=t.parent,a=[],r=!1;n&&n.shadowId===t.shadowId&&!r&&(a.push(n),"legend"!==n.props.nodeName);){if(void 0!==n._inDisabledFieldset){r=n._inDisabledFieldset;break}"fieldset"===n.props.nodeName&&n.hasAttr("disabled")&&(r=!0),n=n.parent}return a.forEach((function(e){return e._inDisabledFieldset=r})),!!r||"area"!==t.props.nodeName&&!!t.actualNode&&_r(t)},po=/^\\/\\#/,fo=/^#[!/]/;function Do(e){var n,a,r,o,u=e.getAttribute("href");return!(!u||"#"===u)&&(!!po.test(u)||(o=e.hash,n=e.protocol,a=e.hostname,r=e.port,e=e.pathname,!fo.test(o)&&("#"===u.charAt(0)||("string"!=typeof(null==(o=t.location)?void 0:o.origin)||-1===t.location.origin.indexOf("://")?null:(u=t.location.origin+t.location.pathname,o=a?"".concat(n,"//").concat(a).concat(r?":".concat(r):""):t.location.origin,(o+=e?("/"!==e[0]?"/":"")+e:t.location.pathname)===u)))))}var mo=function(e,t){var n=e.getAttribute(t);return n&&("href"!==t||Do(e))?(-1!==n.indexOf("#")&&(n=decodeURIComponent(n.substr(n.indexOf("#")+1))),(t=a.getElementById(n))||((t=a.getElementsByName(n)).length?t[0]:null)):null};function ho(e,n){Kr();for(var a=Math.max(e._stackingOrder.length,n._stackingOrder.length),r=0;r<a;r++){if(void 0===n._stackingOrder[r])return-1;if(void 0===e._stackingOrder[r])return 1;if(n._stackingOrder[r].value>e._stackingOrder[r].value)return 1;if(n._stackingOrder[r].value<e._stackingOrder[r].value)return-1}var o=e.actualNode,u=n.actualNode;if(o.getRootNode&&o.getRootNode()!==u.getRootNode()){for(var i=[];o;)i.push({root:o.getRootNode(),node:o}),o=o.getRootNode().host;for(;u&&!i.find((function(e){return e.root===u.getRootNode()}));)u=u.getRootNode().host;if((o=i.find((function(e){return e.root===u.getRootNode()})).node)===u)return e.actualNode.getRootNode()!==o.getRootNode()?-1:1}var l,s=(d=t.Node).DOCUMENT_POSITION_FOLLOWING,c=d.DOCUMENT_POSITION_CONTAINS,d=d.DOCUMENT_POSITION_CONTAINED_BY;s=(l=o.compareDocumentPosition(u))&s?1:-1,c=l&c||l&d;return(l=go(e))===(d=go(n))||c?s:d-l}function go(e){return-1!==e.getComputedStylePropertyValue("display").indexOf("inline")?2:function e(t){if(!t)return!1;if(void 0!==t._isFloated)return t._isFloated;var n=t.getComputedStylePropertyValue("float");return"none"!==n?t._isFloated=!0:(n=e(t.parent),t._isFloated=n,n)}(e)?1:0}var bo={};function vo(e,t){e=e.boundingClientRect,t=t.boundingClientRect;var n,a,r,o=(n=e,a=t,r={},[["x","left","right","width"],["y","top","bottom","height"]].forEach((function(e){var t,o=(e=W(e,4))[0],u=e[1],i=e[2];e=e[3];a[u]<n[u]&&a[i]>n[i]?r[o]=n[u]+n[e]/2:(e=a[u]+a[e]/2,t=Math.abs(e-n[u]),e=Math.abs(e-n[i]),r[o]=e<=t?n[u]:n[i])})),r);e=function(e,t,n){var a=e.x;if(function(e,t){var n=e.x;return(e=e.y)>=t.top&&n<=t.right&&e<=t.bottom&&n>=t.left}({x:a,y:e=e.y},n)){if(null!==(i=function(e,t,n){var a,r,o=e.x;e=e.y;return o===t.left&&t.right<n.right?a=t.right:o===t.right&&t.left>n.left&&(a=t.left),e===t.top&&t.bottom<n.bottom?r=t.bottom:e===t.bottom&&t.top>n.top&&(r=t.top),a||r?r?a&&Math.abs(o-a)<Math.abs(e-r)?{x:a,y:e}:{x:o,y:r}:{x:a,y:e}:null}({x:a,y:e},t,n)))return i;n=t}t=(i=n).top,n=i.right;var r=i.bottom,o=(i=i.left)<=a&&a<=n,u=t<=e&&e<=r,i=Math.abs(i-a)<Math.abs(n-a)?i:n;n=Math.abs(t-e)<Math.abs(r-e)?t:r;return!o&&u?{x:i,y:e}:o&&!u?{x:a,y:n}:o||u?Math.abs(a-i)<Math.abs(e-n)?{x:i,y:e}:{x:a,y:n}:{x:i,y:n}}(o,e,t);return t=o,o=e,e=Math.abs(t.x-o.x),t=Math.abs(t.y-o.y),e&&t?Math.sqrt(Math.pow(e,2)+Math.pow(t,2)):e||t}function yo(e){var n=e.left,a=e.top,r=e.width;e=e.height;return new t.DOMPoint(n+r/2,a+e/2)}function Fo(e,t){var n=e.boundingClientRect,a=t.boundingClientRect;return!(n.left>=a.right||n.right<=a.left||n.top>=a.bottom||n.bottom<=a.top)&&0<ho(e,t)}function wo(e,t){var n,a=[e],r=ee(t);try{function o(){var e=n.value;a=a.reduce((function(t,n){return t.concat(function(e,t){var n=e.top,a=e.left,r=e.bottom,o=e.right,u=n<t.bottom&&r>t.top,i=a<t.right&&o>t.left,l=[];return Eo(t.top,n,r)&&i&&l.push({top:n,left:a,bottom:t.top,right:o}),Eo(t.right,a,o)&&u&&l.push({top:n,left:t.right,bottom:r,right:o}),Eo(t.bottom,n,r)&&i&&l.push({top:t.bottom,right:o,bottom:r,left:a}),Eo(t.left,a,o)&&u&&l.push({top:n,left:a,bottom:r,right:t.left}),0===l.length&&l.push(e),l.map(Co)}(n,e))}),[])}for(r.s();!(n=r.n()).done;)o()}catch(e){r.e(e)}finally{r.f()}return a}re(bo,{getBoundingRect:function(){return $r},getIntersectionRect:function(){return ro},getOffset:function(){return vo},getRectCenter:function(){return yo},hasVisualOverlap:function(){return Fo},isPointInRect:function(){return Hr},rectsOverlap:function(){return mr},splitRects:function(){return wo}});var Eo=function(e,t,n){return t<e&&e<n};function Co(e){return G({},e,{x:e.left,y:e.top,height:e.bottom-e.top,width:e.right-e.left})}function xo(e,t,n){var r=2<arguments.length&&void 0!==n&&n,o=yo(t),u=e.getCellFromPoint(o)||[],i=Math.floor(o.x),l=Math.floor(o.y);o=u.filter((function(e){return e.clientRects.some((function(e){var t=e.left,n=e.top;return i<Math.floor(t+e.width)&&i>=Math.floor(t)&&l<Math.floor(n+e.height)&&l>=Math.floor(n)}))}));return(u=e.container)&&(o=xo(u._grid,u.boundingClientRect,!0).concat(o)),r?o:o.sort(ho).map((function(e){return e.actualNode})).concat(a.documentElement).filter((function(e,t,n){return n.indexOf(e)===t}))}var Ao=function(e){Kr();var t=(e=Xn(e))._grid;return t?xo(t,e.boundingClientRect):[]},ko=function(e){return cp(e,"*").filter((function(e){var t=e.isFocusable;return(e=(e=e.actualNode.getAttribute("tabindex"))&&!isNaN(parseInt(e,10))?parseInt(e):null)?t&&0<=e:t}))},Bo={},To=(re(Bo,{accessibleText:function(){return No},accessibleTextVirtual:function(){return ti},autocomplete:function(){return ri},formControlValue:function(){return Ku},formControlValueMethods:function(){return Wu},hasUnicode:function(){return Zu},isHumanInterpretable:function(){return ai},isIconLigature:function(){return Ju},isValidAutocomplete:function(){return oi},label:function(){return si},labelText:function(){return Bu},labelVirtual:function(){return li},nativeElementType:function(){return ci},nativeTextAlternative:function(){return Ou},nativeTextMethods:function(){return _u},removeUnicode:function(){return ni},sanitize:function(){return Xo},subtreeText:function(){return ku},titleText:function(){return Eu},unsupported:function(){return Su},visible:function(){return ii},visibleTextNodes:function(){return di},visibleVirtual:function(){return Iu}}),function(e,t){e=e.actualNode||e;try{var n=sr(e),a=[];if(r=e.getAttribute(t))for(var r=Uc(r),o=0;o<r.length;o++)a.push(n.getElementById(r[o]));return a}catch(e){throw new TypeError("Cannot resolve id references for non-DOM nodes")}}),No=function(e,t){return e=Xn(e),ti(e,t)},Ro=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=jd(e).vNode;return 1!==(null==n?void 0:n.props.nodeType)||1!==n.props.nodeType||t.inLabelledByContext||t.inControlContext||!n.attr("aria-labelledby")?"":To(n,"aria-labelledby").filter((function(e){return e})).reduce((function(e,a){return a=No(a,G({inLabelledByContext:!0,startNode:t.startNode||n},t)),e?"".concat(e," ").concat(a):a}),"")};function _o(e){return 1===(null==(e=jd(e).vNode)?void 0:e.props.nodeType)&&e.attr("aria-label")||""}var Oo={"aria-activedescendant":{type:"idref",allowEmpty:!0},"aria-atomic":{type:"boolean",global:!0},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"]},"aria-braillelabel":{type:"string",global:!0},"aria-brailleroledescription":{type:"string",global:!0},"aria-busy":{type:"boolean",global:!0},"aria-checked":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-colcount":{type:"int",minValue:-1},"aria-colindex":{type:"int",minValue:1},"aria-colspan":{type:"int",minValue:1},"aria-controls":{type:"idrefs",allowEmpty:!0,global:!0},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],global:!0},"aria-describedby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-description":{type:"string",allowEmpty:!0,global:!0},"aria-details":{type:"idref",allowEmpty:!0,global:!0},"aria-disabled":{type:"boolean",global:!0},"aria-dropeffect":{type:"nmtokens",values:["copy","execute","link","move","none","popup"],global:!0},"aria-errormessage":{type:"idref",allowEmpty:!0,global:!0},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"]},"aria-flowto":{type:"idrefs",allowEmpty:!0,global:!0},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],global:!0},"aria-hidden":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-invalid":{type:"nmtoken",values:["grammar","false","spelling","true"],global:!0},"aria-keyshortcuts":{type:"string",allowEmpty:!0,global:!0},"aria-label":{type:"string",allowEmpty:!0,global:!0},"aria-labelledby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-level":{type:"int",minValue:1},"aria-live":{type:"nmtoken",values:["assertive","off","polite"],global:!0},"aria-modal":{type:"boolean"},"aria-multiline":{type:"boolean"},"aria-multiselectable":{type:"boolean"},"aria-orientation":{type:"nmtoken",values:["horizontal","undefined","vertical"]},"aria-owns":{type:"idrefs",allowEmpty:!0,global:!0},"aria-placeholder":{type:"string",allowEmpty:!0},"aria-posinset":{type:"int",minValue:1},"aria-pressed":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-readonly":{type:"boolean"},"aria-relevant":{type:"nmtokens",values:["additions","all","removals","text"],global:!0},"aria-required":{type:"boolean"},"aria-roledescription":{type:"string",allowEmpty:!0,global:!0},"aria-rowcount":{type:"int",minValue:-1},"aria-rowindex":{type:"int",minValue:1},"aria-rowspan":{type:"int",minValue:0},"aria-selected":{type:"nmtoken",values:["false","true","undefined"]},"aria-setsize":{type:"int",minValue:-1},"aria-sort":{type:"nmtoken",values:["ascending","descending","none","other"]},"aria-valuemax":{type:"decimal"},"aria-valuemin":{type:"decimal"},"aria-valuenow":{type:"decimal"},"aria-valuetext":{type:"string"}},So={alert:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},alertdialog:{type:"widget",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["alert","dialog"],accessibleNameRequired:!0},application:{type:"landmark",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["structure"],accessibleNameRequired:!0},article:{type:"structure",allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["document"]},banner:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},blockquote:{type:"structure",superclassRole:["section"]},button:{type:"widget",allowedAttrs:["aria-expanded","aria-pressed"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},caption:{type:"structure",requiredContext:["figure","table","grid","treegrid"],superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},cell:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-expanded"],superclassRole:["section"],nameFromContent:!0},checkbox:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-readonly","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},code:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},columnheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},combobox:{type:"widget",requiredAttrs:["aria-expanded","aria-controls"],allowedAttrs:["aria-owns","aria-autocomplete","aria-readonly","aria-required","aria-activedescendant","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},command:{type:"abstract",superclassRole:["widget"]},complementary:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},composite:{type:"abstract",superclassRole:["widget"]},contentinfo:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},comment:{type:"structure",allowedAttrs:["aria-level","aria-posinset","aria-setsize"],superclassRole:["article"]},definition:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},deletion:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},dialog:{type:"widget",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["window"],accessibleNameRequired:!0},directory:{type:"structure",deprecated:!0,allowedAttrs:["aria-expanded"],superclassRole:["list"],nameFromContent:!0},document:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["structure"]},emphasis:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},feed:{type:"structure",requiredOwned:["article"],allowedAttrs:["aria-expanded"],superclassRole:["list"]},figure:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},form:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},grid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-level","aria-multiselectable","aria-readonly","aria-activedescendant","aria-colcount","aria-expanded","aria-rowcount"],superclassRole:["composite","table"],accessibleNameRequired:!1},gridcell:{type:"widget",requiredContext:["row"],allowedAttrs:["aria-readonly","aria-required","aria-selected","aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan"],superclassRole:["cell","widget"],nameFromContent:!0},group:{type:"structure",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["section"]},heading:{type:"structure",requiredAttrs:["aria-level"],allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},img:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!0,childrenPresentational:!0},input:{type:"abstract",superclassRole:["widget"]},insertion:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},landmark:{type:"abstract",superclassRole:["section"]},link:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},list:{type:"structure",requiredOwned:["listitem"],allowedAttrs:["aria-expanded"],superclassRole:["section"]},listbox:{type:"widget",requiredOwned:["group","option"],allowedAttrs:["aria-multiselectable","aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},listitem:{type:"structure",requiredContext:["list"],allowedAttrs:["aria-level","aria-posinset","aria-setsize","aria-expanded"],superclassRole:["section"],nameFromContent:!0},log:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},main:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},marquee:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},math:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],childrenPresentational:!0},menu:{type:"composite",requiredOwned:["group","menuitemradio","menuitem","menuitemcheckbox","menu","separator"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"]},menubar:{type:"composite",requiredOwned:["group","menuitemradio","menuitem","menuitemcheckbox","menu","separator"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["menu"]},menuitem:{type:"widget",requiredContext:["menu","menubar","group"],allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},menuitemcheckbox:{type:"widget",requiredContext:["menu","menubar","group"],requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["checkbox","menuitem"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},menuitemradio:{type:"widget",requiredContext:["menu","menubar","group"],requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["menuitemcheckbox","radio"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},meter:{type:"structure",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"],accessibleNameRequired:!0,childrenPresentational:!0},mark:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},navigation:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},none:{type:"structure",superclassRole:["structure"],prohibitedAttrs:["aria-label","aria-labelledby"]},note:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},option:{type:"widget",requiredContext:["group","listbox"],allowedAttrs:["aria-selected","aria-checked","aria-posinset","aria-setsize"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},paragraph:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},presentation:{type:"structure",superclassRole:["structure"],prohibitedAttrs:["aria-label","aria-labelledby"]},progressbar:{type:"widget",allowedAttrs:["aria-expanded","aria-valuemax","aria-valuemin","aria-valuenow","aria-valuetext"],superclassRole:["range"],accessibleNameRequired:!0,childrenPresentational:!0},radio:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-posinset","aria-setsize","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},radiogroup:{type:"composite",allowedAttrs:["aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},range:{type:"abstract",superclassRole:["widget"]},region:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"],accessibleNameRequired:!1},roletype:{type:"abstract",superclassRole:[]},row:{type:"structure",requiredContext:["grid","rowgroup","table","treegrid"],requiredOwned:["cell","columnheader","gridcell","rowheader"],allowedAttrs:["aria-colindex","aria-level","aria-rowindex","aria-selected","aria-activedescendant","aria-expanded","aria-posinset","aria-setsize"],superclassRole:["group","widget"],nameFromContent:!0},rowgroup:{type:"structure",requiredContext:["grid","table","treegrid"],requiredOwned:["row"],superclassRole:["structure"],nameFromContent:!0},rowheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},scrollbar:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-controls","aria-orientation","aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"],childrenPresentational:!0},search:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},searchbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["textbox"],accessibleNameRequired:!0},section:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},sectionhead:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},select:{type:"abstract",superclassRole:["composite","group"]},separator:{type:"structure",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-orientation","aria-valuetext"],superclassRole:["structure","widget"],childrenPresentational:!0},slider:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-orientation","aria-readonly","aria-required","aria-valuetext"],superclassRole:["input","range"],accessibleNameRequired:!0,childrenPresentational:!0},spinbutton:{type:"widget",allowedAttrs:["aria-valuemax","aria-valuemin","aria-readonly","aria-required","aria-activedescendant","aria-valuetext","aria-valuenow"],superclassRole:["composite","input","range"],accessibleNameRequired:!0},status:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},strong:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},structure:{type:"abstract",superclassRole:["roletype"]},subscript:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},superscript:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},switch:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-readonly","aria-required"],superclassRole:["checkbox"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},suggestion:{type:"structure",requiredOwned:["insertion","deletion"],superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},tab:{type:"widget",requiredContext:["tablist"],allowedAttrs:["aria-posinset","aria-selected","aria-setsize","aria-expanded"],superclassRole:["sectionhead","widget"],nameFromContent:!0,childrenPresentational:!0},table:{type:"structure",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-colcount","aria-rowcount","aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1,nameFromContent:!0},tablist:{type:"composite",requiredOwned:["tab"],allowedAttrs:["aria-level","aria-multiselectable","aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["composite"]},tabpanel:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1},term:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},text:{type:"structure",superclassRole:["section"],nameFromContent:!0},textbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["input"],accessibleNameRequired:!0},time:{type:"structure",superclassRole:["section"]},timer:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["status"]},toolbar:{type:"structure",allowedAttrs:["aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["group"],accessibleNameRequired:!0},tooltip:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},tree:{type:"composite",requiredOwned:["group","treeitem"],allowedAttrs:["aria-multiselectable","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},treegrid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-readonly","aria-required","aria-rowcount"],superclassRole:["grid","tree"],accessibleNameRequired:!1},treeitem:{type:"widget",requiredContext:["group","tree"],allowedAttrs:["aria-checked","aria-expanded","aria-level","aria-posinset","aria-selected","aria-setsize"],superclassRole:["listitem","option"],accessibleNameRequired:!0,nameFromContent:!0},widget:{type:"abstract",superclassRole:["roletype"]},window:{type:"abstract",superclassRole:["roletype"]}},Mo={a:{variant:{href:{matches:"[href]",contentTypes:["interactive","phrasing","flow"],allowedRoles:["button","checkbox","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab","treeitem","doc-backlink","doc-biblioref","doc-glossref","doc-noteref"],namingMethods:["subtreeText"]},default:{contentTypes:["phrasing","flow"],allowedRoles:!0}}},abbr:{contentTypes:["phrasing","flow"],allowedRoles:!0},address:{contentTypes:["flow"],allowedRoles:!0},area:{variant:{href:{matches:"[href]",allowedRoles:!1},default:{allowedRoles:["button","link"]}},contentTypes:["phrasing","flow"],namingMethods:["altText"]},article:{contentTypes:["sectioning","flow"],allowedRoles:["feed","presentation","none","document","application","main","region"],shadowRoot:!0},aside:{contentTypes:["sectioning","flow"],allowedRoles:["feed","note","presentation","none","region","search","doc-dedication","doc-example","doc-footnote","doc-pullquote","doc-tip"]},audio:{variant:{controls:{matches:"[controls]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"],chromiumRole:"Audio"},b:{contentTypes:["phrasing","flow"],allowedRoles:!0},base:{allowedRoles:!1,noAriaAttrs:!0},bdi:{contentTypes:["phrasing","flow"],allowedRoles:!0},bdo:{contentTypes:["phrasing","flow"],allowedRoles:!0},blockquote:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},body:{allowedRoles:!1,shadowRoot:!0},br:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"],namingMethods:["titleText","singleSpace"]},button:{contentTypes:["interactive","phrasing","flow"],allowedRoles:["checkbox","combobox","link","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab"],namingMethods:["subtreeText"]},canvas:{allowedRoles:!0,contentTypes:["embedded","phrasing","flow"],chromiumRole:"Canvas"},caption:{allowedRoles:!1},cite:{contentTypes:["phrasing","flow"],allowedRoles:!0},code:{contentTypes:["phrasing","flow"],allowedRoles:!0},col:{allowedRoles:!1,noAriaAttrs:!0},colgroup:{allowedRoles:!1,noAriaAttrs:!0},data:{contentTypes:["phrasing","flow"],allowedRoles:!0},datalist:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0,implicitAttrs:{"aria-multiselectable":"false"}},dd:{allowedRoles:!1},del:{contentTypes:["phrasing","flow"],allowedRoles:!0},dfn:{contentTypes:["phrasing","flow"],allowedRoles:!0},details:{contentTypes:["interactive","flow"],allowedRoles:!1},dialog:{contentTypes:["flow"],allowedRoles:["alertdialog"]},div:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},dl:{contentTypes:["flow"],allowedRoles:["group","list","presentation","none"],chromiumRole:"DescriptionList"},dt:{allowedRoles:["listitem"]},em:{contentTypes:["phrasing","flow"],allowedRoles:!0},embed:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","presentation","none"],chromiumRole:"EmbeddedObject"},fieldset:{contentTypes:["flow"],allowedRoles:["none","presentation","radiogroup"],namingMethods:["fieldsetLegendText"]},figcaption:{allowedRoles:["group","none","presentation"]},figure:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["figureText","titleText"]},footer:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},form:{contentTypes:["flow"],allowedRoles:["search","none","presentation"]},h1:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"1"}},h2:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"2"}},h3:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"3"}},h4:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"4"}},h5:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"5"}},h6:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"6"}},head:{allowedRoles:!1,noAriaAttrs:!0},header:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},hgroup:{contentTypes:["heading","flow"],allowedRoles:!0},hr:{contentTypes:["flow"],allowedRoles:["none","presentation","doc-pagebreak"],namingMethods:["titleText","singleSpace"]},html:{allowedRoles:!1,noAriaAttrs:!0},i:{contentTypes:["phrasing","flow"],allowedRoles:!0},iframe:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","none","presentation"],chromiumRole:"Iframe"},img:{variant:{nonEmptyAlt:{matches:[{attributes:{alt:"/.+/"}},{hasAccessibleName:!0}],allowedRoles:["button","checkbox","link","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","radio","scrollbar","separator","slider","switch","tab","treeitem","doc-cover"]},usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","flow"]},default:{allowedRoles:["presentation","none"],contentTypes:["embedded","flow"]}},namingMethods:["altText"]},input:{variant:{button:{matches:{properties:{type:"button"}},allowedRoles:["checkbox","combobox","link","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab"]},buttonType:{matches:{properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},checkboxPressed:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":"/.*/"}},allowedRoles:["button","menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},checkbox:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":null}},allowedRoles:["menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},noRoles:{matches:{properties:{type:["color","date","datetime-local","file","month","number","password","range","reset","submit","time","week"]}},allowedRoles:!1},hidden:{matches:{properties:{type:"hidden"}},contentTypes:["flow"],allowedRoles:!1,noAriaAttrs:!0},image:{matches:{properties:{type:"image"}},allowedRoles:["link","menuitem","menuitemcheckbox","menuitemradio","radio","switch"],namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},radio:{matches:{properties:{type:"radio"}},allowedRoles:["menuitemradio"],implicitAttrs:{"aria-checked":"false"}},textWithList:{matches:{properties:{type:"text"},attributes:{list:"/.*/"}},allowedRoles:!1},default:{contentTypes:["interactive","flow"],allowedRoles:["combobox","searchbox","spinbutton"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText","placeholderText"]}}},ins:{contentTypes:["phrasing","flow"],allowedRoles:!0},kbd:{contentTypes:["phrasing","flow"],allowedRoles:!0},label:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1,chromiumRole:"Label"},legend:{allowedRoles:!1},li:{allowedRoles:["menuitem","menuitemcheckbox","menuitemradio","option","none","presentation","radio","separator","tab","treeitem","doc-biblioentry","doc-endnote"],implicitAttrs:{"aria-setsize":"1","aria-posinset":"1"}},link:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},main:{contentTypes:["flow"],allowedRoles:!1,shadowRoot:!0},map:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},math:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!1},mark:{contentTypes:["phrasing","flow"],allowedRoles:!0},menu:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},meta:{variant:{itemprop:{matches:"[itemprop]",contentTypes:["phrasing","flow"]}},allowedRoles:!1,noAriaAttrs:!0},meter:{contentTypes:["phrasing","flow"],allowedRoles:!1,chromiumRole:"progressbar"},nav:{contentTypes:["sectioning","flow"],allowedRoles:["doc-index","doc-pagelist","doc-toc","menu","menubar","none","presentation","tablist"],shadowRoot:!0},noscript:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},object:{variant:{usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application","document","img"],chromiumRole:"PluginObject"},ol:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},optgroup:{allowedRoles:!1},option:{allowedRoles:!1,implicitAttrs:{"aria-selected":"false"}},output:{contentTypes:["phrasing","flow"],allowedRoles:!0,namingMethods:["subtreeText"]},p:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},param:{allowedRoles:!1,noAriaAttrs:!0},picture:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},pre:{contentTypes:["flow"],allowedRoles:!0},progress:{contentTypes:["phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-valuemax":"100","aria-valuemin":"0","aria-valuenow":"0"}},q:{contentTypes:["phrasing","flow"],allowedRoles:!0},rp:{allowedRoles:!0},rt:{allowedRoles:!0},ruby:{contentTypes:["phrasing","flow"],allowedRoles:!0},s:{contentTypes:["phrasing","flow"],allowedRoles:!0},samp:{contentTypes:["phrasing","flow"],allowedRoles:!0},script:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},section:{contentTypes:["sectioning","flow"],allowedRoles:["alert","alertdialog","application","banner","complementary","contentinfo","dialog","document","feed","group","log","main","marquee","navigation","none","note","presentation","search","status","tabpanel","doc-abstract","doc-acknowledgments","doc-afterword","doc-appendix","doc-bibliography","doc-chapter","doc-colophon","doc-conclusion","doc-credit","doc-credits","doc-dedication","doc-endnotes","doc-epigraph","doc-epilogue","doc-errata","doc-example","doc-foreword","doc-glossary","doc-index","doc-introduction","doc-notice","doc-pagelist","doc-part","doc-preface","doc-prologue","doc-pullquote","doc-qna","doc-toc"],shadowRoot:!0},select:{variant:{combobox:{matches:{attributes:{multiple:null,size:[null,"1"]}},allowedRoles:["menu"]},default:{allowedRoles:!1}},contentTypes:["interactive","phrasing","flow"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText"]},slot:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},small:{contentTypes:["phrasing","flow"],allowedRoles:!0},source:{allowedRoles:!1,noAriaAttrs:!0},span:{contentTypes:["phrasing","flow"],allowedRoles:!0,shadowRoot:!0},strong:{contentTypes:["phrasing","flow"],allowedRoles:!0},style:{allowedRoles:!1,noAriaAttrs:!0},svg:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!0,chromiumRole:"SVGRoot",namingMethods:["svgTitleText"]},sub:{contentTypes:["phrasing","flow"],allowedRoles:!0},summary:{allowedRoles:!1,namingMethods:["subtreeText"]},sup:{contentTypes:["phrasing","flow"],allowedRoles:!0},table:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["tableCaptionText","tableSummaryText"]},tbody:{allowedRoles:!0},template:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},textarea:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-valuenow":"","aria-multiline":"true"},namingMethods:["labelText","placeholderText"]},tfoot:{allowedRoles:!0},thead:{allowedRoles:!0},time:{contentTypes:["phrasing","flow"],allowedRoles:!0},title:{allowedRoles:!1,noAriaAttrs:!0},td:{allowedRoles:!0},th:{allowedRoles:!0},tr:{allowedRoles:!0},track:{allowedRoles:!1,noAriaAttrs:!0},u:{contentTypes:["phrasing","flow"],allowedRoles:!0},ul:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},var:{contentTypes:["phrasing","flow"],allowedRoles:!0},video:{variant:{controls:{matches:"[controls]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"],chromiumRole:"video"},wbr:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"]}},Po={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},Io={ariaAttrs:Oo,ariaRoles:G({},So,{"doc-abstract":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-acknowledgments":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-afterword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-appendix":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-backlink":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-biblioentry":{type:"listitem",allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"],deprecated:!0},"doc-bibliography":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-biblioref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-chapter":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-colophon":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-conclusion":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-cover":{type:"img",allowedAttrs:["aria-expanded"],superclassRole:["img"]},"doc-credit":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-credits":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-dedication":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-endnote":{type:"listitem",allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"],deprecated:!0},"doc-endnotes":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-epigraph":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-epilogue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-errata":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-example":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-footnote":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-foreword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossary":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-index":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-introduction":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-noteref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-notice":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-pagebreak":{type:"separator",allowedAttrs:["aria-expanded","aria-orientation"],superclassRole:["separator"],childrenPresentational:!0},"doc-pagelist":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-part":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-preface":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-prologue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-pullquote":{type:"none",superclassRole:["none"]},"doc-qna":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-subtitle":{type:"sectionhead",allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"]},"doc-tip":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-toc":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]}},{"graphics-document":{type:"structure",superclassRole:["document"],accessibleNameRequired:!0},"graphics-object":{type:"structure",superclassRole:["group"],nameFromContent:!0},"graphics-symbol":{type:"structure",superclassRole:["img"],accessibleNameRequired:!0,childrenPresentational:!0}}),htmlElms:Mo,cssColors:Po},jo=G({},Io),Lo=jo,qo=function(e){return!!(e=Lo.ariaRoles[e])&&!!e.unsupported},zo=function(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).allowAbstract,n=void 0!==(n=n.flagUnsupported)&&n,a=Lo.ariaRoles[e],r=qo(e);return!(!a||n&&r||!t&&"abstract"===a.type)},Vo=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=t.fallback,a=t.abstracts,r=t.dpub;return 1===(e=e instanceof un?e:Xn(e)).props.nodeType&&(t=(e.attr("role")||"").trim().toLowerCase(),(n?Uc(t):[t]).find((function(e){return!(!r&&"doc-"===e.substr(0,4))&&zo(e,{allowAbstract:a})})))||null},$o=function(e){return Object.keys(Lo.htmlElms).filter((function(t){return(t=Lo.htmlElms[t]).contentTypes?t.contentTypes.includes(e):!!t.variant&&!(!t.variant.default||!t.variant.default.contentTypes)&&t.variant.default.contentTypes.includes(e)}))},Ho=function(){return Kn.get("globalAriaAttrs",(function(){return Object.keys(Lo.ariaAttrs).filter((function(e){return Lo.ariaAttrs[e].global}))}))},Uo=Dr((function(e){for(var t=[],n=e.rows,a=0,r=n.length;a<r;a++)for(var o=n[a].cells,u=(t[a]=t[a]||[],0),i=0,l=o.length;i<l;i++)for(var s=0;s<o[i].colSpan;s++){for(var c=o[i].getAttribute("rowspan"),d=0===parseInt(c)||0===o[i].rowspan?n.length:o[i].rowSpan,p=0;p<d;p++){for(t[a+p]=t[a+p]||[];t[a+p][u];)u++;t[a+p][u]=o[i]}u++}return t})),Go=Dr((function(e,t){var n,a;for(t=t||Uo(pr(e,"table")),n=0;n<t.length;n++)if(t[n]&&-1!==(a=t[n].indexOf(e)))return{x:a,y:n}})),Wo=function(e){var t,n=(e=jd(e)).vNode,a=(e=e.domNode,n.attr("scope")),r=n.attr("role");if(["td","th"].includes(n.props.nodeName))return"columnheader"===r?"col":"rowheader"===r?"row":"col"===a||"row"===a?a:"th"===n.props.nodeName&&(n.actualNode?(r=Uo(pr(e,"table")))[(t=Go(e,r)).y].reduce((function(e,t){return e&&"TH"===t.nodeName.toUpperCase()}),!0)?"col":r.map((function(e){return e[t.x]})).reduce((function(e,t){return e&&t&&"TH"===t.nodeName.toUpperCase()}),!0)?"row":"auto":"auto");throw new TypeError("Expected TD or TH element")},Yo=function(e){return-1!==["col","auto"].indexOf(Wo(e))},Ko=function(e){return["row","auto"].includes(Wo(e))},Xo=function(e){return e?e.replace(/\\r\\n/g,"\\n").replace(/\\u00A0/g," ").replace(/[\\s]{2,}/g," ").trim():""},Zo=function(e){var t=jd(e).vNode;if(t&&!co(t))switch(t.props.nodeName){case"a":case"area":if(t.hasAttr("href"))return!0;break;case"input":return"hidden"!==t.props.type;case"textarea":case"select":case"summary":case"button":return!0;case"details":return!cp(t,"summary").length}return!1};function Jo(e){return 1===(e=jd(e).vNode).props.nodeType&&!(co(e)||!Zo(e)&&(!(e=e.attr("tabindex"))||isNaN(parseInt(e,10))))}var Qo=$o("sectioning").map((function(e){return"".concat(e,":not([role])")})).join(", ")+" , main:not([role]), [role=article], [role=complementary], [role=main], [role=navigation], [role=region]";function eu(e){var t=Xo(Ro(e));e=Xo(_o(e));return t||e}var tu={a:function(e){return e.hasAttr("href")?"link":null},area:function(e){return e.hasAttr("href")?"link":null},article:"article",aside:"complementary",body:"document",button:"button",datalist:"listbox",dd:"definition",dfn:"term",details:"group",dialog:"dialog",dt:"term",fieldset:"group",figure:"figure",footer:function(e){return ca(e,Qo)?null:"contentinfo"},form:function(e){return eu(e)?"form":null},h1:"heading",h2:"heading",h3:"heading",h4:"heading",h5:"heading",h6:"heading",header:function(e){return ca(e,Qo)?null:"banner"},hr:"separator",img:function(e){var t=e.hasAttr("alt")&&!e.attr("alt"),n=Ho().find((function(t){return e.hasAttr(t)}));return!t||n||Jo(e)?"img":"presentation"},input:function(e){var t,n;switch(e.hasAttr("list")&&(n=(t=To(e.actualNode,"list").filter((function(e){return!!e}))[0])&&"datalist"===t.nodeName.toLowerCase()),e.props.type){case"checkbox":return"checkbox";case"number":return"spinbutton";case"radio":return"radio";case"range":return"slider";case"search":return n?"combobox":"searchbox";case"button":case"image":case"reset":case"submit":return"button";case"text":case"tel":case"url":case"email":case"":return n?"combobox":"textbox";default:return"textbox"}},li:"listitem",main:"main",math:"math",menu:"list",nav:"navigation",ol:"list",optgroup:"group",option:"option",output:"status",progress:"progressbar",section:function(e){return eu(e)?"region":null},select:function(e){return e.hasAttr("multiple")||1<parseInt(e.attr("size"))?"listbox":"combobox"},summary:"button",table:"table",tbody:"rowgroup",td:function(e){return e=ca(e,"table"),e=Vo(e),["grid","treegrid"].includes(e)?"gridcell":"cell"},textarea:"textbox",tfoot:"rowgroup",th:function(e){return Yo(e)?"columnheader":Ko(e)?"rowheader":void 0},thead:"rowgroup",tr:"row",ul:"list"},nu=function(e,t){var n=r(t);if(Array.isArray(t)&&void 0!==e)return t.includes(e);if("function"===n)return!!t(e);if(null!=e){if(t instanceof RegExp)return t.test(e);if(/^\\/.*\\/$/.test(t))return n=t.substring(1,t.length-1),new RegExp(n).test(e)}return t===e};function au(e,t){return nu(!!ti(e),t)}var ru=function(e,t){if("object"!==r(t)||Array.isArray(t)||t instanceof RegExp)throw new Error("Expect matcher to be an object");return Object.keys(t).every((function(n){return nu(e(n),t[n])}))};function ou(e,t){return e=jd(e).vNode,ru((function(t){return e.attr(t)}),t)}function uu(e,t){return!!t(e)}function iu(e,t){return nu(Vo(e),t)}function lu(e,t){return nu(gu(e),t)}function su(e,t){return e=jd(e).vNode,nu(e.props.nodeName,t)}function cu(e,t){return e=jd(e).vNode,ru((function(t){return e.props[t]}),t)}function du(e,t){return nu(Fu(e),t)}var pu={hasAccessibleName:au,attributes:ou,condition:uu,explicitRole:iu,implicitRole:lu,nodeName:su,properties:cu,semanticRole:du},fu=function e(t,n){return t=jd(t).vNode,Array.isArray(n)?n.some((function(n){return e(t,n)})):"string"==typeof n?sa(t,n):Object.keys(n).every((function(e){var a;if(pu[e])return a=n[e],(0,pu[e])(t,a);throw new Error(\'Unknown matcher type "\'.concat(e,\'"\'))}))},Du=function(e,t){return fu(e,t)},mu=(Du.hasAccessibleName=au,Du.attributes=ou,Du.condition=uu,Du.explicitRole=iu,Du.fromDefinition=fu,Du.fromFunction=ru,Du.fromPrimative=nu,Du.implicitRole=lu,Du.nodeName=su,Du.properties=cu,Du.semanticRole=du,Du),hu=function(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).noMatchAccessibleName,n=void 0!==t&&t,a=Lo.htmlElms[e.props.nodeName];if(!a)return{};if(!a.variant)return a;var r,o,u=a.variant,i=$(a,l);for(r in u)if(u.hasOwnProperty(r)&&"default"!==r){for(var c=u[r],d=c.matches,p=$(c,s),f=Array.isArray(d)?d:[d],D=0;D<f.length&&n;D++)if(f[D].hasOwnProperty("hasAccessibleName"))return a;if(mu(e,d))for(var m in p)p.hasOwnProperty(m)&&(i[m]=p[m])}for(o in u.default)u.default.hasOwnProperty(o)&&void 0===i[o]&&(i[o]=u.default[o]);return i},gu=function(e){var t,n=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).chromium,a=e instanceof un?e:Xn(e);if(e=a.actualNode,a)return t=a.props.nodeName,!(t=tu[t])&&n?hu(a).chromiumRole||null:"function"==typeof t?t(a):t||null;throw new ReferenceError("Cannot get implicit role of a node outside the current scope.")},bu={td:["tr"],th:["tr"],tr:["thead","tbody","tfoot","table"],thead:["table"],tbody:["table"],tfoot:["table"],li:["ol","ul"],dt:["dl","div"],dd:["dl","div"],div:["dl"]};function vu(e,t){var n=t.chromium;t=$(t,c);return(n=gu(e,{chromium:n}))?function e(t,n){var a=bu[t.props.nodeName];if(a){if(t.parent)return a.includes(t.parent.props.nodeName)?(a=Vo(t.parent,n),["none","presentation"].includes(a)&&!yu(t.parent)?a:a?null:e(t.parent,n)):null;if(t.actualNode)throw new ReferenceError("Cannot determine role presentational inheritance of a required parent outside the current scope.")}return null}(e,t)||n:null}function yu(e){return Ho().some((function(t){return e.hasAttr(t)}))||Jo(e)}var Fu=function(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).noPresentational,n=function(e,t){var n,a=(r=1<arguments.length&&void 0!==t?t:{}).noImplicit,r=$(r,d),o=jd(e).vNode;return 1!==o.props.nodeType?null:!(n=Vo(o,r))||["presentation","none"].includes(n)&&yu(o)?a?null:vu(o,r):n}(e,$(n,p));return t&&["presentation","none"].includes(n)?null:n},wu=["iframe"],Eu=function(e){var t=jd(e).vNode;return 1!==t.props.nodeType||!e.hasAttr("title")||!Du(t,wu)&&["none","presentation"].includes(Fu(t))?"":t.attr("title")},Cu=function(e){var t,n,a=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).strict;return 1===(e=e instanceof un?e:Xn(e)).props.nodeType&&(t=Fu(e),!(!(n=Lo.ariaRoles[t])||!n.nameFromContent)||!a&&(!n||["presentation","none"].includes(t)))},xu=function(e){var t=e.actualNode,n=e.children;if(n)return e.hasAttr("aria-owns")?(e=To(t,"aria-owns").filter((function(e){return!!e})).map((function(e){return o.utils.getNodeFromTree(e)})),[].concat(H(n),H(e))):H(n);throw new Error("getOwnedVirtual requires a virtual node")},Au=$o("phrasing").concat(["#text"]),ku=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=ti.alreadyProcessed;t.startNode=t.startNode||e;var a=(o=t).strict,r=o.inControlContext,o=o.inLabelledByContext,u=hu(e,{noMatchAccessibleName:!0}).contentTypes;return n(e,t)||1!==e.props.nodeType||null!=u&&u.includes("embedded")||!Cu(e,{strict:a})&&!t.subtreeDescendant?"":(a||(t=G({subtreeDescendant:!r&&!o},t)),xu(e).reduce((function(e,n){var a=t,r=n.props.nodeName;return(n=ti(n,a))?(Au.includes(r)||(" "!==n[0]&&(n+=" "),e&&" "!==e[e.length-1]&&(n=" "+n)),e+n):e}),""))},Bu=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=ti.alreadyProcessed;if(t.inControlContext||t.inLabelledByContext||n(e,t))return"";t.startNode||(t.startNode=e);var a,r=G({inControlContext:!0},t);n=function(e){if(!e.attr("id"))return[];if(e.actualNode)return cr({elm:"label",attr:"for",value:e.attr("id"),context:e.actualNode});throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes")}(e);return(t=ca(e,"label"))?(a=[].concat(H(n),[t.actualNode])).sort(Id):a=n,a.map((function(e){return No(e,r)})).filter((function(e){return""!==e})).join(" ")},Tu={submit:"Submit",image:"Submit",reset:"Reset",button:""};function Nu(e,t){return t.attr(e)||""}function Ru(e,t,n){t=t.actualNode;var a=[e=e.toLowerCase(),t.nodeName.toLowerCase()].join(",");return(t=t.querySelector(a))&&t.nodeName.toLowerCase()===e?No(t,n):""}var _u={valueText:function(e){return e.actualNode.value||""},buttonDefaultText:function(e){return e=e.actualNode,Tu[e.type]||""},tableCaptionText:Ru.bind(null,"caption"),figureText:Ru.bind(null,"figcaption"),svgTitleText:Ru.bind(null,"title"),fieldsetLegendText:Ru.bind(null,"legend"),altText:Nu.bind(null,"alt"),tableSummaryText:Nu.bind(null,"summary"),titleText:Eu,subtreeText:ku,labelText:Bu,singleSpace:function(){return" "},placeholderText:Nu.bind(null,"placeholder")},Ou=function(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},a=e.actualNode;return 1!==e.props.nodeType||["presentation","none"].includes(Fu(e))?"":(t=(hu(e,{noMatchAccessibleName:!0}).namingMethods||[]).map((function(e){return _u[e]})).reduce((function(t,a){return t||a(e,n)}),""),n.debug&&o.log(t||"{empty-value}",a,n),t)},Su={accessibleNameFromFieldValue:["combobox","listbox","progressbar"]};function Mu(e){return e=jd(e).vNode,Pu(e)}var Pu=Dr((function(e,t){return!Cr(e)&&!uo(e,{skipAncestors:!0,isAncestor:t})&&(e.actualNode&&"area"===e.props.nodeName?!Tr(e,Pu):!_r(e,{skipAncestors:!0,isAncestor:t})&&(!e.parent||Pu(e.parent,!0)))})),Iu=function e(t,n,a){var r=jd(t).vNode,o=n?Mu:zr,u=!t.actualNode||t.actualNode&&o(t);o=r.children.map((function(t){var r=(o=t.props).nodeType,o=o.nodeValue;if(3===r){if(o&&u)return o}else if(!a)return e(t,n)})).join("");return Xo(o)},ju=["button","checkbox","color","file","hidden","image","password","radio","reset","submit"],Lu=function(e){var t=(e=e instanceof un?e:Xn(e)).props.nodeName;return"textarea"===t||"input"===t&&!ju.includes((e.attr("type")||"").toLowerCase())},qu=function(e){return"select"===(e=e instanceof un?e:Xn(e)).props.nodeName},zu=function(e){return"textbox"===Vo(e)},Vu=function(e){return"listbox"===Vo(e)},$u=function(e){return"combobox"===Vo(e)},Hu=["progressbar","scrollbar","slider","spinbutton"],Uu=function(e){return e=Vo(e),Hu.includes(e)},Gu=["textbox","progressbar","scrollbar","slider","spinbutton","combobox","listbox"],Wu={nativeTextboxValue:function(e){return e=jd(e).vNode,Lu(e)&&e.props.value||""},nativeSelectValue:function(e){if(e=jd(e).vNode,!qu(e))return"";var t=(e=cp(e,"option")).filter((function(e){return e.props.selected}));return t.length||t.push(e[0]),t.map((function(e){return Iu(e)})).join(" ")||""},ariaTextboxValue:function(e){var t=(e=jd(e)).vNode;e=e.domNode;return zu(t)?e&&_r(e)?e.textContent:Iu(t,!0):""},ariaListboxValue:Yu,ariaComboboxValue:function(e,t){e=jd(e).vNode;return $u(e)&&(e=xu(e).filter((function(e){return"listbox"===Fu(e)}))[0])?Yu(e,t):""},ariaRangeValue:function(e){e=jd(e).vNode;return Uu(e)&&e.hasAttr("aria-valuenow")?(e=+e.attr("aria-valuenow"),isNaN(e)?"0":String(e)):""}};function Yu(e,t){e=jd(e).vNode;return Vu(e)&&0!==(e=xu(e).filter((function(e){return"option"===Fu(e)&&"true"===e.attr("aria-selected")}))).length?ti(e[0],t):""}var Ku=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=e.actualNode,a=Su.accessibleNameFromFieldValue||[],r=Fu(e);return t.startNode===e||!Gu.includes(r)||a.includes(r)?"":(a=Object.keys(Wu).map((function(e){return Wu[e]})).reduce((function(n,a){return n||a(e,t)}),""),t.debug&&an(a||"{empty-value}",n,t),a)};function Xu(){return/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26D3\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC3\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC08\\uDC26](?:\\u200D\\u2B1B)?|[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g}var Zu=function(e,t){var n=t.emoji,a=t.nonBmp;t=t.punctuations;return n?/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26D3\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC3\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC08\\uDC26](?:\\u200D\\u2B1B)?|[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g.test(e):a?/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g.test(e)||/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g.test(e):!!t&&/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_`{|}~\\xb1]/g.test(e)},Ju=function(e){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.15,r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:3,o=e.actualNode.nodeValue.trim();if(!Xo(o)||Zu(o,{emoji:!0,nonBmp:!0}))return!1;var u=Kn.get("canvasContext",(function(){return a.createElement("canvas").getContext("2d",{willReadFrequently:!0})})),i=u.canvas,l=(Kn.get("fonts")||Kn.set("fonts",{}),Kn.get("fonts"));if(l[D=t.getComputedStyle(e.parent.actualNode).getPropertyValue("font-family")]||(l[D]={occurrences:0,numLigatures:0}),(l=l[D]).occurrences>=r){if(l.numLigatures/l.occurrences==1)return!0;if(0===l.numLigatures)return!1}l.occurrences++;var s="".concat(r=30,"px ").concat(D),c=(u.font=s,o.charAt(0)),d=u.measureText(c).width,p=(d<30&&(d*=p=30/d,s="".concat(r*=p,"px ").concat(D)),i.width=d,i.height=r,u.font=s,u.textAlign="left",u.textBaseline="top",u.fillText(c,0,0),new Uint32Array(u.getImageData(0,0,d,r).data.buffer));if(!p.some((function(e){return e})))return l.numLigatures++,!0;u.clearRect(0,0,d,r),u.fillText(o,0,0);var f=new Uint32Array(u.getImageData(0,0,d,r).data.buffer),D=p.reduce((function(e,t,n){return 0===t&&0===f[n]||0!==t&&0!==f[n]?e:++e}),0);i=o.split("").reduce((function(e,t){return e+u.measureText(t).width}),0),s=u.measureText(o).width;return n<=D/p.length&&n<=1-s/i&&(l.numLigatures++,!0)};function Qu(e){var t,n,a,r,u,i=function(e,t){return t.startNode||(t=G({startNode:e},t)),1===e.props.nodeType&&t.inLabelledByContext&&void 0===t.includeHidden&&(t=G({includeHidden:!Mu(e)},t)),t}(e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:{});return function(e,t){if(e&&1===e.props.nodeType&&!t.includeHidden)return!Mu(e)}(e,i)||(t=e,n=(u=i).ignoreIconLigature,a=u.pixelThreshold,r=null!=(r=u.occurrenceThreshold)?r:u.occuranceThreshold,3===t.props.nodeType&&n&&Ju(t,a,r))?"":(u=[Ro,_o,Ou,Ku,ku,ei,Eu].reduce((function(t,n){return""!==(t=i.startNode===e?Xo(t):t)?t:n(e,i)}),""),i.debug&&o.log(u||"{empty-value}",e.actualNode,i),u)}function ei(e){return 3!==e.props.nodeType?"":e.props.nodeValue}Qu.alreadyProcessed=function(e,t){return t.processed=t.processed||[],!!t.processed.includes(e)||(t.processed.push(e),!1)};var ti=Qu,ni=function(e,t){var n=t.emoji,a=t.nonBmp;t=t.punctuations;return n&&(e=e.replace(/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26D3\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC3\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC08\\uDC26](?:\\u200D\\u2B1B)?|[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g,"")),a&&(e=(e=e.replace(/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g,"")).replace(/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g,"")),t?e.replace(/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_`{|}~\\xb1]/g,""):e},ai=function(e){return e.length&&!["x","i"].includes(e)&&(e=ni(e,{emoji:!0,nonBmp:!0,punctuations:!0}),Xo(e))?1:0},ri={stateTerms:["on","off"],standaloneTerms:["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","username","new-password","current-password","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo","one-time-code"],qualifiers:["home","work","mobile","fax","pager"],qualifiedTerms:["tel","tel-country-code","tel-national","tel-area-code","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp"],locations:["billing","shipping"]},oi=function(e){var t=void 0!==(t=(u=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).looseTyped)&&t,n=void 0===(n=u.stateTerms)?[]:n,a=void 0===(a=u.locations)?[]:a,r=void 0===(r=u.qualifiers)?[]:r,o=void 0===(o=u.standaloneTerms)?[]:o,u=void 0===(u=u.qualifiedTerms)?[]:u;return e=e.toLowerCase().trim(),!(!(n=n.concat(ri.stateTerms)).includes(e)&&""!==e)||(r=r.concat(ri.qualifiers),a=a.concat(ri.locations),o=o.concat(ri.standaloneTerms),u=u.concat(ri.qualifiedTerms),!("webauthn"===(n=e.split(/\\s+/g))[n.length-1]&&(n.pop(),0===n.length)||!t&&(8<n[0].length&&"section-"===n[0].substr(0,8)&&n.shift(),a.includes(n[0])&&n.shift(),r.includes(n[0])&&(n.shift(),o=[]),1!==n.length))&&(t=n[n.length-1],o.includes(t)||u.includes(t)))},ui=function(e){var t;return e.attr("aria-labelledby")&&(t=To(e.actualNode,"aria-labelledby").map((function(e){return(e=Xn(e))?Iu(e):""})).join(" ").trim())?t:(t=(t=e.attr("aria-label"))&&Xo(t))||null},ii=function(e,t,n){return e=Xn(e),Iu(e,t,n)},li=function(e){if(t=ui(e))return t;if(e.attr("id")){if(!e.actualNode)throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes");var t,n=En(e.attr("id"));if(t=(n=sr(e.actualNode).querySelector(\'label[for="\'+n+\'"]\'))&&ii(n,!0))return t}return(t=(n=ca(e,"label"))&&Iu(n,!0))||null},si=function(e){return e=Xn(e),li(e)},ci=[{matches:[{nodeName:"textarea"},{nodeName:"input",properties:{type:["text","password","search","tel","email","url"]}}],namingMethods:"labelText"},{matches:{nodeName:"input",properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},{matches:{nodeName:"input",properties:{type:"image"}},namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},{matches:"button",namingMethods:"subtreeText"},{matches:"fieldset",namingMethods:"fieldsetLegendText"},{matches:"OUTPUT",namingMethods:"subtreeText"},{matches:[{nodeName:"select"},{nodeName:"input",properties:{type:/^(?!text|password|search|tel|email|url|button|submit|reset)/}}],namingMethods:"labelText"},{matches:"summary",namingMethods:"subtreeText"},{matches:"figure",namingMethods:["figureText","titleText"]},{matches:"img",namingMethods:"altText"},{matches:"table",namingMethods:["tableCaptionText","tableSummaryText"]},{matches:["hr","br"],namingMethods:["titleText","singleSpace"]}],di=function e(t){var n=zr(t),a=[];return t.children.forEach((function(t){3===t.actualNode.nodeType?n&&a.push(t):a=a.concat(e(t))})),a},pi=Dr((function(e){var t=Xn(e),n=t.boundingClientRect,r=[],o=gr(t);return e.childNodes.forEach((function(e){var t,u,i,l;3!==e.nodeType||""===Xo(e.nodeValue)||(e=e,(t=a.createRange()).selectNodeContents(e),e=Array.from(t.getClientRects()),u=n,e.some((function(e){return!Hr(yo(e),u)})))||r.push.apply(r,H((i=o,l=[],e.forEach((function(e){e.width<1||e.height<1||(e=i.reduce((function(e,t){return e&&ro(e,t.boundingClientRect)}),e))&&l.push(e)})),l)))})),r.length?r:[n]})),fi=function(e){Kr();var t=Xn(e)._grid;return t?pi(e).map((function(e){return xo(t,e)})):[]},Di=["checkbox","img","meter","progressbar","scrollbar","radio","slider","spinbutton","textbox"],mi=function(e){var t=jd(e).vNode;if(e=o.commons.aria.getExplicitRole(t))return-1!==Di.indexOf(e);switch(t.props.nodeName){case"img":case"iframe":case"object":case"video":case"audio":case"canvas":case"svg":case"math":case"button":case"select":case"textarea":case"keygen":case"progress":case"meter":return!0;case"input":return"hidden"!==t.props.type;default:return!1}},hi=["head","title","template","script","style","iframe","object","video","audio","noscript"];function gi(e){return!hi.includes(e.props.nodeName)&&e.children.some((function(e){return 3===(e=e.props).nodeType&&e.nodeValue.trim()}))}var bi=function e(t,n,a){return gi(t)||mi(t.actualNode)||!a&&!!ui(t)||!n&&t.children.some((function(t){return 1===t.actualNode.nodeType&&e(t)}))},vi=function(e,t,n){return e=Xn(e),bi(e,t,n)};function yi(e){return!(void 0!==e.children&&!gi(e))||(1===e.props.nodeType&&mi(e)?!!o.commons.text.accessibleTextVirtual(e):e.children.some((function(e){return!e.attr("lang")&&yi(e)&&!_r(e)})))}var Fi=function(e){return-1<parseInt(e.getAttribute("tabindex"),10)&&Jo(e)&&!Zo(e)};function wi(e,t){var n=(e=jd(e)).vNode;e=e.domNode;return n?(void 0===n._isHiddenWithCSS&&(n._isHiddenWithCSS=Ei(e,t)),n._isHiddenWithCSS):Ei(e,t)}function Ei(e,n){if(9===e.nodeType)return!1;if(11===e.nodeType&&(e=e.host),["STYLE","SCRIPT"].includes(e.nodeName.toUpperCase()))return!1;var a,r=t.getComputedStyle(e,null);if(r)return"none"===r.getPropertyValue("display")||(a=["hidden","collapse"],r=r.getPropertyValue("visibility"),!(!a.includes(r)||n))||!!(a.includes(r)&&n&&a.includes(n))||!(!(n=Mr(e))||a.includes(r))&&wi(n,r);throw new Error("Style does not exist for the given element.")}var Ci=wi,xi=function(e){return null!==(e=e.doctype)&&"html"===e.name&&!e.publicId&&!e.systemId};function Ai(e){return 1===(e=jd(e).vNode).props.nodeType&&!(parseInt(e.attr("tabindex",10))<=-1)&&Jo(e)}var ki=function(e){(e instanceof un||null!=(n=t)&&n.Node&&e instanceof t.Node)&&(e=o.commons.aria.getRole(e));var n=Lo.ariaRoles[e];return(null==n?void 0:n.type)||null},Bi=["block","list-item","table","flex","grid","inline-block"];function Ti(e){return e=t.getComputedStyle(e).getPropertyValue("display"),Bi.includes(e)||"table-"===e.substr(0,6)}var Ni=function(e,t){var n,a,r,o;return!Ti(e)&&(n=function(e){for(var t=Mr(e);t&&!Ti(t);)t=Mr(t);return Xn(t)}(e),r=a="",o=0,function e(t,n){!1!==n(t.actualNode)&&t.children.forEach((function(t){return e(t,n)}))}(n,(function(t){if(2===o)return!1;if(3===t.nodeType&&(a+=t.nodeValue),1===t.nodeType){var n=(t.nodeName||"").toUpperCase();if(t===e&&(o=1),!["BR","HR"].includes(n))return!("none"===t.style.display||"hidden"===t.style.overflow||!["",null,"none"].includes(t.style.float)||!["",null,"relative"].includes(t.style.position))&&("widget"===ki(t)?(r+=t.textContent,!1):void 0);0===o?r=a="":o=2}})),a=Xo(a),null!=t&&t.noLengthCompare?0!==a.length:(r=Xo(r),a.length>r.length))},Ri=function(e){if(e=(e=e||{}).modalPercent||.75,Kn.get("isModalOpen"))return Kn.get("isModalOpen");if(ep(o._tree[0],"dialog, [role=dialog], [aria-modal=true]",zr).length)return Kn.set("isModalOpen",!0),!0;for(var n=jr(t),u=n.width*e,i=n.height*e,l=(e=(n.width-u)/2,(n.height-i)/2),s=[{x:e,y:l},{x:n.width-e,y:l},{x:n.width/2,y:n.height/2},{x:e,y:n.height-l},{x:n.width-e,y:n.height-l}].map((function(e){return Array.from(a.elementsFromPoint(e.x,e.y))})),c=0;c<s.length;c++){var d=function(e){var n=s[e].find((function(e){return e=t.getComputedStyle(e),parseInt(e.width,10)>=u&&parseInt(e.height,10)>=i&&"none"!==e.getPropertyValue("pointer-events")&&("absolute"===e.position||"fixed"===e.position)}));if(n&&s.every((function(e){return e.includes(n)})))return Kn.set("isModalOpen",!0),{v:!0}}(c);if("object"===r(d))return d.v}Kn.set("isModalOpen",void 0)};function _i(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:2,a=e.ownerDocument.createRange(),r=(a.setStart(e,0),a.setEnd(e,e.childNodes.length),0),o=0,u=ee(a.getClientRects());try{for(u.s();!(t=u.n()).done;){var i=t.value;if(!(i.height<=n))if(r>i.top+n)r=Math.max(r,i.bottom);else{if(0!==o)return!0;r=i.bottom,o++}}}catch(e){u.e(e)}finally{u.f()}return!1}var Oi=function(e){return e instanceof t.Node},Si={},Mi={set:function(e,t){if("string"!=typeof e)throw new Error("Incomplete data: key must be a string");return t&&(Si[e]=t),Si[e]},get:function(e){return Si[e]},clear:function(){Si={}}},Pi=function(e,n){var a=e.nodeName.toUpperCase();return["IMG","CANVAS","OBJECT","IFRAME","VIDEO","SVG"].includes(a)?(Mi.set("bgColor","imgNode"),!0):((e="none"!==(a=(n=n||t.getComputedStyle(e)).getPropertyValue("background-image")))&&(n=/gradient/.test(a),Mi.set("bgColor",n?"bgGradient":"bgImage")),e)},Ii=(re(Mo={},{Colorjs:function(){return Dc},CssSelectorParser:function(){return Ii.CssSelectorParser},doT:function(){return ji.default},emojiRegexText:function(){return Xu},memoize:function(){return Li.default}}),oe(ye())),ji=oe(Zt()),Li=oe(Xt());function qi(e,t){var n=e.length,a=(Array.isArray(e[0])||(e=[e]),(t=Array.isArray(t[0])?t:t.map((function(e){return[e]})))[0].length),r=t[0].map((function(e,n){return t.map((function(e){return e[n]}))}));e=e.map((function(e){return r.map((function(t){var n=0;if(Array.isArray(e))for(var a=0;a<e.length;a++)n+=e[a]*(t[a]||0);else{var r,o=ee(t);try{for(o.s();!(r=o.n()).done;){var u=r.value;n+=e*u}}catch(t){o.e(t)}finally{o.f()}}return n}))}));return 1===n&&(e=e[0]),1===a?e.map((function(e){return e[0]})):e}function zi(e){return"string"===Vi(e)}function Vi(e){return(Object.prototype.toString.call(e).match(/^\\[object\\s+(.*?)\\]$/)[1]||"").toLowerCase()}function $i(e,t){e=+e,t=+t;var n=(Math.floor(e)+"").length;return n<t?+e.toFixed(t-n):(n=Math.pow(10,n-t),Math.round(e/n)*n)}function Hi(e){var t,n;if(e)return e=e.trim(),t=/^-?[\\d.]+$/,(e=e.match(/^([a-z]+)\\((.+?)\\)$/i))?(n=[],e[2].replace(/\\/?\\s*([-\\w.]+(?:%|deg)?)/g,(function(e,a){/%$/.test(a)?(a=new Number(a.slice(0,-1)/100)).type="<percentage>":/deg$/.test(a)?((a=new Number(+a.slice(0,-3))).type="<angle>",a.unit="deg"):t.test(a)&&((a=new Number(a)).type="<number>"),e.startsWith("/")&&((a=a instanceof Number?a:new Number(a)).alpha=!0),n.push(a)})),{name:e[1].toLowerCase(),rawName:e[1],rawArgs:e[2],args:n}):void 0}function Ui(e){return e[e.length-1]}function Gi(e,t,n){return isNaN(e)?t:isNaN(t)?e:e+(t-e)*n}function Wi(e,t,n){return(n-e)/(t-e)}function Yi(e,t,n){return Gi(t[0],t[1],Wi(e[0],e[1],n))}function Ki(e){return e.map((function(e){return e.split("|").map((function(e){var t,n=(e=e.trim()).match(/^(<[a-z]+>)\\[(-?[.\\d]+),\\s*(-?[.\\d]+)\\]?$/);return n?((t=new String(n[1])).range=[+n[2],+n[3]],t):e}))}))}function Xi(){X(this,Xi)}Po=Object.freeze({__proto__:null,isString:zi,type:Vi,toPrecision:$i,parseFunction:Hi,last:Ui,interpolate:Gi,interpolateInv:Wi,mapRange:Yi,parseCoordGrammar:Ki,multiplyMatrices:qi}),J(Xi,[{key:"add",value:function(e,t,n){if("string"!=typeof arguments[0])for(var e in arguments[0])this.add(e,arguments[0][e],t);else(Array.isArray(e)?e:[e]).forEach((function(e){this[e]=this[e]||[],t&&this[e][n?"unshift":"push"](t)}),this)}},{key:"run",value:function(e,t){this[e]=this[e]||[],this[e].forEach((function(e){e.call(t&&t.context?t.context:t,t)}))}}]);var Zi=new Xi,Ji={gamut_mapping:"lch.c",precision:5,deltaE:"76"},Qi={D50:[.3457/.3585,1,.2958/.3585],D65:[.3127/.329,1,.3583/.329]};function el(e){return Array.isArray(e)?e:Qi[e]}function tl(e,t,n,a){var r=3<arguments.length&&void 0!==a?a:{};if(e=el(e),t=el(t),!e||!t)throw new TypeError("Missing white point to convert ".concat(e?"":"from").concat(e||t?"":"/").concat(t?"":"to"));if(e===t)return n;if(r={W1:e,W2:t,XYZ:n,options:r},Zi.run("chromatic-adaptation-start",r),r.M||(r.W1===Qi.D65&&r.W2===Qi.D50?r.M=[[1.0479298208405488,.022946793341019088,-.05019222954313557],[.029627815688159344,.990434484573249,-.01707382502938514],[-.009243058152591178,.015055144896577895,.7518742899580008]]:r.W1===Qi.D50&&r.W2===Qi.D65&&(r.M=[[.9554734527042182,-.023098536874261423,.0632593086610217],[-.028369706963208136,1.0099954580058226,.021041398966943008],[.012314001688319899,-.020507696433477912,1.3303659366080753]])),Zi.run("chromatic-adaptation-end",r),r.M)return qi(r.M,r.XYZ);throw new TypeError("Only Bradford CAT with white points D50 and D65 supported for now.")}function nl(e){X(this,nl),I(this,se),I(this,ie),P(this,le,{writable:!0,value:void 0}),this.id=e.id,this.name=e.name,this.base=e.base?nl.get(e.base):null,this.aliases=e.aliases,this.base&&(this.fromBase=e.fromBase,this.toBase=e.toBase);var t,n=null!=(n=e.coords)?n:this.base.coords;this.coords=n,n=null!=(n=null!=(n=e.white)?n:this.base.white)?n:"D65";for(t in this.white=el(n),this.formats=null!=(n=e.formats)?n:{},this.formats){var a=this.formats[t];a.type||(a.type="function"),a.name||(a.name=t)}!e.cssId||null!=(n=this.formats.functions)&&n.color?null==(n=this.formats)||!n.color||null!=(n=this.formats)&&n.color.id||(this.formats.color.id=this.id):(this.formats.color={id:e.cssId},Object.defineProperty(this,"cssId",{value:e.cssId})),this.referred=e.referred,z(this,le,q(this,se,rl).call(this).reverse()),Zi.run("colorspace-init-end",this)}function al(e){var t;return e.coords&&!e.coordGrammar&&(e.type||(e.type="function"),e.name||(e.name="color"),e.coordGrammar=Ki(e.coords),t=Object.entries(this.coords).map((function(t,n){(t=W(t,2))[0],t=t[1],n=e.coordGrammar[n][0],t=t.range||t.refRange;var a=n.range,r="";return"<percentage>"==n?(a=[0,100],r="%"):"<angle>"==n&&(r="deg"),{fromRange:t,toRange:a,suffix:r}})),e.serializeCoords=function(e,n){return e.map((function(e,a){var r=(a=t[a]).fromRange,o=a.toRange;a=a.suffix;return e=$i(e=r&&o?Yi(r,o,e):e,n),a&&(e+=a),e}))}),e}function rl(){for(var e=[this],t=this;t=t.base;)e.push(t);return e}ie=new WeakSet,le=new WeakMap,se=new WeakSet,J(nl,[{key:"inGamut",value:function(e){var t,n=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).epsilon,a=void 0===n?75e-6:n;return this.isPolar?(e=this.toBase(e),this.base.inGamut(e,{epsilon:a})):(t=Object.values(this.coords),e.every((function(e,n){var r;return"angle"===(n=t[n]).type||!n.range||!!Number.isNaN(e)||(r=(n=W(n.range,2))[0],n=n[1],(void 0===r||r-a<=e)&&(void 0===n||e<=n+a))})))}},{key:"cssId",get:function(){var e;return(null==(e=this.formats.functions)||null==(e=e.color)?void 0:e.id)||this.id}},{key:"isPolar",get:function(){for(var e in this.coords)if("angle"===this.coords[e].type)return!0;return!1}},{key:"getFormat",value:function(e){return"object"===r(e)||(e="default"===e?Object.values(this.formats)[0]:this.formats[e])?q(this,ie,al).call(this,e):null}},{key:"to",value:function(e,t){var n;if(1===arguments.length&&(e=(n=[e.space,e.coords])[0],t=n[1]),this!==(e=nl.get(e))){t=t.map((function(e){return Number.isNaN(e)?0:e}));for(var a,r,o=L(this,le),u=L(e,le),i=0;i<o.length&&o[i]===u[i];i++)a=o[i],r=i;if(!a)throw new Error("Cannot convert between color spaces ".concat(this," and ").concat(e,": no connection space was found"));for(var l=o.length-1;r<l;l--)t=o[l].toBase(t);for(var s=r+1;s<u.length;s++)t=u[s].fromBase(t)}return t}},{key:"from",value:function(e,t){var n;return 1===arguments.length&&(e=(n=[e.space,e.coords])[0],t=n[1]),(e=nl.get(e)).to(this,t)}},{key:"toString",value:function(){return"".concat(this.name," (").concat(this.id,")")}},{key:"getMinCoords",value:function(){var e,t=[];for(e in this.coords){var n=(n=this.coords[e]).range||n.refRange;t.push(null!=(n=null==n?void 0:n.min)?n:0)}return t}}],[{key:"all",get:function(){return H(new Set(Object.values(nl.registry)))}},{key:"register",value:function(e,t){if(1===arguments.length&&(e=(t=arguments[0]).id),t=this.get(t),this.registry[e]&&this.registry[e]!==t)throw new Error("Duplicate color space registration: \'".concat(e,"\'"));if(this.registry[e]=t,1===arguments.length&&t.aliases){var n,a=ee(t.aliases);try{for(a.s();!(n=a.n()).done;){var r=n.value;this.register(r,t)}}catch(e){a.e(e)}finally{a.f()}}return t}},{key:"get",value:function(e){if(!e||e instanceof nl)return e;if("string"===Vi(e)){var t=nl.registry[e.toLowerCase()];if(t)return t;throw new TypeError(\'No color space found with id = "\'.concat(e,\'"\'))}for(var n=arguments.length,a=new Array(1<n?n-1:0),r=1;r<n;r++)a[r-1]=arguments[r];if(a.length)return nl.get.apply(nl,a);throw new TypeError("".concat(e," is not a valid color space"))}},{key:"resolveCoord",value:function(e,t){var n,a;if(a="string"===Vi(e)?e.includes(".")?(n=(a=W(e.split("."),2))[0],a[1]):(n=void 0,e):Array.isArray(e)?(n=(a=W(e,2))[0],a[1]):(n=e.space,e.coordId),!(n=(n=nl.get(n))||t))throw new TypeError("Cannot resolve coordinate reference ".concat(e,": No color space specified and relative references are not allowed here"));if(("number"===(t=Vi(a))||"string"===t&&0<=a)&&(e=Object.entries(n.coords)[a]))return G({space:n,id:e[0],index:a},e[1]);n=nl.get(n);var r,o=a.toLowerCase(),u=0;for(r in n.coords){var i,l=n.coords[r];if(r.toLowerCase()===o||(null==(i=l.name)?void 0:i.toLowerCase())===o)return G({space:n,id:r,index:u},l);u++}throw new TypeError(\'No "\'.concat(a,\'" coordinate found in \').concat(n.name,". Its coordinates are: ").concat(Object.keys(n.coords).join(", ")))}}]);var ol,ul=nl,il=(ue(ul,"registry",{}),ue(ul,"DEFAULT_FORMAT",{type:"functions",name:"color"}),new ul({id:"xyz-d65",name:"XYZ D65",coords:{x:{name:"X"},y:{name:"Y"},z:{name:"Z"}},white:"D65",formats:{color:{ids:["xyz-d65","xyz"]}},aliases:["xyz"]}));N(ll,ul),ol=_(ll),ye=J(ll);function ll(e){var t;return X(this,ll),e.coords||(e.coords={r:{range:[0,1],name:"Red"},g:{range:[0,1],name:"Green"},b:{range:[0,1],name:"Blue"}}),e.base||(e.base=il),e.toXYZ_M&&e.fromXYZ_M&&(null==e.toBase&&(e.toBase=function(n){return n=qi(e.toXYZ_M,n),t.white!==t.base.white?tl(t.white,t.base.white,n):n}),null==e.fromBase)&&(e.fromBase=function(n){return n=tl(t.base.white,t.white,n),qi(e.fromXYZ_M,n)}),null==e.referred&&(e.referred="display"),t=ol.call(this,e)}function sl(e){var t={str:null==(n=String(e))?void 0:n.trim()};if(Zi.run("parse-start",t),t.color)return t.color;if(t.parsed=Hi(t.str),t.parsed){var n=function(){var e=t.parsed.name;if("color"===e){var n,a=t.parsed.args.shift(),o=0<t.parsed.rawArgs.indexOf("/")?t.parsed.args.pop():1,u=ee(ul.all);try{for(u.s();!(n=u.n()).done;){var i,l=n.value,s=l.getFormat("color");if(s&&(a===s.id||null!=(i=s.ids)&&i.includes(a))){var c=function(){var e=Object.keys(l.coords).length,n=Array(e).fill(0);return n.forEach((function(e,a){return n[a]=t.parsed.args[a]||0})),{v:{v:{spaceId:l.id,coords:n,alpha:o}}}}();if("object"===r(c))return c.v}}}catch(n){u.e(n)}finally{u.f()}var d,p="";throw a in ul.registry&&(d=null==(d=ul.registry[a].formats)||null==(d=d.functions)||null==(d=d.color)?void 0:d.id)&&(p="Did you mean color(".concat(d,")?")),new TypeError("Cannot parse color(".concat(a,"). ")+(p||"Missing a plugin?"))}var f,D=ee(ul.all);try{for(D.s();!(f=D.n()).done;){var m=function(){var n,a,r=f.value,o=r.getFormat(e);if(o&&"function"===o.type)return n=1,(o.lastAlpha||Ui(t.parsed.args).alpha)&&(n=t.parsed.args.pop()),a=t.parsed.args,o.coordGrammar&&Object.entries(r.coords).forEach((function(t,n){var r=(t=W(t,2))[0],u=(t=t[1],o.coordGrammar[n]),i=null==(l=a[n])?void 0:l.type;if(!(u=u.find((function(e){return e==i}))))throw l=t.name||r,new TypeError("".concat(i," not allowed for ").concat(l," in ").concat(e,"()"));r=u.range;var l=t.range||t.refRange;(r="<percentage>"===i?r||[0,1]:r)&&l&&(a[n]=Yi(r,l,a[n]))})),{v:{v:{spaceId:r.id,coords:a,alpha:n}}}}();if("object"===r(m))return m.v}}catch(n){D.e(n)}finally{D.f()}}();if("object"===r(n))return n.v}else{var a,o=ee(ul.all);try{for(o.s();!(a=o.n()).done;){var u,i=a.value;for(u in i.formats){var l=i.formats[u];if("custom"===l.type&&(!l.test||l.test(t.str))){var s=l.parse(t.str);if(s)return null==s.alpha&&(s.alpha=1),s}}}}catch(e){o.e(e)}finally{o.f()}}throw new TypeError("Could not parse ".concat(e," as a color. Missing a plugin?"))}function cl(e){var t;if(e)return(t=(e=zi(e)?sl(e):e).space||e.spaceId)instanceof ul||(e.space=ul.get(t)),void 0===e.alpha&&(e.alpha=1),e;throw new TypeError("Empty color reference")}function dl(e,t){return(t=ul.get(t)).from(e)}function pl(e,t){var n=(t=ul.resolveCoord(t,e.space)).space;t=t.index;return dl(e,n)[t]}function fl(e,t,n){return t=ul.get(t),e.coords=t.to(e.space,n),e}function Dl(e,t,n){if(e=cl(e),2===arguments.length&&"object"===Vi(t)){var a,r=t;for(a in r)Dl(e,a,r[a])}else{"function"==typeof n&&(n=n(pl(e,t)));var o=(u=ul.resolveCoord(t,e.space)).space,u=u.index,i=dl(e,o);i[u]=n,fl(e,o,i)}return e}Xt=new ul({id:"xyz-d50",name:"XYZ D50",white:"D50",base:il,fromBase:function(e){return tl(il.white,"D50",e)},toBase:function(e){return tl("D50",il.white,e)},formats:{color:{}}});var ml=24389/27,hl=Qi.D50,gl=new ul({id:"lab",name:"Lab",coords:{l:{refRange:[0,100],name:"L"},a:{refRange:[-125,125]},b:{refRange:[-125,125]}},white:hl,base:Xt,fromBase:function(e){return[116*(e=e.map((function(e,t){return e/hl[t]})).map((function(e){return 216/24389<e?Math.cbrt(e):(ml*e+16)/116})))[1]-16,500*(e[0]-e[1]),200*(e[1]-e[2])]},toBase:function(e){var t=[];return t[1]=(e[0]+16)/116,t[0]=e[1]/500+t[1],t[2]=t[1]-e[2]/200,[24/116<t[0]?Math.pow(t[0],3):(116*t[0]-16)/ml,8<e[0]?Math.pow((e[0]+16)/116,3):e[0]/ml,24/116<t[2]?Math.pow(t[2],3):(116*t[2]-16)/ml].map((function(e,t){return e*hl[t]}))},formats:{lab:{coords:["<number> | <percentage>","<number>","<number>"]}}});function bl(e){return(e%360+360)%360}var vl=new ul({id:"lch",name:"LCH",coords:{l:{refRange:[0,100],name:"Lightness"},c:{refRange:[0,150],name:"Chroma"},h:{refRange:[0,360],type:"angle",name:"Hue"}},base:gl,fromBase:function(e){var t=(e=W(e,3))[0],n=e[1],a=(e=e[2],Math.abs(n)<.02&&Math.abs(e)<.02?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),bl(a)]},toBase:function(e){var t=(e=W(e,3))[0],n=e[1];e=e[2];return n<0&&(n=0),isNaN(e)&&(e=0),[t,n*Math.cos(e*Math.PI/180),n*Math.sin(e*Math.PI/180)]},formats:{lch:{coords:["<number> | <percentage>","<number>","<number> | <angle>"]}}}),yl=Math.pow(25,7),Fl=Math.PI,wl=180/Fl,El=Fl/180;function Cl(e,t){var n=void 0===(n=(r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).kL)?1:n,a=void 0===(a=r.kC)?1:a,r=void 0===(r=r.kH)?1:r,o=(i=W(gl.from(e),3))[0],u=i[1],i=i[2],l=vl.from(gl,[o,u,i])[1],s=(d=W(gl.from(t),3))[0],c=d[1],d=d[2],p=(l=((l=l<0?0:l)+(p=(p=vl.from(gl,[s,c,d])[1])<0?0:p))/2,Math.pow(l,7)),f=(p=(1+(l=.5*(1-Math.sqrt(p/(p+yl)))))*u,u=(1+l)*c,l=Math.sqrt(Math.pow(p,2)+Math.pow(i,2)),c=Math.sqrt(Math.pow(u,2)+Math.pow(d,2)),i=0==p&&0===i?0:Math.atan2(i,p),p=0==u&&0===d?0:Math.atan2(d,u),d=(i<0&&(i+=2*Fl),p<0&&(p+=2*Fl),s-o),u=c-l,(p*=wl)-(i*=wl)),D=(i=i+p,p=Math.abs(f),f=(l*c==0?D=0:p<=180?D=f:180<f?D=f-360:f<-180?D=360+f:console.log("the unthinkable has happened"),2*Math.sqrt(c*l)*Math.sin(D*El/2)),(o+s)/2);o=(l+c)/2,s=Math.pow(o,7),l=l*c==0?i:p<=180?i/2:i<360?(i+360)/2:(i-360)/2,p=1+.015*(c=Math.pow(D-50,2))/Math.sqrt(20+c),i=1+.045*o,D=1,c=1+.015*o*((D-=.17*Math.cos((l-30)*El))+.24*Math.cos(2*l*El)+.32*Math.cos((3*l+6)*El)-.2*Math.cos((4*l-63)*El)),o=30*Math.exp(-1*Math.pow((l-275)/25,2)),D=2*Math.sqrt(s/(s+yl)),l=-1*Math.sin(2*o*El)*D,s=Math.pow(d/(n*p),2),s=(s+=Math.pow(u/(a*i),2))+Math.pow(f/(r*c),2)+u/(a*i)*l*(f/(r*c));return Math.sqrt(s)}var xl=75e-6;function Al(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:e.space,n=void 0===(n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).epsilon)?xl:n,a=(e=cl(e),t=ul.get(t),e.coords);return t!==e.space&&(a=t.from(e)),t.inGamut(a,{epsilon:n})}function kl(e){return{space:e.space,coords:e.coords.slice(),alpha:e.alpha}}function Bl(e){var t=void 0===(t=(r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).method)?Ji.gamut_mapping:t,n=void 0===(r=r.space)?e.space:r;if(zi(arguments[1])&&(n=arguments[1]),!Al(e,n=ul.get(n),{epsilon:0})){var a,r=Tl(e,n);if("clip"!==t&&!Al(e,n)){var o=Bl(kl(r),{method:"clip",space:n});if(2<Cl(e,o)){for(var u=ul.resolveCoord(t),i=u.space,l=u.id,s=Tl(r,i),c=(u.range||u.refRange)[0],d=pl(s,l);.01<d-c;)Cl(s,Bl(kl(s),{space:n,method:"clip"}))-2<.01?c=pl(s,l):d=pl(s,l),Dl(s,l,(c+d)/2);r=Tl(s,n)}else r=o}"clip"!==t&&Al(r,n,{epsilon:0})||(a=Object.values(n.coords).map((function(e){return e.range||[]})),r.coords=r.coords.map((function(e,t){var n=(t=W(a[t],2))[0];t=t[1];return void 0!==n&&(e=Math.max(n,e)),void 0!==t?Math.min(e,t):e}))),n!==e.space&&(r=Tl(r,e.space)),e.coords=r.coords}return e}function Tl(e,t){var n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).inGamut,a=(e=cl(e),(t=ul.get(t)).from(e));a={space:t,coords:a,alpha:e.alpha};return n?Bl(a):a}function Nl(e){var t=void 0===(n=(r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).precision)?Ji.precision:n,n=void 0===(n=r.format)?"default":n,a=void 0===(a=r.inGamut)||a,r=$(r,f),o=n,u=(n=null!=(u=null!=(u=(e=cl(e)).space.getFormat(n))?u:e.space.getFormat("default"))?u:ul.DEFAULT_FORMAT,a=a||n.toGamut,(u=e.coords).map((function(e){return e||0})));if(a&&!Al(e)&&(u=Bl(kl(e),!0===a?void 0:a).coords),"custom"===n.type){if(r.precision=t,!n.serialize)throw new TypeError("format ".concat(o," can only be used to parse colors, not for serialization"));i=n.serialize(u,e.alpha,r)}else{a=n.name||"color",o=(n.serializeCoords?u=n.serializeCoords(u,t):null!==t&&(u=u.map((function(e){return $i(e,t)}))),H(u)),r=("color"===a&&(u=n.id||(null==(r=n.ids)?void 0:r[0])||e.space.id,o.unshift(u)),e.alpha),u=(null!==t&&(r=$i(r,t)),e.alpha<1&&!n.noAlpha?"".concat(n.commas?",":" /"," ").concat(r):"");var i="".concat(a,"(").concat(o.join(n.commas?", ":" ")).concat(u,")")}return i}Tl.returns=Bl.returns="color";var Rl=new ye({id:"rec2020-linear",name:"Linear REC.2020",white:"D65",toXYZ_M:[[.6369580483012914,.14461690358620832,.1688809751641721],[.2627002120112671,.6779980715188708,.05930171646986196],[0,.028072693049087428,1.060985057710791]],fromXYZ_M:[[1.716651187971268,-.355670783776392,-.25336628137366],[-.666684351832489,1.616481236634939,.0157685458139111],[.017639857445311,-.042770613257809,.942103121235474]],formats:{color:{}}}),_l=1.09929682680944,Ol=.018053968510807,Sl=new ye({id:"rec2020",name:"REC.2020",base:Rl,toBase:function(e){return e.map((function(e){return e<4.5*Ol?e/4.5:Math.pow((e+_l-1)/_l,1/.45)}))},fromBase:function(e){return e.map((function(e){return Ol<=e?_l*Math.pow(e,.45)-(_l-1):4.5*e}))},formats:{color:{}}}),Ml=new ye({id:"p3-linear",name:"Linear P3",white:"D65",toXYZ_M:[[.4865709486482162,.26566769316909306,.1982172852343625],[.2289745640697488,.6917385218365064,.079286914093745],[0,.04511338185890264,1.043944368900976]],fromXYZ_M:[[2.493496911941425,-.9313836179191239,-.40271078445071684],[-.8294889695615747,1.7626640603183463,.023624685841943577],[.03584583024378447,-.07617238926804182,.9568845240076872]]}),Pl=new ye({id:"srgb-linear",name:"Linear sRGB",white:"D65",toXYZ_M:[[.41239079926595934,.357584339383878,.1804807884018343],[.21263900587151027,.715168678767756,.07219231536073371],[.01933081871559182,.11919477979462598,.9505321522496607]],fromXYZ_M:[[3.2409699419045226,-1.537383177570094,-.4986107602930034],[-.9692436362808796,1.8759675015077202,.04155505740717559],[.05563007969699366,-.20397695888897652,1.0569715142428786]],formats:{color:{}}}),Il={aliceblue:[240/255,248/255,1],antiquewhite:[250/255,235/255,215/255],aqua:[0,1,1],aquamarine:[127/255,1,212/255],azure:[240/255,1,1],beige:[245/255,245/255,220/255],bisque:[1,228/255,196/255],black:[0,0,0],blanchedalmond:[1,235/255,205/255],blue:[0,0,1],blueviolet:[138/255,43/255,226/255],brown:[165/255,42/255,42/255],burlywood:[222/255,184/255,135/255],cadetblue:[95/255,158/255,160/255],chartreuse:[127/255,1,0],chocolate:[210/255,105/255,30/255],coral:[1,127/255,80/255],cornflowerblue:[100/255,149/255,237/255],cornsilk:[1,248/255,220/255],crimson:[220/255,20/255,60/255],cyan:[0,1,1],darkblue:[0,0,139/255],darkcyan:[0,139/255,139/255],darkgoldenrod:[184/255,134/255,11/255],darkgray:[169/255,169/255,169/255],darkgreen:[0,100/255,0],darkgrey:[169/255,169/255,169/255],darkkhaki:[189/255,183/255,107/255],darkmagenta:[139/255,0,139/255],darkolivegreen:[85/255,107/255,47/255],darkorange:[1,140/255,0],darkorchid:[.6,50/255,.8],darkred:[139/255,0,0],darksalmon:[233/255,150/255,122/255],darkseagreen:[143/255,188/255,143/255],darkslateblue:[72/255,61/255,139/255],darkslategray:[47/255,79/255,79/255],darkslategrey:[47/255,79/255,79/255],darkturquoise:[0,206/255,209/255],darkviolet:[148/255,0,211/255],deeppink:[1,20/255,147/255],deepskyblue:[0,191/255,1],dimgray:[105/255,105/255,105/255],dimgrey:[105/255,105/255,105/255],dodgerblue:[30/255,144/255,1],firebrick:[178/255,34/255,34/255],floralwhite:[1,250/255,240/255],forestgreen:[34/255,139/255,34/255],fuchsia:[1,0,1],gainsboro:[220/255,220/255,220/255],ghostwhite:[248/255,248/255,1],gold:[1,215/255,0],goldenrod:[218/255,165/255,32/255],gray:[128/255,128/255,128/255],green:[0,128/255,0],greenyellow:[173/255,1,47/255],grey:[128/255,128/255,128/255],honeydew:[240/255,1,240/255],hotpink:[1,105/255,180/255],indianred:[205/255,92/255,92/255],indigo:[75/255,0,130/255],ivory:[1,1,240/255],khaki:[240/255,230/255,140/255],lavender:[230/255,230/255,250/255],lavenderblush:[1,240/255,245/255],lawngreen:[124/255,252/255,0],lemonchiffon:[1,250/255,205/255],lightblue:[173/255,216/255,230/255],lightcoral:[240/255,128/255,128/255],lightcyan:[224/255,1,1],lightgoldenrodyellow:[250/255,250/255,210/255],lightgray:[211/255,211/255,211/255],lightgreen:[144/255,238/255,144/255],lightgrey:[211/255,211/255,211/255],lightpink:[1,182/255,193/255],lightsalmon:[1,160/255,122/255],lightseagreen:[32/255,178/255,170/255],lightskyblue:[135/255,206/255,250/255],lightslategray:[119/255,136/255,.6],lightslategrey:[119/255,136/255,.6],lightsteelblue:[176/255,196/255,222/255],lightyellow:[1,1,224/255],lime:[0,1,0],limegreen:[50/255,205/255,50/255],linen:[250/255,240/255,230/255],magenta:[1,0,1],maroon:[128/255,0,0],mediumaquamarine:[.4,205/255,170/255],mediumblue:[0,0,205/255],mediumorchid:[186/255,85/255,211/255],mediumpurple:[147/255,112/255,219/255],mediumseagreen:[60/255,179/255,113/255],mediumslateblue:[123/255,104/255,238/255],mediumspringgreen:[0,250/255,154/255],mediumturquoise:[72/255,209/255,.8],mediumvioletred:[199/255,21/255,133/255],midnightblue:[25/255,25/255,112/255],mintcream:[245/255,1,250/255],mistyrose:[1,228/255,225/255],moccasin:[1,228/255,181/255],navajowhite:[1,222/255,173/255],navy:[0,0,128/255],oldlace:[253/255,245/255,230/255],olive:[128/255,128/255,0],olivedrab:[107/255,142/255,35/255],orange:[1,165/255,0],orangered:[1,69/255,0],orchid:[218/255,112/255,214/255],palegoldenrod:[238/255,232/255,170/255],palegreen:[152/255,251/255,152/255],paleturquoise:[175/255,238/255,238/255],palevioletred:[219/255,112/255,147/255],papayawhip:[1,239/255,213/255],peachpuff:[1,218/255,185/255],peru:[205/255,133/255,63/255],pink:[1,192/255,203/255],plum:[221/255,160/255,221/255],powderblue:[176/255,224/255,230/255],purple:[128/255,0,128/255],rebeccapurple:[.4,.2,.6],red:[1,0,0],rosybrown:[188/255,143/255,143/255],royalblue:[65/255,105/255,225/255],saddlebrown:[139/255,69/255,19/255],salmon:[250/255,128/255,114/255],sandybrown:[244/255,164/255,96/255],seagreen:[46/255,139/255,87/255],seashell:[1,245/255,238/255],sienna:[160/255,82/255,45/255],silver:[192/255,192/255,192/255],skyblue:[135/255,206/255,235/255],slateblue:[106/255,90/255,205/255],slategray:[112/255,128/255,144/255],slategrey:[112/255,128/255,144/255],snow:[1,250/255,250/255],springgreen:[0,1,127/255],steelblue:[70/255,130/255,180/255],tan:[210/255,180/255,140/255],teal:[0,128/255,128/255],thistle:[216/255,191/255,216/255],tomato:[1,99/255,71/255],turquoise:[64/255,224/255,208/255],violet:[238/255,130/255,238/255],wheat:[245/255,222/255,179/255],white:[1,1,1],whitesmoke:[245/255,245/255,245/255],yellow:[1,1,0],yellowgreen:[154/255,205/255,50/255]},jl=new ye({id:"srgb",name:"sRGB",base:Pl,fromBase:function(e){return e.map((function(e){var t=e<0?-1:1,n=e*t;return.0031308<n?t*(1.055*Math.pow(n,1/2.4)-.055):12.92*e}))},toBase:function(e){return e.map((function(e){var t=e<0?-1:1,n=e*t;return n<.04045?e/12.92:t*Math.pow((.055+n)/1.055,2.4)}))},formats:{rgb:{coords:jl=Array(3).fill("<percentage> | <number>[0, 255]")},rgb_number:{name:"rgb",commas:!0,coords:Ll=Array(3).fill("<number>[0, 255]"),noAlpha:!0},color:{},rgba:{coords:jl,commas:!0,lastAlpha:!0},rgba_number:{name:"rgba",commas:!0,coords:Ll},hex:{type:"custom",toGamut:!0,test:function(e){return/^#([a-f0-9]{3,4}){1,2}$/i.test(e)},parse:function(e){e.length<=5&&(e=e.replace(/[a-f0-9]/gi,"$&$&"));var t=[];return e.replace(/[a-f0-9]{2}/gi,(function(e){t.push(parseInt(e,16)/255)})),{spaceId:"srgb",coords:t.slice(0,3),alpha:t.slice(3)[0]}},serialize:function(e,t){var n=void 0===(n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).collapse)||n,a=(t<1&&e.push(t),e=e.map((function(e){return Math.round(255*e)})),n&&e.every((function(e){return e%17==0})));return"#"+e.map((function(e){return a?(e/17).toString(16):e.toString(16).padStart(2,"0")})).join("")}},keyword:{type:"custom",test:function(e){return/^[a-z]+$/i.test(e)},parse:function(e){var t={spaceId:"srgb",coords:null,alpha:1};if("transparent"===(e=e.toLowerCase())?(t.coords=Il.black,t.alpha=0):t.coords=Il[e],t.coords)return t}}}}),Ll=new ye({id:"p3",name:"P3",base:Ml,fromBase:jl.fromBase,toBase:jl.toBase,formats:{color:{id:"display-p3"}}});if(Ji.display_space=jl,"undefined"!=typeof CSS&&CSS.supports)for(var ql=0,zl=[gl,Sl,Ll];ql<zl.length;ql++){var Vl=zl[ql],$l=Vl.getMinCoords();$l=Nl({space:Vl,coords:$l,alpha:1});if(CSS.supports("color",$l)){Ji.display_space=Vl;break}}function Hl(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"lab",a=(n=ul.get(n)).from(e),r=n.from(t);return Math.sqrt(a.reduce((function(e,t,n){return n=r[n],isNaN(t)||isNaN(n)?e:e+Math.pow(n-t,2)}),0))}function Ul(e){return pl(e,[il,"y"])}function Gl(e,t){Dl(e,[il,"y"],t)}var Wl=Object.freeze({__proto__:null,getLuminance:Ul,setLuminance:Gl,register:function(e){Object.defineProperty(e.prototype,"luminance",{get:function(){return Ul(this)},set:function(e){Gl(this,e)}})}});function Yl(e){return.022<=e?e:e+Math.pow(.022-e,1.414)}function Kl(e){var t=e<0?-1:1;e=Math.abs(e);return t*Math.pow(e,2.4)}var Xl=24389/27,Zl=Qi.D65,Jl=new ul({id:"lab-d65",name:"Lab D65",coords:{l:{refRange:[0,100],name:"L"},a:{refRange:[-125,125]},b:{refRange:[-125,125]}},white:Zl,base:il,fromBase:function(e){return[116*(e=e.map((function(e,t){return e/Zl[t]})).map((function(e){return 216/24389<e?Math.cbrt(e):(Xl*e+16)/116})))[1]-16,500*(e[0]-e[1]),200*(e[1]-e[2])]},toBase:function(e){var t=[];return t[1]=(e[0]+16)/116,t[0]=e[1]/500+t[1],t[2]=t[1]-e[2]/200,[24/116<t[0]?Math.pow(t[0],3):(116*t[0]-16)/Xl,8<e[0]?Math.pow((e[0]+16)/116,3):e[0]/Xl,24/116<t[2]?Math.pow(t[2],3):(116*t[2]-16)/Xl].map((function(e,t){return e*Zl[t]}))},formats:{"lab-d65":{coords:["<number> | <percentage>","<number>","<number>"]}}}),Ql=.5*Math.pow(5,.5)+.5,es=Object.freeze({__proto__:null,contrastWCAG21:function(e,t){var n;return e=cl(e),t=cl(t),(e=Math.max(Ul(e),0))<(t=Math.max(Ul(t),0))&&(e=(n=[t,e])[0],t=n[1]),(e+.05)/(t+.05)},contrastAPCA:function(e,t){t=cl(t),e=cl(e);var n=(t=W((t=Tl(t,"srgb")).coords,3))[0],a=t[1],r=(t=t[2],.2126729*Kl(n)+.7151522*Kl(a)+.072175*Kl(t));n=(e=W((e=Tl(e,"srgb")).coords,3))[0],a=e[1],t=e[2],e=.2126729*Kl(n)+.7151522*Kl(a)+.072175*Kl(t),t=(n=Yl(r))<(a=Yl(e)),r=Math.abs(a-n)<5e-4?0:t?1.14*(Math.pow(a,.56)-Math.pow(n,.57)):1.14*(Math.pow(a,.65)-Math.pow(n,.62));return 100*(Math.abs(r)<.1?0:0<r?r-.027:r+.027)},contrastMichelson:function(e,t){e=cl(e),t=cl(t);var n=((e=Math.max(Ul(e),0))<(t=Math.max(Ul(t),0))&&(e=(n=[t,e])[0],t=n[1]),e+t);return 0===n?0:(e-t)/n},contrastWeber:function(e,t){var n;return e=cl(e),t=cl(t),(e=Math.max(Ul(e),0))<(t=Math.max(Ul(t),0))&&(e=(n=[t,e])[0],t=n[1]),0===t?5e4:(e-t)/t},contrastLstar:function(e,t){return e=cl(e),t=cl(t),e=pl(e,[gl,"l"]),t=pl(t,[gl,"l"]),Math.abs(e-t)},contrastDeltaPhi:function(e,t){return e=cl(e),t=cl(t),e=pl(e,[Jl,"l"]),t=pl(t,[Jl,"l"]),e=Math.abs(Math.pow(e,Ql)-Math.pow(t,Ql)),(t=Math.pow(e,1/Ql)*Math.SQRT2-40)<7.5?0:t}});function ts(e){var t=(e=W(dl(e,il),3))[0],n=e[1];return[4*t/(e=t+15*n+3*e[2]),9*n/e]}function ns(e){var t=(e=W(dl(e,il),3))[0],n=e[1];return[t/(e=t+n+e[2]),n/e]}var as=Object.freeze({__proto__:null,uv:ts,xy:ns,register:function(e){Object.defineProperty(e.prototype,"uv",{get:function(){return ts(this)}}),Object.defineProperty(e.prototype,"xy",{get:function(){return ns(this)}})}}),rs=Math.PI/180,os=new ul({id:"xyz-abs-d65",name:"Absolute XYZ D65",coords:{x:{refRange:[0,9504.7],name:"Xa"},y:{refRange:[0,1e4],name:"Ya"},z:{refRange:[0,10888.3],name:"Za"}},base:il,fromBase:function(e){return e.map((function(e){return Math.max(203*e,0)}))},toBase:function(e){return e.map((function(e){return Math.max(e/203,0)}))}}),us=2610/Math.pow(2,14),is=Math.pow(2,14)/2610,ls=3424/Math.pow(2,12),ss=2413/Math.pow(2,7),cs=2392/Math.pow(2,7),ds=1.7*2523/Math.pow(2,5),ps=Math.pow(2,5)/(1.7*2523),fs=16295499532821565e-27,Ds=[[.41478972,.579999,.014648],[-.20151,1.120649,.0531008],[-.0166008,.2648,.6684799]],ms=[[1.9242264357876067,-1.0047923125953657,.037651404030618],[.35031676209499907,.7264811939316552,-.06538442294808501],[-.09098281098284752,-.3127282905230739,1.5227665613052603]],hs=[[.5,.5,0],[3.524,-4.066708,.542708],[.199076,1.096799,-1.295875]],gs=[[1,.1386050432715393,.05804731615611886],[.9999999999999999,-.1386050432715393,-.05804731615611886],[.9999999999999998,-.09601924202631895,-.8118918960560388]],bs=new ul({id:"jzazbz",name:"Jzazbz",coords:{jz:{refRange:[0,1],name:"Jz"},az:{refRange:[-.5,.5]},bz:{refRange:[-.5,.5]}},base:os,fromBase:function(e){var t=(e=W(e,3))[0],n=e[1];e=e[2],n=qi(Ds,[1.15*t-(1.15-1)*e,.66*n-(.66-1)*t,e]).map((function(e){var t=ls+ss*Math.pow(e/1e4,us);e=1+cs*Math.pow(e/1e4,us);return Math.pow(t/e,ds)})),e=(t=W(qi(hs,n),3))[0],n=t[1],t=t[2];return[(1-.56)*e/(1+-.56*e)-fs,n,t]},toBase:function(e){var t=(e=W(e,3))[0],n=e[1];e=e[2],t=qi(gs,[(t+fs)/(1-.56- -.56*(t+fs)),n,e]).map((function(e){var t=ls-Math.pow(e,ps);e=cs*Math.pow(e,ps)-ss;return 1e4*Math.pow(t/e,is)})),e=(n=W(qi(ms,t),3))[0],t=n[1];return[e=(e+(1.15-1)*(n=n[2]))/1.15,(t+(.66-1)*e)/.66,n]},formats:{color:{}}}),vs=new ul({id:"jzczhz",name:"JzCzHz",coords:{jz:{refRange:[0,1],name:"Jz"},cz:{refRange:[0,1],name:"Chroma"},hz:{refRange:[0,360],type:"angle",name:"Hue"}},base:bs,fromBase:function(e){var t=(e=W(e,3))[0],n=e[1],a=(e=e[2],Math.abs(n)<2e-4&&Math.abs(e)<2e-4?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),bl(a)]},toBase:function(e){return[e[0],e[1]*Math.cos(e[2]*Math.PI/180),e[1]*Math.sin(e[2]*Math.PI/180)]},formats:{color:{}}}),ys=2610/16384,Fs=[[.3592,.6976,-.0358],[-.1922,1.1004,.0755],[.007,.0749,.8434]],ws=[[.5,.5,0],[6610/4096,-13613/4096,7003/4096],[17933/4096,-17390/4096,-543/4096]],Es=[[.9999888965628402,.008605050147287059,.11103437159861648],[1.00001110343716,-.008605050147287059,-.11103437159861648],[1.0000320633910054,.56004913547279,-.3206339100541203]],Cs=[[2.0701800566956137,-1.326456876103021,.20661600684785517],[.3649882500326575,.6804673628522352,-.04542175307585323],[-.04959554223893211,-.04942116118675749,1.1879959417328034]],xs=new ul({id:"ictcp",name:"ICTCP",coords:{i:{refRange:[0,1],name:"I"},ct:{refRange:[-.5,.5],name:"CT"},cp:{refRange:[-.5,.5],name:"CP"}},base:os,fromBase:function(e){var t=e=qi(Fs,e);return t=e.map((function(e){var t=.8359375+2413/128*Math.pow(e/1e4,ys);e=1+18.6875*Math.pow(e/1e4,ys);return Math.pow(t/e,2523/32)})),qi(ws,t)},toBase:function(e){return e=qi(Es,e).map((function(e){var t=Math.max(Math.pow(e,32/2523)-.8359375,0);e=2413/128-18.6875*Math.pow(e,32/2523);return 1e4*Math.pow(t/e,16384/2610)})),qi(Cs,e)},formats:{color:{}}}),As=[[.8190224432164319,.3619062562801221,-.12887378261216414],[.0329836671980271,.9292868468965546,.03614466816999844],[.048177199566046255,.26423952494422764,.6335478258136937]],ks=[[1.2268798733741557,-.5578149965554813,.28139105017721583],[-.04057576262431372,1.1122868293970594,-.07171106666151701],[-.07637294974672142,-.4214933239627914,1.5869240244272418]],Bs=[[.2104542553,.793617785,-.0040720468],[1.9779984951,-2.428592205,.4505937099],[.0259040371,.7827717662,-.808675766]],Ts=[[.9999999984505198,.39633779217376786,.2158037580607588],[1.0000000088817609,-.10556134232365635,-.06385417477170591],[1.0000000546724108,-.08948418209496575,-1.2914855378640917]],Ns=new ul({id:"oklab",name:"OKLab",coords:{l:{refRange:[0,1],name:"L"},a:{refRange:[-.4,.4]},b:{refRange:[-.4,.4]}},white:"D65",base:il,fromBase:function(e){return e=qi(As,e).map((function(e){return Math.cbrt(e)})),qi(Bs,e)},toBase:function(e){return e=qi(Ts,e).map((function(e){return Math.pow(e,3)})),qi(ks,e)},formats:{oklab:{coords:["<number> | <percentage>","<number>","<number>"]}}}),Rs=Object.freeze({__proto__:null,deltaE76:function(e,t){return Hl(e,t,"lab")},deltaECMC:function(e,t){var n=void 0===(n=(a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).l)?2:n,a=void 0===(a=a.c)?1:a,r=(u=W(gl.from(e),3))[0],o=u[1],u=u[2],i=(l=W(vl.from(gl,[r,o,u]),3))[1],l=l[2],s=(d=W(gl.from(t),3))[0],c=d[1],d=d[2],p=vl.from(gl,[s,c,d])[1];s=r-s,p=(i=i<0?0:i)-(p=p<0?0:p),u-=d,d=Math.pow(o-c,2)+Math.pow(u,2)-Math.pow(p,2),o=.511,16<=r&&(o=.040975*r/(1+.01765*r)),c=.0638*i/(1+.0131*i)+.638,u=164<=(l=Number.isNaN(l)?0:l)&&l<=345?.56+Math.abs(.2*Math.cos((l+168)*rs)):.36+Math.abs(.4*Math.cos((l+35)*rs)),r=Math.pow(i,4),i=c*((l=Math.sqrt(r/(r+1900)))*u+1-l),r=Math.pow(s/(n*o),2),r=(r+=Math.pow(p/(a*c),2))+d/Math.pow(i,2);return Math.sqrt(r)},deltaE2000:Cl,deltaEJz:function(e,t){var n=(e=W(vs.from(e),3))[0],a=e[1],r=(e=e[2],(t=W(vs.from(t),3))[0]),o=t[1];t=t[2],n-=r,r=a-o,Number.isNaN(e)&&Number.isNaN(t)?t=e=0:Number.isNaN(e)?e=t:Number.isNaN(t)&&(t=e),e-=t,t=2*Math.sqrt(a*o)*Math.sin(e/2*(Math.PI/180));return Math.sqrt(Math.pow(n,2)+Math.pow(r,2)+Math.pow(t,2))},deltaEITP:function(e,t){var n=(e=W(xs.from(e),3))[0],a=e[1],r=(e=e[2],(t=W(xs.from(t),3))[0]),o=t[1];t=t[2];return 720*Math.sqrt(Math.pow(n-r,2)+.25*Math.pow(a-o,2)+Math.pow(e-t,2))},deltaEOK:function(e,t){var n=(e=W(Ns.from(e),3))[0],a=e[1],r=(e=e[2],(t=W(Ns.from(t),3))[0]);a-=t[1],e-=t[2];return Math.sqrt(Math.pow(n-r,2)+Math.pow(a,2)+Math.pow(e,2))}});function _s(e,t){var n,a,r=(a=a=zi(a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{})?{method:a}:a).method,o=void 0===r?Ji.deltaE:r,u=$(a,h);for(n in e=cl(e),t=cl(t),Rs)if("deltae"+o.toLowerCase()===n.toLowerCase())return Rs[n](e,t,u);throw new TypeError("Unknown deltaE method: ".concat(o))}var Os=Object.freeze({__proto__:null,lighten:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.25;return Dl(e,[ul.get("oklch","lch"),"l"],(function(e){return e*(1+t)}))},darken:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.25;return Dl(e,[ul.get("oklch","lch"),"l"],(function(e){return e*(1-t)}))}});function Ss(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:.5,a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},r=(e=(r=[cl(e),cl(t)])[0],t=r[1],"object"===Vi(n)&&(n=(r=[.5,n])[0],a=r[1]),a);return Ps(e,t,{space:r.space,outputSpace:r.outputSpace,premultiplied:r.premultiplied})(n)}function Ms(e,t){var n,a,r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},o=(s=(Is(e)&&(r=t,e=(s=W((n=e).rangeArgs.colors,2))[0],t=s[1]),r)).maxDeltaE,u=s.deltaEMethod,i=(r=void 0===(r=s.steps)?2:r,void 0===(l=s.maxSteps)?1e3:l),l=$(s,g),s=(n||(e=(s=[cl(e),cl(t)])[0],t=s[1],n=Ps(e,t,l)),_s(e,t)),c=(l=0<o?Math.max(r,Math.ceil(s/o)+1):r,[]);if(void 0!==i&&(l=Math.min(l,i)),c=1===l?[{p:.5,color:n(.5)}]:(a=1/(l-1),Array.from({length:l},(function(e,t){return{p:t*=a,color:n(t)}}))),0<o)for(var d=c.reduce((function(e,t,n){return 0===n?0:(t=_s(t.color,c[n-1].color,u),Math.max(e,t))}),0);o<d;){d=0;for(var p=1;p<c.length&&c.length<i;p++){var f=c[p-1],D=c[p],m=(D.p+f.p)/2,h=n(m);d=Math.max(d,_s(h,f.color),_s(h,D.color));c.splice(p,0,{p:m,color:n(m)}),p++}}return c=c.map((function(e){return e.color}))}function Ps(e,t){var n,a,r,o,u,i,l,s,c,d,p,f,D=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};return Is(e)?(r=e,o=t,Ps.apply(void 0,H(r.rangeArgs.colors).concat([G({},r.rangeArgs.options,o)]))):(p=D.space,f=D.outputSpace,n=D.progression,a=D.premultiplied,e=cl(e),t=cl(t),e=kl(e),t=kl(t),r={colors:[e,t],options:D},p=p?ul.get(p):ul.registry[Ji.interpolationSpace]||e.space,f=f?ul.get(f):p,e=Tl(e,p),t=Tl(t,p),e=Bl(e),t=Bl(t),p.coords.h&&"angle"===p.coords.h.type&&(o=D.hue=D.hue||"shorter",s=[u=(i=[pl(e,D=[p,"h"]),pl(t,D)])[0],i=i[1]],l="raw"===(l=o)?s:(c=(s=W(s.map(bl),2))[0],d=(s=s[1])-c,"increasing"===l?d<0&&(s+=360):"decreasing"===l?0<d&&(c+=360):"longer"===l?-180<d&&d<180&&(0<d?s+=360:c+=360):"shorter"===l&&(180<d?c+=360:d<-180&&(s+=360)),[c,s]),u=(d=W(l,2))[0],i=d[1],Dl(e,D,u),Dl(t,D,i)),a&&(e.coords=e.coords.map((function(t){return t*e.alpha})),t.coords=t.coords.map((function(e){return e*t.alpha}))),Object.assign((function(r){r=n?n(r):r;var o=e.coords.map((function(e,n){return Gi(e,t.coords[n],r)})),u=Gi(e.alpha,t.alpha,r);o={space:p,coords:o,alpha:u};return a&&(o.coords=o.coords.map((function(e){return e/u}))),f!==p?Tl(o,f):o}),{rangeArgs:r}))}function Is(e){return"function"===Vi(e)&&!!e.rangeArgs}Ji.interpolationSpace="lab";var js=Object.freeze({__proto__:null,mix:Ss,steps:Ms,range:Ps,isRange:Is,register:function(e){e.defineFunction("mix",Ss,{returns:"color"}),e.defineFunction("range",Ps,{returns:"function<color>"}),e.defineFunction("steps",Ms,{returns:"array<color>"})}}),Ls=new ul({id:"hsl",name:"HSL",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},s:{range:[0,100],name:"Saturation"},l:{range:[0,100],name:"Lightness"}},base:jl,fromBase:function(e){var t=Math.max.apply(Math,H(e)),n=Math.min.apply(Math,H(e)),a=(e=W(e,3))[0],r=e[1],o=e[2],u=NaN,i=(e=0,(n+t)/2),l=t-n;if(0!=l){switch(e=0==i||1==i?0:(t-i)/Math.min(i,1-i),t){case a:u=(r-o)/l+(r<o?6:0);break;case r:u=(o-a)/l+2;break;case o:u=(a-r)/l+4}u*=60}return[u,100*e,100*i]},toBase:function(e){var t=(e=W(e,3))[0],n=e[1],a=e[2];function r(e){e=(e+t/30)%12;var r=n*Math.min(a,1-a);return a-r*Math.max(-1,Math.min(e-3,9-e,1))}return(t%=360)<0&&(t+=360),n/=100,a/=100,[r(0),r(8),r(4)]},formats:{hsl:{toGamut:!0,coords:["<number> | <angle>","<percentage>","<percentage>"]},hsla:{coords:["<number> | <angle>","<percentage>","<percentage>"],commas:!0,lastAlpha:!0}}}),qs=new ul({id:"hsv",name:"HSV",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},s:{range:[0,100],name:"Saturation"},v:{range:[0,100],name:"Value"}},base:Ls,fromBase:function(e){var t=(e=W(e,3))[0],n=e[1];e=e[2];return[t,0==(n=(e/=100)+(n/=100)*Math.min(e,1-e))?0:200*(1-e/n),100*n]},toBase:function(e){var t=(e=W(e,3))[0],n=e[1];e=e[2];return[t,0==(n=(e/=100)*(1-(n/=100)/2))||1==n?0:(e-n)/Math.min(n,1-n)*100,100*n]},formats:{color:{toGamut:!0}}}),zs=new ul({id:"hwb",name:"HWB",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},w:{range:[0,100],name:"Whiteness"},b:{range:[0,100],name:"Blackness"}},base:qs,fromBase:function(e){var t=(e=W(e,3))[0],n=e[1];return[t,(e=e[2])*(100-n)/100,100-e]},toBase:function(e){var t=(e=W(e,3))[0],n=e[1],a=(e=e[2],(n/=100)+(e/=100));return 1<=a?[t,0,n/a*100]:[t,100*(0==(a=1-e)?0:1-n/a),100*a]},formats:{hwb:{toGamut:!0,coords:["<number> | <angle>","<percentage>","<percentage>"]}}}),Vs=new ye({id:"a98rgb-linear",name:"Linear Adobe® 98 RGB compatible",white:"D65",toXYZ_M:[[.5766690429101305,.1855582379065463,.1882286462349947],[.29734497525053605,.6273635662554661,.07529145849399788],[.02703136138641234,.07068885253582723,.9913375368376388]],fromXYZ_M:[[2.0415879038107465,-.5650069742788596,-.34473135077832956],[-.9692436362808795,1.8759675015077202,.04155505740717557],[.013444280632031142,-.11836239223101838,1.0151749943912054]]}),$s=new ye({id:"a98rgb",name:"Adobe® 98 RGB compatible",base:Vs,toBase:function(e){return e.map((function(e){return Math.pow(Math.abs(e),563/256)*Math.sign(e)}))},fromBase:function(e){return e.map((function(e){return Math.pow(Math.abs(e),256/563)*Math.sign(e)}))},formats:{color:{id:"a98-rgb"}}}),Hs=new ye({id:"prophoto-linear",name:"Linear ProPhoto",white:"D50",base:Xt,toXYZ_M:[[.7977604896723027,.13518583717574031,.0313493495815248],[.2880711282292934,.7118432178101014,8565396060525902e-20],[0,0,.8251046025104601]],fromXYZ_M:[[1.3457989731028281,-.25558010007997534,-.05110628506753401],[-.5446224939028347,1.5082327413132781,.02053603239147973],[0,0,1.2119675456389454]]}),Us=new ye({id:"prophoto",name:"ProPhoto",base:Hs,toBase:function(e){return e.map((function(e){return e<.03125?e/16:Math.pow(e,1.8)}))},fromBase:function(e){return e.map((function(e){return 1/512<=e?Math.pow(e,1/1.8):16*e}))},formats:{color:{id:"prophoto-rgb"}}}),Gs=new ul({id:"oklch",name:"OKLCh",coords:{l:{refRange:[0,1],name:"Lightness"},c:{refRange:[0,.4],name:"Chroma"},h:{refRange:[0,360],type:"angle",name:"Hue"}},white:"D65",base:Ns,fromBase:function(e){var t=(e=W(e,3))[0],n=e[1],a=(e=e[2],Math.abs(n)<2e-4&&Math.abs(e)<2e-4?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),bl(a)]},toBase:function(e){var t,n=(e=W(e,3))[0],a=e[1];e=e[2],a=isNaN(e)?t=0:(t=a*Math.cos(e*Math.PI/180),a*Math.sin(e*Math.PI/180));return[n,t,a]},formats:{oklch:{coords:["<number> | <percentage>","<number>","<number> | <angle>"]}}}),Ws=2610/Math.pow(2,14),Ys=Math.pow(2,14)/2610,Ks=2523/Math.pow(2,5),Xs=Math.pow(2,5)/2523,Zs=3424/Math.pow(2,12),Js=2413/Math.pow(2,7),Qs=2392/Math.pow(2,7),ec=new ye({id:"rec2100pq",name:"REC.2100-PQ",base:Rl,toBase:function(e){return e.map((function(e){return 1e4*Math.pow(Math.max(Math.pow(e,Xs)-Zs,0)/(Js-Qs*Math.pow(e,Xs)),Ys)/203}))},fromBase:function(e){return e.map((function(e){e=Math.max(203*e/1e4,0);var t=Zs+Js*Math.pow(e,Ws);e=1+Qs*Math.pow(e,Ws);return Math.pow(t/e,Ks)}))},formats:{color:{id:"rec2100-pq"}}}),tc=.17883277,nc=.28466892,ac=.55991073,rc=3.7743,oc=new ye({id:"rec2100hlg",cssid:"rec2100-hlg",name:"REC.2100-HLG",referred:"scene",base:Rl,toBase:function(e){return e.map((function(e){return e<=.5?Math.pow(e,2)/3*rc:Math.exp((e-ac)/tc+nc)/12*rc}))},fromBase:function(e){return e.map((function(e){return(e/=rc)<=1/12?Math.sqrt(3*e):tc*Math.log(12*e-nc)+ac}))},formats:{color:{id:"rec2100-hlg"}}}),uc={};function ic(e){var t=e.id;e.toCone_M,e.fromCone_M,uc[t]=e}function lc(e,t,n){var a=uc[2<arguments.length&&void 0!==n?n:"Bradford"],r=(u=W(qi(a.toCone_M,e),3))[0],o=u[1],u=u[2],i=W(qi(a.toCone_M,t),3);r=qi([[i[0]/r,0,0],[0,i[1]/o,0],[0,0,i[2]/u]],a.toCone_M);return qi(a.fromCone_M,r)}Zi.add("chromatic-adaptation-start",(function(e){e.options.method&&(e.M=lc(e.W1,e.W2,e.options.method))})),Zi.add("chromatic-adaptation-end",(function(e){e.M||(e.M=lc(e.W1,e.W2,e.options.method))})),ic({id:"von Kries",toCone_M:[[.40024,.7076,-.08081],[-.2263,1.16532,.0457],[0,0,.91822]],fromCone_M:[[1.8599364,-1.1293816,.2198974],[.3611914,.6388125,-64e-7],[0,0,1.0890636]]}),ic({id:"Bradford",toCone_M:[[.8951,.2664,-.1614],[-.7502,1.7135,.0367],[.0389,-.0685,1.0296]],fromCone_M:[[.9869929,-.1470543,.1599627],[.4323053,.5183603,.0492912],[-.0085287,.0400428,.9684867]]}),ic({id:"CAT02",toCone_M:[[.7328,.4296,-.1624],[-.7036,1.6975,.0061],[.003,.0136,.9834]],fromCone_M:[[1.0961238,-.278869,.1827452],[.454369,.4735332,.0720978],[-.0096276,-.005698,1.0153256]]}),ic({id:"CAT16",toCone_M:[[.401288,.650173,-.051461],[-.250268,1.204414,.045854],[-.002079,.048952,.953127]],fromCone_M:[[1.862067855087233,-1.011254630531685,.1491867754444518],[.3875265432361372,.6214474419314753,-.008973985167612518],[-.01584149884933386,-.03412293802851557,1.04996443687785]]}),Object.assign(Qi,{A:[1.0985,1,.35585],C:[.98074,1,1.18232],D55:[.95682,1,.92149],D75:[.94972,1,1.22638],E:[1,1,1],F2:[.99186,1,.67393],F7:[.95041,1,1.08747],F11:[1.00962,1,.6435]}),Qi.ACES=[.32168/.33767,1,.34065/.33767];var sc=new ye({id:"acescg",name:"ACEScg",coords:{r:{range:[0,65504],name:"Red"},g:{range:[0,65504],name:"Green"},b:{range:[0,65504],name:"Blue"}},referred:"scene",white:Qi.ACES,toXYZ_M:[[.6624541811085053,.13400420645643313,.1561876870049078],[.27222871678091454,.6740817658111484,.05368951740793705],[-.005574649490394108,.004060733528982826,1.0103391003129971]],fromXYZ_M:[[1.6410233796943257,-.32480329418479,-.23642469523761225],[-.6636628587229829,1.6153315916573379,.016756347685530137],[.011721894328375376,-.008284441996237409,.9883948585390215]],formats:{color:{}}}),cc=Math.pow(2,-16),dc=-.35828683,pc=(Math.log2(65504)+9.72)/17.52,fc=(ye=new ye({id:"acescc",name:"ACEScc",coords:{r:{range:[dc,pc],name:"Red"},g:{range:[dc,pc],name:"Green"},b:{range:[dc,pc],name:"Blue"}},referred:"scene",base:sc,toBase:function(e){return e.map((function(e){return e<=(9.72-15)/17.52?2*(Math.pow(2,17.52*e-9.72)-cc):e<pc?Math.pow(2,17.52*e-9.72):65504}))},fromBase:function(e){return e.map((function(e){return e<=0?(Math.log2(cc)+9.72)/17.52:e<cc?(Math.log2(cc+.5*e)+9.72)/17.52:(Math.log2(e)+9.72)/17.52}))},formats:{color:{}}}),Object.freeze({__proto__:null,XYZ_D65:il,XYZ_D50:Xt,XYZ_ABS_D65:os,Lab_D65:Jl,Lab:gl,LCH:vl,sRGB_Linear:Pl,sRGB:jl,HSL:Ls,HWB:zs,HSV:qs,P3_Linear:Ml,P3:Ll,A98RGB_Linear:Vs,A98RGB:$s,ProPhoto_Linear:Hs,ProPhoto:Us,REC_2020_Linear:Rl,REC_2020:Sl,OKLab:Ns,OKLCH:Gs,Jzazbz:bs,JzCzHz:vs,ICTCP:xs,REC_2100_PQ:ec,REC_2100_HLG:oc,ACEScg:sc,ACEScc:ye})),Dc=(ce=new WeakMap,J(mc,[{key:"space",get:function(){return L(this,ce)}},{key:"spaceId",get:function(){return L(this,ce).id}},{key:"clone",value:function(){return new mc(this.space,this.coords,this.alpha)}},{key:"toJSON",value:function(){return{spaceId:this.spaceId,coords:this.coords,alpha:this.alpha}}},{key:"display",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];var a=function(e){var t=void 0===(t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).space)?Ji.display_space:t,n=$(n,D),a=Nl(e,n);return"undefined"==typeof CSS||CSS.supports("color",a)||!Ji.display_space?(a=new String(a)).color=e:(t=Tl(e,t),(a=new String(Nl(t,n))).color=t),a}.apply(void 0,[this].concat(t));return a.color=new mc(a.color),a}}],[{key:"get",value:function(e){if(e instanceof mc)return e;for(var t=arguments.length,n=new Array(1<t?t-1:0),a=1;a<t;a++)n[a-1]=arguments[a];return T(mc,[e].concat(n))}},{key:"defineFunction",value:function(e,t){function n(){var e,n=t.apply(void 0,arguments);return"color"===o?n=mc.get(n):"function<color>"===o?(e=n,n=function(){var t=e.apply(void 0,arguments);return mc.get(t)},Object.assign(n,e)):"array<color>"===o&&(n=n.map((function(e){return mc.get(e)}))),n}var a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:t,r=void 0===(r=a.instance)||r,o=a.returns;e in mc||(mc[e]=n),r&&(mc.prototype[e]=function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];return n.apply(void 0,[this].concat(t))})}},{key:"defineFunctions",value:function(e){for(var t in e)mc.defineFunction(t,e[t],e[t])}},{key:"extend",value:function(e){if(e.register)e.register(mc);else for(var t in e)mc.defineFunction(t,e[t])}}]),mc);function mc(){var e=this;X(this,mc),P(this,ce,{writable:!0,value:void 0});for(var t,n,a,r=arguments.length,o=new Array(r),u=0;u<r;u++)o[u]=arguments[u];a=(a=1===o.length?cl(o[0]):a)?(t=a.space||a.spaceId,n=a.coords,a.alpha):(t=o[0],n=o[1],o[2]),z(this,ce,ul.get(t)),this.coords=n?n.slice():[0,0,0],this.alpha=a<1?a:1;for(var i=0;i<this.coords.length;i++)"NaN"===this.coords[i]&&(this.coords[i]=NaN);for(var l in L(this,ce).coords)!function(t){Object.defineProperty(e,t,{get:function(){return e.get(t)},set:function(n){return e.set(t,n)}})}(l)}Dc.defineFunctions({get:pl,getAll:dl,set:Dl,setAll:fl,to:Tl,equals:function(e,t){return e=cl(e),t=cl(t),e.space===t.space&&e.alpha===t.alpha&&e.coords.every((function(e,n){return e===t.coords[n]}))},inGamut:Al,toGamut:Bl,distance:Hl,toString:Nl}),Object.assign(Dc,{util:Po,hooks:Zi,WHITES:Qi,Space:ul,spaces:ul.registry,parse:sl,defaults:Ji});for(var hc,gc=0,bc=Object.keys(fc);gc<bc.length;gc++){var vc=bc[gc];ul.register(fc[vc])}for(hc in ul.registry)yc(hc,ul.registry[hc]);function yc(e,t){Object.keys(t.coords),Object.values(t.coords).map((function(e){return e.name}));var n=e.replace(/-/g,"_");Object.defineProperty(Dc.prototype,n,{get:function(){var n=this,a=this.getAll(e);return"undefined"==typeof Proxy?a:new Proxy(a,{has:function(e,n){try{return ul.resolveCoord([t,n]),!0}catch(e){}return Reflect.has(e,n)},get:function(e,n,a){if(n&&"symbol"!==r(n)&&!(n in e)){var o=ul.resolveCoord([t,n]).index;if(0<=o)return e[o]}return Reflect.get(e,n,a)},set:function(a,o,u,i){if(o&&"symbol"!==r(o)&&!(o in a)||0<=o){var l=ul.resolveCoord([t,o]).index;if(0<=l)return a[l]=u,n.setAll(e,a),!0}return Reflect.set(a,o,u,i)}})},set:function(t){this.setAll(e,t)},configurable:!0,enumerable:!0})}Zi.add("colorspace-init-end",(function(e){var t;yc(e.id,e),null!=(t=e.aliases)&&t.forEach((function(t){yc(t,e)}))})),Dc.extend(Rs),Dc.extend({deltaE:_s}),Dc.extend(Os),Dc.extend({contrast:function(e,t){var n,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},r=(a=a=zi(a)?{algorithm:a}:a).algorithm,o=$(a,m);if(!r)throw a=Object.keys(es).map((function(e){return e.replace(/^contrast/,"")})).join(", "),new TypeError("contrast() function needs a contrast algorithm. Please specify one of: ".concat(a));for(n in e=cl(e),t=cl(t),es)if("contrast"+r.toLowerCase()===n.toLowerCase())return es[n](e,t,o);throw new TypeError("Unknown contrast algorithm: ".concat(r))}}),Dc.extend(as),Dc.extend(Wl),Dc.extend(js),Dc.extend(es);dc=oe(Jt()),Xt=oe(Qt());var Fc=(oe(en()),ji.default.templateSettings.strip=!1,"Promise"in t||dc.default.polyfill(),"Uint32Array"in t||(t.Uint32Array=Xt.Uint32Array),t.Uint32Array&&("some"in t.Uint32Array.prototype||Object.defineProperty(t.Uint32Array.prototype,"some",{value:Array.prototype.some}),"reduce"in t.Uint32Array.prototype||Object.defineProperty(t.Uint32Array.prototype,"reduce",{value:Array.prototype.reduce})),/^#[0-9a-f]{3,8}$/i),wc=/hsl\\(\\s*([\\d.]+)(rad|turn)/;function Ec(e,t,n){var a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:1;X(this,Ec),this.red=e,this.green=t,this.blue=n,this.alpha=a}J(Ec,[{key:"toHexString",value:function(){var e=Math.round(this.red).toString(16),t=Math.round(this.green).toString(16),n=Math.round(this.blue).toString(16);return"#"+(15.5<this.red?e:"0"+e)+(15.5<this.green?t:"0"+t)+(15.5<this.blue?n:"0"+n)}},{key:"toJSON",value:function(){return{red:this.red,green:this.green,blue:this.blue,alpha:this.alpha}}},{key:"parseString",value:function(e){e=e.replace(wc,(function(e,t,n){var a=t+n;switch(n){case"rad":return e.replace(a,180*t/Math.PI);case"turn":return e.replace(a,360*t)}}));try{var t=new Dc(e).to("srgb");this.red=Math.round(255*xc(t.r,0,1)),this.green=Math.round(255*xc(t.g,0,1)),this.blue=Math.round(255*xc(t.b,0,1)),this.alpha=+t.alpha}catch(t){throw new Error(\'Unable to parse color "\'.concat(e,\'"\'))}return this}},{key:"parseRgbString",value:function(e){this.parseString(e)}},{key:"parseHexString",value:function(e){e.match(Fc)&&![6,8].includes(e.length)&&this.parseString(e)}},{key:"parseColorFnString",value:function(e){this.parseString(e)}},{key:"getRelativeLuminance",value:function(){var e=this.red/255,t=this.green/255,n=this.blue/255;return.2126*(e<=.03928?e/12.92:Math.pow((.055+e)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((.055+t)/1.055,2.4))+.0722*(n<=.03928?n/12.92:Math.pow((.055+n)/1.055,2.4))}}]);var Cc=Ec;function xc(e,t,n){return Math.min(Math.max(t,e),n)}var Ac=function(e){var t=new Cc;return t.parseString(e.getPropertyValue("background-color")),0!==t.alpha&&(e=e.getPropertyValue("opacity"),t.alpha=t.alpha*e),t},kc=function(e){var n=t.getComputedStyle(e);return Pi(e,n)||1===Ac(n).alpha};function Bc(e){var t;return!(!e.href||(t=Kn.get("firstPageLink",Tc))&&e.compareDocumentPosition(t.actualNode)!==e.DOCUMENT_POSITION_FOLLOWING)}function Tc(){return(t.location.origin?cp(o._tree,\'a[href]:not([href^="javascript:"])\').find((function(e){return!Do(e.actualNode)})):cp(o._tree,\'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript:"])\')[0])||null}var Nc=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,Rc=/(\\w+)\\((\\d+)/;var _c=function e(n,a,r){if(!n)throw new TypeError("Cannot determine if element is visible for non-DOM nodes");var u,i,l,s=n instanceof un?n:Xn(n),c=(n=s?s.actualNode:n,"_isVisible"+(a?"ScreenReader":"")),d=(p=null!=(p=t.Node)?p:{}).DOCUMENT_NODE,p=p.DOCUMENT_FRAGMENT_NODE,f=(s?s.props:n).nodeType,D=s?s.props.nodeName:n.nodeName.toLowerCase();return s&&void 0!==s[c]?s[c]:f===d||!["style","script","noscript","template"].includes(D)&&(n&&f===p&&(n=n.host),(!a||"true"!==(s?s.attr("aria-hidden"):n.getAttribute("aria-hidden")))&&(n?null!==(d=t.getComputedStyle(n,null))&&("area"===D?(u=a,i=r,!!(p=pr(f=n,"map"))&&!!(p=p.getAttribute("name"))&&!(!(f=sr(f))||9!==f.nodeType||!(l=cp(o._tree,\'img[usemap="#\'.concat(En(p),\'"]\')))||!l.length)&&l.some((function(t){return e(t.actualNode,u,i)}))):"none"!==d.getPropertyValue("display")&&(D=parseInt(d.getPropertyValue("height")),f=parseInt(d.getPropertyValue("width")),l=(p=xd(n))&&0===D,p=p&&0===f,D="absolute"===d.getPropertyValue("position")&&(D<2||f<2)&&"hidden"===d.getPropertyValue("overflow"),!(!a&&(function(e){var t=e.getPropertyValue("clip").match(Nc),n=e.getPropertyValue("clip-path").match(Rc);if(t&&5===t.length&&(e=e.getPropertyValue("position"),["fixed","absolute"].includes(e)))return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(n){e=n[1];var a=parseInt(n[2],10);switch(e){case"inset":return 50<=a;case"circle":return 0===a}}}(d)||"0"===d.getPropertyValue("opacity")||l||p||D)||!r&&("hidden"===d.getPropertyValue("visibility")||!a&&Lr(n))))&&(f=!1,(p=n.assignedSlot||n.parentNode)&&(f=e(p,a,!0)),s&&(s[c]=f),f)):(D=!0,(r=s.parent)&&(D=e(r,a,!0)),s&&(s[c]=D),D)))},Oc=function(e,n){for(var a=["fixed","sticky"],r=[],o=!1,u=0;u<e.length;++u){var i=e[u],l=(i===n&&(o=!0),t.getComputedStyle(i));o||-1===a.indexOf(l.position)?r.push(i):r=[]}return r};function Sc(e,n){var a=Mc(n);do{var r,o,u,i,l,s,c=Mc(e);if(c===a||c===n)return i=e,r=n,u=(o=t.getComputedStyle(r)).getPropertyValue("overflow"),"inline"===o.getPropertyValue("display")||(i=Array.from(i.getClientRects()),l=r.getBoundingClientRect(),s={left:l.left,top:l.top,width:l.width,height:l.height},(["scroll","auto"].includes(u)||r instanceof t.HTMLHtmlElement)&&(s.width=r.scrollWidth,s.height=r.scrollHeight),1===i.length&&"hidden"===u&&"nowrap"===o.getPropertyValue("white-space")&&(i[0]=s),i.some((function(e){return!(Math.ceil(e.left)<Math.floor(s.left)||Math.ceil(e.top)<Math.floor(s.top)||Math.floor(e.left+e.width)>Math.ceil(s.left+s.width)||Math.floor(e.top+e.height)>Math.ceil(s.top+s.height))})))}while(e=c);return!1}function Mc(e){for(var t=Xn(e).parent;t;){if(xd(t.actualNode))return t.actualNode;t=t.parent}}var Pc,Ic,jc=function e(t,n){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:a,o=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;if(999<o)throw new Error("Infinite loop detected");return Array.from(r.elementsFromPoint(t,n)||[]).filter((function(e){return sr(e)===r})).reduce((function(a,r){var u;return ur(r)&&(u=e(t,n,r.shadowRoot,o+1),!(a=a.concat(u)).length||!Sc(a[0],r))||a.push(r),a}),[])},Lc=function(e,t){var n,r;if(e.hasAttribute(t))return r=e.nodeName.toUpperCase(),n=e,["A","AREA"].includes(r)&&!e.ownerSVGElement||((n=a.createElement("a")).href=e.getAttribute(t)),r=["https:","ftps:"].includes(n.protocol)?n.protocol.replace(/s:$/,":"):n.protocol,t=(e=(e=(t=e=/^\\//.test(n.pathname)?n.pathname:"/".concat(n.pathname)).split("/").pop())&&-1!==e.indexOf(".")?{pathname:t.replace(e,""),filename:/index./.test(e)?"":e}:{pathname:t,filename:""}).pathname,e=e.filename,{protocol:r,hostname:n.hostname,port:(r=n.port,["443","80"].includes(r)?"":r),pathname:/\\/$/.test(t)?t:"".concat(t,"/"),search:function(e){var t={};if(e&&e.length){var n=e.substring(1).split("&");if(n&&n.length)for(var a=0;a<n.length;a++){var r=(o=W(n[a].split("="),2))[0],o=void 0===(o=o[1])?"":o;t[decodeURIComponent(r)]=decodeURIComponent(o)}}return t}(n.search),hash:(r=n.hash)&&(t=r.match(/#!?\\/?/g))&&"#"!==W(t,1)[0]?r:"",filename:e}},qc=function(e,n){var a=n.getBoundingClientRect(),r=a.top,o=a.left,u=r-n.scrollTop,i=(r=r-n.scrollTop+n.scrollHeight,o-n.scrollLeft);o=o-n.scrollLeft+n.scrollWidth;return!(e.left>o&&e.left>a.right||e.top>r&&e.top>a.bottom||e.right<i&&e.right<a.left||e.bottom<u&&e.bottom<a.top)&&(o=t.getComputedStyle(n),!(e.left>a.right||e.top>a.bottom)||"scroll"===o.overflow||"auto"===o.overflow||n instanceof t.HTMLBodyElement||n instanceof t.HTMLHtmlElement)},zc=0;function Vc(e,t,n){var a;return X(this,Vc),(a=Ic.call(this)).shadowId=n,a.children=[],a.actualNode=e,(a.parent=t)||(zc=0),a.nodeIndex=zc++,a._isHidden=null,a._cache={},void 0===Pc&&(Pc=Rn(e.ownerDocument)),a._isXHTML=Pc,"input"===e.nodeName.toLowerCase()&&(n=e.getAttribute("type"),n=a._isXHTML?n:(n||"").toLowerCase(),vp().includes(n)||(n="text"),a._type=n),Kn.get("nodeMap")&&Kn.get("nodeMap").set(e,O(a)),a}N(Vc,un),Ic=_(Vc),J(Vc,[{key:"props",get:function(){var e,t,n,a,r,o,u,i,l;return this._cache.hasOwnProperty("props")||(e=(l=this.actualNode).nodeType,t=l.nodeName,n=l.id,a=l.multiple,r=l.nodeValue,o=l.value,u=l.selected,i=l.checked,l=l.indeterminate,this._cache.props={nodeType:e,nodeName:this._isXHTML?t:t.toLowerCase(),id:n,type:this._type,multiple:a,nodeValue:r,value:o,selected:u,checked:i,indeterminate:l}),this._cache.props}},{key:"attr",value:function(e){return"function"!=typeof this.actualNode.getAttribute?null:this.actualNode.getAttribute(e)}},{key:"hasAttr",value:function(e){return"function"==typeof this.actualNode.hasAttribute&&this.actualNode.hasAttribute(e)}},{key:"attrNames",get:function(){var e;return this._cache.hasOwnProperty("attrNames")||(e=(this.actualNode.attributes instanceof t.NamedNodeMap?this.actualNode:this.actualNode.cloneNode(!1)).attributes,this._cache.attrNames=Array.from(e).map((function(e){return e.name}))),this._cache.attrNames}},{key:"getComputedStylePropertyValue",value:function(e){var n="computedStyle_"+e;return this._cache.hasOwnProperty(n)||(this._cache.hasOwnProperty("computedStyle")||(this._cache.computedStyle=t.getComputedStyle(this.actualNode)),this._cache[n]=this._cache.computedStyle.getPropertyValue(e)),this._cache[n]}},{key:"isFocusable",get:function(){return this._cache.hasOwnProperty("isFocusable")||(this._cache.isFocusable=Jo(this.actualNode)),this._cache.isFocusable}},{key:"tabbableElements",get:function(){return this._cache.hasOwnProperty("tabbableElements")||(this._cache.tabbableElements=ko(this)),this._cache.tabbableElements}},{key:"clientRects",get:function(){return this._cache.hasOwnProperty("clientRects")||(this._cache.clientRects=Array.from(this.actualNode.getClientRects()).filter((function(e){return 0<e.width}))),this._cache.clientRects}},{key:"boundingClientRect",get:function(){return this._cache.hasOwnProperty("boundingClientRect")||(this._cache.boundingClientRect=this.actualNode.getBoundingClientRect()),this._cache.boundingClientRect}}]);var $c,Hc=Vc,Uc=function(e){return(e||"").trim().replace(/\\s{2,}/g," ").split(" ")},Gc=" [idsMap]";function Wc(e,t,n){var a=e[0]._selectorMap;if(a){for(var r=e[0].shadowId,o=0;o<t.length;o++)if(1<t[o].length&&t[o].some(Yc))return;var u=new Set,i=(t.forEach((function(e){var t,n=function(e,t,n){var a=e[e.length-1],r=null,o=1<e.length||!!a.pseudos||!!a.classes;if(Yc(a))r=t["*"];else{if(a.id){if(!t[Gc]||null==(e=t[Gc][a.id])||!e.length)return;r=t[Gc][a.id].filter((function(e){return e.shadowId===n}))}if(a.tag&&"*"!==a.tag){if(null==(e=t[a.tag])||!e.length)return;e=t[a.tag];r=r?Kc(e,r):e}if(a.classes){if(null==(e=t["[class]"])||!e.length)return;e=t["[class]"],r=r?Kc(e,r):e}if(a.attributes)for(var u=0;u<a.attributes.length;u++){var i=a.attributes[u];if("attrValue"===i.type&&(o=!0),null==(l=t["[".concat(i.key,"]")])||!l.length)return;var l=t["[".concat(i.key,"]")];r=r?Kc(l,r):l}}return{nodes:r,isComplexSelector:o}}(e,a,r);null!=n&&null!=(t=n.nodes)&&t.forEach((function(t){n.isComplexSelector&&!la(t,e)||u.add(t)}))})),[]);return u.forEach((function(e){return i.push(e)})),(i=n?i.filter(n):i).sort((function(e,t){return e.nodeIndex-t.nodeIndex}))}}function Yc(e){return"*"===e.tag&&!e.attributes&&!e.id&&!e.classes}function Kc(e,t){return e.filter((function(e){return t.includes(e)}))}function Xc(e,t,n){n[e]=n[e]||[],n[e].push(t)}function Zc(e,t){1===e.props.nodeType&&(Xc(e.props.nodeName,e,t),Xc("*",e,t),e.attrNames.forEach((function(n){"id"===n&&(t[Gc]=t[Gc]||{},Uc(e.attr(n)).forEach((function(n){Xc(n,e,t[Gc])}))),Xc("[".concat(n,"]"),e,t)})))}function Jc(e,t,n){return Zc(e=new Hc(e,t,n),Kn.get("selectorMap")),e}function Qc(e,n,a){var r,o,u;function i(e,t,a){return(t=Qc(t,n,a))?e.concat(t):e}return u=(e=e.documentElement?e.documentElement:e).nodeName.toLowerCase(),ur(e)?($c=!0,r=Jc(e,a,n),n="a"+Math.random().toString().substring(2),o=Array.from(e.shadowRoot.childNodes),r.children=o.reduce((function(e,t){return i(e,t,r)}),[]),[r]):"content"===u&&"function"==typeof e.getDistributedNodes?(o=Array.from(e.getDistributedNodes())).reduce((function(e,t){return i(e,t,a)}),[]):"slot"===u&&"function"==typeof e.assignedNodes?((o=Array.from(e.assignedNodes())).length||(o=function(e){var t=[];for(e=e.firstChild;e;)t.push(e),e=e.nextSibling;return t}(e)),t.getComputedStyle(e),o.reduce((function(e,t){return i(e,t,a)}),[])):1===e.nodeType?(r=Jc(e,a,n),o=Array.from(e.childNodes),r.children=o.reduce((function(e,t){return i(e,t,r)}),[]),[r]):3===e.nodeType?[Jc(e,a)]:void 0}var ed=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:a.documentElement,t=1<arguments.length?arguments[1]:void 0,n=($c=!1,{});return Kn.set("nodeMap",new WeakMap),Kn.set("selectorMap",n),(e=Qc(e,t,null))[0]._selectorMap=n,e[0]._hasShadowRoot=$c,e},td=function(e){return e?e.trim().split("-")[0].toLowerCase():""},nd=function(e){var t={};return t.none=e.none.concat(e.all),t.any=e.any,Object.keys(t).map((function(e){var n;return t[e].length&&(n=o._audit.data.failureSummaries[e])&&"function"==typeof n.failureMessage?n.failureMessage(t[e].map((function(e){return e.message||""}))):void 0})).filter((function(e){return void 0!==e})).join("\\n\\n")};function ad(){var e=o._audit.data.incompleteFallbackMessage;return"string"!=typeof(e="function"==typeof e?e():e)?"":e}var rd=nn.resultGroups,od=function(e,t){var n=o.utils.aggregateResult(e);return rd.forEach((function(e){t.resultTypes&&!t.resultTypes.includes(e)&&(n[e]||[]).forEach((function(e){Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=[e.nodes[0]])})),n[e]=(n[e]||[]).map((function(e){return e=Object.assign({},e),Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=e.nodes.map((function(e){var n,a;return"object"===r(e.node)&&(e.html=e.node.source,t.elementRef&&!e.node.fromFrame&&(e.element=e.node.element),!1===t.selectors&&!e.node.fromFrame||(e.target=e.node.selector),t.ancestry&&(e.ancestry=e.node.ancestry),t.xpath)&&(e.xpath=e.node.xpath),delete e.result,delete e.node,n=e,a=t,["any","all","none"].forEach((function(e){Array.isArray(n[e])&&n[e].filter((function(e){return Array.isArray(e.relatedNodes)})).forEach((function(e){e.relatedNodes=e.relatedNodes.map((function(e){var t,n={html:null!=(n=null==e?void 0:e.source)?n:"Undefined"};return!a.elementRef||null!=e&&e.fromFrame||(n.element=null!=(t=null==e?void 0:e.element)?t:null),(!1!==a.selectors||null!=e&&e.fromFrame)&&(n.target=null!=(t=null==e?void 0:e.selector)?t:[":root"]),a.ancestry&&(n.ancestry=null!=(t=null==e?void 0:e.ancestry)?t:[":root"]),a.xpath&&(n.xpath=null!=(t=null==e?void 0:e.xpath)?t:["/"]),n}))}))})),e}))),rd.forEach((function(t){return delete e[t]})),delete e.pageLevel,delete e.result,e}))})),n},ud=/\\$\\{\\s?data\\s?\\}/g;function id(e,t){if("string"==typeof t)return e.replace(ud,t);for(var n in t){var a;t.hasOwnProperty(n)&&(a=new RegExp("\\\\${\\\\s?data\\\\."+n+"\\\\s?}","g"),n=void 0===t[n]?"":String(t[n]),e=e.replace(a,n))}return e}var ld=function e(t,n){var a;if(t)return Array.isArray(n)?(n.values=n.join(", "),"string"==typeof t.singular&&"string"==typeof t.plural?id(1===n.length?t.singular:t.plural,n):id(t,n)):"string"==typeof t?id(t,n):"string"==typeof n?id(t[n],n):(a=t.default||ad(),e(a=n&&n.messageKey&&t[n.messageKey]?t[n.messageKey]:a,n))},sd=function(e,t,n){var a=o._audit.data.checks[e];if(!a)throw new Error("Cannot get message for unknown check: ".concat(e,"."));if(a.messages[t])return ld(a.messages[t],n);throw new Error(\'Check "\'.concat(e,\'"" does not have a "\').concat(t,\'" message.\'))},cd=function(e,t,n){t=((n.rules&&n.rules[t]||{}).checks||{})[e.id];var a=(n.checks||{})[e.id],r=e.enabled;e=e.options;return a&&(a.hasOwnProperty("enabled")&&(r=a.enabled),a.hasOwnProperty("options"))&&(e=a.options),t&&(t.hasOwnProperty("enabled")&&(r=t.enabled),t.hasOwnProperty("options"))&&(e=t.options),{enabled:r,options:e,absolutePaths:n.absolutePaths}};function dd(){var e,n,a,u,i=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t;return i&&"object"===r(i)?i:"object"!==r(l)?{}:{testEngine:{name:"axe-core",version:o.version},testRunner:{name:o._audit.brand},testEnvironment:(i=l).navigator&&"object"===r(i.navigator)?(e=i.navigator,n=i.innerHeight,a=i.innerWidth,i=function(e){return(e=e.screen).orientation||e.msOrientation||e.mozOrientation}(i)||{},u=i.angle,i=i.type,{userAgent:e.userAgent,windowWidth:a,windowHeight:n,orientationAngle:u,orientationType:i}):{},timestamp:(new Date).toISOString(),url:null==(e=l.location)?void 0:e.href}}function pd(e,t){var n=t.focusable;t=t.page;return{node:e,include:[],exclude:[],initiator:!1,focusable:n&&(!(n=(n=e).getAttribute("tabindex"))||(n=parseInt(n,10),isNaN(n))||0<=n),size:function(e){var t=parseInt(e.getAttribute("width"),10),n=parseInt(e.getAttribute("height"),10);return(isNaN(t)||isNaN(n))&&(e=e.getBoundingClientRect(),t=isNaN(t)?e.width:t,n=isNaN(n)?e.height:n),{width:t,height:n}}(e),page:t}}function fd(e){var n=0<arguments.length&&void 0!==e?e:[],a=[];bd(n)||(n=[n]);for(var r=0;r<n.length;r++){var o=function(e){return e instanceof t.Node?e:"string"==typeof e?[e]:(hd(e)?(function(e){vd(Array.isArray(e.fromFrames),"fromFrames property must be an array"),vd(e.fromFrames.every((function(e){return!yd(e,"fromFrames")})),"Invalid context; fromFrames selector must be appended, rather than nested"),vd(!yd(e,"fromShadowDom"),"fromFrames and fromShadowDom cannot be used on the same object")}(e),e=e.fromFrames):gd(e)&&(e=[e]),function(e){if(Array.isArray(e)){var t,n=[],a=ee(e);try{for(a.s();!(t=a.n()).done;){var r=t.value;if(gd(r)&&(function(e){vd(Array.isArray(e.fromShadowDom),"fromShadowDom property must be an array"),vd(e.fromShadowDom.every((function(e){return!yd(e,"fromFrames")})),"shadow selector must be inside fromFrame instead"),vd(e.fromShadowDom.every((function(e){return!yd(e,"fromShadowDom")})),"fromShadowDom selector must be appended, rather than nested")}(r),r=r.fromShadowDom),"string"!=typeof r&&!function(e){return Array.isArray(e)&&e.every((function(e){return"string"==typeof e}))}(r))return;n.push(r)}}catch(e){a.e(e)}finally{a.f()}return n}}(e))}(n[r]);o&&a.push(o)}return a}function Dd(e){return["include","exclude"].some((function(t){return yd(e,t)&&md(e[t])}))}function md(e){return"string"==typeof e||e instanceof t.Node||hd(e)||gd(e)||bd(e)}function hd(e){return yd(e,"fromFrames")}function gd(e){return yd(e,"fromShadowDom")}function bd(e){return e&&"object"===r(e)&&"number"==typeof e.length&&e instanceof t.Node==0}function vd(e,t){Fn(e,"Invalid context; ".concat(t,"\\nSee: https://github.com/dequelabs/axe-core/blob/master/doc/context.md"))}function yd(e,t){return!(!e||"object"!==r(e))&&Object.prototype.hasOwnProperty.call(e,t)}function Fd(e,n){for(var a=[],r=0,o=e[n].length;r<o;r++){var u=e[n][r];u instanceof t.Node?u.documentElement instanceof t.Node?a.push(e.flatTree[0]):a.push(Xn(u)):u&&u.length&&(1<u.length?function(e,t,n){e.frames=e.frames||[],bp(n.shift()).forEach((function(a){var r=e.frames.find((function(e){return e.node===a}));r||(r=pd(a,e),e.frames.push(r)),r[t].push(n)}))}(e,n,u):(u=bp(u[0]),a.push.apply(a,H(u.map((function(e){return Xn(e)}))))))}return a.filter((function(e){return e}))}function wd(e,n){var o=this,u=(e=ea(e),this.frames=[],this.page="boolean"==typeof(null==(u=e)?void 0:u.page)?e.page:void 0,this.initiator="boolean"!=typeof(null==(u=e)?void 0:u.initiator)||e.initiator,this.focusable="boolean"!=typeof(null==(u=e)?void 0:u.focusable)||e.focusable,this.size="object"===r(null==(u=e)?void 0:u.size)?e.size:{},e=function(e){if(Dd(e)){var t=" must be used inside include or exclude. It should not be on the same object.";vd(!yd(e,"fromFrames"),"fromFrames"+t),vd(!yd(e,"fromShadowDom"),"fromShadowDom"+t)}else{if(!md(e))return{include:[a],exclude:[]};e={include:e,exclude:[]}}return 0===(t=fd(e.include)).length&&t.push(a),{include:t,exclude:e=fd(e.exclude)}}(e),this.flatTree=null!=n?n:ed(function(e){for(var n=e.include,r=(e=e.exclude,Array.from(n).concat(Array.from(e))),o=0;o<r.length;o++){var u=r[o];if(u instanceof t.Element)return u.ownerDocument.documentElement;if(u instanceof t.Document)return u.documentElement}return a.documentElement}(e)),this.exclude=e.exclude,this.include=e.include,this.include=Fd(this,"include"),this.exclude=Fd(this,"exclude"),mp("frame, iframe",this).forEach((function(e){var t;Sd(e,o)&&(t=o,Mu(e=e.actualNode))&&!Ja(t.frames,"node",e)&&t.frames.push(pd(e,t))})),void 0===this.page&&(this.page=function(e){return 1===(e=e.include).length&&e[0].actualNode===a.documentElement}(this),this.frames.forEach((function(e){e.page=o.page}))),this);if(0===u.include.length&&0===u.frames.length)throw u=Ga.isInFrame()?"frame":"page",new Error("No elements found for include in "+u+" Context");Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(Id)}function Ed(e){return!1===(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).iframes?[]:new wd(e).frames.map((function(e){var t=e.node;return(e=$(e,b)).initiator=!1,{frameSelector:Gn(t),frameContext:e}}))}var Cd=function(e){var t=o._audit.rules.find((function(t){return t.id===e}));if(t)return t;throw new Error("Cannot find rule by id: ".concat(e))};function xd(e){var n,a,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,o=e.scrollWidth>e.clientWidth+r;r=e.scrollHeight>e.clientHeight+r;if(o||r)return n=Ad(a=t.getComputedStyle(e),"overflow-x"),a=Ad(a,"overflow-y"),o&&n||r&&a?{elm:e,top:e.scrollTop,left:e.scrollLeft}:void 0}function Ad(e,t){return e=e.getPropertyValue(t),["scroll","auto"].includes(e)}var kd=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:t,n=e.document.documentElement;return[void 0!==e.pageXOffset?{elm:e,top:e.pageYOffset,left:e.pageXOffset}:{elm:n,top:n.scrollTop,left:n.scrollLeft}].concat(function e(t){return Array.from(t.children||t.childNodes||[]).reduce((function(t,n){var a=xd(n);return a&&t.push(a),t.concat(e(n))}),[])}(a.body))};function Bd(){return ea(Lo)}var Td,Nd=function(e){if(e)return function(t){var n=t.data,a=void 0!==(a=t.isCrossOrigin)&&a,r=t.shadowId,o=t.root,u=t.priority,i=(t=void 0!==(t=t.isLink)&&t,e.createElement("style"));return t?(t=e.createTextNode(\'@import "\'.concat(n.href,\'"\')),i.appendChild(t)):i.appendChild(e.createTextNode(n)),e.head.appendChild(i),{sheet:i.sheet,isCrossOrigin:a,shadowId:r,root:o,priority:u}};throw new Error("axe.utils.getStyleSheetFactory should be invoked with an argument")},Rd=function(e){var t;return Td&&Td.parentNode?(void 0===Td.styleSheet?Td.appendChild(a.createTextNode(e)):Td.styleSheet.cssText+=e,Td):e?(t=a.head||a.getElementsByTagName("head")[0],(Td=a.createElement("style")).type="text/css",void 0===Td.styleSheet?Td.appendChild(a.createTextNode(e)):Td.styleSheet.cssText=e,t.appendChild(Td),Td):void 0},_d=function e(n,a){var r,o=Xn(n);return 9!==n.nodeType&&(11===n.nodeType&&(n=n.host),o&&null!==o._isHidden?o._isHidden:!(r=t.getComputedStyle(n,null))||!n.parentNode||"none"===r.getPropertyValue("display")||!a&&"hidden"===r.getPropertyValue("visibility")||"true"===n.getAttribute("aria-hidden")||(a=e(n.assignedSlot||n.parentNode,!0),o&&(o._isHidden=a),a))},Od=function(e){var t=null!=(t=null==(t=e.props)?void 0:t.nodeName)?t:e.nodeName.toLowerCase();return"http://www.w3.org/2000/svg"!==e.namespaceURI&&!!Lo.htmlElms[t]};function Sd(e,t){var n=void 0===(n=t.include)?[]:n;t=void 0===(t=t.exclude)?[]:t;return 0!==(n=n.filter((function(t){return nr(t,e)}))).length&&(0===(t=t.filter((function(t){return nr(t,e)}))).length||(n=Md(n),nr(Md(t),n)))}function Md(e){var t,n,a=ee(e);try{for(a.s();!(n=a.n()).done;){var r=n.value;t&&nr(r,t)||(t=r)}}catch(e){a.e(e)}finally{a.f()}return t}var Pd=function(e,t){return e.length===t.length&&e.every((function(e,n){var a=t[n];return Array.isArray(e)?e.length===a.length&&e.every((function(e,t){return a[t]===e})):e===a}))},Id=function(e,t){return(e=e.actualNode||e)===(t=t.actualNode||t)?0:4&e.compareDocumentPosition(t)?-1:1};function jd(e){return e instanceof un?{vNode:e,domNode:e.actualNode}:{vNode:Xn(e),domNode:e}}var Ld,qd,zd=function(e,t,n,a){var r,o=4<arguments.length&&void 0!==arguments[4]&&arguments[4],u=Array.from(e.cssRules);return u?(r=u.filter((function(e){return 3===e.type}))).length?(r=r.filter((function(e){return e.href})).map((function(e){return e.href})).filter((function(e){return!a.includes(e)})).map((function(e,r){r=[].concat(H(n),[r]);var o=/^https?:\\/\\/|^\\/\\//i.test(e);return $d(e,t,r,a,o)})),(u=u.filter((function(e){return 3!==e.type}))).length&&r.push(Promise.resolve(t.convertDataToStylesheet({data:u.map((function(e){return e.cssText})).join(),isCrossOrigin:o,priority:n,root:t.rootNode,shadowId:t.shadowId}))),Promise.all(r)):Promise.resolve({isCrossOrigin:o,priority:n,root:t.rootNode,shadowId:t.shadowId,sheet:e}):Promise.resolve()},Vd=function(e,t,n,a){var r=4<arguments.length&&void 0!==arguments[4]&&arguments[4];return function(e){try{return!(!e.cssRules&&e.href)}catch(e){return!1}}(e)?zd(e,t,n,a,r):$d(e.href,t,n,a,!0)},$d=function(e,n,a,r,o){return r.push(e),new Promise((function(n,a){var r=new t.XMLHttpRequest;r.open("GET",e),r.timeout=nn.preload.timeout,r.addEventListener("error",a),r.addEventListener("timeout",a),r.addEventListener("loadend",(function(e){if(e.loaded&&r.responseText)return n(r.responseText);a(r.responseText)})),r.send()})).then((function(e){return e=n.convertDataToStylesheet({data:e,isCrossOrigin:o,priority:a,root:n.rootNode,shadowId:n.shadowId}),Vd(e.sheet,n,a,r,e.isCrossOrigin)}))};function Hd(){if(t.performance&&t.performance)return t.performance.now()}Ld=null,qd=Hd();var Ud,Gd,Wd={start:function(){this.mark("mark_axe_start")},end:function(){this.mark("mark_axe_end"),this.measure("axe","mark_axe_start","mark_axe_end"),this.logMeasures("axe")},auditStart:function(){this.mark("mark_audit_start")},auditEnd:function(){this.mark("mark_audit_end"),this.measure("audit_start_to_end","mark_audit_start","mark_audit_end"),this.logMeasures()},mark:function(e){t.performance&&void 0!==t.performance.mark&&t.performance.mark(e)},measure:function(e,n,a){t.performance&&void 0!==t.performance.measure&&t.performance.measure(e,n,a)},logMeasures:function(e){function n(e){an("Measure "+e.name+" took "+e.duration+"ms")}if(t.performance&&void 0!==t.performance.getEntriesByType)for(var a=t.performance.getEntriesByName("mark_axe_start")[0],r=t.performance.getEntriesByType("measure").filter((function(e){return e.startTime>=a.startTime})),o=0;o<r.length;++o){var u=r[o];if(u.name===e)return void n(u);n(u)}},timeElapsed:function(){return Hd()-qd},reset:function(){Ld=Ld||Hd(),qd=Hd()}};function Yd(){var e,t,n,r;return a.elementsFromPoint||a.msElementsFromPoint||((e=a.createElement("x")).style.cssText="pointer-events:auto",e="auto"===e.style.pointerEvents,t=e?"pointer-events":"visibility",n=e?"none":"hidden",(r=a.createElement("style")).innerHTML=e?"* { pointer-events: all }":"* { visibility: visible }",function(e,o){var u,i,l,s=[],c=[];for(a.head.appendChild(r);(u=a.elementFromPoint(e,o))&&-1===s.indexOf(u);)s.push(u),c.push({value:u.style.getPropertyValue(t),priority:u.style.getPropertyPriority(t)}),u.style.setProperty(t,n,"important");for(s.indexOf(a.documentElement)<s.length-1&&(s.splice(s.indexOf(a.documentElement),1),s.push(a.documentElement)),i=c.length;l=c[--i];)s[i].style.setProperty(t,l.value||"",l.priority);return a.head.removeChild(r),s})}function Kd(e){return"function"==typeof e||"[object Function]"===Ud.call(e)}function Xd(e){return e=function(e){return e=Number(e),isNaN(e)?0:0!==e&&isFinite(e)?(0<e?1:-1)*Math.floor(Math.abs(e)):e}(e),Math.min(Math.max(e,0),Gd)}"function"!=typeof Object.assign&&(Object.assign=function(e){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),n=1;n<arguments.length;n++){var a=arguments[n];if(null!=a)for(var r in a)a.hasOwnProperty(r)&&(t[r]=a[r])}return t}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var t,n=Object(this),a=n.length>>>0,r=arguments[1],o=0;o<a;o++)if(t=n[o],e.call(r,t,o,n))return t}}),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(e,t){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var n,a=Object(this),r=a.length>>>0,o=0;o<r;o++)if(n=a[o],e.call(t,n,o,a))return o;return-1}}),"function"==typeof t.addEventListener&&(a.elementsFromPoint=Yd()),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(e){var t=Object(this),n=parseInt(t.length,10)||0;if(0!==n){var a,r,o=parseInt(arguments[1],10)||0;for(0<=o?a=o:(a=n+o)<0&&(a=0);a<n;){if(e===(r=t[a])||e!=e&&r!=r)return!0;a++}}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,"some",{value:function(e){if(null==this)throw new TypeError("Array.prototype.some called on null or undefined");if("function"!=typeof e)throw new TypeError;for(var t=Object(this),n=t.length>>>0,a=2<=arguments.length?arguments[1]:void 0,r=0;r<n;r++)if(r in t&&e.call(a,t[r],r,t))return!0;return!1}}),Array.from||Object.defineProperty(Array,"from",{value:(Ud=Object.prototype.toString,Gd=Math.pow(2,53)-1,function(e){var t=Object(e);if(null==e)throw new TypeError("Array.from requires an array-like object - not null or undefined");var n,a=1<arguments.length?arguments[1]:void 0;if(void 0!==a){if(!Kd(a))throw new TypeError("Array.from: when provided, the second argument must be a function");2<arguments.length&&(n=arguments[2])}for(var r,o=Xd(t.length),u=Kd(this)?Object(new this(o)):new Array(o),i=0;i<o;)r=t[i],u[i]=a?void 0===n?a(r,i):a.call(n,r,i):r,i+=1;return u.length=o,u})}),String.prototype.includes||(String.prototype.includes=function(e,t){return!((t="number"!=typeof t?0:t)+e.length>this.length)&&-1!==this.indexOf(e,t)}),Array.prototype.flat||Object.defineProperty(Array.prototype,"flat",{configurable:!0,value:function e(){var t=isNaN(arguments[0])?1:Number(arguments[0]);return t?Array.prototype.reduce.call(this,(function(n,a){return Array.isArray(a)?n.push.apply(n,e.call(a,t-1)):n.push(a),n}),[]):Array.prototype.slice.call(this)},writable:!0}),!t.Node||"isConnected"in t.Node.prototype||Object.defineProperty(t.Node.prototype,"isConnected",{get:function(){return!(this.ownerDocument&&this.ownerDocument.compareDocumentPosition(this)&this.DOCUMENT_POSITION_DISCONNECTED)}});var Zd=function(e,t){return e.concat(t).filter((function(e,t,n){return n.indexOf(e)===t}))};function Jd(e,t,n,a,r){return(r=r||{}).vNodes=e,r.vNodesIndex=0,r.anyLevel=t,r.thisLevel=n,r.parentShadowId=a,r}var Qd=[],ep=function(e,t,n){if(a=Wc(e=Array.isArray(e)?e:[e],t=ia(t),n))return a;for(var a=e,r=(e=t,n),o=[],u=Jd(Array.isArray(a)?a:[a],e,null,a[0].shadowId,Qd.pop()),i=[];u.vNodesIndex<u.vNodes.length;){for(var l,s=u.vNodes[u.vNodesIndex++],c=null,d=null,p=((null==(l=u.anyLevel)?void 0:l.length)||0)+((null==(l=u.thisLevel)?void 0:l.length)||0),f=!1,D=0;D<p;D++){var m=D<((null==(m=u.anyLevel)?void 0:m.length)||0)?u.anyLevel[D]:u.thisLevel[D-((null==(m=u.anyLevel)?void 0:m.length)||0)];if((!m[0].id||s.shadowId===u.parentShadowId)&&la(s,m[0]))if(1===m.length)f||r&&!r(s)||(i.push(s),f=!0);else{var h=m.slice(1);if(!1===[" ",">"].includes(h[0].combinator))throw new Error("axe.utils.querySelectorAll does not support the combinator: "+m[1].combinator);(">"===h[0].combinator?c=c||[]:d=d||[]).push(h)}m[0].id&&s.shadowId!==u.parentShadowId||null==(h=u.anyLevel)||!h.includes(m)||(d=d||[]).push(m)}for(s.children&&s.children.length&&(o.push(u),u=Jd(s.children,d,c,s.shadowId,Qd.pop()));u.vNodesIndex===u.vNodes.length&&o.length;)Qd.push(u),u=o.pop()}return i},tp=function(e){var t,n,r,u;e=void 0===(e=e.treeRoot)?o._tree[0]:e;return t=[],e=ep(e=e,"*",(function(e){return!t.includes(e.shadowId)&&(t.push(e.shadowId),!0)})).map((function(e){return{shadowId:e.shadowId,rootNode:lr(e.actualNode)}})),(e=Zd(e,[])).length?(n=a.implementation.createHTMLDocument("Dynamic document for loading cssom"),n=Nd(n),r=n,u=[],e.forEach((function(e,t){var n=e.rootNode,a=function(e,t,n){return function(e){var t=[];return e.filter((function(e){if(e.href){if(t.includes(e.href))return!1;t.push(e.href)}return!0}))}(t=11===e.nodeType&&t?function(e,t){return Array.from(e.children).filter(np).reduce((function(n,a){var r=a.nodeName.toUpperCase();a="STYLE"===r?a.textContent:a,a=t({data:a,isLink:"LINK"===r,root:e});return n.push(a.sheet),n}),[])}(e,n):function(e){return Array.from(e.styleSheets).filter((function(e){return!!e.media&&ap(e.media.mediaText)}))}(e))}(n,e=e.shadowId,r);if(!a)return Promise.all(u);var o=t+1,i={rootNode:n,shadowId:e,convertDataToStylesheet:r,rootIndex:o},l=[];t=Promise.all(a.map((function(e,t){return Vd(e,i,[o,t],l)})));u.push(t)})),Promise.all(u).then((function e(t){return t.reduce((function(t,n){return Array.isArray(n)?t.concat(e(n)):t.concat(n)}),[])}))):Promise.resolve()};function np(e){var t=e.nodeName.toUpperCase(),n=e.getAttribute("href"),a=e.getAttribute("rel");n="LINK"===t&&n&&a&&e.rel.toUpperCase().includes("STYLESHEET");return"STYLE"===t||n&&ap(e.media)}function ap(e){return!e||!e.toUpperCase().includes("PRINT")}var rp=function(e){return e=void 0===(e=e.treeRoot)?o._tree[0]:e,e=ep(e,"video, audio",(function(e){return(e=e.actualNode).hasAttribute("src")?!!e.getAttribute("src"):!(Array.from(e.getElementsByTagName("source")).filter((function(e){return!!e.getAttribute("src")})).length<=0)})),Promise.all(e.map((function(e){var t;e=e.actualNode;return t=e,new Promise((function(e){0<t.readyState&&e(t),t.addEventListener("loadedmetadata",(function n(){t.removeEventListener("loadedmetadata",n),e(t)}))}))})))};function op(e){return!e||void 0===e.preload||null===e.preload||("boolean"==typeof e.preload?e.preload:(e=e.preload,"object"===r(e)&&Array.isArray(e.assets)))}function up(e){var t=(n=nn.preload).assets,n=n.timeout;n={assets:t,timeout:n};if(e.preload&&"boolean"!=typeof e.preload){if(!e.preload.assets.every((function(e){return t.includes(e.toLowerCase())})))throw new Error("Requested assets, not supported. Supported assets are: ".concat(t.join(", "),"."));n.assets=Zd(e.preload.assets.map((function(e){return e.toLowerCase()})),[]),e.preload.timeout&&"number"==typeof e.preload.timeout&&!isNaN(e.preload.timeout)&&(n.timeout=e.preload.timeout)}return n}var ip=function(e){var t={cssom:tp,media:rp};return op(e)?new Promise((function(n,a){var r=(o=up(e)).assets,o=o.timeout,u=setTimeout((function(){return a(new Error("Preload assets timed out."))}),o);Promise.all(r.map((function(n){return t[n](e).then((function(e){return t={},e=e,(a=Q(a=n))in t?Object.defineProperty(t,a,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[a]=e,t;var t,a}))}))).then((function(e){e=e.reduce((function(e,t){return G({},e,t)}),{}),clearTimeout(u),n(e)})).catch((function(e){clearTimeout(u),a(e)}))})):Promise.resolve()};function lp(e,t,n){return function(a){var o,u=(o=e[a.id]||{}).messages||{};delete(o=Object.assign({},o)).messages,n.reviewOnFail||void 0!==a.result?o.message=a.result===t?u.pass:u.fail:("object"!==r(u.incomplete)||Array.isArray(a.data)||(o.message=function(e,t){function n(e){return e.incomplete&&e.incomplete.default?e.incomplete.default:ad()}if(!e||!e.missingData)return e&&e.messageKey?t.incomplete[e.messageKey]:n(t);try{var a=t.incomplete[e.missingData[0].reason];if(a)return a;throw new Error}catch(a){return"string"==typeof e.missingData?t.incomplete[e.missingData]:n(t)}}(a.data,u)),o.message||(o.message=u.incomplete)),"function"!=typeof o.message&&(o.message=ld(o.message,a.data)),rr(a,o)}}var sp=function(e){var t=o._audit.data.checks||{},n=o._audit.data.rules||{},a=Ja(o._audit.rules,"id",e.id)||{},r=(e.tags=ea(a.tags||[]),lp(t,!0,a)),u=lp(t,!1,a);e.nodes.forEach((function(e){e.any.forEach(r),e.all.forEach(r),e.none.forEach(u)})),rr(e,ea(n[e.id]||{}))},cp=function(e,t){return ep(e,t)};function dp(e,t){var n,a=o._audit&&o._audit.tagExclude?o._audit.tagExclude:[],r=t.hasOwnProperty("include")||t.hasOwnProperty("exclude")?(n=t.include||[],n=Array.isArray(n)?n:[n],r=t.exclude||[],(r=Array.isArray(r)?r:[r]).concat(a.filter((function(e){return-1===n.indexOf(e)})))):(n=Array.isArray(t)?t:[t],a.filter((function(e){return-1===n.indexOf(e)})));return!!(n.some((function(t){return-1!==e.tags.indexOf(t)}))||0===n.length&&!1!==e.enabled)&&r.every((function(t){return-1===e.tags.indexOf(t)}))}var pp=function(e,t,n){var a=n.runOnly||{};n=(n.rules||{})[e.id];return!(e.pageLevel&&!t.page)&&("rule"===a.type?-1!==a.values.indexOf(e.id):n&&"boolean"==typeof n.enabled?n.enabled:"tag"===a.type&&a.values?dp(e,a.values):dp(e,[]))};function fp(e,t){var n,a,r;return t?(r=e.cloneNode(!1),n=Tn(r),r=1===r.nodeType?(a=r.outerHTML,Kn.get(a,(function(){return Dp(r,n,e,t)}))):Dp(r,n,e,t),Array.from(e.childNodes).forEach((function(e){r.appendChild(fp(e,t))})),r):e}function Dp(e,t,n,r){return t&&(e=a.createElement(e.nodeName),Array.from(t).forEach((function(t){var a,o,u;a=n,o=t.name,void 0!==(u=r)[o]&&(!0===u[o]||Nn(a,u[o]))||e.setAttribute(t.name,t.value)}))),e}function mp(e,t){var n=[];if(o._selectCache)for(var a=0,r=o._selectCache.length;a<r;a++){var u=o._selectCache[a];if(u.selector===e)return u.result}for(var i,l=t.include.reduce((function(e,t){return e.length&&nr(e[e.length-1],t)||e.push(t),e}),[]),s=(i=t).exclude&&0!==i.exclude.length?function(e){return Sd(e,i)}:null,c=0;c<l.length;c++){var d=l[c];n=function(e,t){if(0===e.length)return t;var n;e.length<t.length&&(n=e,e=t,t=n);for(var a=0,r=t.length;a<r;a++)e.includes(t[a])||e.push(t[a]);return e}(n,ep(d,e,s))}return o._selectCache&&o._selectCache.push({selector:e,result:n}),n}var hp=function(e){e.forEach((function(e){var n=e.elm,a=e.top;e=e.left;if(n===t)return n.scroll(e,a);n.scrollTop=a,n.scrollLeft=e}))};function gp(e){return function e(t,n){var a=t.shift();return n=a?n.querySelector(a):null,0===t.length?n:null!=n&&n.shadowRoot?e(t,n.shadowRoot):null}(Array.isArray(e)?H(e):[e],a)}function bp(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:a,n=Array.isArray(e)?H(e):[e];return 0===e.length?[]:function e(t,n){var a=(t=B(t))[0],r=t.slice(1);if(t=n.querySelectorAll(a),0===r.length)return Array.from(t);var o,u=[],i=ee(t);try{for(i.s();!(o=i.n()).done;){var l=o.value;null!=l&&l.shadowRoot&&u.push.apply(u,H(e(r,l.shadowRoot)))}}catch(e){i.e(e)}finally{i.f()}return u}(n,t)}var vp=function(){return["hidden","text","search","tel","url","email","password","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]},yp=[,[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,,,,,1,1,1,1,,,1,1,1,,1,,1,,1,1],[1,1,1,,1,1,,1,1,1,,1,,,1,1,1,,,1,1,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,,,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1],[,1,,,,,,1,,1,,,,,1,,1,,,,1,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,,,1,,,,,1,1,1,,1,,1,,1,,,,,,1],[1,,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,,1,,1,,,,,1,,1,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,,1,1,1,,1,,1,1,1,,,1,1,1,1,1,1,1,1],[,,1,,,1,,1,,,,1,1,1,,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1,1,1,1,1,,,1,1,1],[1,1,1,1,1,,,1,,,1,,,1,1,1,,,,,1,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,,1,1,,1,1,1,1,1,1,1,,1],[,1,,1,1,1,,1,1,,1,,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,,,1,1,1,,,1,1,,,,,,1,1],[1,1,1,,,,,1,,,,1,1,,1,,,,,,1,,,,,1],[,1,,,1,,,1,,,,,,1],[,1,,1,,,,1,,,,1],[1,,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,,1,,,1,1,1,1],[,1,1,1,1,1,,,1,,,1,,1,1,,1,,1,,,,,1,,1],[,1,,,,1,,,1,1,,1,,1,1,1,1,,1,1,,,1,,,1],[,1,1,,,,,,1,,,,1,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,,1,1,1,,,1,1,1,1,1,1,,1,,,,,1,1,,1,,1],[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,1,1],[,1,1,1,,,,1,1,1,,1,1,,,1,1,,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,,1,,,,,1,1,1,,,1,,1,,,1,1],[,,,,1,,,,,,,,,,,,,,,,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,,1,1,1,,1,1,,,,1,1,1,1,1,,,1,1,1,,,,,1],[1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,1,,,,,,,1],[,1,1,,1,1,,1,,,,,,,,,,,,,1],,[1,1,1,,,,,,,,,,,,,1],[,,,,,,,,1,,,1,,,1,1,,,,,1]],[,[1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,,1,1,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,,1],[,,,1,,,,,,,,,,,,,,,1],[,1,,,1,1,,1,,1,1,,,,1,1,,,1,1,,,,1],[1,,,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,,,,1],,[,1,1,1,1,1,,1,1,1,,1,1,,1,1,,,1,1,1,1,,1,1,,1],[,1,,,1,,,1,,1,,,1,1,1,1,,,1,1,,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,,,1,1,1,1,1,1,1,,,1,,,1,,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,,,,1],[,,,,,,,1,,,,1,,1,1],[,1,1,1,1,1,1,1,,,,1,1,1,1,1,,,1,1,,1,1,1,1,1],[,1,,,1,1,,1,,1,1,1,,,1,1,,,1,,1,1,1,1,,1],[,1,1,1,,1,1,,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1],[,,,,,,,,,,,,,,,,1],,[,1,1,1,1,1,,1,1,1,,,1,,1,1,,1,1,1,1,1,,1,,1],[,,1,,,1,,,1,1,,,1,,1,1,,1],[,1,1,,1,,,,1,1,,1,,1,1,1,1,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,1,,1,,1,1],,[,1,1,,1,,,1,,1,,,,1,1,1,,,,,,1,,,,1],[1,1,,,1,1,,1,,,,,1,,1]],[,[,1],[,,,1,,,,1,,,,1,,,,1,,,1,,,1],[,,,,,,,,,,,,,,,,,,1,1,,,,,,1],,[1,,,,,1],[,1,,,,1,,,,1],[,1,,,,,,,,,,,1,,,1,,,,,,,,,1,1],[,,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,1,,1],[,1],[,1,,1,,1,,1,,1,,1,1,1,,1,1,,1,,,,,,,1],[1,,,,,1,,,1,1,,1,,1,,1,1,,,,,1,,,1],[,1,1,,,1,,1,,1,,1,,1,1,1,1,,,1,,1,,1,1,1],[1,1,1,1,1,,1,,1,,,,1,1,1,1,,1,1,,,1,1,1,1],[1,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],,[,1,,,,,,1,1,1,,1,,,,1,,,1,1,1,,,1],[1,,,,,1,,1,1,1,,1,1,1,1,1,,1,,1,,1,,,1,1],[1,,1,1,,,,,1,,,,,,1,1,,,1,1,1,1,,,1,,1],[1,,,,,,,,,,,,,,,,,1],[,,,,,1,,,1,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,,,1],[,1,,,,1]],[,[1,1,1,,1,,1,1,1,1,1,1,1,1,1,,1,,1,,1,1,,,1,1,1],[,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],,[,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1],,[1,1,,,,1,1,,,,,,1,,,,1,,1,,1,1,,1],[1],[,,,,,,,,,,,1,,,,,,,,,,,1],[,1,,,,,,,1,1,,,1,,1,,,,1,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,,1],[,,1,,,,,1,,1],[1,,,,1,,,,,1,,,,1,1,,,,1,1,,,,,1],[,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[1,,,1,1,,,,,,,1,,1,,1,1,1,1,1,1],[,,,,,1,,,,,,,1,,,,,,,1],,[,,1,1,1,1,1,,1,1,1,,,1,1,,,1,1,,1,1,1,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,,,,1],,[1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,,,1,1,1,1,,,,,,1,,1,,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,,,,1,,1,,,1,1,1,1,1],[,,,,,,,,,,,1,,,,,,,,,1,,,,1],[,1,1,,1,1,,1,,,,1,1,,1,1,,,1,,1,1,,1],[,1,,1,,1,,,1,,,1,1,,1,1,,,1,1,1],[,1,1,1,1,1,,1,1,,,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,,,,,,,,,1,,1,,1,1,,,,1,,,1],[,1,,,1,1,,,,,,,,,1,1,1,,,,,1],[1,,,1,1,,,,1,1,1,1,1,,,1,,,1,,,1,,1,,1],[,1,1,,1,1,,1,1,,,,1,1,1,,,1,1,,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,,,,1,,,,,,,,,1],[,1,,,,,,,,1,,,,,1,,,,1,,,1],[,1,1,1,1,,,1,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1],[,,,,,1,,1,,,,,1,1,1,1,1,,,1,,,,1],[,1,,,,,,,,1,,,,,,,,,,,,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,1,,,,1,,1,1,1,1,1,,1,1,,,,,,1],[,1,1,1,1,1,1,1,,1,1,,,1,1,,,,1,,1,1,,1,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,1,1,,1,,,1,1,1,1,,,1,,,,,,,1],[,1,,,,,,,,1,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1],[,1,1,,,,,,,,,,,,1,1,,,,,,1],[,1,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,,,,,1],[1,1,,,1,,,1,1,1,,,,1],,[,,,,,,,,,,,,,1,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,1,,,,,,,1],[1,1,1,,1,,1,1,1,1,1,1,1,1,,1,,,1,,1,,,1,1],[,,,,,,,,,1],[,1,,,,1,,,,,,1,,,1,,,,,1],[,1,1,,1,1,,,,,,,,,,,,,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,1,1,1,,,,1,1,,,,1,,1],[1,1,1,1,1,1,,,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,,1,1],[,,,,,,,,,,,,,,,1,,,,1],,[1,1,,1,,1,,,,,,1,,1,,1,1,,1,,1,1,,1,1,,1],[,,1,,,,,,1,,,,1,,1,,,,,1],[1,,,,,,,,,1,,,,,,1,,,,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,,1,,,,,,1,,,1,,,,,,,,1],[,1,,1,,,,,,,,,,,,1],,[1,1,,,,,,,,,,,,,,,,,,,,,,1,1],[1]],[,[1,,,,,,,,,1,,,,,1,,1,,1],[,1,1,,1,1,,1,1,1,,,1,1,1,,,,1,,,1,,,,1],[,1,,,,,,,1,,,,1,,,,,,1],[1,1,1,1,1,1,,,,1,,,,,,,,,1,1,1,1],[1],[,1,1,,,1,1,,,,,1,,1,,,,,,,,1,,,,1],[1,,1,,,1,,1,,,,,1,1,1,1,,,,1,,,,1],[,,1,,,,,,,1,,,,,,,1,,,,,,,1],[1,,,,,,,,,,,,,,1,,,,1],[,,,1,,1,,,,,1,,,,1,1,,,,1],[1,,,,,1,,,,1,,1,1,,,1,1,,1,1,1,,1,1,1,,1],[,1,1,,,,,1,,1,,1,1,1,,1,1,,,1,,1,1,1],[,1,,,,1,,,,1,,,1,,1,1,,,1,1,,,,,,1],[1,,1,1,,1,,1,1,,1,,1,1,1,1,1,,,1,1,,,,,,1],[1,,,,,,,,,,,,,,,,,,1,,,1,,1],[,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,,1,,1],[,1,,,,1,,,1,1,,1,,,1,1,,,1,,,1,,,1,1],[1,1,,1,1,1,,1,1,1,,1,,1,1,1,,,1,,1,1],[1,,1,1,1,1,,,,1,,1,1,1,,1,,,1,1,1,,1,1,1,1,1],[1,,,,,,,,,,,,,1],[,,1,,,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,,,1,,1,,1,,,,1],[,,,1,,,,,,,,,1],[,1,,,,,,,,,,,,,,1,,,,,,,,,1],[,,,,,,,,1,1,,,,,,,,,1,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,,,1,1,1],[,,,,,1,,,,1,1,1,,,1,1,,,1,,1,1,,1],[,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,1,,,,,,,,,,,,,1],[,,1,,,1,,1,1,1,,1,1,,1,,,,1,,1,1],,[,,1,,,1,,,,,,1,,,,1],[,,,,,,,,,1,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,,1,1,,1,,1,,,1,1,1,,,1],[,,,,,1,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,1,,1,1,,1,,,1],[,,,,,1,,,,,,,,,,,,,,1],[,1,1,1,1,,,,,1,,,1,,1,,,,1,1,,,,1,1],[,1,,,1,,,1,,1,1,,1,,,,,,,1],[,,1,,1,,,1,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,,,,,,,,,,1,,1,1],[,,,,,,,,,,,,1],,[,1,1,1,1,,,,1,1,,1,1,1,1,1,1,,1,1,1,1,,1,,1],[1,,,,1,,,,,,,,,,1],[1,,,,,,,,,1],,[,1,,,,1,,,,,,,,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,,1,,,,1,1,,,1,1,,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,1],[1,1,1,,,,,1,1,1,,1,1,1,1,,,1,1,,1,1,,,,,1],[,1,,,,,,,1,1,,,1,1,1,,1,,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,,,1,,,,1,,,1,,,,1,,,,,,,1,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1],[1,1,1,,1,,,1,1,1,1,,1,1,1,1,,,,1,,1,,1,,,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,,1,1,,,,,,,,,1],,[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,,1,,1,,,,1],[,1,,,1,1,,1,1,1,,,1,1,1,1,1,,1,1,1,,1,,,1],[1,,,1,,,,1,1,1,,,,,1,1,,,,1,,1],[1,1,,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,,1,,1,,,,,,,,1,,1],[,1,,,,1,,1,1,,,,1,1,,1,,,,1,1,1,,1],,[,1,,,,,,1,,,,,,,1],[,,,,,,,,1,,,,1,,1,,,,,,,,,,,,1]],[,[,1,1,,1,1,1,1,,1,1,1,,1,1,,1,1,,1,1,1,1,1,1,,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,,,1,,,,,,,,1,,,,,,1,,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,,1,,1,1,1,1,1,1,1,,1,1,,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1],[,1,1,,,,,1,1,1,,,1,,1,1,,,,1,,1,,,1,1],[,,,,,,,1,,,,1,1,1,1,1,,1,,,,,,,,1],[1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,,1,,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,1,1,,1,,1,1,1,,1,,1,1,,1,1,,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,,1,,,,,1,,1],[,1,1,1,,1,,1,,1,,,,1,,1,,,1,,,,,,1,1],[,1,,,1,1,,1,,1,,1,1,1,1,1,,1,1,,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,,1,,1,,1,,,,,,1,,1,,,,1,1]],[,[,1,,1,,,,,,,,,,,,,,,1,,,,1],[,,,,,,,,,1,,1,1,1,,1,,,1,,1,1],[1,1,,,,,,,1,,,,,,,1,,,,,,1],[,1,,,,,,,,,,1,,,,,,,,,1,1],,[,,,,,,,,,,,,,,,1,,,,1,,1],[,,1,1,,1,,1,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,,,,,,,,1],[1,,1,1,,,,1,,,,,,,,,1,,,1,,,1,1],[,1,1,,1,1,,1,1,1,1,1,1,1,1,1,,,1,1,,1,1,,1],[,1,,,1,1,,,,,,1,,1,,1,,,1,,1,1],[1,1,1,1,,1,,1,,1,,1,1,,1,1,1,1,1,,1,1,1,1,1],[,1,1,,,1,,1,,1,1,1,,,1,1,1,,1,1,1,1,,1,1],[,,,,1,,,1,,,,,,,1,,,,1,1],[,1,,,,,,,,,,1,,1,,1,,,,,1,,,,,1],,[1,1,,1,,1,,1,1,,,,,,1,1,,,1,1,1,1,1,1,1,1,1],[1,1,,1,,,,,,1,,,,,,1,1,,,,1,1,,,1],[,1,1,,1,1,,,,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,,,1,,,,1,,,,1,1],[,,,,1],[,,,,,,,,,1,,,1],,[,,1,,1,,,,,,,,,1,,,,,,,,,,,,1],[,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,,,1],[,1,,1,,,,,,1,,,,,1,1,,,,,1,1],[,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,,,1,,1,1,1],[,1,,,,1,,,,,,,1],[,1,,,1,,,1,,1,,1,1,,1,,,,,1,,1,,,,1,1],[,1,,,1,,,1,1,1,,1,1,1,1,1,,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,1,1,,,,1,1,,,,,,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,,1,1,,1,1,1,1,1],[,1,,,,1,,,,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,1,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,,1,1,1,,1,1,1,,,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,,,,,,,1,1,,,,,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,1,,1,1,1,1],,[,1,1,,,,,1,,1,,,,1,1,1,,,1,,,,,1],[,,,,,,,,,,,,,1],[,,,,,1,,,,,,,,1,1,,,,,1,,1,,,1,1],[,,,,,,,,,,,,,,1]],[,[,1],,,,,,,,,,,,,,,,,,,,[1,1,1,1,1,,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,1,1,1,1],[,1,,1,,1,,,1,1,1,,1,1,1,1,1,,,1,,,,1,,1,1],[,1,,1,,1,,,1,,,,,1,,,,,,1,1],[,1,,1,,,,,1,,,,1,,1,1,1,1,1,1,1,1,,1],[,1,,,,,,,,,,,,,,,1]],[,[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,,,,,,,,,1,1,,,,1],[,,,,,,1],[,,1],[,1,1,,,1,,1,,1,1,,1,1,1,,,,1,1,1,,,,,1],,[,1,,,,1,,,,,,1,,,1,,,,1,1,,1],[,,,,,,,1,,,,,,,,,1],[,1,,,,1,1,,,,,,1,1,1,,,,1,,1,1],[,,,,,,,1,,1,,,,,,,,,,1],[,1,1,,,,,,1,1,,,,1,,,,,,,1,,,1],,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,,1,,,1,,,,,1,,1,,1,,1,,,,,1],[1,1,1,1,1,1,1,1,,,,,1,1,,1,1,,1,,,1,,1],[,,,,,,,,,,,,,,1,,,,,,1],,[,,,,,,,,,1,,,,,,1,,,,,1],[,,1,,,,,,,1,,,1,1],[,,,1,,,,,1,,,,,1,,,,,,1,,,,1],[1,,1,1,,1,1,1,1,1,,1,,,,1,1,1,,,1,1,,,,1,1],,[1,1,,,,,,,,,,1,,1,,1,,,1],[,,,,1,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,1],[,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,,1,,,1,,,,,,,,1,,,,,,1,,,,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,1,,,,1,1,1,1,1,1,,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,1,,1,1,,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,,1,,1,,1,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,,,,,,1,,1,,,,,1,1,,,,,1],[1,,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,,1,,,,1,1,1,1,1,,,1,1,,1,,1],[,1,1,1,1,,,,,1,,1,1,1,1,1,,,1,1,,,,1,1,1],[,1,1,1,1,1,,1,,,,,1,,1,,1,,,1,,,1,1,,1]],[,[1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,,,,,1,,,,,1,1,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,,,,1,,1,1,,1,1,1,1,1,,,1,,1,,1],[1,1,1,,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,,1,,,,,,,,,,1,1,1,1,1,1,1,,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,1,1,,,,,,1,1,1,1,1,,,,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,,1,1,1],[,1,1,1,,1,,1,1,1,1,,,1,1,1,,1,1,1,1,1,,,1,1],[1,1,,,,1,,,1,1,1,,1,,1,,1,,1,1,1,1,1,,1,,1],[,1,,,,,,,1,,1,,1,1,1,1,,,,,,,,,1]],[,[,,,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,1,,,1,,,,,,1,,,1,,,,1],,[,1,,,,1,,1,,1,1,,1,1,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],[1,1,1,,,1,,,,,,,,,1,1,,,,,,,,,,1],[,1,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1,,,1],[,,,,,,,,,1],[1,1,,,,,,1,1,1,,1,1,,,,1,1,,1,,1,1,1,,1],[,1,1,1,,1,1,,,1,,1,1,1,1,,,,,,,1,,1],[,1,1,1,1,,,1,,1,,,,1,1,1,1,,1,1,,1],[,1,,,1,1,,1,,,,1,,1,1,,1,,1,,,1,,,1,,1],[,,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,,,,,1],,[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1],[,1,,,,,,,1,1,,1,,,,,1,,,1,,1],[,1,,,,1,,,1,,,,,,,,1,,1,,,1],[,,,,,,,,,,,,,1,1,,,,1,,,1],[,,,,,1,,,1,,,,1],[,1],,[,1],[1,,,,,,,,,,,,,,1,,,,,1]],[,[,1,,,,1,1,1,1,1,1,,1,1,1,1,1,,1,1,,1,1,,,1],[,,1,,,,,,,,,1],,,[1,,,1,1,,,,,,,,1,1,,1,1,,1],,[,,,,,,,,,,,,,,,,,,1,,1],,[1,,,1,1,,1,1,,,,,1,,1,,,,,1,1,,1],,[,1,,,,,,,,1,1,1,1,1,,1,1,,,,1,1],[,,,,,,,,,,,,,,,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,,1,1,1,1,1,1],[,,,,,,,,,,,1,,1,,,1],[1,,,,,,,,,,,,,,,,,,1,,1],,,[,1,,,,,,,,,,,,,,1,,,,1,1],[,,,,,,,,,1,,,1,,,,,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,1,1,,,,,,1],,[,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,1,1,,1,1,1,1,1,1,,,1,1,1,1,1,,1,1],[,1,,,,,,,,1],[,,,,1,,,1,,,1,1,,,,,,,,,,1,,,,1],[,1,,1,1,,,1,1,1,,,,1,1,1,1,,1,1,1,1,,1],[,,,,,,,1],[,1,1,,,,,1,,1,,,,,,1,,,,,,1,,1,,1],[,1,,,,,,1,,,,1,,,,,,,,,,1],[,,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1,1,1,1,,1],[,1,,,,,,,,1],[,1,1,,1,,,,,,,,1,,,,,,1,,,1,,1,,1],[,1,,1,,1,,1,1,1,,1,1,1,,1,,,1,1,,1,1,1,1,1],[,1,1,1,1,1,,,1,1,,,,1,1,1,,,,1,1,,,1,1],[,,1,1,1,1,,1,,1,,1,,1,1,1,1,,,,,1,,1,,1],[1,1,1,1,1,1,1,1,,1,,1,,1,1,1,,,1,1,,,,1,,1],[,,,1],,[,1,1,,1,,,1,1,1,,1,1,1,1,1,1,,1,1,,1,1,1,1,1,1],[,1,,,,,,1,,1,,1,,,,,,,1,1,,1,1],[,,,,,,1,,1,1,,1,,1,,,,,,,,,,1],[,1,1,,1,,,,1,,,,1,1,1,,,,1,,1,1,1,,1,1],,[,1,1,,,,,,,,,,,,,1,,,1,,,,,1],[,1,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,1,,,,1,,,,,1,,,,,,,1]],[,[,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[,1,1,1,1,1,,1,,1,1,,,1,1,1,1,,1,,,,,1,1,1],[,,1,1,,1,,1,1,,,,1,1,1,1,,,1,,1,1,1,1,,1],[,1,,1,,,,,,,,1,,1,,1,,,,,,,,,,1],[,,1,,1,,,1,,,,,1,1,,,1,,1,1,1,1],[,1],[,1,1,,1,,1,1,,1,,,1,1,1,,,,1,,,1,,1],[1,1,,1,1,1,,,,,,,,,,,,,1,,1,1,1],[,1,1,,,,,,,1,,,1,,1,,1,,1,1,,,1,,,1],[,,1,,,,,,,,,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,,1,,,,,1,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,,1,,1,1,1,,,1,1,1,1,,,,1,1],[,,,1,1,,,1,,1,,1,,1,1,1,1,,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,,1,,1,,,,1,1,,,1,1,,1,1,,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1,,1,1,,,1],[,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,,1,,,1,,,1,,1,1,1,1,1,,1,,1,1],[,,,,,1,,,,1,,,,,1,1,,,,1],[,1,,1,1,1,,1,,,1,1,1,,,1,,,1,,1,,,1],[,,1,,,,,,,,,1,,1,,,,,1,,1],[,1,1,,,,,,,,1,1,1,,,,,,,,1,,,,,1],[,,,,,,,,1,,,,,1,,,1]],[,[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,,1,1,1,1,1,1,1,1,,,,,,,,,1,1],[,,,,,,,,1,,,,1,,1,,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,1,,1,,1,,,,1,1,,1,,1,,,,1,1,1,1,1,,,1],,[,1,,,,,,,,1,,,1,1,,,1,,1,1,,1,,1],[,1,,,1,,,,,,,,1,,,,,,,1],[1,1,,,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1],,[,1,,,,,,1,,1,,1,1,1,1,1,,,1,,1,1,,,,1],[,1,1,,,1,,1,,1,,,1,1,1,1,,,1,,,1,,,,1],[,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1],[,1,,,1,1,,1,1,,,1,1,,1,1,,1,,1,,1],[1,,1,,,,,1,,1,,1,1,1,1,,,,,1,1,,,,1,1],[,1,1,,,,,1,1,,,1,,1,1,1,1,,,,,,,,,,1],,[,1,1,,,1,,,,1,,1,1,1,1,1,,,,1,,,,1,,1],[,,,1,1,,,1,,,,,1,,1,1,1,,1,1,,,,,,1],[,1,,,,,,,,,,,1,,,,1,,,,,,,1,,1],[,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,1,,,,,1,,1,,,1,1,,1,1,,1],[,1,,,,,,1,,,,,1,1,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1,,,1,,,,,1],[,,,,,,,1,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,,1,,,,,,,1,,,,,,,,1,,,1],[,1,,,,,,,1],[,,,,,,,,,,1],[,1,,,,,,1,1,,,,,,1],,[,1,1,,,,,,1,,,,,1,1,,,,1],[1,,1,,1,,,,,1,,,,,1,,,,,,,,,1,1],[,1,1,,,,,,,,,1,1,1,1,,,,1,,,,,1,,,1],,[,1,1,,1,,,1,1,,,1,,,1,1,1,,1,,1,1,1,,,,1],[,,,,,1,,,,,1,,,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,,,1,,,,,1,,,,,1,,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,1],[,1,,,,,,1,,,,,,,1,1,1,,,1],[,1,,,,,,,,,,1,1,1,,,,,1,,,1],[,,,,,1,,1,,,,,1,1,1,,1,1,,1,1,1,,,1,1],[1,1,,,,,,,1,,,,,1,1,,,,,,,,,,,1],,[,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,,1,,,,,1,,,1,,,,1,,1],[,1,,,,,,,,,1]]];function Fp(e){e=Array.isArray(e)?e:yp;var t=[];return e.forEach((function(e,n){var a=String.fromCharCode(n+96).replace("`","");Array.isArray(e)?t=t.concat(Fp(e).map((function(e){return a+e}))):t.push(a)})),t}var wp,Ep=function(e){for(var t=yp;e.length<3;)e+="`";for(var n=0;n<=e.length-1;n++)if(!(t=t[e.charCodeAt(n)-96]))return!1;return!0};N(Cp,un),wp=_(Cp),J(Cp,[{key:"props",get:function(){return this._props}},{key:"attr",value:function(e){return null!=(e=this._attrs[e])?e:null}},{key:"hasAttr",value:function(e){return void 0!==this._attrs[e]}},{key:"attrNames",get:function(){return Object.keys(this._attrs)}}]),os=Cp;function Cp(e){var t,n,a;return X(this,Cp),(t=wp.call(this))._props=function(e){var t=null!=(t=e.nodeName)?t:kp[e.nodeType],n=null!=(n=null!=(n=e.nodeType)?n:Ap[e.nodeName])?n:1,a=(Fn("number"==typeof n,"nodeType has to be a number, got \'".concat(n,"\'")),Fn("string"==typeof t,"nodeName has to be a string, got \'".concat(t,"\'")),t=t.toLowerCase(),null);return"input"===t&&(a=(e.type||e.attributes&&e.attributes.type||"").toLowerCase(),vp().includes(a)||(a="text")),e=G({},e,{nodeType:n,nodeName:t}),a&&(e.type=a),delete e.attributes,Object.freeze(e)}(e),t._attrs=(e=(e=e).attributes,n=void 0===e?{}:e,a={htmlFor:"for",className:"class"},Object.keys(n).reduce((function(e,t){var o=n[t];return Fn("object"!==r(o)||null===o,"expects attributes not to be an object, \'".concat(t,"\' was")),void 0!==o&&(e[a[t]||t]=null!==o?String(o):null),e}),{})),t}var xp,Ap={"#cdata-section":2,"#text":3,"#comment":8,"#document":9,"#document-fragment":11},kp={},Bp=(Object.keys(Ap).forEach((function(e){kp[Ap[e]]=e})),os),Tp=function(e,t){if(e=e||function(){},t=t||o.log,!o._audit)throw new Error("No audit configured");var n=o.utils.queue(),r=[],u=(Object.keys(o.plugins).forEach((function(e){n.defer((function(t){function n(e){r.push(e),t()}try{o.plugins[e].cleanup(t,n)}catch(e){n(e)}}))})),o.utils.getFlattenedTree(a.body));o.utils.querySelectorAll(u,"iframe, frame").forEach((function(e){n.defer((function(t,n){return o.utils.sendCommandToFrame(e.actualNode,{command:"cleanup-plugin"},t,n)}))})),n.then((function(n){0===r.length?e(n):t(r)})).catch(t)},Np={};function Rp(e){return Np.hasOwnProperty(e)}function _p(e){return"string"==typeof e&&Np[e]?Np[e]:"function"==typeof e?e:xp}var Op={},Sp=(re(Op,{allowedAttr:function(){return Sp},arialabelText:function(){return _o},arialabelledbyText:function(){return Ro},getAccessibleRefs:function(){return Pp},getElementUnallowedRoles:function(){return qp},getExplicitRole:function(){return Vo},getImplicitRole:function(){return gu},getOwnedVirtual:function(){return xu},getRole:function(){return Fu},getRoleType:function(){return ki},getRolesByType:function(){return Vp},getRolesWithNameFromContents:function(){return Gp},implicitNodes:function(){return Yp},implicitRole:function(){return gu},isAccessibleRef:function(){return Kp},isAriaRoleAllowedOnElement:function(){return Ip},isComboboxPopup:function(){return Xp},isUnsupportedRole:function(){return qo},isValidRole:function(){return zo},label:function(){return Jp},labelVirtual:function(){return ui},lookupTable:function(){return Wp},namedFromContents:function(){return Cu},requiredAttr:function(){return Qp},requiredContext:function(){return ef},requiredOwned:function(){return tf},validateAttr:function(){return af},validateAttrValue:function(){return nf}}),function(e){e=Lo.ariaRoles[e];var t=H(Ho());return e&&(e.allowedAttrs&&t.push.apply(t,H(e.allowedAttrs)),e.requiredAttrs)&&t.push.apply(t,H(e.requiredAttrs)),t}),Mp=/^idrefs?$/,Pp=function(e){e=e.actualNode||e;var t=(t=sr(e)).documentElement||t,n=Kn.get("idRefsByRoot",(function(){return new WeakMap})),a=n.get(t);return a||(n.set(t,a={}),function e(t,n,a){if(t.hasAttribute){var r;"LABEL"===t.nodeName.toUpperCase()&&t.hasAttribute("for")&&(n[r=t.getAttribute("for")]=n[r]||[],n[r].push(t));for(var o=0;o<a.length;++o){var u=a[o];if(u=Xo(t.getAttribute(u)||""))for(var i=Uc(u),l=0;l<i.length;++l)n[i[l]]=n[i[l]]||[],n[i[l]].push(t)}}for(var s=0;s<t.childNodes.length;s++)1===t.childNodes[s].nodeType&&e(t.childNodes[s],n,a)}(t,a,Object.keys(Lo.ariaAttrs).filter((function(e){return e=Lo.ariaAttrs[e].type,Mp.test(e)})))),a[e.id]||[]},Ip=function(e,t){e=e instanceof un?e:Xn(e);var n=gu(e);e=hu(e);return Array.isArray(e.allowedRoles)?e.allowedRoles.includes(t):t!==n&&!!e.allowedRoles},jp=["doc-backlink","doc-biblioentry","doc-biblioref","doc-cover","doc-endnote","doc-glossref","doc-noteref"],Lp={header:"banner",footer:"contentinfo"},qp=function(e){var t,n,a,r=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],o=jd(e).vNode;return Od(o)?(a=o.props.nodeName,t=gu(o)||Lp[a],a=[],((n=o)?(n.hasAttr("role")&&(n=Uc(n.attr("role").toLowerCase()),a=a.concat(n)),a.filter((function(e){return zo(e)}))):a).filter((function(e){var n=o,a=t;return!(r&&e===a||(!jp.includes(e)||ki(e)===a)&&Ip(n,e))}))):[]},zp=function(e){return Object.keys(Lo.ariaRoles).filter((function(t){return Lo.ariaRoles[t].type===e}))},Vp=function(e){return zp(e)},$p=function(){return Kn.get("ariaRolesNameFromContent",(function(){return Object.keys(Lo.ariaRoles).filter((function(e){return Lo.ariaRoles[e].nameFromContent}))}))};function Hp(e){return null===e}function Up(e){return null!==e}var Gp=function(){return $p()},Wp=((Pl={attributes:{"aria-activedescendant":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-atomic":{type:"boolean",values:["true","false"],unsupported:!1},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"],unsupported:!1},"aria-busy":{type:"boolean",values:["true","false"],unsupported:!1},"aria-checked":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-colcount":{type:"int",unsupported:!1},"aria-colindex":{type:"int",unsupported:!1},"aria-colspan":{type:"int",unsupported:!1},"aria-controls":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],unsupported:!1},"aria-describedby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-describedat":{unsupported:!0,unstandardized:!0},"aria-details":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-disabled":{type:"boolean",values:["true","false"],unsupported:!1},"aria-dropeffect":{type:"nmtokens",values:["copy","move","reference","execute","popup","none"],unsupported:!1},"aria-errormessage":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-flowto":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],unsupported:!1},"aria-hidden":{type:"boolean",values:["true","false"],unsupported:!1},"aria-invalid":{type:"nmtoken",allowEmpty:!0,values:["true","false","spelling","grammar"],unsupported:!1},"aria-keyshortcuts":{type:"string",allowEmpty:!0,unsupported:!1},"aria-label":{type:"string",allowEmpty:!0,unsupported:!1},"aria-labelledby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-level":{type:"int",unsupported:!1},"aria-live":{type:"nmtoken",values:["off","polite","assertive"],unsupported:!1},"aria-modal":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiline":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiselectable":{type:"boolean",values:["true","false"],unsupported:!1},"aria-orientation":{type:"nmtoken",values:["horizontal","vertical"],unsupported:!1},"aria-owns":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-placeholder":{type:"string",allowEmpty:!0,unsupported:!1},"aria-posinset":{type:"int",unsupported:!1},"aria-pressed":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-readonly":{type:"boolean",values:["true","false"],unsupported:!1},"aria-relevant":{type:"nmtokens",values:["additions","removals","text","all"],unsupported:!1},"aria-required":{type:"boolean",values:["true","false"],unsupported:!1},"aria-roledescription":{type:"string",allowEmpty:!0,unsupported:!1},"aria-rowcount":{type:"int",unsupported:!1},"aria-rowindex":{type:"int",unsupported:!1},"aria-rowspan":{type:"int",unsupported:!1},"aria-selected":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-setsize":{type:"int",unsupported:!1},"aria-sort":{type:"nmtoken",values:["ascending","descending","other","none"],unsupported:!1},"aria-valuemax":{type:"decimal",unsupported:!1},"aria-valuemin":{type:"decimal",unsupported:!1},"aria-valuenow":{type:"decimal",unsupported:!1},"aria-valuetext":{type:"string",unsupported:!1}},globalAttributes:["aria-atomic","aria-busy","aria-controls","aria-current","aria-describedby","aria-details","aria-disabled","aria-dropeffect","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-keyshortcuts","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant","aria-roledescription"]}).role={alert:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},alertdialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["dialog","section"]},application:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage","aria-activedescendant"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","audio","embed","iframe","object","section","svg","video"]},article:{type:"structure",attributes:{allowed:["aria-expanded","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["article"],unsupported:!1},banner:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["header"],unsupported:!1,allowedElements:["section"]},button:{type:"widget",attributes:{allowed:["aria-expanded","aria-pressed","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["button",\'input[type="button"]\',\'input[type="image"]\',\'input[type="reset"]\',\'input[type="submit"]\',"summary"],unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:Up}}]},cell:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},checkbox:{type:"widget",attributes:{allowed:["aria-checked","aria-required","aria-readonly","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:[\'input[type="checkbox"]\'],unsupported:!1,allowedElements:["button"]},columnheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},combobox:{type:"composite",attributes:{allowed:["aria-autocomplete","aria-required","aria-activedescendant","aria-orientation","aria-errormessage"],required:["aria-expanded"]},owned:{all:["listbox","tree","grid","dialog","textbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:"input",properties:{type:["text","search","tel","url","email"]}}]},command:{nameFrom:["author"],type:"abstract",unsupported:!1},complementary:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["aside"],unsupported:!1,allowedElements:["section"]},composite:{nameFrom:["author"],type:"abstract",unsupported:!1},contentinfo:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["footer"],unsupported:!1,allowedElements:["section"]},definition:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dd","dfn"],unsupported:!1},dialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dialog"],unsupported:!1,allowedElements:["section"]},directory:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["ol","ul"]},document:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["body"],unsupported:!1,allowedElements:["article","embed","iframe","object","section","svg"]},"doc-abstract":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-acknowledgments":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-afterword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-appendix":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-backlink":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:Up}}]},"doc-biblioentry":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:["doc-bibliography"],unsupported:!1,allowedElements:["li"]},"doc-bibliography":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-biblioentry"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-biblioref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:Up}}]},"doc-chapter":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-colophon":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-conclusion":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-cover":{type:"img",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-credit":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-credits":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-dedication":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-endnote":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,namefrom:["author"],context:["doc-endnotes"],unsupported:!1,allowedElements:["li"]},"doc-endnotes":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-endnote"]},namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-epigraph":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-epilogue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-errata":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-example":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-footnote":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","footer","header"]},"doc-foreword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-glossary":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:["term","definition"],namefrom:["author"],context:null,unsupported:!1,allowedElements:["dl"]},"doc-glossref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:Up}}]},"doc-index":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-introduction":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-noteref":{type:"link",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:Up}}]},"doc-notice":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pagebreak":{type:"separator",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["hr"]},"doc-pagelist":{type:"navigation",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-part":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-preface":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-prologue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pullquote":{type:"none",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-qna":{type:"section",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-subtitle":{type:"sectionhead",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["h1","h2","h3","h4","h5","h6"]}},"doc-tip":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},"doc-toc":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},feed:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["article"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","aside","section"]},figure:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["figure"],unsupported:!1},form:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["form"],unsupported:!1},grid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-colcount","aria-level","aria-multiselectable","aria-readonly","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"],unsupported:!1},gridcell:{type:"widget",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-selected","aria-readonly","aria-required","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},group:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["details","optgroup"],unsupported:!1,allowedElements:["dl","figcaption","fieldset","figure","footer","header","ol","ul"]},heading:{type:"structure",attributes:{required:["aria-level"],allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["h1","h2","h3","h4","h5","h6"],unsupported:!1},img:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["img"],unsupported:!1,allowedElements:["embed","iframe","object","svg"]},input:{nameFrom:["author"],type:"abstract",unsupported:!1},landmark:{nameFrom:["author"],type:"abstract",unsupported:!1},link:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["a[href]","area[href]"],unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["image","button"]}}]},list:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{all:["listitem"]},nameFrom:["author"],context:null,implicit:["ol","ul","dl"],unsupported:!1},listbox:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-readonly","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["option"]},nameFrom:["author"],context:null,implicit:["select"],unsupported:!1,allowedElements:["ol","ul"]},listitem:{type:"structure",attributes:{allowed:["aria-level","aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["list"],implicit:["li","dt"],unsupported:!1},log:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},main:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["main"],unsupported:!1,allowedElements:["article","section"]},marquee:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},math:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["math"],unsupported:!1},menu:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,implicit:[\'menu[type="context"]\'],unsupported:!1,allowedElements:["ol","ul"]},menubar:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},menuitem:{type:"widget",attributes:{allowed:["aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="command"]\'],unsupported:!1,allowedElements:["button","li",{nodeName:"iput",properties:{type:["image","button"]}},{nodeName:"a",attributes:{href:Up}}]},menuitemcheckbox:{type:"widget",attributes:{allowed:["aria-checked","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="checkbox"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:Up}}]},menuitemradio:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="radio"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button","radio"]}},{nodeName:"a",attributes:{href:Up}}]},navigation:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["nav"],unsupported:!1,allowedElements:["section"]},none:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:Up}}]},note:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},option:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-checked","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["listbox"],implicit:["option"],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","button"]}},{nodeName:"a",attributes:{href:Up}}]},presentation:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:Up}}]},progressbar:{type:"widget",attributes:{allowed:["aria-valuetext","aria-valuenow","aria-valuemax","aria-valuemin","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["progress"],unsupported:!1},radio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-required","aria-errormessage","aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:[\'input[type="radio"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button"]}}]},radiogroup:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-required","aria-expanded","aria-readonly","aria-errormessage","aria-orientation"]},owned:{all:["radio"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["ol","ul","fieldset"]}},range:{nameFrom:["author"],type:"abstract",unsupported:!1},region:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["section[aria-label]","section[aria-labelledby]","section[title]"],unsupported:!1,allowedElements:{nodeName:["article","aside"]}},roletype:{type:"abstract",unsupported:!1},row:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-colindex","aria-expanded","aria-level","aria-selected","aria-rowindex","aria-errormessage"]},owned:{one:["cell","columnheader","rowheader","gridcell"]},nameFrom:["author","contents"],context:["rowgroup","grid","treegrid","table"],implicit:["tr"],unsupported:!1},rowgroup:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:{all:["row"]},nameFrom:["author","contents"],context:["grid","table","treegrid"],implicit:["tbody","thead","tfoot"],unsupported:!1},rowheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},scrollbar:{type:"widget",attributes:{required:["aria-controls","aria-valuenow"],allowed:["aria-valuetext","aria-orientation","aria-errormessage","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},search:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["aside","form","section"]}},searchbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="search"]\'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:"text"}}},section:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},sectionhead:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},select:{nameFrom:["author"],type:"abstract",unsupported:!1},separator:{type:"structure",attributes:{allowed:["aria-expanded","aria-orientation","aria-valuenow","aria-valuemax","aria-valuemin","aria-valuetext","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["hr"],unsupported:!1,allowedElements:["li"]},slider:{type:"widget",attributes:{allowed:["aria-valuetext","aria-orientation","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="range"]\'],unsupported:!1},spinbutton:{type:"widget",attributes:{allowed:["aria-valuetext","aria-required","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="number"]\'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:["text","tel"]}}},status:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["output"],unsupported:!1,allowedElements:["section"]},structure:{type:"abstract",unsupported:!1},switch:{type:"widget",attributes:{allowed:["aria-errormessage"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:Up}}]},tab:{type:"widget",attributes:{allowed:["aria-selected","aria-expanded","aria-setsize","aria-posinset","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["tablist"],unsupported:!1,allowedElements:[{nodeName:["button","h1","h2","h3","h4","h5","h6","li"]},{nodeName:"input",properties:{type:"button"}},{nodeName:"a",attributes:{href:Up}}]},table:{type:"structure",attributes:{allowed:["aria-colcount","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author","contents"],context:null,implicit:["table"],unsupported:!1},tablist:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-errormessage"]},owned:{all:["tab"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},tabpanel:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},term:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["dt"],unsupported:!1},textbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="text"]\',\'input[type="email"]\',\'input[type="password"]\',\'input[type="tel"]\',\'input[type="url"]\',"input:not([type])","textarea"],unsupported:!1},timer:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},toolbar:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'menu[type="toolbar"]\'],unsupported:!1,allowedElements:["ol","ul"]},tooltip:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1},tree:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},treegrid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-readonly","aria-required","aria-rowcount","aria-orientation","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,unsupported:!1},treeitem:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["group","tree"],unsupported:!1,allowedElements:["li",{nodeName:"a",attributes:{href:Up}}]},widget:{type:"abstract",unsupported:!1},window:{nameFrom:["author"],type:"abstract",unsupported:!1}},Pl.implicitHtmlRole=tu,Pl.elementsAllowedNoRole=[{nodeName:["base","body","caption","col","colgroup","datalist","dd","details","dt","head","html","keygen","label","legend","main","map","math","meta","meter","noscript","optgroup","param","picture","progress","script","source","style","template","textarea","title","track"]},{nodeName:"area",attributes:{href:Up}},{nodeName:"input",properties:{type:["color","data","datatime","file","hidden","month","number","password","range","reset","submit","time","week"]}},{nodeName:"link",attributes:{href:Up}},{nodeName:"menu",attributes:{type:"context"}},{nodeName:"menuitem",attributes:{type:["command","checkbox","radio"]}},{nodeName:"select",condition:function(e){return e instanceof o.AbstractVirtualNode||(e=o.utils.getNodeFromTree(e)),1<Number(e.attr("size"))},properties:{multiple:!0}},{nodeName:["clippath","cursor","defs","desc","feblend","fecolormatrix","fecomponenttransfer","fecomposite","feconvolvematrix","fediffuselighting","fedisplacementmap","fedistantlight","fedropshadow","feflood","fefunca","fefuncb","fefuncg","fefuncr","fegaussianblur","feimage","femerge","femergenode","femorphology","feoffset","fepointlight","fespecularlighting","fespotlight","fetile","feturbulence","filter","hatch","hatchpath","lineargradient","marker","mask","meshgradient","meshpatch","meshrow","metadata","mpath","pattern","radialgradient","solidcolor","stop","switch","view"]}],Pl.elementsAllowedAnyRole=[{nodeName:"a",attributes:{href:Hp}},{nodeName:"img",attributes:{alt:Hp}},{nodeName:["abbr","address","canvas","div","p","pre","blockquote","ins","del","output","span","table","tbody","thead","tfoot","td","em","strong","small","s","cite","q","dfn","abbr","time","code","var","samp","kbd","sub","sup","i","b","u","mark","ruby","rt","rp","bdi","bdo","br","wbr","th","tr"]}],Pl.evaluateRoleForElement={A:function(e){var t=e.node;e=e.out;return"http://www.w3.org/2000/svg"===t.namespaceURI||!t.href.length||e},AREA:function(e){return!e.node.href},BUTTON:function(e){var t=e.node,n=e.role;e=e.out;return"menu"===t.getAttribute("type")?"menuitem"===n:e},IMG:function(e){var t=e.node,n=e.role,a=e.out;switch(t.alt){case null:return a;case"":return"presentation"===n||"none"===n;default:return"presentation"!==n&&"none"!==n}},INPUT:function(e){var t=e.node,n=e.role,a=e.out;switch(t.type){case"button":case"image":return a;case"checkbox":return!("button"!==n||!t.hasAttribute("aria-pressed"))||a;case"radio":return"menuitemradio"===n;case"text":return"combobox"===n||"searchbox"===n||"spinbutton"===n;case"tel":return"combobox"===n||"spinbutton"===n;case"url":case"search":case"email":return"combobox"===n;default:return!1}},LI:function(e){var t=e.node;e=e.out;return!o.utils.matchesSelector(t,"ol li, ul li")||e},MENU:function(e){return"context"!==e.node.getAttribute("type")},OPTION:function(e){return e=e.node,!o.utils.matchesSelector(e,"select > option, datalist > option, optgroup > option")},SELECT:function(e){var t=e.node;e=e.role;return!t.multiple&&t.size<=1&&"menu"===e},SVG:function(e){var t=e.node;e=e.out;return!(!t.parentNode||"http://www.w3.org/2000/svg"!==t.parentNode.namespaceURI)||e}},Pl.rolesOfType={widget:["button","checkbox","dialog","gridcell","link","log","marquee","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","radio","scrollbar","searchbox","slider","spinbutton","status","switch","tab","tabpanel","textbox","timer","tooltip","tree","treeitem"]},Pl),Yp=function(e){var t=null;return(e=Wp.role[e])&&e.implicit?ea(e.implicit):t},Kp=function(e){return!!Pp(e).length};function Xp(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).popupRoles,n=Fu(e);if(!(t=null!=t?t:Oo["aria-haspopup"].values).includes(n))return!1;if(t=function(e){for(;e=e.parent;)if(null!==Fu(e,{noPresentational:!0}))return e;return null}(e),Zp(t))return!0;if(!(n=e.props.id))return!1;if(e.actualNode)return t=lr(e.actualNode).querySelectorAll(\'[aria-owns~="\'.concat(n,\'"][role~="combobox"]:not(select),\\n     [aria-controls~="\').concat(n,\'"][role~="combobox"]:not(select)\')),Array.from(t).some(Zp);throw new Error("Unable to determine combobox popup without an actualNode")}var Zp=function(e){return e&&"combobox"===Fu(e)},Jp=function(e){return e=Xn(e),ui(e)},Qp=function(e){return(e=Lo.ariaRoles[e])&&Array.isArray(e.requiredAttrs)?H(e.requiredAttrs):[]},ef=function(e){return(e=Lo.ariaRoles[e])&&Array.isArray(e.requiredContext)?H(e.requiredContext):null},tf=function(e){return(e=Lo.ariaRoles[e])&&Array.isArray(e.requiredOwned)?H(e.requiredOwned):null},nf=function(e,t){var n,a=(e=e instanceof un?e:Xn(e)).attr(t),r=Lo.ariaAttrs[t];if(!r)return!0;if(r.allowEmpty&&(!a||""===a.trim()))return!0;switch(r.type){case"boolean":return["true","false"].includes(a.toLowerCase());case"nmtoken":return"string"==typeof a&&r.values.includes(a.toLowerCase());case"nmtokens":return(n=Uc(a)).reduce((function(e,t){return e&&r.values.includes(t)}),0!==n.length);case"idref":try{var o=sr(e.actualNode);return!(!a||!o.getElementById(a))}catch(e){throw new TypeError("Cannot resolve id references for partial DOM")}case"idrefs":return To(e,t).some((function(e){return!!e}));case"string":return""!==a.trim();case"decimal":return!(!(n=a.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!n[1]&&!n[2]);case"int":return o=void 0!==r.minValue?r.minValue:-1/0,/^[-+]?[0-9]+$/.test(a)&&parseInt(a)>=o}},af=function(e){return!!Lo.ariaAttrs[e]};function rf(e,t,n){var a=(r=n.props).nodeName,r=r.type,o=function(e){return e?(e=e.toLowerCase(),["mixed","true"].includes(e)?e:"false"):""}(n.attr("aria-checked"));return"input"!==a||"checkbox"!==r||!o||o===(a=function(e){return e.props.indeterminate?"mixed":e.props.checked?"true":"false"}(n))||(this.data({messageKey:"checkbox",checkState:a}),!1)}function of(e){var t,n,a=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).invalidTableRowAttrs,r=2<arguments.length?arguments[2]:void 0;return 0===(a=null!=(t=null==a||null==(t=a.filter)?void 0:t.call(a,(function(e){return r.hasAttr(e)})))?t:[]).length||!(t=(t=function(e){if(e.parent)return ca(e,\'table:not([role]), [role~="treegrid"], [role~="table"], [role~="grid"]\')}(r))&&Fu(t))||"treegrid"===t||(n="row".concat(1<a.length?"Plural":"Singular"),this.data({messageKey:n,invalidAttrs:a,ownerRole:t}),!1)}var uf={row:of,checkbox:rf};var lf={};function sf(e){return 3===e.props.nodeType?0<e.props.nodeValue.trim().length:bi(e,!1,!0)}function cf(e,t,n,a){var r=Vo(e);if(!(n=n||ef(r)))return null;for(var o=n.includes("group"),u=a?e:e.parent;u;){var i=Fu(u,{noPresentational:!0});if(i){if("group"!==i||!o)return n.includes(i)?null:n;t.includes(r)&&n.push(r),n=n.filter((function(e){return"group"!==e}))}u=u.parent}return n}re(lf,{getAriaRolesByType:function(){return zp},getAriaRolesSupportingNameFromContent:function(){return $p},getElementSpec:function(){return hu},getElementsByContentType:function(){return $o},getGlobalAriaAttrs:function(){return Ho},implicitHtmlRoles:function(){return tu}});var df={ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0},pf={application:!0,article:!0,banner:!1,complementary:!0,contentinfo:!0,form:!0,main:!0,navigation:!0,region:!0,search:!1};var ff={},Df=(re(ff,{Color:function(){return Cc},centerPointOfRect:function(){return Df},elementHasImage:function(){return Pi},elementIsDistinct:function(){return hf},filteredRectStack:function(){return bf},flattenColors:function(){return Ff},flattenShadowColors:function(){return wf},getBackgroundColor:function(){return Nf},getBackgroundStack:function(){return Ef},getContrast:function(){return Of},getForegroundColor:function(){return Sf},getOwnBackgroundColor:function(){return Ac},getRectStack:function(){return gf},getStackingContext:function(){return xf},getTextShadowColors:function(){return Cf},hasValidContrastRatio:function(){return Mf},incompleteData:function(){return Mi},stackingContextToColor:function(){return Af}}),function(e){if(!(e.left>t.innerWidth||e.top>t.innerHeight))return{x:Math.min(Math.ceil(e.left+e.width/2),t.innerWidth-1),y:Math.min(Math.ceil(e.top+e.height/2),t.innerHeight-1)}});function mf(e){return e.getPropertyValue("font-family").split(/[,;]/g).map((function(e){return e.trim().toLowerCase()}))}var hf=function(e,n){var a,r=t.getComputedStyle(e);return"none"!==r.getPropertyValue("background-image")||!!["border-bottom","border-top","outline"].reduce((function(e,t){var n=new Cc;return n.parseString(r.getPropertyValue(t+"-color")),e||"none"!==r.getPropertyValue(t+"-style")&&0<parseFloat(r.getPropertyValue(t+"-width"))&&0!==n.alpha}),!1)||(a=t.getComputedStyle(n),mf(r)[0]!==mf(a)[0])||(e=["text-decoration-line","text-decoration-style","font-weight","font-style","font-size"].reduce((function(e,t){return e||r.getPropertyValue(t)!==a.getPropertyValue(t)}),!1),(n=r.getPropertyValue("text-decoration")).split(" ").length<3?e||n!==a.getPropertyValue("text-decoration"):e)},gf=function(e){var t=Ao(e);return!(e=fi(e))||e.length<=1?[t]:e.some((function(e){return void 0===e}))?null:(e.splice(0,0,t),e)},bf=function(e){var t,n,a=gf(e);return a&&1===a.length?a[0]:a&&1<a.length?(t=a.shift(),a.forEach((function(r,o){var u,i;0!==o&&(u=a[o-1],i=a[o],n=u.every((function(e,t){return e===i[t]}))||t.includes(e))})),n?a[0]:(Mi.set("bgColor","elmPartiallyObscuring"),null)):(Mi.set("bgColor","outsideViewport"),null)},vf={normal:function(e,t){return t},multiply:function(e,t){return t*e},screen:function(e,t){return e+t-e*t},overlay:function(e,t){return this["hard-light"](t,e)},darken:function(e,t){return Math.min(e,t)},lighten:function(e,t){return Math.max(e,t)},"color-dodge":function(e,t){return 0===e?0:1===t?1:Math.min(1,e/(1-t))},"color-burn":function(e,t){return 1===e?1:0===t?0:1-Math.min(1,(1-e)/t)},"hard-light":function(e,t){return t<=.5?this.multiply(e,2*t):this.screen(e,2*t-1)},"soft-light":function(e,t){return t<=.5?e-(1-2*t)*e*(1-e):e+(2*t-1)*((e<=.25?((16*e-12)*e+4)*e:Math.sqrt(e))-e)},difference:function(e,t){return Math.abs(e-t)},exclusion:function(e,t){return e+t-2*e*t}};function yf(e,t,n,a,r){return t*(1-a)*e+t*a*vf[r](n/255,e/255)*255+(1-t)*a*n}var Ff=function(e,t){var n,a,r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"normal",o=yf(e.red,e.alpha,t.red,t.alpha,r),u=yf(e.green,e.alpha,t.green,t.alpha,r),i=(r=yf(e.blue,e.alpha,t.blue,t.alpha,r),n=e.alpha+t.alpha*(1-e.alpha),i=0,a=1,Math.min(Math.max(i,n),a));return 0===i?new Cc(o,u,r,i):(n=Math.round(o/i),a=Math.round(u/i),o=Math.round(r/i),new Cc(n,a,o,i))};function wf(e,t){var n=(1-(r=e.alpha))*t.red+r*e.red,a=(1-r)*t.green+r*e.green,r=(1-r)*t.blue+r*e.blue;t=e.alpha+t.alpha*(1-e.alpha);return new Cc(n,a,r,t)}function Ef(e){for(var n=fi(e).map((function(n){return function(e){var n=e.indexOf(a.body),r=Ac(t.getComputedStyle(a.documentElement));return 1<n&&0===r.alpha&&!Pi(a.documentElement)&&(1<n&&(e.splice(n,1),e.push(a.body)),0<(r=e.indexOf(a.documentElement)))&&(e.splice(r,1),e.push(a.documentElement)),e}(n=Oc(n,e))})),r=0;r<n.length;r++){var o=n[r];if(o[0]!==e)return Mi.set("bgColor","bgOverlap"),null;if(0!==r&&!function(e,t){if(e!==t){if(null===e||null===t)return;if(e.length!==t.length)return;for(var n=0;n<e.length;++n)if(e[n]!==t[n])return}return 1}(o,n[0]))return Mi.set("bgColor","elmPartiallyObscuring"),null}return n[0]||null}var Cf=function(e){var n,a,r,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},u=o.minRatio,i=o.maxRatio,l=t.getComputedStyle(e);return"none"===(o=l.getPropertyValue("text-shadow"))?[]:(n=l.getPropertyValue("font-size"),a=parseInt(n),Fn(!1===isNaN(a),"Unable to determine font-size value ".concat(n)),r=[],function(e){var t={pixels:[]},n=e.trim(),a=[t];if(!n)return[];for(;n;){var r=n.match(/^rgba?\\([0-9,.\\s]+\\)/i)||n.match(/^[a-z]+/i)||n.match(/^#[0-9a-f]+/i),o=n.match(/^([0-9.-]+)px/i)||n.match(/^(0)/);if(r)Fn(!t.colorStr,"Multiple colors identified in text-shadow: ".concat(e)),n=n.replace(r[0],"").trim(),t.colorStr=r[0];else if(o)Fn(t.pixels.length<3,"Too many pixel units in text-shadow: ".concat(e)),n=n.replace(o[0],"").trim(),r=parseFloat(("."===o[1][0]?"0":"")+o[1]),t.pixels.push(r);else{if(","!==n[0])throw new Error("Unable to process text-shadows: ".concat(e));Fn(2<=t.pixels.length,"Missing pixel value in text-shadow: ".concat(e)),a.push(t={pixels:[]}),n=n.substr(1).trim()}}return a}(o).forEach((function(e){var t=e.colorStr,n=(e=e.pixels,t=t||l.getPropertyValue("color"),(e=W(e,3))[0]),o=e[1];e=void 0===(e=e[2])?0:e;(!u||a*u<=e)&&(!i||e<a*i)&&(t=function(e){var t=e.colorStr,n=e.offsetX,a=e.offsetY,r=e.blurRadius;e=e.fontSize;return r<n||r<a?new Cc(0,0,0,0):((n=new Cc).parseString(t),n.alpha*=function(e,t){return 0===e?1:.185/(e/t+.4)}(r,e),n)}({colorStr:t,offsetY:n,offsetX:o,blurRadius:e,fontSize:a}),r.push(t))})),r)};function xf(e,t){var n,a,r,o=Xn(e);return o._stackingContext||(a=[],r=new Map,(t=null!=(n=t)?n:Ef(e)).forEach((function(e){var t=(t=e=Xn(e),(o=new Cc).parseString(t.getComputedStylePropertyValue("background-color")),o),n=e._stackingOrder.filter((function(e){return!!e.vNode})),o=(n.forEach((function(e,t){e=e.vNode;var o=null==(o=n[t-1])?void 0:o.vNode;o=Tf(r,e,o);0!==t||r.get(e)||a.unshift(o),r.set(e,o)})),null==(o=n[n.length-1])?void 0:o.vNode);e=Tf(r,e,o);n.length||a.unshift(e),e.bgColor=t})),o._stackingContext=a)}function Af(e){var t;return null!=(t=e.descendants)&&t.length?(t=e.descendants.reduce(kf,Bf()),(t=Ff(t,e.bgColor,e.descendants[0].blendMode)).alpha*=e.opacity):(t=e.bgColor).alpha*=e.opacity,{color:t,blendMode:e.blendMode}}function kf(e,t){e=e instanceof Cc?e:Af(e).color;var n=Af(t).color;return Ff(n,e,t.blendMode)}function Bf(e,t){return{vNode:e,ancestor:t,opacity:parseFloat(null!=(t=null==e?void 0:e.getComputedStylePropertyValue("opacity"))?t:1),bgColor:new Cc(0,0,0,0),blendMode:(null==e?void 0:e.getComputedStylePropertyValue("mix-blend-mode"))||void 0,descendants:[]}}function Tf(e,t,n){var a=e.get(n);e=null!=(e=e.get(t))?e:Bf(t,a);return a&&n!==t&&!a.descendants.includes(e)&&a.descendants.unshift(e),e}function Nf(e){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:[],r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:.1,o=Xn(e),u=o._cache.getBackgroundColor;return u?(n.push.apply(n,H(u.bgElms)),Mi.set("bgColor",u.incompleteData),u.bgColor):(u=function(e,n,r){var o=Ef(e);if(!o)return null;var u=pi(e);(r=Cf(e,{minRatio:r})).length&&(r=[{color:r.reduce(wf)}]);for(var i=0;i<o.length;i++){var l=o[i],s=t.getComputedStyle(l);if(Pi(l,s))return n.push(l),null;var c=Ac(s);if(0!==c.alpha){if("inline"!==s.getPropertyValue("display")&&!Rf(l,u))return n.push(l),Mi.set("bgColor","elmPartiallyObscured"),null;if(n.push(l),1===c.alpha)break}}var d=(r=(d=xf(e,o)).map(Af).concat(r),function(e,n){var r,o,u,i,l=[];return n||(n=a.documentElement,i=a.body,n=t.getComputedStyle(n),r=t.getComputedStyle(i),o=Ac(n),i=0!==(u=Ac(r)).alpha&&Rf(i,e.getBoundingClientRect()),(0!==u.alpha&&0===o.alpha||i&&1!==u.alpha)&&l.unshift({color:u,blendMode:_f(r.getPropertyValue("mix-blend-mode"))}),0===o.alpha)||i&&1===u.alpha||l.unshift({color:o,blendMode:_f(n.getPropertyValue("mix-blend-mode"))}),l}(e,o.includes(a.body)));return r.unshift.apply(r,H(d)),0===r.length?new Cc(255,255,255,1):(e=r.reduce((function(e,t){return Ff(t.color,e.color instanceof Cc?e.color:e,t.blendMode)})),Ff(e.color instanceof Cc?e.color:e,new Cc(255,255,255,1)))}(e,n,r),o._cache.getBackgroundColor={bgColor:u,bgElms:n,incompleteData:Mi.get("bgColor")},u)}function Rf(e,n){n=Array.isArray(n)?n:[n];var a=e.getBoundingClientRect(),r=a.right,o=a.bottom,u=t.getComputedStyle(e).getPropertyValue("overflow");return(["scroll","auto"].includes(u)||e instanceof t.HTMLHtmlElement)&&(r=a.left+e.scrollWidth,o=a.top+e.scrollHeight),n.every((function(e){return e.top>=a.top&&e.bottom<=o&&e.left>=a.left&&e.right<=r}))}function _f(e){return e||void 0}var Of=function(e,t){return t&&e?(t.alpha<1&&(t=Ff(t,e)),e=e.getRelativeLuminance(),t=t.getRelativeLuminance(),(Math.max(t,e)+.05)/(Math.min(t,e)+.05)):null};function Sf(e,n,a){for(var r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},o=t.getComputedStyle(e),u=[],i=0,l=[function(){var e,t,n=o,a=void 0===(a=(a=r).textStrokeEmMin)?0:a;return 0===(t=parseFloat(n.getPropertyValue("-webkit-text-stroke-width")))||(e=n.getPropertyValue("font-size"),t/=parseFloat(e),isNaN(t))||t<a?null:(e=n.getPropertyValue("-webkit-text-stroke-color"),(new Cc).parseString(e))},function(){return e=o,(new Cc).parseString(e.getPropertyValue("-webkit-text-fill-color")||e.getPropertyValue("color"));var e},function(){return Cf(e,{minRatio:0})}];i<l.length;i++){var s=(0,l[i])();if(s&&(u=u.concat(s),1===s.alpha))break}var c,d,p=u.reduce((function(e,t){return Ff(e,t)}));return null===(a=null==a?Nf(e,[]):a)?(c=Mi.get("bgColor"),Mi.set("fgColor",c),null):(d=function e(t,n){var a,r=ee(t);try{for(r.s();!(a=r.n()).done;){var o,u=a.value;if((null==(o=u.vNode)?void 0:o.actualNode)===n)return u;var i=e(u.descendants,n);if(i)return i}}catch(e){r.e(e)}finally{r.f()}}(c=xf(e),e),Ff(function(e,t,n){for(;t;){var a;1===t.opacity&&t.ancestor||(e.alpha*=t.opacity,a=(null==(a=t.ancestor)?void 0:a.descendants)||n,(a=(a=1!==t.opacity?a.slice(0,a.indexOf(t)):a).map(Af)).length&&(a=a.reduce((function(e,t){return Ff(t.color,e.color instanceof Cc?e.color:e)}),{color:new Cc(0,0,0,0),blendMode:"normal"}),e=Ff(e,a))),t=t.ancestor}return e}(p,d,c),new Cc(255,255,255,1)))}var Mf=function(e,t,n,a){return e=Of(e,t),{isValid:(t=a&&Math.ceil(72*n)/96<14||!a&&Math.ceil(72*n)/96<18?4.5:3)<e,contrastRatio:e,expectedContrastRatio:t}},Pf=Dr((function(e,n){function a(e,t){return r.getPropertyValue(e)===t}var r=t.getComputedStyle(e,n);return a("content","none")||a("display","none")||a("visibility","hidden")||!1===a("position","absolute")||0===Ac(r).alpha&&a("background-image","none")?0:(e=If(r.getPropertyValue("width")),n=If(r.getPropertyValue("height")),"px"!==e.unit||"px"!==n.unit?0===e.value||0===n.value?0:1/0:e.value*n.value)}));function If(e){var t=(e=W(e.match(/^([0-9.]+)([a-z]+)$/i)||[],3))[1];e=void 0===(e=e[2])?"":e;return{value:parseFloat(void 0===t?"":t),unit:e.toLowerCase()}}function jf(e,t){return e=e.getRelativeLuminance(),t=t.getRelativeLuminance(),(Math.max(e,t)+.05)/(Math.min(e,t)+.05)}var Lf=["block","list-item","table","flex","grid","inline-block"];function qf(e){return e=t.getComputedStyle(e).getPropertyValue("display"),-1!==Lf.indexOf(e)||"table-"===e.substr(0,6)}var zf=["block","list-item","table","flex","grid","inline-block"];function Vf(e){return e=t.getComputedStyle(e).getPropertyValue("display"),-1!==zf.indexOf(e)||"table-"===e.substr(0,6)}function $f(e){return e=parseInt(e.attr("tabindex"),10),!isNaN(e)&&e<0}function Hf(e,t){return t=Uf(t),e=Uf(e),!(!t||!e)&&t.includes(e)}function Uf(e){return e=ni(e,{emoji:!0,nonBmp:!0,punctuations:!0}),Xo(e)}function Gf(e){return""!==(e||"").trim()}function Wf(e,t){var n=1<arguments.length&&void 0!==t&&t;return e.map((function(e){return{vChild:e,nested:n}}))}function Yf(e,t){return e=e.boundingClientRect,t=t.boundingClientRect,e.top>=t.top&&e.left>=t.left&&e.bottom<=t.bottom&&e.right<=t.right}function Kf(e){return{width:Math.round(10*e.width)/10,height:Math.round(10*e.height)/10}}function Xf(e,t){return e.actualNode.contains(t.actualNode)&&!Ai(t)}function Zf(e,t){var n=t.width;t=t.height;return e<=n+.05&&e<=t+.05}function Jf(e){return e.map((function(e){return e.actualNode}))}function Qf(e,t){var n=null==(n=t.data)?void 0:n.headingOrder,a=tD(t.node.ancestry,1);return n&&(t=n.map((function(e){return G({},e,{ancestry:a.concat(e.ancestry)})})),-1===(n=function(e,t){for(;t.length;){var n=eD(e,t);if(-1!==n)return n;t=tD(t,1)}return-1}(e,a))?e.push.apply(e,H(t)):e.splice.apply(e,[n,0].concat(H(t)))),e}function eD(e,t){return e.findIndex((function(e){return Pd(e.ancestry,t)}))}function tD(e,t){return e.slice(0,e.length-t)}re(jl={},{aria:function(){return Op},color:function(){return ff},dom:function(){return ir},forms:function(){return nD},matches:function(){return mu},math:function(){return bo},standards:function(){return lf},table:function(){return oD},text:function(){return Bo},utils:function(){return ln}});var nD={},aD=(re(nD,{isAriaCombobox:function(){return $u},isAriaListbox:function(){return Vu},isAriaRange:function(){return Uu},isAriaTextbox:function(){return zu},isDisabled:function(){return rD},isNativeSelect:function(){return qu},isNativeTextbox:function(){return Lu}}),["fieldset","button","select","input","textarea"]),rD=function e(t){var n,a,r=t._isDisabled;return"boolean"!=typeof r&&(n=t.props.nodeName,a=t.attr("aria-disabled"),r=!(!aD.includes(n)||!t.hasAttr("disabled"))||(a?"true"===a.toLowerCase():!!t.parent&&e(t.parent)),t._isDisabled=r),r},oD={},uD=(re(oD,{getAllCells:function(){return uD},getCellPosition:function(){return Go},getHeaders:function(){return lD},getScope:function(){return Wo},isColumnHeader:function(){return Yo},isDataCell:function(){return sD},isDataTable:function(){return cD},isHeader:function(){return dD},isRowHeader:function