# Sift - Recipe Keeper

Sift is a minimalist recipe app for saving, organizing, and accessing your favorite recipes without ads or distractions.

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)


## Features

- **Completely Free & Open Source**: No ads, no subscriptions, and no hidden costs.
- **Unlimited Recipes**: Store as many recipes as you want, all on your own device.
- **Import from Any Website**: Save recipes from your favorite cooking websites with a single tap.
- **Bring Your Own AI Model**: Connect to any OpenAI-compatible API to have full control over your data and costs.
- **Clean & Intuitive Interface**: A distraction-free cooking experience designed to help you focus.


## How It Works

Sift uses AI to extract only the recipe from any webpage, leaving behind ads, stories, and other distractions. This gives you a clean, easy-to-follow recipe card.

The app uses a "Bring Your Own Model" approach, which means you connect it to an AI service of your choice. This gives you complete control over your data and allows you to choose from a wide range of AI models, including free and paid options.

Sift is compatible with any provider that supports the OpenAI API format, such as:

- **OpenRouter**: Access a variety of models from different providers, including some great free options.
- **OpenAI**: Use powerful models like `gpt-4o-mini` for high accuracy.
- **Google AI**: Access the Gemini family of models.

To get started, simply go to `Settings > AI Model` and enter your provider's API Endpoint, Model Name, and API Key.


## Build the app

To build the app from source, please see the detailed instructions in the [BUILD.md](BUILD.md) file.
