/*
 * Copyright (c) 2018, Daniel Gultsch All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package eu.siacs.conversations.utils;

import android.text.Spannable;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class CharSequenceUtils {

    private static int getStartIndex(CharSequence input) {
        int length = input.length();
        int index = 0;
        while (Character.isWhitespace(input.charAt(index))) {
            ++index;
            if (index >= length) {
                break;
            }
        }
        return index;
    }

    private static int getEndIndex(CharSequence input) {
        int index = input.length() - 1;
        while (Character.isWhitespace(input.charAt(index))) {
            --index;
            if (index < 0) {
                break;
            }
        }
        return index;
    }

    public static CharSequence trim(CharSequence input) {
        int begin = getStartIndex(input);
        int end = getEndIndex(input);
        if (begin > end) {
            return "";
        } else {
            return StylingHelper.subSequence(input, begin, end + 1);
        }
    }

    public static List<CharSequence> split(Spannable charSequence, char c) {
        List<CharSequence> out = new ArrayList<>();
        int begin = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) == c) {
                out.add(StylingHelper.subSequence(charSequence, begin, i));
                begin = ++i;
            }
        }
        if (begin < charSequence.length()) {
            out.add(StylingHelper.subSequence(charSequence, begin, charSequence.length()));
        }
        return out;
    }

    public static String nullToEmpty(@Nullable final CharSequence charSequence) {
        return charSequence == null ? "" : charSequence.toString();
    }
}
