/*
 * Copyright © 2014-2025 The Android Password Store Authors. All Rights Reserved.
 * SPDX-License-Identifier: GPL-3.0-only
 */

package app.passwordstore.util.settings

object PreferenceKeys {

  const val APP_THEME = "app_theme"
  const val AUTOFILL_ENABLE = "autofill_enable"
  const val BIOMETRIC_AUTH = "biometric_auth"
  const val BIOMETRIC_AUTH_2 = "biometric_auth_delete_soon_please"
  @Deprecated(
    message = "Use CLEAR_CLIPBOARD_HISTORY instead",
    replaceWith = ReplaceWith("PreferenceKeys.CLEAR_CLIPBOARD_HISTORY"),
  )
  const val CLEAR_CLIPBOARD_20X = "clear_clipboard_20x"
  const val CLEAR_CLIPBOARD_HISTORY = "clear_clipboard_history"
  const val CLEAR_SAVED_PASS = "clear_saved_pass"
  const val COPY_ON_DECRYPT = "copy_on_decrypt"
  const val ENABLE_DEBUG_LOGGING = "enable_debug_logging"
  const val EXPORT_PASSWORDS = "export_passwords"
  const val IMPORT_PASSWORDS = "import_passwords"
  const val FILTER_RECURSIVELY = "filter_recursively"
  const val GENERAL_SHOW_TIME = "general_show_time"
  const val GIT_CONFIG = "git_config"
  const val GIT_CONFIG_AUTHOR_EMAIL = "git_config_user_email"
  const val GIT_CONFIG_AUTHOR_NAME = "git_config_user_name"

  @Deprecated(message = "We're removing support for external storage")
  const val GIT_EXTERNAL = "git_external"

  @Deprecated(message = "We're removing support for external storage")
  const val GIT_EXTERNAL_REPO = "git_external_repo"
  const val GIT_EXTERNAL_MIGRATED = "git_external_migrated"
  const val GIT_REMOTE_AUTH = "git_remote_auth"
  const val GIT_REMOTE_KEY_TYPE = "git_remote_key_type"

  @Deprecated("Use GIT_REMOTE_URL instead") const val GIT_REMOTE_LOCATION = "git_remote_location"
  const val GIT_REMOTE_USE_MULTIPLEXING = "git_remote_use_multiplexing"

  @Deprecated("Use GIT_REMOTE_URL instead") const val GIT_REMOTE_PORT = "git_remote_port"

  @Deprecated("Use GIT_REMOTE_URL instead") const val GIT_REMOTE_PROTOCOL = "git_remote_protocol"
  const val GIT_DELETE_REPO = "git_delete_repo"

  @Deprecated("Use GIT_REMOTE_URL instead") const val GIT_REMOTE_SERVER = "git_remote_server"
  const val GIT_REMOTE_URL = "git_remote_url"

  @Deprecated("Use GIT_REMOTE_URL instead") const val GIT_REMOTE_USERNAME = "git_remote_username"
  const val GIT_SERVER_INFO = "git_server_info"

  @Deprecated("Git branch is no longer stored in preferences")
  const val GIT_BRANCH_NAME = "git_branch"
  const val HTTPS_PASSWORD = "https_password"
  const val LENGTH = "length"
  const val OREO_AUTOFILL_CUSTOM_PUBLIC_SUFFIXES = "oreo_autofill_custom_public_suffixes"
  const val OREO_AUTOFILL_DEFAULT_USERNAME = "oreo_autofill_default_username"
  const val DIRECTORY_STRUCTURE = "oreo_autofill_directory_structure"
  const val STRICT_DOMAIN_SEARCH = "oreo_autofill_strict_domain_search"
  const val PREF_KEY_PWGEN_TYPE = "pref_key_pwgen_type"
  const val REPOSITORY_INITIALIZED = "repository_initialized"
  const val REPO_CHANGED = "repo_changed"
  const val SEARCH_ON_START = "search_on_start"

  @Deprecated(
    message = "Use SHOW_HIDDEN_CONTENTS instead",
    replaceWith = ReplaceWith("PreferenceKeys.SHOW_HIDDEN_CONTENTS"),
  )
  const val SHOW_HIDDEN_FOLDERS = "show_hidden_folders"
  const val SHOW_HIDDEN_CONTENTS = "show_hidden_contents"
  const val SORT_ORDER = "sort_order"
  const val SHOW_PASSWORD = "show_password"
  @Deprecated(
    message = "Use PREF_FAST_UNLOCK_OPTION instead",
    replaceWith = ReplaceWith("PreferenceKeys.PREF_FAST_UNLOCK_OPTION"),
  )
  const val UNLOCK_PASSWORDS_WITH_PIN = "unlock_passwords_with_pin"
  const val PREF_FAST_UNLOCK_OPTION = "pref_fast_unlock_option"
  const val BIOMETRICS_AND_PIN_TIMEOUT = "biometrics_and_pin_timeout"
  const val BIOMETRICS_AND_PIN_LAST_USE = "biometrics_and_pin_last_use"
  const val SSH_KEY = "ssh_key"
  const val SSH_KEYGEN = "ssh_keygen"

  const val SSH_KEY_LOCAL_PASSPHRASE = "ssh_key_local_passphrase"

  const val SSH_OPENKEYSTORE_CLEAR_KEY_ID = "ssh_openkeystore_clear_keyid"
  const val SSH_OPENKEYSTORE_KEYID = "ssh_openkeystore_keyid"
  const val SSH_SEE_KEY = "ssh_see_key"

  @Deprecated("To be used only in Migrations.kt") const val USE_GENERATED_KEY = "use_generated_key"

  const val PROXY_SETTINGS = "proxy_settings"
  const val PROXY_HOST = "proxy_host"
  const val PROXY_PORT = "proxy_port"
  const val PROXY_USERNAME = "proxy_username"
  const val PROXY_PASSWORD = "proxy_password"

  const val REBASE_ON_PULL = "rebase_on_pull"

  const val DICEWARE_SEPARATOR = "diceware_separator"
  const val DICEWARE_LENGTH = "diceware_length"
  const val DISABLE_SYNC_ACTION = "disable_sync_action"
  const val ASCII_ARMOR = "pgpainless_ascii_armor"

  @Deprecated(
    message = "We refactored persistent caching of the PGP passphrase and this is no longer used"
  )
  const val CLEAR_PASSPHRASE_CACHE = "pgpainless_auto_clear_passphrase_cache_screen_off"

  const val CACHE_PASSPHRASE = "cache_passphrase_until_screen_off"
}
