# Changelog

All notable changes to this project will be documented in this file.

## [Unreleased]

## [1.15.0] - 2025-07-11

### Added

- In-app creation of PGP keys in the key manager
- Menu options for PGP key export/backup and for changing the PGP key passphrase

### Fixed

- Navigation icon colour adapting to current app theme (light/dark)

## [1.14.5] - 2025-05-27

### Fixed

- Password repo export to and import from an external directory happened to be incomplete if the user returned to the password list too quickly while the operation was still running in the background
- Fast unlocking of password items: The PIN verification attempt counter was reset to zero upon cancelling the dialog or app restart. It is now persistently cached to prevent brute force attempts on the PIN
- Decryption may fail in a multi-key setup, where some PGP keys listed in `.gpg-id` are public-only keys

## [1.14.4] - 2025-05-21

### Added

- An option for fast unlocking password store entries with a PIN was added. Available unlocking options can be accessed via Settings --> Passwords --> Fast unlocking of entries. The PIN is specific to the app, that is, it may differ from the device PIN
- Importing a symmetrically encrypted PGP secret key file, such as an OpenKeychain backup. This allows for more secure handling of PGP keys outside trusted environments, e. g. for key transfer between devices using e-mail or online storage services

## [1.14.3] - 2025-04-25

### Changed

- Adjust Java version to v17 in GitHub workflows to comply with F-Droid requirements

## [1.14.2] - 2025-04-24

### Fixed

- Re-enable pre-launch biometric auth option on Android-14 devices (<https://github.com/android-password-store/Android-Password-Store/issues/2802>)
- More reliable detection of AES key invalidation due to fingerprint enrollment 

## [1.14.1] - 2025-04-16

### Added

- Detect enrollment of a new fingerprint since last app use and inform the user about it; this counteracts the attempt of a potentially malicious user to add their fingerprint unnoticed to the device lock settings

### Fixed

- With biometric authentication at app launch, the biometric prompt was immediately hidden, requiring the user to reopen the app before it could be finally unlocked
- Fix app launch with biometric authentication in case of missing fingerprint

### Changed

- Allow device PIN authentication for SSH and Git operations

## [1.14.0] - 2025-04-09

### Added

- Display user ID (or user IDs in case of multi-key encrypted entries) on the passphrase input dialog
- Allow setting a subdirectory PGP key when creating folders (restored feature from v1.11.0)
- External repository import. An external "pass" repository or a repository previously exported from the app can now be imported via Settings --> Repository --> Import repository
- Copy OTP to the clipboard during autofill: If the pass entry contains an OTP, it is copied to the clipboard to facilitate autofill. The OTP in the clipboard is refreshed once when the first copy expires. This is to handle the situation when the first OTP was calculated just before its expiry

  [Original repo](https://github.com/android-password-store/Android-Password-Store) up to archiving:
- On Android 11, Autofill will use the new [inline autofill](https://developer.android.com/guide/topics/text/ime-autofill#configure-provider) UI that integrates Autofill results into your keyboard app
- Allow doing a merge instead of a rebase when pulling or syncing
- Add support for manually providing TOTP parameters
- Parse extra content as individual fields
- Improve search result filtering logic
- Allow pinning shortcuts directly to the launcher home screen
- Another workaround for SteamGuard's non-standard OTP format
- Allow importing QR code from images
- Add the ability to run garbage collection on the internal Git repository
- Introduce crash reporting backed by Sentry
- TOTP field now shows the remaining time for which it is valid
- Allow customizing the timeout for decrypted password screen
- Allow toggling ASCII armored output

### Fixed

- Auto-dismiss an abandoned password edit dialog after configurable timeout (password copy timeout is used if configured, 60 seconds otherwise) to prevent information leakage
- Initialising an empty cloned non-pass repo is now possible. This led to an app crash before. The repo to be cloned should however already have at least one commit, e. g. an added and removed dummy file
- Fix app crashes due to a `.gpg-id` file containing an invalid or unknown key/user ID. Prompt for re-selecting/re-importing a PGP secret key file
- In case of multi-key encrypted store entries, decryption failed with passphrases for the other PGP IDs that appear below the first entry in the `.gpg-id` file
- The PGP key is now retrieved also for subkey IDs listed in the `.gpg-id` file
- New store entries created in autofill mode were not committed to the Git repo

  [Original repo](https://github.com/android-password-store/Android-Password-Store) up to archiving:
- Pressing the back button in the navigation bar and the one in the toolbar behaved differently
- App shortcuts would never update once the first 4 were set
- Clipboard history now attempts to flush through 35 times rather than 20 to combat increased clipboard history item count in Samsung devices
- .gpg-id file generated by APS did not work with pass CLI
- All but the latest launcher shortcut would have an empty icon
- When prompted to select a GPG key during onboarding, the app would crash if the user did not make a selection in OpenKeychain
- Biometric authentication prompts no longer inexplicably dismiss when an incorrect biometric is entered

### Changed

- **BREAKING**: The option for generating the SSH key pair in the Ed25519 format was removed from APS. It relied on the now deprecated `androidx.security:security-crypto` library to store the private key as an encrypted file in the application's hidden directory. Use one of Android KeyStore native RSA or ECDSA key format options when generating the SSH key pair. Alternatively, an externally generated SSH private key can be imported into the app. Imported SSH private keys can be in any format, including Ed25519, but they should be protected with a passphrase
- **BREAKING**: Non-free variant removed which allowed filling OTP fields with codes sent by SMS
- `.gpg-id` is now initialised with the numeric key ID instead of the user ID (email)
- The code for persistent PGP passphrase caching was rewritten to remove its dependency on the now deprecated `androidx.security:security-crypto` library. It is enabled via Settings --> Passwords --> Unlock Passwords with biometrics. Passphrase caching and unlocking is only possible with biometric authentication (fingerprint), for enhanced security. The new implementation also works with multi-key pass stores.

  [Original repo](https://github.com/android-password-store/Android-Password-Store) up to archiving:
- **BREAKING**: The app's package name has been changed to `app.passwordstore` so users are aware that this is a new project with no compatibility guarantees with Password Store 1.x.y.
- **BREAKING**: Introduce a new PGP backend powered by [PGPainless](https://github.com/pgpainless/pgpainless) which completely replaces OpenKeychain
- **BREAKING**: Accessibility autofill has been removed completely due to being buggy, insecure and lacking in features. Upgrade to Android 8 or preferably later to gain access to our advanced Autofill implementation.
- **BREAKING**: Support for stores outside the hidden app directory has been removed due to technical restrictions, see [this issue](https://github.com/Android-Password-Store/Android-Password-Store/issues/1849) for details.
- **BREAKING**: The app's minimum supported Android version has been raised to Android Oreo (API level 26).
- The settings UI has been completely re-done to dramatically improve discoverability and navigation for users
- Using the `git://` protocol in the server URL now presents an explicit discouragement rather than a generic error
- Encrypted data is no longer ASCII armored, bringing it in line with `pass`
- Changing password generator parameters now automatically updates the password without needing to press the 'Generate' button again
- The app UI was reskinned to match Google's Material You guidelines
- Using HTTPS without authentication is now fully supported, and no longer asks for a username
- Enabling 'Show hidden files and folders' no longer shows Git-related files and folders
- XkPasswd password generator has been removed in favor of one backed by [Diceware](https://theworld.com/~reinhold/diceware.html)
- The app no longer prompts for a branch during clone and instead always uses the default one. Use the hard reset option in Git utilities to switch to the desired branch after cloning.

## [1.13.5] - 2021-07-28

### Fixed

- When prompted to select a GPG key during onboarding, the app would crash if the user did not make a selection in OpenKeychain
- Certain apps had incorrect Autofill hints which would crash the app

## [1.13.4] - 2021-03-20

- Fix support for ECDSA SSH keys and support AES-GCM
- Fix a couple issues with Autofill

## [1.13.3] - 2021-03-06

### Fixed

- Autofill now works much more reliably in Chrome 89 and later, including support for saving passwords if no accessibility service is enabled.
- Editing a password allowed accidentally overwriting an existing one

## [1.13.2] - 2020-12-21

### Added

- Invalid `.gpg-id` files can now be fixed automatically by deleting them and then trying to create a new password.
- Suggest users to re-clone repository when it is deemed to be broken
- A new browser support level is added for Chrome Canary and Chrome Dev which are shipping fixes developed by Password Store maintainer Fabian to improve the Autofill experience on Chromium browsers

### Changed

- Synced localisations with Crowdin. This adds Galician and Italian translations while getting rid of incomplete Arabic, Chinese Simplified, Chinese Traditional, Czech, Japanese and Spanish.

### Fixed

- Cancelling the Autofill "Generate password" action now correctly returns you to the original app.
- If multiple username fields exist in the password, we now ensure the later ones are not dropped from extra content.
- Icons in Autofill suggestions are no longer black on almost black in dark mode.
- Decrypt screen would stay in memory infinitely, allowing passwords to be seen without re-auth
- Git commits in the store would wrongly use the 'default' committer as opposed to the user's configured one
- Connection attempts now use a reasonable 10 second timeout as opposed to the default of 30 seconds
- A change to the remote host key for a server would prevent the user from being able to connect to it

## [1.13.1] - 2020-10-23

### Fixed

- OpenKeychain authentication would fail with `LifecycleOwner com.zeapo.pwdstore.git.GitServerConfigActivity@f578da1 is attempting to register while current state is RESUMED. LifecycleOwners must call register before they are STARTED.`

### Added

- Add support for domain-level autofill in DuckDuckGo's F-Droid builds.
- Support gopass MIME secret encoding

### Changed

- The newly added automatic synchronisation feature has been rolled back due to multiple issues with its implementation.

## [1.13.0] - 2020-10-22

### Fixed

- Some classes of errors would be swallowed by an unhelpful 'Invalid remote: origin' message
- Repositories created within APS would contain invalid `.gpg-id` files with no ability to fix them from the app
- Button labels were invisible in Autofill phishing warning screen
- Unsupported authentication modes would appear briefly in the server config screen

### Added

- Add GPG key selection step to onboarding flow
- Allow configuring an app-wide HTTP(S) proxy
- Add option to automatically sync repository on app launch
- Add a quickfix for invalid HTTPS URLs that contain a custom port

## [1.12.1] - 2020-10-13

### Fixed

- Certain operations like folder creation with GPG keys would fail with `java.lang.IllegalStateException`.
- ECDSA key exchanges failed resulting in users being unable to clone repositories.

## [1.12.0] - 2020-09-24

### Added

- Allow sorting by recently used
- Add [Bromite](https://www.bromite.org/), [Ungoogled Chromium](https://git.droidware.info/wchen342/ungoogled-chromium-android) and [Kiwi](https://kiwibrowser.com/) to supported browsers list for Autofill
- Add ability to view the Git commit log
- Allow generating ECDSA and ED25519 keys for SSH
- Add support for multiple/fallback authentication methods for SSH
- Add warning when the custom SSH port in a URL could potentially be ignored

### Changed

- A descriptive error message is shown if no username is specified in the Git server settings
- Remove explicit protocol choice from Git server settings, it is now inferred from your URL
- 'Show hidden folders' is now 'Show hidden files and folders'
- Generated SSH keys are now stored in the Android Keystore if available, and encrypted at rest otherwise
- Allow using device's screen lock credentials to secure generated SSH key
- Update onboarding UI
- Update translations

### Fixed

- Git server protocol and authentication mode are only updated when explicitly saved
- Remember HTTPS password during a sync operation
- Unable to use show/hide password option for password/passphrase after first attempt was wrong
- TOTP values shown might some times be stale and considered invalid by sites
- Symlinks are no longer clobbered by the app (only available on Android 8 and above)
- Workaround lack of SSH connection reuse capabilities on some Git hosts like Bitbucket

## [1.11.3] - 2020-08-27

### Fixed

- Delete stored HTTPS password on connection errors (such as failed authentication)

## [1.11.2] - 2020-08-24

### Fixed

- Saving a password after creating it fails to finish commit operation
- HTTPS authentication did not prompt users for password

## [1.11.1] - 2020-08-21

### Fixed

- App failed to start on Android 7 and below

## [1.11.0] - 2020-08-18

### Added

- Allow changing the branch used for Git operations
- Allow setting a subdirectory key when creating folders
- Allow adding digits/symbols in XkPasswd generated passwords using a mask-like value (`dds` gives you two digits and a symbol, and so on)

### Changed

- The Git repository URL can now be specified directly
- Slightly reduce APK size
- Always show the parent path in entries
- Passwords will no longer be copied to the clipboard by default
- Notify user if there was nothing to push

### Fixed

- Allow creating nested directories directly
- I keep saying this but for real: error message for wrong SSH/HTTPS password is properly fixed now
- Fix crash when OpenKeychain is not installed
- Clone operation won't leave user on an empty password list upon failure
- Cloning a new repository to external storage wouldn't work
- UI froze for some people when deleting existing files from the external directory

## [1.10.3] - 2020-07-30

### Fixed

- Worked around a dependency bug that would crash the Autofill service when triggered on an OTP field

## [1.10.2] - 2020-07-30

### Fixed

- Properly handle cases where files contain only TOTP secrets and no password
- Correctly hide TOTP import button when TOTP secret/OTPAUTH URL is already present in extra content
- SMS OTP Autofill no longer crashes when invoked and correctly asks for the required permission on first use

## [1.10.1] - 2020-07-23

### Fixed

- Using long key IDs in .gpg-id no longer leads to a crash
- Long key IDs and fingerprints are now correctly forwarded to OpenKeychain

### Added

- Support for multiple GPG IDs in .gpg-id
- Creating an entry in an empty store now lets you select keys to initialize .gpg-id with

## [1.10.0] - 2020-07-22

### Changed

- A brand new icon to go with our biggest update ever!
- Light theme is now a consistent white across the board with ample contrast
- XkPassword generator is now easier to use with less configuration options
- Edit screen now has better protection and guidance for invalid names
- Improved biometric authentication UX on app start
- Improved password list UI

### Fixed

- Folder names that were very long did not look right
- Error message for wrong SSH/HTTPS password now looks cleaner
- Fix authentication failure with usernames that contain the `@` character
- Text input boxes were illegible on dark theme
- Top-level password names had inconsistent top margin making them look askew
- Password Store no longer ignores the selected OpenKeychain key
- Password export now happens in a separate process, preventing possible freezes

### Added

- TOTP support is reintroduced by popular demand. HOTP continues to be unsupported and heavily discouraged.
- Initial support for detecting and filling OTP fields with Autofill
- OTP codes can be automatically filled from SMS (requires Android P+ and Google Play Services)
- Importing TOTP secrets using QR codes
- Support for ed25519/ECDSA SSH keys
- Navigate into newly created folders and scroll to newly created passwords
- Support per-directory keys
- Full pt-BR localization

## [1.9.2] - 2020-06-30

### Fixed

- App crashes upon launching the app for the first time

## [1.9.1] - 2020-06-28

### Fixed

- Remember passphrase option did not work with old-style keys (generated either before 2019 or by passing `-m PEM` to new versions of OpenSSH)

### Added

- Add GNU IceCatMobile to the list of supported browsers for Autofill

## [1.9.0] - 2020-06-21

### Fixed

- 'Draw over other apps' permission dialog opens when attempting to use Oreo Autofill
- Old app shortcuts are now removed when the local repository is deleted

### Added

- Completely revamped decypted password view
- Add support for better, more secure Keyex's and MACs with a brand new SSH backend
- Allow manually marking domains for subdomain-level association. This will allow you to keep separate passwords for `site1.example.com` and `site2.example.com` and have them show as such in Autofill.
- Provide better messages for OpenKeychain errors
- Rename passwords and categories

### Changed

- **BREAKING**: Remove support for HOTP/TOTP secrets - Please use FIDO keys or a dedicated app like [Aegis](https://github.com/beemdevelopment/Aegis) or [andOTP](https://github.com/andOTP/andOTP)
- Reduce Autofill false positives on username fields by removing "name" from list of heuristic terms
- Reduced app size
- Improve IME experience with server config screen
- Removed edit password option from long-press menu.
- Batch deletion now does not require manually confirming for each password
- Better commit messages on password deletion

## [1.8.1] - 2020-05-24

### Fixed

- Don't strip leading slash from repository paths

## [1.8.0] - 2020-05-23

### Added

- Allow user to abort password move when it is replacing an existing file
- Allow setting a default username for Autofill
- Add no authentication mode for working with public repositories

### Changed

- More UI related tweaks, changes and improvements
- Improved error messages and internal logic for server configuration

### Fixed

- Add the following fields to encrypted username detection: user, account, email, name, handle, id, identity.
- Improved detection of broken or incomplete git repositories
- Better UX flow for storage permissions

## [1.7.2] - 2020-04-29

### Added

- Settings option to enable debug logging

### Changed

- SSH Keygen UI was improved
- Default key length for SSH Keygen is now 4096 bits
- Settings items were rearranged and cleaned up
- Autofill icons in dark mode are now more legible

### Fixed

- Failure to detect if repository was not cloned which broke Git operations
- Search results were inaccurate if root directory's name started with a dot (.)
- Saving git username and email did not provide user-facing confirmation

## [1.7.1] - 2020-04-23

### Fixed

- Autofill message does not show OK button when many browsers are installed
- Autofill message does not get marked as shown when dismissed
- App crashes when using type-independent sort
- Storage permission not requested when using existing external repository

## [1.7.0] - 2020-04-21

### Added

- Oreo Autofill support
- Securely remember HTTPS password/SSH key passphrase

### Fixed

- Text input box theming
- Password repository held in non-hidden storage no longer fails
- Remove ambiguous and confusing URL field in server config menu
  and heavily improve UI for ease of use.

## [1.6.0] - 2020-03-20

### Added

- Copy implicit username (password filename) by long pressing
- Create xkpasswd style passwords
- Swipe on password list to synchronize repository

### Fixed

- Resolve memory leaks on password decryption
- Can't delete folders containing a password

## [1.5.0] - 2020-02-21

### Added

- Fast scroller with alphabetic hints
- UI button to create new folders
- Option to directly start searching when opening the app
- Option to always search from root folder regardless of the currently open folder

### Changed

- Logging is now enabled in release builds
- Searching now shows folders as well as the passwords inside them

### Fixed

- OpenKeychain errors cause app crash

## [1.4.0] - 2020-01-24

### Added

- Add save-and-copy button
- Dark theme
- Setting to save OpenKeychain auth id
- Add number of passwords to folders

### Changed

- Updated UI design and iconograph
- Biometric authentication
- Use new OpenKeychain integration library

### Fixed

- Snackbars showing behind keyboards

## [1.3.2] - 2018-12-23

### Changed

- Improve French translation.

### Fixed

- Extra field is multi-line.

## [1.3.1] - 2018-10-18

### Fixed

- Fix default sort order bug.

## [1.3.0] - 2018-10-16

### Added

- Allow app to be installed on external media (SD card).
- Change password sort order.
- Display HOTP code if present.
- Open search view on keyboard press.

### Changed

- Use adaptive icon.
- Password entry is more secure.
- Clean paths on password list view.
- Improve Chinese translation.
- Don't show hidden files and directories.

### Fixed

- Fix clipboard clearing.
- Wrap long passwords.

## 1.2.0.75 - 2018-05-31

### Added

- Add Arabic translation.
- Warn user that remembering SSH passphrase is currently insecure.

### Changed

- Update Japanese assets.

### Fixed

- Fix elements overlapping.

[unreleased]: https://github.com/agrahn/Android-Password-Store/compare/v1.15.0...HEAD
[1.15.0]: https://github.com/agrahn/Android-Password-Store/compare/v1.14.5...v1.15.0
[1.14.5]: https://github.com/agrahn/Android-Password-Store/compare/v1.14.4...v1.14.5
[1.14.4]: https://github.com/agrahn/Android-Password-Store/compare/v1.14.3...v1.14.4
[1.14.3]: https://github.com/agrahn/Android-Password-Store/compare/v1.14.2...v1.14.3
[1.14.2]: https://github.com/agrahn/Android-Password-Store/compare/v1.14.1...v1.14.2
[1.14.1]: https://github.com/agrahn/Android-Password-Store/compare/agrahn:Android-Password-Store:v1.14.0...v1.14.1
[1.14.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.13.5...agrahn:Android-Password-Store:v1.14.0
[1.13.5]: https://github.com/android-password-store/Android-Password-Store/compare/v1.13.4...v1.13.5
[1.13.4]: https://github.com/android-password-store/Android-Password-Store/compare/v1.13.3...v1.13.4
[1.13.3]: https://github.com/android-password-store/Android-Password-Store/compare/v1.13.2...v1.13.3
[1.13.2]: https://github.com/android-password-store/Android-Password-Store/compare/v1.13.1...v1.13.2
[1.13.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.13.0...v1.13.1
[1.13.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.12.1...v1.13.0
[1.12.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.12.0...v1.12.1
[1.12.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.11.3...v1.12.0
[1.11.3]: https://github.com/android-password-store/Android-Password-Store/compare/v1.11.2...v1.11.3
[1.11.2]: https://github.com/android-password-store/Android-Password-Store/compare/v1.11.1...v1.11.2
[1.11.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.11.0...v1.11.1
[1.11.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.10.3...v1.11.0
[1.10.3]: https://github.com/android-password-store/Android-Password-Store/compare/v1.10.2...v1.10.3
[1.10.2]: https://github.com/android-password-store/Android-Password-Store/compare/v1.10.1...v1.10.2
[1.10.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.10.0...v1.10.1
[1.10.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.9.2...v1.10.0
[1.9.2]: https://github.com/android-password-store/Android-Password-Store/compare/v1.9.1...v1.9.2
[1.9.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.9.0...v1.9.1
[1.9.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.8.1...v1.9.0
[1.8.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.8.0..v1.8.1
[1.8.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.7.2..v1.8.0
[1.7.2]: https://github.com/android-password-store/Android-Password-Store/compare/v1.7.1..v1.7.2
[1.7.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.7.0..v1.7.1
[1.7.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.6.0..v1.7.0
[1.6.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.5.0..v1.6.0
[1.5.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.4.0...v1.5.0
[1.4.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.3.0...v1.4.0
[1.3.2]: https://github.com/android-password-store/Android-Password-Store/compare/v1.3.1...v1.3.2
[1.3.1]: https://github.com/android-password-store/Android-Password-Store/compare/v1.3.0...v1.3.1
[1.3.0]: https://github.com/android-password-store/Android-Password-Store/compare/v1.2.0.75...v1.3.0
