/* Copyright 2022 Tusky contributors
 *
 * This file is a part of Pachli.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * Pachli is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Pachli; if not,
 * see <http://www.gnu.org/licenses>.
 */

package app.pachli.core.network.model

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

@JsonClass(generateAdapter = true)
data class NotificationSubscribeResult(
    // Documentation about the type of `id` is inconsistent, showing it as both
    // a string and a number (https://github.com/mastodon/mastodon/issues/36609).
    //
    // Mastodon returns a number, some other servers, like GoToSocial, return
    // a string.
    //
    // Since we don't actually use it for anything ignore it for the moment.
    //
    // val id: Int,
    val endpoint: String,
    @Json(name = "server_key") val serverKey: String,
)
