<div align='center'>
	<h2>mLauncher - Minimal and Clutter Free Android launcher</h2>
    <table align='center'>
        Click on any image to enlarge it. To know more, explore and see for yourself.
        <tr>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/0.png' height='200' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/1.png' height='200' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/2.png' height='200' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/3.png' height='200' alt=""></td>
        </tr>
        <tr>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/4.png' height='200' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/5.png' height='200' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/6.png' height='200' alt=""></td>
            <td><img src='fastlane/metadata/android/en-US/images/phoneScreenshots/7.png' height='200' alt=""></td>
        </tr>
    </table>
    <p>
        <a href='https://apt.izzysoft.de/fdroid/index/apk/app.mlauncher'><img src='https://codeworkscreativehub.github.io/mLauncher/IzzyOnDroid.png' width="150" alt="IzzyOnDroid"></a>
        <a href='http://apps.obtainium.imranr.dev/redirect.html?r=obtainium://add/https://github.com/CodeWorksCreativeHub/mLauncher'><img src='https://codeworkscreativehub.github.io/mLauncher/obtanium.png' width="150" alt="Obtanium"></a>
	<a href='https://play.google.com/store/apps/details?id=app.mlauncher'><img src='https://codeworkscreativehub.github.io/mLauncher/google_play.png' width="150" alt="Obtanium"></a>	    
	<a href='https://f-droid.org/packages/app.mlauncher'><img src='https://codeworkscreativehub.github.io/mLauncher/fdroid.png' width="150" alt="fDroid"></a>
    </p>
    <div align='center'>
        <p>
            <img src='https://img.shields.io/badge/Android-SDK_36-BD93F9?style=flat-square&logo=android&logoColor=white' alt="SDK-36">
            <a href='https://github.com/CodeWorksCreativeHub/mLauncher/blob/main/LICENSE'><img src='https://img.shields.io/github/license/CodeWorksCreativeHub/mLauncher?color=BD93F9&style=flat-square' alt="LICENSE"></a>
            <br>
            <a href='https://github.com/CodeWorksCreativeHub/mLauncher/releases/latest'><img src='https://img.shields.io/github/downloads/CodeWorksCreativeHub/mLauncher/total?color=50FA7B&style=flat-square&label=Overall&logo=github' alt="releases"></a>
            <a href='https://github.com/CodeWorksCreativeHub/mLauncher/releases/latest'><img src="https://img.shields.io/github/downloads/CodeWorksCreativeHub/mLauncher/latest/total?color=50FA7B&style=flat-square&label=Latest&logo=github" alt="GitHub Downloads (all assets, latest release)"></a>
			<br>
			<a href='https://play.google.com/store/apps/details?id=app.mlauncher'><img src='https://img.shields.io/endpoint?url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dapp.mlauncher%26gl%3DUK%26hl%3Den%26l%3D%24name%26m%3D%24totalinstalls&color=50FA7B&style=flat-square&label=Google%20Play&logo=googleplay' alt='Google Play'></a>
            <br>
	    	<a href='https://apt.izzysoft.de/fdroid/index/apk/app.mlauncher'><img alt="IzzyOnDroid (including pre-releases)" src="https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/app.mlauncher&color=FFB86C&style=flat-square&label=IzzyOnDroid"></a>
            <a href='https://github.com/CodeWorksCreativeHub/mLauncher/releases/latest'><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/CodeWorksCreativeHub/mLauncher?color=FFB86C&style=flat-square&label=Github"></a>
	    	<br>
			<a href='https://play.google.com/store/apps/details?id=app.mlauncher'><img src='https://img.shields.io/endpoint?url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dapp.mlauncher%26gl%3DUK%26hl%3Den%26l%3D%24name%26m%3D%24version&color=FFB86C&style=flat-square&label=Google%20Play' alt='Google Play'></a>
            <a href='https://gitlab.com/fdroid/fdroiddata/-/blob/master/metadata/app.mlauncher.yml'><img alt="F-Droid (including pre-releases)" src="https://img.shields.io/f-droid/v/app.mlauncher?color=FFB86C&style=flat-square&label=F-Droid"></a>
            <br>
            <img src='https://img.shields.io/badge/Maintained-yes-FF5555?style=flat-square' alt="Maintained">
        </p>
    </div>
</div>

- Chat with us at [ModMyDevice](https://discord.com/invite/modmydevice) on discord.
- This application can be found
  on [Play Store](https://play.google.com/store/apps/details?id=app.mlauncher), [GitHub](https://github.com/CodeWorksCreativeHub/mLauncher/releases/), [IzzyOnDroid](https://apt.izzysoft.de/fdroid/index/apk/app.mlauncher) & [F-Droid](https://f-droid.org/packages/app.mlauncher/).
- The latest stable version is available on the [main](https://github.com/CodeWorksCreativeHub/mLauncher/tree/main) branch, which can be cloned to build
  the application independently.
- The **original** version of the application is also accessible on
  the [Play Store](https://play.google.com/store/apps/details?id=app.olauncher), [F-Droid](https://f-droid.org/fr/packages/app.olauncher/) & [GitHub](https://github.com/tanujnotes/Olauncher).

We try to balance customizability and minimalization well still being simple :)</h3>

# Forked with extra features

<details><summary>List of features (click to expand)</summary>

- Removed clutter, like ads and links.
- You can rename apps in the app-drawer (Renaming apps on the home screen is already supported. Just long-click on an app on the home screen and start
  typing.)
- We have added a lot more options for gestures on the home screen:
    - Gestures are now:
        - Swiping up, down, left, right
        - Clicking on the clock
        - Clicking on the Date
    - Possible actions now include:
        - Open specified app
        - Display app list
        - Locking the screen
        - Show Recent opened apps
        - Opening the notification drawer
        - Opening the quick settings
        - Power Dialog
        - Take A Screenshot
        - Disable Gesture
- You can also position the clock independently of the home apps.
- Change alignment of apps in app-drawer independent from homescreen.
- Change font size of sections of the homescreen independent of each other.
- Removed internet permission. You never know what an app developer wants to know about you.
- Lock settings behind biometrics (toggle)
- Added the ability to report crashing via email.
- Added the ability to view app usage time.

</details>

## Translations:

We would like to extend our sincere gratitude to the numerous individuals who have contributed to the translation of our application into various
languages. Your efforts have made it possible for users around the world to access and benefit from our product, and we are immensely appreciative of
your hard work and dedication. Thank you all for your invaluable contributions!

<details><summary>List of translations (click to expand)</summary>

- Arabic
- Dutch
- English
- French
- German
- Hebrew
- Italian
- Japanese
- Korean
- Lithuanian
- Polish
- Portuguese
- Russian
- Slovak
- Spanish
- Thai
- Turkish

</details>

## Contribute

- If you are unhappy with any part of the app or feel like missing something, you can open a pull request or an [**issue**](https://github.com/CodeWorksCreativeHub/mLauncher/issues/new/choose) as you like.
    - Please go through the issues marked as `Bug report`, `Crash report` or `Feature request`.
    - Please can we discuss before sending pull requests.
    - Make pull requests to `main` branch.
- Any help in translating mLauncher into other languages is greatly appreciated. If you don't know how to perform a pull request, feel free to check
  out our dedicated [**Wiki**](https://github.com/CodeWorksCreativeHub/mLauncher/wiki).

## License

**mLauncher is proudly licensed under the open source GPL3 license, granting users the freedom to use, study, modify and distribute it at will.**

The Copyleft provision guarantees that these freedoms remain intact, ensuring that Multi Launcher will remain a fully open-source project. With access to
the full source code, anyone can build, fork, and customize the application to their heart's content, unleashing its full potential.

- Multi Launcher does not collect or transmit any data in any way whatsoever.

## Permissions

mLauncher uses the following permissions:

- `android.permission.EXPAND_STATUS_BAR`
    - Allows an application to expand or collapse the status bar.
- `android.permission.QUERY_ALL_PACKAGES`
    - Allows query of any normal app on the device, regardless of manifest declarations. Used to show the apps list.
- `android.alarm.permission.SET_ALARM`
    - Allows an application to broadcast an Intent to set an alarm for the user. Used to open the default alarm app if no other clock app is set in
      the settings.
- `android.permission.REQUEST_DELETE_PACKAGES`
    - Required for issuing the request to remove packages. This does not allow the app to remove apps directly; this only gives the permission to
      issue the request.
- `android.permission.PACKAGE_USAGE_STATS`
    - Allows mLauncher to see usage of other apps to list last used apps first in the app list.

## Credits

- [https://github.com/tanujnotes/Olauncher](https://github.com/tanujnotes/Olauncher)
- [https://github.com/OlauncherCF/OlauncherCF](https://github.com/OlauncherCF/OlauncherCF)

## Donation

We kindly request that you consider supporting the ongoing development of mLauncher by making a donation if you find it to be a useful application.
As a free and open-source product, mLauncher depends entirely on the support and generosity of its users to maintain its continued growth and
accessibility to all.
Please note that while purchasing is not obligatory, even a small donation would go a long way in helping us to keep mLauncher alive and thriving.
We appreciate your continued support, and thank you for your contribution towards the betterment of our product. 😊

<div align='center'>

<a href="https://www.buymeacoffee.com/CreativeCodeCat"><img src="https://img.buymeacoffee.com/button-api/?text=Enjoy+a+Coffee+on+Me&emoji=&slug=CreativeCodeCat&button_colour=FFDD00&font_colour=000000&font_family=Cookie&outline_colour=000000&coffee_colour=ffffff" /></a>

</div>
