# Changelog

All notable changes to this project will be documented in this file. See [conventional commits](https://www.conventionalcommits.org/) for commit guidelines.

## [1.11.3.2 → Unreleased](https://github.com/CodeWorksCreativeHub/mLauncher/tree/main) - In Development

### :sparkles: Enhancements:

* Add options to clear theme and WOTD data ([fe5406f0](https://github.com/CodeWorksCreativeHub/mLauncher/commit/fe5406f0))

### :bug: Bug Fixes:

* Capitalize Czech language name ([639948c1](https://github.com/CodeWorksCreativeHub/mLauncher/commit/639948c1))
* Improve reliability of opening the default SMS app ([0aebba45](https://github.com/CodeWorksCreativeHub/mLauncher/commit/0aebba45))

### :wrench: Code Quality:

* Refactor language change implementation ([2b7c7d77](https://github.com/CodeWorksCreativeHub/mLauncher/commit/2b7c7d77))
* Check for internet before showing crash dialog ([c7cafa34](https://github.com/CodeWorksCreativeHub/mLauncher/commit/c7cafa34))
* Adopt Gradle version catalog for plugins ([42b75b56](https://github.com/CodeWorksCreativeHub/mLauncher/commit/42b75b56))

### :globe_with_meridians: Localization:

* Updated Language Files. ([#977](https://github.com/CodeWorksCreativeHub/mLauncher/pull/977)) ([c7850232](https://github.com/CodeWorksCreativeHub/mLauncher/commit/c7850232))
* Updated Language Files. ([#976](https://github.com/CodeWorksCreativeHub/mLauncher/pull/976)) ([51970918](https://github.com/CodeWorksCreativeHub/mLauncher/commit/51970918))

## [1110302 (1.11.3.2) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.3.2) - (29, December 2025)

### :sparkles: Enhancements:

* Relocate Expert Options easter egg to About section ([2fdf9809](https://github.com/CodeWorksCreativeHub/mLauncher/commit/2fdf9809))
* Add increment/decrement buttons to slider dialog ([981f8d9f](https://github.com/CodeWorksCreativeHub/mLauncher/commit/981f8d9f))
* Migrate to Material Design 3 ([803c8444](https://github.com/CodeWorksCreativeHub/mLauncher/commit/803c8444))

### :wrench: Code Quality:

* Improve crash report payload and reduce cooldown ([b6604421](https://github.com/CodeWorksCreativeHub/mLauncher/commit/b6604421))
* Migrate to AppCompatDelegate for language handling ([9a196f64](https://github.com/CodeWorksCreativeHub/mLauncher/commit/9a196f64))
* Cache localized resources to improve performance ([bf9999d9](https://github.com/CodeWorksCreativeHub/mLauncher/commit/bf9999d9))
* Make AppViewHolder a static nested class ([9ada91e9](https://github.com/CodeWorksCreativeHub/mLauncher/commit/9ada91e9))
* Replace AndroidView with Compose Text ([710ef168](https://github.com/CodeWorksCreativeHub/mLauncher/commit/710ef168))
* Replace XML switch with Compose implementation ([d35ddef9](https://github.com/CodeWorksCreativeHub/mLauncher/commit/d35ddef9))

### :broom: Maintenance & Cleanup:

* Rename package from `droidworksstudio` to `codeworkscreativehub` ([f6d7534d](https://github.com/CodeWorksCreativeHub/mLauncher/commit/f6d7534d))

## [1110301 (1.11.3.1) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.3.1) - (26, December 2025)

### :sparkles: Enhancements:

* Improve settings UI and state management ([b71182b7](https://github.com/CodeWorksCreativeHub/mLauncher/commit/b71182b7))
* Add close icon to app drawer search view ([aaaa1b8a](https://github.com/CodeWorksCreativeHub/mLauncher/commit/aaaa1b8a))

### :bug: Bug Fixes:

* Adjust App Drawer search bar layout ([4579c5e1](https://github.com/CodeWorksCreativeHub/mLauncher/commit/4579c5e1))

### :wrench: Code Quality:

* Adjust spacing and padding in settings ([4e489d26](https://github.com/CodeWorksCreativeHub/mLauncher/commit/4e489d26))
* Improve App Drawer search bar layout ([5e8a98d3](https://github.com/CodeWorksCreativeHub/mLauncher/commit/5e8a98d3))

### :globe_with_meridians: Localization:

* Updated Language Files. ([#966](https://github.com/CodeWorksCreativeHub/mLauncher/pull/966)) ([e8c02382](https://github.com/CodeWorksCreativeHub/mLauncher/commit/e8c02382))

## [1110300 (1.11.3.0) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.3.0) - (25, December 2025)

### :sparkles: Enhancements:

* Improve solid color wallpaper quality ([108a4a30](https://github.com/CodeWorksCreativeHub/mLauncher/commit/108a4a30))

### :bug: Bug Fixes:

* Convert search bar to ConstraintLayout to fix alignment ([b04b71c3](https://github.com/CodeWorksCreativeHub/mLauncher/commit/b04b71c3))

## [1110208 (1.11.2.8) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.2.8) - (22, December 2025)

### :bug: Bug Fixes:

* Improve error handling for word list import ([089f7c06](https://github.com/CodeWorksCreativeHub/mLauncher/commit/089f7c06))
* Add exception handling for restore operations ([1ae83873](https://github.com/CodeWorksCreativeHub/mLauncher/commit/1ae83873))
* Add rate limit to crash reporting ([f1e47959](https://github.com/CodeWorksCreativeHub/mLauncher/commit/f1e47959))
* Correct pin/unpin icon logic in context menu ([53752245](https://github.com/CodeWorksCreativeHub/mLauncher/commit/53752245))

## [1110207 (1.11.2.7) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.2.7) - (19, November 2025)

### :sparkles: Enhancements:

* Improve release announcement formatting ([6a048baa](https://github.com/CodeWorksCreativeHub/mLauncher/commit/6a048baa))

### :broom: Maintenance & Cleanup:

* Add rules for DeviceInfo and Moshi ([bf067e79](https://github.com/CodeWorksCreativeHub/mLauncher/commit/bf067e79))

## [1110206 (1.11.2.6) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.2.6) - (17, November 2025)

### :sparkles: Enhancements:

* Add smart weather app launcher ([d21717e7](https://github.com/CodeWorksCreativeHub/mLauncher/commit/d21717e7))
* Add weather widget click handler ([09ace13b](https://github.com/CodeWorksCreativeHub/mLauncher/commit/09ace13b))

### :bug: Bug Fixes:

* Send actual exception string in crash report ([ba78f788](https://github.com/CodeWorksCreativeHub/mLauncher/commit/ba78f788))

### :wrench: Code Quality:

* Improve list building and sorting logic ([19dc35a5](https://github.com/CodeWorksCreativeHub/mLauncher/commit/19dc35a5))
* Add comments to app filtering logic in MainViewModel ([ccafe0b0](https://github.com/CodeWorksCreativeHub/mLauncher/commit/ccafe0b0))
* Optimize list sorting and indexing logic ([d1571acb](https://github.com/CodeWorksCreativeHub/mLauncher/commit/d1571acb))

## [1110205 (1.11.2.5) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.2.5) - (21, October 2025)

### :bug: Bug Fixes:

* prevent icon pack icons from showing in app list when disabled ([6a3d504b](https://github.com/CodeWorksCreativeHub/mLauncher/commit/6a3d504b))

## [1110204 (1.11.2.4) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.2.4) - (20, October 2025)

### :sparkles: Enhancements:

* Implement native crash reporting service ([4d750cb8](https://github.com/CodeWorksCreativeHub/mLauncher/commit/4d750cb8))
* Add grab line to bottom and top sheet dialogs ([6a81010d](https://github.com/CodeWorksCreativeHub/mLauncher/commit/6a81010d))
* Move cache files to cache directory ([2e383825](https://github.com/CodeWorksCreativeHub/mLauncher/commit/2e383825))
* Configure Room schema for WidgetDatabase ([802c1b1a](https://github.com/CodeWorksCreativeHub/mLauncher/commit/802c1b1a))

### :wrench: Code Quality:

* Use CardView for Top and Bottom Sheets ([e1b5abe2](https://github.com/CodeWorksCreativeHub/mLauncher/commit/e1b5abe2))
* Rearchitect FontBottomSheetDialogLocked ([84de7e2e](https://github.com/CodeWorksCreativeHub/mLauncher/commit/84de7e2e))
* Rename LockedBottomSheetDialog to FontBottomSheetDialogLocked and move to shared component package ([899cba8c](https://github.com/CodeWorksCreativeHub/mLauncher/commit/899cba8c))
* Implement Device Admin for screen lock ([f4f8eec3](https://github.com/CodeWorksCreativeHub/mLauncher/commit/f4f8eec3))
* Improve performance and readability ([ebb3ece7](https://github.com/CodeWorksCreativeHub/mLauncher/commit/ebb3ece7))
* Optimize app list loading and sorting ([354b0ce4](https://github.com/CodeWorksCreativeHub/mLauncher/commit/354b0ce4))

### :globe_with_meridians: Localization:

* Updated Language Files. ([#936](https://github.com/CodeWorksCreativeHub/mLauncher/pull/936)) ([dd0bc103](https://github.com/CodeWorksCreativeHub/mLauncher/commit/dd0bc103))

## [1110203 (1.11.2.3) - Multi Launcher ‧ Home Screen](https://github.com/CodeWorksCreativeHub/mLauncher/tree/1.11.2.3) - (16, October 2025)

### :sparkles: Enhancements:

* Add option to force colored wallpaper ([03fac865](https://github.com/CodeWorksCreativeHub/mLauncher/commit/03fac865))

### :bug: Bug Fixes:

* Adjust font sizes for consistency ([07046ce1](https://github.com/CodeWorksCreativeHub/mLauncher/commit/07046ce1))

### :books: Documentation:

* Remove "Known Issues" references ([06a9923f](https://github.com/CodeWorksCreativeHub/mLauncher/commit/06a9923f))

---
> Generated by CodeWorks Creative Hub