# Contributing to mLauncher

We love your input! Contributing to this project can include:

- Reporting a bug  
- Discussing the code  
- Submitting a fix  
- Proposing new features  
- Becoming a maintainer  

Following these guidelines helps make the contribution process smooth for everyone and ensures that all contributors’ time is respected. In return, we will review issues, assess changes, and help finalize pull requests efficiently.

## Quick Links

* [Code of Conduct](#code-of-conduct)  
* [Getting Started](#getting-started)  
    * [Using GitHub](#using-github)  
    * [Pull Requests](#pull-requests)  
    * [Issues](#issues)  
    * [Code Style](#code-style)  
* [License](#license)  

## Code of Conduct

By participating in this project, you agree to uphold our [Code of Conduct](CODE-OF-CONDUCT.md). We expect all contributors to communicate respectfully and maintain a positive, inclusive environment.

## Getting Started

All contributions are made via **Issues** and **Pull Requests (PRs)**.

- **Check existing issues and PRs** before submitting new ones.  
- Friendly comments or pings can help maintainers notice important or blocking issues.  

### Using GitHub

We use GitHub to host code, track issues, and accept PRs.

### Pull Requests

We follow a **fork-and-pull Git workflow**:

1. Fork the repository to your GitHub account.  
2. Clone your fork locally.  
3. Create a descriptive branch.  
4. Commit your changes following formatting and testing guidelines.  
5. Push changes to your fork.  
6. Open a PR using the template.  

**Best practices for PRs:**

- Address one concern per PR.  
- Focus on a single functionality or widespread style fixes, not both.  
- Keep changes minimal for easier review.  
- Use the PR template for clarity.  

For major changes or breaking updates, open an issue first to discuss your proposal.

### Issues

Use issues to report bugs, request features, or discuss potential changes.  

- **Check for existing issues** and add your input rather than opening duplicates.  
- Use [reactions](https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) to signal impact.  
- **Report bugs with detail**:  

  - Summary or background  
  - Steps to reproduce (include code if possible)  
  - Expected vs. actual behavior  
  - Notes on potential causes or prior attempts  

### Code Style

- Use **4 spaces** for indentation (no tabs).  
- Maintain consistent formatting throughout your code.  

## License

All contributions are under the **GPL-3.0 License**. By submitting changes, you agree that your contributions will be licensed under the same terms as this project.  

[GPL-3.0 License Details](http://choosealicense.com/licenses/gpl-3.0/)
