# Theme Folder

This folder contains exported themes for the MultiLauncher. Themes are stored as `.mtheme` files, which are JSON-based and contain the theme-related
`SharedPreferences` settings.

## Exporting a Theme

1. Open the MultiLauncher settings.
2. Navigate to the advanced section.
3. Click `Theme Creations` then Export.
4. Choose a filename (must have the `.mtheme` extension).
5. Save the file to your desired location.

## Importing a Theme

1. Open the MultiLauncher settings.
2. Navigate to the advanced section.
3. Click `Theme Creations` then Import.
4. Select an `.mtheme` file from your device.
5. The theme settings will be applied after verification.

## `.mtheme` File Format

- The `.mtheme` file is an XML file containing key-value pairs corresponding to `SharedPreferences` settings.
- Keys follow the format `keyName` to ensure compatibility with the launcher.
- Examples:
    - [Download AdaptaDark Theme](AdaptaDark.mtheme)
    - [Download AdaptaLight Theme](AdaptaLight.mtheme)
    - [Download AyuDark Theme](AyuDark.mtheme)
    - [Download BreezeDark Theme](BreezeDark.mtheme)
    - [Download Catppuccin Theme](Catppuccin.mtheme)
        - [Download Cyberpunk Theme](Cyberpunk.mtheme)
        - [Download Dracula Theme](Dracula.mtheme)
        - [Download GruvboxDark Theme](GruvboxDark.mtheme)
    - [Download GruvboxLight Theme](GruvboxLight.mtheme)
        - [Download Layan Theme](Layan.mtheme)
        - [Download MaterialDark Theme](MaterialDark.mtheme)
        - [Download MojaveLight Theme](MojaveLight.mtheme)
        - [Download Monokai Theme](Monokai.mtheme)
        - [Download NightOwl Theme](NightOwl.mtheme)
        - [Download Nord Theme](Nord.mtheme)
        - [Download OneDark Theme](OneDark.mtheme)
        - [Download Palenight Theme](Palenight.mtheme)
        - [Download SolarizedDark Theme](SolarizedDark.mtheme)
    - [Download SolarizedLight Theme](SolarizedLight.mtheme)
        - [Download TangoDark Theme](TangoDark.mtheme)
    - [Download Tomorrow Theme](Tomorrow.mtheme)
        - [Download UbuntuLight Theme](UbuntuLight.mtheme)

## Notes

- Only valid `.mtheme` files will be imported.
- If an invalid file is detected, an error message will be shown.

For any issues, refer to the launcher documentation or contact support.
