"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertPathToPosix = convertPathToPosix;
exports.findSharedRoot = findSharedRoot;
var path_1 = __importDefault(require("path"));
/** Format the path in posix format. */
function convertPathToPosix(path) {
    return path.includes('\\') ? path.replace(/\\/g, '/') : path;
}
/**
 * Find the shared root of all provided paths.
 * This will split all paths by segments and find the longest common prefix.
 * Note, this works for both posix and non-posix paths.
 */
function findSharedRoot(paths) {
    if (!paths.length) {
        return null;
    }
    var sharedRoot = [];
    for (var _i = 0, paths_1 = paths; _i < paths_1.length; _i++) {
        var item = paths_1[_i];
        var segments = item.split(path_1.default.sep);
        if (!sharedRoot.length) {
            sharedRoot = segments;
            continue;
        }
        for (var i = 0; i < sharedRoot.length; i++) {
            if (sharedRoot[i] !== segments[i]) {
                sharedRoot = sharedRoot.slice(0, i);
                break;
            }
        }
    }
    return sharedRoot.join(path_1.default.sep);
}
//# sourceMappingURL=paths.js.map