export declare class AtlasError extends Error {
    /** A property to determine if any of the extended errors are atlas-specific errors */
    readonly type = "AtlasError";
    /** The error (class) name */
    readonly name: string;
    /** The error code, specifically for these types of errors */
    readonly code?: string;
    constructor(code: string, message?: string, options?: ErrorOptions);
}
export declare class AtlasValidationError extends AtlasError {
    readonly filePath: string;
    readonly incompatibleVersion?: string | undefined;
    constructor(code: 'ATLAS_FILE_NOT_FOUND' | 'ATLAS_FILE_INCOMPATIBLE', filePath: string, incompatibleVersion?: string | undefined);
}
export declare function handleError(error: Error): boolean;
//# sourceMappingURL=errors.d.ts.map