import type metro from 'metro';
import type { MetroConfig } from 'metro-config';
import type { AtlasBundle, AtlasModule, AtlasSource } from './types';
type MetroGraph = metro.Graph | metro.ReadOnlyGraph;
type MetroModule = metro.Module;
type ConvertGraphToAtlasOptions = {
    projectRoot: string;
    entryPoint: string;
    preModules: readonly MetroModule[];
    graph: MetroGraph;
    serializeOptions: Readonly<metro.SerializerOptions>;
    /** Options passed-through from the Metro config */
    metroConfig: {
        watchFolders?: readonly string[];
        resolver?: {
            sourceExts?: readonly string[];
            assetExts?: readonly string[];
        };
    };
};
export declare class MetroGraphSource implements AtlasSource {
    /** All known entries, and detected changes, stored by ID */
    readonly entries: Map<AtlasBundle['id'], AtlasBundle>;
    constructor();
    hasHmrSupport(): boolean;
    getBundleHmr(id: string): {
        bundleId: string;
        socketUrl: URL;
        entryPoints: string[];
    } | null;
    listBundles(): {
        id: string;
        platform: "android" | "ios" | "web" | "unknown";
        environment: "client" | "dom" | "node" | "react-server";
        projectRoot: string;
        sharedRoot: string;
        entryPoint: string;
    }[];
    getBundle(id: string): AtlasBundle;
    /**
     * Serializes the Metro graph, converting it to an Atlas entry.
     * This also registers a listener to the Metro server to track changes, when possible.
     * All data is kept in memory, where stale data is overwritten by new data.
     */
    serializeGraph(options: ConvertGraphToAtlasOptions): AtlasBundle;
}
/** Convert options from the Metro config, used during graph conversions to Atlas */
export declare function convertMetroConfig(config: MetroConfig): ConvertGraphToAtlasOptions['metroConfig'];
/** Convert a Metro graph instance to a JSON-serializable entry */
export declare function convertGraph(options: ConvertGraphToAtlasOptions): AtlasBundle;
/** Find and collect all dependnecies related to the entrypoint within the graph */
export declare function collectEntryPointModules(options: Pick<ConvertGraphToAtlasOptions, 'graph' | 'entryPoint' | 'serializeOptions' | 'metroConfig'>, sharedRoot: string): Map<string, AtlasModule>;
/** Convert a Metro module to a JSON-serializable Atlas module */
export declare function convertModule(options: Pick<ConvertGraphToAtlasOptions, 'graph' | 'metroConfig' | 'serializeOptions'>, module: MetroModule, sharedRoot: string): AtlasModule;
/** Convert Metro transform options to a JSON-serializable object */
export declare function convertTransformOptions(options: Pick<ConvertGraphToAtlasOptions, 'graph'>): AtlasBundle['transformOptions'];
/** Convert Metro serialize options to a JSON-serializable object */
export declare function convertSerializeOptions(options: Pick<ConvertGraphToAtlasOptions, 'serializeOptions'>): AtlasBundle['serializeOptions'];
export {};
//# sourceMappingURL=MetroGraphSource.d.ts.map