# react-native-toast-message

[![npm version](https://img.shields.io/npm/v/react-native-toast-message)](https://www.npmjs.com/package/react-native-toast-message)
[![npm downloads](https://img.shields.io/npm/dw/react-native-toast-message)](https://www.npmjs.com/package/react-native-toast-message)
[![Build](https://github.com/calintamas/react-native-toast-message/actions/workflows/publish.yml/badge.svg)](https://github.com/calintamas/react-native-toast-message/actions/workflows/publish.yml?query=workflow%3Abuild)
[![Coverage Status](https://coveralls.io/repos/github/calintamas/react-native-toast-message/badge.svg?branch=master)](https://coveralls.io/github/calintamas/react-native-toast-message?branch=main)
[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg)](https://github.com/prettier/prettier)

Animated toast message component for React Native.

![toast gif](./docs/toast.gif)

## Features

- 🚀 Imperative API
- 📦 Very lightweight (~40 kB)
- ⌨️ Keyboard-aware
- 🎨 Customizable layouts
- 🔧 Flexible config

## Documentation

> This is the documentation for `react-native-toast-message@v2`, which has a similar API to v1, but contains a few important changes. [Read the complete changelog](https://github.com/calintamas/react-native-toast-message/releases/tag/v2.0.0).

- [Quick start](./docs/quick-start.md)
- [API](./docs/api.md)
- [Create custom layouts](./docs/custom-layouts.md)
- FAQ
  - [How to show the Toast inside a Modal?](./docs/modal-usage.md)
  - [How to render the Toast when using a Navigation library?](./docs/navigation-usage.md)
  - [How to mock the library for testing with jest?](./docs/jest-testing.md)

## License

MIT
