import React from 'react';
import { TouchableOpacityProps, TouchableNativeFeedbackProps, StyleProp, ViewStyle, ActivityIndicatorProps, TextStyle } from 'react-native';
import { RneFunctionComponent } from '../helpers';
import { IconNode } from '../icons/Icon';
import { TextProps } from '../text/Text';
export declare type ButtonProps = TouchableOpacityProps & TouchableNativeFeedbackProps & {
    title?: string | React.ReactElement<{}>;
    titleStyle?: StyleProp<TextStyle>;
    titleProps?: TextProps;
    buttonStyle?: StyleProp<ViewStyle>;
    type?: 'solid' | 'clear' | 'outline';
    loading?: boolean;
    loadingStyle?: StyleProp<ViewStyle>;
    loadingProps?: ActivityIndicatorProps;
    containerStyle?: StyleProp<ViewStyle>;
    icon?: IconNode;
    iconContainerStyle?: StyleProp<ViewStyle>;
    iconRight?: boolean;
    linearGradientProps?: object;
    TouchableComponent?: typeof React.Component;
    ViewComponent?: typeof React.Component;
    disabled?: boolean;
    disabledStyle?: StyleProp<ViewStyle>;
    disabledTitleStyle?: StyleProp<TextStyle>;
    raised?: boolean;
    iconPosition?: 'left' | 'right' | 'top' | 'bottom';
};
declare const Button: RneFunctionComponent<ButtonProps>;
export { Button };
declare const _default: React.FunctionComponent<Omit<ButtonProps, keyof import("../config").ThemeProps<T>>> | React.ForwardRefExoticComponent<ButtonProps>;
export default _default;
