import connect from 'connect';
import { type AtlasSource } from '../data/types';
/**
 * Initialize Expo Atlas to gather statistics from Metro during development.
 * This function creates a connect middleware to serve the webui and the Atlas API.
 * It's designed to use any `AtlasSource` implementation and passes it to the webui.
 *
 * @example ```js
 *   import { createAtlasMiddleware, MetroGraphSource } from 'expo-atlas/middleware';
 *
 *   const source = new MetroGraphSource();
 *   const middleware = createAtlasMiddleware(source);
 *
 *   source.onSerializeGraph(...);
 *   app.use('/_expo/atlas', middleware);
 * ```
 */
export declare function createAtlasMiddleware(source: AtlasSource): connect.Server;
//# sourceMappingURL=middleware.d.ts.map