import readline from 'readline';
/**
 * Iterate through lines of a ndjson/jsonl file using streams.
 * This won't parse the actual JSON but invokes the callback for each line.
 *
 * @note Line numbers starts at `1`
 */
export declare function forEachJsonLines(filePath: string, callback: (lineContent: string, lineNumber: number, reader: readline.Interface) => any): Promise<void>;
/**
 * Parse a single line of a jsonl/ndjson file using streams.
 * Once the line is found, iteration is stopped and the parsed JSON is returned.
 *
 * @note Line numbers starts at `1`
 */
export declare function parseJsonLine<T = any>(filePath: string, lineNumber: number): Promise<T>;
/** Append a single line of json data to a jsonl/ndjson file using streams. */
export declare function appendJsonLine(filePath: string, data: unknown): Promise<void>;
//# sourceMappingURL=jsonl.d.ts.map