"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AtlasValidationError = exports.AtlasError = void 0;
exports.handleError = handleError;
var AtlasError = /** @class */ (function (_super) {
    __extends(AtlasError, _super);
    function AtlasError(code, message, options) {
        if (message === void 0) { message = ''; }
        var _this = _super.call(this, message, options) || this;
        /** A property to determine if any of the extended errors are atlas-specific errors */
        _this.type = 'AtlasError';
        _this.name = _this.constructor.name;
        _this.code = code;
        return _this;
    }
    return AtlasError;
}(Error));
exports.AtlasError = AtlasError;
var AtlasValidationError = /** @class */ (function (_super) {
    __extends(AtlasValidationError, _super);
    function AtlasValidationError(code, filePath, incompatibleVersion) {
        var _this = _super.call(this, code, code === 'ATLAS_FILE_NOT_FOUND'
            ? "Atlas file not found: ".concat(filePath)
            : "Atlas file is incompatible with this version.") || this;
        _this.filePath = filePath;
        _this.incompatibleVersion = incompatibleVersion;
        return _this;
    }
    return AtlasValidationError;
}(AtlasError));
exports.AtlasValidationError = AtlasValidationError;
function handleError(error) {
    if (error instanceof AtlasError) {
        console.error("".concat(error.message, " (").concat(error.code, ")"));
        return true;
    }
    throw error;
}
//# sourceMappingURL=errors.js.map