"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilAtlasFileReady = void 0;
exports.withExpoAtlas = withExpoAtlas;
exports.resetExpoAtlasFile = resetExpoAtlasFile;
var AtlasFileSource_1 = require("./data/AtlasFileSource");
var MetroGraphSource_1 = require("./data/MetroGraphSource");
var AtlasFileSource_2 = require("./data/AtlasFileSource");
Object.defineProperty(exports, "waitUntilAtlasFileReady", { enumerable: true, get: function () { return AtlasFileSource_2.waitUntilAtlasFileReady; } });
/**
 * Initialize Expo Atlas to gather statistics from Metro when exporting bundles.
 * This function adds the required Metro config, and should be the last config mutation.
 *
 * @example ```js
 *   // Learn more https://docs.expo.dev/guides/customizing-metro
 *   const { getDefaultConfig } = require('expo/metro-config')
 *   const { withExpoAtlas } = require('expo-atlas/metro')
 *
 *   const config = getDefaultConfig(__dirname)
 *
 *   // Make more changes
 *
 *   module.exports = withExpoAtlas(config)
 * ```
 */
function withExpoAtlas(config, options) {
    var _a, _b, _c;
    if (options === void 0) { options = {}; }
    var projectRoot = config.projectRoot;
    var originalSerializer = (_b = (_a = config.serializer) === null || _a === void 0 ? void 0 : _a.customSerializer) !== null && _b !== void 0 ? _b : (function () { });
    if (!projectRoot) {
        throw new Error('No "projectRoot" configured in Metro config.');
    }
    var atlasFile = (_c = options === null || options === void 0 ? void 0 : options.atlasFile) !== null && _c !== void 0 ? _c : (0, AtlasFileSource_1.getAtlasPath)(projectRoot);
    var metroConfig = (0, MetroGraphSource_1.convertMetroConfig)(config);
    // Note(cedric): we don't have to await this, Metro would never bundle before this is finishes
    (0, AtlasFileSource_1.ensureAtlasFileExist)(atlasFile);
    // @ts-expect-error
    config.serializer.customSerializer = function (entryPoint, preModules, graph, serializeOptions) {
        // Note(cedric): we don't have to await this, it has a built-in write queue
        (0, AtlasFileSource_1.writeAtlasEntry)(atlasFile, (0, MetroGraphSource_1.convertGraph)({ projectRoot: projectRoot, entryPoint: entryPoint, preModules: preModules, graph: graph, serializeOptions: serializeOptions, metroConfig: metroConfig }));
        return originalSerializer(entryPoint, preModules, graph, serializeOptions);
    };
    return config;
}
/**
 * Fully reset, or recreate, the Expo Atlas file containing all Metro information.
 * This method should only be called once per exporting session, to avoid overwriting data with mutliple Metro instances.
 */
function resetExpoAtlasFile(projectRoot) {
    return __awaiter(this, void 0, void 0, function () {
        var filePath;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    filePath = (0, AtlasFileSource_1.getAtlasPath)(projectRoot);
                    return [4 /*yield*/, (0, AtlasFileSource_1.createAtlasFile)(filePath)];
                case 1:
                    _a.sent();
                    return [2 /*return*/, filePath];
            }
        });
    });
}
//# sourceMappingURL=metro.js.map