import { type MetroConfig } from 'metro-config';
export { waitUntilAtlasFileReady } from './data/AtlasFileSource';
type ExpoAtlasOptions = Partial<{
    /** The output of the atlas file, defaults to `.expo/atlas.json` */
    atlasFile: string;
}>;
/**
 * Initialize Expo Atlas to gather statistics from Metro when exporting bundles.
 * This function adds the required Metro config, and should be the last config mutation.
 *
 * @example ```js
 *   // Learn more https://docs.expo.dev/guides/customizing-metro
 *   const { getDefaultConfig } = require('expo/metro-config')
 *   const { withExpoAtlas } = require('expo-atlas/metro')
 *
 *   const config = getDefaultConfig(__dirname)
 *
 *   // Make more changes
 *
 *   module.exports = withExpoAtlas(config)
 * ```
 */
export declare function withExpoAtlas(config: MetroConfig, options?: ExpoAtlasOptions): import("metro-config").InputConfigT;
/**
 * Fully reset, or recreate, the Expo Atlas file containing all Metro information.
 * This method should only be called once per exporting session, to avoid overwriting data with mutliple Metro instances.
 */
export declare function resetExpoAtlasFile(projectRoot: string): Promise<string>;
//# sourceMappingURL=metro.d.ts.map