import type { ConfigT as MetroConfig } from 'metro-config';
import { MetroGraphSource } from './data/MetroGraphSource';
/**
 * Iniitalize Expo Atlas to gather statistics from Metro when exporting bundles.
 * This function adds the required Metro config, and should be used inside the Expo CLI.
 *
 * @example ```js
 *   const atlasFromProject = requireFrom(projectRoot, 'expo-atlas/cli');
 *   const atlas = atlasFromProject?.createExpoAtlasMiddleware(config);
 *
 *   if (atlas) {
 *     // Register the Atlas middleware, to serve the UI and API.
 *     middleware.use('/_expo/atlas', atlasFromProject.middleware);
 *   }
 * ```
 */
export declare function createExpoAtlasMiddleware(config: MetroConfig): {
    source: MetroGraphSource;
    middleware: import("connect").Server;
    /** @deprecated This method does nothing and will be removed in the next major version */
    registerMetro(): void;
};
//# sourceMappingURL=cli.d.ts.map