package app.hypostats.domain

import app.hypostats.ui.model.AppTheme
import app.hypostats.ui.model.CarbIcon
import kotlinx.coroutines.flow.Flow

interface SettingsRepository {
    fun getAppTheme(): Flow<AppTheme>

    suspend fun setAppTheme(theme: AppTheme)

    fun getCarbIncrement(): Flow<Int>

    suspend fun setCarbIncrement(increment: Int)

    fun getCarbIcon(): Flow<CarbIcon>

    suspend fun setCarbIcon(icon: CarbIcon)
}
