package app.hypostats.ui.settings.components

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import app.hypostats.R

@Composable
fun ExpandableSettingSection(
    title: String,
    currentValue: String,
    expanded: Boolean,
    onExpandedChange: (Boolean) -> Unit,
    content: @Composable () -> Unit,
) {
    Card(
        modifier = Modifier.fillMaxWidth(),
    ) {
        Column {
            Row(
                modifier =
                    Modifier
                        .fillMaxWidth()
                        .clickable { onExpandedChange(!expanded) }
                        .padding(16.dp),
                horizontalArrangement = Arrangement.SpaceBetween,
                verticalAlignment = Alignment.CenterVertically,
            ) {
                Column(modifier = Modifier.weight(1f)) {
                    Text(
                        text = title,
                        style = MaterialTheme.typography.titleMedium,
                    )
                    if (!expanded) {
                        Text(
                            text = currentValue,
                            style = MaterialTheme.typography.bodyMedium,
                            color = MaterialTheme.colorScheme.onSurfaceVariant,
                            modifier = Modifier.padding(top = 4.dp),
                        )
                    }
                }
                val iconRes = if (expanded) R.drawable.keyboard_arrow_up_24 else R.drawable.keyboard_arrow_down_24
                Icon(
                    painter = painterResource(iconRes),
                    contentDescription = if (expanded) "Collapse" else "Expand",
                )
            }

            if (expanded) {
                Column {
                    HorizontalDivider()
                    content()
                }
            }
        }
    }
}

@Preview
@Composable
private fun ExpandableSettingSectionCollapsedPreview() {
    MaterialTheme {
        ExpandableSettingSection(
            title = "Language",
            currentValue = "English",
            expanded = false,
            onExpandedChange = { },
        ) {
            Text("Options here", modifier = Modifier.padding(16.dp))
        }
    }
}

@Preview
@Composable
private fun ExpandableSettingSectionExpandedPreview() {
    MaterialTheme {
        ExpandableSettingSection(
            title = "Language",
            currentValue = "English",
            expanded = true,
            onExpandedChange = { },
        ) {
            Column(modifier = Modifier.padding(16.dp)) {
                Text("System default")
                Text("English")
                Text("Čeština")
            }
        }
    }
}
