/*!
 * This file acts as the connector/bridge between Stencil and Jest.
 *
 * It defines/caches a `JestFacade` implementation to dispatch Jest-related configuration calls to the correct section
 * of the Stencil codebase.
 *
 * It contains the APIs that are designed to be used by the Jest pre-configurations supplied by Stencil.
 */
/**
 * Retrieve the numeric representation of the major version of Jest being used.
 *
 * If a user has Jest v27.1.0 installed, `27` will be returned.
 *
 * @returns the major version of Jest detected
 */
export declare const getVersion: () => number;
/**
 * Retrieve the default Jest runner name prescribed by Stencil
 *
 * @returns the stringified name of the test runner, based on the currently detected version of Stencil
 */
export declare const getDefaultJestRunner: () => string;
/**
 * Retrieve the Stencil-Jest test runner based on the version of Jest that's installed.
 *
 * @returns a test runner for Stencil tests, based on the version of Jest that's detected
 */
export declare const getRunner: () => (config: any, e2eEnv: any) => Promise<boolean>;
/**
 * Retrieve the Stencil-Jest screenshot facade implementation based on the version of Jest that's installed.
 *
 * @returns a screenshot facade implementation for Stencil tests, based on the version of Jest that's detected
 */
export declare const getScreenshot: () => (config: any, e2eEnv: any) => Promise<boolean>;
/**
 * Retrieve the Jest-Puppeteer Environment, based on the version of Jest that is installed
 *
 * @returns a function capable of creating a Jest-Puppeteer environment
 */
export declare const getCreateJestPuppeteerEnvironment: () => () => any;
/**
 * Retrieve the Jest preprocessor, based on the version of Jest that is installed
 *
 * @returns a Jest preprocessor to transform code at test time
 */
export declare const getJestPreprocessor: () => import("./jest-apis").JestPreprocessor;
/**
 * Retrieve the Jest-Runner, based on the version of Jest that is installed
 *
 * @returns a function capable of creating a Jest test runner
 */
export declare const getCreateJestTestRunner: () => any;
/**
 * Retrieve the Jest-setup function, based on the version of Jest that is installed
 *
 * @returns a function capable of setting up Jest
 */
export declare const getJestSetupTestFramework: () => () => void;
/**
 * Retrieve Stencil's Jest presets for the detected version of Jest
 *
 * @returns an object representing a Jest preset
 */
export declare const getJestPreset: () => Partial<{
    automock: boolean;
    bail: number | boolean;
    cache: boolean;
    cacheDirectory: string;
    ci: boolean;
    clearMocks: boolean;
    changedFilesWithAncestor: boolean;
    changedSince: string;
    collectCoverage: boolean;
    collectCoverageFrom: string[];
    collectCoverageOnlyFrom: {
        [key: string]: boolean;
    };
    coverageDirectory: string;
    coveragePathIgnorePatterns: string[];
    coverageProvider: "v8" | "babel";
    coverageReporters: import("@jest/types/build/Config").CoverageReporters;
    coverageThreshold: {
        [path: string]: import("@jest/types/build/Config").CoverageThresholdValue;
        global: import("@jest/types/build/Config").CoverageThresholdValue;
    };
    dependencyExtractor: string;
    detectLeaks: boolean;
    detectOpenHandles: boolean;
    displayName: string | import("@jest/types/build/Config").DisplayName;
    expand: boolean;
    extensionsToTreatAsEsm: string[];
    extraGlobals: string[];
    filter: string;
    findRelatedTests: boolean;
    forceCoverageMatch: string[];
    forceExit: boolean;
    json: boolean;
    globals: import("@jest/types/build/Config").ConfigGlobals;
    globalSetup: string;
    globalTeardown: string;
    haste: import("@jest/types/build/Config").HasteConfig;
    injectGlobals: boolean;
    reporters: (string | import("@jest/types/build/Config").ReporterConfig)[];
    logHeapUsage: boolean;
    lastCommit: boolean;
    listTests: boolean;
    maxConcurrency: number;
    maxWorkers: string | number;
    moduleDirectories: string[];
    moduleFileExtensions: string[];
    moduleLoader: string;
    moduleNameMapper: {
        [key: string]: string | string[];
    };
    modulePathIgnorePatterns: string[];
    modulePaths: string[];
    name: string;
    noStackTrace: boolean;
    notify: boolean;
    notifyMode: string;
    onlyChanged: boolean;
    onlyFailures: boolean;
    outputFile: string;
    passWithNoTests: boolean;
    preprocessorIgnorePatterns: string[];
    preset: string;
    prettierPath: string;
    projects: (string | import("@jest/types/build/Config").InitialProjectOptions)[];
    replname: string;
    resetMocks: boolean;
    resetModules: boolean;
    resolver: string;
    restoreMocks: boolean;
    rootDir: string;
    roots: string[];
    runner: string;
    runTestsByPath: boolean;
    scriptPreprocessor: string;
    setupFiles: string[];
    setupTestFrameworkScriptFile: string;
    setupFilesAfterEnv: string[];
    silent: boolean;
    skipFilter: boolean;
    skipNodeResolution: boolean;
    slowTestThreshold: number;
    snapshotResolver: string;
    snapshotSerializers: string[];
    snapshotFormat: import("@jest/types/build/Config").PrettyFormatOptions;
    errorOnDeprecated: boolean;
    testEnvironment: string;
    testEnvironmentOptions: Record<string, unknown>;
    testFailureExitCode: string | number;
    testLocationInResults: boolean;
    testMatch: string[];
    testNamePattern: string;
    testPathDirs: string[];
    testPathIgnorePatterns: string[];
    testRegex: string | string[];
    testResultsProcessor: string;
    testRunner: string;
    testSequencer: string;
    testURL: string;
    testTimeout: number;
    timers: "real" | "fake" | "modern" | "legacy";
    transform: {
        [regex: string]: string | import("@jest/types/build/Config").TransformerConfig;
    };
    transformIgnorePatterns: string[];
    watchPathIgnorePatterns: string[];
    unmockedModulePathPatterns: string[];
    updateSnapshot: boolean;
    useStderr: boolean;
    verbose?: boolean;
    watch: boolean;
    watchAll: boolean;
    watchman: boolean;
    watchPlugins: (string | [string, Record<string, unknown>])[];
}>;
