import type { Circus } from '@jest/types';
import type { JestEnvironmentGlobal } from '@stencil/core/internal';
export declare function createJestPuppeteerEnvironment(): {
    new (config: any, context: any): {
        [x: string]: any;
        global: JestEnvironmentGlobal;
        browser: any;
        pages: any[];
        testPath: string | null;
        setup(): Promise<void>;
        /**
         * Jest Circus hook for capturing events.
         *
         * We use this lifecycle hook to capture information about the currently running test in the event that it is a
         * Jest-Stencil screenshot test, so that we may accurately report on it.
         *
         * @param event the captured runtime event
         */
        handleTestEvent(event: Circus.AsyncEvent): Promise<void>;
        newPuppeteerPage(): Promise<import("puppeteer").Page>;
        closeOpenPages(): Promise<void>;
        teardown(): Promise<void>;
        getVmContext(): any;
    };
    [x: string]: any;
};
