import type { RouteLocationMatched, Router } from "vue-router";
import type { RouteInfo, ViewItem } from "./types";
export declare const createViewStacks: (router: Router) => {
    unmountLeavingViews: (outletId: number, viewItem: ViewItem, delta?: number) => void;
    mountIntermediaryViews: (outletId: number, viewItem: ViewItem, delta?: number) => void;
    clear: (outletId: number) => void;
    findViewItemByRouteInfo: (routeInfo: RouteInfo, outletId?: number) => ViewItem;
    findLeavingViewItemByRouteInfo: (routeInfo: RouteInfo, outletId?: number, mustBeIonRoute?: boolean) => ViewItem;
    findViewItemByPathname: (pathname: string, outletId?: number) => ViewItem;
    createViewItem: (outletId: number, vueComponent: any, matchedRoute: RouteLocationMatched, routeInfo: RouteInfo, ionPage?: HTMLElement) => ViewItem;
    getChildrenToRender: (outletId: number) => ViewItem[];
    add: (viewItem: ViewItem) => void;
    remove: (viewItem: ViewItem, outletId?: number) => void;
    registerIonPage: (viewItem: ViewItem, ionPage: HTMLElement) => void;
    getViewStack: (outletId: number) => ViewItem[];
    size: () => number;
};
