import type { Mode } from "../../../interface";
import type { ToastAnimationPosition, ToastPosition } from '../toast-interface';
/**
 * Calculate the CSS top and bottom position of the toast, to be used
 * as starting points for the animation keyframes.
 *
 * Note that MD animates bottom-positioned toasts using style.bottom,
 * which calculates from the bottom edge of the screen, while iOS uses
 * translateY, which calculates from the top edge of the screen. This
 * is why the bottom calculates differ slightly between modes.
 *
 * @param position The value of the toast's position prop.
 * @param positionAnchor The element the toast should be anchored to,
 * if applicable.
 * @param mode The toast component's mode (md, ios, etc).
 * @param toast A reference to the toast element itself.
 */
export declare function getAnimationPosition(position: ToastPosition, positionAnchor: HTMLElement | undefined, mode: Mode, toast: HTMLElement): ToastAnimationPosition;
