package app.fluffy.ui.screens

import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material3.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import androidx.work.WorkInfo
import app.fluffy.ui.components.AppTopBar

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun TasksScreen(
    workInfos: List<WorkInfo>,
    onBack: () -> Unit
) {
    Scaffold(
        topBar = {
            AppTopBar(
                title = { Text("Tasks") },
                navigationIcon = { IconButton(onClick = onBack) { Icon(Icons.AutoMirrored.Filled.ArrowBack, contentDescription = null) } }
            )
        }
    ) { pv ->
        LazyColumn(
            modifier = Modifier.fillMaxSize().padding(pv),
            contentPadding = PaddingValues(12.dp),
            verticalArrangement = Arrangement.spacedBy(8.dp)
        ) {
            items(workInfos, key = { it.id.toString() }) { wi ->
                TaskRow(wi)
            }
        }
    }
}

@Composable
private fun TaskRow(wi: WorkInfo) {
    val progress = wi.progress.getFloat("progress", -1f)
    val title = wi.tags.firstOrNull { it != "fluffy" } ?: wi.id.toString()
    val err = wi.outputData.getString("error")
    ElevatedCard(Modifier.fillMaxWidth()) {
        Column(Modifier.padding(12.dp)) {
            Text(title, style = MaterialTheme.typography.bodyLarge)
            Text(
                wi.state.name,
                style = MaterialTheme.typography.labelSmall,
                color = MaterialTheme.colorScheme.onSurfaceVariant
            )
            if (!err.isNullOrBlank()) {
                Spacer(Modifier.height(6.dp))
                Text(
                    err,
                    style = MaterialTheme.typography.bodySmall,
                    color = MaterialTheme.colorScheme.error
                )
            }
            if (progress >= 0f) {
                LinearProgressIndicator(
                    progress = { progress },
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(top = 8.dp)
                )
            } else {
                LinearProgressIndicator(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(top = 8.dp)
                )
            }
        }
    }
}