package app.flicky.data.repository

import app.flicky.R
import io.github.mlmgames.settings.core.annotations.CategoryDefinition
import io.github.mlmgames.settings.core.annotations.NoReset
import io.github.mlmgames.settings.core.annotations.Persisted
import io.github.mlmgames.settings.core.annotations.SchemaVersion
import io.github.mlmgames.settings.core.annotations.Setting
import io.github.mlmgames.settings.core.types.Button
import io.github.mlmgames.settings.core.types.Dropdown
import io.github.mlmgames.settings.core.types.Slider
import io.github.mlmgames.settings.core.types.TextInput
import io.github.mlmgames.settings.core.types.Toggle

@SchemaVersion(1)
data class AppSettings(
    // Appearance
    @Setting(
        title = "Theme Mode",
        description = "Choose between light, dark, or system theme",
        category = Appearance::class,
        type = Dropdown::class,
        options = ["System", "Light", "Dark"]
    )
    val themeMode: Int = 2,

    @Setting(
        title = "Dynamic Theme",
        description = "Use Material You dynamic colors (Android 12+)",
        category = Appearance::class,
        type = Toggle::class
    )
    val dynamicTheme: Boolean = false,

    @Setting(
        title = "Show App Icons",
        description = "Display app icons in lists and grids",
        category = Appearance::class,
        type = Toggle::class
    )
    val showAppIcons: Boolean = true,

    @Setting(
        title = "Use List Layout",
        description = "Show apps in a list instead of grid",
        category = Appearance::class,
        type = Toggle::class
    )
    val useListLayout: Boolean = false,

    // General
    @Setting(
        title = "Default Sort",
        description = "How to sort apps by default",
        category = General::class,
        type = Dropdown::class,
        options = ["Name", "Updated", "Size", "Added"]
    )
    val defaultSort: Int = 1,

    // Downloads
    @Setting(
        title = "Auto Update",
        description = "Automatically update apps in the background",
        category = Downloads::class,
        type = Toggle::class
    )
    val autoUpdate: Boolean = false,

    @Setting(
        title = "Wi-Fi Only",
        description = "Only download and sync over Wi-Fi",
        category = Downloads::class,
        type = Toggle::class
    )
    val wifiOnly: Boolean = true,

    @Setting(
        title = "Sync Interval",
        description = "How often to check for updates",
        category = Downloads::class,
        type = Dropdown::class,
        options = ["3 hours", "6 hours", "12 hours", "Daily", "Weekly", "Never"],
        key = "sync_interval_idx"
    )
    val syncIntervalIndex: Int = 1,

    @Setting(
        title = "Keep Download Cache",
        description = "Keep downloaded APKs after installation",
        category = Downloads::class,
        type = Toggle::class
    )
    val keepCache: Boolean = false,

    @Setting(
        title = "Installer Mode",
        description = "Method to use for installing apps",
        category = Downloads::class,
        type = Dropdown::class,
        options = ["System", "Session", "Root", "Shizuku"]
    )
    val installerMode: Int = 0,

    @Setting(
        title = "Preferred Repository",
        description = "Prefer updates from specific repository",
        category = Downloads::class,
        type = Dropdown::class,
        options = ["Auto", "F-Droid", "IzzyOnDroid"]
    )
    val preferredRepo: Int = 0,

    // Filters
    @Setting(
        title = "Hide Anti-Features",
        description = "Hide apps with anti-features",
        category = Filters::class,
        type = Toggle::class
    )
    val hideAntiFeatures: Boolean = false,

    @Setting(
        title = "Show Incompatible",
        description = "Show apps that are incompatible with your device",
        category = Filters::class,
        type = Toggle::class
    )
    val showIncompatible: Boolean = false,

    // Sync
    @Setting(
        title = "Differential Sync",
        description = "Only fetch changes since last sync",
        category = Sync::class,
        type = Toggle::class
    )
    val differentialSync: Boolean = true,

    @Persisted
    val useEntryJson: Boolean = false,

    @Setting(
        title = "Fail on Trust Errors",
        description = "Strict SSL/TLS verification",
        category = Sync::class,
        type = Toggle::class
    )
    val failOnTrustErrors: Boolean = false,

    // Proxy
    @Setting(
        title = "Use Proxy",
        description = "Route connections through a proxy",
        category = Proxy::class,
        type = Toggle::class
    )
    val useProxy: Boolean = false,

    @Setting(
        title = "Proxy Type",
        description = "Type of proxy to use",
        category = Proxy::class,
        type = Dropdown::class,
        options = ["HTTP", "SOCKS5"],
        dependsOn = "useProxy"
    )
    val proxyType: Int = 0,

    @Setting(
        title = "Proxy Host",
        description = "Proxy server hostname",
        category = Proxy::class,
        type = TextInput::class,
        dependsOn = "useProxy"
    )
    val proxyHost: String = "",

    @Setting(
        title = "Proxy Port",
        description = "Proxy server port",
        category = Proxy::class,
        type = Slider::class,
        min = 1f,
        max = 65535f,
        step = 1f,
        dependsOn = "useProxy"
    )
    val proxyPort: Int = 9050,

    // Other (actions)
    @Setting(
        title = "Clear Cache",
        description = "Clear all cached data and images",
        category = Other::class,
        type = Button::class
    )
    @NoReset
    val clearCache: Long = 0L,

    @Persisted
    val exportSettings: Boolean = false,

    @Setting(
        title = "Show Debug Info",
        description = "Display debug information in the UI",
        category = Other::class,
        type = Toggle::class
    )
    val showDebugInfo: Boolean = false,

    // Non-UI persisted
    @Persisted
    val lastSync: Long = 0L,

    @Persisted(key = "repo_headers_json")
    val repoHeadersJson: String = "{}", // replaces REPO_HEADERS

    @Persisted(key = "last_query")
    val lastQuery: String = "",

    @Persisted
    val importSettings: Boolean = false,
)


@CategoryDefinition(order = 0, titleRes = R.string.category_appearance)
object Appearance

@CategoryDefinition(order = 1, titleRes = R.string.category_general)
object General

@CategoryDefinition(order = 2, titleRes = R.string.category_downloads)
object Downloads

@CategoryDefinition(order = 3, titleRes = R.string.category_filters)
object Filters

@CategoryDefinition(order = 4, titleRes = R.string.category_sync)
object Sync

@CategoryDefinition(order = 5, titleRes = R.string.category_proxy)
object Proxy

@CategoryDefinition(order = 6, titleRes = R.string.category_other)
object Other