import type { DatePickerInputProps } from './DatePickerInput.shared';
import { ReactNode } from 'react';
declare const _default: import("react").ForwardRefExoticComponent<Omit<{
    inputMode: "start" | "end";
    locale: string;
    onChange: (date: Date | undefined) => void;
    value: Date | undefined;
    validRange?: import("./Calendar").ValidRangeType | undefined;
    withModal?: boolean;
    withDateFormatInLabel?: boolean;
    hideValidationErrors?: boolean;
    hasError?: boolean;
    onValidationError?: ((error: string | null) => void) | undefined;
    calendarIcon?: string;
    disableCalendarIcon?: boolean;
    iconSize?: number;
    iconStyle?: import("react").CSSProperties;
    iconColor?: string;
    saveLabel?: string;
    saveLabelDisabled?: boolean;
    uppercase?: boolean;
    startYear?: number;
    endYear?: number;
    onChangeText?: (text: string | undefined) => void;
    inputEnabled?: boolean;
    disableStatusBarPadding?: boolean;
    animationType?: "slide" | "fade" | "none";
    presentationStyle?: "pageSheet" | "overFullScreen";
    startWeekOnMonday?: boolean;
} & Omit<import("react-native").TextInputProps & import("react").RefAttributes<import("react-native").TextInput> & {
    mode?: "flat" | "outlined";
    left?: React.ReactNode;
    right?: React.ReactNode;
    disabled?: boolean;
    label?: import("react-native-paper/lib/typescript/components/TextInput/types").TextInputLabelProp;
    placeholder?: string;
    error?: boolean;
    onChangeText?: Function;
    selectionColor?: string;
    cursorColor?: string;
    underlineColor?: string;
    activeUnderlineColor?: string;
    outlineColor?: string;
    activeOutlineColor?: string;
    textColor?: string;
    dense?: boolean;
    multiline?: boolean;
    numberOfLines?: number;
    onFocus?: (args: any) => void;
    onBlur?: (args: any) => void;
    render?: (props: import("react-native-paper/lib/typescript/components/TextInput/types").RenderProps) => React.ReactNode;
    value?: string;
    style?: import("react-native").StyleProp<import("react-native").TextStyle>;
    theme?: import("react-native-paper/lib/typescript/types").ThemeProp;
    testID?: string;
    contentStyle?: import("react-native").StyleProp<import("react-native").TextStyle>;
    outlineStyle?: import("react-native").StyleProp<import("react-native").ViewStyle>;
    underlineStyle?: import("react-native").StyleProp<import("react-native").ViewStyle>;
} & import("react").RefAttributes<{
    focus: () => void;
    clear: () => void;
    blur: () => void;
    isFocused: () => boolean;
    setNativeProps: (nativeProps: object) => void;
    setSelection: (start: number, end: number) => void;
}>, "inputMode" | "onChange" | "onChangeText" | "value"> & {
    modal?: (params: {
        value: DatePickerInputProps["value"];
        locale: DatePickerInputProps["locale"];
        inputMode: DatePickerInputProps["inputMode"];
        validRange: DatePickerInputProps["validRange"];
        saveLabel: DatePickerInputProps["saveLabel"];
        saveLabelDisabled: DatePickerInputProps["saveLabelDisabled"];
        uppercase: DatePickerInputProps["uppercase"];
        startYear: DatePickerInputProps["startYear"];
        endYear: DatePickerInputProps["endYear"];
        inputEnabled: DatePickerInputProps["inputEnabled"];
        disableStatusBarPadding: DatePickerInputProps["disableStatusBarPadding"];
        startWeekOnMonday?: DatePickerInputProps["startWeekOnMonday"];
    }) => any;
    inputButton?: ReactNode;
}, "ref"> & import("react").RefAttributes<unknown>>;
export default _default;
//# sourceMappingURL=DatePickerInputWithoutModal.d.ts.map