"use strict";

import { FlatList, ScrollView, StyleSheet, View } from 'react-native';
import { Text, TouchableRipple, useTheme } from 'react-native-paper';
import { range } from '../shared/utils';
import { memo, useEffect, useRef } from 'react';
import { sharedStyles } from '../shared/styles';
import { defaultStartYear, defaultEndYear } from './dateUtils';
import { jsx as _jsx } from "react/jsx-runtime";
const ITEM_HEIGHT = 62;
export default function YearPicker({
  selectedYear,
  selectingYear,
  onPressYear,
  startYear,
  endYear
}) {
  const theme = useTheme();
  const flatList = useRef(null);
  const years = range(isNaN(startYear) ? defaultStartYear : startYear, isNaN(endYear) ? defaultEndYear : endYear);

  // scroll to selected year
  useEffect(() => {
    if (flatList.current && selectedYear) {
      const indexToGo = selectedYear - startYear;
      flatList.current.scrollToOffset({
        offset: indexToGo / 3 * ITEM_HEIGHT - ITEM_HEIGHT,
        animated: false
      });
    }
  }, [flatList, selectedYear, startYear]);
  return /*#__PURE__*/_jsx(View, {
    style: [StyleSheet.absoluteFill, styles.root, {
      backgroundColor: theme.colors.surface
    }, selectingYear ? sharedStyles.opacity1 : sharedStyles.opacity0],
    pointerEvents: selectingYear ? 'auto' : 'none',
    children: /*#__PURE__*/_jsx(FlatList, {
      ref: flatList,
      style: sharedStyles.root,
      data: years,
      renderScrollComponent: sProps => {
        return /*#__PURE__*/_jsx(ScrollView, {
          ...sProps
        });
      },
      renderItem: ({
        item
      }) => /*#__PURE__*/_jsx(Year, {
        year: item,
        selected: selectedYear === item,
        onPressYear: onPressYear
      }),
      keyExtractor: item => `${item}`,
      numColumns: 3
    })
  });
}
function YearPure({
  year,
  selected,
  onPressYear
}) {
  const theme = useTheme();
  let textFont = theme?.isV3 ? theme.fonts.bodyLarge : theme.fonts.medium;
  return /*#__PURE__*/_jsx(View, {
    style: styles.year,
    children: /*#__PURE__*/_jsx(TouchableRipple, {
      onPress: () => onPressYear(year),
      accessibilityRole: "button",
      accessibilityLabel: String(year),
      style: styles.yearButton,
      children: /*#__PURE__*/_jsx(View, {
        style: [styles.yearInner, selected ? {
          backgroundColor: theme.colors.primary
        } : null],
        children: /*#__PURE__*/_jsx(Text, {
          maxFontSizeMultiplier: 1.5,
          style: [styles.yearLabel, selected ?
          // eslint-disable-next-line react-native/no-inline-styles
          {
            color: theme.isV3 ? theme.colors.onPrimary : '#fff'
          } : {
            color: theme.isV3 ? theme.colors.onSurfaceVariant : theme.colors.onSurface
          }, {
            ...textFont
          }],
          selectable: false,
          children: year
        })
      })
    })
  });
}
const styles = StyleSheet.create({
  root: {
    flex: 1,
    top: 56,
    zIndex: 100
  },
  year: {
    flex: 1,
    marginLeft: 16,
    marginRight: 16,
    height: ITEM_HEIGHT,
    justifyContent: 'center'
  },
  yearButton: {
    borderRadius: 46 / 2,
    overflow: 'hidden'
  },
  yearInner: {
    borderRadius: 46 / 2,
    height: 46,
    alignItems: 'center',
    justifyContent: 'center'
  },
  yearLabel: {
    fontSize: 16
  }
});
const Year = /*#__PURE__*/memo(YearPure);
//# sourceMappingURL=YearPicker.js.map