"use strict";

import { StyleSheet, View } from 'react-native';
import DayName from './DayName';
import { useTheme } from 'react-native-paper';
import { showWeekDay } from './dateUtils';
import { memo, useMemo } from 'react';
import { jsx as _jsx } from "react/jsx-runtime";
export const dayNamesHeight = 44;
function DayNames({
  disableWeekDays,
  locale,
  startWeekOnMonday
}) {
  const theme = useTheme();
  const shortDayNames = useMemo(() => {
    // TODO: wait for a better Intl api ;-)
    const weekdays = [new Date(2020, 7, 2), new Date(2020, 7, 3), new Date(2020, 7, 4), new Date(2020, 7, 5), new Date(2020, 7, 6), new Date(2020, 7, 7), new Date(2020, 7, 8)];
    if (startWeekOnMonday) {
      weekdays.push(weekdays.shift());
    }
    const formatter = new Intl.DateTimeFormat(locale, {
      weekday: 'narrow'
    });
    return weekdays.map(date => formatter.format(date));
  }, [locale, startWeekOnMonday]);
  return /*#__PURE__*/_jsx(View, {
    style: [styles.dayNames, {
      backgroundColor: theme.colors.surface
    }],
    pointerEvents: "none",
    children: shortDayNames.filter((_, dayIndex) => showWeekDay(dayIndex, disableWeekDays)).map((dayName, i) => /*#__PURE__*/_jsx(DayName, {
      label: dayName
    }, `${dayName}_${i}`))
  });
}
const styles = StyleSheet.create({
  dayNames: {
    alignItems: 'center',
    backgroundColor: '#fff',
    flexDirection: 'row',
    height: dayNamesHeight
  }
});
export default /*#__PURE__*/memo(DayNames);
//# sourceMappingURL=DayNames.js.map