"use strict";

import { Modal, Platform, StyleSheet, TouchableWithoutFeedback, useWindowDimensions, View } from 'react-native';
import { useTheme } from 'react-native-paper';
import DatePickerModalContent from './DatePickerModalContent';
import { memo } from 'react';
import { sharedStyles } from '../shared/styles';
import { supportedOrientations } from '../shared/utils';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
export function DatePickerModal(props) {
  const {
    visible,
    animationType,
    disableStatusBar,
    disableStatusBarPadding,
    inputEnabled,
    presentationStyle,
    statusBarOnTopOfBackdrop,
    ...rest
  } = props;
  const animationTypeCalculated = animationType || Platform.select({
    web: 'none',
    default: 'slide'
  });
  const isPageSheet = presentationStyle === 'pageSheet' && Platform.OS === 'ios';
  const theme = useTheme();
  const dimensions = useWindowDimensions();
  return /*#__PURE__*/_jsx(View, {
    style: StyleSheet.absoluteFill,
    pointerEvents: "box-none",
    children: /*#__PURE__*/_jsxs(Modal, {
      animationType: animationTypeCalculated,
      transparent: !isPageSheet,
      visible: visible,
      onRequestClose: rest.onDismiss,
      presentationStyle: isPageSheet ? 'pageSheet' : 'overFullScreen',
      supportedOrientations: supportedOrientations,
      statusBarTranslucent: true,
      children: [/*#__PURE__*/_jsx(TouchableWithoutFeedback, {
        onPress: rest.onDismiss,
        children: /*#__PURE__*/_jsx(View, {
          style: [StyleSheet.absoluteFill, sharedStyles.root, {
            backgroundColor: theme.colors.backdrop
          }]
        })
      }), /*#__PURE__*/_jsx(View, {
        style: [StyleSheet.absoluteFill, styles.modalRoot],
        pointerEvents: "box-none",
        children: /*#__PURE__*/_jsx(View, {
          style: [styles.modalContent, {
            backgroundColor: theme.colors.surface
          }, dimensions.width > 650 ? styles.modalContentBig : null],
          children: /*#__PURE__*/_jsx(DatePickerModalContent, {
            ...rest,
            inputEnabled: inputEnabled,
            disableSafeTop: disableStatusBarPadding,
            disableStatusBar: disableStatusBar,
            statusBarOnTopOfBackdrop: isPageSheet || statusBarOnTopOfBackdrop,
            withDateFormatInLabel: props.withDateFormatInLabel,
            placeholder: props.placeholder
          })
        })
      })]
    })
  });
}
const styles = StyleSheet.create({
  modalContent: {
    flex: 1,
    width: '100%'
  },
  modalContentBig: {
    maxWidth: 400,
    maxHeight: 600,
    borderRadius: 10,
    width: '100%',
    overflow: 'hidden'
  },
  modalRoot: {
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1
  }
});
export default /*#__PURE__*/memo(DatePickerModal);
//# sourceMappingURL=DatePickerModal.js.map