"use strict";

import { View } from 'react-native';
import Swiper from './Swiper';
import Month from './Month';
import { areDatesOnSameDay, dateToUnix, getEndOfDay, getInitialIndex } from './dateUtils';
import CalendarHeader from './CalendarHeader';
import { memo, useCallback, useMemo, useState } from 'react';
import YearPicker from './YearPicker';
import Color from 'color';
import { useTheme } from 'react-native-paper';
import { darkenBy, lightenBy, useLatest } from '../shared/utils';
import { sharedStyles } from '../shared/styles';
import { defaultStartYear, defaultEndYear } from './dateUtils';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
function Calendar(props) {
  const {
    locale,
    mode,
    onChange,
    startDate,
    endDate,
    date,
    disableWeekDays,
    startYear,
    endYear,
    dates,
    validRange,
    dateMode,
    startWeekOnMonday
  } = props;
  const scrollMode = mode === 'range' || mode === 'multiple' ? 'vertical' : 'horizontal';
  const firstDate = startDate || date || dates?.[0];
  const theme = useTheme();
  const [selectedYear, setSelectedYear] = useState(undefined);
  const [selectingYear, setSelectingYear] = useState(false);

  // prevent re-rendering all months when something changed we only need the
  // latest version of the props and we don't want the useCallback to change
  const startDateRef = useLatest(startDate);
  const endDateRef = useLatest(endDate);
  const onChangeRef = useLatest(onChange);
  const datesRef = useLatest(dates);
  const onPressYear = useCallback(year => {
    setSelectedYear(year);
    setSelectingYear(prev => !prev);
  }, [setSelectingYear]);
  const onPressDate = useCallback(d => {
    if (mode === 'single') {
      ;
      onChangeRef.current({
        date: dateMode === 'start' ? d : getEndOfDay(d)
      });
    } else if (mode === 'range') {
      const sd = startDateRef.current;
      const ed = endDateRef.current;
      let isStart = true;
      if (sd && !ed && dateToUnix(d) >= dateToUnix(sd)) {
        isStart = false;
      }
      ;
      onChangeRef.current({
        startDate: isStart ? d : sd,
        endDate: !isStart ? getEndOfDay(d) : undefined
      });
    } else if (mode === 'multiple') {
      datesRef.current = datesRef.current || [];
      const exists = datesRef.current.some(ed => areDatesOnSameDay(ed, d));
      const newDates = exists ? datesRef.current.filter(ed => !areDatesOnSameDay(ed, d)) : [...datesRef.current, d];
      newDates.sort((a, b) => a.getTime() - b.getTime());
      onChangeRef.current({
        dates: newDates,
        datePressed: d,
        change: exists ? 'removed' : 'added'
      });
    }
  }, [mode, dateMode, onChangeRef, startDateRef, endDateRef, datesRef]);
  const selectColor = useMemo(() => {
    if (theme.isV3) {
      return theme.colors.primaryContainer;
    }
    if (theme.dark) {
      return darkenBy(Color(theme.colors.primary), 0.1).hex();
    }
    return lightenBy(Color(theme.colors.primary), 0.9).hex();
  }, [theme]);
  return /*#__PURE__*/_jsxs(View, {
    style: sharedStyles.root,
    children: [/*#__PURE__*/_jsx(Swiper, {
      initialIndex: getInitialIndex(firstDate, startYear, endYear),
      selectedYear: selectedYear,
      scrollMode: scrollMode,
      startWeekOnMonday: startWeekOnMonday || false,
      startYear: startYear,
      endYear: endYear,
      renderItem: ({
        index
      }) => /*#__PURE__*/_jsx(Month, {
        locale: locale,
        mode: mode,
        validRange: validRange,
        index: index,
        startDate: startDate,
        endDate: endDate,
        date: date,
        dates: dates,
        onPressYear: onPressYear,
        selectingYear: selectingYear,
        onPressDate: onPressDate,
        scrollMode: scrollMode,
        primaryColor: theme.colors.primary,
        selectColor: selectColor,
        roundness: theme.roundness,
        disableWeekDays: disableWeekDays,
        startWeekOnMonday: startWeekOnMonday || false,
        startYear: startYear,
        endYear: endYear
      }, index),
      renderHeader: ({
        onPrev,
        onNext
      }) => /*#__PURE__*/_jsx(CalendarHeader, {
        locale: locale,
        onPrev: onPrev,
        onNext: onNext,
        scrollMode: scrollMode,
        disableWeekDays: disableWeekDays,
        startWeekOnMonday: startWeekOnMonday || false
      })
    }), scrollMode === 'horizontal' ? /*#__PURE__*/_jsx(YearPicker, {
      selectedYear: selectedYear,
      selectingYear: selectingYear,
      onPressYear: onPressYear,
      startYear: startYear || defaultStartYear,
      endYear: endYear || defaultEndYear
    }) : null]
  });
}
export default /*#__PURE__*/memo(Calendar);
//# sourceMappingURL=Calendar.js.map