"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.darkenBy = darkenBy;
exports.lightenBy = lightenBy;
exports.range = range;
exports.supportedOrientations = void 0;
exports.useHeaderBackgroundColor = useHeaderBackgroundColor;
exports.useHeaderColorIsLight = useHeaderColorIsLight;
exports.useHeaderTextColor = useHeaderTextColor;
exports.useLatest = useLatest;
exports.useTextColorOnPrimary = useTextColorOnPrimary;
var _react = require("react");
var _reactNativePaper = require("react-native-paper");
var _color = _interopRequireDefault(require("color"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const supportedOrientations = exports.supportedOrientations = ['portrait', 'portrait-upside-down', 'landscape', 'landscape-left', 'landscape-right'];
function useLatest(value) {
  const ref = (0, _react.useRef)(value);
  ref.current = value;
  return ref;
}
function useHeaderBackgroundColor() {
  const theme = (0, _reactNativePaper.useTheme)();
  if (theme.isV3) {
    return theme.colors.surface;
  }
  return theme.dark && theme.mode === 'adaptive' ? (0, _reactNativePaper.overlay)(4, theme.colors.surface) : theme.colors.primary;
}
function useHeaderColorIsLight() {
  const theme = (0, _reactNativePaper.useTheme)();
  const background = theme.dark && theme.mode === 'adaptive' ? theme.colors.surface : theme.colors.primary;
  return (0, _color.default)(background).isLight();
}
function useHeaderTextColor() {
  const theme = (0, _reactNativePaper.useTheme)();
  const isLight = useHeaderColorIsLight();
  if (theme.isV3) {
    return theme.colors.onSurfaceVariant;
  }
  return !isLight ? '#fff' : '#000';
}
function useTextColorOnPrimary() {
  const theme = (0, _reactNativePaper.useTheme)();
  const isDark = !(0, _color.default)(theme.colors.primary).isLight();
  if (theme.isV3) {
    if (isDark && theme.dark) {
      return theme.colors.onSurface;
    } else {
      return theme.colors.onPrimary;
    }
  }
  return isDark ? '#fff' : '#000';
}
function range(start, end) {
  return Array(end - start + 1).fill(null).map((_, i) => start + i);
}
function lightenBy(color, ratio) {
  const lightness = color.lightness();
  return color.lightness(lightness + (100 - lightness) * ratio);
}
function darkenBy(color, ratio) {
  const lightness = color.lightness();
  return color.lightness(lightness - lightness * ratio);
}
//# sourceMappingURL=utils.js.map