"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimePickerModal = TimePickerModal;
exports.default = void 0;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _TimePicker = _interopRequireDefault(require("./TimePicker"));
var _timeUtils = require("./timeUtils");
var _react = require("react");
var _styles = require("../shared/styles");
var _utils = require("../shared/utils");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function TimePickerModal({
  visible,
  onDismiss,
  onConfirm,
  hours,
  minutes,
  label = 'Select time',
  uppercase: _uppercase,
  cancelLabel = 'Cancel',
  confirmLabel = 'Ok',
  animationType = 'none',
  locale,
  keyboardIcon = 'keyboard-outline',
  clockIcon = 'clock-outline',
  use24HourClock,
  inputFontSize,
  defaultInputType
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const [inputType, setInputType] = (0, _react.useState)(defaultInputType || _timeUtils.inputTypes.picker);
  const [focused, setFocused] = (0, _react.useState)(_timeUtils.clockTypes.hours);
  const [localHours, setLocalHours] = (0, _react.useState)(getHours(hours));
  const [localMinutes, setLocalMinutes] = (0, _react.useState)(getMinutes(minutes));
  (0, _react.useEffect)(() => {
    setLocalHours(getHours(hours));
  }, [setLocalHours, hours]);
  (0, _react.useEffect)(() => {
    setLocalMinutes(getMinutes(minutes));
  }, [setLocalMinutes, minutes]);
  const onFocusInput = (0, _react.useCallback)(type => setFocused(type), []);
  const onChange = (0, _react.useCallback)(params => {
    if (params.focused) {
      setFocused(params.focused);
    }
    setLocalHours(params.hours);
    setLocalMinutes(params.minutes);
  }, [setFocused, setLocalHours, setLocalMinutes]);
  const defaultUppercase = !theme.isV3;
  const uppercase = _uppercase ?? defaultUppercase;
  let textFont;
  let labelText = label;
  if (theme.isV3) {
    textFont = theme.fonts.labelMedium;
  } else {
    textFont = theme?.fonts.medium;
  }
  if (inputType === _timeUtils.inputTypes.keyboard && !label) {
    labelText = 'Enter time';
  }
  let color;
  if (theme.isV3) {
    color = theme.dark ? theme.colors.elevation.level3 : theme.colors.surface;
  } else {
    color = theme.dark ? (0, _reactNativePaper.overlay)(10, theme.colors.surface) : theme.colors.surface;
  }
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Modal, {
    animationType: animationType,
    transparent: true,
    visible: visible,
    onRequestClose: onDismiss,
    presentationStyle: "overFullScreen",
    supportedOrientations: _utils.supportedOrientations,
    statusBarTranslucent: true,
    children: /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.TouchableWithoutFeedback, {
        onPress: onDismiss,
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [_reactNative.StyleSheet.absoluteFill, _styles.sharedStyles.root, {
            backgroundColor: theme.colors?.backdrop
          }]
        })
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [_reactNative.StyleSheet.absoluteFill, styles.center],
        pointerEvents: "box-none",
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.KeyboardAvoidingView, {
          style: styles.center,
          behavior: "padding",
          children: /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.Animated.View, {
            style: [styles.modalContent,
            // eslint-disable-next-line react-native/no-inline-styles
            {
              backgroundColor: color,
              borderRadius: theme.isV3 ? 28 : undefined
            }],
            children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
              style: styles.labelContainer,
              children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Text, {
                maxFontSizeMultiplier: 1.5,
                style: [styles.label, {
                  ...textFont,
                  color: theme?.isV3 ? theme.colors.onSurfaceVariant : theme.colors.text
                }],
                children: uppercase ? labelText.toUpperCase() : labelText
              })
            }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
              style: styles.timePickerContainer,
              children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_TimePicker.default, {
                locale: locale,
                inputType: inputType,
                use24HourClock: use24HourClock,
                inputFontSize: inputFontSize,
                focused: focused,
                hours: localHours,
                minutes: localMinutes,
                onChange: onChange,
                onFocusInput: onFocusInput
              })
            }), /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
              style: styles.bottom,
              children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.IconButton, {
                iconColor: theme?.isV3 ? theme.colors.onBackground : theme.colors.text,
                icon: (0, _timeUtils.getTimeInputTypeIcon)(inputType, {
                  keyboard: keyboardIcon,
                  picker: clockIcon
                }),
                onPress: () => {
                  _reactNative.Keyboard.dismiss();
                  setInputType(_timeUtils.reverseInputTypes[inputType]);
                },
                size: 24,
                style: styles.inputTypeToggle,
                accessibilityLabel: "toggle keyboard"
              }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
                style: _styles.sharedStyles.root
              }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Button, {
                onPress: onDismiss,
                uppercase: uppercase,
                children: cancelLabel
              }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Button, {
                onPress: () => onConfirm({
                  hours: localHours,
                  minutes: localMinutes
                }),
                uppercase: uppercase,
                children: confirmLabel
              })]
            })]
          })
        })
      })]
    })
  });
}
function getMinutes(minutes) {
  return minutes === undefined || minutes === null ? new Date().getMinutes() : minutes;
}
function getHours(hours) {
  return hours === undefined || hours === null ? new Date().getHours() : hours;
}
const styles = _reactNative.StyleSheet.create({
  bottom: {
    flexDirection: 'row',
    alignItems: 'center',
    padding: 8
  },
  center: {
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1
  },
  inputTypeToggle: {
    margin: 4
  },
  labelContainer: {
    justifyContent: 'flex-end',
    paddingLeft: 24,
    paddingRight: 24,
    paddingTop: 16
  },
  label: {
    letterSpacing: 1,
    fontSize: 13
  },
  modalContent: {
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 5
    },
    shadowOpacity: 0.34,
    shadowRadius: 6.27,
    elevation: 3,
    minWidth: 328,
    paddingVertical: 8
  },
  timePickerContainer: {
    paddingLeft: 24,
    paddingTop: 20,
    paddingBottom: 16,
    paddingRight: 24
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(TimePickerModal);
//# sourceMappingURL=TimePickerModal.js.map