"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _timeUtils = require("./timeUtils");
var _TimeInput = _interopRequireDefault(require("./TimeInput"));
var _AmPmSwitcher = _interopRequireDefault(require("./AmPmSwitcher"));
var _utils = require("../shared/utils");
var _color = _interopRequireDefault(require("color"));
var _utils2 = require("../translations/utils");
var _react = require("react");
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function TimeInputs({
  hours,
  minutes,
  onFocusInput,
  focused,
  inputType,
  onChange,
  is24Hour,
  inputFontSize,
  locale
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const startInput = (0, _react.useRef)(null);
  const endInput = (0, _react.useRef)(null);
  const dimensions = (0, _reactNative.useWindowDimensions)();
  const isLandscape = dimensions.width > dimensions.height;
  const minutesRef = (0, _utils.useLatest)(minutes);
  const onSubmitStartInput = (0, _react.useCallback)(() => {
    if (endInput.current) {
      endInput.current.focus();
    }
  }, [endInput]);
  const onSubmitEndInput = (0, _react.useCallback)(() => {
    // TODO: close modal and persist time
  }, []);
  const onChangeHours = (0, _react.useCallback)(newHours => {
    onChange({
      hours: newHours,
      minutes: minutesRef.current,
      focused: _timeUtils.clockTypes.hours
    });
  }, [onChange, minutesRef]);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: [styles.inputContainer, isLandscape && _styles.sharedStyles.root],
    children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      style: styles.column,
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_TimeInput.default, {
        ref: startInput,
        inputFontSize: inputFontSize,
        placeholder: '00',
        value: (0, _timeUtils.toHourInputFormat)(hours, is24Hour),
        clockType: _timeUtils.clockTypes.hours,
        pressed: focused === _timeUtils.clockTypes.hours,
        onPress: onFocusInput,
        inputType: inputType,
        maxFontSizeMultiplier: 1.2,
        selectionColor: theme.dark ? (0, _color.default)(theme.colors.primary).darken(0.2).hex() : theme.colors.primary,
        returnKeyType: 'next',
        onSubmitEditing: onSubmitStartInput,
        blurOnSubmit: false,
        onChanged: newHoursFromInput => {
          let newHours = (0, _timeUtils.toHourOutputFormat)(newHoursFromInput, hours, is24Hour);
          if (newHoursFromInput > 24) {
            newHours = 24;
          }
          onChange({
            hours: newHours,
            minutes
          });
        }
      }), inputType === 'keyboard' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
        maxFontSizeMultiplier: 1.5,
        variant: "bodySmall",
        children: (0, _utils2.getTranslation)(locale, 'hour', 'Hour')
      }) : null]
    }), /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      style: [styles.hoursAndMinutesSeparator,
      // eslint-disable-next-line react-native/no-inline-styles
      {
        marginBottom: inputType === 'keyboard' ? 16 : 0
      }],
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: _styles.sharedStyles.root
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [styles.dot, {
          backgroundColor: theme?.isV3 ? theme.colors.onSurface : theme.colors.text
        }]
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: styles.betweenDot
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [styles.dot, {
          backgroundColor: theme?.isV3 ? theme.colors.onSurface : theme.colors.text
        }]
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: _styles.sharedStyles.root
      })]
    }), /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      style: styles.column,
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_TimeInput.default, {
        ref: endInput,
        inputFontSize: inputFontSize,
        placeholder: '00',
        value: minutes,
        clockType: _timeUtils.clockTypes.minutes,
        pressed: focused === _timeUtils.clockTypes.minutes,
        onPress: onFocusInput,
        inputType: inputType,
        maxFontSizeMultiplier: 1.2,
        selectionColor: theme.dark ? (0, _color.default)(theme.colors.primary).darken(0.2).hex() : theme.colors.primary,
        onSubmitEditing: onSubmitEndInput,
        onChanged: newMinutesFromInput => {
          let newMinutes = newMinutesFromInput;
          if (newMinutesFromInput > 59) {
            newMinutes = 59;
          }
          onChange({
            hours,
            minutes: newMinutes
          });
        }
      }), inputType === 'keyboard' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
        maxFontSizeMultiplier: 1.5,
        variant: "bodySmall",
        children: (0, _utils2.getTranslation)(locale, 'minute', 'Minute')
      }) : null]
    }), !is24Hour && /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: styles.spaceBetweenInputsAndSwitcher
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_AmPmSwitcher.default, {
        hours: hours,
        onChange: onChangeHours,
        inputType: inputType
      })]
    })]
  });
}
const styles = _reactNative.StyleSheet.create({
  betweenDot: {
    height: 12
  },
  column: {
    flexDirection: 'column'
  },
  dot: {
    width: 7,
    height: 7,
    borderRadius: 7 / 2
  },
  hoursAndMinutesSeparator: {
    fontSize: 65,
    width: 24,
    alignItems: 'center'
  },
  inputContainer: {
    flexDirection: 'row',
    alignItems: 'center'
  },
  spaceBetweenInputsAndSwitcher: {
    width: 12
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(TimeInputs);
//# sourceMappingURL=TimeInputs.js.map