"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactNativePaper = require("react-native-paper");
var _jsxRuntime = require("react/jsx-runtime");
const splitCharacters = ['-', '/', '.', '年', ' '];
function detectCharacter(mask) {
  const c = splitCharacters.find(ch => mask.includes(ch));
  return c || '';
}
function escapeForRegExp(value) {
  return value.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
function TextInputWithMask({
  inputButton,
  onChangeText,
  onChange,
  value,
  mask,
  disabled,
  ...rest
}, ref) {
  const [controlledValue, setControlledValue] = (0, _react.useState)(value || '');
  (0, _react.useEffect)(() => {
    setControlledValue(value || '');
  }, [value]);
  const onInnerChange = text => {
    const splitCharacter = detectCharacter(mask);
    const maskParts = mask.split(splitCharacter);
    let trimmedText = text.trim();
    const format = maskParts[0].toLowerCase() + splitCharacter + maskParts[1].toLowerCase() + splitCharacter + maskParts[2].toLowerCase();
    const match = new RegExp(format.replace(/(\w+)\W(\w+)\W(\w+)/, '^\\s*($1)\\W*($2)?\\W*($3)?([0-9]*).*').replace(/m|d|y/g, '\\d'));
    const replaceValue = format.match(/\W/);
    const replace = `$1${splitCharacter}$2${splitCharacter}$3$4`.replace(new RegExp(escapeForRegExp(splitCharacter), 'g'), replaceValue ?? '');
    const isBackSpace = controlledValue.length > trimmedText.length;
    if (!isBackSpace) {
      trimmedText = trimmedText.replace(/(^|\W)(?=\d\W)/g, '$10').replace(match, replace).replace(/(\W)+/g, '$1');
    }
    if (trimmedText.length === mask.length) {
      onChangeText && onChangeText(trimmedText);
    }
    setControlledValue(trimmedText);
  };
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.TextInput, {
    ref: ref,
    ...rest,
    disabled: disabled,
    value: controlledValue,
    onChangeText: onInnerChange,
    onChange: e => {
      onChange && onChange(e);
    },
    maxLength: 10,
    right: inputButton
  });
}
var _default = exports.default = /*#__PURE__*/(0, _react.forwardRef)(TextInputWithMask);
//# sourceMappingURL=TextInputMask.js.map