"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = YearPicker;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _utils = require("../shared/utils");
var _react = require("react");
var _styles = require("../shared/styles");
var _dateUtils = require("./dateUtils");
var _jsxRuntime = require("react/jsx-runtime");
const ITEM_HEIGHT = 62;
function YearPicker({
  selectedYear,
  selectingYear,
  onPressYear,
  startYear,
  endYear
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const flatList = (0, _react.useRef)(null);
  const years = (0, _utils.range)(isNaN(startYear) ? _dateUtils.defaultStartYear : startYear, isNaN(endYear) ? _dateUtils.defaultEndYear : endYear);

  // scroll to selected year
  (0, _react.useEffect)(() => {
    if (flatList.current && selectedYear) {
      const indexToGo = selectedYear - startYear;
      flatList.current.scrollToOffset({
        offset: indexToGo / 3 * ITEM_HEIGHT - ITEM_HEIGHT,
        animated: false
      });
    }
  }, [flatList, selectedYear, startYear]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: [_reactNative.StyleSheet.absoluteFill, styles.root, {
      backgroundColor: theme.colors.surface
    }, selectingYear ? _styles.sharedStyles.opacity1 : _styles.sharedStyles.opacity0],
    pointerEvents: selectingYear ? 'auto' : 'none',
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.FlatList, {
      ref: flatList,
      style: _styles.sharedStyles.root,
      data: years,
      renderScrollComponent: sProps => {
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.ScrollView, {
          ...sProps
        });
      },
      renderItem: ({
        item
      }) => /*#__PURE__*/(0, _jsxRuntime.jsx)(Year, {
        year: item,
        selected: selectedYear === item,
        onPressYear: onPressYear
      }),
      keyExtractor: item => `${item}`,
      numColumns: 3
    })
  });
}
function YearPure({
  year,
  selected,
  onPressYear
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  let textFont = theme?.isV3 ? theme.fonts.bodyLarge : theme.fonts.medium;
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: styles.year,
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.TouchableRipple, {
      onPress: () => onPressYear(year),
      accessibilityRole: "button",
      accessibilityLabel: String(year),
      style: styles.yearButton,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [styles.yearInner, selected ? {
          backgroundColor: theme.colors.primary
        } : null],
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
          maxFontSizeMultiplier: 1.5,
          style: [styles.yearLabel, selected ?
          // eslint-disable-next-line react-native/no-inline-styles
          {
            color: theme.isV3 ? theme.colors.onPrimary : '#fff'
          } : {
            color: theme.isV3 ? theme.colors.onSurfaceVariant : theme.colors.onSurface
          }, {
            ...textFont
          }],
          selectable: false,
          children: year
        })
      })
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  root: {
    flex: 1,
    top: 56,
    zIndex: 100
  },
  year: {
    flex: 1,
    marginLeft: 16,
    marginRight: 16,
    height: ITEM_HEIGHT,
    justifyContent: 'center'
  },
  yearButton: {
    borderRadius: 46 / 2,
    overflow: 'hidden'
  },
  yearInner: {
    borderRadius: 46 / 2,
    height: 46,
    alignItems: 'center',
    justifyContent: 'center'
  },
  yearLabel: {
    fontSize: 16
  }
});
const Year = /*#__PURE__*/(0, _react.memo)(YearPure);
//# sourceMappingURL=YearPicker.js.map