"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.dayNamesHeight = void 0;
var _reactNative = require("react-native");
var _DayName = _interopRequireDefault(require("./DayName"));
var _reactNativePaper = require("react-native-paper");
var _dateUtils = require("./dateUtils");
var _react = require("react");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const dayNamesHeight = exports.dayNamesHeight = 44;
function DayNames({
  disableWeekDays,
  locale,
  startWeekOnMonday
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const shortDayNames = (0, _react.useMemo)(() => {
    // TODO: wait for a better Intl api ;-)
    const weekdays = [new Date(2020, 7, 2), new Date(2020, 7, 3), new Date(2020, 7, 4), new Date(2020, 7, 5), new Date(2020, 7, 6), new Date(2020, 7, 7), new Date(2020, 7, 8)];
    if (startWeekOnMonday) {
      weekdays.push(weekdays.shift());
    }
    const formatter = new Intl.DateTimeFormat(locale, {
      weekday: 'narrow'
    });
    return weekdays.map(date => formatter.format(date));
  }, [locale, startWeekOnMonday]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: [styles.dayNames, {
      backgroundColor: theme.colors.surface
    }],
    pointerEvents: "none",
    children: shortDayNames.filter((_, dayIndex) => (0, _dateUtils.showWeekDay)(dayIndex, disableWeekDays)).map((dayName, i) => /*#__PURE__*/(0, _jsxRuntime.jsx)(_DayName.default, {
      label: dayName
    }, `${dayName}_${i}`))
  });
}
const styles = _reactNative.StyleSheet.create({
  dayNames: {
    alignItems: 'center',
    backgroundColor: '#fff',
    flexDirection: 'row',
    height: dayNamesHeight
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(DayNames);
//# sourceMappingURL=DayNames.js.map