"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DatePickerModalHeader;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _utils = require("../shared/utils");
var _utils2 = require("../translations/utils");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _jsxRuntime = require("react/jsx-runtime");
function DatePickerModalHeader(props) {
  const {
    locale,
    closeIcon = 'close'
  } = props;
  const saveLabel = props.saveLabel || (0, _utils2.getTranslation)(locale, 'save');
  const color = (0, _utils.useHeaderTextColor)();
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const theme = (0, _reactNativePaper.useTheme)();
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_jsxRuntime.Fragment, {
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Animated.View, {
      style: [styles.animated, {
        paddingLeft: insets.left,
        paddingRight: insets.right
      }],
      children: /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNativePaper.Appbar, {
        style: styles.appbarHeader,
        children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Appbar.Action, {
          icon: closeIcon,
          accessibilityLabel: (0, _utils2.getTranslation)(locale, 'close'),
          onPress: props.onDismiss,
          color: color,
          testID: "react-native-paper-dates-close"
        }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Button, {
          textColor: theme.isV3 ? theme.colors.primary : color,
          onPress: props.onSave,
          disabled: props.saveLabelDisabled ?? false,
          uppercase: props.uppercase ?? true,
          contentStyle: styles.buttonStyle,
          mode: "text",
          labelStyle: styles.buttonLabel,
          testID: "react-native-paper-dates-save",
          children: saveLabel
        })]
      })
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  animated: {
    elevation: 4
  },
  appbarHeader: {
    elevation: 0,
    backgroundColor: 'transparent',
    justifyContent: 'space-between'
  },
  buttonStyle: {
    paddingHorizontal: 8
  },
  buttonLabel: {
    flexGrow: 1
  }
});
//# sourceMappingURL=DatePickerModalHeader.js.map