"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerModalContent = DatePickerModalContent;
exports.default = void 0;
var _Calendar = _interopRequireDefault(require("./Calendar"));
var _AnimatedCrossView = _interopRequireDefault(require("./AnimatedCrossView"));
var _DatePickerModalHeader = _interopRequireDefault(require("./DatePickerModalHeader"));
var _DatePickerModalContentHeader = _interopRequireDefault(require("./DatePickerModalContentHeader"));
var _CalendarEdit = _interopRequireDefault(require("./CalendarEdit"));
var _DatePickerModalHeaderBackground = _interopRequireDefault(require("./DatePickerModalHeaderBackground"));
var _reactNativePaper = require("react-native-paper");
var _DatePickerModalStatusBar = _interopRequireDefault(require("./DatePickerModalStatusBar"));
var _react = require("react");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function DatePickerModalContent(props) {
  const {
    mode,
    onChange,
    onConfirm,
    onDismiss,
    disableSafeTop,
    disableStatusBar,
    disableWeekDays,
    locale,
    validRange,
    dateMode,
    startYear,
    endYear,
    statusBarOnTopOfBackdrop,
    startWeekOnMonday
  } = props;
  const theme = (0, _reactNativePaper.useTheme)();
  const anyProps = props;
  const defaultUppercase = !theme.isV3;

  // use local state to add only onConfirm state changes
  const [state, setState] = (0, _react.useState)({
    date: anyProps.date,
    startDate: anyProps.startDate,
    endDate: anyProps.endDate,
    dates: anyProps.dates
  });
  const [collapsed, setCollapsed] = (0, _react.useState)(true);

  // update local state if changed from outside or if modal is opened
  (0, _react.useEffect)(() => {
    setState({
      date: anyProps.date,
      startDate: anyProps.startDate,
      endDate: anyProps.endDate,
      dates: anyProps.dates
    });
  }, [anyProps.date, anyProps.startDate, anyProps.endDate, anyProps.dates]);
  const onInnerChange = (0, _react.useCallback)(params => {
    onChange && onChange(params);
    setState(prev => ({
      ...prev,
      ...params
    }));
  }, [onChange, setState]);
  const onInnerConfirm = (0, _react.useCallback)(() => {
    if (mode === 'single') {
      ;
      onConfirm({
        date: state.date
      });
    } else if (mode === 'range') {
      ;
      onConfirm({
        startDate: state.startDate,
        endDate: state.endDate
      });
    } else if (mode === 'multiple') {
      ;
      onConfirm({
        dates: state.dates || []
      });
    }
  }, [state, mode, onConfirm]);
  const onToggleCollapse = (0, _react.useCallback)(() => {
    setCollapsed(prev => !prev);
  }, [setCollapsed]);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(_DatePickerModalHeaderBackground.default, {
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerModalStatusBar.default, {
        disableSafeTop: !!disableSafeTop,
        disableStatusBar: !!disableStatusBar,
        statusBarOnTopOfBackdrop: !!statusBarOnTopOfBackdrop
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerModalHeader.default, {
        locale: locale,
        onSave: onInnerConfirm,
        onDismiss: onDismiss,
        saveLabel: props.saveLabel,
        saveLabelDisabled: props.saveLabelDisabled ?? false,
        uppercase: props.uppercase ?? defaultUppercase,
        closeIcon: props.closeIcon
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerModalContentHeader.default, {
        state: state,
        mode: mode,
        collapsed: collapsed,
        onToggle: onToggleCollapse,
        headerSeparator: props.headerSeparator,
        emptyLabel: props.emptyLabel,
        label: props.label,
        moreLabel: props.moreLabel,
        startLabel: props.startLabel,
        endLabel: props.endLabel,
        uppercase: props.uppercase ?? defaultUppercase,
        locale: locale,
        editIcon: props?.editIcon,
        calendarIcon: props.calendarIcon,
        allowEditing: props.allowEditing ?? true
      })]
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_AnimatedCrossView.default, {
      collapsed: collapsed,
      calendar: /*#__PURE__*/(0, _jsxRuntime.jsx)(_Calendar.default, {
        locale: locale,
        mode: mode,
        startDate: state.startDate,
        endDate: state.endDate,
        date: state.date,
        onChange: onInnerChange,
        disableWeekDays: disableWeekDays,
        dates: state.dates,
        validRange: validRange,
        dateMode: dateMode,
        startYear: startYear,
        endYear: endYear,
        startWeekOnMonday: startWeekOnMonday
      }),
      calendarEdit: /*#__PURE__*/(0, _jsxRuntime.jsx)(_CalendarEdit.default, {
        mode: mode,
        state: state,
        label: props.label,
        startLabel: props.startLabel,
        endLabel: props.endLabel,
        collapsed: collapsed,
        onChange: onInnerChange,
        validRange: validRange,
        locale: locale,
        inputEnabled: props.inputEnabled,
        withDateFormatInLabel: props.withDateFormatInLabel,
        placeholder: props.placeholder
      })
    })]
  });
}
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(DatePickerModalContent);
//# sourceMappingURL=DatePickerModalContent.js.map