"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _DatePickerInputWithoutModal = _interopRequireDefault(require("./DatePickerInputWithoutModal"));
var _react = require("react");
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function CalendarEdit({
  mode,
  state,
  label = '',
  startLabel = 'Start',
  endLabel = 'End',
  collapsed,
  onChange,
  validRange,
  locale,
  inputEnabled,
  withDateFormatInLabel,
  placeholder
}) {
  const dateInput = (0, _react.useRef)(null);
  const startInput = (0, _react.useRef)(null);
  const endInput = (0, _react.useRef)(null);

  // when switching views focus, or un-focus text input
  (0, _react.useEffect)(() => {
    // hide open keyboard
    if (collapsed) {
      _reactNative.Keyboard.dismiss();
    }
    const inputsToFocus = [dateInput.current, startInput.current].filter(n => n);
    const inputsToBlur = [dateInput.current, startInput.current, endInput.current].filter(n => n);
    if (collapsed) {
      inputsToBlur.forEach(ip => ip.blur());
    } else {
      inputsToFocus.forEach(ip => ip.focus());
    }
  }, [mode, startInput, endInput, dateInput, collapsed]);
  const onSubmitStartInput = (0, _react.useCallback)(() => {
    if (endInput.current) {
      endInput.current.focus();
    }
  }, [endInput]);
  const onSubmitEndInput = (0, _react.useCallback)(() => {
    // TODO: close modal and persist range
  }, []);
  const onSubmitInput = (0, _react.useCallback)(() => {
    // TODO: close modal and persist range
  }, []);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: styles.root,
    children: [mode === 'single' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerInputWithoutModal.default, {
      inputMode: "start",
      ref: dateInput,
      label: label,
      value: state.date,
      onChange: date => onChange({
        ...state,
        date
      }),
      onSubmitEditing: onSubmitInput,
      validRange: validRange,
      locale: locale,
      withModal: false,
      autoComplete: 'off',
      inputEnabled: inputEnabled,
      withDateFormatInLabel: withDateFormatInLabel,
      placeholder: placeholder
    }) : null, mode === 'range' ? /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      style: _styles.sharedStyles.flexDirectionRow,
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerInputWithoutModal.default, {
        inputMode: "start",
        ref: startInput,
        label: startLabel,
        value: state.startDate,
        onChange: startDate => onChange({
          ...state,
          startDate
        }),
        returnKeyType: 'next',
        onSubmitEditing: onSubmitStartInput,
        validRange: validRange,
        locale: locale,
        withModal: false,
        autoComplete: 'off',
        inputEnabled: inputEnabled,
        withDateFormatInLabel: withDateFormatInLabel,
        placeholder: placeholder
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: styles.separator
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerInputWithoutModal.default, {
        inputMode: "end",
        ref: endInput,
        label: endLabel,
        value: state.endDate,
        onChange: endDate => onChange({
          ...state,
          endDate
        }),
        onSubmitEditing: onSubmitEndInput,
        validRange: validRange,
        locale: locale,
        withModal: false,
        autoComplete: "off",
        inputEnabled: inputEnabled,
        withDateFormatInLabel: withDateFormatInLabel,
        placeholder: placeholder
      })]
    }) : null]
  });
}
const styles = _reactNative.StyleSheet.create({
  root: {
    padding: 12
  },
  separator: {
    width: 12
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(CalendarEdit);
//# sourceMappingURL=CalendarEdit.js.map